package br.com.centralit.citcorpore.ajaxForms;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citcorpore.bean.AplicacaoDTO;
import br.com.centralit.citcorpore.bean.AplicacaoServicoDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioAplicacoesDTO;
import br.com.centralit.citcorpore.negocio.AplicacaoService;
import br.com.centralit.citcorpore.negocio.AplicacaoServicoService;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.centralit.citcorpore.util.Enumerados.PagesPortfolio;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.integracao.core.PageRequest;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;

public class GerenciamentoPortfolioAplicacoes extends AjaxFormAction {

	private AplicacaoService aplicacaoService;
	private AplicacaoServicoService servicoAplicacaoService;
	private static Permissoes permissao;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		GerenciamentoPortfolioAplicacoesDTO beanDto = (GerenciamentoPortfolioAplicacoesDTO) document.getBean();

		permissao = new Permissoes(document, request, PagesPortfolio.SERVICO_NEGOCIO_APLICACOES.getCaminho());

		if (beanDto != null && !UtilNumbersAndDecimals.isNull(beanDto.getIdServico())) {
			geraTabelaAplicacoes(beanDto, document, request);
		}
	}

	public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		GerenciamentoPortfolioAplicacoesDTO gerenciamentoDto = (GerenciamentoPortfolioAplicacoesDTO) document.getBean();
		HTMLForm form = document.getForm("formCadastroAplicacao");
		form.setValues(gerenciamentoDto);
	}

	/**
	 * Mtodo chamado no javascript, pegar o DTO do bean e gerar a tabela de
	 * contratos.
	 *
	 * @throws Exception
	 * @author rodrigo.dorighello
	 * @since 16.09.2015
	 */
	public void carregaTabelaAplicacao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioAplicacoesDTO gerenciamentoPortfolioDto = (GerenciamentoPortfolioAplicacoesDTO) document.getBean();

		geraTabelaAplicacoes(gerenciamentoPortfolioDto, document, request);

		document.executeScript("JANELA_AGUARDE_MENU.hide();");

	}

	/**
	 * Mtodo para a gerao da tabela de contratos
	 *
	 * @throws Exception
	 * @author rodrigo.dorighello
	 * @since 15.09.2015
	 */
	private void geraTabelaAplicacoes(GerenciamentoPortfolioAplicacoesDTO gerenciamentoPortfolioDto, DocumentHTML document, HttpServletRequest request) throws Exception {

		String filtro = gerenciamentoPortfolioDto.getFiltroAplicacao();
		if (filtro == null) {
			filtro = "";
		}

		Integer itensPorPagina = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANT_RETORNO_PESQUISA, "10"));

		Integer paginaSelecionadaAplicacao = gerenciamentoPortfolioDto.getPaginaSelecionadaAplicacao();
		if (paginaSelecionadaAplicacao == null || paginaSelecionadaAplicacao == 0) {
			paginaSelecionadaAplicacao = 1;
		}

		Pageable pageable = new PageRequest(paginaSelecionadaAplicacao - 1, itensPorPagina);

		Collection<AplicacaoDTO> colAplicacao = this.getAplicacaoService().listAtivosByIdServicoAndFiltro(gerenciamentoPortfolioDto.getIdServico(), filtro, pageable, false);

		HTMLElement divTabelaPortfolio = document.getElementById("divDinamicoTabelaAplicacao");

		StringBuilder sb = new StringBuilder();


		if(colAplicacao!=null){
		    sb.append(geraHtmlCabecalhoTabela(request));

			for(AplicacaoDTO aplicacaoDto : colAplicacao){
				sb.append(geraHtmlDadosTabela(document, request, aplicacaoDto.getIdAplicacao(), aplicacaoDto.getNome(), aplicacaoDto.getNomeResponsavel()));
			}
			sb.append(geraHTMLFinalTabela());

			divTabelaPortfolio.setInnerHTML(sb.toString());
		} else {
			sb.append("<h4>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nenhumaAplicacaoVinculada") + "</h4>");
			divTabelaPortfolio.setInnerHTML(sb.toString());
		}


		/*
		 * //paginao incompleta Integer totalItensAplicacao = 0;
		 * if(colAplicacao != null) { totalItensAplicacao =
		 * this.getAplicacaoService().listAtivosByIdServicoAndFiltro(
		 * gerenciamentoPortfolioDto.getIdServico(), filtro, pageable,
		 * true).size(); } if (totalItensAplicacao > 0) {
		 * sb.append(geraHtmlCabecalhoTabela(request)); for
		 * (Iterator<AplicacaoDTO> iterator = colAplicacao.iterator();
		 * iterator.hasNext();) { AplicacaoDTO aplicacaoDto = iterator.next(); }
		 * try { HTMLElement paginacaoAplicacoes =
		 * document.getElementById("paginacaoAplicacao"); String
		 * funcaoJsPaginarAplicacoes = "paginarAplicacoes"; Double
		 * numPaginas=1.0; if(totalItensAplicacao > itensPorPagina) numPaginas =
		 * java.lang.Math.ceil( totalItensAplicacao/itensPorPagina );
		 * paginacaoAplicacoes.setInnerHTML(UtilHTML.paginacaoHtml(request,
		 * funcaoJsPaginarAplicacoes, numPaginas.intValue(),
		 * paginaSelecionadaAplicacao)); } catch (Exception e) {
		 * e.printStackTrace(); } } else { sb.append("<h4>" +
		 * UtilI18N.internacionaliza(request,
		 * "gerenciaportfolio.nenhumaAplicacaoVinculada") + "</h4>");
		 * divTabelaPortfolio.setInnerHTML(sb.toString()); }
		 */

		document.executeScript("depoisCarregarTabelaAplicacoes()");
	}

	/**
	 * Gera o html do cabealho da tabela de contratos
	 *
	 * @throws Exception
	 * @author rodrigo.dorighello
	 * @since 15.09.2015
	 */
	private String geraHtmlCabecalhoTabela(HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		sb.append("<div class='row-fluid' id='tabelaAplicacoes'> ");
		sb.append("	<div class=\"table-responsive tabela\">");
		sb.append("		<table class=\"table table-bordered table-striped table-condensed table-vertical-center checkboxs js-table-sortable ui-sortable\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.id") + "</th> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.nome") + "</th> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nomeResponsavel") + "</th> ");
		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.acoes") + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody> ");

		return sb.toString();
	}

	/**
	 * Gera o html dos dados da tabela de contratos
	 *
	 * @author rodrigo.dorighello
	 * @since 15.09.2015
	 */
	private String geraHtmlDadosTabela(DocumentHTML document, HttpServletRequest request, Integer idAplicacao, String nomeAplicacao, String nomeResponsavel) {
		StringBuilder sb = new StringBuilder();

		if(nomeResponsavel==null) {
			nomeResponsavel = "";
		}

		String onMouseOverEditarAplicacao = "onmouseover=\"abreTooltip(this, '"+UtilI18N.internacionaliza(request, "gerenciaportfolio.editarAplicacao")+"')\" onmouseout=\"fechaTooltip()\"";
		String onMouseOverDesvincAplicacao = "onmouseover=\"abreTooltip(this, '"+UtilI18N.internacionaliza(request, "gerenciaportfolio.desvincularAplicacao")+"')\" onmouseout=\"fechaTooltip()\"";

		sb.append("		<tr>");
		sb.append("			<td class=\"center\">" + idAplicacao + "</td> ");
		sb.append("			<td> "+nomeAplicacao+" </td> ");
		sb.append("			<td>" + nomeResponsavel + "</td> ");
		sb.append("			<td class=\"center\" style=\"width: 60px;\"> ");
		if(permissao.isGravar()){
			sb.append("				<a onclick=\"editarAplicacao(" + idAplicacao + ");\" "+onMouseOverEditarAplicacao+" class=\"btn-action glyphicons pencil btn-success\"><i></i></a>");
			sb.append("				<a onclick=\"desvincularAplicacao(" + idAplicacao + ");\" "+onMouseOverDesvincAplicacao+" class=\"btn-action glyphicons remove_2 btn-default\"><i></i></a>");
		}
		sb.append("			</td> ");
		sb.append("		</tr> ");

		return sb.toString();
	}

	/**
	 * Gera o html do final da tabela de contratos
	 *
	 * @author rodrigo.dorighello
	 * @since 15.09.2015
	 */
	private String geraHTMLFinalTabela() {
		StringBuilder sb = new StringBuilder();
		sb.append("			</tbody> ");
		sb.append("		</table>");
		sb.append("	</div>");
		sb.append("</div>");
		sb.append("<div class='row-fluid'> ");
		sb.append("	<div id=\"paginacaoAplicacao\" class=\"divPaginacao\"></div>");
		sb.append("</div>");

		return sb.toString();
	}

	/**
	 * Mtodo vindo do javascript, que faz o vnculo do contrato aps ser
	 * selecionado pela lookup
	 *
	 * @throws Exception
	 * @author douglas.japiassu
	 * @since 11.09.2015
	 */
	public void vincularAplicacaoAoServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		GerenciamentoPortfolioAplicacoesDTO gerenciamentoPortfolioAplicacaoDto = (GerenciamentoPortfolioAplicacoesDTO) document.getBean();
		
		if(permissao.isGravar()){
			if (gerenciamentoPortfolioAplicacaoDto != null && gerenciamentoPortfolioAplicacaoDto.getIdAplicacaoVincular() != null) {
				AplicacaoServicoDTO servicoAplicacaoDTO = new AplicacaoServicoDTO();
	
				servicoAplicacaoDTO.setIdServico(gerenciamentoPortfolioAplicacaoDto.getIdServico());
				servicoAplicacaoDTO.setIdAplicacao(gerenciamentoPortfolioAplicacaoDto.getIdAplicacaoVincular());
	
	
				if (getServicoAplicacaoService().findByIdServicoAndIdAplicacao(servicoAplicacaoDTO.getIdServico(), servicoAplicacaoDTO.getIdAplicacao()) != null) {
					document.executeScript("notificacao('" + UtilI18N.internacionaliza(request, "gerenciaportfolio.aplicacaoJaVinculado") + "', '')");
					return;
				}
				servicoAplicacaoDTO = getServicoAplicacaoService().create(servicoAplicacaoDTO);
				document.executeScript("notificacao('" + UtilI18N.internacionaliza(request, "gerenciaportfolio.aplicacaoVinculadoSucesso") + "', '')");
				gerenciamentoPortfolioAplicacaoDto.setAcaoAplicacoesOcorrenciaServico(AuditoriaAcoes.VINCULADO.getIdentificador());
				gerenciamentoPortfolioAplicacaoDto.setIdsAplicacoesOcorrenciaServico(gerenciamentoPortfolioAplicacaoDto.getIdAplicacaoVincular().toString());
				this.salvarOcorrenciaServicoAplicacao(document, request, response);
			}
	
			carregaTabelaAplicacao(document, request, response);
		}else{
			document.executeScript("notificacaoErro('citcorpore.comum.naoFoiPossivelVincular','citcorpore.comum.usuarioSemPermissao')");
		}
	}

	/**
	 * Mtodo vindo do javascript, que desvincula o contrato aps ser
	 * selecionado na lista
	 *
	 * @throws Exception
	 * @author douglas.japiassu
	 * @since 11.09.2015
	 */
	public void desvincularAplicacaoServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		GerenciamentoPortfolioAplicacoesDTO gerenciamentoPortfolioAplicacaoDto = (GerenciamentoPortfolioAplicacoesDTO) document.getBean();

		if (gerenciamentoPortfolioAplicacaoDto != null && gerenciamentoPortfolioAplicacaoDto.getIdAplicacao() != null) {
			AplicacaoServicoDTO servicoContratoDTO = new AplicacaoServicoDTO();

			servicoContratoDTO.setIdServico(gerenciamentoPortfolioAplicacaoDto.getIdServico());
			servicoContratoDTO.setIdAplicacao(gerenciamentoPortfolioAplicacaoDto.getIdAplicacao());

			servicoContratoDTO = getServicoAplicacaoService().findByIdServicoAndIdAplicacao(servicoContratoDTO.getIdServico(), servicoContratoDTO.getIdAplicacao());

			if (servicoContratoDTO != null) {
				getServicoAplicacaoService().delete(servicoContratoDTO);
				document.executeScript("notificacao('" + UtilI18N.internacionaliza(request, "gerenciaportfolio.aplicacaoDesvinculada") + "', '');");
				gerenciamentoPortfolioAplicacaoDto.setAcaoAplicacoesOcorrenciaServico(AuditoriaAcoes.DESVINCULADO.getIdentificador());
				gerenciamentoPortfolioAplicacaoDto.setIdsAplicacoesOcorrenciaServico(gerenciamentoPortfolioAplicacaoDto.getIdAplicacao().toString());
				this.salvarOcorrenciaServicoAplicacao(document, request, response);
			} else {
				document.executeScript("notificacao('" + UtilI18N.internacionaliza(request, "gerenciaportfolio.idAplicacaoNaoEncontrado") + "', '');");
			}

			carregaTabelaAplicacao(document, request, response);
		}

	}

	private AplicacaoService getAplicacaoService() throws Exception {
		if (aplicacaoService == null) {
			aplicacaoService = (AplicacaoService) ServiceLocator.getInstance().getService(AplicacaoService.class, null);
		}
		return aplicacaoService;
	}

	private AplicacaoServicoService getServicoAplicacaoService() throws Exception {
		if (servicoAplicacaoService == null) {
			servicoAplicacaoService = (AplicacaoServicoService) ServiceLocator.getInstance().getService(AplicacaoServicoService.class, null);
		}
		return servicoAplicacaoService;
	}

	@Override
	public Class<GerenciamentoPortfolioAplicacoesDTO> getBeanClass() {
		return GerenciamentoPortfolioAplicacoesDTO.class;
	}

	/**
	 * @author deborah.ferreira
	 * @since 27.01.2016
	 */
	public void salvarOcorrenciaServicoAplicacao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioAplicacoesDTO gerenciamentoPortfolioAplicacoesDTO = (GerenciamentoPortfolioAplicacoesDTO) document.getBean();
		GerenciamentoPortfolioOcorrenciasServico gerenciamentoPortfolioOcorrenciasServico = new GerenciamentoPortfolioOcorrenciasServico();

		gerenciamentoPortfolioOcorrenciasServico.salvaOcorrenciaServicoAplicacao(gerenciamentoPortfolioAplicacoesDTO.getIdServico(), gerenciamentoPortfolioAplicacoesDTO, document, request);
	}
}
