package br.com.centralit.citcorpore.ajaxForms;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citcorpore.bean.AtributoDemandaServicoDTO;
import br.com.centralit.citcorpore.bean.ServicoNegocioAtributoDemandaDTO;
import br.com.centralit.citcorpore.negocio.AtributoDemandaServicoService;
import br.com.centralit.citcorpore.negocio.OcorrenciaServicoService;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.PagesPortfolio;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;

public class GerenciamentoPortfolioAtributoDemanda extends AjaxFormAction {

	private AtributoDemandaServicoService atributoDemandaServicoService;
	private OcorrenciaServicoService ocorrenciaServicoService;
	private static Permissoes permissao;
	
	@Override
	public Class<ServicoNegocioAtributoDemandaDTO> getBeanClass() {
		return ServicoNegocioAtributoDemandaDTO.class;
	}

	private Integer pageSize = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANT_RETORNO_PESQUISA, "10"));

	@Override
	public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		permissao = new Permissoes(document, request, PagesPortfolio.SERVICO_NEGOCIO_ATRIBUTO_DEMANDA.getCaminho());
		ServicoNegocioAtributoDemandaDTO beanDto = (ServicoNegocioAtributoDemandaDTO) document.getBean();

		if (beanDto != null && !UtilNumbersAndDecimals.isNull(beanDto.getIdServico())) {
			this.restoreIndicadoresCapacidade(beanDto, document, request);
		}

	}

	public void atualizaTelaAtributoDemanda(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception{
		ServicoNegocioAtributoDemandaDTO servicoNegocioAtributoDemandaDTO = (ServicoNegocioAtributoDemandaDTO) document.getBean();
		this.preencheTabela(servicoNegocioAtributoDemandaDTO, document, request);
		document.executeScript("limpaValor()");

	}

	private void restoreIndicadoresCapacidade(ServicoNegocioAtributoDemandaDTO servicoNegocioAtributoDemandaDTO, final DocumentHTML document, final HttpServletRequest request) throws ServiceException, Exception {
		if(servicoNegocioAtributoDemandaDTO != null && servicoNegocioAtributoDemandaDTO.getIdServico() != null){
			this.preencheTabela(servicoNegocioAtributoDemandaDTO, document, request);
		}
	}

	private void preencheTabela(ServicoNegocioAtributoDemandaDTO servicoNegocioAtributoDemandaDTO, final DocumentHTML document, final HttpServletRequest request) throws ServiceException, Exception {
		Integer paginaSelecionada = servicoNegocioAtributoDemandaDTO.getPaginaSelecionadaAtributoDemanda();
		Integer totalPaginas = getAtributoDemandaServicoService().getTotalPaginasAtributoDemanda(pageSize, servicoNegocioAtributoDemandaDTO.getIdServico());
		if(paginaSelecionada != null && totalPaginas != null && paginaSelecionada > totalPaginas){
			paginaSelecionada = totalPaginas;
		}
		if(paginaSelecionada == null || paginaSelecionada <= 0) {
			paginaSelecionada = 1;
		}
		List<AtributoDemandaServicoDTO> listAtributos = this.getAtributoDemandaServicoService().listByIdServico(servicoNegocioAtributoDemandaDTO, paginaSelecionada - 1, pageSize);
		HTMLElement divTabela = document.getElementById("tabelaAtributoDemandaServico");
		document.executeScript("limpaTabelaAtributoDemandaServico()");
		StringBuilder sb = new StringBuilder();
		if(listAtributos != null && !listAtributos.isEmpty()){
			sb.append("		<table class='dynamicTable table table-striped table-bordered'> ");
			sb.append("			<thead> ");
			sb.append("				<tr> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.nome") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.valor") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "planoMelhoria.acoes.titulo") + "</th> ");
			sb.append("				</tr> ");
			sb.append("			</thead> ");
			sb.append("			<tbody> ");

			for (AtributoDemandaServicoDTO atributoDemandaServicoDTO : listAtributos) {
				sb.append("		<tr>");
				sb.append("			<td>"+atributoDemandaServicoDTO.getNome()+"</td>");
				sb.append("			<td>"+atributoDemandaServicoDTO.getValor()+"</td>");
				sb.append("			<td>");
				if (permissao.isGravar()) {
					sb.append("			<button type='button' id='btnExcluirVinculo' class='btn-action glyphicons remove_2 btn-danger btnGravar' onclick='desvincularAtributoDemanda(")
							.append(atributoDemandaServicoDTO.getIdAtributoDemandaServico()).append(")'><i></i></button>");
				}
				sb.append("			</td>");
				sb.append("		</tr>");
			}
			sb.append("			</tbody> ");
			sb.append("		</table> ");
			sb.append("");
			sb.append("<div class='separator'></div>");
			sb.append(UtilHTML.paginacaoHtml(request, "atualizaTelaPaginadaAtributoDemanda", totalPaginas, paginaSelecionada));
			divTabela.appendHTML(sb.toString());
		}else{
			sb.append("<h4>"+ UtilI18N.internacionaliza(request, "gerenciamentoportfolio.atributodemanda.nenhumvinculado"));
			divTabela.appendHTML(sb.toString());
		}
	}
	
	public void desvincularAtributoDemandaServico(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		if (permissao.isGravar()) {
			GerenciamentoPortfolioOcorrenciasServico auditoria = new GerenciamentoPortfolioOcorrenciasServico();
			WebUtil.validarSeUsuarioEstaNaSessao(request, document);
			ServicoNegocioAtributoDemandaDTO servicoNegocioAtributoDemandaDTO = (ServicoNegocioAtributoDemandaDTO) document.getBean();
			AtributoDemandaServicoDTO atributoDemandaServicoDTO = new AtributoDemandaServicoDTO();
			Integer[] registro = new Integer[1];

			if (servicoNegocioAtributoDemandaDTO != null && servicoNegocioAtributoDemandaDTO.getIdAtributoDemandaServico() != null) {
				atributoDemandaServicoDTO.setIdAtributoDemandaServico(servicoNegocioAtributoDemandaDTO.getIdAtributoDemandaServico());
				atributoDemandaServicoDTO = this.getAtributoDemandaServicoService().restore(atributoDemandaServicoDTO);
				registro[0] = atributoDemandaServicoDTO.getIdAtributoDemanda();
				getAtributoDemandaServicoService().delete(atributoDemandaServicoDTO);
				this.getOcorrenciaServicoService().salvaOcorrenciaServicoDemanda(atributoDemandaServicoDTO.getIdServico(), Enumerados.AuditoriaAcoes.DESVINCULADO.getIdentificador(), registro, document, request);
				preencheTabela(servicoNegocioAtributoDemandaDTO, document, request);
			}
		} else {
			document.executeScript("notificacaoErro('citcorpore.comum.permissaoFuncionalidade');");
		}
	}

	private AtributoDemandaServicoService getAtributoDemandaServicoService() throws ServiceException{
		if(atributoDemandaServicoService == null)
			atributoDemandaServicoService = (AtributoDemandaServicoService) ServiceLocator.getInstance().getService(AtributoDemandaServicoService.class, null);
		return atributoDemandaServicoService;
	}

	private OcorrenciaServicoService getOcorrenciaServicoService() throws ServiceException {
		if (ocorrenciaServicoService == null)
			ocorrenciaServicoService = (OcorrenciaServicoService) ServiceLocator.getInstance().getService(OcorrenciaServicoService.class, null);
		return ocorrenciaServicoService;
	}

}
