package br.com.centralit.citcorpore.ajaxForms;

import java.text.DecimalFormat;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.AtributosFinanceirosDTO;
import br.com.centralit.citcorpore.bean.CadastroTipoFinanceiroDTO;
import br.com.centralit.citcorpore.negocio.AtributosFinanceirosService;
import br.com.centralit.citcorpore.negocio.CadastroTipoFinanceiroService;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.centralit.citcorpore.util.Enumerados.ClassificacaoTipoFinanceiro;
import br.com.centralit.citcorpore.util.Enumerados.PagesPortfolio;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;

/**
 * @author joao.morais
 * @since 07/01/2016
 */
public class GerenciamentoPortfolioAtributosFinanceiros extends AjaxFormAction {

	private AtributosFinanceirosService atributosFinanceirosService;
	private CadastroTipoFinanceiroService cadastroTipoFinanceiroService;
	private static Permissoes permissao;

	@Override
	public Class<AtributosFinanceirosDTO> getBeanClass() {
		return AtributosFinanceirosDTO.class;
	}

	private final String PERFIL_RECEITA = Enumerados.PerfilFinanceiro.PERFIL_FINANCEIRO_RECEITA.getValorPerfil();
	private Integer pageSize = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANT_RETORNO_PESQUISA, "10"));


	@Override
	public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		AtributosFinanceirosDTO beanDto = (AtributosFinanceirosDTO) document.getBean();
		setPermissoesAtributosFinanceiros(document, request);

		if (beanDto != null && !UtilNumbersAndDecimals.isNull(beanDto.getIdServico())) {
			this.restoreAtributosFinanceiros(beanDto, document, request);
		}

	}
	
	private void setPermissoesAtributosFinanceiros(DocumentHTML document, HttpServletRequest request) throws Exception {
		permissao = new Permissoes(document, request, PagesPortfolio.SERVICO_NEGOCIO_ATRIBUTOS_FINANCEIROS.getCaminho());
	}

	public void atualizaTelaFinanceiro(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception{
		AtributosFinanceirosDTO atributosFinanceirosDTO = (AtributosFinanceirosDTO) document.getBean();
		this.preencheTabela(atributosFinanceirosDTO, document, request);
		this.montaCombo(document, request);
		this.listaTipos(document, request, response);
		this.limparFormulariosCadastro(document);
		document.executeScript("atualizaClassificacao()");
		document.executeScript("atualizaCategoria()");
		document.executeScript("limpaValor()");

	}

	private void restoreAtributosFinanceiros(AtributosFinanceirosDTO atributosFinanceirosDTO, final DocumentHTML document, final HttpServletRequest request) throws ServiceException, Exception {
		if(atributosFinanceirosDTO != null && atributosFinanceirosDTO.getIdServico() != null){
			HTMLForm form = document.getForm("formAtributosFinanceiro");
			form.setValues(atributosFinanceirosDTO);
			this.montaCombo(document, request);
			iniciaComboTipo("C", document, request);
			this.preencheTabela(atributosFinanceirosDTO, document, request);
		}

	}

	private AtributosFinanceirosService getAtributosFinanceirosService() throws ServiceException {
		if (atributosFinanceirosService == null) {
			atributosFinanceirosService = (AtributosFinanceirosService) ServiceLocator.getInstance().getService(AtributosFinanceirosService.class, null);
		}
		return atributosFinanceirosService;
	}

	/**
	 * @author joao.morais
	 * @since 11/01/2016
	 */
	public void save(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		AtributosFinanceirosDTO atributosFinanceirosDTO = (AtributosFinanceirosDTO) document.getBean();
		setPermissoesAtributosFinanceiros(document, request);
		
		if(permissao.isGravar()) {
			if(atributosFinanceirosDTO.getPerfil() != null && atributosFinanceirosDTO.getPerfil().equalsIgnoreCase(PERFIL_RECEITA)
					|| atributosFinanceirosDTO.getIdClassificacao() == -1){
				atributosFinanceirosDTO.setIdClassificacao(null);
			}
	
			if (atributosFinanceirosDTO.getIdFinanceiroServico() != null && atributosFinanceirosDTO.getIdFinanceiroServico().intValue() > 0) {
				this.getAtributosFinanceirosService().update(atributosFinanceirosDTO);
				document.alert(UtilI18N.internacionaliza(request, "MSG06"));
				atributosFinanceirosDTO.setAcaoAtributosFinanceirosOcorrenciaServico(AuditoriaAcoes.ALTERADO.getIdentificador());
			} else {
				atributosFinanceirosDTO = this.getAtributosFinanceirosService().create(atributosFinanceirosDTO);
				if (atributosFinanceirosDTO != null) {
					document.alert(UtilI18N.internacionaliza(request, "MSG05"));
					atributosFinanceirosDTO.setAcaoAtributosFinanceirosOcorrenciaServico(AuditoriaAcoes.VINCULADO.getIdentificador());
				}
			}
	
			if (atributosFinanceirosDTO != null) {
				this.preencheTabela(atributosFinanceirosDTO, document, request);
	
				if (atributosFinanceirosDTO.getIdFinanceiroServico() != null) {
					atributosFinanceirosDTO.setIdsAtributosFinanceirosOcorrenciaServico(atributosFinanceirosDTO.getIdFinanceiroServico().toString());
					this.salvarOcorrenciaServicoAtributosFinanceiros(document, request, response);
				}
			}
	
			this.montaCombo(document, request);
			this.listaTipos(document, request, response);
			this.limparFormulariosCadastro(document);
	
			document.executeScript("escondeEditar()");
		} else {
			document.executeScript("notificacaoErro('citcorpore.comum.permissaoFuncionalidade');");
		}
	}

	public void excluir(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		setPermissoesAtributosFinanceiros(document, request);
		final AtributosFinanceirosDTO atributosFinanceirosDTO = (AtributosFinanceirosDTO) document.getBean();
		
		if(permissao.isDeletar()) {
			atributosFinanceirosDTO.setIdTipo(atributosFinanceirosDTO.getIdTipoSelect());
			if (atributosFinanceirosDTO != null && atributosFinanceirosDTO.getIdFinanceiroServico() != null && atributosFinanceirosDTO.getIdFinanceiroServico().intValue() > 0) {
				this.getAtributosFinanceirosService().deleteLogico(atributosFinanceirosDTO);
	
				document.executeScript("JANELA_AGUARDE_MENU.hide();");
	
				this.preencheTabela(atributosFinanceirosDTO, document, request);
				this.montaCombo(document, request);
				this.listaTipos(document, request, response);
	
				document.alert(UtilI18N.internacionaliza(request, "MSG07"));
				atributosFinanceirosDTO.setAcaoAtributosFinanceirosOcorrenciaServico(AuditoriaAcoes.DESVINCULADO.getIdentificador());
				this.salvarOcorrenciaServicoAtributosFinanceiros(document, request, response);
			}else{
				document.executeScript("JANELA_AGUARDE_MENU.hide();");
				document.alert(UtilI18N.internacionaliza(request, "gerenciaportfolio.atributosFinanceiros.falhaExcluir"));
			}
		} else {
			document.executeScript("notificacaoErro('citcorpore.comum.permissaoFuncionalidade');");
		}

	}

	/**
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	private void salvarOcorrenciaServicoAtributosFinanceiros(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		AtributosFinanceirosDTO atributosFinanceirosDTO = (AtributosFinanceirosDTO) document.getBean();
		GerenciamentoPortfolioOcorrenciasServico gerenciamentoPortfolioOcorrenciasServico = new GerenciamentoPortfolioOcorrenciasServico();
		gerenciamentoPortfolioOcorrenciasServico.salvaOcorrenciaServicoAtributosFinanceiros(atributosFinanceirosDTO.getIdServico(),
				atributosFinanceirosDTO.getIdsAtributosFinanceirosOcorrenciaServico(), atributosFinanceirosDTO, document, request);
	}

	private void limparFormulariosCadastro(final DocumentHTML document) throws Exception {
		document.executeScript("limpaValor()");
	}

	/**
	 * Clique no "See Also" para descrio do mtodo
	 *
	 * @see br.com.centralit.citcorpore.ajaxForms.GerenciamentoServicos#paginacaoGerenciamento(Integer,
	 *      StringBuilder, Integer, HttpServletRequest)
	 */
	private void preencheTabela(AtributosFinanceirosDTO atributosFinanceirosDTO, final DocumentHTML document, final HttpServletRequest request) throws ServiceException, Exception {
		Integer paginaSelecionada = atributosFinanceirosDTO.getPaginaSelecionada();
		if(paginaSelecionada == null) {
			paginaSelecionada = 1;
		}
		Collection<AtributosFinanceirosDTO> listaFinanceiroServico = this.getAtributosFinanceirosService().findFinanceiroByIdServico(atributosFinanceirosDTO.getIdServico(), paginaSelecionada - 1, pageSize);
		HTMLElement divTabela = document.getElementById("tabelaFinanceiro");
		document.executeScript("limpaTabela()");
		StringBuilder sb = new StringBuilder();
		if(listaFinanceiroServico != null && !listaFinanceiroServico.isEmpty()){
			sb.append("		<table class='dynamicTable table table-striped table-bordered'> ");
			sb.append("			<thead> ");
			sb.append("				<tr> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.atributosFinanceiros.categoria") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.atributosFinanceiros.tipo") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.classificacao") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.atributosFinanceiros.valor") + "</th> ");
			sb.append("					<th style='width:77px'>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.atributosFinanceiros.editar") + "</th> ");
			sb.append("				</tr> ");
			sb.append("			</thead> ");
			sb.append("			<tbody> ");
			sb.append("			</tbody> ");

			//codigo ascii para aspas simples &#39;
			for (AtributosFinanceirosDTO tabelaDTO : listaFinanceiroServico) {
				sb.append("<tr>");
				sb.append("		<td>"+tabelaDTO.getNomeTipo()+"</td>");
				sb.append("		<td>"+ UtilI18N.internacionaliza(request, checaPerfil(tabelaDTO.getPerfil())) +"</td>");
				sb.append("		<td>").append(UtilI18N.internacionaliza(request,getNomeClassificacaoById(tabelaDTO.getIdClassificacao()))).append("</td>");
				DecimalFormat decimal = new DecimalFormat("0.00");
				sb.append("		<td>"+decimal.format(tabelaDTO.getValor())+"</td>");
				if(permissao.isGravar()){
					sb.append("		<td><button type='button' id='btnNovoFinanceiro' class='btn-action glyphicons pencil btn-success btnGravar' onclick='editarAtributofinanceiro(&#39;"
						+ tabelaDTO.getIdFinanceiroServico() + "&#39; , &#39;"
						+ tabelaDTO.getIdTipo() + "&#39; , &#39;"
						+ tabelaDTO.getPerfil() + "&#39; , &#39;"
						+ decimal.format(tabelaDTO.getValor()) + "&#39; , &#39;"
						+ (tabelaDTO.getIdClassificacao() != null ? tabelaDTO.getIdClassificacao() : "-1") +"&#39;);'><i></i></button>");
				}else{
					sb.append("<td>");
				}if(permissao.isDeletar()){
					sb.append("<button style='margin-left:5px;' type='button' id='btnNovoFinanceiro' class='btn-action glyphicons remove_2 btn-default btnExcluir' onclick='excluirAtributofinanceiro(&#39;"
							+ tabelaDTO.getIdFinanceiroServico() + "&#39; , &#39;"
							+ tabelaDTO.getIdTipo() + "&#39; , &#39;"
							+ tabelaDTO.getPerfil() + "&#39; , &#39;"
							+ decimal.format(tabelaDTO.getValor()) + "&#39; , &#39;"
							+ tabelaDTO.getIdClassificacao() +"&#39;);'><i></i></button></td>");
				}else{
					sb.append("</td>");
				}
				sb.append("</tr>");
			}
			sb.append("			</table> ");
			sb.append("");
			Integer totalPaginas = getAtributosFinanceirosService().getTotalPaginasAtributosFinanceiros(pageSize, atributosFinanceirosDTO.getIdServico());

			sb.append("<div class='separator'></div>");
			sb.append(UtilHTML.paginacaoHtml(request, "atualizaTelaPaginada", totalPaginas, paginaSelecionada));
			divTabela.appendHTML(sb.toString());
		}else{
			sb.append("<h4>"+ UtilI18N.internacionaliza(request, "gerenciaportfolio.atributosFinanceiros.nenhumaOcorrenciaServicoEncontrada"));
			divTabela.appendHTML(sb.toString());
		}
	}

	public String checaPerfil(String perfil){
		if(perfil.equals(Enumerados.PerfilFinanceiro.PERFIL_FINANCEIRO_CUSTO.getValorPerfil())){
			return Enumerados.PerfilFinanceiro.PERFIL_FINANCEIRO_CUSTO.getNomePerfil();
		}else if(perfil.equals(Enumerados.PerfilFinanceiro.PERFIL_FINANCEIRO_RECEITA.getValorPerfil())){
			return Enumerados.PerfilFinanceiro.PERFIL_FINANCEIRO_RECEITA.getNomePerfil();
		}

		return null;
	}

	public void montaCombo(DocumentHTML document, HttpServletRequest request) throws Exception{
		HTMLSelect comboPerfil = document.getSelectById("perfilFinanceiro");
		inicializaCombo(comboPerfil, request);
		for (Enumerados.PerfilFinanceiro perfil : Enumerados.PerfilFinanceiro.values()) {
			comboPerfil.addOption(perfil.getValorPerfil(), UtilI18N.internacionaliza(request, perfil.getNomePerfil()));
		}
		carregarComboClassificacao(document, request);
	}

	private void inicializaCombo(HTMLSelect componenteCombo, HttpServletRequest request) {
		componenteCombo.removeAllOptions();
	}

	public void listaTipos(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception{
		AtributosFinanceirosDTO atributosFinanceirosDTO = (AtributosFinanceirosDTO) document.getBean();
		String perfil = atributosFinanceirosDTO.getPerfil();

		Collection<AtributosFinanceirosDTO> listaFinanceiroServico = this.getAtributosFinanceirosService().findlistaTiposPorPerfil(perfil);
		if(listaFinanceiroServico != null && !listaFinanceiroServico.isEmpty()){
			HTMLSelect comboTipo = document.getSelectById("idTipo");
			inicializaCombo(comboTipo, request);
			comboTipo.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
			for(AtributosFinanceirosDTO result : listaFinanceiroServico){
				comboTipo.addOption(String.valueOf(result.getIdTipo()),result.getNomeTipo());
			}
		}else{
			HTMLSelect comboTipo = document.getSelectById("idTipo");
			inicializaCombo(comboTipo, request);
			comboTipo.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
		}
	}

	public void iniciaComboTipo(String perfil, final DocumentHTML document, final HttpServletRequest request) throws ServiceException, Exception{
		Collection<AtributosFinanceirosDTO> listaFinanceiroServico = this.getAtributosFinanceirosService().findlistaTiposPorPerfil(perfil);
		if(listaFinanceiroServico != null && !listaFinanceiroServico.isEmpty()){
			HTMLSelect comboTipo = document.getSelectById("idTipo");
			inicializaCombo(comboTipo, request);
			for(AtributosFinanceirosDTO result : listaFinanceiroServico){
				comboTipo.addOption(String.valueOf(result.getIdTipo()),result.getNomeTipo());
			}
		}
	}

	public void iniciaComboTipoEditar(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception{
		AtributosFinanceirosDTO financeiroServico = (AtributosFinanceirosDTO) document.getBean();
		Collection<AtributosFinanceirosDTO> listaFinanceiroServico = this.getAtributosFinanceirosService().findlistaTiposPorPerfil(financeiroServico.getPerfil());

		HTMLSelect comboTipo = document.getSelectById("idTipo");
		inicializaCombo(comboTipo, request);
		int cont = 0;
		int indice = 0;

		if (listaFinanceiroServico != null && !listaFinanceiroServico.isEmpty()) {
			for(AtributosFinanceirosDTO result : listaFinanceiroServico){
				if(result.getIdTipo().intValue() == financeiroServico.getIdTipoSelect().intValue()){
					indice = cont;
				}
				comboTipo.addOption(String.valueOf(result.getIdTipo()),result.getNomeTipo());
				cont ++;
			}
		}

		comboTipo.setSelectedIndex(indice);
	}

	public void atualizaComboTipoEditar(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception{
		AtributosFinanceirosDTO atributosFinanceirosDTO = (AtributosFinanceirosDTO) document.getBean();
		Collection<AtributosFinanceirosDTO> listaFinanceiroServico = this.getAtributosFinanceirosService().findlistaTiposPorPerfil(atributosFinanceirosDTO.getPerfil());
		if(listaFinanceiroServico != null && !listaFinanceiroServico.isEmpty()){
			HTMLSelect comboTipo = document.getSelectById("idTipo");
			inicializaCombo(comboTipo, request);
			comboTipo.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
			for(AtributosFinanceirosDTO result : listaFinanceiroServico){
				comboTipo.addOption(String.valueOf(result.getIdTipo()),result.getNomeTipo());
			}
			preencheTabela(atributosFinanceirosDTO, document, request);
		}else{
			HTMLSelect comboTipo = document.getSelectById("idTipo");
			inicializaCombo(comboTipo, request);
			comboTipo.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
		}
	}

	public void carregarComboClassificacao(final DocumentHTML document, final HttpServletRequest request) throws Exception{
		HTMLSelect classificacaoSelect = document.getSelectById("idClassificacao");
		classificacaoSelect.removeAllOptions();
		classificacaoSelect.addOption("-1", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
		for(Enumerados.ClassificacaoTipoFinanceiro classificacaoTipoFinanceiro : Enumerados.ClassificacaoTipoFinanceiro.values()){
			classificacaoSelect.addOption(
					classificacaoTipoFinanceiro.getIdClassificacaoTipoFinanceiro().toString(),
					UtilI18N.internacionaliza(request, classificacaoTipoFinanceiro.getNomeClassificacaoTipoFinanceiro()));
		}
	}

	public void selecionaClassificacaoPadrao(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception{
		AtributosFinanceirosDTO atributosFinanceirosDTO = (AtributosFinanceirosDTO) document.getBean();
		if(atributosFinanceirosDTO.getPerfil().equalsIgnoreCase(PERFIL_RECEITA)) {
			return;
		}
		CadastroTipoFinanceiroDTO cadastroTipoFinanceiroDTO = new CadastroTipoFinanceiroDTO();
		cadastroTipoFinanceiroDTO.setIdTipo(atributosFinanceirosDTO.getIdTipo());
		cadastroTipoFinanceiroDTO = (CadastroTipoFinanceiroDTO) getCadastroTipoFinanceiroService().restore(cadastroTipoFinanceiroDTO);
		if (cadastroTipoFinanceiroDTO != null && cadastroTipoFinanceiroDTO.getClassificacaoTipo() != null) {
			document.executeScript("selecionaClassificacao('".concat(cadastroTipoFinanceiroDTO.getClassificacaoTipo().toString()).concat("')"));
		}
	}

	private CadastroTipoFinanceiroService getCadastroTipoFinanceiroService() throws ServiceException {
		if(cadastroTipoFinanceiroService == null) {
			cadastroTipoFinanceiroService = (CadastroTipoFinanceiroService) ServiceLocator.getInstance().getService(CadastroTipoFinanceiroService.class, null);
		}
		return cadastroTipoFinanceiroService;
	}

	private String getNomeClassificacaoById(Integer idClassificacao){
		if(idClassificacao == null){
			return "--";
		}
		switch(idClassificacao){
			case 1:
				return ClassificacaoTipoFinanceiro.CAPEXOPEX.getNomeClassificacaoTipoFinanceiro();
			case 2:
				return ClassificacaoTipoFinanceiro.DIRETOINDIRETO.getNomeClassificacaoTipoFinanceiro();
			case 3:
				return ClassificacaoTipoFinanceiro.FIXOVARIAVEL.getNomeClassificacaoTipoFinanceiro();
			case 4:
				return ClassificacaoTipoFinanceiro.CUSTOUNITARIO.getNomeClassificacaoTipoFinanceiro();
			default:
				return "--";
		}
	}
}
