package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioBusinessUserDTO;
import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.negocio.GerenciamentoPortfolioBusinessUserService;
import br.com.centralit.citcorpore.negocio.GrupoService;
import br.com.centralit.citcorpore.negocio.UsuarioService;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.centralit.citcorpore.util.Enumerados.BusinessUserTipo;
import br.com.centralit.citcorpore.util.Enumerados.PagesPortfolio;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;

public class GerenciamentoPortfolioBusinessUser extends AjaxFormAction {

	private GerenciamentoPortfolioBusinessUserService businessUserService;
	private UsuarioService usuarioService;
	private GrupoService grupoService;
	private static Permissoes permissao;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		GerenciamentoPortfolioBusinessUserDTO beanDto = (GerenciamentoPortfolioBusinessUserDTO) document.getBean();
		permissao = new Permissoes(document, request, PagesPortfolio.SERVICO_NEGOCIO_USUARIO_NEGOCIO.getCaminho());

		if (beanDto != null && !UtilNumbersAndDecimals.isNull(beanDto.getIdServicoAtual())) {
			this.restore(beanDto, document, request);
		}
	}

	@Override
	public Class<GerenciamentoPortfolioBusinessUserDTO> getBeanClass() {
		return GerenciamentoPortfolioBusinessUserDTO.class;
	}

	public void salvarItensChecados(DocumentHTML document, HttpServletRequest request, String checkboxChecadosComoTrue, Integer idServico, int tipo) throws Exception {
		List<GerenciamentoPortfolioBusinessUserDTO> listaDto = new ArrayList<>();
		List<String> listaIdsVinculados = new ArrayList<String>();
		if(permissao.isGravar()){

			for (String id : checkboxChecadosComoTrue.split(";")) {
				if (!isNullOrEmpty(id)) {
					GerenciamentoPortfolioBusinessUserDTO dto = new GerenciamentoPortfolioBusinessUserDTO();
					dto.setIdGrupoUsuario(BusinessUserTipo.GRUPO_USUARIO.getIdentificador() == tipo ? Integer.valueOf(id) : null);
					dto.setIdUsuario(BusinessUserTipo.USUARIO.getIdentificador() == tipo ? Integer.valueOf(id) : null);
					dto.setIdServicoAtual(idServico);
					dto.setTipo(tipo);
	
					listaDto.add(dto);
					listaIdsVinculados.add(id);
				}
			}
	
			if (persistirItensChecados(document, request, listaDto, idServico)) {
				GerenciamentoPortfolioBusinessUserDTO businessUserDto = new GerenciamentoPortfolioBusinessUserDTO();
				businessUserDto.setIdServicoAtual(idServico);
				restore(businessUserDto, document, request);
				document.executeScript("salvarVincularOcorrenciaServicoUsuarioNegocio('" + listaIdsVinculados.toString() + "', '" + tipo + "');");
			}
		} else {
			document.executeScript("fecharPopupGrupo();");
			document.executeScript("fecharPopupUsuario();");
			document.executeScript("notificacaoErro('citcorpore.comum.naoFoiPossivelVincular','citcorpore.comum.usuarioSemPermissao')");
		}
	}

	private boolean persistirItensChecados(DocumentHTML document, HttpServletRequest request, List<GerenciamentoPortfolioBusinessUserDTO> listaDto, Integer idServico) throws Exception {
		try {
			getBusinessUserService().create(listaDto);
			document.executeScript("fecharPopupGrupo();");
			document.executeScript("fecharPopupUsuario();");
			document.executeScript("notificacaoI18N('gerenciaportfolio.businessUser.Vinculado');");
			return true;
		} catch (ServiceException | LogicException e) {
			e.printStackTrace();
			StringBuilder sb = new StringBuilder();
			sb.append("dispararErro(");
			sb.append(UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "citcorpore.comum.erroGravacao")));
			sb.append(");");
			document.executeScript(sb.toString());
			return false;
		}
	}

	private void restore(GerenciamentoPortfolioBusinessUserDTO businessUserDto, DocumentHTML document, HttpServletRequest request) throws Exception {
		if (!isNullOrEmpty(businessUserDto.getIdServicoAtual())) {
			List<GerenciamentoPortfolioBusinessUserDTO> salvosNoBanco = (List<GerenciamentoPortfolioBusinessUserDTO>) getBusinessUserService().listByServico(businessUserDto.getIdServicoAtual());
			refreshUI(document, request, salvosNoBanco);
		}
	}

	private void refreshUI(DocumentHTML document, HttpServletRequest request, List<GerenciamentoPortfolioBusinessUserDTO> listaDto) throws Exception {
		HTMLElement divDinamico = document.getElementById("divDinamicoListaServicosBusinessUser");
		String listaVazia = "<h4>" + UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "gerenciaportfolio.nenhumGrupoOuUsuarioVinculado")) + "</h4>";
		divDinamico.setInnerHTML(!isNullOrEmpty(listaDto) && listaDto.size() > 0 ? gerarHTML(document, request, listaDto) : listaVazia);
		atualizarListaDeItensSelecionadosNoJavaScript(document, listaDto);
	}

	private String gerarHTML(DocumentHTML document, HttpServletRequest request, List<GerenciamentoPortfolioBusinessUserDTO> listaDto) throws LogicException, ServiceException {
		StringBuilder sb = new StringBuilder();
		adicionarCabecalhoTabela(sb, request);
		adicionarDadosTabela(sb, request, document, listaDto);
		adicionarFimTabela(sb);
		return sb.toString();
	}

	private void adicionarCabecalhoTabela(StringBuilder sb, HttpServletRequest request) {
		sb.append("<div class='row-fluid' id='divTabela'> ");
		sb.append("	<div class=\"table-responsive tabela\">");
		sb.append("		<table class=\"table table-bordered table-striped table-condensed table-vertical-center checkboxs js-table-sortable ui-sortable\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th>" + UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "ID")) + "</th> ");
		sb.append("					<th>" + UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "citcorpore.comum.nome")) + "</th> ");
		sb.append("					<th>" + UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "citcorpore.comum.descricao")) + "</th> ");
		sb.append("					<th>" + UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "baseConhecimentoView.acoes")) + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
	}

	private void adicionarDadosTabela(StringBuilder sb, HttpServletRequest request, DocumentHTML document, List<GerenciamentoPortfolioBusinessUserDTO> listaDto) throws LogicException, ServiceException {

		if (!isNullOrEmpty(listaDto)) {

			UsuarioDTO usuario = null;
			GrupoDTO grupo = null;
			boolean isGrupoUsuario = false;

			for (GerenciamentoPortfolioBusinessUserDTO dto : listaDto) {
				if (!isNullOrEmpty(dto)) {
					if (BusinessUserTipo.GRUPO_USUARIO.getIdentificador().equals(dto.getTipo())) {
						isGrupoUsuario = true;
					} else {
						isGrupoUsuario = false;
					}

					if (!isGrupoUsuario && !isNullOrEmpty(dto.getIdUsuario())) {
						usuario = new UsuarioDTO();
						usuario.setIdUsuario(dto.getIdUsuario());
						usuario = (UsuarioDTO) getUsuarioService().restore(usuario);
					} else if (isGrupoUsuario && !isNullOrEmpty(dto.getIdGrupoUsuario())) {
						grupo = new GrupoDTO();
						grupo.setIdGrupo(dto.getIdGrupoUsuario());
						grupo = (GrupoDTO) getGrupoService().restore(grupo);
					}

					sb.append("<tbody>");
					sb.append("	<tr>");
					sb.append("		<td>");
					sb.append(isGrupoUsuario ? dto.getIdGrupoUsuario() : dto.getIdUsuario());
					sb.append("		</td>");
					sb.append("		<td>");
					sb.append(isGrupoUsuario ? grupo.getNome() : usuario.getNomeUsuario());
					sb.append("		</td>");
					sb.append("		<td>");
					sb.append(UtilI18N.internacionaliza(request, isGrupoUsuario ? BusinessUserTipo.GRUPO_USUARIO.getChave() : BusinessUserTipo.USUARIO.getChave()));
					sb.append("		</td>");
					sb.append("     <td class=\"center\" > ");
					if (permissao.isGravar()) {
						sb.append("         <a class=\"btn-action glyphicons remove_2 btn-default\" key=\"");
						sb.append(UtilI18N.internacionaliza(request, "citcorpore.comum.descvincular"));
						sb.append("\"");
						sb.append(" onclick=\"");
						sb.append("excluir(" + dto.getIdBusinessUser() + ")\"");
						sb.append(" onmouseout=\"fechaTooltip()\" onmouseover=\"abreTooltip(this, '");
						sb.append(UtilI18N.internacionaliza(request, "citcorpore.comum.descvincular"));
						sb.append("')\"");
						sb.append("          class=\"btn-action glyphicons remove_2 btn-default\"><i></i></a> ");
					}
					sb.append("		</td>");
					sb.append("	</tr>");
					sb.append("</tbody>");
				}
			}
		}
	}

	public void excluir(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) {
		GerenciamentoPortfolioBusinessUserDTO obj = (GerenciamentoPortfolioBusinessUserDTO) document.getBean();
		try {
			obj = this.getBusinessUserService().restore(obj);
			getBusinessUserService().delete(obj);
			obj.setAcaoUsuarioNegocioOcorrenciaServico(AuditoriaAcoes.DESVINCULADO.getIdentificador());
			document.setBean(obj);
			this.salvarOcorrenciaServicoUsuarioNegocio(document, request, response);
			document.executeScript("notificacaoI18N('gerenciaportfolio.businessUser.Desvinculado');");
			restore(obj, document, request);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private void adicionarFimTabela(StringBuilder sb) {
		sb.append("</table>");
		sb.append("	</div>");
		sb.append("</div>");
	}

	private boolean isNullOrEmpty(Object object) {
		if (object == null) {
			return true;
		} else {
			if (object instanceof String) {
				return ((String) object).isEmpty();
			}
			return false;
		}
	}

	private void atualizarListaDeItensSelecionadosNoJavaScript(DocumentHTML document, List<GerenciamentoPortfolioBusinessUserDTO> lista) throws Exception {
		StringBuilder stringBuilderGrupo = new StringBuilder("");
		StringBuilder stringBuilderUsuario = new StringBuilder("");

		if (!isNullOrEmpty(lista)) {
			for (GerenciamentoPortfolioBusinessUserDTO obj : lista) {
				if (BusinessUserTipo.GRUPO_USUARIO.getIdentificador().equals(obj.getTipo())) {
					stringBuilderGrupo.append(obj.getIdGrupoUsuario());
					stringBuilderGrupo.append(";");
				} else {
					stringBuilderUsuario.append(obj.getIdUsuario());
					stringBuilderUsuario.append(";");
				}
			}
		}

		document.getElementById("listaIdGrupoVinculado").setValue(stringBuilderGrupo.toString());
		document.getElementById("listaIdUsuarioVinculado").setValue(stringBuilderUsuario.toString());
	}

	public void pesquisar(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioBusinessUserDTO obj = (GerenciamentoPortfolioBusinessUserDTO) document.getBean();

		if (!isNullOrEmpty(obj) && !isNullOrEmpty(obj.getIdServicoAtual())) {

			if (isNullOrEmpty(obj.getTextoPesquisado())) {
				restore(obj, document, request);
			} else {
				List<GerenciamentoPortfolioBusinessUserDTO> salvosNoBanco = (List<GerenciamentoPortfolioBusinessUserDTO>) getBusinessUserService().listByServicoAndText(obj.getIdServicoAtual(),
						obj.getTextoPesquisado());
				refreshUI(document, request, salvosNoBanco);
			}
		}
	}

	private GerenciamentoPortfolioBusinessUserService getBusinessUserService() throws ServiceException {
		if (isNullOrEmpty(businessUserService)) {
			businessUserService = (GerenciamentoPortfolioBusinessUserService) ServiceLocator.getInstance().getService(GerenciamentoPortfolioBusinessUserService.class, null);
		}
		return businessUserService;
	}

	private UsuarioService getUsuarioService() throws ServiceException {
		if (isNullOrEmpty(usuarioService)) {
			usuarioService = (UsuarioService) ServiceLocator.getInstance().getService(UsuarioService.class, null);
		}
		return usuarioService;
	}

	private GrupoService getGrupoService() throws ServiceException {
		if (isNullOrEmpty(grupoService)) {
			grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
		}
		return grupoService;
	}

	/**
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	public void salvarOcorrenciaServicoUsuarioNegocio(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) {
		GerenciamentoPortfolioBusinessUserDTO gerenciamentoPortfolioBusinessUserDTO = (GerenciamentoPortfolioBusinessUserDTO) document.getBean();
		GerenciamentoPortfolioOcorrenciasServico gerenciamentoPortfolioOcorrenciasServico = new GerenciamentoPortfolioOcorrenciasServico();

		gerenciamentoPortfolioOcorrenciasServico.salvaOcorrenciaServicoUsuarioNegocio(gerenciamentoPortfolioBusinessUserDTO.getIdServicoAtual(), gerenciamentoPortfolioBusinessUserDTO, document,
				request);
	}

}
