package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.CategoriaServicoDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioCadastroServicoApoioDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioDTO;
import br.com.centralit.citcorpore.bean.ServicoAutoRelacionamentoDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.negocio.CategoriaServicoService;
import br.com.centralit.citcorpore.negocio.ServicoAutoRelacionamentoService;
import br.com.centralit.citcorpore.negocio.ServicoService;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.centralit.citcorpore.util.Enumerados.BusinessImportance;
import br.com.centralit.citcorpore.util.Enumerados.FaseServico;
import br.com.centralit.citcorpore.util.Enumerados.PagesPortfolio;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.Enumerados.SimNao;
import br.com.centralit.citcorpore.util.Enumerados.StatusServico;
import br.com.centralit.citcorpore.util.Enumerados.TipoServico;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.core.PageRequest;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Reflexao;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;
import br.com.citframework.util.UtilStrings;

public class GerenciamentoPortfolioCadastroServicoApoio extends AjaxFormAction {

	private ServicoService servicoService;
	private CategoriaServicoService categoriaServicoService;
	private ServicoAutoRelacionamentoService  servicoAutoRelacionamentoService ;
	private static Permissoes permissao;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		setPermissaoServicoApoio(document, request);
		GerenciamentoPortfolioCadastroServicoApoioDTO beanDto = (GerenciamentoPortfolioCadastroServicoApoioDTO) document.getBean();
		carregaCombosCadastroServicoNegocio(document, request, response);

		if (beanDto != null && !UtilNumbersAndDecimals.isNull(beanDto.getIdServicoRelacionado())) {
			restoreServicoNegocioCarregaServicosApoio(beanDto, document, request);
		}
	}

	private void setPermissaoServicoApoio(DocumentHTML document, HttpServletRequest request) {
		GerenciamentoPortfolioCadastroServicoApoioDTO beanDto = (GerenciamentoPortfolioCadastroServicoApoioDTO) document.getBean();
		String caminhoPermissaoAcesso = "";

		if ("servicoNegocio".equalsIgnoreCase(beanDto.getTipoTela())) {
			caminhoPermissaoAcesso = PagesPortfolio.SERVICO_NEGOCIO_SERVICO_APOIO.getCaminho();
		} else if ("servicoApoio".equalsIgnoreCase(beanDto.getTipoTela())){
			caminhoPermissaoAcesso = PagesPortfolio.SERVICO_APOIO_SERVICOS_APOIO.getCaminho();
		}

		permissao = new Permissoes(document, request, caminhoPermissaoAcesso);
	}

	public void loadAndRestore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		setPermissaoServicoApoio(document, request);
		carregaCombosCadastroServicoNegocio(document, request, response);
		restore(document, request, response);
		document.executeScript("changeFaseServicoApoio();");
		document.executeScript("JANELA_AGUARDE_MENU.hide();");
	}

	private void carregaCombosCadastroServicoNegocio(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		carregaComboImportanciaNegocio(document, request, response);
		carregaComboFaseServico(document, request, response);
	}

	private void iniciaCombo(DocumentHTML document, HttpServletRequest request, HTMLSelect combo) throws Exception {
		combo.removeAllOptions();
		combo.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
	}

	private void carregaComboImportanciaNegocio(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("idImportanciaNegocioApoio");
		iniciaCombo(document, request, combo);

		for (BusinessImportance businessImportance : BusinessImportance.values()) {
			combo.addOption(String.valueOf(businessImportance.getId()), UtilI18N.internacionaliza(request, businessImportance.getI18NKey()));
		}
	}

	/**
	 * De acordo com os requisitos do Gerenciamento de Portflio, o servio ser
	 * classificado em fases, definidos no enum citado abaixo.
	 *
	 * @see br.com.centralit.citcorpore.util.Enumerados.FaseServico
	 * @since 15/09/2015
	 * @author douglas.japiassu
	 */
	private void carregaComboFaseServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("faseServicoApoio");
		iniciaCombo(document, request, combo);

		for (FaseServico faseServico : FaseServico.values()) {
			combo.addOption(faseServico.getIdentificador(), UtilI18N.internacionaliza(request, faseServico.getChave()));
		}
	}

	/**
	 * De acordo com os requisitos do Gerenciamento de Portflio, o servio ser
	 * classificado em <i>status</i>, de acordo com a fase selecionada.
	 *
	 * @see br.com.centralit.citcorpore.util.Enumerados.StatusServico
	 * @since 25/09/2015
	 * @author douglas.japiassu
	 */
	public void carregaComboStatusServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("statusServicoApoio");
		iniciaCombo(document, request, combo);

		GerenciamentoPortfolioCadastroServicoApoioDTO servicoApoioDto = (GerenciamentoPortfolioCadastroServicoApoioDTO) document.getBean();

		if (UtilStrings.isNotVazio(servicoApoioDto.getFaseServico())) {
			FaseServico fase = FaseServico.fromTipo(servicoApoioDto.getFaseServico());


			for (StatusServico statusServico : StatusServico.fromFase(fase)) {
				combo.addOption(statusServico.getIdentificador(), UtilI18N.internacionaliza(request, statusServico.getChave()));
			}

			if (servicoApoioDto.getIdServico() != null) {
				combo.setValue(getServicoService().recuperaStatusServico(servicoApoioDto.getIdServico()));
			}
		}

		combo.setDisabled(UtilStrings.stringVazia(servicoApoioDto.getFaseServico()));
	}

	private void restoreServicoNegocioCarregaServicosApoio(GerenciamentoPortfolioCadastroServicoApoioDTO servicoApoioDto, DocumentHTML document, HttpServletRequest request) throws Exception {
		if (servicoApoioDto != null && servicoApoioDto.getIdServicoRelacionado() != null) {
			servicoApoioDto.setPaginaSelecionadaServicoApoio(1);
			servicoApoioDto.setFiltroServicoApoio("");

			HTMLForm form = document.getForm("formCadastroServicoApoio");
			form.setValues(servicoApoioDto);

			montaHTMLServicosApoio(getDivServicoApoio(request), servicoApoioDto, document, request);
		}
	}

	public void carregaTabelaServicosApoio(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		GerenciamentoPortfolioCadastroServicoApoioDTO gerenciamentoPortfolioCadastroServicoApoioDto = (GerenciamentoPortfolioCadastroServicoApoioDTO) document.getBean();

		montaHTMLServicosApoio(getDivServicoApoio(request), gerenciamentoPortfolioCadastroServicoApoioDto, document, request);
	}

	private void montaHTMLServicosApoio(String idDiv, GerenciamentoPortfolioCadastroServicoApoioDTO gerenciamentoPortfolioCadastroServicoApoioDto, final DocumentHTML document, final HttpServletRequest request)
			throws ServiceException, Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);

		HTMLElement divListaServicosApoio = document.getElementById(idDiv);

		String filtroServicoApoio = gerenciamentoPortfolioCadastroServicoApoioDto.getFiltroServicoApoio();
		if (filtroServicoApoio == null) {
			filtroServicoApoio = "";
		}

		Integer itensPorPagina = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANT_RETORNO_PESQUISA, "10"));

		Integer paginaSelecionadaApoio = gerenciamentoPortfolioCadastroServicoApoioDto.getPaginaSelecionadaServicoApoio();
		if (paginaSelecionadaApoio == null || paginaSelecionadaApoio == 0) {
			paginaSelecionadaApoio = 1;
		}

		Pageable pageable = new PageRequest(paginaSelecionadaApoio - 1, itensPorPagina);

		Collection<ServicoDTO> listServicoApoio = getServicoService().listServicosDeApoio(gerenciamentoPortfolioCadastroServicoApoioDto.getIdPortfolioServico(), gerenciamentoPortfolioCadastroServicoApoioDto.getIdServicoRelacionado(),
				filtroServicoApoio, pageable, false).getContent();

		if (listServicoApoio != null && !listServicoApoio.isEmpty()) {
			divListaServicosApoio.setInnerHTML(GerenciamentoPortfolio.geraHTMLServicosNegocioApoio(document, request, listServicoApoio, TipoServico.SERVICO_APOIO.getIdentificador()));

			Integer totalPaginasApoio = getServicoService().listServicosDeApoio(gerenciamentoPortfolioCadastroServicoApoioDto.getIdPortfolioServico(), gerenciamentoPortfolioCadastroServicoApoioDto.getIdServicoRelacionado(),
					filtroServicoApoio, pageable, true).getTotalPages();

			HTMLElement paginacaoServicosApoio = document.getElementById("paginacaoServicosApoio");
			String funcaoJsPaginarApoio = "paginarServicosApoio";
			paginacaoServicosApoio.setInnerHTML(UtilHTML.paginacaoHtml(request, funcaoJsPaginarApoio, totalPaginasApoio, paginaSelecionadaApoio));
		} else {
			final StringBuilder htmlDivSemRegistros = new StringBuilder();
			htmlDivSemRegistros.append("<h4>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nenhumServicoApoioRegistrado") + "</h4>");
			divListaServicosApoio.setInnerHTML(htmlDivSemRegistros.toString());
		}

	}

	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		GerenciamentoPortfolioCadastroServicoApoioDTO gerenciamentoPortfolioCadastroServicoApoioDto = (GerenciamentoPortfolioCadastroServicoApoioDTO) document.getBean();
		setPermissaoServicoApoio(document, request);
		
		if(permissao.isGravar()) {
			ServicoDTO servicoDto = new ServicoDTO();
			ServicoAutoRelacionamentoDTO servicoAutoRelacionamentoDTO = new ServicoAutoRelacionamentoDTO();
	
			Reflexao.copyPropertyValues(gerenciamentoPortfolioCadastroServicoApoioDto, servicoDto);
			Reflexao.copyPropertyValues(gerenciamentoPortfolioCadastroServicoApoioDto, servicoAutoRelacionamentoDTO);
	
			if (servicoDto != null && servicoAutoRelacionamentoDTO.getIdServicoRelacionado() != null) {
				servicoDto.setDispPortal(SimNao.NAO.getValorStr());
				servicoDto.setIdEmpresa(WebUtil.getIdEmpresa(request));
				servicoDto.setIdSituacaoServico(new Integer(0));
	
	
				/*
				 * Antes pela regra de negcio, um servio no poderia inserir um
				 * servio com o mesmo nome. if
				 * (getServicoService().verificarSeServicoExiste(servicoDto)) {
				 * document.alert(UtilI18N.internacionaliza(request, "MSE01"));
				 * return; } else
				 */
	
				if (servicoAutoRelacionamentoDTO.getIdServicoRelacionado() == null) {
					document.alert(UtilI18N.internacionaliza(request, "MSE01"));
					return;
				}
	
				if (servicoDto != null && servicoDto.getIdServico() != null) {
					this.getServicoService().update(servicoDto);
					document.alert(UtilI18N.internacionaliza(request, "MSG06"));
					gerenciamentoPortfolioCadastroServicoApoioDto.setAcaoServicoApoioOcorrenciaServico(AuditoriaAcoes.ALTERADO.getIdentificador());
				} else {
					servicoDto = this.getServicoService().create(servicoDto);
	
					servicoAutoRelacionamentoDTO.setIdServico(servicoDto.getIdServico());
					servicoAutoRelacionamentoDTO.setFaseServico(servicoDto.getFaseServico());
					servicoAutoRelacionamentoDTO.setStatusServico(servicoDto.getStatusServico());
					servicoAutoRelacionamentoDTO.setDataInicio(UtilDatas.getDataAtual());
	
					this.getServicoAutoRelacionamentoService().create(servicoAutoRelacionamentoDTO);
					document.alert(UtilI18N.internacionaliza(request, "MSG05"));
					gerenciamentoPortfolioCadastroServicoApoioDto.setAcaoServicoApoioOcorrenciaServico(AuditoriaAcoes.VINCULADO.getIdentificador());
				}
	
	
				if (servicoDto != null && servicoDto.getIdServico() != null) {
					gerenciamentoPortfolioCadastroServicoApoioDto.setIdsServicoApoioOcorrenciaServico(servicoDto.getIdServico().toString());
					this.salvarOcorrenciaServicoServicoApoio(document, request, response);
				}
			}
		} else {
			document.executeScript("notificacaoErro('citcorpore.comum.permissaoFuncionalidade');");
		}

	}
	
	public void vincularServicos(final Integer idPortfolioServico, final Integer idServicoNegocio, final String listaServicosStr, final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) {
		try {
			if(permissao.isGravar()){
			String[] listaServicosApoio = new String[] {};

			listaServicosApoio = listaServicosStr.split(";");
			List<String> idsServicosVinculados = new ArrayList<String>();

			if (idServicoNegocio > 0 && listaServicosApoio != null && listaServicosApoio.length > 0) {
				for (String idServicoApoio : listaServicosApoio) {
					ServicoAutoRelacionamentoDTO autoRelacionamento = new ServicoAutoRelacionamentoDTO();

					autoRelacionamento.setIdServico(Integer.parseInt(idServicoApoio));
					autoRelacionamento.setIdServicoRelacionado(idServicoNegocio);
					autoRelacionamento.setFaseServico(getServicoService().recuperaFaseServico(idServicoNegocio));
					autoRelacionamento.setStatusServico(getServicoService().recuperaStatusServico(idServicoNegocio));
					autoRelacionamento.setDataInicio(UtilDatas.getDataAtual());

					this.getServicoAutoRelacionamentoService().create(autoRelacionamento);
					idsServicosVinculados.add(idServicoApoio);
				}
				document.alert(UtilI18N.internacionaliza(request, "gerenciaportfolio.servicoVinculadoSucesso"));
				document.executeScript("salvarOcorrenciaServicoServicoApoio('" + idsServicosVinculados.toString() + "');");
			}

			GerenciamentoPortfolioCadastroServicoApoioDTO servicoApoio = new GerenciamentoPortfolioCadastroServicoApoioDTO();
			servicoApoio.setIdPortfolioServico(idPortfolioServico);
			servicoApoio.setIdServicoRelacionado(idServicoNegocio);

			montaHTMLServicosApoio(getDivServicoApoio(request), servicoApoio, document, request);
			} else {
				document.executeScript("notificacaoErro('citcorpore.comum.naoFoiPossivelVincular','citcorpore.comum.usuarioSemPermissao')");
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@SuppressWarnings("unused")
	private void vincularServico(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		GerenciamentoPortfolioCadastroServicoApoioDTO servicoApoioDto = (GerenciamentoPortfolioCadastroServicoApoioDTO) document.getBean();

		ServicoDTO servico = new ServicoDTO();
		Reflexao.copyPropertyValues(servicoApoioDto, servico);
		ServicoAutoRelacionamentoDTO servicoAutoRelacionamentoDTO = new ServicoAutoRelacionamentoDTO();
		Reflexao.copyPropertyValues(servicoApoioDto, servicoAutoRelacionamentoDTO);

		if (servico.getIdServico() != null && servicoAutoRelacionamentoDTO.getIdServicoRelacionado() != null) {
			servicoAutoRelacionamentoDTO.setStatusServico(getServicoService().recuperaStatusServico(servicoAutoRelacionamentoDTO.getIdServicoRelacionado()));
			servicoAutoRelacionamentoDTO.setFaseServico(getServicoService().recuperaFaseServico(servicoAutoRelacionamentoDTO.getIdServicoRelacionado()));
			servicoAutoRelacionamentoDTO.setDataInicio(UtilDatas.getDataAtual());
			this.getServicoAutoRelacionamentoService().create(servicoAutoRelacionamentoDTO);
			document.alert(UtilI18N.internacionaliza(request, "gerenciaportfolio.servicoVinculadoSucesso"));
			this.salvarOcorrenciaServicoServicoApoio(document, request, response);
		} else {
			document.alert(UtilI18N.internacionaliza(request, "gerenciaportfolio.servicoVinculadoErro"));
		}

		montaHTMLServicosApoio(getDivServicoApoio(request), servicoApoioDto, document, request);
	}

	public void desvincularServico(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		GerenciamentoPortfolioCadastroServicoApoioDTO servicoApoioDto = (GerenciamentoPortfolioCadastroServicoApoioDTO) document.getBean();

		if (servicoApoioDto.getIdServico() != null && servicoApoioDto.getIdServicoRelacionado() != null) {
			if (permissao.isGravar()) {
				this.getServicoAutoRelacionamentoService().deleteServicoRelacionado(servicoApoioDto.getIdServico(), servicoApoioDto.getIdServicoRelacionado());
				document.alert(UtilI18N.internacionaliza(request, "gerenciaportfolio.servicoDesvinculadoSucesso"));
				montaHTMLServicosApoio(getDivServicoApoio(request), servicoApoioDto, document, request);
				servicoApoioDto.setAcaoServicoApoioOcorrenciaServico(AuditoriaAcoes.DESVINCULADO.getIdentificador());
				servicoApoioDto.setIdsServicoApoioOcorrenciaServico(servicoApoioDto.getIdServico().toString());
				this.salvarOcorrenciaServicoServicoApoio(document, request, response);
			} else {
				document.executeScript("notificacaoErro('citcorpore.comum.naoFoiPossivelDesvincular','citcorpore.comum.usuarioSemPermissao')");
			}
		} else {
			document.alert(UtilI18N.internacionaliza(request, "gerenciaportfolio.servicoDesvinculadoErro"));
		}
	}

	public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		GerenciamentoPortfolioCadastroServicoApoioDTO gerenciamentoPortfolioCadastroServicoApoioDto = (GerenciamentoPortfolioCadastroServicoApoioDTO) document.getBean();

		if (gerenciamentoPortfolioCadastroServicoApoioDto.getIdServico() != null) {
			ServicoDTO servicoDto = new ServicoDTO();
			servicoDto.setIdServico(gerenciamentoPortfolioCadastroServicoApoioDto.getIdServico());

			servicoDto = this.getServicoService().restore(servicoDto);

			if (servicoDto != null && servicoDto.getIdServico() != null) {

				if(servicoDto.getIdCategoriaServico() != null){
					CategoriaServicoDTO categoriaServicoDto = new CategoriaServicoDTO();
					categoriaServicoDto.setIdCategoriaServico(servicoDto.getIdCategoriaServico());
					categoriaServicoDto = this.getCategoriaServicoService().restore(categoriaServicoDto);
					if (categoriaServicoDto != null && categoriaServicoDto.getIdCategoriaServico() != null && categoriaServicoDto.getNomeCategoriaServico() != null) {
						HTMLElement nomeCategoriaServico = document.getElementById("nomeCategoriaServicoApoio");
						nomeCategoriaServico.setValue(categoriaServicoDto.getNomeCategoriaServico());
					}
				}

				if(gerenciamentoPortfolioCadastroServicoApoioDto.getIdPortfolioServico()!=null) {
					servicoDto.setIdPortfolioServico(gerenciamentoPortfolioCadastroServicoApoioDto.getIdPortfolioServico());
				}

				if(gerenciamentoPortfolioCadastroServicoApoioDto.getIdServicoRelacionado()!=null) {
					servicoDto.setIdServicoRelacionado(gerenciamentoPortfolioCadastroServicoApoioDto.getIdServicoRelacionado());
				}

				HTMLForm form = document.getForm("formCadastroServicoApoio");
				form.setValues(servicoDto);

			}
		}
	}

	public void excluir(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		GerenciamentoPortfolioCadastroServicoApoioDTO servicoApoioDto = (GerenciamentoPortfolioCadastroServicoApoioDTO) document.getBean();

		if (servicoApoioDto != null && servicoApoioDto.getIdServico() != null) {

			ServicoDTO servicoDto = new ServicoDTO();
			servicoDto.setIdServico(servicoApoioDto.getIdServico());

			servicoDto = this.getServicoService().restore(servicoDto);

			if (servicoDto != null && servicoDto.getIdServico() != null) {
				servicoDto.setDeleted(SimNao.SIM.getValorStrEn());

				this.getServicoService().update(servicoDto);
				this.getServicoAutoRelacionamentoService().deleteServicoRelacionado(servicoApoioDto.getIdServico(), servicoApoioDto.getIdServicoRelacionado());

				HTMLForm form = document.getForm("formCadastroServicoApoio");
				form.clear();

				document.alert(UtilI18N.internacionaliza(request, "MSG07"));
				document.executeScript("voltarParaListaServicoApoio();");
			}
		}
	}

	private ServicoService getServicoService() throws ServiceException {
		if (servicoService == null) {
			servicoService = (ServicoService) ServiceLocator.getInstance().getService(ServicoService.class, null);
		}
		return servicoService;
	}

	private CategoriaServicoService getCategoriaServicoService() throws ServiceException {
		if (categoriaServicoService == null) {
			categoriaServicoService = (CategoriaServicoService) ServiceLocator.getInstance().getService(CategoriaServicoService.class, null);
		}
		return categoriaServicoService;
	}

	private ServicoAutoRelacionamentoService getServicoAutoRelacionamentoService() throws ServiceException {
		if (servicoAutoRelacionamentoService == null) {
			servicoAutoRelacionamentoService = (ServicoAutoRelacionamentoService) ServiceLocator.getInstance().getService(ServicoAutoRelacionamentoService.class, null);
		}
		return servicoAutoRelacionamentoService;
	}

	@Override
	public Class<GerenciamentoPortfolioCadastroServicoApoioDTO> getBeanClass() {
		return GerenciamentoPortfolioCadastroServicoApoioDTO.class;
	}

	private String getDivServicoApoio(final HttpServletRequest request) {
		String idDiv = "divDinamicoListaServicosApoioNegocio";

		if (request.getParameter("tipoTela") != null && request.getParameter("tipoTela").equalsIgnoreCase("servicoApoio")) {
			idDiv = "divDinamicoListaServicosApoioApoio";
		}

		return idDiv;
	}

	/**
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	public void salvarOcorrenciaServicoServicoApoio(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioCadastroServicoApoioDTO gerenciamentoPortfolioCadastroServicoApoioDTO = (GerenciamentoPortfolioCadastroServicoApoioDTO) document.getBean();
		GerenciamentoPortfolioOcorrenciasServico gerenciamentoPortfolioOcorrenciasServico = new GerenciamentoPortfolioOcorrenciasServico();

		gerenciamentoPortfolioOcorrenciasServico.salvaOcorrenciaServicoRelacionado(gerenciamentoPortfolioCadastroServicoApoioDTO.getIdServicoRelacionado(),
				gerenciamentoPortfolioCadastroServicoApoioDTO.getIdsServicoApoioOcorrenciaServico(), gerenciamentoPortfolioCadastroServicoApoioDTO.getAcaoServicoApoioOcorrenciaServico(),
				TipoServico.SERVICO_APOIO.getIdentificador(), document, request);
	}

}
