package br.com.centralit.citcorpore.ajaxForms;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.CategoriaServicoDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioCadastroServicoNegocioDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.bean.ServicoQuestionarioDTO;
import br.com.centralit.citcorpore.bean.TemplateServicoDTO;
import br.com.centralit.citcorpore.bean.TipoServicoDTO;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citcorpore.negocio.CategoriaServicoService;
import br.com.centralit.citcorpore.negocio.ServicoQuestionarioService;
import br.com.centralit.citcorpore.negocio.ServicoService;
import br.com.centralit.citcorpore.negocio.TemplateServicoService;
import br.com.centralit.citcorpore.negocio.TipoServicoService;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.centralit.citcorpore.util.Enumerados.BusinessImportance;
import br.com.centralit.citcorpore.util.Enumerados.CampoUpload;
import br.com.centralit.citcorpore.util.Enumerados.CategoriaPortfolio;
import br.com.centralit.citcorpore.util.Enumerados.CriticidadeServico;
import br.com.centralit.citcorpore.util.Enumerados.DemandaServicoNegocio;
import br.com.centralit.citcorpore.util.Enumerados.FaseServico;
import br.com.centralit.citcorpore.util.Enumerados.PagesPortfolio;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.Enumerados.ProcessoDeIniciacao;
import br.com.centralit.citcorpore.util.Enumerados.RetornoFinanceiroServico;
import br.com.centralit.citcorpore.util.Enumerados.ServiceExecutionPlace;
import br.com.centralit.citcorpore.util.Enumerados.SimNao;
import br.com.centralit.citcorpore.util.Enumerados.StatusServico;
import br.com.centralit.citcorpore.util.Enumerados.TipoDeInvestimento;
import br.com.centralit.citcorpore.util.Enumerados.TipoServico;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.Util;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.centralit.citged.bean.ControleGEDDTO;
import br.com.centralit.citged.negocio.ControleGEDService;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.core.PageRequest;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Configuracoes;
import br.com.citframework.util.Reflexao;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;
import br.com.citframework.util.UtilStrings;

@SuppressWarnings("unchecked")
public class GerenciamentoPortfolioCadastroServicoNegocio extends AjaxFormAction {

	private ServicoService servicoService;
	private CategoriaServicoService categoriaServicoService;
	private ControleGEDService controleGEDService;
	private TipoServicoService tipoServicoService;
	private TemplateServicoService templateServicoService;
	private ServicoQuestionarioService servicoQuestionarioService;
	private static Permissoes permissao;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		GerenciamentoPortfolio.setPortalImages(document);
		carregaCombosCadastroServicoNegocio(document, request, response);
		request.getSession(true).setAttribute(CampoUpload.UPLOADSERVICONEGOCIO.getColUploadGED(), null);
		document.executeScript("uploadServicoNegocio.refresh()");
		setarDataImplantacao(document, request);
	}

	private void setPermissoesServicoNegocio(DocumentHTML document, HttpServletRequest request) throws Exception {
		permissao = new Permissoes(document, request, PagesPortfolio.SERVICO_NEGOCIO.getCaminho());
	}

	private void setarDataImplantacao(DocumentHTML document, HttpServletRequest request) throws Exception {
		UtilDatas.setLocale(WebUtil.getLanguage(request));
		document.getElementById("dataInicioServicoNegocio").setValue(UtilDatas.getDataAtualStr());
	}

	public void reloadAnexos(final DocumentHTML document, final HttpServletRequest request,
			final HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioCadastroServicoNegocioDTO beanDto = (GerenciamentoPortfolioCadastroServicoNegocioDTO) document.getBean();

		restaurarAnexos(document, request, beanDto);
		document.executeScript("afterReloadAnexosServicoNegocio()");
	}

	private void carregaCombosCadastroServicoNegocio(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		carregaComboImportanciaNegocio(document, request, response);
		carregaComboFaseServico(document, request, response);
		carregaComboProcessoDeIniciacao(document, request, response);
		carregaComboTipoDeInvestimento(document, request, response);
		carregaComboTipoServico(document, request, response);
		carregaComboLocalExecucaoServico(document, request, response);
		carregaComboTemplate(document, request, response);
		carregaComboCriticidade(document, request, response);
		carregaComboDemandaNegocio(document, request, response);
		carregaComboTipoRetornoServicoNegocio(document, request, response);
	}

	private void iniciaCombo(DocumentHTML document, HttpServletRequest request, HTMLSelect combo) throws Exception {
		combo.removeAllOptions();
		combo.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
	}

	private void carregaComboImportanciaNegocio(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("idImportanciaNegocio");
		iniciaCombo(document, request, combo);

		for (BusinessImportance businessImportance : BusinessImportance.values()) {
			combo.addOption(String.valueOf(businessImportance.getId()), UtilI18N.internacionaliza(request, businessImportance.getI18NKey()));
		}
	}

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.FaseServico
	 * @since 15/09/2015
	 * @author douglas.japiassu
	 */
	private void carregaComboFaseServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("faseServico");
		combo.removeAllOptions();

		for (FaseServico faseServico : FaseServico.values()) {
			combo.addOption(faseServico.getIdentificador(), UtilI18N.internacionaliza(request, faseServico.getChave()));
		}

		combo = document.getSelectById("statusServico");
		combo.removeAllOptions();

		for (StatusServico statusServico : StatusServico.fromFase(FaseServico.DEFINIR)) {
			combo.addOption(statusServico.getIdentificador(), UtilI18N.internacionaliza(request, statusServico.getChave()));
		}
	}

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.ProcessoDeIniciacao
	 * @since 26.10.2015
	 * @author douglas.japiassu
	 */
	private void carregaComboProcessoDeIniciacao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("processoDeIniciacao");
		iniciaCombo(document, request, combo);

		for (ProcessoDeIniciacao processoDeIniciacao : ProcessoDeIniciacao.values()) {
			combo.addOption(processoDeIniciacao.getIdentificador(), UtilI18N.internacionaliza(request, processoDeIniciacao.getChave()));
		}
	}
	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.TipoDeInvestimento
	 * @since 26.10.2015
	 * @author douglas.japiassu
	 */
	private void carregaComboTipoDeInvestimento(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("tipoDeInvestimento");
		iniciaCombo(document, request, combo);

		for (TipoDeInvestimento tipoDeInvestimento : TipoDeInvestimento.values()) {
			combo.addOption(tipoDeInvestimento.getIdentificador(), UtilI18N.internacionaliza(request, tipoDeInvestimento.getChave()));
		}
	}

	/**
	 * @since 18.01.2016
	 * @author douglas.japiassu
	 */
	private void carregaComboTipoServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("idTipoServicoNegocio");
		iniciaCombo(document, request, combo);

		Collection<TipoServicoDTO> listTipoServicoDto = this.getTipoServicoService().getAtivos();

		if (listTipoServicoDto != null) {
			for (TipoServicoDTO tipoServicoDto : listTipoServicoDto) {
				combo.addOption(String.valueOf(tipoServicoDto.getIdTipoServico()), tipoServicoDto.getNomeTipoServico());
			}
		}
	}

	/**
	 * @since 18.01.2016
	 * @author douglas.japiassu
	 */
	private void carregaComboLocalExecucaoServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("idLocalExecucaoServicoNegocio");
		iniciaCombo(document, request, combo);

		for (ServiceExecutionPlace serviceExecutionPlace : ServiceExecutionPlace.values()) {
			combo.addOption(String.valueOf(serviceExecutionPlace.getId()), UtilI18N.internacionaliza(request, serviceExecutionPlace.getI18NKey()));
		}
	}

	/**
	 * Template que ser renderizado dentro do Gerenciamento de Portflio. S poder ser escolhido no momento da criao do servio.
	 *
	 * @since 19.01.2016
	 * @author douglas.japiassu
	 */
	private void carregaComboTemplate(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("idTemplateServico");
		iniciaCombo(document, request, combo);

		Collection<TemplateServicoDTO> listTemplateServicoDto = this.getTemplateServicoService().list();

		if (listTemplateServicoDto != null) {
			combo.addOptions(listTemplateServicoDto, "idTemplateServico", "nomeTemplate", "");
		}
	}

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.CriticidadeServico
	 * @since 28.01.2016
	 * @author gilmar.junior
	 */
	private void carregaComboCriticidade(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("criticidadeServico");
		iniciaCombo(document, request, combo);

		for (CriticidadeServico criticidade : CriticidadeServico.values()) {
			combo.addOption(criticidade.getIdentificador().toString(), UtilI18N.internacionaliza(request, criticidade.getChave()));
		}
	}

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.DemandaServicoNegocio
	 * @since 28.01.2016
	 * @author gilmar.junior
	 */
	private void carregaComboDemandaNegocio(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("demandaServico");
		iniciaCombo(document, request, combo);

		for (DemandaServicoNegocio demandaServicoNegocio : DemandaServicoNegocio.values()) {
			combo.addOption(demandaServicoNegocio.getIdentificador().toString(), UtilI18N.internacionaliza(request, demandaServicoNegocio.getChave()));
		}
	}

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.RetornoFinanceiroServico
	 * @since 28.01.2016
	 * @author gilmar.junior
	 */
	private void carregaComboTipoRetornoServicoNegocio(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("retornoFinanceiroServico");
		iniciaCombo(document, request, combo);

		for (RetornoFinanceiroServico retornoFinanceiroServico : RetornoFinanceiroServico.values()) {
			combo.addOption(retornoFinanceiroServico.getIdentificador().toString(), UtilI18N.internacionaliza(request, retornoFinanceiroServico.getChave()));
		}
	}

	/**
	 * De acordo com os requisitos do Gerenciamento de Portflio, o servio ser classificado em <i>status</i>, de acordo com a fase selecionada.
	 *
	 * @see br.com.centralit.citcorpore.util.Enumerados.StatusServico
	 * @since 25/09/2015
	 * @author douglas.japiassu
	 */
	public void carregaComboStatusServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("statusServico");
		combo.removeAllOptions();

		GerenciamentoPortfolioCadastroServicoNegocioDTO servicoNegocioDto = (GerenciamentoPortfolioCadastroServicoNegocioDTO) document.getBean();

		if (UtilStrings.isNotVazio(servicoNegocioDto.getFaseServico())) {
			FaseServico fase = FaseServico.fromTipo(servicoNegocioDto.getFaseServico());


			for (StatusServico statusServico : StatusServico.fromFase(fase)) {
				combo.addOption(statusServico.getIdentificador(), UtilI18N.internacionaliza(request, statusServico.getChave()));
			}

			if (servicoNegocioDto.getIdServico() != null) {
				combo.setValue(getServicoService().recuperaStatusServico(servicoNegocioDto.getIdServico()));
			}
		}
	}

	public void carregarContadores(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioCadastroServicoNegocioDTO servicoNegocioDto = (GerenciamentoPortfolioCadastroServicoNegocioDTO) document.getBean();

		setarContadoresPortfolio(servicoNegocioDto, document, request);
	}

	/**
	 * Busca no banco a quantidade de registros para cada Categoria de Portflio (conforme enum abaixo).
	 *
	 * @see br.com.centralit.citcorpore.util.Enumerados.CategoriaPortfolio
	 * @param servicoNegocioDto
	 * @param document
	 * @param request
	 * @throws Exception
	 * @author douglas.japiassu
	 */
	private void setarContadoresPortfolio(GerenciamentoPortfolioCadastroServicoNegocioDTO servicoNegocioDto, DocumentHTML document, HttpServletRequest request) throws Exception {
		Long countFunil = getServicoService().getTotalRegistrosPorCategoriaPortfolio(servicoNegocioDto.getIdPortfolioServico(), CategoriaPortfolio.FUNIL_SERVICOS.getIdentificador());
		Long countCatalogo = getServicoService().getTotalRegistrosPorCategoriaPortfolio(servicoNegocioDto.getIdPortfolioServico(), CategoriaPortfolio.CATALOGO_SERVICOS.getIdentificador());
		Long countObsoletos = getServicoService().getTotalRegistrosPorCategoriaPortfolio(servicoNegocioDto.getIdPortfolioServico(), CategoriaPortfolio.SERVICOS_OBSOLETOS.getIdentificador());

		HTMLElement contadorFunilServicos = document.getElementById("statsCountFunilServicos");
		contadorFunilServicos.setInnerHTML(countFunil.toString());

		HTMLElement contadorCatalogoServicos = document.getElementById("statsCountCatalogoServicos");
		contadorCatalogoServicos.setInnerHTML(countCatalogo.toString());

		HTMLElement contadorServicosObsoletos = document.getElementById("statsCountServicosObsoletos");
		contadorServicosObsoletos.setInnerHTML(countObsoletos.toString());
	}

	public void carregaTabelaServicosNegocio(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		GerenciamentoPortfolioCadastroServicoNegocioDTO gerenciamentoPortfolioCadastroServicoNegocioDto = (GerenciamentoPortfolioCadastroServicoNegocioDTO) document.getBean();

		montaHTMLServicosNegocio(gerenciamentoPortfolioCadastroServicoNegocioDto, document, request);

		document.executeScript("depoisCarregarTabelaServicosNegocio();");
	}

	/**
	 * Adiciona a div divClassificacaoServicoNegocioTxt os valores de tipoDeInvestimento, Demanda e RetornoFinanceiro para serem mostrados quando o tipo de servio for Aprovar ou Termo de Abertura
	 *
	 * @see br.com.centralit.citcorpore.util.Enumerados.TipoDeInvestimento
	 * @see br.com.centralit.citcorpore.util.Enumerados.CriticidadeIC
	 * @see br.com.centralit.citcorpore.util.Enumerados.RetornoFinanceiroServico
	 *
	 * @author gilmar.junior
	 * @since 29.01.2016
	 *
	 */
	public void montaHTMLClassificacaoServicoNegocioTxt(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		GerenciamentoPortfolioCadastroServicoNegocioDTO gerenciamentoPortfolioCadastroServicoNegocioDto = (GerenciamentoPortfolioCadastroServicoNegocioDTO) document.getBean();
		if (!UtilNumbersAndDecimals.nullToVazio(gerenciamentoPortfolioCadastroServicoNegocioDto.getIdServico()).isEmpty()) {
			final ServicoDTO servicoDto = getServicoService().findById(gerenciamentoPortfolioCadastroServicoNegocioDto.getIdServico());

			if (servicoDto != null && servicoDto.getIdServico() != null) {
				if(servicoDto.getTipoDeInvestimento() != null && !servicoDto.getTipoDeInvestimento().isEmpty()
					&&	servicoDto.getDemandaServico() != null && !servicoDto.getDemandaServico().toString().isEmpty()
					&&  servicoDto.getRetornoFinanceiroServico() != null && !servicoDto.getRetornoFinanceiroServico().toString().isEmpty()){

					StringBuilder sb = new StringBuilder();
					HTMLElement divClassificacaoServicosNegocioTxt = document.getElementById("divClassificacaoServicoNegocioTxT");

					sb.append("	<div class='row-fluid'>");
					sb.append("		<h4 class='strong heading-arrow'>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.classificacao") + "</h4>");
					sb.append("	</div>");

					sb.append("	<div class='row-fluid' style='margin-left:10px; width: 98%' id='classificacaoServicoNegocioTxt'>");

					sb.append("		<div class='span4'>");
					sb.append("			<div class=\"row-fluid strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.tipoDeInvestimento") + ": </div>");

					if (UtilStrings.isNotVazio(servicoDto.getTipoDeInvestimento())) {
						sb.append("			<div class=\"span6\" id=\"tipoDeInvestimentoTxt\"> "
								+ UtilI18N.internacionaliza(request, TipoDeInvestimento.fromTipo(servicoDto.getTipoDeInvestimento()).getChave()) + "</div>");
					}

					sb.append("		</div>");

					sb.append("		<div class='span4'>");
					sb.append("			<div class=\"row-fluid strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.classificacao.demandaServico") + ": </div>");

					if (!UtilNumbersAndDecimals.nullToVazio(servicoDto.getDemandaServico()).isEmpty()) {
						sb.append("			<div class=\"span6\" id=\"demandaServicoTxt\"> " + UtilI18N.internacionaliza(request, DemandaServicoNegocio.fromIdentificador(servicoDto.getDemandaServico()).getChave())
								+ "</div>");
					}

					sb.append("		</div>");

					sb.append("		<div class='span4'>");
					sb.append("			<div class=\"row-fluid strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.classificacao.retornoFinanceiroServico") + ": </div>");

					if (!UtilNumbersAndDecimals.nullToVazio(servicoDto.getRetornoFinanceiroServico()).isEmpty()) {
						sb.append("			<div class=\"span6\"id=\"retornoFinanceiroServicoTxt\">"
								+ UtilI18N.internacionaliza(request, RetornoFinanceiroServico.fromIdentificador(servicoDto.getRetornoFinanceiroServico()).getChave()) + "</div>");
					}

					sb.append("		</div>");
					sb.append("	</div>");

					document.executeScript("$(\"#criticidadeServico\").val(" + servicoDto.getCriticidadeServico() + ");");

					divClassificacaoServicosNegocioTxt.setInnerHTML(sb.toString());
				}
			}
		}
	}

	public void montaHTMLServicosNegocio(GerenciamentoPortfolioCadastroServicoNegocioDTO servicoNegocioDto, final DocumentHTML document, final HttpServletRequest request)
			throws ServiceException, Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);

		HTMLElement divListaServicos = document.getElementById("divDinamicoListaServicosNegocio");

		String filtroServicoNegocio = servicoNegocioDto.getFiltroServicoNegocio();
		if (filtroServicoNegocio == null) {
			filtroServicoNegocio = "";
		}

		Integer itensPorPagina = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANT_RETORNO_PESQUISA, "10"));

		Integer paginaSelecionadaNegocio = servicoNegocioDto.getPaginaSelecionadaServicoNegocio();
		if (paginaSelecionadaNegocio == null || paginaSelecionadaNegocio == 0) {
			paginaSelecionadaNegocio = 1;
		}

		Pageable pageable = new PageRequest(paginaSelecionadaNegocio - 1, itensPorPagina);

		Collection<ServicoDTO> listServicoNegocio = getServicoService().listServicosDeNegocio(servicoNegocioDto.getIdPortfolioServico(),
				servicoNegocioDto.getCategoriaPortfolio(), filtroServicoNegocio, servicoNegocioDto.getOrdenarPor(), servicoNegocioDto.getAscDesc(), pageable, false).getContent();

		if (listServicoNegocio != null && !listServicoNegocio.isEmpty()) {
			divListaServicos.setInnerHTML(GerenciamentoPortfolio.geraHTMLServicosNegocioApoio(document, request, listServicoNegocio, TipoServico.SERVICO_NEGOCIO.getIdentificador()));

			Integer totalPaginasNegocio = getServicoService().listServicosDeNegocio(servicoNegocioDto.getIdPortfolioServico(),
					servicoNegocioDto.getCategoriaPortfolio(), filtroServicoNegocio, servicoNegocioDto.getOrdenarPor(), servicoNegocioDto.getAscDesc(), pageable, true).getTotalPages();

			HTMLElement paginacaoServicosNegocio = document.getElementById("paginacaoServicosNegocio");
			String funcaoJsPaginarNegocio = "paginarServicosNegocio";
			paginacaoServicosNegocio.setInnerHTML(UtilHTML.paginacaoHtml(request, funcaoJsPaginarNegocio, totalPaginasNegocio, paginaSelecionadaNegocio));
		} else {
			final StringBuilder htmlDivSemRegistros = new StringBuilder();
			htmlDivSemRegistros.append("<h4>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nenhumServicoNegocioRegistrado") + "</h4>");
			divListaServicos.setInnerHTML(htmlDivSemRegistros.toString());
		}

		setarContadoresPortfolio(servicoNegocioDto, document, request);

		document.executeScript("depoisMontarHTMLServicosNegocio();");
	}

	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		GerenciamentoPortfolioCadastroServicoNegocioDTO servicoNegocioDto = (GerenciamentoPortfolioCadastroServicoNegocioDTO) document.getBean();
		setPermissoesServicoNegocio(document, request);

		if(permissao.isGravar()) {
			if (SimNao.SIM.getValorStr().equalsIgnoreCase(servicoNegocioDto.getDispPortal()) && UtilStrings.isNotVazio(servicoNegocioDto.getImagemPortal())) {
				servicoNegocioDto.setImagemPortal(servicoNegocioDto.getImagemPortal().replace(CITCorporeUtil.CONTEXTO_APLICACAO, ""));
			}

			ServicoDTO servicoDTO = new ServicoDTO();

			Reflexao.copyPropertyValues(servicoNegocioDto, servicoDTO);

			Collection<UploadDTO> arquivosGED = (Collection<UploadDTO>) request.getSession(true).getAttribute(CampoUpload.UPLOADSERVICONEGOCIO.getColUploadGED());

			servicoNegocioDto.setColsUploadGED(arquivosGED);

			if (servicoDTO != null) {
				servicoDTO.setIdEmpresa(WebUtil.getIdEmpresa(request));
				servicoDTO.setIdSituacaoServico(new Integer(0));

				this.tratarTemplateServico(document, request, servicoDTO);

				final String mensagem = montarMensagemDaAcao(servicoDTO);

				if (servicoDTO.getIdServico() != null) {
					servicoNegocioDto.setAcaoDetalhesOcorrenciaServico(AuditoriaAcoes.ALTERADO.getIdentificador());
				} else {
					servicoNegocioDto.setAcaoDetalhesOcorrenciaServico(AuditoriaAcoes.CRIADO.getIdentificador());
				}

				servicoNegocioDto = this.getServicoService().salvar(servicoDTO, servicoNegocioDto, request);

				if (servicoNegocioDto != null) {
					if (Util.isNullOrEmpty(servicoNegocioDto.getMsgErroSalvarQuestionario())) {
						document.alert(UtilI18N.internacionaliza(request, mensagem));

						if (servicoDTO != null && servicoDTO.getIdServico() != null) {
							this.salvarListaArquivosAdicionadosDetalhesServico(arquivosGED, document);
							this.salvarOcorrenciaServicoDetalhesServico(document, request, response);
						}
					} else {
						document.executeScript("notificacaoErro('citcorpore.comum.erroAoGravar', ['gerenciaportfolio.formularioDinamico', ': ', '".concat(servicoNegocioDto.getMsgErroSalvarQuestionario()).concat("']);"));
					}
				} else {
					document.executeScript("notificacaoErro('MSG01');");
				}

				carregaInformacoesComplementares(document, request, servicoDTO);
			}
		} else {
			document.executeScript("notificacaoErro('citcorpore.comum.permissaoFuncionalidade');");
		}

	}

	/**
	 * Responsvel por obter os dados do template/questionrio (quando houver)
	 *
	 * @author douglas.japiassu
	 * @since 28.01.2016
	 */
	private void tratarTemplateServico(DocumentHTML document, HttpServletRequest request, ServicoDTO servicoDTO) throws Exception, ServiceException {
		if (servicoDTO.getIdServico() != null && servicoDTO.getIdTemplateServico() != null) {
			ServicoQuestionarioDTO servicoQuestionarioDTO = null;
			final TemplateServicoDTO templateDto = getTemplateServicoService().findById(servicoDTO.getIdTemplateServico());
			if (templateDto != null && templateDto.isQuestionario()) {
				final Timestamp ts1 = UtilDatas.getDataHoraAtual();
				double tempo = 0;
				String attrSessao = "dados_servico_questionario_".concat(servicoDTO.getIdServico().toString());
				servicoQuestionarioDTO = (ServicoQuestionarioDTO) request.getSession().getAttribute(attrSessao);
				while (servicoQuestionarioDTO == null && tempo <= 10000) {
					servicoQuestionarioDTO = (ServicoQuestionarioDTO) request.getSession().getAttribute(attrSessao);
					final Timestamp ts2 = UtilDatas.getDataHoraAtual();
					tempo = UtilDatas.calculaDiferencaTempoEmMilisegundos(ts2, ts1);
				}

				request.getSession(true).setAttribute(attrSessao, null);

				if (servicoQuestionarioDTO == null) {
					return;
				}
			}
			getServicoService().deserializaInformacoesComplementares(servicoDTO, servicoQuestionarioDTO);
		}
	}

	private String montarMensagemDaAcao(final ServicoDTO beanDto) {
		String mensagemRetorno = "MSG05";
		if (beanDto != null && beanDto.getIdServico() != null) {
			mensagemRetorno = "MSG06";
		}
		return mensagemRetorno;
	}

	public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolio.setPortalImages(document);

		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		carregaCombosCadastroServicoNegocio(document, request, response);
		GerenciamentoPortfolioCadastroServicoNegocioDTO servicoNegocioDto = (GerenciamentoPortfolioCadastroServicoNegocioDTO) document.getBean();

		if (servicoNegocioDto != null && servicoNegocioDto.getIdServico() != null) {
			request.getSession(true).setAttribute("idServicoRelacionado", servicoNegocioDto.getIdServico());
			ServicoDTO servicoDto = new ServicoDTO();
			servicoDto.setIdServico(servicoNegocioDto.getIdServico());

			servicoDto = this.getServicoService().restore(servicoDto);

			if (servicoDto != null && servicoDto.getIdServico() != null) {

				if(servicoDto.getIdCategoriaServico() != null){
					CategoriaServicoDTO categoriaServicoDto = new CategoriaServicoDTO();
					categoriaServicoDto.setIdCategoriaServico(servicoDto.getIdCategoriaServico());
					categoriaServicoDto = this.getCategoriaServicoService().restore(categoriaServicoDto);
					if (categoriaServicoDto != null && categoriaServicoDto.getIdCategoriaServico() != null && categoriaServicoDto.getNomeCategoriaServico() != null) {
						HTMLElement nomeCategoriaServico = document.getElementById("nomeCategoriaServicoNegocio");
						nomeCategoriaServico.setValue(categoriaServicoDto.getNomeCategoriaServico());
					}
				}

				// Se for um clone, o id do porfolio no necessariamente ser o
				// mesmo do servio clonado
				if(servicoNegocioDto.getIdPortfolioServico()!=null) {
					servicoDto.setIdPortfolioServico(servicoNegocioDto.getIdPortfolioServico());
				}

				HTMLForm form = document.getForm("formCadastroServicoNegocio");
				form.setValues(servicoDto);

				restaurarAnexos(document, request, servicoNegocioDto);
				carregaInformacoesComplementares(document, request, servicoDto);

				if (servicoDto.getDispPortal() != null && servicoDto.getDispPortal().equalsIgnoreCase("S")) {
					document.executeScript("$('.portal-content').show();");
				} else {
					document.executeScript("$('.portal-content').hide();");
				}

				document.executeScript("Modal.adjust('modal-portfolio-servico-negocio');");

				if (UtilStrings.isNotVazio(servicoDto.getImagemPortal())) {
					document.executeScript("$('.carousel li img[src=\"" + Configuracoes.getCaminhoComContexto(servicoDto.getImagemPortal()) + "\"]').parent('li').trigger('click');");
				}
			}
		}
	}

	private void restaurarAnexos(final DocumentHTML document, final HttpServletRequest request, final GerenciamentoPortfolioCadastroServicoNegocioDTO servicoNegocioDTO) throws ServiceException, Exception {
		Collection<UploadDTO> colAnexosUploadDTO = new ArrayList<>();

		final Collection<ControleGEDDTO> colAnexos = getControleGEDService().listByIdTabelaAndID(ControleGEDDTO.TABELA_SERVICO_NEGOCIO,
				servicoNegocioDTO.getIdServico());

		if (colAnexos != null && !colAnexos.isEmpty()) {
			colAnexosUploadDTO = getControleGEDService().convertListControleGEDToUploadDTO(colAnexos);
			request.getSession(true).setAttribute(CampoUpload.UPLOADSERVICONEGOCIO.getColUploadGED(), colAnexosUploadDTO);
		} else {
			request.getSession(true).setAttribute(CampoUpload.UPLOADSERVICONEGOCIO.getColUploadGED(), null);
		}

		definirContadorProcessoDeIniciacao(document, colAnexosUploadDTO);
		document.executeScript("uploadServicoNegocio.refresh()");
	}

	public void definirContadorProcessoDeIniciacao(DocumentHTML document, Collection<UploadDTO> anexos) throws Exception {
		HTMLElement processoDeIniciacao = document.getElementById("processoDeIniciacaoLabel");
		setQuantidadeElemento(anexos.size(), processoDeIniciacao);
	}

	private void setQuantidadeElemento(final Integer qtde, HTMLElement elemento) {
		if (qtde.compareTo(new Integer(0)) > 0) {
			elemento.setValue("<i class=\"lfloat material-icons md-14\">attachment</i>&nbsp".concat(String.valueOf(qtde)));
			elemento.setClassName("rfloat label label-success");
			elemento.setAttributes("onmouseover", "abreTooltip(this, \"citcorpore.comum.quantidadeAnexos\")");
		} else {
			elemento.setValue("<i class=\"material-icons md-14\">attach_file</i>");
			elemento.setClassName("rfloat label label-warning");
			elemento.setAttributes("onmouseover", "abreTooltip(this, \"citcorpore.comum.adicionarAnexos\")");
		}

		elemento.setAttributes("onclick", "onClickLabelAnexosServicoNegocio()");
		elemento.setAttributes("onmouseout", "fechaTooltip()");
	}

	public void carregaInformacoesComplementaresViaJS(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioCadastroServicoNegocioDTO servicoNegocioDto = (GerenciamentoPortfolioCadastroServicoNegocioDTO) document.getBean();
		ServicoDTO servicoDTO = new ServicoDTO();
		Reflexao.copyPropertyValues(servicoNegocioDto, servicoDTO);

		if (servicoDTO != null && servicoDTO.getIdServico() != null) {
			carregaInformacoesComplementares(document, request, servicoDTO);
		}

	}

	private void carregaInformacoesComplementares(DocumentHTML document, HttpServletRequest request, ServicoDTO servicoDto) throws Exception {
		TemplateServicoDTO templateDto = getTemplateServicoService().findById(UtilNumbersAndDecimals.nullToZero(servicoDto.getIdTemplateServico()));

		if (templateDto != null) {
			if (templateDto.getAlturaDiv() != null) {
				String url = getServicoService().getUrlInformacoesComplementares(servicoDto);
				document.executeScript("document.getElementById('divInformacoesComplementares').style.height = '" + templateDto.getAlturaDiv().intValue() + "px';");
				document.executeScript("exibirInformacoesComplementares(\"" + url + "\");");
				document.executeScript("incluiInfoComplSeQuestionario(\"" + url + "\");");

				if (this.getServicoQuestionarioService().existeQuestionarioByIdServico(servicoDto.getIdServico())) {
					document.executeScript("disableTemplateServico();");
				}
			}
		} else {
			document.executeScript("$(\"li a[href='#dadosServicoNegocio']\").trigger('click');");
			document.executeScript("exibirInformacoesComplementares('');");
		}

		document.executeScript("JANELA_AGUARDE_MENU.hide();");
	}

	public void excluir(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		GerenciamentoPortfolioCadastroServicoNegocioDTO gerenciamentoPortfolioCadastroServicoNegocioDto = (GerenciamentoPortfolioCadastroServicoNegocioDTO) document.getBean();
		setPermissoesServicoNegocio(document, request);

		if(permissao.isDeletar()) {
			if (gerenciamentoPortfolioCadastroServicoNegocioDto != null && gerenciamentoPortfolioCadastroServicoNegocioDto.getIdServico() != null) {

				ServicoDTO servicoDto = new ServicoDTO();
				servicoDto.setIdServico(gerenciamentoPortfolioCadastroServicoNegocioDto.getIdServico());

				servicoDto = this.getServicoService().restore(servicoDto);

				if (servicoDto != null && servicoDto.getIdServico() != null) {
					servicoDto.setDeleted("y");

					this.getServicoService().update(servicoDto);

					HTMLForm form = document.getForm("formCadastroServicoNegocio");
					form.clear();

					document.alert(UtilI18N.internacionaliza(request, "MSG07"));
					document.executeScript("voltarParaListaServicoNegocio();");
					gerenciamentoPortfolioCadastroServicoNegocioDto.setAcaoDetalhesOcorrenciaServico(AuditoriaAcoes.EXCLUIDO.getIdentificador());
					this.salvarOcorrenciaServicoDetalhesServico(document, request, response);
				}
			}
		} else {
			document.executeScript("notificacaoErro('citcorpore.comum.permissaoFuncionalidade');");
		}
	}

	/**
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	public void salvarOcorrenciaServicoDetalhesServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioCadastroServicoNegocioDTO gerenciamentoPortfolioCadastroServicoNegocioDto = (GerenciamentoPortfolioCadastroServicoNegocioDTO) document.getBean();

		GerenciamentoPortfolioOcorrenciasServico gerenciamentoPortfolioOcorrenciasServico = new GerenciamentoPortfolioOcorrenciasServico();
		gerenciamentoPortfolioOcorrenciasServico.salvaOcorrenciaServicoDetalhes(gerenciamentoPortfolioCadastroServicoNegocioDto, document, request);
	}

	/**
	 * @author deborah.ferreira
	 * @since 18.02.2016
	 */
	private void salvarListaArquivosAdicionadosDetalhesServico(Collection<UploadDTO> listaArquivos, DocumentHTML document) throws Exception {
		GerenciamentoPortfolioCadastroServicoNegocioDTO gerenciamentoPortfolioCadastroServicoNegocioDTO = (GerenciamentoPortfolioCadastroServicoNegocioDTO) document.getBean();
		String listaIdsStr = "";

		if (listaArquivos != null) {
			for (UploadDTO anexo : listaArquivos) {
				if (anexo.getTemporario().toUpperCase().equals("S")) {
					if (anexo.getIdControleGED() != null) {
						listaIdsStr += anexo.getIdControleGED() + ",";
					}
				}
			}
		}

		gerenciamentoPortfolioCadastroServicoNegocioDTO.setListaIdsAnexosServicoOcorrenciaServico(listaIdsStr);
	}

	private ServicoService getServicoService() throws ServiceException {
		if (servicoService == null) {
			servicoService = (ServicoService) ServiceLocator.getInstance().getService(ServicoService.class, null);
		}
		return servicoService;
	}

	private CategoriaServicoService getCategoriaServicoService() throws ServiceException {
		if (categoriaServicoService == null) {
			categoriaServicoService = (CategoriaServicoService) ServiceLocator.getInstance().getService(CategoriaServicoService.class, null);
		}
		return categoriaServicoService;
	}

	private ControleGEDService getControleGEDService() throws ServiceException {
		if (this.controleGEDService == null) {
			this.controleGEDService = (ControleGEDService) ServiceLocator.getInstance().getService(ControleGEDService.class, null);
		}
		return this.controleGEDService;
	}

	private TipoServicoService getTipoServicoService() throws ServiceException {
		if (tipoServicoService == null) {
			tipoServicoService = (TipoServicoService) ServiceLocator.getInstance().getService(TipoServicoService.class, null);
		}
		return tipoServicoService;
	}

	private TemplateServicoService getTemplateServicoService() throws ServiceException {
		if (templateServicoService == null) {
			templateServicoService = (TemplateServicoService) ServiceLocator.getInstance().getService(TemplateServicoService.class, null);
		}
		return templateServicoService;
	}

	private ServicoQuestionarioService getServicoQuestionarioService() throws ServiceException {
		if (servicoQuestionarioService == null) {
			servicoQuestionarioService = (ServicoQuestionarioService) ServiceLocator.getInstance().getService(ServicoQuestionarioService.class, null);
		}
		return servicoQuestionarioService;
	}

	@Override
	public Class<GerenciamentoPortfolioCadastroServicoNegocioDTO> getBeanClass() {
		return GerenciamentoPortfolioCadastroServicoNegocioDTO.class;
	}

}
