package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.CasoNegocioDTO;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.negocio.CasoNegocioService;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.centralit.citcorpore.util.Enumerados.CampoUpload;
import br.com.centralit.citcorpore.util.Enumerados.PagesPortfolio;
import br.com.centralit.citcorpore.util.Enumerados.TipoAnexoCasoNegocio;
import br.com.centralit.citcorpore.util.LogoRel;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.UtilRelatorio;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.centralit.citged.bean.ControleGEDDTO;
import br.com.centralit.citged.negocio.ControleGEDService;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilListas;
import br.com.citframework.util.UtilNumbersAndDecimals;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.fill.JRAbstractLRUVirtualizer;
import net.sf.jasperreports.engine.fill.JRSwapFileVirtualizer;
import net.sf.jasperreports.engine.util.JRSwapFile;

/**
 * @author ibimon.morais
 * @02/10/2015
 */
public class GerenciamentoPortfolioCasoNegocio extends AjaxFormAction {
	private static final String JASPER_ARQ_REL = "RelatorioGerenciamentoPortfolioCasoDeNegocio";
	private CasoNegocioService service;
	private static Permissoes permissao;

	@Override
	public Class<CasoNegocioDTO> getBeanClass() {
		return CasoNegocioDTO.class;
	}

	/**
	 * @author ibimon.morais
	 * @since 07/10/2015
	 */
	@Override
	public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		setPermissoesCasoNegocio(document, request);
		CasoNegocioDTO beanDto = (CasoNegocioDTO) document.getBean();
		request.getSession(true).setAttribute(CampoUpload.UPLOADCASODENEGOCIO.getColUploadGED(), null);
		this.carregarDadosComboTipoDeAnexo(document, request, response);

		if (beanDto != null && !UtilNumbersAndDecimals.isNull(beanDto.getIdServico())) {
			this.restoreCasoDeNegocio(beanDto, document, request);
		}
		document.executeScript("uploadCasoDeNegocio.refresh();");
	}
	
	private void setPermissoesCasoNegocio(DocumentHTML document, HttpServletRequest request) throws Exception {
		permissao = new Permissoes(document, request, PagesPortfolio.SERVICO_NEGOCIO_CASOS_NEGOCIO.getCaminho());
	}

	/**
	 * @author ibimon.morais
	 * @since 15/09/2015
	 */
	private void carregarDadosComboTipoDeAnexo(final DocumentHTML document, final HttpServletRequest request,
			final HttpServletResponse response) throws Exception {
		final HTMLSelect combo = document.getSelectById("campoSelect_uploadCasoDeNegocio");
		this.iniciarCombos(document, request, combo);
		for (final TipoAnexoCasoNegocio sit : TipoAnexoCasoNegocio.values()) {
			combo.addOption(sit.getIdentificador(), UtilI18N.internacionaliza(request, sit.getChave()));
		}
	}

	/**
	 * @author ibimon.morais
	 * @since 15/09/2015
	 */
	private void iniciarCombos(final DocumentHTML document, final HttpServletRequest request, final HTMLSelect combo) throws Exception {
		combo.removeAllOptions();
		combo.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecioneTipoDeAnexo"));
	}

	/**
	 * br.com.centralit.citcorpore.rh.ajaxForms.GerenciamentoPortfolioCasoNegocio.java_(#restore)
	 *
	 * @since 07/10/2015
	 * @author ibimon.morais
	 */
	public void restore(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final UsuarioDTO usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert("Sesso expirada! Favor efetuar logon novamente!");
			return;
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.GerenciamentoPortfolioCasoNegocio.java_(#restaurarAnexos)
	 *
	 * @since 20/10/2015
	 * @author ibimon.morais
	 */
	protected void restaurarAnexos(final HttpServletRequest request, final CasoNegocioDTO dto, final DocumentHTML document)
			throws ServiceException, Exception {
		Collection<UploadDTO> colAnexosUploadDTO = null;
		final ControleGEDService controleGedService = (ControleGEDService) ServiceLocator.getInstance().getService(
				ControleGEDService.class, null);
		final Collection<ControleGEDDTO> colAnexos = controleGedService.listByIdTabelaAndID(ControleGEDDTO.TABELA_BUSINESS_CASE, dto.getIdCasoNegocio());
		if (colAnexos != null && !colAnexos.isEmpty()) {
			colAnexosUploadDTO = controleGedService.convertListControleGEDToUploadDTO(colAnexos);
			this.definirDescricaoAnexos(request, colAnexosUploadDTO);
			request.getSession(true).setAttribute(CampoUpload.UPLOADCASODENEGOCIO.getColUploadGED(), colAnexosUploadDTO);
		} else {
			request.getSession(true).setAttribute(CampoUpload.UPLOADCASODENEGOCIO.getColUploadGED(), null);
		}
		this.definirContadoresUploadCasoNegocio(document, colAnexosUploadDTO);
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.GerenciamentoPortfolioCasoNegocio.java_(#excluir)
	 *
	 * @since 22/10/2015
	 * @author ibimon.morais
	 */
	public void excluir(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		setPermissoesCasoNegocio(document, request);
		final CasoNegocioDTO beanDto = (CasoNegocioDTO) document.getBean();
		
		if(permissao.isDeletar()) {
			final ControleGEDService controleGedService = (ControleGEDService) ServiceLocator.getInstance().getService(
					ControleGEDService.class, null);
			final Collection<?> colAnexos = controleGedService.listByIdTabelaAndID(ControleGEDDTO.TABELA_BUSINESS_CASE,
					beanDto.getIdCasoNegocio());
	
			if (colAnexos != null && !colAnexos.isEmpty()) {
				document.alert(UtilI18N.internacionaliza(request, "gerenciaportfolio.businessCase.docsEmAnexo"));
				return;
			}
	
			beanDto.setDataFim(UtilDatas.getDataAtual());
			this.getService().update(beanDto);
			document.alert(UtilI18N.internacionaliza(request, "MSG07"));
			document.executeScript("limparCasoDeNegocio();");
			request.getSession(true).setAttribute(CampoUpload.UPLOADCASODENEGOCIO.getColUploadGED(), null);
			document.executeScript("uploadCasoDeNegocio.refresh();");
			this.definirServicoSelecionadoNaPagina(beanDto, document);
			beanDto.setAcaoCasoNegocioOcorrenciaServico(AuditoriaAcoes.EXCLUIDO.getIdentificador());
			this.salvarOcorrenciaServicoCasoNegocio(document, request, response);
		} else {
			document.executeScript("notificacaoErro('citcorpore.comum.permissaoFuncionalidade');");
		}
	}

	/**
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	public void salvarOcorrenciaServicoCasoNegocio(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		 CasoNegocioDTO casoNegocioDTO = (CasoNegocioDTO) document.getBean();
		 GerenciamentoPortfolioOcorrenciasServico gerenciamentoPortfolioOcorrenciasServico = new GerenciamentoPortfolioOcorrenciasServico();
		 gerenciamentoPortfolioOcorrenciasServico.salvaOcorrenciaServicoCasoNegocio(casoNegocioDTO, document, request);
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.GerenciamentoPortfolioCasoNegocio.java_(#definirDescricaoAnexos)
	 *
	 * @since 20/10/2015
	 * @author ibimon.morais
	 */
	private void definirDescricaoAnexos(final HttpServletRequest request, final Collection<UploadDTO> colAnexosUploadDTO) {
		if (colAnexosUploadDTO != null) {
			for (final UploadDTO uploadDTO : colAnexosUploadDTO) {
				if (uploadDTO.getDescricao() == null) {
					uploadDTO.setDescricao("");
				} else {
					final String descricao = UtilI18N.internacionaliza(request, TipoAnexoCasoNegocio.fromTipo(uploadDTO.getDescricao())
							.getChave());
					uploadDTO.setTipoAnexoParaCombo(descricao);
				}
			}
		}
	}

	/**
	 * br.com.centralit.citcorpore.rh.ajaxForms.GerenciamentoPortfolioCasoNegocio.java_(#save)
	 *
	 * @since 07/10/2015
	 * @author ibimon.morais
	 */
	@SuppressWarnings({ "unchecked", "unused" })
	public void save(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		setPermissoesCasoNegocio(document, request);
		CasoNegocioDTO beanDto = (CasoNegocioDTO) document.getBean();
		if(permissao.isGravar()) {
			try {
				final Collection<UploadDTO> arquivosGED = (Collection<UploadDTO>) request.getSession(true).getAttribute(
						CampoUpload.UPLOADCASODENEGOCIO.getColUploadGED());
				beanDto.setColsUploadGED(arquivosGED);
				final HTMLElement element = document.getElementById("descUpload_uploadCasoDeNegocio");
				final Map<String, String> mapValores = element.getDocument().getValuesForm();
				final String mensagemRetorno = this.montarMensagemDaAcao(beanDto);
	
				if (beanDto != null && beanDto.getIdCasoNegocio() != null) {
					beanDto.setAcaoCasoNegocioOcorrenciaServico(AuditoriaAcoes.ALTERADO.getIdentificador());
				} else {
					beanDto.setAcaoCasoNegocioOcorrenciaServico(AuditoriaAcoes.CRIADO.getIdentificador());
				}
	
				// Salvando
				beanDto = this.getService().salvar(beanDto);
	
				if (beanDto.getIdCasoNegocio() != null) {
					this.salvarListaArquivosAdicionadosCasoNegocio(arquivosGED, document);
					this.salvarOcorrenciaServicoCasoNegocio(document, request, response);
					document.alert(UtilI18N.internacionaliza(request, mensagemRetorno));
					this.definirValoresDosCamposNoFormulario(document, beanDto);
				}
	
				this.fecharFormulario(document, request, beanDto, response);
			} catch (final Exception e) {
				e.printStackTrace();
			}
		} else {
			document.executeScript("notificacaoErro('citcorpore.comum.permissaoFuncionalidade');");
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.GerenciamentoPortfolioCasoNegocio.java_(#montarMensagemDaAcao)
	 *
	 * @since 21/10/2015
	 * @author ibimon.morais
	 */
	private String montarMensagemDaAcao(final CasoNegocioDTO beanDto) {
		String mensagemRetorno = "MSG05";
		if (beanDto != null && beanDto.getIdCasoNegocio() != null) {
			mensagemRetorno = "MSG06";
		}
		return mensagemRetorno;
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.GerenciamentoPortfolioCasoNegocio.java_(#fecharFormulario)
	 *
	 * @since 20/10/2015
	 * @author ibimon.morais
	 * @throws Exception
	 * @throws ServiceException
	 */
	private void fecharFormulario(final DocumentHTML document, final HttpServletRequest request, final CasoNegocioDTO beanDto,
			final HttpServletResponse response) throws ServiceException, Exception {
		document.executeScript("JANELA_AGUARDE_MENU.hide();");
		document.executeScript("abrirAbaCasoNegocio();");
		this.load(document, request, response);
		this.restaurarAnexos(request, beanDto, document);
		document.executeScript("uploadCasoDeNegocio.refresh();");
		final HTMLForm form = document.getForm("formCasoNegocio");
		form.setValue("idCasoNegocio", beanDto.getIdCasoNegocio());
		form.setValue("idServico", beanDto.getIdServico());
	}

	/**
	 * br.com.centralit.citcorpore.rh.ajaxForms.GerenciamentoPortfolioCasoNegocio.java_(#restoreCasoDeNegocio)
	 *
	 * @since 07/10/2015
	 * @author ibimon.morais
	 */
	private void restoreCasoDeNegocio(CasoNegocioDTO casoNegocioDTO, final DocumentHTML document, final HttpServletRequest request)
			throws Exception {
		try {
			final Collection<CasoNegocioDTO> listaCasoNegocio = this.getService().findByIdServico(casoNegocioDTO.getIdServico());

			if (listaCasoNegocio != null && !listaCasoNegocio.isEmpty()) {
				casoNegocioDTO = listaCasoNegocio.iterator().next();
			}

			this.restaurarAnexos(request, casoNegocioDTO, document);
			this.definirValoresDosCamposNoFormulario(document, casoNegocioDTO);
		} catch (PersistenceException | ServiceException e) {
			e.printStackTrace();
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.GerenciamentoPortfolioCasoNegocio.java_(#setandoValoresNoFormulario)
	 *
	 * @since 13/10/2015
	 * @author ibimon.morais
	 */
	private void definirValoresDosCamposNoFormulario(final DocumentHTML document, final CasoNegocioDTO casoNegocioDTO) throws Exception {
		final HTMLForm form = document.getForm("formCasoNegocio");
		// Setando o formulario para impressao na tela
		form.setValues(casoNegocioDTO);
		this.definirServicoSelecionadoNaPagina(casoNegocioDTO, document);
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.GerenciamentoPortfolioCasoNegocio.java_(#definirServicoSelecionadoNaPagina)
	 *
	 * @since 09/10/2015
	 * @author ibimon.morais
	 */
	private void definirServicoSelecionadoNaPagina(final CasoNegocioDTO dto, final DocumentHTML document) {
		// Setando o id do servico selecionado no(s) caso de negocio a serem consultados pel mesmo
		document.executeScript("document.formCasoNegocio.idServico.value = ".concat(String.valueOf(dto.getIdServico())));
		document.executeScript("document.formCasoNegocio.btnLimpar.style.display = 'block';");
		document.executeScript("document.formCasoNegocio.btnRelatorio.style.display = 'none';");
		document.executeScript("document.formCasoNegocio.btnUpDate.style.display = 'none';");
		if (dto.getIdCasoNegocio() != null && dto.getDataFim() == null) {
			document.executeScript("document.formCasoNegocio.btnLimpar.style.display = 'none';");
			document.executeScript("document.formCasoNegocio.btnRelatorio.style.display = 'block';");
			document.executeScript("document.formCasoNegocio.btnUpDate.style.display = 'block';");
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.GerenciamentoPortfolioCasoNegocio.java_(#definirContadoresUploadCasoNegocio)
	 *
	 * @since 22/10/2015
	 * @author ibimon.morais
	 */
	private void definirContadoresUploadCasoNegocio(final DocumentHTML document, final Collection<UploadDTO> anexos) throws Exception {
		final List<String> listaTipoAnexo = new ArrayList<String>();
		final Map<String, TipoAnexoCasoNegocio> mapColunas = this.montarMapaColunas();
		// Gerando lista de descricoes
		this.gerarListaDescricao(anexos, listaTipoAnexo);
		final Map<String, Integer> tipoAnexoQuantidade = UtilListas.agrupaDuplicadosComQtde(listaTipoAnexo);
		// Montando as funcoes executadas nas tags onde existem downloads
		this.montarFuncoesNasTags(document, mapColunas, tipoAnexoQuantidade);
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.GerenciamentoPortfolioCasoNegocio.java_(#montarMapaColunas)
	 *
	 * @since 23/10/2015
	 * @author ibimon.morais
	 */
	private Map<String, TipoAnexoCasoNegocio> montarMapaColunas() {
		final Map<String, TipoAnexoCasoNegocio> mapColunas = new HashMap<String, TipoAnexoCasoNegocio>();
		mapColunas.put("descricaoSumarioExecutivoLabel", TipoAnexoCasoNegocio.DESCRICAO_SUMARIO_EXECUTIVO);
		mapColunas.put("descricaoCenariosLabel", TipoAnexoCasoNegocio.CENARIOS);
		mapColunas.put("descricaoProblemaOportunidadeLabel", TipoAnexoCasoNegocio.PROBLEMA_OPORTUNIDADE);
		mapColunas.put("descricaoPropostaSolucaoLabel", TipoAnexoCasoNegocio.PROPOSTA_SOLUCAO);
		mapColunas.put("descricaoAnaliseFinanceiraLabel", TipoAnexoCasoNegocio.ANALISE_FINANCEIRA);
		mapColunas.put("descricaoAnaliseRiscoLabel", TipoAnexoCasoNegocio.ANALISE_RISCO);
		mapColunas.put("descricaoViabilidadeTecnicaLabel", TipoAnexoCasoNegocio.VIABILIDADE_TECNICA);
		mapColunas.put("descricaoConclusaoLabel", TipoAnexoCasoNegocio.CONCLUSAO);
		return mapColunas;
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.GerenciamentoPortfolioCasoNegocio.java_(#montarFuncoesNasTags)
	 *
	 * @since 23/10/2015
	 * @author ibimon.morais
	 */
	private void montarFuncoesNasTags(final DocumentHTML document, final Map<String, TipoAnexoCasoNegocio> mapColunas,
			final Map<String, Integer> tipoAnexoQuantidade) throws Exception {
		for (final String key : mapColunas.keySet()) {
			HTMLElement elemento = document.getElementById(key);
			elemento = document.getElementById(key);
			this.setQuantidadeElemento(tipoAnexoQuantidade, mapColunas.get(key), elemento);
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.GerenciamentoPortfolioCasoNegocio.java_(#setQuantidadeElemento)
	 *
	 * @since 23/10/2015
	 * @author ibimon.morais
	 */
	private void setQuantidadeElemento(final Map<String, Integer> tipoAnexoQuantidade, final Object tipoAnexoObj, final HTMLElement elemento) {
		final TipoAnexoCasoNegocio tipoAnexo = (TipoAnexoCasoNegocio) tipoAnexoObj;
		final Integer valor = tipoAnexoQuantidade.get(tipoAnexo.getIdentificador());

		if (valor != null && valor > 0) {
			elemento.setValue("<i class=\"lfloat material-icons md-14\">attachment</i>&nbsp".concat(String.valueOf(valor)));
			elemento.setClassName("rfloat label label-success");
			elemento.setAttributes("onmouseover", "abreTooltip(this, \"citcorpore.comum.quantidadeAnexos\")");
		} else {
			elemento.setValue("<i class=\"material-icons md-14\">attach_file</i>");
			elemento.setClassName("rfloat label label-warning");
			elemento.setAttributes("onmouseover", "abreTooltip(this, \"citcorpore.comum.adicionarAnexos\")");
		}

		elemento.setAttributes("onclick", "onClickLabelAnexos(\"".concat(tipoAnexo.getIdentificador()).concat("\")"));
		elemento.setAttributes("onmouseout", "fechaTooltip()");
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.GerenciamentoPortfolioCasoNegocio.java_(#gerarListaDescricao)
	 *
	 * @since 23/10/2015
	 * @author ibimon.morais
	 */
	private void gerarListaDescricao(final Collection<UploadDTO> anexos, final List<String> listaTipoAnexo) {
		if (anexos == null) {
			return;
		}
		for (final UploadDTO up : anexos) {
			listaTipoAnexo.add(up.getDescricao());
		}
	}

	// ------------- RELATORIO----------
	/**
	 * br.com.centralit.citcorpore.ajaxForms.GerenciamentoPortfolioCasoNegocio.java_(#gerarRelatorio)
	 *
	 * @since 23/10/2015
	 * @author ibimon.morais
	 */
	public void gerarRelatorio(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) {
		final CasoNegocioDTO dto = (CasoNegocioDTO) document.getBean();
		final UsuarioDTO usuario = WebUtil.getUsuario(request);

		try {
			if (dto == null || dto.getIdCasoNegocio() == null || dto.getIdCasoNegocio().intValue() == 0) {
				document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
				return;
			}
			if (!this.validarUsuario(document, request, usuario)) {
				document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
				return;
			}
			dto.setListaParaImpressao(this.pesquisarDadosParaImpressao(document, request, response, dto));
			this.controlarImpressaoDoRelatorio(dto, usuario, document, request, response);
			document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
		} catch (final Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.GerenciamentoPortfolioCasoNegocio.java_(#pesquisarDadosParaImpressao)
	 *
	 * @since 23/10/2015
	 * @author ibimon.morais
	 */
	private Collection<CasoNegocioDTO> pesquisarDadosParaImpressao(final DocumentHTML document, final HttpServletRequest request,
			final HttpServletResponse response, final CasoNegocioDTO dto) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		Collection<CasoNegocioDTO> listaDeCasosDeNegocio = new ArrayList<CasoNegocioDTO>(0);
		listaDeCasosDeNegocio = this.getService().findByIdServico(dto.getIdServico());
		return listaDeCasosDeNegocio;
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.GerenciamentoPortfolioCasoNegocio.java_(#controlarImpressaoDoRelatorio)
	 *
	 * @since 23/10/2015
	 * @author ibimon.morais
	 */
	private void controlarImpressaoDoRelatorio(final CasoNegocioDTO dto, final UsuarioDTO usuario, final DocumentHTML document,
			final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		final Date dt = new Date();

		final String strMiliSegundos = Long.toString(dt.getTime());
		final String caminhoJasper = CITCorporeUtil.CAMINHO_REAL_APP.concat(Constantes.getValue("CAMINHO_RELATORIOS"));
		final String diretorioTemp = CITCorporeUtil.CAMINHO_REAL_APP.concat("/tempFiles");
		final String diretorioRelativo = Constantes.getValue("SERVER_ADDRESS").concat(Constantes.getValue("CONTEXTO_APLICACAO"))
				.concat("/tempFiles");
		final String arquivoRelatorio = "/".concat(JASPER_ARQ_REL).concat(strMiliSegundos).concat("_")
				.concat(usuario.getIdUsuario().toString());

		this.contralarDadosParaImpressao(dto, document, request, response, JASPER_ARQ_REL, caminhoJasper, diretorioTemp, diretorioRelativo,
				arquivoRelatorio, usuario);
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.GerenciamentoPortfolioCasoNegocio.java_(#contralarDadosParaImpressao)
	 *
	 * @since 23/10/2015
	 * @author ibimon.morais
	 */
	private void contralarDadosParaImpressao(final CasoNegocioDTO dto, final DocumentHTML document, final HttpServletRequest request,
			final HttpServletResponse response, final String jasperArqRel, final String caminhoJasper, final String diretorioTemp,
			final String diretorioRelativo, final String arquivoRelatorio, final UsuarioDTO usuario) throws ServiceException, Exception {

		final Map<String, Object> parametros = this.gerarParametros(dto, usuario, document, request, response);
		final List<CasoNegocioDTO> listaParaDataSource = new ArrayList<CasoNegocioDTO>();
		listaParaDataSource.add(dto);
		final JRDataSource dataSource = new JRBeanCollectionDataSource(listaParaDataSource);

		this.imprimirRelatorioEmPDF(dataSource, parametros, diretorioTemp, caminhoJasper, jasperArqRel, diretorioRelativo,
				arquivoRelatorio, document, request, response);
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.GerenciamentoPortfolioCasoNegocio.java_(#imprimirRelatorioEmPDF)
	 *
	 * @since 23/10/2015
	 * @author ibimon.morais
	 */
	private void imprimirRelatorioEmPDF(final JRDataSource dataSource, final Map<String, Object> parametros, final String diretorioTemp,
			final String caminhoJasper, final String jasperArqRel, final String diretorioRelativo, final String arquivoRelatorio,
			final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) {
		try {
			final JRSwapFile arquivoSwap = new JRSwapFile(diretorioTemp, 4096, 25);
			final JRAbstractLRUVirtualizer virtualizer = new JRSwapFileVirtualizer(25, arquivoSwap, true);
			parametros.put(JRParameter.REPORT_VIRTUALIZER, virtualizer);
			final JasperPrint print = JasperFillManager.fillReport(caminhoJasper.concat(jasperArqRel).concat(".jasper"), parametros,
					dataSource);
			JasperExportManager.exportReportToPdfFile(print, diretorioTemp.concat(arquivoRelatorio).concat(".pdf"));
			this.executaScriptPosImpressao(diretorioRelativo, arquivoRelatorio, document);
		} catch (final OutOfMemoryError e) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.erro.erroServidor"));
		} catch (final JRException e) {
			e.printStackTrace();
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.GerenciamentoPortfolioCasoNegocio.java_(#executaScriptPosImpressao)
	 *
	 * @since 23/10/2015
	 * @author ibimon.morais
	 */
	private void executaScriptPosImpressao(final String diretorioRelativo, final String arquivoRelatorio, final DocumentHTML document) {
		document.executeScript("window.open('".concat(Constantes.getValue("SERVER_ADDRESS"))
				.concat(Constantes.getValue("CONTEXTO_APLICACAO")).concat("/printPDF/printPDF.jsp?url=").concat(diretorioRelativo)
				.concat(arquivoRelatorio).concat(".pdf')"));
	}

	/*------------------- TRATAMENTO DE PARAMETROS DO RELATORIO -------------------------------------*/
	/**
	 * br.com.centralit.citcorpore.ajaxForms.GerenciamentoPortfolioCasoNegocio.java_(#gerarParametros)
	 *
	 * @since 23/10/2015
	 * @author ibimon.morais
	 */
	private Map<String, Object> gerarParametros(final CasoNegocioDTO dtoRel, final UsuarioDTO usuario, final DocumentHTML document,
			final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		final HttpSession session = request.getSession();
		Map<String, Object> parametros = new HashMap<String, Object>();
		parametros = this.definirLabelsEValoresEstruturaisDoRelatorio(usuario, request, session, parametros);
		this.definirLabelsColunasRelatorio(request, parametros);
		return parametros;
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.GerenciamentoPortfolioCasoNegocio.java_(#definirLabelsEValoresEstruturaisDoRelatorio)
	 *
	 * @since 23/10/2015
	 * @author ibimon.morais
	 */
	private Map<String, Object> definirLabelsEValoresEstruturaisDoRelatorio(final UsuarioDTO usuario, final HttpServletRequest request,
			final HttpSession session, Map<String, Object> parametros) {
		parametros = UtilRelatorio.trataInternacionalizacaoLocale(session, parametros);
		parametros.put("TITULO_RELATORIO", UtilI18N.internacionaliza(request, "gerenciaportfolio.businessCase.relatorio.titulo"));
		parametros.put("CIDADE", UtilI18N.internacionaliza(request, "citcorpore.comum.relatorioCidade"));
		parametros.put("DATA_HORA", UtilDatas.getDataHoraAtual());
		parametros.put("NOME_USUARIO", usuario != null ? usuario.getNomeUsuario() : "-");
		parametros.put("Logo", LogoRel.getFile());
		parametros.put("SUBREPORT_DIR", CITCorporeUtil.CAMINHO_REAL_APP + Constantes.getValue("CAMINHO_RELATORIOS"));
		return parametros;
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.GerenciamentoPortfolioCasoNegocio.java_(#definirLabelsColunasRelatorio)
	 *
	 * @since 23/10/2015
	 * @author ibimon.morais
	 */
	private void definirLabelsColunasRelatorio(final HttpServletRequest request, final Map<String, Object> parametros) {
		// Montando os labels que sero apresentados no relatorio.
		parametros.put("labelSumario", UtilI18N.internacionaliza(request, "gerenciaportfolio.businessCase.sumario"));
		parametros
				.put("labelStakeholderEntidade", UtilI18N.internacionaliza(request, "gerenciaportfolio.businessCase.StakeholderEntidade"));
		parametros.put("labelCenarios", UtilI18N.internacionaliza(request, "gerenciaportfolio.businessCase.cenarios"));
		parametros.put("labelProblemaOportunidade",
				UtilI18N.internacionaliza(request, "gerenciaportfolio.businessCase.problemaOportunidade"));
		parametros.put("labelPropostaSolucao", UtilI18N.internacionaliza(request, "gerenciaportfolio.businessCase.propostaSolucao"));
		parametros.put("labelAnaliseFinanceira", UtilI18N.internacionaliza(request, "gerenciaportfolio.businessCase.analiseFinanceira"));
		parametros.put("labelAnaliseRisco", UtilI18N.internacionaliza(request, "gerenciaportfolio.businessCase.analiseRisco"));
		parametros.put("labelViabilidadeTecnica", UtilI18N.internacionaliza(request, "gerenciaportfolio.businessCase.viabilidadeTecnica"));
		parametros.put("labelConclusao", UtilI18N.internacionaliza(request, "gerenciaportfolio.businessCase.conclusao"));
	}

	/*------------------- FIM DO TRATAMENTO DE PARAMETROS DO RELATORIO ------------------------------*/
	/**
	 * br.com.centralit.citcorpore.ajaxForms.GerenciamentoPortfolioCasoNegocio.java_(#validarUsuario)
	 *
	 * @since 23/10/2015
	 * @author ibimon.morais
	 */
	private boolean validarUsuario(final DocumentHTML document, final HttpServletRequest request, final UsuarioDTO usuario) {
		boolean retorno = Boolean.TRUE;
		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '".concat(Constantes.getValue("SERVER_ADDRESS")).concat(request.getContextPath())
					.concat("'"));
			retorno = Boolean.FALSE;
		}
		return retorno;
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.GerenciamentoPortfolioCasoNegocio.java_(#getService)
	 *
	 * @since 20/10/2015
	 * @author ibimon.morais
	 */
	private CasoNegocioService getService() throws ServiceException {
		if (this.service == null) {
			this.service = (CasoNegocioService) ServiceLocator.getInstance().getService(CasoNegocioService.class, null);
		}
		return this.service;
	}

	/**
	 * @author deborah.ferreira
	 * @since 19.02.2016
	 */
	private void salvarListaArquivosAdicionadosCasoNegocio(Collection<UploadDTO> listaArquivos, DocumentHTML document) throws Exception {
		CasoNegocioDTO casoNegocioDTO = (CasoNegocioDTO) document.getBean();
		String listaIdsStr = "";

		if (listaArquivos != null) {
			for (UploadDTO anexo : listaArquivos) {
				if (anexo.getTemporario().toUpperCase().equals("S")) {
					if (anexo.getIdControleGED() != null) {
						listaIdsStr += anexo.getIdControleGED() + ",";
					}
				}
			}
		}

		casoNegocioDTO.setListaIdsAnexosCasoNegocioOcorrenciaServico(listaIdsStr);
	}

}
