package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioConhecimentoDTO;
import br.com.centralit.citcorpore.bean.HistoricoBaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.ServicoBaseConhecimentoDTO;
import br.com.centralit.citcorpore.negocio.HistoricoBaseConhecimentoService;
import br.com.centralit.citcorpore.negocio.ServicoBaseConhecimentoService;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;

/**
 * @since 29.01.2016
 * @author gustavo.gomes
 */
public class GerenciamentoPortfolioConhecimento extends AjaxFormAction {

	private ServicoBaseConhecimentoService conhecimentoService;
	private HistoricoBaseConhecimentoService historicoBaseConhecimentoService;
	private static Permissoes permissao;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioConhecimentoDTO beanDto = (GerenciamentoPortfolioConhecimentoDTO) document.getBean();
		permissao = new Permissoes(document, request, "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioConhecimento/gerenciamentoPortfolioConhecimento.jsp");

		if (beanDto != null && !UtilNumbersAndDecimals.isNull(beanDto.getIdServico())) {
			this.restauraConhecimentos(document, request, response);
		}
	}

	public void restauraConhecimentos(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		try{
			HTMLElement divListaConhecimentos = document.getElementById("divDinamicoTabelaConhecimento");
			StringBuilder sb = new StringBuilder();
			ServicoBaseConhecimentoService vinculoService = this.getServicoBaseConhecimentoService();
			GerenciamentoPortfolioConhecimentoDTO conhecimentos = (GerenciamentoPortfolioConhecimentoDTO)document.getBean();
			Collection<ServicoBaseConhecimentoDTO> vinculos = vinculoService.findConhecimentosByServico(conhecimentos.getIdServico(), conhecimentos.getFiltroConhecimento());

			if(vinculos==null || vinculos.isEmpty()){
				sb.append("<h4>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nenhumConhecimentoVinculado") + "</h4>");
			}else{
				sb.append(geraHtmlCabecalhoTabela(request));
				sb.append(geraHtmlDadosTabela(document, request, vinculos));
				sb.append(geraHTMLFinalTabela());
			}
			divListaConhecimentos.setInnerHTML(sb.toString());
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
		}catch(Exception e){
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
			e.printStackTrace();
			document.alert(UtilI18N.internacionaliza(request, "MSE02"));
		}
	}

	private String geraHtmlCabecalhoTabela(HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		sb.append("<div class='row-fluid' id='tabelaConhecimentos'> ");
		sb.append("	<div class=\"table-responsive tabela\">");
		sb.append("		<table class=\"table table-bordered table-striped table-condensed table-vertical-center checkboxs js-table-sortable ui-sortable\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.id") + "</th> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.titulo") + "</th> ");
		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.acoes") + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody> ");

		return sb.toString();
	}

	private String geraHtmlDadosTabela(DocumentHTML document, HttpServletRequest request, Collection<ServicoBaseConhecimentoDTO> vinculos) throws Exception {

		StringBuilder sb = new StringBuilder();

		for(ServicoBaseConhecimentoDTO vinculo: vinculos){
			sb.append("		<tr>");
			sb.append("			<td class=\"center\">" + vinculo.getIdServicoBaseConhecimento() + "</td> ");
				HistoricoBaseConhecimentoDTO base = new HistoricoBaseConhecimentoDTO();
				base.setIdBaseConhecimento(vinculo.getIdBaseConhecimento());;
				base = this.getHistoricoBaseConhecimentoService().restoreHistoricoFromIdBaseConhecimento(base);
				if(base.getTitulo()!=null) {
					sb.append("			<td>" + base.getTitulo() + "</td> ");
				} else {
					sb.append("			<td>" + " " + "</td> ");
				}

			sb.append("			<td class=\"center\" style=\"width: 90px;\"> ");
			if (permissao.isGravar()) {
				sb.append("				<a onmouseout=\"fechaTooltip()\" onmouseover=\"abreTooltip(this, 'gerenciaportfolio.DesvincularConhecimento')\" onclick=\"desvincularConhecimento('"
						+ vinculo.getIdServicoBaseConhecimento() + "','" + vinculo.getIdBaseConhecimento() + "');\" class=\"btn-action glyphicons remove_2 btn-default\"><i></i></a>");
			}
			sb.append("			</td> ");
			sb.append("		</tr> ");
		}
		return sb.toString();
	}

	private String geraHTMLFinalTabela() {
		StringBuilder sb = new StringBuilder();
		sb.append("			</tbody> ");
		sb.append("		</table>");
		sb.append("	</div>");
		sb.append("</div>");
		sb.append("<div class='row-fluid'> ");
		sb.append("	<div id=\"paginacaoConhecimento\" class=\"divPaginacao\"></div>");
		sb.append("</div>");

		return sb.toString();
	}

	public void vincularBaseConhecimento(String conhecimentos, Integer idServico, DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		try{
			if(conhecimentos.isEmpty()){
				document.executeScript("JANELA_AGUARDE_MENU.hide();");
				document.alert("gerenciaportfolio.selecioneNovos");
				return;
			}

			String[] conhecimentosList = conhecimentos.split(";");
			List<String> idsVinculadosStr = new ArrayList<String>();

			if (idServico > 0 && conhecimentosList != null && conhecimentosList.length > 0) {
				for (String idConhecimentoStr : conhecimentosList) {
					ServicoBaseConhecimentoDTO vinculo = new ServicoBaseConhecimentoDTO();
					vinculo.setIdServico(idServico);
					vinculo.setIdBaseConhecimento(Integer.parseInt(idConhecimentoStr));
					this.getServicoBaseConhecimentoService().create(vinculo);
					idsVinculadosStr.add(idConhecimentoStr);
				}

				this.salvarOcorrenciaServicoBaseConhecimentoVinculados(idsVinculadosStr.toString(), document, request);
				this.restauraConhecimentos(document, request, response);
				document.executeScript("JANELA_AGUARDE_MENU.hide();");
				document.executeScript("Modal.close('modal-portfolio-vincular-base-conhecimento');");
				document.executeScript("notificacao('" + UtilI18N.internacionaliza(request, "gerenciaportfolio.conhecimentoVinculadoSucesso") + "', '')");
			}
		}catch(Exception e){
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
			e.printStackTrace();
			document.alert(UtilI18N.internacionaliza(request, "MSE02"));
		}

	}


	public void adicionaTabelaLOOKUP_SERVICO_BASECONHECIMENTO(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		try{
			document.executeScript("JANELA_AGUARDE_MENU.show();");
			WebUtil.validarSeUsuarioEstaNaSessao(request, document);
			GerenciamentoPortfolioConhecimentoDTO gerenciamentoPortfolioConhecimentoDto = (GerenciamentoPortfolioConhecimentoDTO) document.getBean();
			if (gerenciamentoPortfolioConhecimentoDto != null && gerenciamentoPortfolioConhecimentoDto.getIdServico() != null
					&& gerenciamentoPortfolioConhecimentoDto.getColAllLOOKUP_SERVICO_BASECONHECIMENTO() != null) {
				Integer idServico = gerenciamentoPortfolioConhecimentoDto.getIdServico();
				String listaProprietarios = gerenciamentoPortfolioConhecimentoDto.getColAllLOOKUP_SERVICO_BASECONHECIMENTO();
				if(permissao.isGravar()){
					this.vincularBaseConhecimento(listaProprietarios, idServico, document, request, response);
				}else{
					document.executeScript("notificacaoErro('citcorpore.comum.naoFoiPossivelVincular','citcorpore.comum.usuarioSemPermissao')");
					document.executeScript("JANELA_AGUARDE_MENU.hide();");
				}
			}else{
				document.executeScript("JANELA_AGUARDE_MENU.hide();");
			}
		}catch(Exception e){
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
			e.printStackTrace();
			document.alert(UtilI18N.internacionaliza(request, "MSE02"));
		}
		document.executeScript("$(\"#POPUP_USUARIO\").dialog(\"close\");");
	}


	public void desvincularConhecimento(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) {
		try{
			GerenciamentoPortfolioConhecimentoDTO dto = (GerenciamentoPortfolioConhecimentoDTO) document.getBean();
			if (dto != null	&& dto.getIdServicoBaseConhecimento() != null) {
				this.getServicoBaseConhecimentoService().deletaVinculo(dto.getIdServicoBaseConhecimento());
				document.executeScript("notificacao('" + UtilI18N.internacionaliza(request, "gerenciaportfolio.conhecimentoDesvinculado") + "', '')");
				this.restauraConhecimentos(document, request, response);
				document.executeScript("JANELA_AGUARDE_MENU.hide();");
				dto.setAcaoBaseConhecimentoOcorrenciaServico(AuditoriaAcoes.DESVINCULADO.getIdentificador());
				this.salvarOcorrenciaServicoBaseConhecimento(dto, document, request);
			}

		}catch(Exception e){
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
			e.printStackTrace();
			document.alert(UtilI18N.internacionaliza(request, "MSE02"));
		}
	}


	private ServicoBaseConhecimentoService getServicoBaseConhecimentoService() throws Exception {
		if (conhecimentoService == null) {
			conhecimentoService = (ServicoBaseConhecimentoService) ServiceLocator.getInstance().getService(ServicoBaseConhecimentoService.class, null);
		}
		return conhecimentoService;
	}

	@Override
	public Class<GerenciamentoPortfolioConhecimentoDTO> getBeanClass() {
		return GerenciamentoPortfolioConhecimentoDTO.class;
	}

	/**
	 * @author deborah.ferreira
	 * @since 17.02.2016
	 */
	private void salvarOcorrenciaServicoBaseConhecimentoVinculados(String idsVinculadosStr, DocumentHTML document, HttpServletRequest request) throws Exception {
		GerenciamentoPortfolioConhecimentoDTO gerenciamentoPortfolioConhecimentoDTO = (GerenciamentoPortfolioConhecimentoDTO) document.getBean();
		gerenciamentoPortfolioConhecimentoDTO.setIdsBaseConhecimentoOcorrenciaServico(idsVinculadosStr.toString());
		gerenciamentoPortfolioConhecimentoDTO.setAcaoBaseConhecimentoOcorrenciaServico(AuditoriaAcoes.VINCULADO.getIdentificador());
		this.salvarOcorrenciaServicoBaseConhecimento(gerenciamentoPortfolioConhecimentoDTO, document, request);
	}

	/**
	 * @author deborah.ferreira
	 * @since 17.02.2016
	 */
	private void salvarOcorrenciaServicoBaseConhecimento(GerenciamentoPortfolioConhecimentoDTO gerenciamentoPortfolioConhecimentoDTO, DocumentHTML document, HttpServletRequest request)
			throws Exception {
		GerenciamentoPortfolioOcorrenciasServico gerenciamentoPortfolioOcorrenciasServico = new GerenciamentoPortfolioOcorrenciasServico();

		gerenciamentoPortfolioOcorrenciasServico.salvaOcorrenciaServicoBaseConhecimento(gerenciamentoPortfolioConhecimentoDTO.getIdServico(), gerenciamentoPortfolioConhecimentoDTO, document, request);
	}

	private HistoricoBaseConhecimentoService getHistoricoBaseConhecimentoService() throws ServiceException {
		if(historicoBaseConhecimentoService == null)
			historicoBaseConhecimentoService = (HistoricoBaseConhecimentoService) ServiceLocator.getInstance().getService(HistoricoBaseConhecimentoService.class, null);
		return historicoBaseConhecimentoService;
	}
	
}
