package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citcorpore.bean.ContratoDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioContratosDTO;
import br.com.centralit.citcorpore.bean.ServicoContratoDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.negocio.ContratoService;
import br.com.centralit.citcorpore.negocio.ServicoContratoService;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.centralit.citcorpore.util.Enumerados.PagesPortfolio;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.integracao.core.PageRequest;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;

public class GerenciamentoPortfolioContratos extends AjaxFormAction {

	private ContratoService contratoService;
	private ServicoContratoService servicoContratoService;
	private static Permissoes permissao;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		GerenciamentoPortfolioContratosDTO beanDto = (GerenciamentoPortfolioContratosDTO) document.getBean();
		setPermissaoContratos(document, request);

		if (beanDto != null && !UtilNumbersAndDecimals.isNull(beanDto.getIdServicoNegocioContrato())) {
			this.restoreServicoNegocioCarregaContratos(beanDto, document, request);
		}
	}

	private void setPermissaoContratos(DocumentHTML document, HttpServletRequest request) {
		permissao = new Permissoes(document, request, PagesPortfolio.SERVICO_NEGOCIO_CONTRATO.getCaminho());
	}

	/**
	 * Mtodo chamado aps avanar o contrato. Vrios outros dados so
	 * restaurados.
	 *
	 * @throws Exception
	 * @author rodrigo.dorighello
	 * @since 24.09.2015
	 */
	public void restoreDemaisDadosContrato(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioContratosDTO gerenciamentoPortfolioContratosDto = (GerenciamentoPortfolioContratosDTO) document.getBean();

		// Vinculo de servios de requisio e de incidente com o contrato
		try {
			GerenciamentoPortfolioVinculoServicoContrato gerenciamentoPortfolioVinculoServicoContrato = new GerenciamentoPortfolioVinculoServicoContrato();
			gerenciamentoPortfolioVinculoServicoContrato.avancarContrato(gerenciamentoPortfolioContratosDto, document, request, response);
		} catch (Exception e) {
			e.printStackTrace();
		}

		ServicoContratoDTO servicoContratoDTO = getServicoContratoService().findByIdServicoContrato(gerenciamentoPortfolioContratosDto.getIdServicoNegocioContrato(), gerenciamentoPortfolioContratosDto.getIdContrato());
		document.executeScript("$('.breadcrumb li.breadCrumbContrato').attr('data-idservicocontrato', " + servicoContratoDTO.getIdServicoContrato() + ");");
	}


	/**
	 * Mtodo chamado aps o restore do servio de negcio, j que os contratos
	 * dependem de um servio de negcio estar selecionado.
	 *
	 * @throws Exception
	 * @author rodrigo.dorighello
	 * @since 16.09.2015
	 */
	private void restoreServicoNegocioCarregaContratos(GerenciamentoPortfolioContratosDTO gerenciamentoPortfolioDto, DocumentHTML document, HttpServletRequest request) throws Exception {
		if (gerenciamentoPortfolioDto != null && gerenciamentoPortfolioDto.getIdServicoNegocioContrato() != null) {
			gerenciamentoPortfolioDto.setPaginaSelecionadaContrato(1);
			gerenciamentoPortfolioDto.setFiltroContrato("");

			HTMLForm form = document.getForm("formCadastroContrato");
			form.setValues(gerenciamentoPortfolioDto);

			geraTabelaContratos(gerenciamentoPortfolioDto, document, request);
		}

	}

	/**
	 * Mtodo chamado no javascript, pegar o DTO do bean e gerar a tabela de
	 * contratos.
	 *
	 * @throws Exception
	 * @author rodrigo.dorighello
	 * @since 16.09.2015
	 */
	public void carregaTabelaContratos(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioContratosDTO gerenciamentoPortfolioDto = (GerenciamentoPortfolioContratosDTO) document.getBean();

		geraTabelaContratos(gerenciamentoPortfolioDto, document, request);

	}

	/**
	 * Mtodo para a gerao da tabela de contratos
	 *
	 * @throws Exception
	 * @author rodrigo.dorighello
	 * @since 15.09.2015
	 */
	public void geraTabelaContratos(GerenciamentoPortfolioContratosDTO gerenciamentoPortfolioDto, DocumentHTML document, HttpServletRequest request) throws Exception {

		String filtro = gerenciamentoPortfolioDto.getFiltroContrato();
		if (filtro == null) {
			filtro = "";
		}

		Integer itensPorPagina = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANT_RETORNO_PESQUISA, "10"));

		Integer paginaSelecionadaContrato = gerenciamentoPortfolioDto.getPaginaSelecionadaContrato();
		if (paginaSelecionadaContrato == null || paginaSelecionadaContrato == 0) {
			paginaSelecionadaContrato = 1;
		}

		Pageable pageable = new PageRequest(paginaSelecionadaContrato - 1, itensPorPagina);

		Collection<ContratoDTO> colContrato = this.getContratoService().listAtivosByIdServicoAndFiltro(gerenciamentoPortfolioDto.getIdServicoNegocioContrato(), filtro, pageable, false).getContent();

		Integer totalPaginasContratos = this.getContratoService().listAtivosByIdServicoAndFiltro(gerenciamentoPortfolioDto.getIdServicoNegocioContrato(), filtro, pageable, true).getTotalPages();

		HTMLElement divTabelaPortfolio = document.getElementById("divDinamicoTabelaContratos");

		StringBuilder sb = new StringBuilder();

		if (colContrato.size() > 0) {
			sb.append(geraHtmlCabecalhoTabela(request));

			for (Iterator<ContratoDTO> iterator = colContrato.iterator(); iterator.hasNext();) {
				ContratoDTO contratoDto = iterator.next();

				sb.append(geraHtmlDadosTabela(contratoDto.getIdContrato(), contratoDto.getNumero(), contratoDto.getRazaoSocialCliente(), contratoDto.getRazaoSocialFornecedor(), document, request));
			}

			sb.append(geraHTMLFinalTabela());
			divTabelaPortfolio.setInnerHTML(sb.toString());

			try {
				HTMLElement paginacaoContrato = document.getElementById("paginacaoContrato");
				String funcaoJsPaginarContratos = "paginarContratos";
				paginacaoContrato.setInnerHTML(UtilHTML.paginacaoHtml(request, funcaoJsPaginarContratos, totalPaginasContratos, paginaSelecionadaContrato));

			} catch (Exception e) {
				e.printStackTrace();
			}
		} else {
			sb.append("<h4>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nenhumContratoVinculado") + "</h4>");
			divTabelaPortfolio.setInnerHTML(sb.toString());
		}

		document.executeScript("depoisCarregarTabelaContratos()");
	}

	/**
	 * Gera o html do cabealho da tabela de contratos
	 *
	 * @throws Exception
	 * @author rodrigo.dorighello
	 * @since 15.09.2015
	 */
	private String geraHtmlCabecalhoTabela(HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		sb.append("<div class='row-fluid' id='tabelaContratos'> ");
		sb.append("	<div class=\"table-responsive tabela\">");
		sb.append("		<table class=\"table table-bordered table-striped table-condensed table-vertical-center checkboxs js-table-sortable ui-sortable\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.id") + "</th> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.contratoDescricao") + "</th> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.contratoCliente") + "</th> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.contratoFornecedor") + "</th> ");
		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.acoes") + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody> ");

		return sb.toString();
	}

	/**
	 * Gera o html dos dados da tabela de contratos
	 *
	 * @author rodrigo.dorighello
	 * @since 15.09.2015
	 */
	private String geraHtmlDadosTabela(Integer idContrato, String descricaoContrato, String cliente, String fornecedor, DocumentHTML document, HttpServletRequest request) {
		setPermissaoContratos(document, request);

		StringBuilder sb = new StringBuilder();
		sb.append("		<tr>");
		sb.append("			<td class=\"center\">" + idContrato + "</td> ");
		sb.append("			<td>" + descricaoContrato + "</td> ");
		sb.append("			<td>" + cliente + "</td> ");
		sb.append("			<td>" + fornecedor + "</td> ");
		sb.append("			<td class=\"center\" style=\"width: 90px;\"> ");
		sb.append("				<a onclick=\"avancarContrato(this, " + idContrato + ", '" + descricaoContrato + "'); \"class=\"btn-action glyphicons right_arrow btn-default\"><i></i></a> ");
		if(permissao.isGravar()){
			sb.append("				<a onclick=\"editarContrato(this, " + idContrato + "); \"class=\"btn-action glyphicons pencil btn-success\"><i></i></a> ");
			sb.append("				<a onclick=\"desvincularContrato('" + idContrato + "');\" class=\"btn-action glyphicons remove_2 btn-default\"><i></i></a>");
		}
		sb.append("			</td> ");
		sb.append("		</tr> ");

		return sb.toString();
	}

	/**
	 * Gera o html do final da tabela de contratos
	 *
	 * @author rodrigo.dorighello
	 * @since 15.09.2015
	 */
	private String geraHTMLFinalTabela() {
		StringBuilder sb = new StringBuilder();
		sb.append("			</tbody> ");
		sb.append("		</table>");
		sb.append("	</div>");
		sb.append("</div>");
		sb.append("<div class='row-fluid'> ");
		sb.append("	<div id=\"paginacaoContrato\" class=\"divPaginacao\"></div>");
		sb.append("</div>");

		return sb.toString();
	}

	/**
	 * Mtodo vindo do javascript, que faz o vnculo do contrato aps ser
	 * selecionado pela lookup
	 *
	 * @see br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes
	 * @throws Exception
	 * @author douglas.japiassu
	 * @since 11.09.2015
	 */
	public void vincularContratoAoServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		GerenciamentoPortfolioContratosDTO gerenciamentoPortfolioContratosDto = (GerenciamentoPortfolioContratosDTO) document.getBean();

		if(permissao.isGravar()) {
			if (gerenciamentoPortfolioContratosDto != null && gerenciamentoPortfolioContratosDto.getIdContratoVincular() != null) {
				gerenciamentoPortfolioContratosDto.setAcaoContratoOcorrenciaServico(AuditoriaAcoes.VINCULADO.getIdentificador());
				ServicoContratoDTO servicoContratoDTO = new ServicoContratoDTO();

				servicoContratoDTO.setIdServico(gerenciamentoPortfolioContratosDto.getIdServicoNegocioContrato());
				servicoContratoDTO.setIdContrato(gerenciamentoPortfolioContratosDto.getIdContratoVincular());
				servicoContratoDTO.setDataInicio(UtilDatas.getDataAtual());

				if (getServicoContratoService().findByIdServicoContrato(servicoContratoDTO.getIdServico(), servicoContratoDTO.getIdContrato()) != null) {
					document.executeScript("notificacao('" + UtilI18N.internacionaliza(request, "gerenciaportfolio.contratoJaVinculado") + "', '')");
					return;
				}
				servicoContratoDTO = getServicoContratoService().create(servicoContratoDTO);
				document.executeScript("notificacao('" + UtilI18N.internacionaliza(request, "gerenciaportfolio.contratoVinculadoSucesso") + "', '')");
				gerenciamentoPortfolioContratosDto.setIdsContratoOcorrenciaServico(gerenciamentoPortfolioContratosDto.getIdContratoVincular().toString());
				this.salvarOcorrenciaServicoContrato(document, request, response);
			}

			carregaTabelaContratos(document, request, response);
		} else {
			document.executeScript("notificacaoErro('citcorpore.comum.naoFoiPossivelVincular','citcorpore.comum.usuarioSemPermissao')");
		}
	}

	/**
	 * Mtodo vindo do javascript, que desvincula o contrato aps ser
	 * selecionado na lista
	 *
	 * @see br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes
	 * @throws Exception
	 * @author douglas.japiassu
	 * @since 11.09.2015
	 */
	public void desvincularContratoServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		GerenciamentoPortfolioContratosDTO gerenciamentoPortfolioContratosDto = (GerenciamentoPortfolioContratosDTO) document.getBean();

		if (gerenciamentoPortfolioContratosDto != null && gerenciamentoPortfolioContratosDto.getIdContrato() != null) {
			gerenciamentoPortfolioContratosDto.setAcaoContratoOcorrenciaServico(AuditoriaAcoes.DESVINCULADO.getIdentificador());
			ServicoContratoDTO servicoContratoDTO = new ServicoContratoDTO();

			servicoContratoDTO.setIdServico(gerenciamentoPortfolioContratosDto.getIdServicoNegocioContrato());
			servicoContratoDTO.setIdContrato(gerenciamentoPortfolioContratosDto.getIdContrato());

			servicoContratoDTO = getServicoContratoService().findByIdServicoContrato(servicoContratoDTO.getIdServico(), servicoContratoDTO.getIdContrato());

			if(servicoContratoDTO != null) {
				getServicoContratoService().removeServicoContrato(servicoContratoDTO.getIdServicoContrato());
				document.executeScript("notificacao('" + UtilI18N.internacionaliza(request, "gerenciaportfolio.contratoDesvinculado") + "', '');");
				gerenciamentoPortfolioContratosDto.setIdsContratoOcorrenciaServico(servicoContratoDTO.getIdServicoContrato().toString());
				this.salvarOcorrenciaServicoContrato(document, request, response);
			} else {
				document.executeScript("notificacao('" + UtilI18N.internacionaliza(request, "gerenciaportfolio.idContratoNaoEncontrado") + "', '');");
				return;
			}
		}

		carregaTabelaContratos(document, request, response);
	}

	/**
	 * Temporrio para testes Depois, alterar de ServicoDTO para a entidade
	 * Grupos de Usurios
	 */
	public static Collection<ServicoDTO> listProcessosGruposUsuarios() {
		Collection<ServicoDTO> retorno = new ArrayList<ServicoDTO>();

		Random gerador = new Random();

		for (int i = 1; i <= 10; i++) {
			ServicoDTO servicoDto = new ServicoDTO();
			int idAleatorio = gerador.nextInt(5000);
			servicoDto.setIdServico(idAleatorio);
			servicoDto.setNomeServico("Grupo de usurios " + idAleatorio);
			retorno.add(servicoDto);
		}

		return retorno;
	}

	private ContratoService getContratoService() throws Exception {
		if (contratoService == null) {
			contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
		}
		return contratoService;
	}

	private ServicoContratoService getServicoContratoService() throws Exception {
		if (servicoContratoService == null) {
			servicoContratoService = (ServicoContratoService) ServiceLocator.getInstance().getService(ServicoContratoService.class, null);
		}
		return servicoContratoService;
	}

	@Override
	public Class<GerenciamentoPortfolioContratosDTO> getBeanClass() {
		return GerenciamentoPortfolioContratosDTO.class;
	}

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes
	 * @author deborah.ferreira
	 * @since 29.01.2016
	 */
	public void salvarOcorrenciaServicoContrato(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioContratosDTO gerenciamentoPortfolioContratosDTO = (GerenciamentoPortfolioContratosDTO) document.getBean();
		GerenciamentoPortfolioOcorrenciasServico gerenciamentoPortfolioOcorrenciasServico = new GerenciamentoPortfolioOcorrenciasServico();

		gerenciamentoPortfolioOcorrenciasServico.salvaOcorrenciaServicoContrato(gerenciamentoPortfolioContratosDTO.getIdServicoNegocioContrato(), gerenciamentoPortfolioContratosDTO.getIdsContratoOcorrenciaServico(),
				gerenciamentoPortfolioContratosDTO.getAcaoContratoOcorrenciaServico(), document, request);
	}

}
