package br.com.centralit.citcorpore.ajaxForms;

import java.util.Collection;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citcorpore.bean.ContratoDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioContratosApoioDTO;
import br.com.centralit.citcorpore.bean.ServicoContratoDTO;
import br.com.centralit.citcorpore.negocio.ContratoService;
import br.com.centralit.citcorpore.negocio.ServicoContratoService;
import br.com.centralit.citcorpore.util.Enumerados.PagesPortfolio;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.integracao.core.PageRequest;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;

public class GerenciamentoPortfolioContratosApoio extends AjaxFormAction {

	private ContratoService contratoService;
	private ServicoContratoService servicoContratoService;
	private static Permissoes permissao;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		GerenciamentoPortfolioContratosApoioDTO beanDto = (GerenciamentoPortfolioContratosApoioDTO) document.getBean();

		setPermissaoContratosApoio(document, request);

		if (beanDto != null && !UtilNumbersAndDecimals.isNull(beanDto.getIdServicoApoioContrato())) {
			this.restoreServicoApoioCarregaContratos(beanDto, document, request);
		}
	}

	private void setPermissaoContratosApoio(DocumentHTML document, HttpServletRequest request) {
		permissao = new Permissoes(document, request, PagesPortfolio.SERVICO_APOIO_CONTRATOS.getCaminho());
	}

	public void restoreDemaisDadosContratoApoio(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		setPermissaoContratosApoio(document, request);
		GerenciamentoPortfolioContratosApoioDTO gerenciamentoPortfolioContratosDto = (GerenciamentoPortfolioContratosApoioDTO) document.getBean();

		//Vinculo de servios de requisio e de incidente com o contrato
		try {
			GerenciamentoPortfolioVinculoServicoContrato gerenciamentoPortfolioVinculoServicoContrato = new GerenciamentoPortfolioVinculoServicoContrato();
			gerenciamentoPortfolioVinculoServicoContrato.avancarContratoApoio(gerenciamentoPortfolioContratosDto, document, request, response);
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		ServicoContratoDTO servicoContratoDTO = getServicoContratoService().findByIdServicoContrato(gerenciamentoPortfolioContratosDto.getIdServicoApoioContrato(), gerenciamentoPortfolioContratosDto.getIdContrato());
		document.executeScript("$('.breadcrumb li.breadCrumbContratoApoio').attr('data-idservicocontrato', " + servicoContratoDTO.getIdServicoContrato() + ");");
	}

	private void restoreServicoApoioCarregaContratos(GerenciamentoPortfolioContratosApoioDTO servicoApoioDto, DocumentHTML document, HttpServletRequest request) throws Exception {
		if (servicoApoioDto != null && servicoApoioDto.getIdServicoApoioContrato() != null) {
			servicoApoioDto.setPaginaSelecionadaContratoApoio(1);
			servicoApoioDto.setFiltroContratoApoio("");

			HTMLForm form = document.getForm("formCadastroContrato");
			form.setValues(servicoApoioDto);

			geraTabelaContratos(servicoApoioDto, document, request);
		}
	}

	public void carregaTabelaContratos(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioContratosApoioDTO gerenciamentoPortfolioDto = (GerenciamentoPortfolioContratosApoioDTO) document.getBean();

		geraTabelaContratos(gerenciamentoPortfolioDto, document, request);

	}

	/**
	 * Mtodo para a gerao da tabela de contratos
	 *
	 * @throws Exception
	 * @author rodrigo.dorighello
	 * @since 15.09.2015
	 */
	public void geraTabelaContratos(GerenciamentoPortfolioContratosApoioDTO gerenciamentoPortfolioDto, DocumentHTML document, HttpServletRequest request) throws Exception {

		String filtro = gerenciamentoPortfolioDto.getFiltroContratoApoio();
		if (filtro == null) {
			filtro = "";
		}

		Integer itensPorPagina = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANT_RETORNO_PESQUISA, "10"));

		Integer paginaSelecionadaContrato = gerenciamentoPortfolioDto.getPaginaSelecionadaContratoApoio();
		if (paginaSelecionadaContrato == null || paginaSelecionadaContrato == 0) {
			paginaSelecionadaContrato = 1;
		}

		Pageable pageable = new PageRequest(paginaSelecionadaContrato - 1, itensPorPagina);

		Collection<ContratoDTO> colContrato = this.getContratoService().listAtivosByIdServicoAndFiltro(gerenciamentoPortfolioDto.getIdServicoApoioContrato(), filtro, pageable, false).getContent();

		Integer totalPaginasContratos = this.getContratoService().listAtivosByIdServicoAndFiltro(gerenciamentoPortfolioDto.getIdServicoApoioContrato(), filtro, pageable, true).getTotalPages();

		HTMLElement divTabelaPortfolio = document.getElementById("divDinamicoTabelaContratosApoio");

		StringBuilder sb = new StringBuilder();

		if (colContrato.size() > 0) {
			sb.append(geraHtmlCabecalhoTabela(request));

			for (Iterator<ContratoDTO> iterator = colContrato.iterator(); iterator.hasNext();) {
				ContratoDTO contratoDto = iterator.next();

				sb.append(geraHtmlDadosTabela(contratoDto.getIdContrato(), contratoDto.getNumero(), contratoDto.getRazaoSocialCliente(), contratoDto.getRazaoSocialFornecedor(), document, request));
			}

			sb.append(geraHTMLFinalTabela());
			divTabelaPortfolio.setInnerHTML(sb.toString());

			try {
				HTMLElement paginacaoContrato = document.getElementById("paginacaoContratoApoio");
				String funcaoJsPaginarContratos = "paginarContratosApoio";
				paginacaoContrato.setInnerHTML(UtilHTML.paginacaoHtml(request, funcaoJsPaginarContratos, totalPaginasContratos, paginaSelecionadaContrato));

			} catch (Exception e) {
				e.printStackTrace();
			}
		} else {
			sb.append("<h4>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nenhumContratoVinculado") + "</h4>");
			divTabelaPortfolio.setInnerHTML(sb.toString());
		}

		document.executeScript("depoisCarregarTabelaContratosApoio()");
	}

	private String geraHtmlCabecalhoTabela(HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		sb.append("<div class='row-fluid' id='tabelaContratos'> ");
		sb.append("	<div class=\"table-responsive tabela\">");
		sb.append("		<table class=\"table table-bordered table-striped table-condensed table-vertical-center checkboxs js-table-sortable ui-sortable\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.id") + "</th> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.contratoDescricao") + "</th> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.contratoCliente") + "</th> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.contratoFornecedor") + "</th> ");
		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.acoes") + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody> ");

		return sb.toString();
	}

	private String geraHtmlDadosTabela(Integer idContrato, String descricaoContrato, String cliente, String fornecedor, DocumentHTML document, HttpServletRequest request) {
		setPermissaoContratosApoio(document, request);
		StringBuilder sb = new StringBuilder();

		sb.append("		<tr>");
		sb.append("			<td class=\"center\">" + idContrato + "</td> ");
		sb.append("			<td>" + descricaoContrato + "</td> ");
		sb.append("			<td>" + cliente + "</td> ");
		sb.append("			<td>" + fornecedor + "</td> ");
		sb.append("			<td class=\"center\" style=\"width: 90px;\"> ");
		sb.append("				<a onclick=\"avancarContratoApoio(this, " + idContrato + ", '" + descricaoContrato + "'); \"class=\"btn-action glyphicons right_arrow btn-default\"><i></i></a> ");
		if(permissao.isGravar()){
			sb.append("				<a onclick=\"editarContratoApoio(this, " + idContrato + "); \"class=\"btn-action glyphicons pencil btn-success\"><i></i></a> ");
			sb.append("				<a onclick=\"desvincularContratoApoio('" + idContrato + "');\" class=\"btn-action glyphicons remove_2 btn-default\"><i></i></a>");
		}
		sb.append("			</td> ");
		sb.append("		</tr> ");

		return sb.toString();
	}

	private String geraHTMLFinalTabela() {
		StringBuilder sb = new StringBuilder();
		sb.append("			</tbody> ");
		sb.append("		</table>");
		sb.append("	</div>");
		sb.append("</div>");
		sb.append("<div class='row-fluid'> ");
		sb.append("	<div id=\"paginacaoContratoApoio\" class=\"divPaginacao\"></div>");
		sb.append("</div>");

		return sb.toString();
	}

	/**
	 * Mtodo vindo do javascript, que faz o vnculo do contrato aps ser
	 * selecionado pela lookup
	 *
	 * @throws Exception
	 * @author douglas.japiassu
	 * @since 11.09.2015
	 */
	public void vincularContratoAoServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		GerenciamentoPortfolioContratosApoioDTO gerenciamentoPortfolioContratosDto = (GerenciamentoPortfolioContratosApoioDTO) document.getBean();

		if (gerenciamentoPortfolioContratosDto != null && gerenciamentoPortfolioContratosDto.getIdContratoApoioVincular() != null) {
			ServicoContratoDTO servicoContratoDTO = new ServicoContratoDTO();

			servicoContratoDTO.setIdServico(gerenciamentoPortfolioContratosDto.getIdServicoApoioContrato());
			servicoContratoDTO.setIdContrato(gerenciamentoPortfolioContratosDto.getIdContratoApoioVincular());
			servicoContratoDTO.setDataInicio(UtilDatas.getDataAtual());

			if (getServicoContratoService().findByIdServicoContrato(servicoContratoDTO.getIdServico(), servicoContratoDTO.getIdContrato()) != null) {
				document.executeScript("notificacao('" + UtilI18N.internacionaliza(request, "gerenciaportfolio.contratoJaVinculado") + "', '')");
				return;
			}
			servicoContratoDTO = getServicoContratoService().create(servicoContratoDTO);
			document.executeScript("notificacao('" + UtilI18N.internacionaliza(request, "gerenciaportfolio.contratoVinculadoSucesso") + "', '')");
		}

		carregaTabelaContratos(document, request, response);
	}

	/**
	 * Mtodo vindo do javascript, que desvincula o contrato aps ser
	 * selecionado na lista
	 *
	 * @throws Exception
	 * @author douglas.japiassu
	 * @since 11.09.2015
	 */
	public void desvincularContratoServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		GerenciamentoPortfolioContratosApoioDTO gerenciamentoPortfolioContratosApoioDto = (GerenciamentoPortfolioContratosApoioDTO) document.getBean();

		if (gerenciamentoPortfolioContratosApoioDto != null && gerenciamentoPortfolioContratosApoioDto.getIdContrato() != null) {
			ServicoContratoDTO servicoContratoDTO = new ServicoContratoDTO();

			servicoContratoDTO.setIdServico(gerenciamentoPortfolioContratosApoioDto.getIdServicoApoioContrato());
			servicoContratoDTO.setIdContrato(gerenciamentoPortfolioContratosApoioDto.getIdContrato());

			servicoContratoDTO = getServicoContratoService().findByIdServicoContrato(servicoContratoDTO.getIdServico(), servicoContratoDTO.getIdContrato());

			if(servicoContratoDTO != null) {
				getServicoContratoService().removeServicoContrato(servicoContratoDTO.getIdServicoContrato());
				document.executeScript("notificacao('" + UtilI18N.internacionaliza(request, "gerenciaportfolio.contratoDesvinculado") + "', '');");
			} else {
				document.executeScript("notificacao('" + UtilI18N.internacionaliza(request, "gerenciaportfolio.idContratoNaoEncontrado") + "', '');");
				return;
			}
		}

		carregaTabelaContratos(document, request, response);
	}

	private ContratoService getContratoService() throws Exception {
		if (contratoService == null) {
			contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
		}
		return contratoService;
	}

	private ServicoContratoService getServicoContratoService() throws Exception {
		if (servicoContratoService == null) {
			servicoContratoService = (ServicoContratoService) ServiceLocator.getInstance().getService(ServicoContratoService.class, null);
		}
		return servicoContratoService;
	}

	@Override
	public Class<GerenciamentoPortfolioContratosApoioDTO> getBeanClass() {
		return GerenciamentoPortfolioContratosApoioDTO.class;
	}

}
