package br.com.centralit.citcorpore.ajaxForms;

import java.util.Collection;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioContratosCalendarioDTO;
import br.com.centralit.citcorpore.bean.ServicoContratoCalendarioDTO;
import br.com.centralit.citcorpore.negocio.ServicoContratoCalendarioService;
import br.com.centralit.citcorpore.util.Enumerados.PagesPortfolio;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.Enumerados.TipoDate;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.core.PageRequest;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Reflexao;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;

public class GerenciamentoPortfolioContratosCalendario extends AjaxFormAction {
	private ServicoContratoCalendarioService servicoContratoCalendarioService;
	private static Permissoes permissao;

	/**
	 * @author deborah.ferreira
	 * @since 02.04.2016
	 */
	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		permissao = new Permissoes(document, request, PagesPortfolio.CONTRATOS_CALENDARIO.getCaminho());
		carregarTabelaServicoContratoCalendario(document, request, response);
	}

	/**
	 * @author deborah.ferreira
	 * @since 02.04.2016
	 */
	public void carregarTabelaServicoContratoCalendario(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioContratosCalendarioDTO servicoContratoCalendarioDTO = (GerenciamentoPortfolioContratosCalendarioDTO) document.getBean();

		montaTabelaServicoContratoCalendario(document, request, servicoContratoCalendarioDTO);
	}

	/**
	 * @author deborah.ferreira
	 * @since 02.04.2016
	 */
	public void adicionarCalendario(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (permissao.isGravar()) {
			GerenciamentoPortfolioContratosCalendarioDTO bean = (GerenciamentoPortfolioContratosCalendarioDTO) document.getBean();
			ServicoContratoCalendarioDTO servicoContratoCalendarioDTO = new ServicoContratoCalendarioDTO();

			Reflexao.copyPropertyValues(bean, servicoContratoCalendarioDTO);

			Boolean existeAtivo = getServicoContratoCalendarioService().existeCalendarioAtivoByServicoContrato(bean.getIdServicoContrato());
			if (existeAtivo) {
				document.executeScript("notificacaoErro('gerenciaPortfolio.contrato.jaExisteCalendarioAtivo')");
				return;
			}

			bean.setDataInicio(UtilDatas.getDataAtual());
			getServicoContratoCalendarioService().create(bean);

			montaTabelaServicoContratoCalendario(document, request, bean);
		} else {
			document.executeScript("notificacaoErro('citcorpore.comum.permissaoFuncionalidade');");
		}
	}

	/**
	 * @author deborah.ferreira
	 * @since 02.04.2016
	 */
	public void desativarCalendario(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (permissao.isGravar()) {
			GerenciamentoPortfolioContratosCalendarioDTO bean = (GerenciamentoPortfolioContratosCalendarioDTO) document.getBean();
			ServicoContratoCalendarioDTO servicoContratoCalendarioDTO = new ServicoContratoCalendarioDTO();

			Reflexao.copyPropertyValues(bean, servicoContratoCalendarioDTO);

			servicoContratoCalendarioDTO.setDataFim(UtilDatas.getDataAtual());
			getServicoContratoCalendarioService().updateNotNull(servicoContratoCalendarioDTO);

			montaTabelaServicoContratoCalendario(document, request, bean);
		} else {
			document.executeScript("notificacaoErro('citcorpore.comum.permissaoFuncionalidade');");
		}
	}

	/**
	 * @author deborah.ferreira
	 * @since 02.04.2016
	 */
	private void montaTabelaServicoContratoCalendario(final DocumentHTML document, final HttpServletRequest request, GerenciamentoPortfolioContratosCalendarioDTO contratoCalendarioDTO)
			throws ServiceException, Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);

		HTMLElement divListaServicoContratoCalendario = document.getElementById("divDinamicoListaContratoCalendarios");

		String filtro = contratoCalendarioDTO.getFiltro();
		if (filtro == null) {
			filtro = "";
		}

		Integer itensPorPagina = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANT_RETORNO_PESQUISA, "10"));

		Integer paginaSelecionada = contratoCalendarioDTO.getPaginaSelecionada();
		if (paginaSelecionada == null || paginaSelecionada == 0) {
			paginaSelecionada = 1;
		}

		Pageable pageable = new PageRequest(paginaSelecionada - 1, itensPorPagina);

		List<ServicoContratoCalendarioDTO> listServicoContratoCalendario = getServicoContratoCalendarioService().listCalendario(contratoCalendarioDTO.getIdServicoContrato(), filtro, pageable, false)
				.getContent();

		if (listServicoContratoCalendario != null && !listServicoContratoCalendario.isEmpty()) {
			divListaServicoContratoCalendario.setInnerHTML(geraTabelaServicoContratoCalendario(document, request, listServicoContratoCalendario));

			Integer totalPaginas = getServicoContratoCalendarioService().listCalendario(contratoCalendarioDTO.getIdServicoContrato(), filtro, pageable, true).getTotalPages();

			HTMLElement paginacao = document.getElementById("paginacaoServicoContratoCalendario");
			String funcaoJsPaginar = "paginarServicoContratoCalendario";
			paginacao.setInnerHTML(UtilHTML.paginacaoHtml(request, funcaoJsPaginar, totalPaginas, paginaSelecionada));
		} else {
			final StringBuilder htmlDivSemRegistros = new StringBuilder();
			htmlDivSemRegistros.append("<h4>" + UtilI18N.internacionaliza(request, "gerenciaPortfolio.contrato.nenhumCalendarioVinculado") + "</h4>");
			divListaServicoContratoCalendario.setInnerHTML(htmlDivSemRegistros.toString());
		}

		document.executeScript("depoisCarregarListaServicoContratoCalendario();");
	}

	/**
	 * @author deborah.ferreira
	 * @since 02.04.2016
	 */
	public String geraTabelaServicoContratoCalendario(final DocumentHTML document, final HttpServletRequest request, Collection<ServicoContratoCalendarioDTO> listServicoContratoCalendario) {
		StringBuilder sb = new StringBuilder();

		sb.append(geraCabecalhoTabela(request));
		for (ServicoContratoCalendarioDTO servicoContratoCalendario : listServicoContratoCalendario) {
			sb.append(geraDadosTabela(document, request, servicoContratoCalendario));
		}
		sb.append(geraFinalTabela());

		return sb.toString();
	}

	/**
	 * @author deborah.ferreira
	 * @since 02.04.2016
	 */
	private String geraCabecalhoTabela(final HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		sb.append("<div class='row-fluid'> ");
		sb.append("	<div class=\"table-responsive tabela\">");
		sb.append("		<table class=\"table table-bordered table-striped table-condensed table-vertical-center checkboxs js-table-sortable ui-sortable\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th class=\"center\" style=\"width: 1%;\">" + UtilI18N.internacionaliza(request, "lookup.id") + "</th> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.nome") + "</th> ");
		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.dataInicio") + "</th> ");
		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.dataFim") + "</th> ");
		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.acao") + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody> ");

		return sb.toString();
	}

	/**
	 * @author deborah.ferreira
	 * @since 02.04.2016
	 */
	private String geraDadosTabela(final DocumentHTML document, final HttpServletRequest request, ServicoContratoCalendarioDTO servicoContratoCalendario) {
		StringBuilder sb = new StringBuilder();
		String onClick = "ContratoCalendario.desativarCalendario(".concat(servicoContratoCalendario.getIdServicoContratoCalendario().toString()).concat(");");
		String onMouseOver = "onmouseover=\"abreTooltip(this, '" + UtilI18N.internacionaliza(request, "citcorpore.comum.desativar") + "')\" onmouseout=\"fechaTooltip()\"";

		sb.append("		<tr>");
		sb.append("			<td class=\"center\">" + servicoContratoCalendario.getIdServicoContratoCalendario() + "</td> ");
		sb.append("			<td>" + UtilHTML.encodeHTML(servicoContratoCalendario.getNomeCalendario()) + "</td> ");
		sb.append("			<td style=\"width: 90px;\">" + UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, servicoContratoCalendario.getDataInicio()) + "</td> ");
		sb.append("			<td style=\"width: 90px;\">" + UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, servicoContratoCalendario.getDataFim()) + "</td> ");
		sb.append("			<td class=\"center\" style=\"width: 30px;\"> ");
		if (permissao.isGravar() && servicoContratoCalendario.getDataFim() == null) {
			sb.append("				<a onclick=\"" + onClick + "\" " + onMouseOver + "  class=\"btn-action glyphicons remove_2 btn-default\"><i></i></a> ");
		}
		sb.append("			</td> ");
		sb.append("		</tr> ");

		return sb.toString();
	}

	/**
	 * @author deborah.ferreira
	 * @since 02.04.2016
	 */
	private static String geraFinalTabela() {
		StringBuilder sb = new StringBuilder();
		sb.append("			</tbody> ");
		sb.append("		</table>");
		sb.append("	</div>");
		sb.append("</div>");
		sb.append("<div id=\"paginacaoServicoContratoCalendario\" class=\"divPaginacao\"></div>");
		sb.append("</div>");

		return sb.toString();
	}


	@Override
	public Class<GerenciamentoPortfolioContratosCalendarioDTO> getBeanClass() {
		return GerenciamentoPortfolioContratosCalendarioDTO.class;
	}

	private ServicoContratoCalendarioService getServicoContratoCalendarioService() throws ServiceException {
		if (servicoContratoCalendarioService == null) {
			servicoContratoCalendarioService = (ServicoContratoCalendarioService) ServiceLocator.getInstance().getService(ServicoContratoCalendarioService.class, null);
		}
		return servicoContratoCalendarioService;
	}
}
