package br.com.centralit.citcorpore.ajaxForms;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioContratosCustoDisponibilidadeDTO;
import br.com.centralit.citcorpore.bean.ServicoContratoDTO;
import br.com.centralit.citcorpore.negocio.ServicoContratoService;
import br.com.centralit.citcorpore.util.Enumerados.PagesPortfolio;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;

public class GerenciamentoPortfolioContratosCustoDisponibilidade extends AjaxFormAction {
	private ServicoContratoService servicoContratoService;
	private static Permissoes permissao;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		permissao = new Permissoes(document, request, PagesPortfolio.CONTRATOS_CUSTO_DISPONIBILIDADE.getCaminho());
		this.restore(document, request, response);
	}

	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		if (permissao.isGravar()) {
			GerenciamentoPortfolioContratosCustoDisponibilidadeDTO custoDisponibilidadeDTO = (GerenciamentoPortfolioContratosCustoDisponibilidadeDTO) document.getBean();
			ServicoContratoDTO servicoContratoDTO = new ServicoContratoDTO();
			servicoContratoDTO.setIdServicoContrato(custoDisponibilidadeDTO.getIdServicoContrato());
			servicoContratoDTO = this.getServicoContratoService().restore(servicoContratoDTO);
			servicoContratoDTO.setCustoHoraIndisponibilidade(custoDisponibilidadeDTO.getCustoHoraIndisponibilidade());
			this.getServicoContratoService().update(servicoContratoDTO);
			document.executeScript("notificacaoI18N('MSG06')");
		} else {
			document.executeScript("notificacaoErro('citcorpore.comum.permissaoFuncionalidade');");
			this.restore(document, request, response);
		}
	}

	public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioContratosCustoDisponibilidadeDTO custoDisponibilidadeDTO = (GerenciamentoPortfolioContratosCustoDisponibilidadeDTO) document.getBean();
		ServicoContratoDTO servicoContratoDTO = this.getServicoContratoService().listByIdServicoContrato(custoDisponibilidadeDTO.getIdServicoContrato());
		if(servicoContratoDTO != null) {
			custoDisponibilidadeDTO.setCustoHoraIndisponibilidade(servicoContratoDTO.getCustoHoraIndisponibilidade());
			document.getForm("formContratoCustoDisponibilidade").setValues(custoDisponibilidadeDTO);
		}
	}

	@Override
	public Class<GerenciamentoPortfolioContratosCustoDisponibilidadeDTO> getBeanClass() {
		return GerenciamentoPortfolioContratosCustoDisponibilidadeDTO.class;
	}

	private ServicoContratoService getServicoContratoService() throws ServiceException {
		if (servicoContratoService == null) {
			servicoContratoService = (ServicoContratoService) ServiceLocator.getInstance().getService(ServicoContratoService.class, null);
		}
		return servicoContratoService;
	}
}
