package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citcorpore.bean.DonoNegocioDTO;
import br.com.centralit.citcorpore.bean.EmpregadoDTO;
import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.negocio.DonoNegocioService;
import br.com.centralit.citcorpore.negocio.EmpregadoService;
import br.com.centralit.citcorpore.negocio.GrupoService;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.centralit.citcorpore.util.Enumerados.DonoNegocioTipo;
import br.com.centralit.citcorpore.util.Enumerados.PagesPortfolio;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;

/**
 * @author Gilmar.junior
 */
public class GerenciamentoPortfolioDonoNegocio extends AjaxFormAction {

	private GrupoService grupoService;
	private EmpregadoService empregadoService;
	private List<DonoNegocioDTO> listaDTO = new ArrayList<DonoNegocioDTO>();
	private DonoNegocioService donoNegocioService;
	private static Permissoes permissao;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		DonoNegocioDTO beanDto = (DonoNegocioDTO) document.getBean();
		permissao = new Permissoes(document, request, PagesPortfolio.SERVICO_NEGOCIO_DONO_NEGOCIO.getCaminho());

		if (beanDto != null && !UtilNumbersAndDecimals.isNull(beanDto.getIdServico())) {
			restore(beanDto, document, request);
		}
	}

	private void restore(DonoNegocioDTO donoNegocioDTO, DocumentHTML document, HttpServletRequest request) throws Exception {
		if (donoNegocioDTO.getIdServico() != null) {
			List<DonoNegocioDTO> salvosNoBanco = (List<DonoNegocioDTO>) getDonoNegocioService().listByServico(donoNegocioDTO.getIdServico());
			refreshTabelaServicoDonoNegocio(document, request, salvosNoBanco);
			atualizarListaDeItensSelecionadosNoJavaScript(document, salvosNoBanco);
		}
	}

	private void refreshTabelaServicoDonoNegocio(DocumentHTML document, HttpServletRequest request, List<DonoNegocioDTO> listDTO) throws Exception {
		HTMLElement divDinamicoListaDonoNegocio = document.getElementById("divDinamicoListaDonoNegocio");
		if (listDTO != null) {
			divDinamicoListaDonoNegocio.setInnerHTML(geraHTMLConfigurandoPortfolioDonoNegocioGrupo(request, listDTO));
		} else {
			atualizarListaDeItensSelecionadosNoJavaScript(document, listDTO);
			divDinamicoListaDonoNegocio = document.getElementById("divDinamicoListaDonoNegocio");
			StringBuilder sb = new StringBuilder();
			sb.append("<h4>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nenhumDonoNegocioVinculado") + "</h4>");
			divDinamicoListaDonoNegocio.setInnerHTML(sb.toString());
		}
	}

	private String geraHTMLConfigurandoPortfolioDonoNegocioGrupo(HttpServletRequest request, List<DonoNegocioDTO> listDTO) throws Exception {
		StringBuilder sb = new StringBuilder();
		if (listDTO != null) {
			sb.append(geraHTMLCabecalhoConfigurandoPortfolioNegocioGrupo(request));
			for (DonoNegocioDTO donoNegocio : listDTO) {
				sb.append(geraHTMLDadosConfigurandoPortfolioNegocioGrupo(donoNegocio, request));
			}
			sb.append(geraHTMLFinalConfigurandoPortfolioNegocioGrupo());
		}
		return sb.toString();
	}

	private String geraHTMLCabecalhoConfigurandoPortfolioNegocioGrupo(HttpServletRequest request) throws Exception {
		StringBuilder sb = new StringBuilder();

		sb.append("<div class='row-fluid' id='divTabelaANSs'> ");
		sb.append("	<div class=\"table-responsive tabela\">");
		sb.append("		<table class=\"table table-bordered table-striped table-condensed table-vertical-center checkboxs js-table-sortable ui-sortable\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th> ID </th> ");
		sb.append("					<th>" + UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "citcorpore.comum.nome")) + "</th> ");
		sb.append("					<th>" + UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "citcorpore.comum.tipo")) + "</th> ");
		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.acoes") + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody> ");

		return sb.toString();
	}

	private String geraHTMLDadosConfigurandoPortfolioNegocioGrupo(DonoNegocioDTO donoNegocioDTO, HttpServletRequest request) throws Exception {
		StringBuilder sb = new StringBuilder();

		String onClickDesvincularDonoNegocio = "";
		String onMouseOverDesvincularDonoNegocio = "";

		if (DonoNegocioTipo.GRUPO.getIdentificador().equals(donoNegocioDTO.getTipoDonoNegocio())) {
			onClickDesvincularDonoNegocio = "desvincularDonoNegocioGrupo";
			onMouseOverDesvincularDonoNegocio = "onmouseover=\"abreTooltip(this, '" + UtilI18N.internacionaliza(request, "gerenciaportfolio.desvincularDonoNegocioGrupo")
					+ "')\" onmouseout=\"fechaTooltip()\"";

		} else if (DonoNegocioTipo.EMPREGADO.getIdentificador().equals(donoNegocioDTO.getTipoDonoNegocio())) {
			onClickDesvincularDonoNegocio = "desvincularDonoNegocioGrupo";
			onMouseOverDesvincularDonoNegocio = "onmouseover=\"abreTooltip(this, '" + UtilI18N.internacionaliza(request, "gerenciaportfolio.desvincularDonoNegocioEmpregado")
					+ "')\" onmouseout=\"fechaTooltip()\"";
		}

		sb.append("		<tr>");

		if (donoNegocioDTO.getIdGrupo() != null) {
			sb.append("			<td>" + donoNegocioDTO.getIdGrupo() + "</td> ");

		} else if (donoNegocioDTO.getIdEmpregado() != null) {
			sb.append("			<td>" + donoNegocioDTO.getIdEmpregado() + "</td> ");
		}

		if (DonoNegocioTipo.GRUPO.getIdentificador().equals(donoNegocioDTO.getTipoDonoNegocio())) {
			GrupoDTO grupo = new GrupoDTO();
			grupo.setIdGrupo(donoNegocioDTO.getIdGrupo());
			grupo = this.getGrupoService().restore(grupo);

			sb.append("			<td>" + grupo.getNome() + "</td> ");
			sb.append("			<td>" + UtilI18N.internacionaliza(request, DonoNegocioTipo.GRUPO.getChave()) + "</td> ");

		} else if (DonoNegocioTipo.EMPREGADO.getIdentificador().equals(donoNegocioDTO.getTipoDonoNegocio())) {
			EmpregadoDTO emp = new EmpregadoDTO();
			emp.setIdEmpregado(donoNegocioDTO.getIdEmpregado());
			emp = this.getEmpregadoService().restore(emp);

			sb.append("			<td>" + emp.getNome() + "</td> ");
			sb.append("			<td>" + UtilI18N.internacionaliza(request, DonoNegocioTipo.EMPREGADO.getChave()) + "</td> ");
		}

		sb.append("			</td> ");
		sb.append("			<td class=\"center\" style=\"width: 90px;\"> ");
		if (permissao.isGravar()) {
			sb.append("				<a onclick=\"" + onClickDesvincularDonoNegocio + "(this, " + donoNegocioDTO.getIdServicoDonoNegocio() + ", " + donoNegocioDTO.getIdServico() + ");\" "
				+ onMouseOverDesvincularDonoNegocio + " class=\"btn-action glyphicons remove_2 btn-default\"><i></i></a> ");
		}
		sb.append("			</td> ");
		sb.append("		</tr> ");

		return sb.toString();
	}

	private String geraHTMLFinalConfigurandoPortfolioNegocioGrupo() {
		StringBuilder sb = new StringBuilder();
		sb.append("			</tbody> ");
		sb.append("		</table>");
		sb.append("	</div>");
		sb.append("</div>");

		return sb.toString();
	}

	public void desvincularServicoDonoNegocio(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		DonoNegocioDTO donoNegocioDTO = (DonoNegocioDTO) document.getBean();

		if (permissao.isGravar()) {
			if (donoNegocioDTO.getIdServico() != null && donoNegocioDTO.getIdServicoDonoNegocio() != null) {
				donoNegocioDTO = this.getDonoNegocioService().restore(donoNegocioDTO);
				this.getDonoNegocioService().delete(donoNegocioDTO);
				document.executeScript("notificacaoI18N('gerenciaportfolio.donoNegocioGrupoDesvinculadoSucesso')");
				this.restore(donoNegocioDTO, document, request);
				donoNegocioDTO.setAcaoDonoNegocioOcorrenciaServico(AuditoriaAcoes.DESVINCULADO.getIdentificador());
				document.setBean(donoNegocioDTO);
				this.salvarOcorrenciaServicoDonoNegocio(document, request, response);
			} else {
				document.alert(UtilI18N.internacionaliza(request, "gerenciaportfolio.donoNegocioDesvinculadoErro"));
			}
		} else {
			document.executeScript("notificacaoErro('citcorpore.comum.naoFoiPossivelVincular','citcorpore.comum.usuarioSemPermissao')");
		}
		
		document.executeScript("JANELA_AGUARDE_MENU.hide();");
	}

	public void vincularDonoNegocioGrupo(DocumentHTML document, HttpServletRequest request, HttpServletResponse response, String checkboxChecadosComoTrue, Integer idServico, int tipoDonoNegocio) throws Exception {
		if (permissao.isGravar()) {
			try {
				if (checkboxChecadosComoTrue.isEmpty()) {
					document.executeScript("JANELA_AGUARDE_MENU.hide();");
					document.executeScript("notificacaoErro('gerenciaportfolio.selecioneNovos')");
					return;
				}
				
				List<String> idsDonoNegocioVinculados = new ArrayList<String>();

				for (String id : checkboxChecadosComoTrue.split(";")) {

					if (id != null && !id.isEmpty()) {
						DonoNegocioDTO dto = new DonoNegocioDTO();
						dto.setIdGrupo(DonoNegocioTipo.GRUPO.getIdentificador().equals(tipoDonoNegocio) ? Integer.valueOf(id) : null);
						dto.setIdEmpregado(DonoNegocioTipo.EMPREGADO.getIdentificador().equals(tipoDonoNegocio) ? Integer.valueOf(id) : null);
						dto.setIdServico(idServico);
						dto.setTipoDonoNegocio(tipoDonoNegocio);

						listaDTO.add(dto);
						idsDonoNegocioVinculados.add(id);
					}
				}

				DonoNegocioDTO donoNegocioDTO = new DonoNegocioDTO();
				donoNegocioDTO.setIdServico(idServico);

				persistirItensChecados(document, request);
				this.restore(donoNegocioDTO, document, request);
				document.executeScript("salvarVincularOcorrenciaServicoDonoNegocio('" + idsDonoNegocioVinculados.toString() + "', '" + tipoDonoNegocio + "');");

			} catch (Exception e) {
				e.printStackTrace();
			}
		} else {
			document.executeScript("notificacaoErro('citcorpore.comum.naoFoiPossivelVincular','citcorpore.comum.usuarioSemPermissao')");
		}
	}

	public void filtroServicoDonoNegocio(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		DonoNegocioDTO obj = (DonoNegocioDTO) document.getBean();

		if (obj != null && obj.getIdServico() != null) {

			if (obj.getTextoPesquisado() == null || obj.getTextoPesquisado().isEmpty()) {
				this.restore(obj, document, request);
			} else {
				List<DonoNegocioDTO> salvosNoBanco = (List<DonoNegocioDTO>) getDonoNegocioService().listByServicoAndText(obj.getIdServico(), obj.getTextoPesquisado());
				if (salvosNoBanco != null) {
					refreshTabelaServicoDonoNegocio(document, request, salvosNoBanco);
				}
			}
		}
	}

	private void persistirItensChecados(DocumentHTML document, HttpServletRequest request) throws Exception {
		try {
			this.getDonoNegocioService().create(listaDTO);
			document.executeScript("notificacaoI18N('gerenciaportfolio.donoNegocioGrupoVinculadoSucesso')");
		} catch (ServiceException | LogicException e) {
			e.printStackTrace();
			StringBuilder sb = new StringBuilder();
			sb.append("dispararErro(");
			sb.append(UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "citcorpore.comum.erroGravacao")));
			sb.append(");");
			document.executeScript(sb.toString());
		}
	}

	private void atualizarListaDeItensSelecionadosNoJavaScript(DocumentHTML document, List<DonoNegocioDTO> listDto) throws Exception {
		StringBuilder stringBuilderGrupo = new StringBuilder("");
		StringBuilder stringBuilderEmpregado = new StringBuilder("");

		if (listDto != null) {
			for (DonoNegocioDTO obj : listDto) {
				if (DonoNegocioTipo.GRUPO.getIdentificador().equals(obj.getTipoDonoNegocio())) {
					stringBuilderGrupo.append(obj.getIdGrupo());
					stringBuilderGrupo.append(";");
				} else {
					stringBuilderEmpregado.append(obj.getIdEmpregado());
					stringBuilderEmpregado.append(";");
				}
			}
		}
		document.getElementById("listaIdGrupoVinculado").setValue(stringBuilderGrupo.toString());
		document.getElementById("listaIdEmpregadoVinculado").setValue(stringBuilderEmpregado.toString());
	}

	private DonoNegocioService getDonoNegocioService() throws ServiceException {
		if (donoNegocioService == null) {
			donoNegocioService = (DonoNegocioService) ServiceLocator.getInstance().getService(DonoNegocioService.class, null);
		}
		return donoNegocioService;
	}

	private EmpregadoService getEmpregadoService() throws Exception {
		if (empregadoService == null) {
			empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, null);
		}
		return empregadoService;
	}

	private GrupoService getGrupoService() throws Exception {
		if (grupoService == null) {
			grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
		}
		return grupoService;
	}

	@Override
	public Class<DonoNegocioDTO> getBeanClass() {
		return DonoNegocioDTO.class;
	}

	/**
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	public void salvarOcorrenciaServicoDonoNegocio(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) {
		DonoNegocioDTO donoNegocioDTO = (DonoNegocioDTO) document.getBean();
		GerenciamentoPortfolioOcorrenciasServico gerenciamentoPortfolioOcorrenciasServico = new GerenciamentoPortfolioOcorrenciasServico();
		gerenciamentoPortfolioOcorrenciasServico.salvaOcorrenciaServicoDonoNegocio(donoNegocioDTO.getIdServico(), donoNegocioDTO, document, request);
	}

}