package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citcorpore.bean.EsquemaDadosDTO;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citcorpore.negocio.EsquemaDadosService;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.centralit.citcorpore.util.Enumerados.CampoUpload;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.centralit.citged.bean.ControleGEDDTO;
import br.com.centralit.citged.negocio.ControleGEDService;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;

public class GerenciamentoPortfolioEsquemaDados extends AjaxFormAction {
	private EsquemaDadosService service;
	private ControleGEDService controleGEDService;


	@Override
	public Class<EsquemaDadosDTO> getBeanClass() {
		return EsquemaDadosDTO.class;
	}

	@Override
	public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		EsquemaDadosDTO beanDto = (EsquemaDadosDTO) document.getBean();
		request.getSession(true).setAttribute(CampoUpload.UPLOADESQUEMADADOS.getColUploadGED(), null);

		if (beanDto != null && !UtilNumbersAndDecimals.isNull(beanDto.getIdServicoNegocio())) {
			this.restoreEsquemaDados(beanDto, document, request);
		}
	}

	public void reloadAnexos(final DocumentHTML document, final HttpServletRequest request,
			final HttpServletResponse response) throws Exception {
		EsquemaDadosDTO beanDto = (EsquemaDadosDTO) document.getBean();

		restaurarAnexos(request, beanDto);
		document.executeScript("afterReloadAnexosEsquemaDados()");
	}

	@SuppressWarnings("unchecked")
	public void save(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);

		EsquemaDadosDTO beanDto = (EsquemaDadosDTO) document.getBean();
		try {
			Collection<UploadDTO> arquivosGED = (Collection<UploadDTO>) request.getSession(true).getAttribute(CampoUpload.UPLOADESQUEMADADOS.getColUploadGED());

			beanDto.setColsUploadGED(arquivosGED);

			if (beanDto.getIdEsquemaDados() != null) {
				this.getService().salvar(beanDto);
				beanDto.setAcaoEsquemaDadosOcorrenciaServico(AuditoriaAcoes.ALTERADO.getIdentificador());
				document.alert(UtilI18N.internacionaliza(request, "MSG06"));
			} else {
				beanDto.setDataCriacao(UtilDatas.getDataAtual());
				beanDto = this.getService().salvar(beanDto);
				beanDto.setAcaoEsquemaDadosOcorrenciaServico(AuditoriaAcoes.CRIADO.getIdentificador());
				document.alert(UtilI18N.internacionaliza(request, "MSG05"));
			}

			if (beanDto.getIdEsquemaDados() != null) {
				HTMLElement idEsquemaDados = document.getElementById("idEsquemaDados");
				idEsquemaDados.setValue(beanDto.getIdEsquemaDados().toString());
				document.setBean(beanDto);
				this.salvarListaArquivosAdicionados(arquivosGED, document);
				this.salvarOcorrenciaServicoEsquemaDados(document, request, response);
			}
		} catch (final Exception e) {
			e.printStackTrace();
		}
	}

	private void restoreEsquemaDados(EsquemaDadosDTO esquemaDadosDTO, final DocumentHTML document, final HttpServletRequest request)
			throws Exception {
		try {
			final Collection<EsquemaDadosDTO> colEsquemaDados = this.getService().findByIdServicoNegocio(esquemaDadosDTO.getIdServicoNegocio());

			if (colEsquemaDados != null && !colEsquemaDados.isEmpty()) {
				esquemaDadosDTO = colEsquemaDados.iterator().next();
			}

			this.definirServicoSelecionadoNaPagina(esquemaDadosDTO, document);

			this.restaurarAnexos(request, esquemaDadosDTO);
			document.executeScript("afterReloadAnexosEsquemaDados()");

			this.definirValoresNoFormulario(document, esquemaDadosDTO);
		} catch (PersistenceException | ServiceException e) {
			e.printStackTrace();
		}
	}

	private void restaurarAnexos(final HttpServletRequest request, final EsquemaDadosDTO esquemaDadosDTO) throws ServiceException, Exception {
		if (esquemaDadosDTO.getIdEsquemaDados() != null) {
			Collection<UploadDTO> colAnexosUploadDTO = new ArrayList<UploadDTO>();

			final Collection<ControleGEDDTO> colAnexos = getControleGEDService().listByIdTabelaAndID(ControleGEDDTO.TABELA_ESQUEMA_DADOS,
					esquemaDadosDTO.getIdEsquemaDados());
			colAnexosUploadDTO = getControleGEDService().convertListControleGEDToUploadDTO(colAnexos);
			request.getSession(true).setAttribute(CampoUpload.UPLOADESQUEMADADOS.getColUploadGED(), colAnexosUploadDTO);
		} else {
			request.getSession(true).setAttribute(CampoUpload.UPLOADESQUEMADADOS.getColUploadGED(), null);
		}

	}

	private void definirValoresNoFormulario(final DocumentHTML document, final EsquemaDadosDTO esquemaDadosDTO)
			throws Exception {
		final HTMLForm form = document.getForm("formEsquemaDados");
		form.clear();
		form.setValues(esquemaDadosDTO);
	}

	private void definirServicoSelecionadoNaPagina(final EsquemaDadosDTO dto, final DocumentHTML document) {
		// Setando o id do servico selecionado no(s) caso de negocio a serem consultados pel mesmo
		final String idServicoSelecionadoNoPortfolio = "document.formEsquemaDados.idServicoNegocio.value = ".concat(String.valueOf(dto
				.getIdServicoNegocio()));
		document.executeScript(idServicoSelecionadoNoPortfolio);

		document.executeScript("document.formEsquemaDados.btnLimpar.style.display = 'block';");
		if(dto.getIdEsquemaDados() != null){
			document.executeScript("document.formEsquemaDados.btnLimpar.style.display = 'none';");
		}
	}

	private EsquemaDadosService getService() throws ServiceException {
		if (this.service == null) {
			this.service = (EsquemaDadosService) ServiceLocator.getInstance().getService(EsquemaDadosService.class, null);
		}
		return this.service;
	}

	private ControleGEDService getControleGEDService() throws ServiceException {
		if (this.controleGEDService == null) {
			this.controleGEDService = (ControleGEDService) ServiceLocator.getInstance().getService(ControleGEDService.class, null);
		}
		return this.controleGEDService;
	}

	public void excluir(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		EsquemaDadosDTO esquemaDadosDTO = (EsquemaDadosDTO) document.getBean();

		if (esquemaDadosDTO != null && esquemaDadosDTO.getIdEsquemaDados() != null) {

			if (esquemaDadosDTO.getColsUploadGED() != null && !esquemaDadosDTO.getColsUploadGED().isEmpty()) {
				esquemaDadosDTO.setDataFim(UtilDatas.getDataAtual());
				this.getService().update(esquemaDadosDTO);
				esquemaDadosDTO.setAcaoEsquemaDadosOcorrenciaServico(AuditoriaAcoes.EXCLUIDO.getIdentificador());
				this.salvarOcorrenciaServicoEsquemaDados(document, request, response);
				HTMLForm form = document.getForm("formEsquemaDados");
				form.clear();
			} else {
				document.executeScript("notificacao('".concat(UtilI18N.internacionaliza(request, "citcorpore.comum.naoFoiPossivelExcluir"))
						.concat("','").concat(UtilI18N.internacionaliza(request, "citcorpore.comum.existemDocumentosRelacionados")).concat("')"));
			}
		}
	}

	/**
	 * @author deborah.ferreira
	 * @since 02.02.2016
	 */
	public void salvarListaArquivosAdicionados(Collection<UploadDTO> listaArquivos, DocumentHTML document) throws Exception {
		EsquemaDadosDTO esquemaDadosDTO = (EsquemaDadosDTO) document.getBean();
		String listaIdsStr = "";

		if (listaArquivos != null) {
			for (UploadDTO anexo : listaArquivos) {
				if (anexo.getTemporario().toUpperCase().equals("S")) {
					if (anexo.getIdControleGED() != null) {
						listaIdsStr += anexo.getIdControleGED() + ",";
					}
				}
			}
		}

		esquemaDadosDTO.setListaIdsAnexosEsquemaDadosOcorrenciaServico(listaIdsStr);
	}

	/**
	 * @author deborah.ferreira
	 * @since 02.02.2016
	 */
	public void salvarOcorrenciaServicoEsquemaDados(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		EsquemaDadosDTO esquemaDadosDTO = (EsquemaDadosDTO) document.getBean();
		GerenciamentoPortfolioOcorrenciasServico gerenciamentoPortfolioOcorrenciasServico = new GerenciamentoPortfolioOcorrenciasServico();

		gerenciamentoPortfolioOcorrenciasServico.salvaOcorrenciaServicoEsquemaDados(esquemaDadosDTO.getIdServicoNegocio(), esquemaDadosDTO, document, request);
	}
}
