package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioHabilidadeDTO;
import br.com.centralit.citcorpore.negocio.GerenciamentoPortfolioHabilidadeService;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.centralit.citcorpore.util.Enumerados.PagesPortfolio;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;
import br.com.citframework.util.UtilStrings;

public class GerenciamentoPortfolioHabilidade extends AjaxFormAction {
	/**
	 * @since 03.02.2016
	 * @author joao.morais
	 */
	private static Permissoes permissao;
	private GerenciamentoPortfolioHabilidadeService gerenciamentoHabilidadeService;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		GerenciamentoPortfolioHabilidadeDTO beanDto = (GerenciamentoPortfolioHabilidadeDTO) document.getBean();
		permissao = new Permissoes(document, request, PagesPortfolio.SERVICO_NEGOCIO_HABILIDADE_RECURSO.getCaminho());

		if (beanDto != null && !UtilNumbersAndDecimals.isNull(beanDto.getIdServico())) {
			this.restoreHabilidades(beanDto, document, request);
		}
	}

	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		permissao = new Permissoes(document, request, PagesPortfolio.SERVICO_NEGOCIO_HABILIDADE_RECURSO.getCaminho());
		if(permissao.isGravar()){
			GerenciamentoPortfolioHabilidadeDTO habilidadeDTO = (GerenciamentoPortfolioHabilidadeDTO) document.getBean();
			habilidadeDTO.setListaIdsHabilidadesVinculadas(habilidadeDTO.getListaIdsHabilidadesVinculadas() + habilidadeDTO.getColAllLOOKUP_SERVICO_VINCULAR_HABILIDADE());
	
			if (habilidadeDTO != null && habilidadeDTO.getListaIdsHabilidadesVinculadas().equals("") && habilidadeDTO.getIdServico() != null
					&& habilidadeDTO.getColAllLOOKUP_SERVICO_VINCULAR_HABILIDADE().equals("")) {
				this.getGerenciamentoPortfolioHabilidadeService().deleteAllVinculosHabilidades(habilidadeDTO.getIdServico());
				return;
			} else if (habilidadeDTO != null && habilidadeDTO.getIdServico() != null) {
				this.getGerenciamentoPortfolioHabilidadeService().deleteAllVinculosHabilidades(habilidadeDTO.getIdServico());
				String[] idsHabilidade = habilidadeDTO.getListaIdsHabilidadesVinculadas().split(";");
				for (String id : idsHabilidade) {
					habilidadeDTO.setIdHabilidade(Integer.parseInt(id));
					habilidadeDTO = this.getGerenciamentoPortfolioHabilidadeService().create(habilidadeDTO);
				}
	
			}
	
			if (UtilStrings.isNotVazio(habilidadeDTO.getColAllLOOKUP_SERVICO_VINCULAR_HABILIDADE())) {
				habilidadeDTO.setAcaoHabilidadeOcorrenciaServico(AuditoriaAcoes.VINCULADO.getIdentificador());
				habilidadeDTO.setIdsHabilidadeOcorrenciaServico(habilidadeDTO.getColAllLOOKUP_SERVICO_VINCULAR_HABILIDADE().replaceAll(";", ","));
				this.salvarOcorrenciaServicoHabilidade(document, request, response);
			}
			this.restoreHabilidades(habilidadeDTO, document, request);
		} else {
			document.executeScript("notificacaoErro('citcorpore.comum.naoFoiPossivelVincular','citcorpore.comum.usuarioSemPermissao')");
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
		}
	}

	public void excluir(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		permissao = new Permissoes(document, request, PagesPortfolio.SERVICO_NEGOCIO_HABILIDADE_RECURSO.getCaminho());
		GerenciamentoPortfolioHabilidadeDTO habilidadeDTO = (GerenciamentoPortfolioHabilidadeDTO) document.getBean();
		if (habilidadeDTO != null && habilidadeDTO.getIdHabilidadeVinculo().intValue() > 0) {
			if (permissao.isGravar()) {
				this.getGerenciamentoPortfolioHabilidadeService().deleteByIdHabilidadeVinculo(habilidadeDTO.getIdHabilidadeVinculo());
				document.executeScript("fechaAguarde();");
				document.alert(UtilI18N.internacionaliza(request, "gerenciaportfolioHabilidade.habilidadeDesvinculada"));
				habilidadeDTO.setAcaoHabilidadeOcorrenciaServico(AuditoriaAcoes.DESVINCULADO.getIdentificador());
				this.salvarOcorrenciaServicoHabilidade(document, request, response);
			} else {
				document.executeScript("notificacaoErro('citcorpore.comum.permissaoFuncionalidade');");
				document.executeScript("fechaAguarde();");
			}
		}
		try {
			this.restoreHabilidades(habilidadeDTO, document, request);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void preencheDivListaHabilidade(GerenciamentoPortfolioHabilidadeDTO gerenciamentoPortfolioHabilidadeDTO, Collection<GerenciamentoPortfolioHabilidadeDTO> totalHabilidade,
			DocumentHTML document) {
		String idsHabilidade = "";
		for (GerenciamentoPortfolioHabilidadeDTO habilidade : totalHabilidade) {
			idsHabilidade += habilidade.getIdHabilidade() + ";";
		}
		HTMLForm form = document.getForm("formVincularHabilidade");
		form.setValue("listaIdsHabilidadesVinculadas", idsHabilidade);
		gerenciamentoPortfolioHabilidadeDTO.setListaIdsHabilidadesVinculadas(idsHabilidade);
	}

	private void restoreHabilidades(GerenciamentoPortfolioHabilidadeDTO gerenciamentoPortfolioHabilidadeDTO, DocumentHTML document, HttpServletRequest request)
			throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		permissao = new Permissoes(document, request);
		HTMLForm form = document.getForm("formVincularHabilidade");
		HTMLElement divDinamicoListaHabilidade = document.getElementById("divDinamicoListaHabilidade");
		Collection<GerenciamentoPortfolioHabilidadeDTO> totalHabilidade = this.getGerenciamentoPortfolioHabilidadeService().getListHabilidadesByIdServico(gerenciamentoPortfolioHabilidadeDTO);

		this.preencheDivListaHabilidade(gerenciamentoPortfolioHabilidadeDTO, totalHabilidade, document);
		form.setValue("idServico", String.valueOf(gerenciamentoPortfolioHabilidadeDTO.getIdServico()));

		if (totalHabilidade == null || totalHabilidade.isEmpty()) {
			divDinamicoListaHabilidade.setInnerHTML("<h4>" + UtilI18N.internacionaliza(request, "gerenciaportfolioHabilidade.nenhumHabilidadeVinculado") + "</h4>");
		} else {
			divDinamicoListaHabilidade.setInnerHTML(this.geraTabelaHabilidade(totalHabilidade, document, request));
		}

		document.executeScript("VincularHabilidade.depoisMontarHTMLHabilidade();");
	}

	public void preencheListaHabilidadeFiltro(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioHabilidadeDTO habilidadeDTO = (GerenciamentoPortfolioHabilidadeDTO) document.getBean();
		List<GerenciamentoPortfolioHabilidadeDTO> listaHabilidades = new ArrayList<GerenciamentoPortfolioHabilidadeDTO>();
		String filtro = habilidadeDTO.getFiltroHabilidade();
		HTMLElement divDinamicoListaHabilidade = document.getElementById("divDinamicoListaHabilidade");

		if (filtro == null) {
			filtro = "";
		}

		listaHabilidades.addAll(this.getGerenciamentoPortfolioHabilidadeService().getListHabilidadesFiltradas(habilidadeDTO, filtro));
		if (listaHabilidades.size() > 0) {
			divDinamicoListaHabilidade.setInnerHTML(this.geraTabelaHabilidade(listaHabilidades, document, request));
			document.executeScript("fechaAguarde();");
		}else{
			divDinamicoListaHabilidade.setInnerHTML("<h4>" + UtilI18N.internacionaliza(request, "gerenciaportfolioHabilidade.nenhumHabilidadeVinculado") + "</h4>");
			document.executeScript("fechaAguarde();");
		}
	}

	public void adicionaTabelaLOOKUP_SERVICO_VINCULAR_HABILIDADE(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		GerenciamentoPortfolioHabilidadeDTO habilidadeDTO = (GerenciamentoPortfolioHabilidadeDTO) document.getBean();
		if (habilidadeDTO != null) {
			document.executeScript("VincularHabilidade.carregarTabelaHabilidade();");
			this.save(document, request, response);
			document.executeScript("VincularHabilidade.fecharPopup();");
		}
	}

	public void montarHTMLHabilidade(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws ServiceException, Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);

		HTMLElement divDinamicoListaHabilidade = document.getElementById("divDinamicoListaHabilidade");
		GerenciamentoPortfolioHabilidadeDTO gerenciamentoPortfolioHabilidadeDTO = (GerenciamentoPortfolioHabilidadeDTO) document.getBean();

		String filtroHabilidade = gerenciamentoPortfolioHabilidadeDTO.getFiltroHabilidade();
		if (filtroHabilidade == null) {
			filtroHabilidade = "";
		}

		Collection<GerenciamentoPortfolioHabilidadeDTO> totalHabilidade = this.getGerenciamentoPortfolioHabilidadeService().getListHabilidadesByIdServico(gerenciamentoPortfolioHabilidadeDTO);

		if (totalHabilidade == null || totalHabilidade.isEmpty()) {
			divDinamicoListaHabilidade.setInnerHTML("<h4>" + UtilI18N.internacionaliza(request, "gerenciaportfolioHabilidade.nenhumHabilidadeVinculado") + "</h4>");
		} else {
			divDinamicoListaHabilidade.setInnerHTML(this.geraTabelaHabilidade(totalHabilidade, document, request));
		}

		document.executeScript("VincularHabilidade.depoisMontarHTMLHabilidade();");
	}

	private String geraTabelaHabilidade(Collection<GerenciamentoPortfolioHabilidadeDTO> listaHabilidades, DocumentHTML document, HttpServletRequest request) throws Exception {
		StringBuilder sb = new StringBuilder();

		sb.append(geraHtmlCabecalhoTabela(request));

		sb.append(geraHtmlDadosTabela(listaHabilidades, document, request));

		sb.append(geraHTMLFinalTabela());

		return sb.toString();
	}

	private String geraHtmlCabecalhoTabela(HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		sb.append("	<div class=\"table-responsive tabela\">");
		sb.append("		<table class=\"table table-bordered table-striped table-condensed\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolioHabilidade.IdHabilidade") + "</th> ");
		sb.append("				<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolioHabilidade.nomeHabilidade") + "</th> ");
		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.acoes") + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody id=\"bodyTabelaColaboradorHabilidade\"> ");

		return sb.toString();
	}

	private String geraHtmlDadosTabela(Collection<GerenciamentoPortfolioHabilidadeDTO> listaHabilidades, DocumentHTML document, HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		for (GerenciamentoPortfolioHabilidadeDTO habilidade : listaHabilidades) {
			sb.append(geraHtmlLinhaTabela(request, habilidade.getIdHabilidade(), habilidade.getNomeHabilidade(), habilidade.getIdHabilidadeVinculo()));
		}

		return sb.toString();
	}

	private String geraHtmlLinhaTabela(HttpServletRequest request, Integer id, String nomeHabilidade, Integer idHabilidadeVinculo) {
		StringBuilder sb = new StringBuilder();
		String onMouseOver = "onmouseover=\"abreTooltip(this, '" + UtilI18N.internacionaliza(request, "cadastroHabilidade.desvincularHabilidade") + "')\" onmouseout=\"fechaTooltip();\"";
		String onMouseOverEditar = "onmouseover=\"abreTooltip(this, '" + UtilI18N.internacionaliza(request, "cadastroHabilidade.editarHabilidade") + "')\" onmouseout=\"fechaTooltip();\"";

		sb.append("		<tr id=\"" + id + "\">");
		sb.append("			<td class=\"center\">" + id + "</td> ");
		sb.append("			<td>" + nomeHabilidade + "</td> ");
		sb.append("			<td class=\"center\" style=\"width: 60px;\">");
		if (permissao.isGravar()) {
			sb.append("				<a onclick=\"VincularHabilidade.desvincularHabilidadeFromServico('" + idHabilidadeVinculo + "','" + id + "');\" " + onMouseOver
					+ " class=\"btn-action glyphicons remove_2 btn-default btnUpDate\"><i></i></a>");
			sb.append("				<a onclick=\"VincularHabilidade.abrirPopupHabilidade(&#39;" + id + "&#39;);\" " + onMouseOverEditar
					+ " class=\"btn-action glyphicons pencil btn-success btnGravar\"><i></i></a>");
		}
		sb.append("			</td> ");
		sb.append("		</tr> ");

		return sb.toString();
	}

	private String geraHTMLFinalTabela() {
		StringBuilder sb = new StringBuilder();
		sb.append("			</tbody> ");
		sb.append("		</table>");
		sb.append("	</div>");

		return sb.toString();
	}

	@Override
	public Class<GerenciamentoPortfolioHabilidadeDTO> getBeanClass() {
		return GerenciamentoPortfolioHabilidadeDTO.class;
	}

	private GerenciamentoPortfolioHabilidadeService getGerenciamentoPortfolioHabilidadeService() throws ServiceException {
		if (gerenciamentoHabilidadeService == null) {
			gerenciamentoHabilidadeService = (GerenciamentoPortfolioHabilidadeService) ServiceLocator.getInstance().getService(GerenciamentoPortfolioHabilidadeService.class, null);
		}
		return gerenciamentoHabilidadeService;
	}

	/**
	 * @author deborah.ferreira
	 * @since 17.02.2016
	 */
	public void salvarOcorrenciaServicoHabilidade(DocumentHTML document, HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		GerenciamentoPortfolioHabilidadeDTO gerenciamentoPortfolioHabilidadeDTO = (GerenciamentoPortfolioHabilidadeDTO) document.getBean();
		GerenciamentoPortfolioOcorrenciasServico gerenciamentoPortfolioOcorrenciasServico = new GerenciamentoPortfolioOcorrenciasServico();

		gerenciamentoPortfolioOcorrenciasServico.salvaOcorrenciaServicoHabilidade(gerenciamentoPortfolioHabilidadeDTO.getIdServico(), gerenciamentoPortfolioHabilidadeDTO, document,
				request);
	}

}