package br.com.centralit.citcorpore.ajaxForms;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citcorpore.bean.IndicadorCapacidadeServicoDTO;
import br.com.centralit.citcorpore.bean.ServicoNegocioIndicadorCapacidadeDTO;
import br.com.centralit.citcorpore.negocio.IndicadorCapacidadeServicoService;
import br.com.centralit.citcorpore.negocio.OcorrenciaServicoService;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.PagesPortfolio;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;

public class GerenciamentoPortfolioIndicadoresCapacidade extends AjaxFormAction {

	private IndicadorCapacidadeServicoService indicadorCapacidadeServicoService;
	private OcorrenciaServicoService ocorrenciaServicoService;
	private static Permissoes permissao;
	
	@Override
	public Class<ServicoNegocioIndicadorCapacidadeDTO> getBeanClass() {
		return ServicoNegocioIndicadorCapacidadeDTO.class;
	}

	private Integer pageSize = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANT_RETORNO_PESQUISA, "10"));

	@Override
	public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		permissao = new Permissoes(document, request, PagesPortfolio.SERVICO_NEGOCIO_INDICADORES_CAPACIDADE_PERFORMANCE.getCaminho());
		ServicoNegocioIndicadorCapacidadeDTO beanDto = (ServicoNegocioIndicadorCapacidadeDTO) document.getBean();

		if (beanDto != null && !UtilNumbersAndDecimals.isNull(beanDto.getIdServico())) {
			this.restoreIndicadoresCapacidade(beanDto, document, request);
		}
	}

	public void atualizaTelaIndicadoresCapacidade(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception{
		ServicoNegocioIndicadorCapacidadeDTO ServicoNegocioIndicadorCapacidadeDTO = (ServicoNegocioIndicadorCapacidadeDTO) document.getBean();
		this.preencheTabela(ServicoNegocioIndicadorCapacidadeDTO, document, request);
		document.executeScript("limpaValor()");

	}

	private void restoreIndicadoresCapacidade(ServicoNegocioIndicadorCapacidadeDTO ServicoNegocioIndicadorCapacidadeDTO, final DocumentHTML document, final HttpServletRequest request) throws ServiceException, Exception {
		if(ServicoNegocioIndicadorCapacidadeDTO != null && ServicoNegocioIndicadorCapacidadeDTO.getIdServico() != null){
			this.preencheTabela(ServicoNegocioIndicadorCapacidadeDTO, document, request);
		}

	}

	private void preencheTabela(ServicoNegocioIndicadorCapacidadeDTO servicoNegocioIndicadorCapacidadeDTO, final DocumentHTML document, final HttpServletRequest request) throws ServiceException, Exception {
		Integer paginaSelecionada = servicoNegocioIndicadorCapacidadeDTO.getPaginaSelecionadaIndicadorCapacidadeServico();
		Integer totalPaginas = getIndicadorCapacidadeServicoService().getTotalPaginasIndicadoresCapacidade(pageSize, servicoNegocioIndicadorCapacidadeDTO.getIdServico());
		if(paginaSelecionada != null && totalPaginas != null && paginaSelecionada > totalPaginas){
			paginaSelecionada = totalPaginas;
		}
		if(paginaSelecionada == null || paginaSelecionada <= 0) {
			paginaSelecionada = 1;
		}
		List<IndicadorCapacidadeServicoDTO> listIndicadores = this.getIndicadorCapacidadeServicoService().listByIdServico(servicoNegocioIndicadorCapacidadeDTO, paginaSelecionada - 1, pageSize);
		HTMLElement divTabela = document.getElementById("tabelaIndicadoresCapacidadeServico");
		document.executeScript("limpaTabelaIndicadorCapacidadeServico()");
		StringBuilder sb = new StringBuilder();
		if(listIndicadores != null && !listIndicadores.isEmpty()){
			sb.append("		<table class='dynamicTable table table-striped table-bordered'> ");
			sb.append("			<thead> ");
			sb.append("				<tr> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.nome") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.valor") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "planoMelhoria.acoes.titulo") + "</th> ");
			sb.append("				</tr> ");
			sb.append("			</thead> ");
			sb.append("			<tbody> ");

			for (IndicadorCapacidadeServicoDTO indicadorCapacidadeServicoDTO : listIndicadores) {
				sb.append("		<tr>");
				sb.append("			<td>"+indicadorCapacidadeServicoDTO.getNome()+"</td>");
				sb.append("			<td>"+indicadorCapacidadeServicoDTO.getValor().toString()+"</td>");
				sb.append("			<td>");
				if (permissao.isGravar()) {
					sb.append("			<button type='button' id='btnExcluirVinculo' class='btn-action glyphicons remove_2 btn-danger btnGravar' onclick='desvincularIndicadorCapacidade(")
							.append(indicadorCapacidadeServicoDTO.getIdIndicadorCapacidadeServico()).append(")'><i></i></button>");
				}
				sb.append("			</td>");
				sb.append("		</tr>");
			}
			sb.append("			</tbody> ");
			sb.append("		</table> ");
			sb.append("");
			sb.append("<div class='separator'></div>");
			sb.append(UtilHTML.paginacaoHtml(request, "atualizaTelaPaginadaIndicadorCapacidadeServico", totalPaginas, paginaSelecionada));
			divTabela.appendHTML(sb.toString());
		}else{
			sb.append("<h4>"+ UtilI18N.internacionaliza(request, "gerenciamentoportfolio.indicadorescapacidade.nenhumvinculado"));
			divTabela.appendHTML(sb.toString());
		}
	}
	
	public void desvincularIndicadorCapacidade(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		if (permissao.isGravar()) {
			ServicoNegocioIndicadorCapacidadeDTO servicoNegocioIndicadorCapacidadeDTO = (ServicoNegocioIndicadorCapacidadeDTO) document.getBean();
			IndicadorCapacidadeServicoDTO indicadorCapacidadeServicoDTO = new IndicadorCapacidadeServicoDTO();
			indicadorCapacidadeServicoDTO.setIdIndicadorCapacidadeServico(servicoNegocioIndicadorCapacidadeDTO.getIdIndicadorCapacidadeServico());
			indicadorCapacidadeServicoDTO = this.getIndicadorCapacidadeServicoService().restore(indicadorCapacidadeServicoDTO);
			Integer[] indicadores = new Integer[1];
			indicadores[0] = indicadorCapacidadeServicoDTO.getIdIndicadorCapacidade();
			getIndicadorCapacidadeServicoService().delete(indicadorCapacidadeServicoDTO);
			this.getOcorrenciaServicoService().salvaOcorrenciaServicoCapacidade(servicoNegocioIndicadorCapacidadeDTO.getIdServico(), Enumerados.AuditoriaAcoes.DESVINCULADO.getIdentificador(), indicadores, document,
					request);
			preencheTabela(servicoNegocioIndicadorCapacidadeDTO, document, request);
		} else {
			document.executeScript("notificacaoErro('citcorpore.comum.permissaoFuncionalidade');");
		}
	}

	private IndicadorCapacidadeServicoService getIndicadorCapacidadeServicoService() throws ServiceException{
		if(indicadorCapacidadeServicoService == null)
			indicadorCapacidadeServicoService = (IndicadorCapacidadeServicoService) ServiceLocator.getInstance().getService(IndicadorCapacidadeServicoService.class, null);
		return indicadorCapacidadeServicoService;
	}

	private OcorrenciaServicoService getOcorrenciaServicoService() throws ServiceException {
		if (ocorrenciaServicoService == null)
			ocorrenciaServicoService = (OcorrenciaServicoService) ServiceLocator.getInstance().getService(OcorrenciaServicoService.class, null);
		return ocorrenciaServicoService;
	}

}
