package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioMapaDesenhoApoioDTO;
import br.com.centralit.citcorpore.bean.ImagemItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.ImagemItemConfiguracaoRelacaoDTO;
import br.com.centralit.citcorpore.bean.ItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.negocio.EvmConexaoService;
import br.com.centralit.citcorpore.negocio.ImagemItemConfiguracaoRelacaoService;
import br.com.centralit.citcorpore.negocio.ImagemItemConfiguracaoService;
import br.com.centralit.citcorpore.negocio.ItemConfiguracaoService;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.enums.EvmEnumerados;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilStrings;
import br.com.citframework.util.WebUtil;

@SuppressWarnings({ "unchecked", "rawtypes" })
public class GerenciamentoPortfolioMapaDesenhoApoio extends AjaxFormAction {
	
	private EvmConexaoService evmConexaoService;

	ArrayList<ServicoDTO> listaServicos;
	private ArrayList<Integer> itensDeletadosInesperadamente;
	private static Permissoes permissao;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioMapaDesenhoApoioDTO mapaApoio = (GerenciamentoPortfolioMapaDesenhoApoioDTO) document.getBean();
		permissao = new Permissoes(document, request, "/pages/gerenciamentoPortfolio/gerenciamentoPortfolioMapaDesenhoApoio/gerenciamentoPortfolioMapaDesenhoApoio.jsp");
		restoreServicoApoioCarregaMapaApoio(mapaApoio, document, request);
	}

	public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioMapaDesenhoApoioDTO mapaApoio = (GerenciamentoPortfolioMapaDesenhoApoioDTO) document.getBean();
		
		restoreMapaDesenho(mapaApoio, document, request);
	}
	
	public void restoreServicoApoioCarregaMapaApoio(GerenciamentoPortfolioMapaDesenhoApoioDTO mapaApoio, DocumentHTML document, HttpServletRequest request) throws Exception {

		if (mapaApoio != null && mapaApoio.getIdServicoApoio() != null && mapaApoio.getIdPortfolioServico() != null) {
			Integer idPortfolio = mapaApoio.getIdPortfolioServico();
			Integer idServicoApoio = mapaApoio.getIdServicoApoio();

			mapaApoio.setIdPortfolioServico(idPortfolio);
			mapaApoio.setIdServicoApoio(idServicoApoio);
			

			HTMLForm form = document.getForm("formMapaDesenhoApoio");
			form.setValues(mapaApoio);

			String chaveServicosApoio = Enumerados.TipoServico.SERVICO_APOIO.getIdentificador();
			//document.executeScript("atualizaLookupIC(" + idPortfolio + ", '" + chaveServicosApoio + "', " + idServicoApoio + ");");

			restoreMapaDesenho(mapaApoio, document, request);
		} else {
			//document.executeScript("atualizaLookupIC(0, '', 0);");
		}
	}

	public void restoreMapaDesenho(GerenciamentoPortfolioMapaDesenhoApoioDTO mapa, DocumentHTML document, HttpServletRequest request) throws Exception {

		if (mapa.getIdServicoApoio() != null) {
			String imagensItemConfiguracaoSerializado = getImagensItemConfiguracaoSerializado(mapa.getIdServicoApoio(), request);
			imagensItemConfiguracaoSerializado = StringEscapeUtils.escapeJavaScript(imagensItemConfiguracaoSerializado);
			mapa.setListaItensConfiguracaoSerializada(imagensItemConfiguracaoSerializado);

			itensDeletadosInesperadamente = new ArrayList<Integer>();
			if (this.itensDeletadosInesperadamente.size() > 0) {
				document.alert(UtilI18N.internacionaliza(request, "mapaDesenhoServico.algunsItensForamDeletadosPorOutrasFontes") + itensDeletadosInesperadamente.toString());
			}

			HTMLForm form = document.getForm("formMapaDesenhoApoio");
			form.setValues(mapa);

			document.executeScript("atualizaServicoMapa('" + imagensItemConfiguracaoSerializado + "');");
		}

	}

	public void selecionarServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioMapaDesenhoApoioDTO mapa = (GerenciamentoPortfolioMapaDesenhoApoioDTO) document.getBean();

		restoreMapaDesenho(mapa, document, request);

	}

	/**
	 * @param idServico
	 * @param request 
	 * @return
	 * @throws Exception
	 */
	private String getImagensItemConfiguracaoSerializado(int idServico, HttpServletRequest request) throws Exception {

		ImagemItemConfiguracaoService imagemItemConfiguracaoService = (ImagemItemConfiguracaoService) ServiceLocator.getInstance().getService(ImagemItemConfiguracaoService.class, null);
		
		ImagemItemConfiguracaoRelacaoService imagemItemConfiguracaoRelacaoService = (ImagemItemConfiguracaoRelacaoService) ServiceLocator.getInstance().getService(ImagemItemConfiguracaoRelacaoService.class, null);

		ArrayList<ImagemItemConfiguracaoDTO> imagensItemConfiguracao = (ArrayList) imagemItemConfiguracaoService.findByIdServico(idServico);

		String serializado = null;

		if (imagensItemConfiguracao != null) {

			for (ImagemItemConfiguracaoDTO img : imagensItemConfiguracao) {

				ItemConfiguracaoService itemService = (ItemConfiguracaoService) ServiceLocator.getInstance().getService(ItemConfiguracaoService.class, null);

				ItemConfiguracaoDTO item = new ItemConfiguracaoDTO();
				item.setIdItemConfiguracao(img.getIdItemConfiguracao());
				item = (ItemConfiguracaoDTO) itemService.restore(item);

				if (item == null) {
					itensDeletadosInesperadamente.add(img.getIdItemConfiguracao());
					imagemItemConfiguracaoService.delete(img);
				} else {
					img.setIdentificacao(item.getIdentificacao());
				}
				
				if(img.getIdImagemItemConfiguracao()!= null){
					Collection<ImagemItemConfiguracaoRelacaoDTO> colIdImagemItemConfiguracaoPai = new ArrayList<ImagemItemConfiguracaoRelacaoDTO>();
					Collection<ImagemItemConfiguracaoRelacaoDTO> imgItemConfiguracaoRel = null;
					imgItemConfiguracaoRel = imagemItemConfiguracaoRelacaoService.findByIdImagemItemConfiguracao(img.getIdImagemItemConfiguracao());
					
					//Trata itens que j existiam itens pai
					if(img.getIdImagemItemConfiguracaoPai()!= null){
						ImagemItemConfiguracaoRelacaoDTO imgItemPaiAux = null;
						imgItemPaiAux = imagemItemConfiguracaoRelacaoService.findByIdImagemItemConfiguracaoAndIdItemPai(img.getIdImagemItemConfiguracao(), img.getIdImagemItemConfiguracaoPai());
						if(imgItemPaiAux == null){
							imgItemPaiAux = new ImagemItemConfiguracaoRelacaoDTO();
							imgItemPaiAux.setIdImagemItemConfiguracaoPai(img.getIdImagemItemConfiguracaoPai());
							imgItemPaiAux.setIdImagemItemConfiguracao(img.getIdImagemItemConfiguracao());
							colIdImagemItemConfiguracaoPai.add(imgItemPaiAux);
						}
					}
					//Adiciona na lista de itens pais.
					if(imgItemConfiguracaoRel!= null && !imgItemConfiguracaoRel.isEmpty()){
						for(ImagemItemConfiguracaoRelacaoDTO imgRel:imgItemConfiguracaoRel){
							if(imgRel.getIdImagemItemConfiguracaoPai()!= null){
								colIdImagemItemConfiguracaoPai.add(imgRel);
							}
						}
					}
					if(colIdImagemItemConfiguracaoPai!= null && !colIdImagemItemConfiguracaoPai.isEmpty()){
						String colSerializado = WebUtil.serializeObjects(colIdImagemItemConfiguracaoPai, WebUtil.getLanguage(request));
						img.setIdImagemItemConfiguracaoPaiColSerializado(colSerializado);
					}
				}
			}
		}
		serializado = WebUtil.serializeObjects(imagensItemConfiguracao, WebUtil.getLanguage(request));

		return serializado;
	}

	/**
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	public void selecionarItemConfigurcao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioMapaDesenhoApoioDTO mapa = (GerenciamentoPortfolioMapaDesenhoApoioDTO) document.getBean();
		
		try{
			ItemConfiguracaoService itemService = (ItemConfiguracaoService) ServiceLocator.getInstance().getService(ItemConfiguracaoService.class, null);
			ItemConfiguracaoDTO item = new ItemConfiguracaoDTO();
			item.setIdItemConfiguracao(mapa.getIdItemConfiguracao());
			item = (ItemConfiguracaoDTO) itemService.restore(item);
			
			if(item!=null && item.getIdentificacao()!=null){
				document.executeScript("afterSelecionarItemConfiguracao('"+item.getIdentificacao()+"');");
			}
		}catch(Exception e){
			throw new Exception(e);
		}finally{
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
		}
	}

	public void salvarServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		ArrayList<ImagemItemConfiguracaoDTO> listaItens = (ArrayList) WebUtil.deserializeCollectionFromRequest(ImagemItemConfiguracaoDTO.class, "listaItensConfiguracaoSerializada", request);

		ImagemItemConfiguracaoService imagemItemService = (ImagemItemConfiguracaoService) ServiceLocator.getInstance().getService(ImagemItemConfiguracaoService.class, null);
		
		ImagemItemConfiguracaoRelacaoService imagemItemConfiguracaoRelacaoServico = (ImagemItemConfiguracaoRelacaoService) ServiceLocator.getInstance().getService(ImagemItemConfiguracaoRelacaoService.class, null);
		if (listaItens != null) {
			for (ImagemItemConfiguracaoDTO img : listaItens) {
				if (img.getIdImagemItemConfiguracao() == 0) {
					imagemItemService.create(img);
				} else {
					imagemItemService.update(img);
				}
				//Salvar itens na tabela de relao
				if(img.getIdImagemItemConfiguracaoPaiColSerializado()!= null && UtilStrings.isNotVazio(img.getIdImagemItemConfiguracaoPaiColSerializado())){
					Collection<ImagemItemConfiguracaoRelacaoDTO> listaItensItemRel = WebUtil.deserializeCollectionFromString(ImagemItemConfiguracaoRelacaoDTO.class, img.getIdImagemItemConfiguracaoPaiColSerializado());
					for(ImagemItemConfiguracaoRelacaoDTO imgRel : listaItensItemRel){
						if(imgRel!= null && imgRel.getIdImagemItemConfiguracao()!= null && imgRel.getIdImagemItemConfiguracaoPai()!= null){
							ImagemItemConfiguracaoRelacaoDTO imgAux = imagemItemConfiguracaoRelacaoServico.findByIdImagemItemConfiguracaoAndIdItemPai(imgRel.getIdImagemItemConfiguracao(), imgRel.getIdImagemItemConfiguracaoPai());
							if(imgAux == null){
								imagemItemConfiguracaoRelacaoServico.create(imgRel);
							}
						}
					}
				}

			}
		}
		selecionarServico(document, request, response);
		document.executeScript("notificacao('"+UtilI18N.internacionaliza(request, "MSG06") +"', '');");
		document.executeScript("fecharModalImpactoServicoMapa();");

	}
	
	public void excluirImagemItemConfiguracao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		GerenciamentoPortfolioMapaDesenhoApoioDTO mapa = (GerenciamentoPortfolioMapaDesenhoApoioDTO) document.getBean();
		ImagemItemConfiguracaoService imagemItemService = (ImagemItemConfiguracaoService) ServiceLocator.getInstance().getService(ImagemItemConfiguracaoService.class, null);
		ImagemItemConfiguracaoDTO img = new ImagemItemConfiguracaoDTO();
		img.setIdImagemItemConfiguracao(mapa.getIdImagemItemConfiguracao());
		imagemItemService.delete(img);
		mapa.setListaItensConfiguracaoSerializada(getImagensItemConfiguracaoSerializado(mapa.getIdServicoApoio(), request));
		HTMLForm form = document.getForm("formMapaDesenhoApoio");
		form.setValues(mapa);

		salvarServico(document, request, response);
	}

	private EvmConexaoService getEvmConexaoService() throws ServiceException {
		if (evmConexaoService == null) {
			evmConexaoService = (EvmConexaoService) ServiceLocator.getInstance().getService(EvmConexaoService.class, null);
		}
		return evmConexaoService;
	}
	
	@Override
	public Class getBeanClass() {
		return GerenciamentoPortfolioMapaDesenhoApoioDTO.class;
	}
}
