package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioMapaDesenhoNegocioDTO;
import br.com.centralit.citcorpore.bean.ItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.MapaNegocioItemDTO;
import br.com.centralit.citcorpore.bean.MapaNegocioRelacaoDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.negocio.EvmConexaoService;
import br.com.centralit.citcorpore.negocio.ItemConfiguracaoService;
import br.com.centralit.citcorpore.negocio.MapaNegocioItemService;
import br.com.centralit.citcorpore.negocio.MapaNegocioRelacaoService;
import br.com.centralit.citcorpore.negocio.ServicoService;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.centralit.citcorpore.util.Enumerados.PagesPortfolio;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.enums.EvmEnumerados;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;
import br.com.citframework.util.UtilStrings;
import br.com.citframework.util.WebUtil;


public class GerenciamentoPortfolioMapaDesenhoNegocio extends AjaxFormAction {

	private ServicoService servicoService;
	private EvmConexaoService evmConexaoService;
	private MapaNegocioItemService mapaNegocioItemService;
	private MapaNegocioRelacaoService mapaNegocioRelacaoService;
	private ItemConfiguracaoService itemConfiguracaoService;
	private static Permissoes permissao;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!br.com.centralit.citcorpore.util.WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		setPermissoesMapaDesenhoNegocio(document, request);
		GerenciamentoPortfolioMapaDesenhoNegocioDTO beanDto = (GerenciamentoPortfolioMapaDesenhoNegocioDTO) document.getBean();
		if (beanDto != null && !UtilNumbersAndDecimals.isNull(beanDto.getIdServicoNegocio())) {
			restoreServicoCarregaMapaNegocio(beanDto, document, request);
		}

	}
	
	private void setPermissoesMapaDesenhoNegocio(DocumentHTML document, HttpServletRequest request) throws Exception {
		permissao = new Permissoes(document, request, PagesPortfolio.PORTFOLIO.getCaminho());
	}
	
	public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioMapaDesenhoNegocioDTO mapaDesenhoNegocio = (GerenciamentoPortfolioMapaDesenhoNegocioDTO) document.getBean();
		
		this.restoreMapaNegocio(mapaDesenhoNegocio, document, request);
	}

	/**
	 * Mtodo chamado aps o restore do servio de negocio, j que o mapa de
	 * desenho de negcio depende de um servio de negcio estar selecionado.
	 *
	 * @throws Exception
	 * @author rodrigo.dorighello
	 * @since 22.09.2015
	 */
	private void restoreServicoCarregaMapaNegocio(GerenciamentoPortfolioMapaDesenhoNegocioDTO mapaNegocioDto, DocumentHTML document, HttpServletRequest request) throws Exception {
		if (mapaNegocioDto != null && mapaNegocioDto.getIdServicoNegocio() != null && mapaNegocioDto.getIdPortfolioServico() != null) {
			HTMLForm form = document.getForm("formMapaDesenhoNegocio");
			form.setValues(mapaNegocioDto);

			String chaveServicosApoio = Enumerados.TipoServico.SERVICO_APOIO.getIdentificador();
			document.executeScript("atualizaLookupServicosApoio(" + mapaNegocioDto.getIdPortfolioServico() + ", '" + chaveServicosApoio + "', " + mapaNegocioDto.getIdServicoNegocio() + ");");

			restoreMapaNegocio(mapaNegocioDto, document, request);
		} else {
			document.executeScript("atualizaLookupServicosApoio(0, '', 0);");
		}

	}

	private void restoreMapaNegocio(GerenciamentoPortfolioMapaDesenhoNegocioDTO mapa, DocumentHTML document, HttpServletRequest request) throws Exception {
		if (mapa != null && mapa.getIdServicoNegocio() != null) {
			String serializacaoProcessoNegocioMapaImg = getSerializacaoItensMapaNegocio(mapa.getIdServicoNegocio(), request);
			serializacaoProcessoNegocioMapaImg = StringEscapeUtils.escapeJavaScript(serializacaoProcessoNegocioMapaImg);
			mapa.setSerializacaoItensMapaNegocio(serializacaoProcessoNegocioMapaImg);

			HTMLForm form = document.getForm("formMapaDesenhoNegocio");
			form.setValues(mapa);

			document.executeScript("atualizaMapaNegocio('" + serializacaoProcessoNegocioMapaImg + "');");
		}
	}

	private String getSerializacaoItensMapaNegocio(Integer idServicoNegocio, HttpServletRequest request) throws Exception {
		ArrayList<MapaNegocioItemDTO> itens = (ArrayList<MapaNegocioItemDTO>) this.getMapaNegocioItemService().findByIdServicoNegocio(idServicoNegocio);

		String serializado = null;

		if (itens != null) {

			for (MapaNegocioItemDTO item : itens) {

				if(item != null && (item.getIdServicoApoio() != null || item.getIdItemConfiguracao() != null)){

					if(item.getIdServicoApoio() != null){
						ServicoDTO servicoDto = new ServicoDTO();
						servicoDto.setIdServico(item.getIdServicoApoio());
						servicoDto = (ServicoDTO) this.getServicoService().restore(servicoDto);

						if (servicoDto != null) {
							item.setTitulo(servicoDto.getNomeServico());
						}
					}else if(item.getIdItemConfiguracao() != null){
						ItemConfiguracaoDTO itemConfiguracaoDto = new ItemConfiguracaoDTO();
						itemConfiguracaoDto.setIdItemConfiguracao(item.getIdItemConfiguracao());
						itemConfiguracaoDto = (ItemConfiguracaoDTO) this.getItemConfiguracaoService().restore(itemConfiguracaoDto);

						if(itemConfiguracaoDto != null && itemConfiguracaoDto.getIdentificacao() != null) {
							item.setTitulo(itemConfiguracaoDto.getIdentificacao());
						}
					}

					if (item.getIdMapaNegocioItem() != null) {
						Collection<MapaNegocioRelacaoDTO> listProcessoNegocioImagemRelacaoPai = this.getMapaNegocioRelacaoService().findByIdMapaNegocioItemFilho(item.getIdMapaNegocioItem());

						if (listProcessoNegocioImagemRelacaoPai != null && !listProcessoNegocioImagemRelacaoPai.isEmpty()) {
							String colSerializado = WebUtil.serializeObjects(listProcessoNegocioImagemRelacaoPai, WebUtil.getLanguage(request));
							item.setSerializacaoRelacoesDTO(colSerializado);
						}
					}
				}
			}
		}
		serializado = WebUtil.serializeObjects(itens, WebUtil.getLanguage(request));

		return serializado;
	}

	@SuppressWarnings("unchecked")
	public void salvarMapaNegocio(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		ArrayList<MapaNegocioItemDTO> listaItens = (ArrayList<MapaNegocioItemDTO>) WebUtil.deserializeCollectionFromRequest(MapaNegocioItemDTO.class, "serializacaoItensMapaNegocio", request);
		setPermissoesMapaDesenhoNegocio(document, request);
		GerenciamentoPortfolioMapaDesenhoNegocioDTO gerenciamentoPortfolioMapaDesenhoNegocioDTO = (GerenciamentoPortfolioMapaDesenhoNegocioDTO) document.getBean();

		if(permissao.isGravar()) {
			if (listaItens != null) {
				for (MapaNegocioItemDTO img : listaItens) {
					if (img.getIdMapaNegocioItem() == 0) {
						this.getMapaNegocioItemService().create(img);
						gerenciamentoPortfolioMapaDesenhoNegocioDTO.setAcaoDesenhoMapaNegocioOcorrenciaServico(AuditoriaAcoes.ADICIONADO.getIdentificador());
						gerenciamentoPortfolioMapaDesenhoNegocioDTO.setItemMapaNegocioOcorrenciaServico(img);
					} else {
						this.getMapaNegocioItemService().update(img);
						if (img.getIdMapaNegocioItem().equals(gerenciamentoPortfolioMapaDesenhoNegocioDTO.getIdMapaNegocioItem())) {
							gerenciamentoPortfolioMapaDesenhoNegocioDTO.setIdMapaNegocioItem(null);
							gerenciamentoPortfolioMapaDesenhoNegocioDTO.setAcaoDesenhoMapaNegocioOcorrenciaServico(AuditoriaAcoes.ALTERADO.getIdentificador());
							gerenciamentoPortfolioMapaDesenhoNegocioDTO.setItemMapaNegocioOcorrenciaServico(img);
						}
					}
					// Salvar itens na tabela de relao
					if (img.getSerializacaoRelacoesDTO() != null && UtilStrings.isNotVazio(img.getSerializacaoRelacoesDTO())) {
						Collection<MapaNegocioRelacaoDTO> listaProcessoNegocioImagemRelacao = WebUtil.deserializeCollectionFromString(MapaNegocioRelacaoDTO.class, img.getSerializacaoRelacoesDTO());
	
						for (MapaNegocioRelacaoDTO imagemRelacao : listaProcessoNegocioImagemRelacao) {
							if (imagemRelacao != null && imagemRelacao.getIdMapaNegocioItemFilho() != null && imagemRelacao.getIdMapaNegocioItemPai() != null) {
								MapaNegocioRelacaoDTO imgAux = this.getMapaNegocioRelacaoService().findByIdMapaNegocioItemFilhoAndIdItemPai(imagemRelacao.getIdMapaNegocioItemFilho(), imagemRelacao.getIdMapaNegocioItemPai());
								if(imgAux == null){
									this.getMapaNegocioRelacaoService().create(imagemRelacao);
								}
							}
						}
					}
	
				}
	
				if (gerenciamentoPortfolioMapaDesenhoNegocioDTO.getItemMapaNegocioOcorrenciaServico() != null) {
					this.salvarOcorrenciaServicoDesenhoMapaServico(document, request, response);
				}
			}
	
			restoreMapaNegocio((GerenciamentoPortfolioMapaDesenhoNegocioDTO) document.getBean(), document, request);
			document.executeScript("notificacao('"+UtilI18N.internacionaliza(request, "MSG06") +"', '');");
		} else {
			document.executeScript("notificacaoErro('citcorpore.comum.permissaoFuncionalidade');");
		}
	}

	public void excluirItemMapaNegocio(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		setPermissoesMapaDesenhoNegocio(document, request);
		GerenciamentoPortfolioMapaDesenhoNegocioDTO mapa = (GerenciamentoPortfolioMapaDesenhoNegocioDTO) document.getBean();

		if(permissao.isGravar()) {
			MapaNegocioItemDTO imagemDto = new MapaNegocioItemDTO();
			imagemDto.setIdMapaNegocioItem(mapa.getIdMapaNegocioItem());
			imagemDto = this.getMapaNegocioItemService().restore(imagemDto);
			mapa.setAcaoDesenhoMapaNegocioOcorrenciaServico(AuditoriaAcoes.REMOVIDO.getIdentificador());
			mapa.setItemMapaNegocioOcorrenciaServico(imagemDto);
	
			if (imagemDto != null) {
				if (imagemDto.getIdMapaNegocioItem() != null) {
					this.getMapaNegocioRelacaoService().deleteRelacaoByIdPai(imagemDto.getIdMapaNegocioItem());
					this.getMapaNegocioRelacaoService().deleteRelacaoByIdFilho(imagemDto.getIdMapaNegocioItem());
				}
				this.getMapaNegocioItemService().delete(imagemDto);
				String serializacaoProcessoNegocioMapaImg = getSerializacaoItensMapaNegocio(mapa.getIdServicoNegocio(), request);
				mapa.setSerializacaoItensMapaNegocio(serializacaoProcessoNegocioMapaImg);
				HTMLForm form = document.getForm("formMapaDesenhoNegocio");
				form.setValues(mapa);
				
				document.executeScript("finalizaExclusaoItemMapaNegocio('" + serializacaoProcessoNegocioMapaImg + "');");
				document.executeScript("notificacao('"+UtilI18N.internacionaliza(request, "MSG07") +"', '');");
				this.salvarOcorrenciaServicoDesenhoMapaServico(document, request, response);
			}
		} else {
			document.executeScript("notificacaoErro('citcorpore.comum.permissaoFuncionalidade');");
		}
	}

	public void servicoApoioSelecionado(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioMapaDesenhoNegocioDTO mapa = (GerenciamentoPortfolioMapaDesenhoNegocioDTO) document.getBean();

		ServicoDTO servicoDto = new ServicoDTO();
		servicoDto.setIdServico(mapa.getIdServicoApoio());
		servicoDto = (ServicoDTO) this.getServicoService().restore(servicoDto);

		if (servicoDto != null) {
			mapa.setIdServicoApoio(servicoDto.getIdServico());

			HTMLForm form = document.getForm("formMapaDesenhoNegocio");
			form.setValues(mapa);
		}
	}

	public void itemConfiguracaoSelecionado(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioMapaDesenhoNegocioDTO mapa = (GerenciamentoPortfolioMapaDesenhoNegocioDTO) document.getBean();

		try{
			if(mapa != null && mapa.getIdItemConfiguracao() != null){
				ItemConfiguracaoDTO item = new ItemConfiguracaoDTO();
				item.setIdItemConfiguracao(mapa.getIdItemConfiguracao());
				item = (ItemConfiguracaoDTO) this.getItemConfiguracaoService().restore(item);


				if(item != null && item.getIdentificacao() != null){
					document.executeScript("depoisSelecionarICMapaNegocio('"+item.getIdentificacao()+"');");
				}
			} else {
				document.executeScript("JANELA_AGUARDE_MENU.hide();");
			}
		}catch(Exception e){
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
			throw new Exception(e);
		}
	}

	private ServicoService getServicoService() throws ServiceException {
		if (servicoService == null) {
			servicoService = (ServicoService) ServiceLocator.getInstance().getService(ServicoService.class, null);
		}
		return servicoService;
	}

	private EvmConexaoService getEvmConexaoService() throws ServiceException {
		if (evmConexaoService == null) {
			evmConexaoService = (EvmConexaoService) ServiceLocator.getInstance().getService(EvmConexaoService.class, null);
		}
		return evmConexaoService;
	}

	private MapaNegocioItemService getMapaNegocioItemService() throws ServiceException {
		if (mapaNegocioItemService == null) {
			mapaNegocioItemService = (MapaNegocioItemService) ServiceLocator.getInstance().getService(MapaNegocioItemService.class, null);
		}
		return mapaNegocioItemService;
	}

	private MapaNegocioRelacaoService getMapaNegocioRelacaoService() throws ServiceException {
		if (mapaNegocioRelacaoService == null) {
			mapaNegocioRelacaoService = (MapaNegocioRelacaoService) ServiceLocator.getInstance().getService(MapaNegocioRelacaoService.class, null);
		}
		return mapaNegocioRelacaoService;
	}

	private ItemConfiguracaoService getItemConfiguracaoService() throws ServiceException {
		if (itemConfiguracaoService == null) {
			itemConfiguracaoService = (ItemConfiguracaoService) ServiceLocator.getInstance().getService(ItemConfiguracaoService.class, null);
		}
		return itemConfiguracaoService;
	}

	@Override
	public Class<GerenciamentoPortfolioMapaDesenhoNegocioDTO> getBeanClass() {
		return GerenciamentoPortfolioMapaDesenhoNegocioDTO.class;
	}

	/**
	 * @author deborah.ferreira
	 * @since 03.02.2016
	 */
	public void salvarOcorrenciaServicoDesenhoMapaServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioMapaDesenhoNegocioDTO gerenciamentoPortfolioMapaDesenhoNegocioDTO = (GerenciamentoPortfolioMapaDesenhoNegocioDTO) document.getBean();
		GerenciamentoPortfolioOcorrenciasServico gerenciamentoPortfolioOcorrenciasServico = new GerenciamentoPortfolioOcorrenciasServico();

		gerenciamentoPortfolioOcorrenciasServico.salvaOcorrenciaServicoDesenhoMapaServico(gerenciamentoPortfolioMapaDesenhoNegocioDTO.getIdServicoNegocio(),
				gerenciamentoPortfolioMapaDesenhoNegocioDTO,
				document, request);
	}
}
