package br.com.centralit.citcorpore.ajaxForms;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.AtributosFinanceirosDTO;
import br.com.centralit.citcorpore.bean.CasoNegocioDTO;
import br.com.centralit.citcorpore.bean.DonoNegocioDTO;
import br.com.centralit.citcorpore.bean.EsquemaDadosDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioAplicacoesDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioBusinessUserDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioCadastroServicoNegocioDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioConhecimentoDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioHabilidadeDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioMapaDesenhoNegocioDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioOcorrenciasServicoDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioProcessoNegocioDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioProprietariosDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoAnexosDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoAplicacaoDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoAtributosFinanceirosDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoBaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoCapacidadeDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoCasoNegocioDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoContratoDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoDemandaDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoDesenhoMapaServicoDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoDetalhesDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoDonoNegocioDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoEsquemaDadosDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoHabilidadeDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoProcessoNegocioDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoProprietariosDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoRelacionadoDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoRequisitosNivelServicoDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaServicoUsuarioNegocioDTO;
import br.com.centralit.citcorpore.bean.RequisitosNivelServicoDTO;
import br.com.centralit.citcorpore.integracao.OcorrenciaServicoCapacidadeService;
import br.com.centralit.citcorpore.negocio.CasoNegocioService;
import br.com.centralit.citcorpore.negocio.OcorrenciaServicoAnexosService;
import br.com.centralit.citcorpore.negocio.OcorrenciaServicoAplicacaoService;
import br.com.centralit.citcorpore.negocio.OcorrenciaServicoAtributosFinanceirosService;
import br.com.centralit.citcorpore.negocio.OcorrenciaServicoBaseConhecimentoService;
import br.com.centralit.citcorpore.negocio.OcorrenciaServicoCasoNegocioService;
import br.com.centralit.citcorpore.negocio.OcorrenciaServicoContratoService;
import br.com.centralit.citcorpore.negocio.OcorrenciaServicoDemandaService;
import br.com.centralit.citcorpore.negocio.OcorrenciaServicoDesenhoMapaServicoService;
import br.com.centralit.citcorpore.negocio.OcorrenciaServicoDetalhesService;
import br.com.centralit.citcorpore.negocio.OcorrenciaServicoDonoNegocioService;
import br.com.centralit.citcorpore.negocio.OcorrenciaServicoEsquemaDadosService;
import br.com.centralit.citcorpore.negocio.OcorrenciaServicoHabilidadeService;
import br.com.centralit.citcorpore.negocio.OcorrenciaServicoProcessoNegocioService;
import br.com.centralit.citcorpore.negocio.OcorrenciaServicoProprietariosService;
import br.com.centralit.citcorpore.negocio.OcorrenciaServicoRelacionadoService;
import br.com.centralit.citcorpore.negocio.OcorrenciaServicoRequisitosNivelServicoService;
import br.com.centralit.citcorpore.negocio.OcorrenciaServicoService;
import br.com.centralit.citcorpore.negocio.OcorrenciaServicoUsuarioNegocioService;
import br.com.centralit.citcorpore.negocio.RequisitosNivelServicoService;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaTipos;
import br.com.centralit.citcorpore.util.Enumerados.BusinessUserTipo;
import br.com.centralit.citcorpore.util.Enumerados.ClassificacaoTipoFinanceiro;
import br.com.centralit.citcorpore.util.Enumerados.CriticidadeServico;
import br.com.centralit.citcorpore.util.Enumerados.DemandaServicoNegocio;
import br.com.centralit.citcorpore.util.Enumerados.DonoNegocioTipo;
import br.com.centralit.citcorpore.util.Enumerados.FaseServico;
import br.com.centralit.citcorpore.util.Enumerados.OcorrenciaServicoCategorias;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.Enumerados.PerfilFinanceiro;
import br.com.centralit.citcorpore.util.Enumerados.ProcessoDeIniciacao;
import br.com.centralit.citcorpore.util.Enumerados.ProprietariosTipo;
import br.com.centralit.citcorpore.util.Enumerados.RetornoFinanceiroServico;
import br.com.centralit.citcorpore.util.Enumerados.StatusServico;
import br.com.centralit.citcorpore.util.Enumerados.TipoAnexoCasoNegocio;
import br.com.centralit.citcorpore.util.Enumerados.TipoAnexoRequisitosNivelServico;
import br.com.centralit.citcorpore.util.Enumerados.TipoDate;
import br.com.centralit.citcorpore.util.Enumerados.TipoDeInvestimento;
import br.com.centralit.citcorpore.util.Enumerados.TipoItemMapaServico;
import br.com.centralit.citcorpore.util.Enumerados.TipoServico;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.Util;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.core.PageRequest;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Reflexao;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilListas;
import br.com.citframework.util.UtilNumbersAndDecimals;
import br.com.citframework.util.UtilStrings;

public class GerenciamentoPortfolioOcorrenciasServico extends AjaxFormAction {

	private OcorrenciaServicoService ocorrenciaServicoService;
	private OcorrenciaServicoDetalhesService ocorrenciaServicoDetalhesService;
	private OcorrenciaServicoRequisitosNivelServicoService ocorrenciaServicoRequisitosNivelServicoService;
	private OcorrenciaServicoAtributosFinanceirosService ocorrenciaServicoAtributosFinanceirosService;
	private OcorrenciaServicoCasoNegocioService ocorrenciaServicoCasoNegocioService;
	private OcorrenciaServicoProcessoNegocioService ocorrenciaServicoProcessoNegocioService;
	private OcorrenciaServicoDonoNegocioService ocorrenciaServicoDonoNegocioService;
	private OcorrenciaServicoUsuarioNegocioService ocorrenciaServicoUsuarioNegocioService;
	private OcorrenciaServicoRelacionadoService ocorrenciaServicoRelacionadoService;
	private OcorrenciaServicoAplicacaoService ocorrenciaServicoAplicacaoService;
	private OcorrenciaServicoContratoService ocorrenciaServicoContratoService;
	private OcorrenciaServicoProprietariosService ocorrenciaServicoProprietariosService;
	private OcorrenciaServicoEsquemaDadosService ocorrenciaServicoEsquemaDadosService;
	private OcorrenciaServicoAnexosService ocorrenciaServicoAnexosService;
	private OcorrenciaServicoDesenhoMapaServicoService ocorrenciaServicoDesenhoMapaServicoService;
	private OcorrenciaServicoBaseConhecimentoService ocorrenciaServicoBaseConhecimentoService;
	private OcorrenciaServicoHabilidadeService ocorrenciaServicoHabilidadeService;
	private OcorrenciaServicoDemandaService ocorrenciaServicoDemandaService;
	private OcorrenciaServicoCapacidadeService ocorrenciaServicoCapacidadeService;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioOcorrenciasServicoDTO beanDto = (GerenciamentoPortfolioOcorrenciasServicoDTO) document.getBean();

		if (beanDto != null && !UtilNumbersAndDecimals.isNull(beanDto.getIdServico())) {
			this.restoreOcorrencias(beanDto, document, request, response);
		}
	}

	/**
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	private void restoreOcorrencias(GerenciamentoPortfolioOcorrenciasServicoDTO beanDto, DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		this.carregarComboCategoria(document.getSelectById("categoriaOcorrenciaServico"), request);
		this.carregarComboCategoria(document.getSelectById("categoriaFiltroOcorrenciaServico"), request);
		document.getForm("formPortfolioOcorrenciasServico").setValues(beanDto);
		montarHTMLOcorrencia(document, request, response);
	}

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.AuditoriaTipos
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) {
		try {
			WebUtil.validarSeUsuarioEstaNaSessao(request, document);
			GerenciamentoPortfolioOcorrenciasServicoDTO gerenciamentoPortfolioOcorrenciasServicoDTO = (GerenciamentoPortfolioOcorrenciasServicoDTO) document.getBean();
			OcorrenciaServicoDTO ocorrenciaServicoDTO = new OcorrenciaServicoDTO();
			ocorrenciaServicoDTO.setIdServico(gerenciamentoPortfolioOcorrenciasServicoDTO.getIdServico());
			ocorrenciaServicoDTO.setTipoOcorrencia(AuditoriaTipos.MANUAL.getIdentificador());
			ocorrenciaServicoDTO.setCategoriaOcorrencia(gerenciamentoPortfolioOcorrenciasServicoDTO.getCategoriaOcorrencia());
			ocorrenciaServicoDTO.setDescricaoOcorrencia(gerenciamentoPortfolioOcorrenciasServicoDTO.getDescricaoOcorrencia());

			ocorrenciaServicoDTO = createOcorrenciaServico(ocorrenciaServicoDTO, request);

			if (ocorrenciaServicoDTO != null && ocorrenciaServicoDTO.getIdOcorrenciaServico() != null) {
				document.executeScript("PortfolioOcorrencias.gerarOcorrencias();");
				document.executeScript("notificacaoI18N('MSG05','')");
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.OcorrenciaServicoCategorias
	 * @since 28.01.2016
	 * @author deborah.ferreira
	 */
	private void carregarComboCategoria(HTMLSelect comboCategoria, HttpServletRequest request) throws Exception {
		comboCategoria.removeAllOptions();
		comboCategoria.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

		for (OcorrenciaServicoCategorias ocorrenciaServicoCategorias : OcorrenciaServicoCategorias.values()) {
			comboCategoria.addOption(ocorrenciaServicoCategorias.getIdentificador(), UtilI18N.internacionaliza(request, ocorrenciaServicoCategorias.getChave()));
		}
	}

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.OcorrenciaServicoCategorias
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	public void salvaOcorrenciaServicoDetalhes(GerenciamentoPortfolioCadastroServicoNegocioDTO gerenciamentoPortfolioCadastroServicoNegocioDTO, DocumentHTML document, HttpServletRequest request) {
		try {
			WebUtil.validarSeUsuarioEstaNaSessao(request, document);
			OcorrenciaServicoDTO ocorrenciaServicoDTO = this.createOcorrenciaServicoAutomatica(gerenciamentoPortfolioCadastroServicoNegocioDTO.getIdServico(),
					OcorrenciaServicoCategorias.DETALHES_SERVICO.getIdentificador(), document, request);

			if (ocorrenciaServicoDTO != null && ocorrenciaServicoDTO.getIdOcorrenciaServico() != null) {
				String acaoOcorrenciaServico = gerenciamentoPortfolioCadastroServicoNegocioDTO.getAcaoDetalhesOcorrenciaServico();
				String acaoOcorrenciaServicoAnexos = acaoOcorrenciaServico.equals(AuditoriaAcoes.REMOVIDO.getIdentificador()) ? AuditoriaAcoes.REMOVIDO.getIdentificador()
						: AuditoriaAcoes.ADICIONADO.getIdentificador();

				if (acaoOcorrenciaServico.equals(AuditoriaAcoes.REMOVIDO.getIdentificador()) || acaoOcorrenciaServico.equals(AuditoriaAcoes.ADICIONADO.getIdentificador())) {
					acaoOcorrenciaServico = AuditoriaAcoes.ALTERADO.getIdentificador();
				}

				this.getOcorrenciaServicoDetalhesService().createOcorrenciaServicoDetalhes(ocorrenciaServicoDTO.getIdOcorrenciaServico(), acaoOcorrenciaServico);

				this.getOcorrenciaServicoAnexosService().createOcorrenciaServicoAnexos(ocorrenciaServicoDTO,
						Util.listStrToListInteger(gerenciamentoPortfolioCadastroServicoNegocioDTO.getListaIdsAnexosServicoOcorrenciaServico()), acaoOcorrenciaServicoAnexos);

				if (acaoOcorrenciaServicoAnexos.equals(AuditoriaAcoes.REMOVIDO.getIdentificador())) {
					if (gerenciamentoPortfolioCadastroServicoNegocioDTO.getAnexoRemovidoServico() != null) {
						this.getOcorrenciaServicoAnexosService().createOcorrenciaServicoAnexosRemovido(ocorrenciaServicoDTO.getIdOcorrenciaServico(),
								gerenciamentoPortfolioCadastroServicoNegocioDTO.getAnexoRemovidoServico());
					}
				}
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.OcorrenciaServicoCategorias
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	public void salvaOcorrenciaServicoRequisitoNivelServico(RequisitosNivelServicoDTO requisitosNivelServicoDTO, DocumentHTML document, HttpServletRequest request) {
		try {
			WebUtil.validarSeUsuarioEstaNaSessao(request, document);
			OcorrenciaServicoDTO ocorrenciaServicoDTO = this.createOcorrenciaServicoAutomatica(requisitosNivelServicoDTO.getIdServicoNegocio(), OcorrenciaServicoCategorias.REQUISITOS_NIVEL_SERVICO.getIdentificador(),
					document, request);

			if (ocorrenciaServicoDTO != null && ocorrenciaServicoDTO.getIdOcorrenciaServico() != null && requisitosNivelServicoDTO != null) {
				String acaoOcorrenciaServico = requisitosNivelServicoDTO.getAcaoRequisitosNivelServicoOcorrenciaServico();
				String acaoOcorrenciaServicoAnexos = acaoOcorrenciaServico.equals(AuditoriaAcoes.REMOVIDO.getIdentificador()) ? AuditoriaAcoes.REMOVIDO.getIdentificador()
						: AuditoriaAcoes.ADICIONADO.getIdentificador();

				if (acaoOcorrenciaServico.equals(AuditoriaAcoes.REMOVIDO.getIdentificador()) || acaoOcorrenciaServico.equals(AuditoriaAcoes.ADICIONADO.getIdentificador())) {
					acaoOcorrenciaServico = AuditoriaAcoes.ALTERADO.getIdentificador();
				}

				OcorrenciaServicoRequisitosNivelServicoDTO ocorrenciaServicoRequisitoNivelServicoDTO = new OcorrenciaServicoRequisitosNivelServicoDTO();

				if (acaoOcorrenciaServicoAnexos.equals(AuditoriaAcoes.REMOVIDO.getIdentificador())) {
					RequisitosNivelServicoService requisitosNivelServicoService = (RequisitosNivelServicoService) ServiceLocator.getInstance().getService(RequisitosNivelServicoService.class, null);
					Reflexao.copyPropertyValues(requisitosNivelServicoService.restore(requisitosNivelServicoDTO), ocorrenciaServicoRequisitoNivelServicoDTO);
				} else {
					Reflexao.copyPropertyValues(requisitosNivelServicoDTO, ocorrenciaServicoRequisitoNivelServicoDTO);
				}

				if (ocorrenciaServicoRequisitoNivelServicoDTO != null) {
					OcorrenciaServicoRequisitosNivelServicoService ocorrenciaServicoRequisitoNivelServicoService = (OcorrenciaServicoRequisitosNivelServicoService) ServiceLocator.getInstance()
							.getService(OcorrenciaServicoRequisitosNivelServicoService.class, null);
					ocorrenciaServicoRequisitoNivelServicoDTO.setIdOcorrenciaServico(ocorrenciaServicoDTO.getIdOcorrenciaServico());
					ocorrenciaServicoRequisitoNivelServicoDTO.setAcaoOcorrenciaServico(acaoOcorrenciaServico);
					ocorrenciaServicoRequisitoNivelServicoService.create(ocorrenciaServicoRequisitoNivelServicoDTO);

					this.getOcorrenciaServicoAnexosService().createOcorrenciaServicoAnexos(ocorrenciaServicoDTO,
							Util.listStrToListInteger(requisitosNivelServicoDTO.getListaIdsAnexosRequisitosNivelServicoOcorrenciaServico()), acaoOcorrenciaServicoAnexos);

					if (acaoOcorrenciaServicoAnexos.equals(AuditoriaAcoes.REMOVIDO.getIdentificador())) {
						if (requisitosNivelServicoDTO.getAnexoRemovidoRequisitosNivelServico() != null) {
							this.getOcorrenciaServicoAnexosService().createOcorrenciaServicoAnexosRemovido(ocorrenciaServicoDTO.getIdOcorrenciaServico(),
									requisitosNivelServicoDTO.getAnexoRemovidoRequisitosNivelServico());
						}
					}
				}

			}

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.OcorrenciaServicoCategorias
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	public void salvaOcorrenciaServicoCasoNegocio(CasoNegocioDTO casoNegocioDTO, DocumentHTML document, HttpServletRequest request) {
		try {
			WebUtil.validarSeUsuarioEstaNaSessao(request, document);
			OcorrenciaServicoDTO ocorrenciaServicoDTO = this.createOcorrenciaServicoAutomatica(casoNegocioDTO.getIdServico(), OcorrenciaServicoCategorias.CASOS_NEGOCIO.getIdentificador(), document, request);

			if (ocorrenciaServicoDTO != null && ocorrenciaServicoDTO.getIdOcorrenciaServico() != null) {
				String acaoOcorrenciaServico = casoNegocioDTO.getAcaoCasoNegocioOcorrenciaServico();
				String acaoOcorrenciaServicoAnexos = acaoOcorrenciaServico.equals(AuditoriaAcoes.REMOVIDO.getIdentificador()) ? AuditoriaAcoes.REMOVIDO.getIdentificador()
						: AuditoriaAcoes.ADICIONADO.getIdentificador();

				if (acaoOcorrenciaServico.equals(AuditoriaAcoes.REMOVIDO.getIdentificador()) || acaoOcorrenciaServico.equals(AuditoriaAcoes.ADICIONADO.getIdentificador())) {
					acaoOcorrenciaServico = AuditoriaAcoes.ALTERADO.getIdentificador();
				}

				OcorrenciaServicoCasoNegocioDTO ocorrenciaServicoCasoNegocioDTO = new OcorrenciaServicoCasoNegocioDTO();

				if (acaoOcorrenciaServicoAnexos.equals(AuditoriaAcoes.REMOVIDO.getIdentificador())) {
					CasoNegocioService casoNegocioService = (CasoNegocioService) ServiceLocator.getInstance().getService(CasoNegocioService.class, null);
					Reflexao.copyPropertyValues(casoNegocioService.restore(casoNegocioDTO), ocorrenciaServicoCasoNegocioDTO);
				} else {
					Reflexao.copyPropertyValues(casoNegocioDTO, ocorrenciaServicoCasoNegocioDTO);
				}

				if (ocorrenciaServicoCasoNegocioDTO != null) {
					ocorrenciaServicoCasoNegocioDTO.setIdOcorrenciaServico(ocorrenciaServicoDTO.getIdOcorrenciaServico());
					ocorrenciaServicoCasoNegocioDTO.setAcaoOcorrenciaServico(acaoOcorrenciaServico);
					getOcorrenciaServicoCasoNegocioService().create(ocorrenciaServicoCasoNegocioDTO);

					this.getOcorrenciaServicoAnexosService().createOcorrenciaServicoAnexos(ocorrenciaServicoDTO, Util.listStrToListInteger(casoNegocioDTO.getListaIdsAnexosCasoNegocioOcorrenciaServico()),
							acaoOcorrenciaServicoAnexos);

					if (acaoOcorrenciaServicoAnexos.equals(AuditoriaAcoes.REMOVIDO.getIdentificador())) {
						if (casoNegocioDTO.getAnexoRemovidoCasoNegocio() != null) {
							this.getOcorrenciaServicoAnexosService().createOcorrenciaServicoAnexosRemovido(ocorrenciaServicoDTO.getIdOcorrenciaServico(), casoNegocioDTO.getAnexoRemovidoCasoNegocio());
						}
					}
				}
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.OcorrenciaServicoCategorias
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	public void salvaOcorrenciaServicoAtributosFinanceiros(Integer idServico, String listaIdsOcorrenciaServicoStr, AtributosFinanceirosDTO atributosFinanceirosDTO, DocumentHTML document, HttpServletRequest request) {
		try {
			WebUtil.validarSeUsuarioEstaNaSessao(request, document);
			OcorrenciaServicoDTO ocorrenciaServicoDTO = this.createOcorrenciaServicoAutomatica(idServico, OcorrenciaServicoCategorias.ATRIBUTOS_FINANCEIROS.getIdentificador(), document, request);

			if (ocorrenciaServicoDTO != null && ocorrenciaServicoDTO.getIdOcorrenciaServico() != null) {
				getOcorrenciaServicoAtributosFinanceirosService().createOcorrenciaServicoAtributosFinanceiros(ocorrenciaServicoDTO.getIdOcorrenciaServico(), Util.listStrToListInteger(listaIdsOcorrenciaServicoStr),
						atributosFinanceirosDTO);
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.OcorrenciaServicoCategorias
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	public void salvaOcorrenciaServicoProcessoNegocio(Integer idServico, GerenciamentoPortfolioProcessoNegocioDTO gerenciamentoPortfolioProcessoNegocioDTO, DocumentHTML document, HttpServletRequest request) {
		try {
			WebUtil.validarSeUsuarioEstaNaSessao(request, document);
			OcorrenciaServicoDTO ocorrenciaServicoDTO = this.createOcorrenciaServicoAutomatica(idServico, OcorrenciaServicoCategorias.PROCESSO_NEGOCIO.getIdentificador(), document, request);

			if (ocorrenciaServicoDTO != null && ocorrenciaServicoDTO.getIdOcorrenciaServico() != null) {
				getOcorrenciaServicoProcessoNegocioService().createOcorrenciaServicoProcessoNegocio(ocorrenciaServicoDTO.getIdOcorrenciaServico(),
						Util.listStrToListInteger(gerenciamentoPortfolioProcessoNegocioDTO.getIdsProcessoNegocioOcorrenciaServico()), gerenciamentoPortfolioProcessoNegocioDTO.getAcaoProcessoNegocioOcorrenciaServico());
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.OcorrenciaServicoCategorias
	 * @author deborah.ferreira
	 * @since 27.01.2016
	 */
	public void salvaOcorrenciaServicoRelacionado(Integer idServico, String listaIdsOcorrenciaServicoStr, String acaoOcorrenciaServico, String tipoServico, DocumentHTML document, HttpServletRequest request) {
		try {
			WebUtil.validarSeUsuarioEstaNaSessao(request, document);
			String categoriaServico = "";

			if (tipoServico.equalsIgnoreCase(TipoServico.SERVICO_APOIO.getIdentificador())) {
				categoriaServico = OcorrenciaServicoCategorias.SERVICOS_APOIO.getIdentificador();
			} else if (tipoServico.equalsIgnoreCase(TipoServico.SERVICO_REQUISICAO.getIdentificador())) {
				categoriaServico = OcorrenciaServicoCategorias.REQUISICAO_SERVICOS.getIdentificador();
			} else if (tipoServico.equalsIgnoreCase(TipoServico.SERVICO_INCIDENTE.getIdentificador())) {
				categoriaServico = OcorrenciaServicoCategorias.INCIDENTES.getIdentificador();
			} else if (tipoServico.equalsIgnoreCase(TipoServico.SERVICO_PROCEDIMENTO.getIdentificador())) {
				categoriaServico = OcorrenciaServicoCategorias.PROCEDIMENTO.getIdentificador();
			}

			OcorrenciaServicoDTO ocorrenciaServicoDTO = this.createOcorrenciaServicoAutomatica(idServico, categoriaServico, document, request);

			if (ocorrenciaServicoDTO != null && ocorrenciaServicoDTO.getIdOcorrenciaServico() != null) {
				getOcorrenciaServicoRelacionadoService().createOcorrenciaServicoRelacionado(ocorrenciaServicoDTO.getIdOcorrenciaServico(), Util.listStrToListInteger(listaIdsOcorrenciaServicoStr), acaoOcorrenciaServico,
						tipoServico);
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.OcorrenciaServicoCategorias
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	public void salvaOcorrenciaServicoDonoNegocio(Integer idServico, DonoNegocioDTO donoNegocioDTO, DocumentHTML document, HttpServletRequest request) {
		try {
			WebUtil.validarSeUsuarioEstaNaSessao(request, document);
			OcorrenciaServicoDTO ocorrenciaServicoDTO = this.createOcorrenciaServicoAutomatica(idServico, OcorrenciaServicoCategorias.DONO_NEGOCIO.getIdentificador(), document, request);

			if (ocorrenciaServicoDTO != null && ocorrenciaServicoDTO.getIdOcorrenciaServico() != null) {
				getOcorrenciaServicoDonoNegocioService().createOcorrenciaServicoDonoNegocio(ocorrenciaServicoDTO.getIdOcorrenciaServico(), Util.listStrToListInteger(donoNegocioDTO.getIdsDonoNegocioOcorrenciaServico()),
						donoNegocioDTO);
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.OcorrenciaServicoCategorias
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	public void salvaOcorrenciaServicoUsuarioNegocio(Integer idServico, GerenciamentoPortfolioBusinessUserDTO usuarioNegocioDTO, DocumentHTML document, HttpServletRequest request) {
		try {
			WebUtil.validarSeUsuarioEstaNaSessao(request, document);
			OcorrenciaServicoDTO ocorrenciaServicoDTO = this.createOcorrenciaServicoAutomatica(idServico, OcorrenciaServicoCategorias.USUARIO_NEGOCIO.getIdentificador(), document, request);

			if (ocorrenciaServicoDTO != null && ocorrenciaServicoDTO.getIdOcorrenciaServico() != null) {
				getOcorrenciaServicoUsuarioNegocioService().createOcorrenciaServicoUsuarioNegocio(ocorrenciaServicoDTO.getIdOcorrenciaServico(),
						Util.listStrToListInteger(usuarioNegocioDTO.getIdsUsuarioNegocioOcorrenciaServico()), usuarioNegocioDTO);
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.OcorrenciaServicoCategorias
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	public void salvaOcorrenciaServicoAplicacao(Integer idServico, GerenciamentoPortfolioAplicacoesDTO gerenciamentoPortfolioAplicacoesDTO, DocumentHTML document, HttpServletRequest request) {
		try {
			WebUtil.validarSeUsuarioEstaNaSessao(request, document);
			OcorrenciaServicoDTO ocorrenciaServicoDTO = this.createOcorrenciaServicoAutomatica(idServico, OcorrenciaServicoCategorias.APLICACOES.getIdentificador(), document, request);

			if (ocorrenciaServicoDTO != null && ocorrenciaServicoDTO.getIdOcorrenciaServico() != null) {
				getOcorrenciaServicoAplicacaoService().createOcorrenciaServicoAplicacao(ocorrenciaServicoDTO.getIdOcorrenciaServico(),
						Util.listStrToListInteger(gerenciamentoPortfolioAplicacoesDTO.getIdsAplicacoesOcorrenciaServico()), gerenciamentoPortfolioAplicacoesDTO.getAcaoAplicacoesOcorrenciaServico());
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.OcorrenciaServicoCategorias
	 * @author deborah.ferreira
	 * @since 29.01.2016
	 */
	public void salvaOcorrenciaServicoContrato(Integer idServico, String listaIdsStr, String acaoOcorrenciaServico, DocumentHTML document, HttpServletRequest request) {
		try {
			WebUtil.validarSeUsuarioEstaNaSessao(request, document);
			OcorrenciaServicoDTO ocorrenciaServicoDTO = this.createOcorrenciaServicoAutomatica(idServico, OcorrenciaServicoCategorias.CONTRATOS.getIdentificador(), document, request);

			if (ocorrenciaServicoDTO != null && ocorrenciaServicoDTO.getIdOcorrenciaServico() != null) {
				getOcorrenciaServicoContratoService().createOcorrenciaServicoContrato(ocorrenciaServicoDTO.getIdOcorrenciaServico(), Util.listStrToListInteger(listaIdsStr), acaoOcorrenciaServico);
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.OcorrenciaServicoCategorias
	 * @author deborah.ferreira
	 * @since 01.02.2016
	 */
	public void salvaOcorrenciaServicoProprietarios(Integer idServico, GerenciamentoPortfolioProprietariosDTO gerenciamentoPortfolioProprietariosDTO, DocumentHTML document, HttpServletRequest request) {
		try {
			WebUtil.validarSeUsuarioEstaNaSessao(request, document);
			OcorrenciaServicoDTO ocorrenciaServicoDTO = this.createOcorrenciaServicoAutomatica(idServico, OcorrenciaServicoCategorias.PROPRIETARIOS_TI.getIdentificador(), document, request);

			if (ocorrenciaServicoDTO != null && ocorrenciaServicoDTO.getIdOcorrenciaServico() != null && gerenciamentoPortfolioProprietariosDTO != null) {
				this.getOcorrenciaServicoProprietariosService().createOcorrenciaServicoProprietarios(ocorrenciaServicoDTO.getIdOcorrenciaServico(),
						Util.listStrToListInteger(gerenciamentoPortfolioProprietariosDTO.getIdsProprietariosOcorrenciaServico()), gerenciamentoPortfolioProprietariosDTO);

			}

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.OcorrenciaServicoCategorias
	 * @author deborah.ferreira
	 * @since 02.02.2016
	 */
	public void salvaOcorrenciaServicoEsquemaDados(Integer idServico, EsquemaDadosDTO esquemaDadosDTO, DocumentHTML document, HttpServletRequest request) {
		try {
			WebUtil.validarSeUsuarioEstaNaSessao(request, document);
			OcorrenciaServicoDTO ocorrenciaServicoDTO = this.createOcorrenciaServicoAutomatica(idServico, OcorrenciaServicoCategorias.ESQUEMA_DADOS.getIdentificador(), document, request);

			if (ocorrenciaServicoDTO != null && ocorrenciaServicoDTO.getIdOcorrenciaServico() != null && esquemaDadosDTO != null) {
				String acaoOcorrenciaServico = esquemaDadosDTO.getAcaoEsquemaDadosOcorrenciaServico();
				String acaoOcorrenciaServicoAnexos = acaoOcorrenciaServico.equals(AuditoriaAcoes.REMOVIDO.getIdentificador()) ? AuditoriaAcoes.REMOVIDO.getIdentificador()
						: AuditoriaAcoes.ADICIONADO.getIdentificador();

				if (acaoOcorrenciaServico.equals(AuditoriaAcoes.REMOVIDO.getIdentificador()) || acaoOcorrenciaServico.equals(AuditoriaAcoes.ADICIONADO.getIdentificador())) {
					acaoOcorrenciaServico = AuditoriaAcoes.ALTERADO.getIdentificador();
				}

				this.getOcorrenciaServicoEsquemaDadosService().createOcorrenciaServicoEsquemaDados(ocorrenciaServicoDTO.getIdOcorrenciaServico(), acaoOcorrenciaServico);

				this.getOcorrenciaServicoAnexosService().createOcorrenciaServicoAnexos(ocorrenciaServicoDTO, Util.listStrToListInteger(esquemaDadosDTO.getListaIdsAnexosEsquemaDadosOcorrenciaServico()),
						acaoOcorrenciaServicoAnexos);

				if (acaoOcorrenciaServicoAnexos.equals(AuditoriaAcoes.REMOVIDO.getIdentificador())) {
					if (esquemaDadosDTO.getAnexoRemovido() != null) {
						this.getOcorrenciaServicoAnexosService().createOcorrenciaServicoAnexosRemovido(ocorrenciaServicoDTO.getIdOcorrenciaServico(), esquemaDadosDTO.getAnexoRemovido());
					}
				}
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.OcorrenciaServicoCategorias
	 * @author deborah.ferreira
	 * @since 03.02.2016
	 */
	public void salvaOcorrenciaServicoDesenhoMapaServico(Integer idServico, GerenciamentoPortfolioMapaDesenhoNegocioDTO gerenciamentoPortfolioMapaDesenhoNegocioDTO, DocumentHTML document, HttpServletRequest request) {
		try {
			WebUtil.validarSeUsuarioEstaNaSessao(request, document);
			OcorrenciaServicoDTO ocorrenciaServicoDTO = this.createOcorrenciaServicoAutomatica(idServico, OcorrenciaServicoCategorias.DESENHO_MAPA_SERVICO.getIdentificador(), document, request);

			if (ocorrenciaServicoDTO != null && ocorrenciaServicoDTO.getIdOcorrenciaServico() != null && gerenciamentoPortfolioMapaDesenhoNegocioDTO != null) {

				if (gerenciamentoPortfolioMapaDesenhoNegocioDTO.getItemMapaNegocioOcorrenciaServico() != null) {
					this.getOcorrenciaServicoDesenhoMapaServicoService().createOcorrenciaServicoDesenhoMapaServico(ocorrenciaServicoDTO.getIdOcorrenciaServico(),
							gerenciamentoPortfolioMapaDesenhoNegocioDTO.getItemMapaNegocioOcorrenciaServico(), gerenciamentoPortfolioMapaDesenhoNegocioDTO.getAcaoDesenhoMapaNegocioOcorrenciaServico());
				}
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.OcorrenciaServicoCategorias
	 * @author deborah.ferreira
	 * @since 17.02.2016
	 */
	public void salvaOcorrenciaServicoBaseConhecimento(Integer idServico, GerenciamentoPortfolioConhecimentoDTO gerenciamentoPortfolioConhecimentoDTO, DocumentHTML document, HttpServletRequest request) {
		try {
			WebUtil.validarSeUsuarioEstaNaSessao(request, document);
			OcorrenciaServicoDTO ocorrenciaServicoDTO = this.createOcorrenciaServicoAutomatica(idServico, OcorrenciaServicoCategorias.BASE_CONHECIMENTO.getIdentificador(), document, request);

			if (ocorrenciaServicoDTO != null && ocorrenciaServicoDTO.getIdOcorrenciaServico() != null) {
				this.getOcorrenciaServicoBaseConhecimentoService().createOcorrenciaServicoBaseConhecimento(ocorrenciaServicoDTO.getIdOcorrenciaServico(),
						Util.listStrToListInteger(gerenciamentoPortfolioConhecimentoDTO.getIdsBaseConhecimentoOcorrenciaServico()), gerenciamentoPortfolioConhecimentoDTO.getAcaoBaseConhecimentoOcorrenciaServico());
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.OcorrenciaServicoCategorias
	 * @author deborah.ferreira
	 * @since 17.02.2016
	 */
	public void salvaOcorrenciaServicoHabilidade(Integer idServico, GerenciamentoPortfolioHabilidadeDTO gerenciamentoPortfolioHabilidadeDTO, DocumentHTML document, HttpServletRequest request) {
		try {
			WebUtil.validarSeUsuarioEstaNaSessao(request, document);
			OcorrenciaServicoDTO ocorrenciaServicoDTO = this.createOcorrenciaServicoAutomatica(idServico, OcorrenciaServicoCategorias.HABILIDADE.getIdentificador(), document, request);

			if (ocorrenciaServicoDTO != null && ocorrenciaServicoDTO.getIdOcorrenciaServico() != null) {
				this.getOcorrenciaServicoHabilidadeService().createOcorrenciaServicoHabilidade(ocorrenciaServicoDTO.getIdOcorrenciaServico(),
						Util.listStrToListInteger(gerenciamentoPortfolioHabilidadeDTO.getIdsHabilidadeOcorrenciaServico()), gerenciamentoPortfolioHabilidadeDTO.getAcaoHabilidadeOcorrenciaServico());
			}

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	* @see br.com.centralit.citcorpore.util.Enumerados.AuditoriaTipos
	* @author deborah.ferreira
	* @since 26.01.2016
	*/
	private OcorrenciaServicoDTO createOcorrenciaServicoAutomatica(Integer idServico, String categoriaOcorrencia, DocumentHTML document, HttpServletRequest request) throws Exception {
		try {
			WebUtil.validarSeUsuarioEstaNaSessao(request, document);
			OcorrenciaServicoDTO ocorrenciaServicoDTO = new OcorrenciaServicoDTO();

			ocorrenciaServicoDTO.setIdServico(idServico);
			ocorrenciaServicoDTO.setTipoOcorrencia(AuditoriaTipos.AUTOMATICO.getIdentificador());
			ocorrenciaServicoDTO.setCategoriaOcorrencia(categoriaOcorrencia);

			ocorrenciaServicoDTO = createOcorrenciaServico(ocorrenciaServicoDTO, request);

			return ocorrenciaServicoDTO;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	private OcorrenciaServicoDTO createOcorrenciaServico(OcorrenciaServicoDTO ocorrenciaServicoDTO, HttpServletRequest request) throws Exception {
		ocorrenciaServicoDTO.setDataCriacao(UtilDatas.getDataHoraAtual());
		ocorrenciaServicoDTO.setNomeUsuario(WebUtil.getUsuario(request).getNomeUsuario());

		ocorrenciaServicoDTO = getOcorrenciaServicoService().create(ocorrenciaServicoDTO);

		return ocorrenciaServicoDTO;
	}

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.ParametroSistema
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	public void montarHTMLOcorrencia(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws ServiceException, Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);

		HTMLElement divOcorrenciasPortfolioRegistradas = document.getElementById("divOcorrenciasPortfolioRegistradas");
		GerenciamentoPortfolioOcorrenciasServicoDTO gerenciamentoPortfolioOcorrenciasServicoDTO = (GerenciamentoPortfolioOcorrenciasServicoDTO) document.getBean();

		Integer itensPorPagina = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANT_RETORNO_PESQUISA, "10"));

		Integer paginaSelecionadaOcorrenciaServico = gerenciamentoPortfolioOcorrenciasServicoDTO.getPaginaSelecionadaOcorrenciaServico();
		if (paginaSelecionadaOcorrenciaServico == null || paginaSelecionadaOcorrenciaServico == 0) {
			paginaSelecionadaOcorrenciaServico = 1;
		}

		Pageable pageable = new PageRequest(paginaSelecionadaOcorrenciaServico - 1, itensPorPagina);

		Collection<OcorrenciaServicoDTO> listOcorrenciaServico = getOcorrenciaServicoService().listOcorrenciasServico(gerenciamentoPortfolioOcorrenciasServicoDTO, pageable, false).getContent();

		if (listOcorrenciaServico != null && !listOcorrenciaServico.isEmpty()) {
			divOcorrenciasPortfolioRegistradas.setInnerHTML(geraHtmlOcorrencia(listOcorrenciaServico, request));

			Integer totalPaginasOcorrenciaServico = getOcorrenciaServicoService().listOcorrenciasServico(gerenciamentoPortfolioOcorrenciasServicoDTO, pageable, true).getTotalPages();

			HTMLElement paginacaoOcorrenciaServico = document.getElementById("paginacaoOcorrenciaServico");
			String funcaoJsPaginarNegocio = "PortfolioOcorrencias.paginarOcorrenciaServico";
			paginacaoOcorrenciaServico.setInnerHTML(UtilHTML.paginacaoHtml(request, funcaoJsPaginarNegocio, totalPaginasOcorrenciaServico, paginaSelecionadaOcorrenciaServico));
		} else {
			divOcorrenciasPortfolioRegistradas.setInnerHTML("<h4>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.ocorrenciasServico.nenhumaOcorrenciaServicoEncontrada") + "</h4>");
		}

		document.executeScript("PortfolioOcorrencias.depoisMontarHTMLOcorrencia();");
	}

	/**
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	private String geraHtmlOcorrencia(Collection<OcorrenciaServicoDTO> listaOcorrencias, HttpServletRequest request) throws Exception {
		StringBuilder sb = new StringBuilder();

		sb.append("<div class=\"ocorrencia\">");
		sb.append("		<div class=\"table-responsive tabela\">");
		sb.append("			<table class=\"table table-bordered table-striped table-condensed\">");
		sb.append("				<thead>");
		sb.append("					<tr>");
		sb.append("						<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "ID") + "</th> ");
		sb.append("						<th style=\"width: 15%;\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.dataHoraCriacao") + "</th> ");
		sb.append("						<th style=\"width: 20%;\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.criadopor") + "</th> ");
		sb.append("						<th style=\"width: 20;\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.tipo") + "</th> ");
		sb.append("						<th style=\"width: 20%;\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.categoria") + "</th> ");
		sb.append("						<th style=\"width: 4%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.acoes") + "</th> ");
		sb.append("					</tr>");
		sb.append("				</thead>");
		sb.append("				<tbody>");

		for (OcorrenciaServicoDTO ocorrenciaServicoDTO : listaOcorrencias) {
			sb.append(geraHtmlDadosOcorrencia(ocorrenciaServicoDTO, request));
		}

		sb.append("				</tbody>");
		sb.append("			</table>");
		sb.append("		</div>");
		sb.append("<div class='row-fluid'> ");
		sb.append("	<div id=\"paginacaoOcorrenciaServico\" class=\"divPaginacao\"></div>");
		sb.append("</div>");

		return sb.toString();
	}

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.AuditoriaTipos
	 * @see br.com.centralit.citcorpore.util.Enumerados.
	 *      OcorrenciaServicoCategorias
	 * @see br.com.centralit.citcorpore.util.Enumerados.TipoDate
	 * @see br.com.centralit.citcorpore.util.Enumerados.TipoServico
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	private String geraHtmlDadosOcorrencia(OcorrenciaServicoDTO ocorrenciaServicoDTO, HttpServletRequest request) throws Exception {
		StringBuilder sb = new StringBuilder();
		String onEvents = " onclick=\"PortfolioOcorrencias.abreFechaMaisInformacoes(this);\"";
		onEvents = onEvents.concat(" onmouseover=\"abreTooltip(this, '" + UtilI18N.internacionaliza(request, "citcorpore.comum.visualizarMaisInformaes") + "')\"");
		onEvents = onEvents.concat(" onmouseout=\"fechaTooltip();\"");
		Integer idOcorrenciaServico = ocorrenciaServicoDTO.getIdOcorrenciaServico();
		String categoriaOcorrencia = ocorrenciaServicoDTO.getCategoriaOcorrencia();

		sb.append("					<tr id=\"" + idOcorrenciaServico + "\">");
		sb.append("						<td class=\"center\">" + idOcorrenciaServico + "</td>");
		sb.append("						<td>" + UtilDatas.convertDateToString(TipoDate.TIMESTAMP_DEFAULT, ocorrenciaServicoDTO.getDataCriacao(), WebUtil.getLanguage(request)) + "</td> ");
		sb.append("						<td>" + ocorrenciaServicoDTO.getNomeUsuario() + "</td> ");
		sb.append("						<td>" + UtilI18N.internacionaliza(request, AuditoriaTipos.fromIdentificador(ocorrenciaServicoDTO.getTipoOcorrencia()).getChave()) + "</td> ");
		sb.append("						<td>" + UtilI18N.internacionaliza(request, OcorrenciaServicoCategorias.fromIdentificador(categoriaOcorrencia).getChave()) + "</td> ");
		sb.append("						<td class=\"center\" style=\"width: 50px;\">");
		sb.append("							<a " + onEvents + " class=\"btn-action glyphicons circle_plus btn-default\"><i></i></a>");
		sb.append("						</td>");
		sb.append("					</tr>");
		sb.append("					<tr id=\"maisInfo" + idOcorrenciaServico + "\" class=\"ocorrencia_maisInformacoes\">");
		sb.append("						<td colspan=\"6\">");
		sb.append("							<div>");
		sb.append("								<div class=\"row-fluid\">");
		sb.append("									<div class=\"span12\">");
		sb.append("										<h5 class=\"heading-arrow\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.maisinformacoes") + "</h5>");
		sb.append("									</div>");
		sb.append("								</div>");
		sb.append("								<div style=\"padding: 10px 15px 30px;\">");

		if (ocorrenciaServicoDTO.getTipoOcorrencia().equals(AuditoriaTipos.AUTOMATICO.getIdentificador())) {

			if (categoriaOcorrencia.equals(OcorrenciaServicoCategorias.DETALHES_SERVICO.getIdentificador())) {
				sb.append(geraDadosOcorrenciaDetalhes(idOcorrenciaServico, request));
			} else if (categoriaOcorrencia.equals(OcorrenciaServicoCategorias.REQUISITOS_NIVEL_SERVICO.getIdentificador())) {
				sb.append(geraDadosOcorrenciaRequisitoNivelServico(idOcorrenciaServico, request));
			} else if (categoriaOcorrencia.equals(OcorrenciaServicoCategorias.CASOS_NEGOCIO.getIdentificador())) {
				sb.append(geraDadosOcorrenciaCasoNegocio(idOcorrenciaServico, request));
			} else if (categoriaOcorrencia.equals(OcorrenciaServicoCategorias.ATRIBUTOS_FINANCEIROS.getIdentificador())) {
				sb.append(geraDadosOcorrenciaAtributosFinanceiros(idOcorrenciaServico, request));
			} else if (categoriaOcorrencia.equals(OcorrenciaServicoCategorias.PROCESSO_NEGOCIO.getIdentificador())) {
				sb.append(geraDadosOcorrenciaProcessoNegocio(idOcorrenciaServico, request));
			} else if (categoriaOcorrencia.equals(OcorrenciaServicoCategorias.SERVICOS_APOIO.getIdentificador())) {
				sb.append(geraDadosOcorrenciaServicoRelacionado(idOcorrenciaServico, TipoServico.SERVICO_APOIO.getIdentificador(), request));
			} else if (categoriaOcorrencia.equals(OcorrenciaServicoCategorias.DONO_NEGOCIO.getIdentificador())) {
				sb.append(geraDadosOcorrenciaDonoNegocio(idOcorrenciaServico, request));
			} else if (categoriaOcorrencia.equals(OcorrenciaServicoCategorias.USUARIO_NEGOCIO.getIdentificador())) {
				sb.append(geraDadosOcorrenciaUsuarioNegocio(idOcorrenciaServico, request));
			} else if (categoriaOcorrencia.equals(OcorrenciaServicoCategorias.REQUISICAO_SERVICOS.getIdentificador())) {
				sb.append(geraDadosOcorrenciaServicoRelacionado(idOcorrenciaServico, TipoServico.SERVICO_REQUISICAO.getIdentificador(), request));
			} else if (categoriaOcorrencia.equals(OcorrenciaServicoCategorias.INCIDENTES.getIdentificador())) {
				sb.append(geraDadosOcorrenciaServicoRelacionado(idOcorrenciaServico, TipoServico.SERVICO_INCIDENTE.getIdentificador(), request));
			} else if (categoriaOcorrencia.equals(OcorrenciaServicoCategorias.APLICACOES.getIdentificador())) {
				sb.append(geraDadosOcorrenciaServicoAplicacoes(idOcorrenciaServico, request));
			} else if (categoriaOcorrencia.equals(OcorrenciaServicoCategorias.CONTRATOS.getIdentificador())) {
				sb.append(geraDadosOcorrenciaServicoContrato(idOcorrenciaServico, request));
			} else if (categoriaOcorrencia.equals(OcorrenciaServicoCategorias.PROPRIETARIOS_TI.getIdentificador())) {
				sb.append(geraDadosOcorrenciaServicoProprietarios(idOcorrenciaServico, request));
			} else if (categoriaOcorrencia.equals(OcorrenciaServicoCategorias.ESQUEMA_DADOS.getIdentificador())) {
				sb.append(geraDadosOcorrenciaServicoEsquemaDados(idOcorrenciaServico, request));
			} else if (categoriaOcorrencia.equals(OcorrenciaServicoCategorias.DESENHO_MAPA_SERVICO.getIdentificador())) {
				sb.append(geraDadosOcorrenciaServicoDesenhoMapaServico(idOcorrenciaServico, request));
			} else if (categoriaOcorrencia.equals(OcorrenciaServicoCategorias.BASE_CONHECIMENTO.getIdentificador())) {
				sb.append(geraDadosOcorrenciaServicoBaseConhecimento(idOcorrenciaServico, request));
			} else if (categoriaOcorrencia.equals(OcorrenciaServicoCategorias.HABILIDADE.getIdentificador())) {
				sb.append(geraDadosOcorrenciaServicoHabilidade(idOcorrenciaServico, request));
			} else if (categoriaOcorrencia.equals(OcorrenciaServicoCategorias.ATRIBUTO_DEMANDA.getIdentificador())) {
				sb.append(geraDadosOcorrenciaServicoDemanda(idOcorrenciaServico, request));
			} else if (categoriaOcorrencia.equals(OcorrenciaServicoCategorias.INDICADOR_CAPACIDADE.getIdentificador())) {
				sb.append(geraDadosOcorrenciaServicoCapacidade(idOcorrenciaServico, request));
			} else if (categoriaOcorrencia.equals(OcorrenciaServicoCategorias.PROCEDIMENTO.getIdentificador())) {
				sb.append(geraDadosOcorrenciaServicoRelacionado(idOcorrenciaServico, TipoServico.SERVICO_PROCEDIMENTO.getIdentificador(), request));
			}

		} else {
			sb.append("								<div class=\"row-fluid\">");
			sb.append("									<div class=\"span8\">");
			sb.append("										<label class=\"strong\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.descricao") + "</label>");
			sb.append("										<span type=\"text\" class=\"span12\" >" + ocorrenciaServicoDTO.getDescricaoOcorrencia() + "</span>");
			sb.append("									</div>");
			sb.append("								</div>");
		}

		sb.append("								</div>");
		sb.append("							</div>");
		sb.append("						</div>");

		sb.append("					</td>");
		sb.append("				</tr>");

		return sb.toString();
	}

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.TipoDate
	 * @see br.com.centralit.citcorpore.util.Enumerados.TipoDeInvestimento
	 * @see br.com.centralit.citcorpore.util.Enumerados.FaseServico
	 * @see br.com.centralit.citcorpore.util.Enumerados.ProcessoDeIniciacao
	 * @see br.com.centralit.citcorpore.util.Enumerados.StatusServico
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	private String geraDadosOcorrenciaDetalhes(Integer idOcorrenciaServico, HttpServletRequest request) throws Exception {
		OcorrenciaServicoDetalhesDTO ocorrenciaServicoDetalhesDTO = getOcorrenciaServicoDetalhesService().findOcorrenciaServicoDetalhesByIdOcorrenciaServico(idOcorrenciaServico);

		StringBuilder sb = new StringBuilder();

		if (ocorrenciaServicoDetalhesDTO != null) {
			String tipoInvestimentoServico = "";
			String criticidadeServico = "";
			String demandaServico = "";
			String retornoFinanceiro = "";
			String processoDeIniciacao = "";
			String faseServico = UtilI18N.internacionaliza(request, FaseServico.fromTipo(ocorrenciaServicoDetalhesDTO.getFaseServico()).getChave());
			String statusServico = UtilI18N.internacionaliza(request, StatusServico.fromTipo(ocorrenciaServicoDetalhesDTO.getStatusServico()).getChave());

			if (UtilStrings.isNotVazio(ocorrenciaServicoDetalhesDTO.getProcessoDeIniciacao())) {
				processoDeIniciacao = UtilI18N.internacionaliza(request, ProcessoDeIniciacao.fromTipo(ocorrenciaServicoDetalhesDTO.getProcessoDeIniciacao()).getChave());
			}

			if (UtilStrings.isNotVazio(ocorrenciaServicoDetalhesDTO.getTipoDeInvestimento())) {
				tipoInvestimentoServico = UtilI18N.internacionaliza(request, TipoDeInvestimento.fromTipo(ocorrenciaServicoDetalhesDTO.getTipoDeInvestimento()).getChave());
			}

			if (ocorrenciaServicoDetalhesDTO.getCriticidadeServico() != null) {
				criticidadeServico = UtilI18N.internacionaliza(request, CriticidadeServico.fromItem(ocorrenciaServicoDetalhesDTO.getCriticidadeServico()).getChave());
			}

			if (ocorrenciaServicoDetalhesDTO.getDemandaServico() != null) {
				demandaServico = UtilI18N.internacionaliza(request, DemandaServicoNegocio.fromIdentificador(ocorrenciaServicoDetalhesDTO.getDemandaServico()).getChave());
			}

			if (ocorrenciaServicoDetalhesDTO.getRetornoFinanceiroServico() != null) {
				retornoFinanceiro = UtilI18N.internacionaliza(request, RetornoFinanceiroServico.fromIdentificador(ocorrenciaServicoDetalhesDTO.getRetornoFinanceiroServico()).getChave());
			}

			if (UtilStrings.isNotVazio(ocorrenciaServicoDetalhesDTO.getAcaoOcorrenciaServico())) {
				String msgAcaoOcorrenciaServico = UtilI18N.internacionaliza(request, "citcorpore.comum.registro").concat(" ")
						.concat(UtilI18N.internacionaliza(request, AuditoriaAcoes.fromIdentificador(ocorrenciaServicoDetalhesDTO.getAcaoOcorrenciaServico()).getChave()));

				sb.append("<div class=\"row-fluid\">");
				sb.append("		<div class=\"span12 acaoOcorrencia\">");
				sb.append("			<span>" + msgAcaoOcorrenciaServico + "</span>");
				sb.append("		</div>");
				sb.append("</div>");
			}

			List<OcorrenciaServicoAnexosDTO> listaOcorrenciaServicoAnexos = (List<OcorrenciaServicoAnexosDTO>) getOcorrenciaServicoAnexosService().findOcorrenciaServicoAnexosByIdOcorrenciaServico(idOcorrenciaServico);

			Map<String, Integer> tipoAnexosQuantidade = this.getListaContadorAnexos(listaOcorrenciaServicoAnexos);

			sb.append("<div class=\"row-fluid\">");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nomeServico") + "</label>");
			sb.append("			<span type=\"text\" class=\"span12\" >" + ocorrenciaServicoDetalhesDTO.getNomeServico() + "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.categoriaServico") + "</label>");
			sb.append("			<span type=\"text\" class=\"span12\" >" + ocorrenciaServicoDetalhesDTO.getNomeCategoriaServico() + "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.faseServico") + "</label>");
			sb.append("			<span type=\"text\" class=\"span12\" >" + faseServico + "</span>");
			sb.append("		</div>");
			sb.append("</div>");
			sb.append("<div class=\"row-fluid\" style=\"background-color: #fbfbfb\">");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.servicoNegocio.criticidadeServico") + "</label>");
			sb.append("			<span type=\"text\" class=\"span12\" >" + criticidadeServico + "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.tipoServico") + "</label>");
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoDetalhesDTO.getNomeTipoServico()) + "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.detalheServico") + "</label>");
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoDetalhesDTO.getDetalheServico()) + "</span>");
			sb.append("		</div>");
			sb.append("</div>");
			sb.append("<div class=\"row-fluid\">");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"lfloat strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.processoDeIniciacao") + "</label>");
			sb.append(this.getElementoContadorAnexos(tipoAnexosQuantidade.size()));
			sb.append("			<span type=\"text\" class=\"span12\" >" + processoDeIniciacao + "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.dataInicio") + "</label>");
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, ocorrenciaServicoDetalhesDTO.getDataInicio(), WebUtil.getLanguage(request)) + "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.statusServico") + "</label>");
			sb.append("			<span type=\"text\" class=\"span12\" >" + statusServico + "</span>");
			sb.append("		</div>");
			sb.append("</div>");
			sb.append("<div class=\"row-fluid\" style=\"background-color: #fbfbfb\">");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.importanciaNegocio") + "</label>");
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoDetalhesDTO.getNomeImportanciaNegocio()) + "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.localExecucaoServico") + "</label>");
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoDetalhesDTO.getNomeLocalExecucaoServico()) + "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.objetivoServico") + "</label>");
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoDetalhesDTO.getObjetivo()) + "</span>");
			sb.append("		</div>");
			sb.append("</div>");
			sb.append("<div class=\"row-fluid\">");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.valoresDoServico") + "</label>");
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoDetalhesDTO.getValoresDoServico()) + "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"strong\">" + UtilI18N.internacionaliza(request, "templateServico.titulo") + "</label>");
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoDetalhesDTO.getNomeTemplateServico()) + "</span>");
			sb.append("		</div>");
			sb.append("</div>");
			sb.append("<div class=\"row-fluid\" >");
			sb.append("		<div class=\"span12\" style=\"padding: 0px 15px;\">");
			sb.append("			<h5>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.classificacao") + "</h5>");
			sb.append("			<hr style=\"margin: 0px;\">");
			sb.append("		</div>");
			sb.append("</div>");
			sb.append("<div class=\"row-fluid\" >");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.tipoDeInvestimento") + "</label>");
			sb.append("			<span type=\"text\" class=\"span12\" >" + tipoInvestimentoServico + "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.classificacao.demandaServico") + "</label>");
			sb.append("			<span type=\"text\" class=\"span12\" >" + demandaServico + "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.classificacao.retornoFinanceiroServico") + "</label>");
			sb.append("			<span type=\"text\" class=\"span12\" >" + retornoFinanceiro + "</span>");
			sb.append("		</div>");
			sb.append("</div>");

			if (!listaOcorrenciaServicoAnexos.isEmpty()) {
				String dadosAnexos = this.geraDadosOcorrenciaServicoAnexos(listaOcorrenciaServicoAnexos, OcorrenciaServicoCategorias.DETALHES_SERVICO.getIdentificador(), request);
				sb.append(dadosAnexos);
			}
		}

		return sb.toString();
	};

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.TipoDate
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	private String geraDadosOcorrenciaRequisitoNivelServico(Integer idOcorrenciaServico, HttpServletRequest request) throws Exception {
		OcorrenciaServicoRequisitosNivelServicoDTO ocorrenciaServicoRequisitoNivelServicoDTO = getOcorrenciaServicoRequisitosNivelServicoService()
				.findOcorrenciaServicoRequisitosNivelServicoByIdOcorrenciaServico(idOcorrenciaServico);

		StringBuilder sb = new StringBuilder();

		if (ocorrenciaServicoRequisitoNivelServicoDTO != null) {
			if (UtilStrings.isNotVazio(ocorrenciaServicoRequisitoNivelServicoDTO.getAcaoOcorrenciaServico())) {
				String msgAcaoOcorrenciaServico = UtilI18N.internacionaliza(request, "citcorpore.comum.registro").concat(" ")
						.concat(UtilI18N.internacionaliza(request, AuditoriaAcoes.fromIdentificador(ocorrenciaServicoRequisitoNivelServicoDTO.getAcaoOcorrenciaServico()).getChave()));

				sb.append("<div class=\"row-fluid\">");
				sb.append("		<div class=\"span12 acaoOcorrencia\">");
				sb.append("			<span>" + msgAcaoOcorrenciaServico + "</span>");
				sb.append("		</div>");
				sb.append("</div>");
			}

			List<OcorrenciaServicoAnexosDTO> listaOcorrenciaServicoAnexos = (List<OcorrenciaServicoAnexosDTO>) getOcorrenciaServicoAnexosService().findOcorrenciaServicoAnexosByIdOcorrenciaServico(idOcorrenciaServico);

			Map<String, Integer> tipoAnexosQuantidade = this.getListaContadorAnexos(listaOcorrenciaServicoAnexos);

			sb.append("<div style=\"padding: 0px 15px;\">");
			sb.append("<div class=\"row-fluid\">");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.requisitosNivelServico.dataCriacao") + "</label>");
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, ocorrenciaServicoRequisitoNivelServicoDTO.getDataCriacao(), WebUtil.getLanguage(request))
					+ "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.requisitosNivelServico.dataInicioServico") + "</label>");
			sb.append("			<span type=\"text\" class=\"span12\" >"
					+ UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, ocorrenciaServicoRequisitoNivelServicoDTO.getDataInicioServico(), WebUtil.getLanguage(request)) + "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.requisitosNivelServico.donoDoServico") + "</label>");
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoRequisitoNivelServicoDTO.getDonoDoServico()) + "</span>");
			sb.append("		</div>");
			sb.append("</div>");
			sb.append("<div class=\"row-fluid\" >");
			sb.append("		<div class=\"span12\">");
			sb.append("			<h5>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.requisitosNivelServico.utilidadeDoServico") + "</h5>");
			sb.append("			<hr style=\"margin: 0px;\">");
			sb.append("		</div>");
			sb.append("</div>");
			sb.append("<div class=\"row-fluid\" >");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"lfloat strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.requisitosNivelServico.especificacao") + "</label>");
			sb.append(this.getElementoContadorAnexos(tipoAnexosQuantidade, TipoAnexoRequisitosNivelServico.ESPECIFICACAO.getIdentificador()));
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoRequisitoNivelServicoDTO.getEspecificacao()) + "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"lfloat strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.requisitosNivelServico.contexto") + "</label>");
			sb.append(this.getElementoContadorAnexos(tipoAnexosQuantidade, TipoAnexoRequisitosNivelServico.CONTEXTO.getIdentificador()));
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoRequisitoNivelServicoDTO.getContexto()) + "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"lfloat strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.requisitosNivelServico.funcionalidadesEssenciais") + "</label>");
			sb.append(this.getElementoContadorAnexos(tipoAnexosQuantidade, TipoAnexoRequisitosNivelServico.FUNCIONALIDADES_ESSENCIAIS.getIdentificador()));
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoRequisitoNivelServicoDTO.getFuncionalidadesEssenciais()) + "</span>");
			sb.append("		</div>");
			sb.append("</div>");
			sb.append("<div class=\"row-fluid\">");
			sb.append("		<div class=\"span12\">");
			sb.append("			<h5>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.requisitosNivelServico.garantiaDoServico") + "</h5>");
			sb.append("			<hr style=\"margin: 0px;\">");
			sb.append("		</div>");
			sb.append("</div>");
			sb.append("<div class=\"row-fluid\">");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"lfloat strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.requisitosNivelServico.seguranca") + "</label>");
			sb.append(this.getElementoContadorAnexos(tipoAnexosQuantidade, TipoAnexoRequisitosNivelServico.SEGURANCA.getIdentificador()));
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoRequisitoNivelServicoDTO.getSeguranca()) + "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"lfloat strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.requisitosNivelServico.disponibilidade") + "</label>");
			sb.append(this.getElementoContadorAnexos(tipoAnexosQuantidade, TipoAnexoRequisitosNivelServico.DISPONIBILIDADE.getIdentificador()));
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoRequisitoNivelServicoDTO.getDisponibilidade()) + "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"lfloat strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.requisitosNivelServico.capacidade") + "</label>");
			sb.append(this.getElementoContadorAnexos(tipoAnexosQuantidade, TipoAnexoRequisitosNivelServico.CAPACIDADE.getIdentificador()));
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoRequisitoNivelServicoDTO.getCapacidade()) + "</span>");
			sb.append("		</div>");
			sb.append("</div>");
			sb.append("<div class=\"row-fluid\" style=\"background-color: #fbfbfb; padding-top: 20px;\">");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"lfloat strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.requisitosNivelServico.continuidadeDoNegocio") + "</label>");
			sb.append(this.getElementoContadorAnexos(tipoAnexosQuantidade, TipoAnexoRequisitosNivelServico.CONTINUIDADE_DO_NEGOCIO.getIdentificador()));
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoRequisitoNivelServicoDTO.getContinuidadeDoNegocio()) + "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"lfloat strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.requisitosNivelServico.performanceDesempenho") + "</label>");
			sb.append(this.getElementoContadorAnexos(tipoAnexosQuantidade, TipoAnexoRequisitosNivelServico.PERFORMANCE_DESEMPENHO.getIdentificador()));
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoRequisitoNivelServicoDTO.getPerformanceDesempenho()) + "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"lfloat strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.requisitosNivelServico.interrupcoesPlanejadas") + "</label>");
			sb.append(this.getElementoContadorAnexos(tipoAnexosQuantidade, TipoAnexoRequisitosNivelServico.INTERRUPCOES_PLANEJADAS.getIdentificador()));
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoRequisitoNivelServicoDTO.getInterrupcoesPlanejadas()) + "</span>");
			sb.append("		</div>");
			sb.append("</div>");
			sb.append("<div class=\"row-fluid\">");
			sb.append("		<div class=\"span12\">");
			sb.append("			<h5>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.requisitosNivelServico.suporteDeServico") + "</h5>");
			sb.append("			<hr style=\"margin: 0px;\">");
			sb.append("		</div>");
			sb.append("</div>");
			sb.append("<div class=\"row-fluid\">");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"lfloat strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.requisitosNivelServico.gestaoDeIncidentes") + "</label>");
			sb.append(this.getElementoContadorAnexos(tipoAnexosQuantidade, TipoAnexoRequisitosNivelServico.GESTAO_DE_INCIDENTES.getIdentificador()));
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoRequisitoNivelServicoDTO.getGestaoDeIncidentes()) + "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"lfloat strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.requisitosNivelServico.gestaoDeProblemas") + "</label>");
			sb.append(this.getElementoContadorAnexos(tipoAnexosQuantidade, TipoAnexoRequisitosNivelServico.GESTAO_DE_PROBLEMAS.getIdentificador()));
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoRequisitoNivelServicoDTO.getGestaoDeProblemas()) + "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"lfloat strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.requisitosNivelServico.gestaoDeMudancas") + "</label>");
			sb.append(this.getElementoContadorAnexos(tipoAnexosQuantidade, TipoAnexoRequisitosNivelServico.GESTAO_DE_MUDANCAS.getIdentificador()));
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoRequisitoNivelServicoDTO.getGestaoDeMudancas()) + "</span>");
			sb.append("		</div>");
			sb.append("</div>");
			sb.append("<div class=\"row-fluid\">");
			sb.append("		<div class=\"span12\">");
			sb.append("			<h5>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.requisitosNivelServico.conformidade") + "</h5>");
			sb.append("			<hr style=\"margin: 0px;\">");
			sb.append("		</div>");
			sb.append("</div>");
			sb.append("<div class=\"row-fluid\">");
			sb.append("		<div class=\"span6\">");
			sb.append("			<label class=\"lfloat strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.requisitosNivelServico.conformidade.interna") + "</label>");
			sb.append(this.getElementoContadorAnexos(tipoAnexosQuantidade, TipoAnexoRequisitosNivelServico.CONFORMIDADE_INTERNA.getIdentificador()));
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoRequisitoNivelServicoDTO.getConformidadeInterna()) + "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span6\">");
			sb.append("			<label class=\"lfloat strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.requisitosNivelServico.conformidade.externa") + "</label>");
			sb.append(this.getElementoContadorAnexos(tipoAnexosQuantidade, TipoAnexoRequisitosNivelServico.CONFORMIDADE_EXTERNA.getIdentificador()));
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoRequisitoNivelServicoDTO.getConformidadeExterna()) + "</span>");
			sb.append("		</div>");
			sb.append("</div>");
			sb.append("</div>");

			if (!listaOcorrenciaServicoAnexos.isEmpty()) {
				String dadosAnexos = this.geraDadosOcorrenciaServicoAnexos(listaOcorrenciaServicoAnexos, OcorrenciaServicoCategorias.REQUISITOS_NIVEL_SERVICO.getIdentificador(), request);
				sb.append(dadosAnexos);
			}
		}

		return sb.toString();
	};

	/**
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	private String geraDadosOcorrenciaCasoNegocio(Integer idOcorrenciaServico, HttpServletRequest request) throws Exception {
		OcorrenciaServicoCasoNegocioDTO ocorrenciaServicoCasoNegocioDTO = getOcorrenciaServicoCasoNegocioService().findOcorrenciaServicoCasoNegocioByIdOcorrenciaServico(idOcorrenciaServico);

		StringBuilder sb = new StringBuilder();

		if (ocorrenciaServicoCasoNegocioDTO != null) {
			if (UtilStrings.isNotVazio(ocorrenciaServicoCasoNegocioDTO.getAcaoOcorrenciaServico())) {
				String msgAcaoOcorrenciaServico = UtilI18N.internacionaliza(request, "citcorpore.comum.registro").concat(" ")
						.concat(UtilI18N.internacionaliza(request, AuditoriaAcoes.fromIdentificador(ocorrenciaServicoCasoNegocioDTO.getAcaoOcorrenciaServico()).getChave()));

				sb.append("<div class=\"row-fluid\">");
				sb.append("		<div class=\"span12 acaoOcorrencia\">");
				sb.append("			<span>" + msgAcaoOcorrenciaServico + "</span>");
				sb.append("		</div>");
				sb.append("</div>");
			}

			List<OcorrenciaServicoAnexosDTO> listaOcorrenciaServicoAnexos = (List<OcorrenciaServicoAnexosDTO>) getOcorrenciaServicoAnexosService().findOcorrenciaServicoAnexosByIdOcorrenciaServico(idOcorrenciaServico);

			Map<String, Integer> tipoAnexosQuantidade = this.getListaContadorAnexos(listaOcorrenciaServicoAnexos);

			sb.append("<div style=\"padding: 0px 15px 0px 0px;\">");
			sb.append("<div class=\"row-fluid\">");
			sb.append("		<div class=\"span12\">");
			sb.append("			<label class=\"strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.businessCase.nomeCasoNegocio") + "</label>");
			sb.append("			<span type=\"text\" class=\"span12\" >" + ocorrenciaServicoCasoNegocioDTO.getNomeCasoNegocio() + "</span>");
			sb.append("		</div>");
			sb.append("</div>");
			sb.append("<div class=\"row-fluid\" >");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"lfloat strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.businessCase.sumario") + "</label>");
			sb.append(this.getElementoContadorAnexos(tipoAnexosQuantidade, TipoAnexoCasoNegocio.DESCRICAO_SUMARIO_EXECUTIVO.getIdentificador()));
			sb.append("			<hr class=\"hrOcorrenciaServico\">");
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoCasoNegocioDTO.getDescricaoSumarioExecutivo()) + "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"lfloat strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.businessCase.StakeholderEntidade") + "</label>");
			sb.append("			<hr class=\"hrOcorrenciaServico\">");
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoCasoNegocioDTO.getDescricaoStakeholderEntidade()) + "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"lfloat strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.businessCase.cenarios") + "</label>");
			sb.append(this.getElementoContadorAnexos(tipoAnexosQuantidade, TipoAnexoCasoNegocio.CENARIOS.getIdentificador()));
			sb.append("			<hr class=\"hrOcorrenciaServico\">");
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoCasoNegocioDTO.getDescricaoCenarios()) + "</span>");
			sb.append("		</div>");
			sb.append("</div>");
			sb.append("<div class=\"row-fluid\">");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"lfloat strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.businessCase.problemaOportunidade") + "</label>");
			sb.append(this.getElementoContadorAnexos(tipoAnexosQuantidade, TipoAnexoCasoNegocio.PROBLEMA_OPORTUNIDADE.getIdentificador()));
			sb.append("			<hr class=\"hrOcorrenciaServico\">");
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoCasoNegocioDTO.getDescricaoProblemaOportunidade()) + "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"lfloat strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.businessCase.propostaSolucao") + "</label>");
			sb.append(this.getElementoContadorAnexos(tipoAnexosQuantidade, TipoAnexoCasoNegocio.PROPOSTA_SOLUCAO.getIdentificador()));
			sb.append("			<hr class=\"hrOcorrenciaServico\">");
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoCasoNegocioDTO.getDescricaoPropostaSolucao()) + "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"lfloat strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.businessCase.analiseFinanceira") + "</label>");
			sb.append(this.getElementoContadorAnexos(tipoAnexosQuantidade, TipoAnexoCasoNegocio.ANALISE_FINANCEIRA.getIdentificador()));
			sb.append("			<hr class=\"hrOcorrenciaServico\">");
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoCasoNegocioDTO.getDescricaoAnaliseFinanceira()) + "</span>");
			sb.append("		</div>");
			sb.append("</div>");
			sb.append("<div class=\"row-fluid\">");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"lfloat strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.businessCase.analiseRisco") + "</label>");
			sb.append(this.getElementoContadorAnexos(tipoAnexosQuantidade, TipoAnexoCasoNegocio.ANALISE_RISCO.getIdentificador()));
			sb.append("			<hr class=\"hrOcorrenciaServico\">");
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoCasoNegocioDTO.getDescricaoAnaliseRisco()) + "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"lfloat strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.businessCase.viabilidadeTecnica") + "</label>");
			sb.append(this.getElementoContadorAnexos(tipoAnexosQuantidade, TipoAnexoCasoNegocio.VIABILIDADE_TECNICA.getIdentificador()));
			sb.append("			<hr class=\"hrOcorrenciaServico\">");
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoCasoNegocioDTO.getDescricaoViabilidadeTecnica()) + "</span>");
			sb.append("		</div>");
			sb.append("		<div class=\"span4\">");
			sb.append("			<label class=\"lfloat strong\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.businessCase.conclusao") + "</label>");
			sb.append(this.getElementoContadorAnexos(tipoAnexosQuantidade, TipoAnexoCasoNegocio.CONCLUSAO.getIdentificador()));
			sb.append("			<hr class=\"hrOcorrenciaServico\">");
			sb.append("			<span type=\"text\" class=\"span12\" >" + UtilStrings.nullToVazio(ocorrenciaServicoCasoNegocioDTO.getDescricaoConclusao()) + "</span>");
			sb.append("		</div>");
			sb.append("</div>");
			sb.append("</div>");

			if (!listaOcorrenciaServicoAnexos.isEmpty()) {
				String dadosAnexos = this.geraDadosOcorrenciaServicoAnexos(listaOcorrenciaServicoAnexos, OcorrenciaServicoCategorias.CASOS_NEGOCIO.getIdentificador(), request);
				sb.append(dadosAnexos);
			}
		}

		return sb.toString();
	};

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.PerfilFinanceiro
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	private String geraDadosOcorrenciaAtributosFinanceiros(Integer idOcorrenciaServico, HttpServletRequest request) throws Exception {
		Collection<OcorrenciaServicoAtributosFinanceirosDTO> listaOcorrenciaServicoAtributosFinanceiros = getOcorrenciaServicoAtributosFinanceirosService()
				.findOcorrenciaServicoAtributosFinanceirosByIdOcorrenciaServico(idOcorrenciaServico);
		DecimalFormat decimal = new DecimalFormat("0.00");
		StringBuilder sb = new StringBuilder();
		String acaoOcorrenciaServico;
		String tipo;
		String classificacao;

		if (!listaOcorrenciaServicoAtributosFinanceiros.isEmpty()) {
			sb.append("	<div class=\"table-responsive tabela\" >");
			sb.append("		<table class=\"table table-bordered table-striped table-condensed\"> ");
			sb.append("			<thead> ");
			sb.append("				<tr> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.atributosFinanceiros.categoria") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.atributosFinanceiros.tipo") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.classificacao") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.atributosFinanceiros.valor") + "</th> ");
			sb.append("					<th class=\"thAcaoOcorrenciaServico\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.ocorrenciasServico.acao") + "</th> ");
			sb.append("				</tr> ");
			sb.append("			</thead> ");
			sb.append("			<tbody> ");

			for (OcorrenciaServicoAtributosFinanceirosDTO ocorrenciaServicoAtributosFinanceirosDTO : listaOcorrenciaServicoAtributosFinanceiros) {
				classificacao = "";
				tipo = UtilI18N.internacionaliza(request, PerfilFinanceiro.fromIdentificador(ocorrenciaServicoAtributosFinanceirosDTO.getTipoAtributosFinanceirosOcorrenciaServico()).getNomePerfil());
				if (ocorrenciaServicoAtributosFinanceirosDTO.getClassificacaoAtributosFinanceirosOcorrenciaServico() != null) {
					ClassificacaoTipoFinanceiro classificacaoTipoFinanceiro = ClassificacaoTipoFinanceiro.fromId(ocorrenciaServicoAtributosFinanceirosDTO.getClassificacaoAtributosFinanceirosOcorrenciaServico());
					if (classificacaoTipoFinanceiro != null) {
						classificacao = UtilI18N.internacionaliza(request, classificacaoTipoFinanceiro.getNomeClassificacaoTipoFinanceiro());
					}
				}
				if (UtilStrings.isNotVazio(ocorrenciaServicoAtributosFinanceirosDTO.getAcaoOcorrenciaServico())) {
					acaoOcorrenciaServico = UtilI18N.internacionaliza(request, AuditoriaAcoes.fromIdentificador(ocorrenciaServicoAtributosFinanceirosDTO.getAcaoOcorrenciaServico()).getChave());
				} else {
					acaoOcorrenciaServico = "";
				}

				sb.append("		<tr>");
				sb.append("			<td>" + ocorrenciaServicoAtributosFinanceirosDTO.getCategoriaAtributosFinanceirosOcorrenciaServico() + "</td> ");
				sb.append("			<td>" + tipo + "</td> ");
				sb.append("			<td>" + classificacao + "</td> ");
				sb.append("			<td>" + decimal.format(ocorrenciaServicoAtributosFinanceirosDTO.getValorAtributosFinanceirosOcorrenciaServico()) + "</td> ");
				sb.append("			<td class=\"tdAcaoOcorrenciaServico\">");
				if (UtilStrings.isNotVazio(acaoOcorrenciaServico)) {
					sb.append("			<span>");
					sb.append(acaoOcorrenciaServico);
					sb.append("			</span>");
				}
				sb.append("			</td> ");
				sb.append("		</tr> ");
			}

			sb.append("			</tbody> ");
			sb.append("		</table>");
			sb.append("	</div>");
		}

		return sb.toString();
	};

	/**
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	private String geraDadosOcorrenciaProcessoNegocio(Integer idOcorrenciaServico, HttpServletRequest request) throws Exception {
		Collection<OcorrenciaServicoProcessoNegocioDTO> listaOcorrenciaServicoProcessoNegocio = getOcorrenciaServicoProcessoNegocioService().findOcorrenciaServicoProcessoNegocioByIdOcorrenciaServico(idOcorrenciaServico);
		StringBuilder sb = new StringBuilder();
		String acaoOcorrenciaServico;

		if (!listaOcorrenciaServicoProcessoNegocio.isEmpty()) {
			sb.append("	<div class=\"table-responsive tabela\" >");
			sb.append("		<table class=\"table table-bordered table-striped table-condensed\"> ");
			sb.append("			<thead> ");
			sb.append("				<tr> ");
			sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.id") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nomeProcessoNegocio") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "processoNegocio.cliente") + "</th> ");
			sb.append("					<th class=\"thAcaoOcorrenciaServico\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.ocorrenciasServico.acao") + "</th> ");
			sb.append("				</tr> ");
			sb.append("			</thead> ");
			sb.append("			<tbody> ");

			for (OcorrenciaServicoProcessoNegocioDTO ocorrenciaServicoProcessoNegocioDTO : listaOcorrenciaServicoProcessoNegocio) {
				if (UtilStrings.isNotVazio(ocorrenciaServicoProcessoNegocioDTO.getAcaoOcorrenciaServico())) {
					acaoOcorrenciaServico = UtilI18N.internacionaliza(request, AuditoriaAcoes.fromIdentificador(ocorrenciaServicoProcessoNegocioDTO.getAcaoOcorrenciaServico()).getChave());
				} else {
					acaoOcorrenciaServico = "";
				}

				sb.append("		<tr>");
				sb.append("			<td>" + ocorrenciaServicoProcessoNegocioDTO.getIdProcessoNegocioOcorrenciaServico() + "</td> ");
				sb.append("			<td>" + ocorrenciaServicoProcessoNegocioDTO.getNomeProcessoNegocioOcorrenciaServico() + "</td> ");
				sb.append("			<td>" + ocorrenciaServicoProcessoNegocioDTO.getNomeCliente() + "</td> ");
				sb.append("			<td class=\"tdAcaoOcorrenciaServico\">");
				if (UtilStrings.isNotVazio(acaoOcorrenciaServico)) {
					sb.append("			<span>");
					sb.append(acaoOcorrenciaServico);
					sb.append("			</span>");
				}
				sb.append("			</td> ");
				sb.append("		</tr> ");
			}

			sb.append("			</tbody> ");
			sb.append("		</table>");
			sb.append("	</div>");
		}

		return sb.toString();
	};

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.FaseServico
	 * @see br.com.centralit.citcorpore.util.Enumerados.StatusServico
	 * @see br.com.centralit.citcorpore.util.Enumerados.TipoServico
	 * @author deborah.ferreira
	 * @since 27.01.2016
	 */
	private String geraDadosOcorrenciaServicoRelacionado(Integer idOcorrenciaServico, String tipoServico, HttpServletRequest request) throws Exception {
		Collection<OcorrenciaServicoRelacionadoDTO> listaOcorrenciaServicoRelacionado = getOcorrenciaServicoRelacionadoService().findOcorrenciaServicoRelacionadoByIdOcorrenciaServicoAndTipoServico(idOcorrenciaServico,
				tipoServico);
		StringBuilder sb = new StringBuilder();
		String acaoOcorrenciaServico;

		if (!listaOcorrenciaServicoRelacionado.isEmpty()) {
			sb.append("	<div class=\"table-responsive tabela\" >");
			sb.append("		<table class=\"table table-bordered table-striped table-condensed\"> ");
			sb.append("			<thead> ");
			sb.append("				<tr> ");
			sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.id") + "</th> ");

			if (tipoServico.equals(TipoServico.SERVICO_APOIO.getIdentificador())) {
				sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nomeServicoApoio") + "</th> ");
				sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.fase") + "</th> ");
				sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.statusServico") + "</th> ");
			} else if (tipoServico.equals(TipoServico.SERVICO_REQUISICAO.getIdentificador())) {
				sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nomeServicoRequisicao") + "</th> ");
			} else if (tipoServico.equals(TipoServico.SERVICO_INCIDENTE.getIdentificador())) {
				sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nomeServicoIncidente") + "</th> ");
			} else if (tipoServico.equals(TipoServico.SERVICO_PROCEDIMENTO.getIdentificador())) {
				sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nomeServicoProcedimento") + "</th> ");
			}

			sb.append("					<th class=\"thAcaoOcorrenciaServico\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.ocorrenciasServico.acao") + "</th> ");

			sb.append("				</tr> ");
			sb.append("			</thead> ");
			sb.append("			<tbody> ");

			for (OcorrenciaServicoRelacionadoDTO ocorrenciaServicoRelacionadoDTO : listaOcorrenciaServicoRelacionado) {
				if (UtilStrings.isNotVazio(ocorrenciaServicoRelacionadoDTO.getAcaoOcorrenciaServico())) {
					acaoOcorrenciaServico = UtilI18N.internacionaliza(request, AuditoriaAcoes.fromIdentificador(ocorrenciaServicoRelacionadoDTO.getAcaoOcorrenciaServico()).getChave());
				} else {
					acaoOcorrenciaServico = "";
				}

				sb.append("		<tr>");
				sb.append("			<td>" + ocorrenciaServicoRelacionadoDTO.getIdServicoRelacionadoOcorrenciaServico() + "</td> ");
				sb.append("			<td>" + ocorrenciaServicoRelacionadoDTO.getNomeServicoRelacionadoOcorrenciaServico() + "</td> ");

				if (tipoServico.equals(TipoServico.SERVICO_APOIO.getIdentificador())) {
					sb.append("			<td>" + UtilI18N.internacionaliza(request, FaseServico.fromTipo(ocorrenciaServicoRelacionadoDTO.getFaseServicoRelacionadoOcorrenciaServico()).getChave()) + "</td> ");
					sb.append("			<td>" + UtilI18N.internacionaliza(request, StatusServico.fromTipo(ocorrenciaServicoRelacionadoDTO.getStatusServicoRelacionadoOcorrenciaServico()).getChave()) + "</td> ");
				}
				sb.append("			<td class=\"tdAcaoOcorrenciaServico\">");
				if (UtilStrings.isNotVazio(acaoOcorrenciaServico)) {
					sb.append("			<span>");
					sb.append(acaoOcorrenciaServico);
					sb.append("			</span>");
				}
				sb.append("			</td> ");

				sb.append("		</tr> ");
			}

			sb.append("			</tbody> ");
			sb.append("		</table>");
			sb.append("	</div>");
		}

		return sb.toString();
	};

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.DonoNegocioTipo
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	private String geraDadosOcorrenciaDonoNegocio(Integer idOcorrenciaServico, HttpServletRequest request) throws Exception {
		Collection<OcorrenciaServicoDonoNegocioDTO> listaOcorrenciaServicoDonoNegocio = getOcorrenciaServicoDonoNegocioService().findOcorrenciaServicoDonoNegocioByIdOcorrenciaServico(idOcorrenciaServico);
		StringBuilder sb = new StringBuilder();
		String acaoOcorrenciaServico;
		String tipoDonoNegocio;

		if (!listaOcorrenciaServicoDonoNegocio.isEmpty()) {
			sb.append("	<div class=\"table-responsive tabela\" >");
			sb.append("		<table class=\"table table-bordered table-striped table-condensed\"> ");
			sb.append("			<thead> ");
			sb.append("				<tr> ");
			sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.id") + "</th> ");
			sb.append("					<th>" + UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "citcorpore.comum.nome")) + "</th> ");
			sb.append("					<th>" + UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "citcorpore.comum.tipo")) + "</th> ");
			sb.append("					<th class=\"thAcaoOcorrenciaServico\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.ocorrenciasServico.acao") + "</th> ");
			sb.append("				</tr> ");
			sb.append("			</thead> ");
			sb.append("			<tbody> ");

			for (OcorrenciaServicoDonoNegocioDTO ocorrenciaServicoDonoNegocioDTO : listaOcorrenciaServicoDonoNegocio) {
				tipoDonoNegocio = UtilI18N.internacionaliza(request, DonoNegocioTipo.fromIdentificador(ocorrenciaServicoDonoNegocioDTO.getTipoDonoNegocioOcorrenciaServico()).getChave());
				if (UtilStrings.isNotVazio(ocorrenciaServicoDonoNegocioDTO.getAcaoOcorrenciaServico())) {
					acaoOcorrenciaServico = UtilI18N.internacionaliza(request, AuditoriaAcoes.fromIdentificador(ocorrenciaServicoDonoNegocioDTO.getAcaoOcorrenciaServico()).getChave());
				} else {
					acaoOcorrenciaServico = "";
				}

				sb.append("		<tr>");
				sb.append("			<td>" + ocorrenciaServicoDonoNegocioDTO.getIdDonoNegocioOcorrenciaServico() + "</td> ");
				sb.append("			<td>" + ocorrenciaServicoDonoNegocioDTO.getNomeDonoNegocioOcorrenciaServico() + "</td> ");
				sb.append("			<td>" + tipoDonoNegocio + "</td> ");
				sb.append("			<td class=\"tdAcaoOcorrenciaServico\">");
				if (UtilStrings.isNotVazio(acaoOcorrenciaServico)) {
					sb.append("			<span>");
					sb.append(acaoOcorrenciaServico);
					sb.append("			</span>");
				}
				sb.append("			</td> ");
				sb.append("		</tr> ");
			}

			sb.append("			</tbody> ");
			sb.append("		</table>");
			sb.append("	</div>");
		}

		return sb.toString();
	};

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.BusinessUserTipo
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	private String geraDadosOcorrenciaUsuarioNegocio(Integer idOcorrenciaServico, HttpServletRequest request) throws Exception {
		Collection<OcorrenciaServicoUsuarioNegocioDTO> listaOcorrenciaServicoUsuarioNegocio = getOcorrenciaServicoUsuarioNegocioService().findOcorrenciaServicoUsuarioNegocioByIdOcorrenciaServico(idOcorrenciaServico);
		StringBuilder sb = new StringBuilder();
		String acaoOcorrenciaServico;
		String tipoUsuarioNegocio;

		if (!listaOcorrenciaServicoUsuarioNegocio.isEmpty()) {
			sb.append("	<div class=\"table-responsive tabela\" >");
			sb.append("		<table class=\"table table-bordered table-striped table-condensed\"> ");
			sb.append("			<thead> ");
			sb.append("				<tr> ");
			sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.id") + "</th> ");
			sb.append("					<th>" + UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "citcorpore.comum.nome")) + "</th> ");
			sb.append("					<th>" + UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "citcorpore.comum.descricao")) + "</th> ");
			sb.append("					<th class=\"thAcaoOcorrenciaServico\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.ocorrenciasServico.acao") + "</th> ");
			sb.append("				</tr> ");
			sb.append("			</thead> ");
			sb.append("			<tbody> ");

			for (OcorrenciaServicoUsuarioNegocioDTO ocorrenciaServicoUsuarioNegocioDTO : listaOcorrenciaServicoUsuarioNegocio) {
				tipoUsuarioNegocio = UtilI18N.internacionaliza(request, BusinessUserTipo.fromIdentificador(ocorrenciaServicoUsuarioNegocioDTO.getTipoUsuarioNegocioOcorrenciaServico()).getChave());
				if (UtilStrings.isNotVazio(ocorrenciaServicoUsuarioNegocioDTO.getAcaoOcorrenciaServico())) {
					acaoOcorrenciaServico = UtilI18N.internacionaliza(request, AuditoriaAcoes.fromIdentificador(ocorrenciaServicoUsuarioNegocioDTO.getAcaoOcorrenciaServico()).getChave());
				} else {
					acaoOcorrenciaServico = "";
				}

				sb.append("		<tr>");
				sb.append("			<td>" + ocorrenciaServicoUsuarioNegocioDTO.getIdUsuarioNegocioOcorrenciaServico() + "</td> ");
				sb.append("			<td>" + ocorrenciaServicoUsuarioNegocioDTO.getNomeUsuarioNegocioOcorrenciaServico() + "</td> ");
				sb.append("			<td>" + tipoUsuarioNegocio + "</td> ");
				sb.append("			<td class=\"tdAcaoOcorrenciaServico\">");
				if (UtilStrings.isNotVazio(acaoOcorrenciaServico)) {
					sb.append("			<span>");
					sb.append(acaoOcorrenciaServico);
					sb.append("			</span>");
				}
				sb.append("			</td> ");
				sb.append("		</tr> ");
			}

			sb.append("			</tbody> ");
			sb.append("		</table>");
			sb.append("	</div>");
		}

		return sb.toString();
	};

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.BusinessUserTipo
	 * @author deborah.ferreira
	 * @since 27.01.2016
	 */
	private String geraDadosOcorrenciaServicoAplicacoes(Integer idOcorrenciaServico, HttpServletRequest request) throws Exception {
		Collection<OcorrenciaServicoAplicacaoDTO> listaOcorrenciaServicoAplicacao = getOcorrenciaServicoAplicacaoService().findOcorrenciaServicoAplicacaoByIdOcorrenciaServico(idOcorrenciaServico);
		StringBuilder sb = new StringBuilder();
		String acaoOcorrenciaServico;

		if (!listaOcorrenciaServicoAplicacao.isEmpty()) {
			sb.append("	<div class=\"table-responsive tabela\" >");
			sb.append("		<table class=\"table table-bordered table-striped table-condensed\"> ");
			sb.append("			<thead> ");
			sb.append("				<tr> ");
			sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.id") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.nome") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nomeResponsavel") + "</th> ");
			sb.append("					<th class=\"thAcaoOcorrenciaServico\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.ocorrenciasServico.acao") + "</th> ");
			sb.append("				</tr> ");
			sb.append("			</thead> ");
			sb.append("			<tbody> ");

			for (OcorrenciaServicoAplicacaoDTO ocorrenciaServicoAplicacaoDTO : listaOcorrenciaServicoAplicacao) {
				if (UtilStrings.isNotVazio(ocorrenciaServicoAplicacaoDTO.getAcaoOcorrenciaServico())) {
					acaoOcorrenciaServico = UtilI18N.internacionaliza(request, AuditoriaAcoes.fromIdentificador(ocorrenciaServicoAplicacaoDTO.getAcaoOcorrenciaServico()).getChave());
				} else {
					acaoOcorrenciaServico = "";
				}

				sb.append("		<tr>");
				sb.append("			<td>" + ocorrenciaServicoAplicacaoDTO.getIdAplicacaoOcorrenciaServico() + "</td> ");
				sb.append("			<td>" + ocorrenciaServicoAplicacaoDTO.getNomeAplicacaoOcorrenciaServico() + "</td> ");
				sb.append("			<td>" + UtilStrings.nullToVazio(ocorrenciaServicoAplicacaoDTO.getNomeResponsavelAplicacaoOcorrenciaServico()) + "</td> ");
				sb.append("			<td class=\"tdAcaoOcorrenciaServico\">");
				if (UtilStrings.isNotVazio(acaoOcorrenciaServico)) {
					sb.append("			<span>");
					sb.append(acaoOcorrenciaServico);
					sb.append("			</span>");
				}
				sb.append("			</td> ");
				sb.append("		</tr> ");
			}

			sb.append("			</tbody> ");
			sb.append("		</table>");
			sb.append("	</div>");
		}

		return sb.toString();
	};

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerated.OcorrenciaServicoAcoes
	 * @author deborah.ferreira
	 * @since 27.01.2016
	 */
	private String geraDadosOcorrenciaServicoContrato(Integer idOcorrenciaServico, HttpServletRequest request) throws Exception {
		Collection<OcorrenciaServicoContratoDTO> listaOcorrenciaServicoContrato = getOcorrenciaServicoContratoService().findOcorrenciaServicoContratoByIdOcorrenciaServico(idOcorrenciaServico);
		StringBuilder sb = new StringBuilder();
		String acaoOcorrenciaServico;
		String acaoOcorrenciaServicoInternacionalizado;

		if (!listaOcorrenciaServicoContrato.isEmpty()) {
			sb.append("	<div class=\"table-responsive tabela\" >");
			sb.append("		<table class=\"table table-bordered table-striped table-condensed\"> ");
			sb.append("			<thead> ");
			sb.append("				<tr> ");
			sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.id") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.contratoDescricao") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.contratoCliente") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.contratoFornecedor") + "</th> ");
			sb.append("					<th class=\"thAcaoOcorrenciaServico\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.ocorrenciasServico.acao") + "</th> ");
			sb.append("				</tr> ");
			sb.append("			</thead> ");
			sb.append("			<tbody> ");

			for (OcorrenciaServicoContratoDTO ocorrenciaServicoContratoDTO : listaOcorrenciaServicoContrato) {
				acaoOcorrenciaServicoInternacionalizado = "";
				acaoOcorrenciaServico = ocorrenciaServicoContratoDTO.getAcaoOcorrenciaServico();
				if (!UtilStrings.isNullOrEmpty(acaoOcorrenciaServico)) {
					acaoOcorrenciaServicoInternacionalizado = UtilI18N.internacionaliza(request, AuditoriaAcoes.fromIdentificador(acaoOcorrenciaServico).getChave());
				}

				sb.append("		<tr>");
				sb.append("			<td>" + ocorrenciaServicoContratoDTO.getIdContratoOcorrenciaServico() + "</td> ");
				sb.append("			<td>" + ocorrenciaServicoContratoDTO.getDescricaoContratoOcorrenciaServico() + "</td> ");
				sb.append("			<td>" + UtilStrings.nullToVazio(ocorrenciaServicoContratoDTO.getClienteContratoOcorrenciaServico()) + "</td> ");
				sb.append("			<td>" + UtilStrings.nullToVazio(ocorrenciaServicoContratoDTO.getFornecedorContratoOcorrenciaServico()) + "</td> ");
				sb.append("			<td class=\"tdAcaoOcorrenciaServico\">");
				if (UtilStrings.isNotVazio(acaoOcorrenciaServicoInternacionalizado)) {
					sb.append("			<span>");
					sb.append(acaoOcorrenciaServicoInternacionalizado);
					sb.append("			</span>");
				}
				sb.append("			</td> ");
				sb.append("		</tr> ");
			}

			sb.append("			</tbody> ");
			sb.append("		</table>");
			sb.append("	</div>");
		}

		return sb.toString();
	};

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes
	 * @author deborah.ferreira
	 * @since 01.02.2016
	 */
	private String geraDadosOcorrenciaServicoProprietarios(Integer idOcorrenciaServico, HttpServletRequest request) throws Exception {
		List<OcorrenciaServicoProprietariosDTO> listaOcorrenciaServicoProprietarios = (List<OcorrenciaServicoProprietariosDTO>) getOcorrenciaServicoProprietariosService()
				.findOcorrenciaServicoProprietariosByIdOcorrenciaServico(idOcorrenciaServico);

		Collections.sort(listaOcorrenciaServicoProprietarios);
		StringBuilder sb = new StringBuilder();
		String acaoOcorrenciaServico;

		if (!listaOcorrenciaServicoProprietarios.isEmpty()) {
			sb.append("	<div class=\"table-responsive tabela\" >");
			sb.append("		<table class=\"table table-bordered table-striped table-condensed\"> ");
			sb.append("			<thead> ");
			sb.append("				<tr> ");
			sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.id") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.proprietarioNome") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.tipo") + "</th> ");
			sb.append("					<th class=\"thAcaoOcorrenciaServico\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.ocorrenciasServico.acao") + "</th> ");
			sb.append("				</tr> ");
			sb.append("			</thead> ");
			sb.append("			<tbody> ");

			for (OcorrenciaServicoProprietariosDTO ocorrenciaServicoProprietariosDTO : listaOcorrenciaServicoProprietarios) {
				if (UtilStrings.isNotVazio(ocorrenciaServicoProprietariosDTO.getAcaoOcorrenciaServico())) {
					acaoOcorrenciaServico = UtilI18N.internacionaliza(request, AuditoriaAcoes.fromIdentificador(ocorrenciaServicoProprietariosDTO.getAcaoOcorrenciaServico()).getChave());
				} else {
					acaoOcorrenciaServico = "";
				}

				sb.append("		<tr>");
				sb.append("			<td>" + ocorrenciaServicoProprietariosDTO.getIdProprietarioOcorrenciaServico() + "</td> ");
				sb.append("			<td>" + ocorrenciaServicoProprietariosDTO.getNomeProprietarioOcorrenciaServico() + "</td> ");
				sb.append("			<td>" + UtilI18N.internacionaliza(request, ProprietariosTipo.fromIdentificador(ocorrenciaServicoProprietariosDTO.getTipoProprietarioOcorrenciaServico()).getChave()) + "</td> ");
				sb.append("			<td class=\"tdAcaoOcorrenciaServico\">");
				if (UtilStrings.isNotVazio(acaoOcorrenciaServico)) {
					sb.append("			<span>");
					sb.append(acaoOcorrenciaServico);
					sb.append("			</span>");
				}
				sb.append("			</td> ");
				sb.append("		</tr> ");
			}

			sb.append("			</tbody> ");
			sb.append("		</table>");
			sb.append("	</div>");
		}

		return sb.toString();
	};

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes
	 * @author deborah.ferreira
	 * @since 02.02.2016
	 */
	private String geraDadosOcorrenciaServicoEsquemaDados(Integer idOcorrenciaServico, HttpServletRequest request) throws Exception {
		List<OcorrenciaServicoEsquemaDadosDTO> listaOcorrenciaServicoEsquemaDados = (List<OcorrenciaServicoEsquemaDadosDTO>) getOcorrenciaServicoEsquemaDadosService()
				.findOcorrenciaServicoEsquemaDadosByIdOcorrenciaServico(idOcorrenciaServico);

		StringBuilder sb = new StringBuilder();

		if (!listaOcorrenciaServicoEsquemaDados.isEmpty()) {
			OcorrenciaServicoEsquemaDadosDTO ocorrenciaServicoEsquemaDadosDTO = listaOcorrenciaServicoEsquemaDados.iterator().next();
			String acaoOcorrenciaServico = UtilI18N.internacionaliza(request, AuditoriaAcoes.fromIdentificador(ocorrenciaServicoEsquemaDadosDTO.getAcaoOcorrenciaServico()).getChave());
			sb.append("<div class=\"row-fluid\">");
			sb.append("		<div class=\"span12 acaoOcorrencia\">");
			sb.append("			<span>" + UtilI18N.internacionaliza(request, "citcorpore.comum.registro") + " " + acaoOcorrenciaServico + "</span>");
			sb.append("		</div>");
			sb.append("</div>");

			sb.append("	<div class=\"row-fluid\">");
			sb.append("		<div class=\"span8\">");
			sb.append("			<label class=\"strong\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.descricao") + "</label>");
			sb.append("			<span type=\"text\" class=\"span12\" >" + ocorrenciaServicoEsquemaDadosDTO.getDetalhesEsquemaDadosOcorrenciaServico() + "</span>");
			sb.append("		</div>");
			sb.append("	</div>");

			List<OcorrenciaServicoAnexosDTO> listaOcorrenciaServicoAnexos = (List<OcorrenciaServicoAnexosDTO>) getOcorrenciaServicoAnexosService().findOcorrenciaServicoAnexosByIdOcorrenciaServico(idOcorrenciaServico);
			if (!listaOcorrenciaServicoAnexos.isEmpty()) {
				String dadosAnexos = this.geraDadosOcorrenciaServicoAnexos(listaOcorrenciaServicoAnexos, OcorrenciaServicoCategorias.ESQUEMA_DADOS.getIdentificador(), request);
				sb.append(dadosAnexos);
			}
		}

		return sb.toString();
	};

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes
	 * @author deborah.ferreira
	 * @since 03.02.2016
	 */
	private String geraDadosOcorrenciaServicoDesenhoMapaServico(Integer idOcorrenciaServico, HttpServletRequest request) throws Exception {
		List<OcorrenciaServicoDesenhoMapaServicoDTO> listaOcorrenciaServicoDesenhoMapaServico = (List<OcorrenciaServicoDesenhoMapaServicoDTO>) getOcorrenciaServicoDesenhoMapaServicoService()
				.findOcorrenciaServicoDesenhoMapaServicoByIdOcorrenciaServico(idOcorrenciaServico);

		StringBuilder sb = new StringBuilder();

		if (!listaOcorrenciaServicoDesenhoMapaServico.isEmpty()) {
			String acaoOcorrenciaServico;
			String tipoItem;
			String tdIcone;

			sb.append("	<div class=\"row-fluid\">");
			sb.append("		<div class=\"span12\">");
			sb.append("			<div class=\"table-responsive tabela\" style=\"padding: 10px 15px;\" >");
			sb.append("				<table class=\"table table-bordered table-striped table-condensed\"> ");
			sb.append("					<thead> ");
			sb.append("						<tr> ");
			sb.append("							<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.id") + "</th> ");
			sb.append("							<th style=\"width: 10%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.icone") + "</th> ");
			sb.append("							<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.nome") + "</th> ");
			sb.append("							<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.tipo") + "</th> ");
			sb.append("							<th class=\"thAcaoOcorrenciaServico\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.ocorrenciasServico.acao") + "</th> ");
			sb.append("						</tr> ");
			sb.append("					</thead> ");
			sb.append("					<tbody> ");

			for (OcorrenciaServicoDesenhoMapaServicoDTO ocorrenciaServicoDesenhoMapaServicoDTO : listaOcorrenciaServicoDesenhoMapaServico) {
				tipoItem = UtilI18N.internacionaliza(request, TipoItemMapaServico.fromIdentificador(ocorrenciaServicoDesenhoMapaServicoDTO.getTipoItemMapaServicoOcorrenciaServico()).getChave());
				tdIcone = "";

				if (UtilStrings.isNotVazio(ocorrenciaServicoDesenhoMapaServicoDTO.getAcaoOcorrenciaServico())) {
					acaoOcorrenciaServico = UtilI18N.internacionaliza(request, AuditoriaAcoes.fromIdentificador(ocorrenciaServicoDesenhoMapaServicoDTO.getAcaoOcorrenciaServico()).getChave());
				} else {
					acaoOcorrenciaServico = "";
				}

				if (UtilStrings.isNotVazio(ocorrenciaServicoDesenhoMapaServicoDTO.getIconeItemMapaServicoOcorrenciaServico())) {
					tdIcone = "<img src=\"${ctx}/pages/gerenciamentoPortfolio/gerenciamentoPortfolioMapaDesenhoNegocio/imagens/";
					if (ocorrenciaServicoDesenhoMapaServicoDTO.getTipoItemMapaServicoOcorrenciaServico().equals(TipoItemMapaServico.SERVICO_APOIO.getIdentificador())) {
						tdIcone = tdIcone.concat("servicoApoio/");
					} else {
						tdIcone = tdIcone.concat("itemConfiguracao/");
					}
					tdIcone = tdIcone.concat(ocorrenciaServicoDesenhoMapaServicoDTO.getIconeItemMapaServicoOcorrenciaServico()).concat(".png\" style=\"height: 20px;\" class=\"itemConfig\"/>");
				}

				sb.append("					<tr>");
				sb.append("						<td>" + ocorrenciaServicoDesenhoMapaServicoDTO.getIdItemMapaServicoOcorrenciaServico() + "</td> ");
				sb.append("						<td class=\"center\">" + tdIcone + "</td>");
				sb.append("						<td>" + ocorrenciaServicoDesenhoMapaServicoDTO.getNomeItemMapaServicoOcorrenciaServico() + "</td> ");
				sb.append("						<td>" + tipoItem + "</td> ");
				sb.append("						<td class=\"tdAcaoOcorrenciaServico\">");
				if (UtilStrings.isNotVazio(acaoOcorrenciaServico)) {
					sb.append("						<span>" + acaoOcorrenciaServico + "</span>");
				}
				sb.append("						</td> ");
				sb.append("					</tr> ");
			}

			sb.append("					</tbody> ");
			sb.append("				</table>");
			sb.append("			</div>");
			sb.append("		</div>");
			sb.append("	</div>");
		}

		return sb.toString();
	};

	/**
	 * @author deborah.ferreira
	 * @since 17.02.2016
	 */
	private String geraDadosOcorrenciaServicoBaseConhecimento(Integer idOcorrenciaServico, HttpServletRequest request) throws Exception {
		Collection<OcorrenciaServicoBaseConhecimentoDTO> listaOcorrenciaServicoBaseConhecimento = getOcorrenciaServicoBaseConhecimentoService()
				.findOcorrenciaServicoBaseConhecimentoByIdOcorrenciaServico(idOcorrenciaServico);
		StringBuilder sb = new StringBuilder();
		String acaoOcorrenciaServico;

		if (!listaOcorrenciaServicoBaseConhecimento.isEmpty()) {
			sb.append("	<div class=\"table-responsive tabela\" >");
			sb.append("		<table class=\"table table-bordered table-striped table-condensed\"> ");
			sb.append("			<thead> ");
			sb.append("				<tr> ");
			sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.id") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.titulo") + "</th> ");
			sb.append("					<th class=\"thAcaoOcorrenciaServico\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.ocorrenciasServico.acao") + "</th> ");
			sb.append("				</tr> ");
			sb.append("			</thead> ");
			sb.append("			<tbody> ");

			for (OcorrenciaServicoBaseConhecimentoDTO ocorrenciaServicoBaseConhecimentoDTO : listaOcorrenciaServicoBaseConhecimento) {
				if (UtilStrings.isNotVazio(ocorrenciaServicoBaseConhecimentoDTO.getAcaoOcorrenciaServico())) {
					acaoOcorrenciaServico = UtilI18N.internacionaliza(request, AuditoriaAcoes.fromIdentificador(ocorrenciaServicoBaseConhecimentoDTO.getAcaoOcorrenciaServico()).getChave());
				} else {
					acaoOcorrenciaServico = "";
				}

				sb.append("		<tr>");
				sb.append("			<td>" + ocorrenciaServicoBaseConhecimentoDTO.getIdBaseConhecimentoOcorrenciaServico() + "</td> ");
				sb.append("			<td>" + ocorrenciaServicoBaseConhecimentoDTO.getNomeBaseConhecimentoOcorrenciaServico() + "</td> ");
				sb.append("			<td class=\"tdAcaoOcorrenciaServico\">");
				if (UtilStrings.isNotVazio(acaoOcorrenciaServico)) {
					sb.append("			<span>");
					sb.append(acaoOcorrenciaServico);
					sb.append("			</span>");
				}
				sb.append("			</td> ");
				sb.append("		</tr> ");
			}

			sb.append("			</tbody> ");
			sb.append("		</table>");
			sb.append("	</div>");
		}

		return sb.toString();
	};

	/**
	 * @author deborah.ferreira
	 * @since 17.02.2016
	 */
	private String geraDadosOcorrenciaServicoHabilidade(Integer idOcorrenciaServico, HttpServletRequest request) throws Exception {
		Collection<OcorrenciaServicoHabilidadeDTO> listaOcorrenciaServicoHabilidade = this.getOcorrenciaServicoHabilidadeService().findOcorrenciaServicoHabilidadeByIdOcorrenciaServico(idOcorrenciaServico);
		StringBuilder sb = new StringBuilder();
		String acaoOcorrenciaServico;

		if (!listaOcorrenciaServicoHabilidade.isEmpty()) {
			sb.append("	<div class=\"table-responsive tabela\" >");
			sb.append("		<table class=\"table table-bordered table-striped table-condensed\"> ");
			sb.append("			<thead> ");
			sb.append("				<tr> ");
			sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.id") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolioHabilidade.nomeHabilidade") + "</th> ");
			sb.append("					<th class=\"thAcaoOcorrenciaServico\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.ocorrenciasServico.acao") + "</th> ");
			sb.append("				</tr> ");
			sb.append("			</thead> ");
			sb.append("			<tbody> ");

			for (OcorrenciaServicoHabilidadeDTO ocorrenciaServicoHabilidadeDTO : listaOcorrenciaServicoHabilidade) {
				if (UtilStrings.isNotVazio(ocorrenciaServicoHabilidadeDTO.getAcaoOcorrenciaServico())) {
					acaoOcorrenciaServico = UtilI18N.internacionaliza(request, AuditoriaAcoes.fromIdentificador(ocorrenciaServicoHabilidadeDTO.getAcaoOcorrenciaServico()).getChave());
				} else {
					acaoOcorrenciaServico = "";
				}

				sb.append("		<tr>");
				sb.append("			<td>" + ocorrenciaServicoHabilidadeDTO.getIdHabilidadeOcorrenciaServico() + "</td> ");
				sb.append("			<td>" + ocorrenciaServicoHabilidadeDTO.getNomeHabilidadeOcorrenciaServico() + "</td> ");
				sb.append("			<td class=\"tdAcaoOcorrenciaServico\">");
				if (UtilStrings.isNotVazio(acaoOcorrenciaServico)) {
					sb.append("			<span>");
					sb.append(acaoOcorrenciaServico);
					sb.append("			</span>");
				}
				sb.append("			</td> ");
				sb.append("		</tr> ");
			}

			sb.append("			</tbody> ");
			sb.append("		</table>");
			sb.append("	</div>");
		}

		return sb.toString();
	};

	/**
	 * @author deborah.ferreira
	 * @since 18.02.2016
	 */
	private String geraDadosOcorrenciaServicoAnexos(List<OcorrenciaServicoAnexosDTO> listaOcorrenciaServicoAnexos, String categoriaOcorrenciaServico, HttpServletRequest request) throws Exception {
		StringBuilder sb = new StringBuilder();
		boolean isCategoriaRequisitoNivelServico = OcorrenciaServicoCategorias.REQUISITOS_NIVEL_SERVICO.getIdentificador().equals(categoriaOcorrenciaServico);
		boolean isCategoriaCasoNegocio = OcorrenciaServicoCategorias.CASOS_NEGOCIO.getIdentificador().equals(categoriaOcorrenciaServico);

		if (!listaOcorrenciaServicoAnexos.isEmpty()) {
			String acaoOcorrenciaServicoAnexo;
			String acaoOcorrenciaServicoAnexoInternacionalizado;
			String descricaoAnexo;

			sb.append("<div class=\"row-fluid\" >");
			sb.append("		<div class=\"span12\" style=\"padding: 0px 15px;\">");
			sb.append("			<h5>" + UtilI18N.internacionaliza(request, "citcorpore.comum.documentosAnexos") + "</h5>");
			sb.append("			<hr style=\"margin: 0px;\">");
			sb.append("		</div>");
			sb.append("</div>");
			sb.append("	<div class=\"row-fluid\">");
			sb.append("		<div class=\"span12\">");
			sb.append("			<div class=\"table-responsive tabela\" style=\"padding: 10px 15px;\" >");
			sb.append("				<table class=\"table table-bordered table-striped table-condensed\"> ");
			sb.append("					<thead> ");
			sb.append("						<tr> ");
			sb.append("							<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.id") + "</th> ");
			sb.append("							<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.arquivo") + "</th> ");
			if (isCategoriaRequisitoNivelServico || isCategoriaCasoNegocio) {
				sb.append("							<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.tipoCampoAnexo") + "</th> ");
			} else {
				sb.append("							<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.descricao") + "</th> ");
			}
			sb.append("							<th class=\"thAcaoOcorrenciaServico\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.ocorrenciasServico.acao") + "</th> ");
			sb.append("						</tr> ");
			sb.append("					</thead> ");
			sb.append("					<tbody> ");

			for (OcorrenciaServicoAnexosDTO ocorrenciaServicoAnexosDTO : listaOcorrenciaServicoAnexos) {
				acaoOcorrenciaServicoAnexoInternacionalizado = "";
				acaoOcorrenciaServicoAnexo = ocorrenciaServicoAnexosDTO.getAcaoOcorrenciaServico();
				descricaoAnexo = ocorrenciaServicoAnexosDTO.getDescricaoAnexoOcorrenciaServico();
				if (!UtilStrings.isNullOrEmpty(acaoOcorrenciaServicoAnexo)) {
					acaoOcorrenciaServicoAnexoInternacionalizado = UtilI18N.internacionaliza(request, AuditoriaAcoes.fromIdentificador(acaoOcorrenciaServicoAnexo).getChave());
				}

				if (isCategoriaRequisitoNivelServico) {
					descricaoAnexo = UtilI18N.internacionaliza(request, TipoAnexoRequisitosNivelServico.fromTipo(descricaoAnexo).getChave());
				}

				if (isCategoriaCasoNegocio) {
					descricaoAnexo = UtilI18N.internacionaliza(request, TipoAnexoCasoNegocio.fromTipo(descricaoAnexo).getChave());
				}

				sb.append("				<tr>");
				sb.append("					<td>" + ocorrenciaServicoAnexosDTO.getIdAnexoOcorrenciaServico() + "</td> ");
				sb.append("					<td>" + ocorrenciaServicoAnexosDTO.getNomeAnexoOcorrenciaServico() + "</td> ");
				sb.append("					<td>" + descricaoAnexo + "</td> ");
				sb.append("					<td class=\"tdAcaoOcorrenciaServico\">");
				if (UtilStrings.isNotVazio(acaoOcorrenciaServicoAnexoInternacionalizado)) {
					sb.append("					<span>");
					sb.append(acaoOcorrenciaServicoAnexoInternacionalizado);
					sb.append("					</span>");
				}
				sb.append("					</td> ");
				sb.append("				</tr> ");
			}

			sb.append("					</tbody> ");
			sb.append("				</table>");
			sb.append("			</div>");
			sb.append("		</div>");
			sb.append("	</div>");
		}

		return sb.toString();
	}

	public String geraDadosOcorrenciaServicoDemanda(Integer idOcorrenciaServico, HttpServletRequest request) throws Exception {
		List<OcorrenciaServicoDemandaDTO> ocorrencias = this.getOcorrenciaServicoDemandaService().getDemandaByIdOcorrenciaServico(idOcorrenciaServico);
		StringBuilder sb = new StringBuilder();
		String acaoOcorrenciaServico;

		sb.append("	<div class=\"table-responsive tabela\" >");
		sb.append("		<table class=\"table table-bordered table-striped table-condensed\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th style=\"width: 50%;\" >" + UtilI18N.internacionaliza(request, "citcorpore.comum.nome") + "</th> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.valor") + "</th> ");
		sb.append("					<th class=\"thAcaoOcorrenciaServico\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.ocorrenciasServico.acao") + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody> ");

		for (OcorrenciaServicoDemandaDTO ocorrenciaServicoDemandaDTO : ocorrencias) {
			if (UtilStrings.isNotVazio(ocorrenciaServicoDemandaDTO.getAcaoOcorrenciaServico())) {
				acaoOcorrenciaServico = AuditoriaAcoes.fromIdentificador(ocorrenciaServicoDemandaDTO.getAcaoOcorrenciaServico()).getChave();
				if (acaoOcorrenciaServico != null) {
					acaoOcorrenciaServico = UtilI18N.internacionaliza(request, acaoOcorrenciaServico);
				}
			} else {
				acaoOcorrenciaServico = "";
			}

			sb.append("		<tr>");
			sb.append("			<td>" + ocorrenciaServicoDemandaDTO.getNome() + "</td> ");
			sb.append("			<td>" + ocorrenciaServicoDemandaDTO.getValor() + "</td> ");
			sb.append("			<td class=\"tdAcaoOcorrenciaServico\">");
			if (UtilStrings.isNotVazio(acaoOcorrenciaServico)) {
				sb.append("			<span>");
				sb.append(acaoOcorrenciaServico);
				sb.append("			</span>");
			}
			sb.append("			</td> ");
			sb.append("		</tr> ");
		}

			sb.append("			</tbody> ");
			sb.append("		</table>");
			sb.append("	</div>");

		return sb.toString();
	}

	public String geraDadosOcorrenciaServicoCapacidade(Integer idOcorrenciaServico, HttpServletRequest request) throws Exception {
		List<OcorrenciaServicoCapacidadeDTO> ocorrencias = this.getOcorrenciaServicoCapacidadeService().getCapacidadeByIdOcorrenciaServico(idOcorrenciaServico);
		StringBuilder sb = new StringBuilder();
		String acaoOcorrenciaServico;

		sb.append("	<div class=\"table-responsive tabela\" >");
		sb.append("		<table class=\"table table-bordered table-striped table-condensed\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th style=\"width: 50%;\" >" + UtilI18N.internacionaliza(request, "citcorpore.comum.nome") + "</th> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.valor") + "</th> ");
		sb.append("					<th class=\"thAcaoOcorrenciaServico\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.ocorrenciasServico.acao") + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody> ");

		for (OcorrenciaServicoCapacidadeDTO ocorrenciaServicoCapacidadeDTO : ocorrencias) {
			if (UtilStrings.isNotVazio(ocorrenciaServicoCapacidadeDTO.getAcaoOcorrenciaServico())) {
				acaoOcorrenciaServico = AuditoriaAcoes.fromIdentificador(ocorrenciaServicoCapacidadeDTO.getAcaoOcorrenciaServico()).getChave();
				if (acaoOcorrenciaServico != null) {
					acaoOcorrenciaServico = UtilI18N.internacionaliza(request, acaoOcorrenciaServico);
				}
			} else {
				acaoOcorrenciaServico = "";
			}

			sb.append("		<tr>");
			sb.append("			<td>" + ocorrenciaServicoCapacidadeDTO.getNome() + "</td> ");
			sb.append("			<td>" + ocorrenciaServicoCapacidadeDTO.getValor() + "</td> ");
			sb.append("			<td class=\"tdAcaoOcorrenciaServico\">");
			if (UtilStrings.isNotVazio(acaoOcorrenciaServico)) {
				sb.append("			<span>");
				sb.append(acaoOcorrenciaServico);
				sb.append("			</span>");
			}
			sb.append("			</td> ");
			sb.append("		</tr> ");
		}

		sb.append("			</tbody> ");
		sb.append("		</table>");
		sb.append("	</div>");

		return sb.toString();
	}

	@Override
	public Class<GerenciamentoPortfolioOcorrenciasServicoDTO> getBeanClass() {
		return GerenciamentoPortfolioOcorrenciasServicoDTO.class;
	}

	/**
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	private OcorrenciaServicoService getOcorrenciaServicoService() throws ServiceException {
		if (ocorrenciaServicoService == null) {
			ocorrenciaServicoService = (OcorrenciaServicoService) ServiceLocator.getInstance().getService(OcorrenciaServicoService.class, null);
		}
		return ocorrenciaServicoService;
	}

	/**
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	private OcorrenciaServicoDetalhesService getOcorrenciaServicoDetalhesService() throws ServiceException {
		if (ocorrenciaServicoDetalhesService == null) {
			ocorrenciaServicoDetalhesService = (OcorrenciaServicoDetalhesService) ServiceLocator.getInstance().getService(OcorrenciaServicoDetalhesService.class, null);
		}
		return ocorrenciaServicoDetalhesService;
	}

	/**
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	private OcorrenciaServicoRequisitosNivelServicoService getOcorrenciaServicoRequisitosNivelServicoService() throws ServiceException {
		if (ocorrenciaServicoRequisitosNivelServicoService == null) {
			ocorrenciaServicoRequisitosNivelServicoService = (OcorrenciaServicoRequisitosNivelServicoService) ServiceLocator.getInstance().getService(OcorrenciaServicoRequisitosNivelServicoService.class, null);
		}
		return ocorrenciaServicoRequisitosNivelServicoService;
	}

	/**
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	private OcorrenciaServicoAtributosFinanceirosService getOcorrenciaServicoAtributosFinanceirosService() throws ServiceException {
		if (ocorrenciaServicoAtributosFinanceirosService == null) {
			ocorrenciaServicoAtributosFinanceirosService = (OcorrenciaServicoAtributosFinanceirosService) ServiceLocator.getInstance().getService(OcorrenciaServicoAtributosFinanceirosService.class, null);
		}
		return ocorrenciaServicoAtributosFinanceirosService;
	}

	/**
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	private OcorrenciaServicoCasoNegocioService getOcorrenciaServicoCasoNegocioService() throws ServiceException {
		if (ocorrenciaServicoCasoNegocioService == null) {
			ocorrenciaServicoCasoNegocioService = (OcorrenciaServicoCasoNegocioService) ServiceLocator.getInstance().getService(OcorrenciaServicoCasoNegocioService.class, null);
		}
		return ocorrenciaServicoCasoNegocioService;
	}

	/**
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	private OcorrenciaServicoProcessoNegocioService getOcorrenciaServicoProcessoNegocioService() throws ServiceException {
		if (ocorrenciaServicoProcessoNegocioService == null) {
			ocorrenciaServicoProcessoNegocioService = (OcorrenciaServicoProcessoNegocioService) ServiceLocator.getInstance().getService(OcorrenciaServicoProcessoNegocioService.class, null);
		}
		return ocorrenciaServicoProcessoNegocioService;
	}

	/**
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	private OcorrenciaServicoDonoNegocioService getOcorrenciaServicoDonoNegocioService() throws ServiceException {
		if (ocorrenciaServicoDonoNegocioService == null) {
			ocorrenciaServicoDonoNegocioService = (OcorrenciaServicoDonoNegocioService) ServiceLocator.getInstance().getService(OcorrenciaServicoDonoNegocioService.class, null);
		}
		return ocorrenciaServicoDonoNegocioService;
	}

	/**
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	private OcorrenciaServicoUsuarioNegocioService getOcorrenciaServicoUsuarioNegocioService() throws ServiceException {
		if (ocorrenciaServicoUsuarioNegocioService == null) {
			ocorrenciaServicoUsuarioNegocioService = (OcorrenciaServicoUsuarioNegocioService) ServiceLocator.getInstance().getService(OcorrenciaServicoUsuarioNegocioService.class, null);
		}
		return ocorrenciaServicoUsuarioNegocioService;
	}

	/**
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	private OcorrenciaServicoRelacionadoService getOcorrenciaServicoRelacionadoService() throws ServiceException {
		if (ocorrenciaServicoRelacionadoService == null) {
			ocorrenciaServicoRelacionadoService = (OcorrenciaServicoRelacionadoService) ServiceLocator.getInstance().getService(OcorrenciaServicoRelacionadoService.class, null);
		}
		return ocorrenciaServicoRelacionadoService;
	}

	/**
	 * @author deborah.ferreira
	 * @since 27.01.2016
	 */
	private OcorrenciaServicoAplicacaoService getOcorrenciaServicoAplicacaoService() throws ServiceException {
		if (ocorrenciaServicoAplicacaoService == null) {
			ocorrenciaServicoAplicacaoService = (OcorrenciaServicoAplicacaoService) ServiceLocator.getInstance().getService(OcorrenciaServicoAplicacaoService.class, null);
		}
		return ocorrenciaServicoAplicacaoService;
	}

	/**
	 * @author deborah.ferreira
	 * @since 29.01.2016
	 */
	private OcorrenciaServicoContratoService getOcorrenciaServicoContratoService() throws ServiceException {
		if (ocorrenciaServicoContratoService == null) {
			ocorrenciaServicoContratoService = (OcorrenciaServicoContratoService) ServiceLocator.getInstance().getService(OcorrenciaServicoContratoService.class, null);
		}
		return ocorrenciaServicoContratoService;
	}

	/**
	 * @author deborah.ferreira
	 * @since 01.02.2016
	 */
	private OcorrenciaServicoProprietariosService getOcorrenciaServicoProprietariosService() throws ServiceException {
		if (ocorrenciaServicoProprietariosService == null) {
			ocorrenciaServicoProprietariosService = (OcorrenciaServicoProprietariosService) ServiceLocator.getInstance().getService(OcorrenciaServicoProprietariosService.class, null);
		}
		return ocorrenciaServicoProprietariosService;
	}

	/**
	 * @author deborah.ferreira
	 * @since 02.02.2016
	 */
	private OcorrenciaServicoEsquemaDadosService getOcorrenciaServicoEsquemaDadosService() throws ServiceException {
		if (ocorrenciaServicoEsquemaDadosService == null) {
			ocorrenciaServicoEsquemaDadosService = (OcorrenciaServicoEsquemaDadosService) ServiceLocator.getInstance().getService(OcorrenciaServicoEsquemaDadosService.class, null);
		}
		return ocorrenciaServicoEsquemaDadosService;
	}

	/**
	 * @author deborah.ferreira
	 * @since 02.02.2016
	 */
	private OcorrenciaServicoAnexosService getOcorrenciaServicoAnexosService() throws ServiceException {
		if (ocorrenciaServicoAnexosService == null) {
			ocorrenciaServicoAnexosService = (OcorrenciaServicoAnexosService) ServiceLocator.getInstance().getService(OcorrenciaServicoAnexosService.class, null);
		}
		return ocorrenciaServicoAnexosService;
	}

	/**
	 * @author deborah.ferreira
	 * @since 03.02.2016
	 */
	private OcorrenciaServicoDesenhoMapaServicoService getOcorrenciaServicoDesenhoMapaServicoService() throws ServiceException {
		if (ocorrenciaServicoDesenhoMapaServicoService == null) {
			ocorrenciaServicoDesenhoMapaServicoService = (OcorrenciaServicoDesenhoMapaServicoService) ServiceLocator.getInstance().getService(OcorrenciaServicoDesenhoMapaServicoService.class, null);
		}
		return ocorrenciaServicoDesenhoMapaServicoService;
	}

	/**
	 * @author deborah.ferreira
	 * @since 17.02.2016
	 */
	private OcorrenciaServicoBaseConhecimentoService getOcorrenciaServicoBaseConhecimentoService() throws ServiceException {
		if (ocorrenciaServicoBaseConhecimentoService == null) {
			ocorrenciaServicoBaseConhecimentoService = (OcorrenciaServicoBaseConhecimentoService) ServiceLocator.getInstance().getService(OcorrenciaServicoBaseConhecimentoService.class, null);
		}
		return ocorrenciaServicoBaseConhecimentoService;
	}

	/**
	 * @author deborah.ferreira
	 * @since 17.02.2016
	 */
	private OcorrenciaServicoHabilidadeService getOcorrenciaServicoHabilidadeService() throws ServiceException {
		if (ocorrenciaServicoHabilidadeService == null) {
			ocorrenciaServicoHabilidadeService = (OcorrenciaServicoHabilidadeService) ServiceLocator.getInstance().getService(OcorrenciaServicoHabilidadeService.class, null);
		}
		return ocorrenciaServicoHabilidadeService;
	}

	private OcorrenciaServicoDemandaService getOcorrenciaServicoDemandaService() throws ServiceException {
		if (ocorrenciaServicoDemandaService == null) {
			ocorrenciaServicoDemandaService = (OcorrenciaServicoDemandaService) ServiceLocator.getInstance().getService(OcorrenciaServicoDemandaService.class, null);
		}
		return ocorrenciaServicoDemandaService;
	}

	private OcorrenciaServicoCapacidadeService getOcorrenciaServicoCapacidadeService() throws ServiceException {
		if (ocorrenciaServicoCapacidadeService == null) {
			ocorrenciaServicoCapacidadeService = (OcorrenciaServicoCapacidadeService) ServiceLocator.getInstance().getService(OcorrenciaServicoCapacidadeService.class, null);
		}
		return ocorrenciaServicoCapacidadeService;
	}

	/**
	 * @author deborah.ferreira
	 * @since 18.02.2016
	 */
	private String getElementoContadorAnexos(Map<String, Integer> tipoAnexoQuantidade, String tipoAnexo) {
		Integer valor = tipoAnexoQuantidade.get(tipoAnexo);
		valor = valor != null ? valor : 0;

		return this.getElementoContadorAnexos(valor);
	}

	/**
	 * @author deborah.ferreira
	 * @since 18.02.2016
	 */
	private String getElementoContadorAnexos(Integer qtdAnexos) {
		StringBuilder sb = new StringBuilder();
		String contadorClass = "rfloat label ocorrenciaContadorAnexos";

		if (qtdAnexos > 0) {
			contadorClass = contadorClass.concat(" ocorrenciaContadorAnexos_comAnexo");
		}

		sb.append("<label class=\"" + contadorClass + "\">");
		sb.append("		<i class=\"lfloat material-icons md-14\">attach_file</i>".concat(qtdAnexos.toString()));
		sb.append("</label>");

		return sb.toString();
	}

	/**
	 * @author deborah.ferreira
	 * @since 18.02.2016
	 */
	private Map<String, Integer> getListaContadorAnexos(Collection<OcorrenciaServicoAnexosDTO> listaAnexos) throws Exception {
		List<String> listaTipoAnexo = new ArrayList<String>();

		for (final OcorrenciaServicoAnexosDTO anexo : listaAnexos) {
			if (!AuditoriaAcoes.REMOVIDO.getIdentificador().equals(anexo.getAcaoOcorrenciaServico())) {
				listaTipoAnexo.add(anexo.getDescricaoAnexoOcorrenciaServico());
			}
		}

		return UtilListas.agrupaDuplicadosComQtde(listaTipoAnexo);
	}

}
