package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.bpm.dto.TipoFluxoDTO;
import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioProcessoNegocioDTO;
import br.com.centralit.citcorpore.bean.ProcessoNegocioDTO;
import br.com.centralit.citcorpore.bean.ServicoProcessoNegocioDTO;
import br.com.centralit.citcorpore.bean.UnidadeDTO;
import br.com.centralit.citcorpore.negocio.GrupoService;
import br.com.centralit.citcorpore.negocio.ProcessoNegocioService;
import br.com.centralit.citcorpore.negocio.ProcessoNegocioTiposFluxoService;
import br.com.centralit.citcorpore.negocio.ProcessoNegocioUnidadesService;
import br.com.centralit.citcorpore.negocio.ServicoProcessoNegocioService;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.centralit.citcorpore.util.Enumerados.PagesPortfolio;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.core.PageRequest;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;
import br.com.citframework.util.UtilStrings;

public class GerenciamentoPortfolioProcessoNegocio extends AjaxFormAction {

	private ServicoProcessoNegocioService servicoProcessoNegocioService;
	private ProcessoNegocioService processoNegocioService;
	private static Permissoes permissao;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		GerenciamentoPortfolioProcessoNegocioDTO beanDto = (GerenciamentoPortfolioProcessoNegocioDTO) document.getBean();
		setPermissaoPortfolioProcessoNegocio(document, request);

		if (beanDto != null && !UtilNumbersAndDecimals.isNull(beanDto.getIdServico())) {
			this.restoreProcessosNegocioVinculados(beanDto, document, request);
		}
	}

	private void setPermissaoPortfolioProcessoNegocio(DocumentHTML document, HttpServletRequest request) {
		permissao = new Permissoes(document, request, PagesPortfolio.SERVICO_NEGOCIO_PROCESSO_NEGOCIO.getCaminho());
	}

	private void restoreProcessosNegocioVinculados(GerenciamentoPortfolioProcessoNegocioDTO processoNegocioDto, DocumentHTML document, HttpServletRequest request) throws Exception {
		setPermissaoPortfolioProcessoNegocio(document, request);
		HTMLForm form = document.getForm("formVincularProcessoNegocio");
		form.clear();
		form.setValues(processoNegocioDto);
		Collection<ProcessoNegocioDTO> listaProcessosNegocioVinculados = getServicoProcessoNegocioService().findProcessosNegocioByIdServico(processoNegocioDto.getIdServico());
		String listaIdsProcessosNegocioVinculados = new String();

		for (ProcessoNegocioDTO processoNegocioDTO : listaProcessosNegocioVinculados) {
			listaIdsProcessosNegocioVinculados += processoNegocioDTO.getIdProcessoNegocio()+";";
		}
		document.getForm("formVincularProcessoNegocio").setValue("listaIdsProcessosNegocioVinculados", listaIdsProcessosNegocioVinculados);
		// Necessrio chamar pelo js pois o document nesse escopo  o do pai
		document.executeScript("VincularProcessoNegocio.carregarTabelaProcessoNegocio();");
	}

	/**
	 * Vincula os processos de negcio ao servio
	 *
	 * @author deborah.ferreira
	 * @since 19.01.2016
	 */
	public void vincularProcessosNegocioAoServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		setPermissaoPortfolioProcessoNegocio(document, request);
		if(permissao.isGravar()){
			try {
				GerenciamentoPortfolioProcessoNegocioDTO gerenciamentoPortfolioProcessoNegocioDTO = (GerenciamentoPortfolioProcessoNegocioDTO) document.getBean();
				String listaIdsProcessosNegocioStr = gerenciamentoPortfolioProcessoNegocioDTO.getColAllLOOKUP_SERVICO_VINCULAR_PROCESSO_NEGOCIO();
				Integer idServico = gerenciamentoPortfolioProcessoNegocioDTO.getIdServico();
				String[] listaIdsProcessosNegocio = new String[] {};
				listaIdsProcessosNegocio = listaIdsProcessosNegocioStr.split(";");
				List<Integer> idsProcessoNegociosVinculados = new ArrayList<Integer>();
	
				if(idServico > 0 && listaIdsProcessosNegocio != null && listaIdsProcessosNegocio.length > 0) {
					for(String idProcessoNegocioStr: listaIdsProcessosNegocio) {
						Integer idProcessoNegocio = Integer.parseInt(idProcessoNegocioStr);
						ServicoProcessoNegocioDTO servicoProcessoNegocioDTO = new ServicoProcessoNegocioDTO();
	
						servicoProcessoNegocioDTO.setIdServico(idServico);
						servicoProcessoNegocioDTO.setIdProcessoNegocio(idProcessoNegocio);
						getServicoProcessoNegocioService().create(servicoProcessoNegocioDTO);
	
						idsProcessoNegociosVinculados.add(idProcessoNegocio);
					}
	
					document.executeScript("notificacaoI18N('gerenciaportfolio.processoNegocioVinculadoComSucesso','')");
					document.executeScript("VincularProcessoNegocio.fecharPopup();");
	
					gerenciamentoPortfolioProcessoNegocioDTO.setIdsProcessoNegocioOcorrenciaServico(idsProcessoNegociosVinculados.toString());
					gerenciamentoPortfolioProcessoNegocioDTO.setAcaoProcessoNegocioOcorrenciaServico(AuditoriaAcoes.VINCULADO.getIdentificador());
					this.salvarOcorrenciaServicoProcessoNegocio(document, request, response);
					this.montarHTMLProcessoNegocio(document, request, response);
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}else{
			document.executeScript("notificacaoErro('citcorpore.comum.naoFoiPossivelVincular','citcorpore.comum.usuarioSemPermissao')");
		}
	}

	/**
	 * Mtodo para vincular vrios servios de incidente ao servio de negcio a
	 * partir da lookup com checkbox
	 *
	 * @author deborah.ferreira
	 * @since 19.01.2016
	 */
	public void adicionaTabelaLOOKUP_SERVICO_VINCULAR_PROCESSO_NEGOCIO(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		if(permissao.isGravar()) {
			this.vincularProcessosNegocioAoServico(document, request, response);
		} else {
			document.getForm("formVincularProcessoNegocioVisualizar").setValue("colAllLOOKUP_SERVICO_VINCULAR_PROCESSO_NEGOCIO", "");
			document.executeScript("notificacaoErro('citcorpore.comum.naoFoiPossivelVincular','citcorpore.comum.usuarioSemPermissao')");
			document.executeScript("VincularProcessoNegocio.fecharPopup();");
		}
	}

	public void montarHTMLProcessoNegocio(DocumentHTML document, HttpServletRequest request, HttpServletResponse response)
			throws ServiceException, Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		HTMLElement divListaProcessosNegocios = document.getElementById("divDinamicoListaProcessosNegocio");
		GerenciamentoPortfolioProcessoNegocioDTO gerenciamentoPortfolioProcessoNegocioDTO = (GerenciamentoPortfolioProcessoNegocioDTO) document.getBean();

		String filtroProcessoNegocio = gerenciamentoPortfolioProcessoNegocioDTO.getFiltroProcessoNegocio();
		if (filtroProcessoNegocio == null) {
			filtroProcessoNegocio = "";
		}

		Integer itensPorPagina = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANT_RETORNO_PESQUISA, "10"));

		Integer paginaSelecionadaProcessoNegocio = gerenciamentoPortfolioProcessoNegocioDTO.getPaginaSelecionadaProcessoNegocio();
		if (paginaSelecionadaProcessoNegocio == null || paginaSelecionadaProcessoNegocio == 0) {
			paginaSelecionadaProcessoNegocio = 1;
		}

		Pageable pageable = new PageRequest(paginaSelecionadaProcessoNegocio - 1, itensPorPagina);

		Collection<ProcessoNegocioDTO> listProcessoNegocio = getProcessoNegocioService().listProcessoDeNegocio(gerenciamentoPortfolioProcessoNegocioDTO.getIdServico(),
				filtroProcessoNegocio, pageable, false).getContent();

		if (listProcessoNegocio != null && !listProcessoNegocio.isEmpty()) {
			divListaProcessosNegocios.setInnerHTML(geraTabelaProcessoNegocio(listProcessoNegocio, document, request));

			Integer totalPaginasProcessoNegocio = getProcessoNegocioService().listProcessoDeNegocio(gerenciamentoPortfolioProcessoNegocioDTO.getIdServico(),
					filtroProcessoNegocio, pageable, true).getTotalPages();

			HTMLElement paginacaoProcessoNegocio = document.getElementById("paginacaoProcessoNegocio");
			String funcaoJsPaginarNegocio = "VincularProcessoNegocio.paginarProcessoNegocio";
			paginacaoProcessoNegocio.setInnerHTML(UtilHTML.paginacaoHtml(request, funcaoJsPaginarNegocio, totalPaginasProcessoNegocio, paginaSelecionadaProcessoNegocio));
		} else {
			divListaProcessosNegocios.setInnerHTML("<h4>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nenhumProcessoNegocioVinculado") + "</h4>");
		}

		document.executeScript("VincularProcessoNegocio.depoisMontarHTMLProcessoNegocio();");
	}

	/**
	 * Desvincular processo de negcio do servio
	 *
	 * @author deborah.ferreira
	 * @since 19.01.2016
	 */
	public void desvincularProcessoNegocioFromServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws ServiceException {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		try {
			GerenciamentoPortfolioProcessoNegocioDTO gerenciamentoPortfolioProcessoNegocioDTO = (GerenciamentoPortfolioProcessoNegocioDTO) document.getBean();

			if(gerenciamentoPortfolioProcessoNegocioDTO != null && gerenciamentoPortfolioProcessoNegocioDTO.getIdServico() != null && gerenciamentoPortfolioProcessoNegocioDTO.getIdProcessoNegocio() != null) {
				Integer idProcessoNegocio = gerenciamentoPortfolioProcessoNegocioDTO.getIdProcessoNegocio();
				Integer idServico = gerenciamentoPortfolioProcessoNegocioDTO.getIdServico();
				getServicoProcessoNegocioService().deleteProcessoFromServico(idProcessoNegocio, idServico);
				document.executeScript("notificacaoI18N('gerenciaportfolio.processoNegocioDesvinculadoComSucesso','')");
				montarHTMLProcessoNegocio(document, request, response);
				gerenciamentoPortfolioProcessoNegocioDTO.setIdsProcessoNegocioOcorrenciaServico(idProcessoNegocio.toString());
				gerenciamentoPortfolioProcessoNegocioDTO.setAcaoProcessoNegocioOcorrenciaServico(AuditoriaAcoes.DESVINCULADO.getIdentificador());
				this.salvarOcorrenciaServicoProcessoNegocio(document, request, response);
			} else {
				document.executeScript("notificacaoErro('citcorpore.comum.naoFoiPossivelDesvincular','')");
			}
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	/**
	 * Visualizar o processo de negcio
	 *
	 * @author deborah.ferreira
	 * @since 19.01.2016
	 */
	public void visualizarProcessoNegocio(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws ServiceException {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		try {
			GerenciamentoPortfolioProcessoNegocioDTO gerenciamentoPortfolioProcessoNegocioDTO = (GerenciamentoPortfolioProcessoNegocioDTO) document.getBean();
			ProcessoNegocioDTO processoNegocioDTO = getProcessoNegocioService().findProcessoNegocioById(gerenciamentoPortfolioProcessoNegocioDTO.getIdProcessoNegocio());
			if(processoNegocioDTO != null && processoNegocioDTO.getIdProcessoNegocio() != null) {
				Integer idProcessoNegocio = processoNegocioDTO.getIdProcessoNegocio();
				GrupoService grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, WebUtil.getUsuarioSistema(request));
				Integer idGrupoExecutor = processoNegocioDTO.getIdGrupoExecutor();
				Integer idGrupoAdministrador = processoNegocioDTO.getIdGrupoAdministrador();

				document.getForm("formVincularProcessoNegocioVisualizar").setValue("nomeProcessoNegocioVisualizar", processoNegocioDTO.getNomeProcessoNegocio());
				if(idGrupoExecutor != null) {
					document.getForm("formVincularProcessoNegocioVisualizar").setValue("idGrupoExecutorVisualizar", grupoService.listGrupoById(idGrupoExecutor).getNome());
				} else {
					document.getForm("formVincularProcessoNegocioVisualizar").setValue("idGrupoExecutorVisualizar", "-");
				}

				if(idGrupoAdministrador != null) {
					document.getForm("formVincularProcessoNegocioVisualizar").setValue("idGrupoAdministradorVisualizar", grupoService.listGrupoById(idGrupoAdministrador).getNome());
				} else {
					document.getForm("formVincularProcessoNegocioVisualizar").setValue("idGrupoAdministradorVisualizar", "-");
				}

				ProcessoNegocioTiposFluxoService processoNegocioTiposFluxoService = (ProcessoNegocioTiposFluxoService) ServiceLocator.getInstance().getService(ProcessoNegocioTiposFluxoService.class, WebUtil.getUsuarioSistema(request));
				Collection<TipoFluxoDTO> tiposFluxosVinculadosProcessoNegocio = processoNegocioTiposFluxoService.findTiposFluxoByIdProcessoNegocio(idProcessoNegocio);
				StringBuilder sb;
				HTMLElement divTiposFluxos = document.getElementById("divTiposFluxosVisualizar");
				divTiposFluxos.setInnerHTML("");

				if(tiposFluxosVinculadosProcessoNegocio != null && tiposFluxosVinculadosProcessoNegocio.size() > 0) {
					sb = new StringBuilder();
					sb.append("<ul class=\"unstyled\">");

					for(TipoFluxoDTO tipoFluxo: tiposFluxosVinculadosProcessoNegocio) {
						sb.append("		<li><span>"+tipoFluxo.getDescricao()+"</span></li>");
					}

					sb.append("</ul>");
					divTiposFluxos.appendHTML(sb.toString());
				} else {
					divTiposFluxos.setInnerHTML("<h4>" + UtilI18N.internacionaliza(request, "processoNegocio.nenhumTipoFluxoVinculado") + "</h4>");
				}

				ProcessoNegocioUnidadesService processoNegocioUnidadesService = (ProcessoNegocioUnidadesService) ServiceLocator.getInstance().getService(ProcessoNegocioUnidadesService.class, null);
				List<UnidadeDTO> listaUnidadesVinculadasProcessoNegocio = (List<UnidadeDTO>) processoNegocioUnidadesService.findUnidadesByIdProcessoNegocio(idProcessoNegocio);
				HTMLElement divUnidades = document.getElementById("divUnidadesVisualizar");

				divUnidades.setInnerHTML(geraHtmlTabelaProcessosNegocioVisualizar(listaUnidadesVinculadasProcessoNegocio, document, request));

			}
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	/**
	 * Gera o html dos dados da tabela vincular processo negocio
	 *
	 * @author deborah.ferreira
	 * @since 19.01.2016
	 */
	private String geraHtmlTabelaProcessosNegocioVisualizar(List<UnidadeDTO> listaUnidades, DocumentHTML document, HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		if(listaUnidades != null && listaUnidades.size() > 0) {
			sb.append("	<div class=\"table-responsive tabela\">");
			sb.append("		<table class=\"table table-bordered table-striped table-condensed\"> ");
			sb.append("			<thead> ");
			sb.append("				<tr> ");
			sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "ID") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "processoNegocio.descricaoUnidade") + "</th> ");
			sb.append("				</tr> ");
			sb.append("			</thead> ");
			sb.append("			<tbody> ");

			for (UnidadeDTO unidadeDTO : listaUnidades) {
				sb.append("		<tr>");
				sb.append("			<td class=\"center\">" + unidadeDTO.getIdUnidade() + "</td> ");
				sb.append("			<td>" + unidadeDTO.getNome() + "</td> ");
				sb.append("		</tr> ");
			}

			sb.append("			</tbody> ");
			sb.append("		</table>");
			sb.append("	</div>");
		} else {
			sb.append("<h4>" + UtilI18N.internacionaliza(request, "processoNegocio.nenhumaUnidadeVinculada") + "</h4>");
		}

		return sb.toString();
	}


	/**
	 * Gera o html da tabela de processos de negcio
	 *
	 * @author deborah.ferreia
	 * @since 19.01.2016
	 */
	private String geraTabelaProcessoNegocio(Collection<ProcessoNegocioDTO> listaProcessoNegocio, DocumentHTML document, HttpServletRequest request) throws Exception{
		StringBuilder sb = new StringBuilder();

		sb.append(geraCabecalhoTabelaProcessoNegocio(request));
		sb.append(geraDadosTabelaProcessoNegocio(document, request, listaProcessoNegocio));
		sb.append(geraFinalTabelaProcessoNegocio());

		return sb.toString();
	}

	/**
	 * Gera o html do cabealho da tabela de processos de negcio
	 *
	 * @author deborah.ferreira
	 * @since 19.01.2016
	 */
	private String geraCabecalhoTabelaProcessoNegocio(HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		sb.append("<div class='row-fluid' id='tabelaProcessoNegocio'> ");
		sb.append("	<div class=\"table-responsive tabela\">");
		sb.append("		<table class=\"table table-bordered table-striped table-condensed\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.id") + "</th> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nomeProcessoNegocio") + "</th> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "processoNegocio.cliente") + "</th> ");
		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.acoes") + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody id='bodyTabelaProcessoNegocio'> ");

		return sb.toString();
	}

	/**
	 * Gera o html dos dados da tabela de processos de negcio
	 *
	 * @author deborah.ferreira
	 * @since 19.01.2016
	 */
	private String geraDadosTabelaProcessoNegocio(DocumentHTML document, HttpServletRequest request, Collection<ProcessoNegocioDTO> listaProcessoNegocio) throws ServiceException, Exception {
		StringBuilder sb = new StringBuilder();
		String onMouseOver = "onmouseover=\"abreTooltip(this, '"+UtilI18N.internacionaliza(request, "gerenciaportfolio.desvincularProcessoNegocio")+"')\" onmouseout=\"fechaTooltip();\"";
		String onMouseOverVisualizar = "onmouseover=\"abreTooltip(this, '"+UtilI18N.internacionaliza(request, "gerenciaportfolio.visualizarProcessoNegocio")+"')\" onmouseout=\"fechaTooltip();\"";

		for(ProcessoNegocioDTO processoNegocioDTO: listaProcessoNegocio) {
			sb.append("		<tr id=\""+processoNegocioDTO.getIdProcessoNegocio()+"\">");
			sb.append("			<td class=\"center\">" + processoNegocioDTO.getIdProcessoNegocio() + "</td> ");
			sb.append("			<td>" + processoNegocioDTO.getNomeProcessoNegocio() + "</td> ");
			sb.append("			<td style=\"width: 70%;\" >" + (UtilStrings.nullToVazio(processoNegocioDTO.getProcessoNegocioCliente())) + "</td> ");
			sb.append("			<td class=\"center\" style=\"width: 60px;\"> ");
			if (permissao.isGravar()) {
				sb.append("				<a onclick=\"VincularProcessoNegocio.desvincularProcessoNegocioFromServico(this);\"/"+onMouseOver+" class=\"btn-action glyphicons remove_2 btn-default\"><i></i></a>");
			}
			sb.append("				<a onclick=\"VincularProcessoNegocio.abrirPopupProcessoNegocio("+processoNegocioDTO.getIdProcessoNegocio()+");\"/"+onMouseOverVisualizar+" class=\"btn-action glyphicons search btn-default\"><i></i></a>");
			sb.append("			</td> ");
			sb.append("		</tr> ");
		}

		return sb.toString();
	}

	/**
	 * Gera o html do final da tabela de processos de negcio
	 *
	 * @author deborah.ferreira
	 * @since 19.01.2016
	 */
	private String geraFinalTabelaProcessoNegocio() {
		StringBuilder sb = new StringBuilder();
		sb.append("			</tbody> ");
		sb.append("		</table>");
		sb.append("	</div>");
		sb.append("</div>");
		sb.append("<div class='row-fluid'> ");
		sb.append("	<div id=\"paginacaoProcessoNegocio\" class=\"divPaginacao\"></div>");
		sb.append("</div>");

		return sb.toString();
	}

	/**
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	public void salvarOcorrenciaServicoProcessoNegocio(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioProcessoNegocioDTO gerenciamentoPortfolioProcessoNegocioDTO = (GerenciamentoPortfolioProcessoNegocioDTO) document.getBean();
		GerenciamentoPortfolioOcorrenciasServico gerenciamentoPortfolioOcorrenciasServico = new GerenciamentoPortfolioOcorrenciasServico();

		gerenciamentoPortfolioOcorrenciasServico.salvaOcorrenciaServicoProcessoNegocio(gerenciamentoPortfolioProcessoNegocioDTO.getIdServico(), gerenciamentoPortfolioProcessoNegocioDTO, document,
				request);
	}

	@Override
	public Class<GerenciamentoPortfolioProcessoNegocioDTO> getBeanClass() {
		return GerenciamentoPortfolioProcessoNegocioDTO.class;
	}

	private ServicoProcessoNegocioService getServicoProcessoNegocioService() throws ServiceException {
		if (servicoProcessoNegocioService == null) {
			servicoProcessoNegocioService = (ServicoProcessoNegocioService) ServiceLocator.getInstance().getService(ServicoProcessoNegocioService.class, null);
		}
		return servicoProcessoNegocioService;
	}

	private ProcessoNegocioService getProcessoNegocioService() throws ServiceException {
		if (processoNegocioService == null) {
			processoNegocioService = (ProcessoNegocioService) ServiceLocator.getInstance().getService(ProcessoNegocioService.class, null);
		}
		return processoNegocioService;
	}

}
