package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citcorpore.bean.EmpregadoDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioProprietariosDTO;
import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.VinculoServicoProprietariosDTO;
import br.com.centralit.citcorpore.negocio.EmpregadoService;
import br.com.centralit.citcorpore.negocio.GrupoService;
import br.com.centralit.citcorpore.negocio.VinculoServicoProprietariosService;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.centralit.citcorpore.util.Enumerados.PagesPortfolio;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;

/**
 * @since 20.01.2016
 * @author gustavo.gomes
 */
public class GerenciamentoPortfolioProprietarios extends AjaxFormAction {

	private VinculoServicoProprietariosService proprietariosService;
	private EmpregadoService empregadoService;
	private GrupoService grupoService;
	private static Permissoes permissao;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioProprietariosDTO beanDto = (GerenciamentoPortfolioProprietariosDTO) document.getBean();
		permissao = new Permissoes(document, request, PagesPortfolio.SERVICO_NEGOCIO_PROPRIETARIOS_TI.getCaminho());

		if (beanDto != null && !UtilNumbersAndDecimals.isNull(beanDto.getIdServico())) {
			this.restauraProprietarios(beanDto, document, request);
		}
	}

	public void restauraProprietariosFiltro(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		try {
			GerenciamentoPortfolioProprietariosDTO dto = (GerenciamentoPortfolioProprietariosDTO) document.getBean();
			this.restauraProprietarios(dto, document, request);
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
		} catch (Exception e) {
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
			e.printStackTrace();
			document.alert(UtilI18N.internacionaliza(request, "MSE02"));
		}
	}

	private void restauraProprietarios(GerenciamentoPortfolioProprietariosDTO beanDto, DocumentHTML document, HttpServletRequest request) throws Exception {
		try{
			HTMLElement divListaProprietarios = document.getElementById("divDinamicoTabelaProprietarios");
			StringBuilder sb = new StringBuilder();
			VinculoServicoProprietariosService vinculoService = this.getServicoProprietariosService();
			GerenciamentoPortfolioProprietariosDTO proprietarios = (GerenciamentoPortfolioProprietariosDTO)document.getBean();
			Collection<VinculoServicoProprietariosDTO> vinculos = vinculoService.findProprietariosByServico(proprietarios.getIdServico(), beanDto.getFiltroProprietario());

			if(vinculos==null || vinculos.isEmpty()){
				sb.append("<h4>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nenhumProprietarioVinculado") + "</h4>");
			}else{
				sb.append(geraHtmlCabecalhoTabela(request));
				sb.append(geraHtmlDadosTabela(document, request, vinculos));
				sb.append(geraHTMLFinalTabela());
			}
			divListaProprietarios.setInnerHTML(sb.toString());
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
		}catch(Exception e){
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
			e.printStackTrace();
			document.alert(UtilI18N.internacionaliza(request, "MSE02"));
		}
	}

	private String geraHtmlCabecalhoTabela(HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		sb.append("<div class='row-fluid' id='tabelaProprietarios'> ");
		sb.append("	<div class=\"table-responsive tabela\">");
		sb.append("		<table class=\"table table-bordered table-striped table-condensed table-vertical-center checkboxs js-table-sortable ui-sortable\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.id") + "</th> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.proprietarioNome") + "</th> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.tipo") + "</th> ");
		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.acoes") + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody> ");

		return sb.toString();
	}

	private String geraHtmlDadosTabela(DocumentHTML document, HttpServletRequest request, Collection<VinculoServicoProprietariosDTO> vinculos) throws Exception {

		StringBuilder sb = new StringBuilder();

		for(VinculoServicoProprietariosDTO vinculo: vinculos){
			sb.append("		<tr>");
			sb.append("			<td class=\"center\">" + vinculo.getIdVinculoServicoProprietarios() + "</td> ");
			if(vinculo.getTipo().equals(VinculoServicoProprietariosDTO.TIPO_EMPREGADO)){
				EmpregadoDTO emp = new EmpregadoDTO();
				emp.setIdEmpregado(vinculo.getIdEmpregado());
				emp = this.getEmpregadoService().restore(emp);
				if(emp.getNome()!=null) {
					sb.append("			<td>" + emp.getNome() + "</td> ");
				} else {
					sb.append("			<td>" + " " + "</td> ");
				}
			}else if(vinculo.getTipo().equals(VinculoServicoProprietariosDTO.TIPO_GRUPO)){
					GrupoDTO grupo = new GrupoDTO();
					grupo.setIdGrupo(vinculo.getIdGrupo());
					grupo = this.getGrupoService().restore(grupo);
					if(grupo.getNome()!=null) {
						sb.append("			<td>" + grupo.getNome() + "</td> ");
					} else {
						sb.append("			<td>" + " " + "</td> ");
					}
			}else{
				sb.append("			<td> \"  \" </td> ");
			}
			sb.append("			<td>"
					+ (vinculo.getTipo().equals(VinculoServicoProprietariosDTO.TIPO_GRUPO) ? UtilI18N.internacionaliza(request, "citcorpore.comum.grupo") : UtilI18N.internacionaliza(request, "citcorpore.comum.usuario"))
					+ "</td> ");
			sb.append("			<td class=\"center\" style=\"width: 90px;\"> ");
			if (permissao.isGravar()) {
				sb.append(
						"				<a onmouseout=\"fechaTooltip()\" onmouseover=\"abreTooltip(this, 'gerenciaportfolio.DesvincularProprietario')\" onclick=\"desvincularProprietario('"
								+ vinculo.getIdVinculoServicoProprietarios()
								+ "');\" class=\"btn-action glyphicons remove_2 btn-default\"><i></i></a>");
			}
			sb.append("			</td> ");
			sb.append("		</tr> ");
		}
		return sb.toString();
	}

	private String geraHTMLFinalTabela() {
		StringBuilder sb = new StringBuilder();
		sb.append("			</tbody> ");
		sb.append("		</table>");
		sb.append("	</div>");
		sb.append("</div>");
		sb.append("<div class='row-fluid'> ");
		sb.append("	<div id=\"paginacaoProprietarios\" class=\"divPaginacao\"></div>");
		sb.append("</div>");

		return sb.toString();
	}

	public void vincularEmpregadoProprietarios(String proprietarios, Integer idServico, DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		try {
			if (proprietarios.isEmpty()) {
				document.executeScript("JANELA_AGUARDE_MENU.hide();");
				document.executeScript("notificacaoErro('gerenciaportfolio.selecioneNovos')");
				return;
			}

			String[] proprietariosList = proprietarios.split(";");
			List<String> listaIdsVinculados = new ArrayList<String>();

			if (idServico > 0 && proprietariosList != null && proprietariosList.length > 0) {
				for (String p : proprietariosList) {
					VinculoServicoProprietariosDTO vinculo = new VinculoServicoProprietariosDTO();
					vinculo.setIdServico(idServico);
					vinculo.setIdEmpregado(Integer.parseInt(p));
					vinculo.setTipo(VinculoServicoProprietariosDTO.TIPO_EMPREGADO);
					if (this.getServicoProprietariosService().existeVinculo(vinculo.getIdServico(), vinculo.getIdEmpregado(), vinculo.getTipo())) {
						document.alert("gerenciaportfolio.proprietarioJaVinculado");
						continue;
					}
					VinculoServicoProprietariosDTO vinculoServicoProprietariosVinculado = this.getServicoProprietariosService().create(vinculo);
					listaIdsVinculados.add(vinculoServicoProprietariosVinculado.getIdVinculoServicoProprietarios().toString());
				}

				GerenciamentoPortfolioProprietariosDTO beanDto = new GerenciamentoPortfolioProprietariosDTO();
				beanDto.setFiltroProprietario("");
				this.restauraProprietarios(beanDto, document, request);
				document.executeScript("JANELA_AGUARDE_MENU.hide();");
				document.executeScript("notificacao('" + UtilI18N.internacionaliza(request, "gerenciaportfolio.proprietarioVinculadoSucesso") + "', '')");
				document.getForm("formGerenciamentoPortfolioProprietarios").setValue("idsProprietariosOcorrenciaServico", listaIdsVinculados.toString().replace("[", "").replace("]", ""));
				document.executeScript("vincularSalvarOcorrenciaServicoProprietarios();");
			}
		} catch (Exception e) {
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
			e.printStackTrace();
			document.alert(UtilI18N.internacionaliza(request, "MSE02"));
		}
	}

	public void vincularGruposProprietarios(String proprietarios, Integer idServico, DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		try{
			if(proprietarios.isEmpty()){
				document.executeScript("JANELA_AGUARDE_MENU.hide();");
				document.executeScript("notificacaoErro('gerenciaportfolio.selecioneNovos')");
				return;
			}

			String[] proprietariosList = proprietarios.split(";");
			List<String> listaIdsVinculados = new ArrayList<String>();

			if (idServico > 0 && proprietariosList != null && proprietariosList.length > 0) {
				for(String p : proprietariosList){
					VinculoServicoProprietariosDTO vinculo = new VinculoServicoProprietariosDTO();
					vinculo.setIdServico(idServico);
					vinculo.setIdGrupo(Integer.parseInt(p));
					vinculo.setTipo(VinculoServicoProprietariosDTO.TIPO_GRUPO);
					if(this.getServicoProprietariosService().existeVinculo(vinculo.getIdServico(), vinculo.getIdGrupo(), vinculo.getTipo())){
						document.alert("gerenciaportfolio.proprietarioJaVinculado");
						continue;
					}

					VinculoServicoProprietariosDTO vinculoServicoProprietariosVinculado = this.getServicoProprietariosService().create(vinculo);
					listaIdsVinculados.add(vinculoServicoProprietariosVinculado.getIdVinculoServicoProprietarios().toString());

				}
				GerenciamentoPortfolioProprietariosDTO beanDto = new GerenciamentoPortfolioProprietariosDTO();
				beanDto.setFiltroProprietario("");
				this.restauraProprietarios(beanDto, document, request);
				document.executeScript("JANELA_AGUARDE_MENU.hide();");
				document.executeScript("notificacao('" + UtilI18N.internacionaliza(request, "gerenciaportfolio.proprietarioVinculadoSucesso") + "', '')");
				document.getForm("formGerenciamentoPortfolioProprietarios").setValue("idsProprietariosOcorrenciaServico", listaIdsVinculados.toString().replace("[", "").replace("]", ""));
				document.executeScript("vincularSalvarOcorrenciaServicoProprietarios();");
			}
		}catch(Exception e){
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
			e.printStackTrace();
			document.alert(UtilI18N.internacionaliza(request, "MSE02"));
		}

	}

	public void adicionaTabelaLOOKUP_RESPONSAVEL_PROPRIETARIOS(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		try{
			document.executeScript("JANELA_AGUARDE_MENU.show();");
			WebUtil.validarSeUsuarioEstaNaSessao(request, document);
			GerenciamentoPortfolioProprietariosDTO gerenciamentoPortfolioProprietarioDto = (GerenciamentoPortfolioProprietariosDTO) document.getBean();
			if (gerenciamentoPortfolioProprietarioDto != null && gerenciamentoPortfolioProprietarioDto.getIdServico() != null
					&& gerenciamentoPortfolioProprietarioDto.getColAllLOOKUP_RESPONSAVEL_PROPRIETARIOS() != null) {
				Integer idServico = gerenciamentoPortfolioProprietarioDto.getIdServico();
				String listaProprietarios = gerenciamentoPortfolioProprietarioDto.getColAllLOOKUP_RESPONSAVEL_PROPRIETARIOS();
				if(permissao.isGravar()){
					this.vincularEmpregadoProprietarios(listaProprietarios, idServico, document, request, response);
				}else{
					document.executeScript("notificacaoErro('citcorpore.comum.naoFoiPossivelVincular','citcorpore.comum.usuarioSemPermissao')");
					document.executeScript("JANELA_AGUARDE_MENU.hide();");
				}
			}
		}catch(Exception e){
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
			e.printStackTrace();
			document.alert(UtilI18N.internacionaliza(request, "MSE02"));
		}
		document.executeScript("Modal.close('modal-portfolio-proprietarios-vincular-usuario');");
	}

	public void adicionaTabelaLOOKUP_GRUPO_PROPRIETARIOS(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) {
		try{
			document.executeScript("JANELA_AGUARDE_MENU.show();");
			WebUtil.validarSeUsuarioEstaNaSessao(request, document);
			GerenciamentoPortfolioProprietariosDTO gerenciamentoPortfolioProprietarioDto = (GerenciamentoPortfolioProprietariosDTO) document.getBean();
			if (gerenciamentoPortfolioProprietarioDto != null && gerenciamentoPortfolioProprietarioDto.getIdServico() != null
					&& gerenciamentoPortfolioProprietarioDto.getColAllLOOKUP_GRUPO_PROPRIETARIOS() != null) {
				Integer idServico = gerenciamentoPortfolioProprietarioDto.getIdServico();
				String listaProprietarios = gerenciamentoPortfolioProprietarioDto.getColAllLOOKUP_GRUPO_PROPRIETARIOS();
				if(permissao.isGravar()){
					this.vincularGruposProprietarios(listaProprietarios, idServico, document, request, response);
				}else{
					document.executeScript("notificacaoErro('citcorpore.comum.naoFoiPossivelVincular','citcorpore.comum.usuarioSemPermissao')");
					document.executeScript("JANELA_AGUARDE_MENU.hide();");
				}
			}
		}catch(Exception e){
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
			e.printStackTrace();
			document.alert(UtilI18N.internacionaliza(request, "MSE02"));
		}
		document.executeScript("Modal.close('modal-portfolio-proprietarios-vincular-grupo');");
	}

	public void desvincularProprietario(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) {
		try{
			GerenciamentoPortfolioProprietariosDTO dto = (GerenciamentoPortfolioProprietariosDTO) document.getBean();
			if (dto != null	&& dto.getIdVinculoServicoProprietario() != null) {
				this.salvarVinculoServicoProprietarioDesvinculado(document);
				this.getServicoProprietariosService().deletaVinculo(dto.getIdVinculoServicoProprietario());
				document.executeScript("notificacaoI18N('gerenciaportfolio.proprietarioVinculadoDeletado')");

				this.salvarOcorrenciaServicoProprietarios(document, request, response);
				this.restauraProprietarios(dto, document, request);
				document.executeScript("JANELA_AGUARDE_MENU.hide();");
			}

		}catch(Exception e){
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
			e.printStackTrace();
			document.alert(UtilI18N.internacionaliza(request, "MSE02"));
		}
	}

	private VinculoServicoProprietariosService getServicoProprietariosService() throws Exception {
		if (proprietariosService == null) {
			proprietariosService = (VinculoServicoProprietariosService) ServiceLocator.getInstance().getService(VinculoServicoProprietariosService.class, null);
		}
		return proprietariosService;
	}

	private EmpregadoService getEmpregadoService() throws Exception {
		if (empregadoService == null) {
			empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, null);
		}
		return empregadoService;
	}

	private GrupoService getGrupoService() throws Exception {
		if (grupoService == null) {
			grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
		}
		return grupoService;
	}

	@Override
	public Class<GerenciamentoPortfolioProprietariosDTO> getBeanClass() {
		return GerenciamentoPortfolioProprietariosDTO.class;
	}

	/**
	 * @author deborah.ferreira
	 * @since 29.01.2016
	 */
	public void salvarOcorrenciaServicoProprietarios(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioProprietariosDTO gerenciamentoPortfolioProprietariosDTO = (GerenciamentoPortfolioProprietariosDTO) document.getBean();
		GerenciamentoPortfolioOcorrenciasServico gerenciamentoPortfolioOcorrenciasServico = new GerenciamentoPortfolioOcorrenciasServico();

		gerenciamentoPortfolioOcorrenciasServico.salvaOcorrenciaServicoProprietarios(gerenciamentoPortfolioProprietariosDTO.getIdServico(), gerenciamentoPortfolioProprietariosDTO, document, request);
	}

	/**
	 * @author deborah.ferreira
	 * @since 01.02.2016
	 */
	public void salvarVinculoServicoProprietarioDesvinculado(DocumentHTML document) throws Exception {
		GerenciamentoPortfolioProprietariosDTO gerenciamentoPortfolioProprietariosDTO = (GerenciamentoPortfolioProprietariosDTO) document.getBean();
		VinculoServicoProprietariosDTO vinculoServicoProprietariosDTO = new VinculoServicoProprietariosDTO();
		vinculoServicoProprietariosDTO.setIdVinculoServicoProprietarios(gerenciamentoPortfolioProprietariosDTO.getIdVinculoServicoProprietario());
		vinculoServicoProprietariosDTO = this.getServicoProprietariosService().restore(vinculoServicoProprietariosDTO);
		gerenciamentoPortfolioProprietariosDTO.setVinculoServicoProprietariosDesvinculado(vinculoServicoProprietariosDTO);
		gerenciamentoPortfolioProprietariosDTO.setAcaoProprietariosOcorrenciaServico(AuditoriaAcoes.DESVINCULADO.getIdentificador());
	}
}
