package br.com.centralit.citcorpore.ajaxForms;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioServicoContratoANSDTO;
import br.com.centralit.citcorpore.bean.ServicoContratoANSDTO;
import br.com.centralit.citcorpore.negocio.ServicoContratoANSService;
import br.com.centralit.citcorpore.util.Enumerados.PagesPortfolio;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.Enumerados.TipoDate;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.core.PageRequest;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Reflexao;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;

/**
 * @author douglas.japiassu
 * @since 02.04.2016
 */
public class GerenciamentoPortfolioServicoContratoANS extends AjaxFormAction {

	private ServicoContratoANSService servicoContratoANSService;
	private static Permissoes permissao;

	/**
	 * @author douglas.japiassu
	 * @since 02.04.2016
	 */
	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		permissao = new Permissoes(document, request, PagesPortfolio.CONTRATOS_SERVICO_CONTRATO_ANS.getCaminho());
		carregarTabelaServicoContratoANS(document, request, response);
	}

	/**
	 * @author douglas.japiassu
	 * @since 02.04.2016
	 */
	public void carregarTabelaServicoContratoANS(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioServicoContratoANSDTO servicoContratoANSDTO = (GerenciamentoPortfolioServicoContratoANSDTO) document.getBean();

		montaTabelaServicoContratoANS(document, request, servicoContratoANSDTO);
	}

	/**
	 * @author douglas.japiassu
	 * @since 02.04.2016
	 */
	public void adicionarAcordoNivelServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (permissao.isGravar()) {
			GerenciamentoPortfolioServicoContratoANSDTO bean = (GerenciamentoPortfolioServicoContratoANSDTO) document.getBean();
			ServicoContratoANSDTO servicoContratoANSDTO = new ServicoContratoANSDTO();

			Reflexao.copyPropertyValues(bean, servicoContratoANSDTO);

			Boolean existeAtivo = getServicoContratoANSService().existeAnsAtivoByServicoContrato(bean.getIdServicoContrato());
			if (existeAtivo) {
				document.executeScript("notificacaoErro('gerenciaPortfolio.contrato.jaExisteAcordoDisponibilidadeAtivo')");
				return;
			}

			bean.setDataInicio(UtilDatas.getDataAtual());
			getServicoContratoANSService().create(bean);

			montaTabelaServicoContratoANS(document, request, bean);
		} else {
			document.executeScript("notificacaoErro('citcorpore.comum.permissaoFuncionalidade');");
		}
	}

	/**
	 * @author douglas.japiassu
	 * @since 02.04.2016
	 */
	public void desativarAcordoNivelServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (permissao.isGravar()) {
			GerenciamentoPortfolioServicoContratoANSDTO bean = (GerenciamentoPortfolioServicoContratoANSDTO) document.getBean();
			ServicoContratoANSDTO servicoContratoANSDTO = new ServicoContratoANSDTO();

			Reflexao.copyPropertyValues(bean, servicoContratoANSDTO);

			servicoContratoANSDTO.setDataFim(UtilDatas.getDataAtual());
			getServicoContratoANSService().updateNotNull(servicoContratoANSDTO);

			montaTabelaServicoContratoANS(document, request, bean);
		} else {
			document.executeScript("notificacaoErro('citcorpore.comum.permissaoFuncionalidade');");
		}
	}

	/**
	 * @author douglas.japiassu
	 * @since 02.04.2016
	 */
	private void montaTabelaServicoContratoANS(final DocumentHTML document, final HttpServletRequest request, GerenciamentoPortfolioServicoContratoANSDTO servicoContratoANSDTO)
			throws ServiceException, Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);

		HTMLElement divListaServicoContratoANS = document.getElementById("divDinamicoListaServicoContratoANS");

		String filtro = servicoContratoANSDTO.getFiltro();
		if (filtro == null) {
			filtro = "";
		}

		Integer itensPorPagina = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANT_RETORNO_PESQUISA, "10"));

		Integer paginaSelecionada = servicoContratoANSDTO.getPaginaSelecionada();
		if (paginaSelecionada == null || paginaSelecionada == 0) {
			paginaSelecionada = 1;
		}

		Pageable pageable = new PageRequest(paginaSelecionada - 1, itensPorPagina);

		Collection<GerenciamentoPortfolioServicoContratoANSDTO> listServicoContratoANS = getServicoContratoANSService().findByIdServicoContrato(servicoContratoANSDTO.getIdServicoContrato(), filtro, pageable, false).getContent();

		if (listServicoContratoANS != null && !listServicoContratoANS.isEmpty()) {
			divListaServicoContratoANS.setInnerHTML(geraTabelaServicoContratoANS(document, request, listServicoContratoANS));

			Integer totalPaginas = getServicoContratoANSService().findByIdServicoContrato(servicoContratoANSDTO.getIdServicoContrato(), filtro, pageable, true).getTotalPages();

			HTMLElement paginacao = document.getElementById("paginacaoServicoContratoANS");
			String funcaoJsPaginar = "paginarServicoContratoANS";
			paginacao.setInnerHTML(UtilHTML.paginacaoHtml(request, funcaoJsPaginar, totalPaginas, paginaSelecionada));
		} else {
			final StringBuilder htmlDivSemRegistros = new StringBuilder();
			htmlDivSemRegistros.append("<h4>" + UtilI18N.internacionaliza(request, "gerenciaPortfolio.contrato.nenhumAcordoDisponibilidadeVinculado") + "</h4>");
			divListaServicoContratoANS.setInnerHTML(htmlDivSemRegistros.toString());
		}

		document.executeScript("depoisCarregarListaServicoContratoANS();");
	}

	/**
	 * @author douglas.japiassu
	 * @since 02.04.2016
	 */
	public String geraTabelaServicoContratoANS(final DocumentHTML document, final HttpServletRequest request, Collection<GerenciamentoPortfolioServicoContratoANSDTO> listServicoContratoANS) {
		StringBuilder sb = new StringBuilder();

		sb.append(geraCabecalhoTabela(request));
		for (GerenciamentoPortfolioServicoContratoANSDTO servicoContratoANS : listServicoContratoANS) {
			sb.append(geraDadosTabela(document, request, servicoContratoANS));
		}
		sb.append(geraFinalTabela());

		return sb.toString();
	}

	/**
	 * @author douglas.japiassu
	 * @since 02.04.2016
	 */
	private String geraCabecalhoTabela(final HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		sb.append("<div class='row-fluid'> ");
		sb.append("	<div class=\"table-responsive tabela\">");
		sb.append("		<table class=\"table table-bordered table-striped table-condensed table-vertical-center checkboxs js-table-sortable ui-sortable\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th class=\"center\" style=\"width: 1%;\">" + UtilI18N.internacionaliza(request, "lookup.id") + "</th> ");
		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.tituloSLA") + "</th> ");
		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "sla.indicedisponibilidade") + "</th> ");
		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.dataInicio") + "</th> ");
		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.dataFim") + "</th> ");
		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.acao") + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody> ");

		return sb.toString();
	}

	/**
	 * @author douglas.japiassu
	 * @since 02.04.2016
	 */
	private String geraDadosTabela(final DocumentHTML document, final HttpServletRequest request, GerenciamentoPortfolioServicoContratoANSDTO servicoContratoANS) {
		StringBuilder sb = new StringBuilder();
		String onClick = "desativarAcordoNivelServico(".concat(servicoContratoANS.getIdServicoContratoANS().toString()).concat(");");
		String onMouseOver = "onmouseover=\"abreTooltip(this, '" + UtilI18N.internacionaliza(request, "citcorpore.comum.desativar") + "')\" onmouseout=\"fechaTooltip()\"";

		sb.append("		<tr>");
		sb.append("			<td class=\"center\">" + servicoContratoANS.getIdServicoContratoANS() + "</td> ");
		sb.append("			<td>" + UtilHTML.encodeHTML(servicoContratoANS.getTituloSla()) + "</td> ");
		if(servicoContratoANS.getDisponibilidade() == null)
			sb.append("			<td class=\"right\" style=\"width: 160px;\"> &nbsp; </td> ");
		else
			sb.append("			<td class=\"right\" style=\"width: 160px;\">"+ servicoContratoANS.getDisponibilidade() +"</td> ");
		sb.append("			<td style=\"width: 90px;\">" + UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, servicoContratoANS.getDataInicio()) + "</td> ");
		sb.append("			<td style=\"width: 90px;\">" + UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, servicoContratoANS.getDataFim()) + "</td> ");
		sb.append("			<td class=\"center\" style=\"width: 30px;\"> ");
		if (permissao.isGravar() && servicoContratoANS.getDataFim() == null) {
			sb.append("				<a onclick=\"" + onClick + "\" " + onMouseOver + "  class=\"btn-action glyphicons remove_2 btn-default\"><i></i></a> ");
		}
		sb.append("			</td> ");
		sb.append("		</tr> ");

		return sb.toString();
	}


	/**
	 * @author douglas.japiassu
	 * @since 02.04.2016
	 */
	private static String geraFinalTabela() {
		StringBuilder sb = new StringBuilder();
		sb.append("			</tbody> ");
		sb.append("		</table>");
		sb.append("	</div>");
		sb.append("</div>");
		sb.append("<div id=\"paginacaoServicoContratoANS\" class=\"divPaginacao\"></div>");
		sb.append("</div>");

		return sb.toString();
	}

	private ServicoContratoANSService getServicoContratoANSService() throws ServiceException {
		if (servicoContratoANSService == null) {
			servicoContratoANSService = (ServicoContratoANSService) ServiceLocator.getInstance().getService(ServicoContratoANSService.class, null);
		}

		return servicoContratoANSService;
	}

	@Override
	public Class<GerenciamentoPortfolioServicoContratoANSDTO> getBeanClass() {
		return GerenciamentoPortfolioServicoContratoANSDTO.class;
	}
}
