package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.bpm.dto.FluxoDTO;
import br.com.centralit.bpm.servico.FluxoService;
import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.AcordoNivelServicoDTO;
import br.com.centralit.citcorpore.bean.AcordoServicoContratoDTO;
import br.com.centralit.citcorpore.bean.CalendarioDTO;
import br.com.centralit.citcorpore.bean.CondicaoOperacaoDTO;
import br.com.centralit.citcorpore.bean.FaseServicoDTO;
import br.com.centralit.citcorpore.bean.FluxoServicoDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioContratosApoioDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioContratosDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioVinculoServicoContratoDTO;
import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.ModeloEmailDTO;
import br.com.centralit.citcorpore.bean.ServicoContratoDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.negocio.AcordoNivelServicoService;
import br.com.centralit.citcorpore.negocio.AcordoServicoContratoService;
import br.com.centralit.citcorpore.negocio.CalendarioService;
import br.com.centralit.citcorpore.negocio.CondicaoOperacaoService;
import br.com.centralit.citcorpore.negocio.FaseServicoService;
import br.com.centralit.citcorpore.negocio.FluxoServicoService;
import br.com.centralit.citcorpore.negocio.GrupoService;
import br.com.centralit.citcorpore.negocio.ModeloEmailService;
import br.com.centralit.citcorpore.negocio.ServicoAutoRelacionamentoService;
import br.com.centralit.citcorpore.negocio.ServicoContratoService;
import br.com.centralit.citcorpore.negocio.ServicoService;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.FaseServicoFluxo;
import br.com.centralit.citcorpore.util.Enumerados.PagesPortfolio;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.Enumerados.SimNao;
import br.com.centralit.citcorpore.util.Enumerados.TipoServico;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.Util;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.core.PageRequest;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Reflexao;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilStrings;

public class GerenciamentoPortfolioVinculoServicoContrato extends AjaxFormAction {

	private ServicoService servicoService;
	private ServicoAutoRelacionamentoService servicoAutoRelacionamentoService;
	private ServicoContratoService servicoContratoService;
	private CondicaoOperacaoService condicaoOperacaoService;
	private ModeloEmailService modeloEmailService;
	private GrupoService grupoService;
	private CalendarioService calendarioService;
	private FaseServicoService faseServicoService;
	private FluxoService fluxoService;
	private FluxoServicoService fluxoServicoService;
	private AcordoServicoContratoService acordoServicoContratoService;
	private AcordoNivelServicoService acordoNivelServicoService;
	private static Permissoes permissao;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		carregaCombosVinculoServicoContrato(document, request, response);
	}

	private void setPermissoesPortfolioVinculoServicoContrato(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) {
		GerenciamentoPortfolioVinculoServicoContratoDTO beanDto = (GerenciamentoPortfolioVinculoServicoContratoDTO) document.getBean();
		String caminhoPermissao = "";

		if (TipoServico.SERVICO_REQUISICAO.getIdentificador().equalsIgnoreCase(beanDto.getTipoServico())) {
			caminhoPermissao = PagesPortfolio.CONTRATOS_REQUISICAO_SERVICOS.getCaminho();
		} else if (TipoServico.SERVICO_INCIDENTE.getIdentificador().equalsIgnoreCase(beanDto.getTipoServico())) {
			caminhoPermissao = PagesPortfolio.CONTRATOS_INCIDENTES.getCaminho();
		} else if (TipoServico.SERVICO_PROCEDIMENTO.getIdentificador().equalsIgnoreCase(beanDto.getTipoServico())) {
			caminhoPermissao = PagesPortfolio.CONTRATOS_PROCEDIMENTO.getCaminho();
		}

		permissao = new Permissoes(document, request, caminhoPermissao);
	}

	/**
	 * Carrega todas as combos da tela, logo quando  chamado o load.
	 *
	 * @author rodrigo.dorighello
	 * @since 01.10.2015
	 */
	private void carregaCombosVinculoServicoContrato(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		carregaComboCondicaoOperacao(document, request, response);
		carregaComboModeloEmailCriacao(document, request, response);
		carregaComboModeloEmailFinalizacao(document, request, response);
		carregaComboModeloEmailAcoes(document, request, response);
		carregaComboGrupoNivel1(document, request, response);
		carregaComboGrupoExecutor(document, request, response);
		carregaComboGrupoAprovador(document, request, response);
		carregaComboCalendario(document, request, response);
		carregaComboTipoFluxo(document, request, response);
		carregaComboFase(document, request, response);
	}

	/**
	 * Inicia a combo passado por parmetro com a opo 'selecione'
	 *
	 * @author rodrigo.dorighello
	 * @since 01.10.2015
	 */
	private void iniciaCombo(DocumentHTML document, HttpServletRequest request, HTMLSelect combo) throws Exception {
		combo.removeAllOptions();
		combo.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
	}

	private void carregaComboCondicaoOperacao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("idCondicaoOperacaoVinculo");
		iniciaCombo(document, request, combo);

		Collection<CondicaoOperacaoDTO> listCondicaoOperacaoDto = this.getCondicaoOperacaoService().list();

		if (listCondicaoOperacaoDto != null) {
			for (CondicaoOperacaoDTO condicaoOperacaoDto : listCondicaoOperacaoDto) {
				if (condicaoOperacaoDto.getDataFim() == null) {
					combo.addOption(String.valueOf(condicaoOperacaoDto.getIdCondicaoOperacao()), condicaoOperacaoDto.getNomeCondicaoOperacao());
				}
			}
		}
	}

	@SuppressWarnings("unchecked")
	private void carregaComboModeloEmailCriacao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("idModeloEmailCriacaoVinculo");
		iniciaCombo(document, request, combo);

		Collection<ModeloEmailDTO> listModeloEmailDto = this.getModeloEmailService().getAtivos();

		if (listModeloEmailDto != null) {
			for (ModeloEmailDTO modeloEmailDTO : listModeloEmailDto) {
				combo.addOption(String.valueOf(modeloEmailDTO.getIdModeloEmail()), modeloEmailDTO.getTitulo());
			}
		}
	}

	@SuppressWarnings("unchecked")
	private void carregaComboModeloEmailFinalizacao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("idModeloEmailFinalizacaoVinculo");
		iniciaCombo(document, request, combo);

		Collection<ModeloEmailDTO> listModeloEmailDto = this.getModeloEmailService().getAtivos();

		if (listModeloEmailDto != null) {
			for (ModeloEmailDTO modeloEmailDTO : listModeloEmailDto) {
				combo.addOption(String.valueOf(modeloEmailDTO.getIdModeloEmail()), modeloEmailDTO.getTitulo());
			}
		}
	}

	@SuppressWarnings("unchecked")
	private void carregaComboModeloEmailAcoes(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("idModeloEmailAcoesVinculo");
		iniciaCombo(document, request, combo);

		Collection<ModeloEmailDTO> listModeloEmailDto = this.getModeloEmailService().getAtivos();

		if (listModeloEmailDto != null) {
			for (ModeloEmailDTO modeloEmailDTO : listModeloEmailDto) {
				combo.addOption(String.valueOf(modeloEmailDTO.getIdModeloEmail()), modeloEmailDTO.getTitulo());
			}
		}
	}

	private void carregaComboGrupoNivel1(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("idGrupoNivel1Vinculo");
		iniciaCombo(document, request, combo);

		Collection<GrupoDTO> listGrupoDto = this.getGrupoService().listaGruposAtivos();

		if (listGrupoDto != null) {
			for (GrupoDTO grupoDTO : listGrupoDto) {
				combo.addOption(String.valueOf(grupoDTO.getIdGrupo()), grupoDTO.getNome());
			}
		}
	}

	private void carregaComboGrupoExecutor(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("idGrupoExecutorVinculo");
		iniciaCombo(document, request, combo);

		Collection<GrupoDTO> listGrupoDto = this.getGrupoService().listaGruposAtivos();

		if (listGrupoDto != null) {
			for (GrupoDTO grupoDTO : listGrupoDto) {
				combo.addOption(String.valueOf(grupoDTO.getIdGrupo()), grupoDTO.getNome());
			}
		}
	}

	private void carregaComboGrupoAprovador(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("idGrupoAprovadorVinculo");
		iniciaCombo(document, request, combo);

		Collection<GrupoDTO> listGrupoDto = this.getGrupoService().listaGruposAtivos();

		if (listGrupoDto != null) {
			for (GrupoDTO grupoDTO : listGrupoDto) {
				combo.addOption(String.valueOf(grupoDTO.getIdGrupo()), grupoDTO.getNome());
			}
		}
	}

	private void carregaComboCalendario(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("idCalendarioVinculo");
		iniciaCombo(document, request, combo);

		Collection<CalendarioDTO> listCalendarioDto = this.getCalendarioService().list();

		if (listCalendarioDto != null) {
			for (CalendarioDTO calendarioDTO : listCalendarioDto) {
				combo.addOption(String.valueOf(calendarioDTO.getIdCalendario()), calendarioDTO.getDescricao());
			}
		}
	}

	private void carregaComboTipoFluxo(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("idTipoFluxoVinculo");
		iniciaCombo(document, request, combo);

		Collection<FluxoDTO> listFluxoDto = this.getFluxoService().list();

		if (listFluxoDto != null) {
			for (FluxoDTO fluxoDto : listFluxoDto) {
				combo.addOption(String.valueOf(fluxoDto.getIdTipoFluxo()), fluxoDto.getDescricao());
			}
		}
	}

	private void carregaComboFase(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("idFaseVinculo");
		iniciaCombo(document, request, combo);

		Collection<FaseServicoDTO> listFaseServicoDto = this.getFaseServicoService().list();

		if (listFaseServicoDto != null) {
			String nomeFase;
			Enumerados.FaseServicoFluxo faseServico;
			for (FaseServicoDTO faseServicoDto : listFaseServicoDto) {
				faseServico = Enumerados.FaseServicoFluxo.fromIdentificador(faseServicoDto.getNomeFase());
				nomeFase = faseServico != null ? UtilI18N.internacionaliza(request, faseServico.getChave()) : faseServicoDto.getNomeFase();
				combo.addOption(String.valueOf(faseServicoDto.getIdFase()), nomeFase);
			}
		}
	}

	public void avancarContrato(GerenciamentoPortfolioContratosDTO gerenciamentoPortfolioContratosDto, DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		carregaCombosVinculoServicoContrato(document, request, response);

		GerenciamentoPortfolioVinculoServicoContratoDTO vinculoServicoContratoDto = new GerenciamentoPortfolioVinculoServicoContratoDTO();
		if (gerenciamentoPortfolioContratosDto != null && gerenciamentoPortfolioContratosDto.getIdContrato() != null) {
			vinculoServicoContratoDto.setIdPortfolioServico(gerenciamentoPortfolioContratosDto.getIdPortfolioServicoContrato());
			vinculoServicoContratoDto.setIdServicoRelacionado(gerenciamentoPortfolioContratosDto.getIdServicoNegocioContrato());
			vinculoServicoContratoDto.setIdContrato(gerenciamentoPortfolioContratosDto.getIdContrato());

			HTMLForm form = document.getForm("formVinculoServicoContrato");
			form.setValues(vinculoServicoContratoDto);
		}
	}

	public void avancarContratoApoio(GerenciamentoPortfolioContratosApoioDTO gerenciamentoPortfolioContratosDto, DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		carregaCombosVinculoServicoContrato(document, request, response);

		GerenciamentoPortfolioVinculoServicoContratoDTO vinculoServicoContratoDto = new GerenciamentoPortfolioVinculoServicoContratoDTO();
		if (gerenciamentoPortfolioContratosDto != null && gerenciamentoPortfolioContratosDto.getIdContrato() != null) {
			vinculoServicoContratoDto.setIdPortfolioServico(gerenciamentoPortfolioContratosDto.getIdPortfolioServicoContrato());
			vinculoServicoContratoDto.setIdServicoRelacionado(gerenciamentoPortfolioContratosDto.getIdServicoApoioContrato());
			vinculoServicoContratoDto.setIdContrato(gerenciamentoPortfolioContratosDto.getIdContrato());

			HTMLForm form = document.getForm("formVinculoServicoContrato");
			form.setValues(vinculoServicoContratoDto);
		}
	}

	public void restoreContratoCarregaVinculoServicoContratoApoio(GerenciamentoPortfolioContratosApoioDTO gerenciamentoPortfolioContratosDto, DocumentHTML document, HttpServletRequest request) throws Exception {

		GerenciamentoPortfolioVinculoServicoContratoDTO vinculoServicoContratoDto = new GerenciamentoPortfolioVinculoServicoContratoDTO();
		if (gerenciamentoPortfolioContratosDto != null && gerenciamentoPortfolioContratosDto.getIdContrato() != null) {
			vinculoServicoContratoDto.setIdPortfolioServico(gerenciamentoPortfolioContratosDto.getIdPortfolioServicoContrato());
			vinculoServicoContratoDto.setIdServicoRelacionado(gerenciamentoPortfolioContratosDto.getIdServicoApoioContrato());
			vinculoServicoContratoDto.setIdContrato(gerenciamentoPortfolioContratosDto.getIdContrato());

			vinculoServicoContratoDto.setPaginaSelecionadaRequisicao(1);
			vinculoServicoContratoDto.setFiltroServicoRequisicao("");

			try {
				montaHTMLServicosRequisicaoContrato(vinculoServicoContratoDto, document, request);
			} catch (Exception e) {
				e.printStackTrace();
			}

			vinculoServicoContratoDto.setPaginaSelecionadaIncidente(1);
			vinculoServicoContratoDto.setFiltroServicoIncidente("");

			try {
				montaHTMLServicosIncidenteContrato(vinculoServicoContratoDto, document, request);
			} catch (Exception e) {
				e.printStackTrace();
			}

		}

		HTMLForm form = document.getForm("formVinculoServicoContrato");
		form.setValues(vinculoServicoContratoDto);
	}

	@SuppressWarnings("unchecked")
	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		setPermissoesPortfolioVinculoServicoContrato(document, request, response);
		
		GerenciamentoPortfolioVinculoServicoContratoDTO gerenciamentoPortfolioVinculoServicoContratoDTO = (GerenciamentoPortfolioVinculoServicoContratoDTO) document.getBean();
		
		List<Integer> listIdServicosVincular = Util.listStrToListInteger(gerenciamentoPortfolioVinculoServicoContratoDTO.getListaIdsStrServicosContratoVinculados());
		String tipoServico = gerenciamentoPortfolioVinculoServicoContratoDTO.getTipoServico();
		
		if (gerenciamentoPortfolioVinculoServicoContratoDTO != null) {
			if (permissao.isGravar()) {
				Integer idTempoAtendimento = gerenciamentoPortfolioVinculoServicoContratoDTO.getIdServicoContratoTempoAtendimento();
				ServicoContratoDTO servicoContratoDto = new ServicoContratoDTO();

				Reflexao.copyPropertyValues(gerenciamentoPortfolioVinculoServicoContratoDTO, servicoContratoDto);

				if (servicoContratoDto != null && servicoContratoDto.getIdContrato() != null) {

					if (!(SimNao.SIM.getValorStr().equalsIgnoreCase(gerenciamentoPortfolioVinculoServicoContratoDTO.getEditar())) && (listIdServicosVincular == null || listIdServicosVincular.isEmpty())) {
						String msg = "servicoContrato.selecioneServicos";
						
						if(TipoServico.SERVICO_REQUISICAO.getIdentificador().equalsIgnoreCase(tipoServico)) {
							msg = "servicoContrato.selecioneRequisicao";
						} else if(TipoServico.SERVICO_INCIDENTE.getIdentificador().equalsIgnoreCase(tipoServico)) {
							msg = "servicoContrato.selecioneIncidente";
						} else if(TipoServico.SERVICO_PROCEDIMENTO.getIdentificador().equalsIgnoreCase(tipoServico)) {
							msg = "servicoContrato.selecioneProcedimento";
						}
						
						document.alert(UtilI18N.internacionaliza(request, msg));
						return;
					}

					ArrayList<FluxoServicoDTO> listaFluxos = (ArrayList<FluxoServicoDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(FluxoServicoDTO.class, "listaFluxosSerializados", request);
					servicoContratoDto.setListaFluxo(listaFluxos == null ? new ArrayList<FluxoServicoDTO>() : listaFluxos);

					try {
						for (Integer idServico : listIdServicosVincular) {
							servicoContratoDto.setIdServico(idServico);

							ServicoContratoDTO servicoContratoDtoTemp = this.getServicoContratoService().findByIdContratoAndIdServico(servicoContratoDto.getIdContrato(), idServico);

							if (servicoContratoDtoTemp == null) {
								servicoContratoDtoTemp = this.getServicoContratoService().create(servicoContratoDto);
							} else {
								if (servicoContratoDtoTemp.getIdServicoContrato() != null) {
									servicoContratoDto.setIdServicoContrato(servicoContratoDtoTemp.getIdServicoContrato());
									this.getServicoContratoService().update(servicoContratoDto);
								}
							}
							
							if (idTempoAtendimento != null && servicoContratoDtoTemp.getIdServicoContrato() != null) {
								this.getAcordoServicoContratoService().saveAcordoServicoContratoByIdAcordoNivelServico(servicoContratoDtoTemp.getIdServicoContrato(), idTempoAtendimento);
							}
						}

						document.executeScript("notificacaoI18N('MSG05');");
						document.executeScript("fecharPopupVincularServicoReqIncContrato();");

					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			} else {
				document.executeScript("notificacaoErro('citcorpore.comum.permissaoFuncionalidade');");
				document.executeScript("fecharPopupVincularServicoReqIncContrato();");
			}
		}
	}

	@SuppressWarnings("unchecked")
	public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if(!WebUtil.validarSeUsuarioEstaNaSessao(request, document)){return;}
		GerenciamentoPortfolioVinculoServicoContratoDTO vinculoServicoContratoDto = (GerenciamentoPortfolioVinculoServicoContratoDTO) document.getBean();

		if (vinculoServicoContratoDto != null && vinculoServicoContratoDto.getIdServicoSelecionado() != null && vinculoServicoContratoDto.getIdContrato() != null) {

			ServicoDTO servicoDto = new ServicoDTO();
			servicoDto.setIdServico(vinculoServicoContratoDto.getIdServicoSelecionado());
			servicoDto = getServicoService().restore(servicoDto);

			ServicoContratoDTO servicoContratoDto = this.getServicoContratoService().findByIdContratoAndIdServico(vinculoServicoContratoDto.getIdContrato(),
					vinculoServicoContratoDto.getIdServicoSelecionado());

			if (servicoContratoDto != null && servicoContratoDto.getIdServicoContrato() != null) {

				Reflexao.copyPropertyValues(servicoContratoDto, vinculoServicoContratoDto);

				if (vinculoServicoContratoDto != null) {

					if (servicoDto != null && servicoDto.getIdServico() != null) {

						ArrayList<ServicoDTO> listaServicos = new ArrayList<ServicoDTO>();

						if (servicoDto != null && servicoDto.getIdServico() != null) {
							listaServicos.add(servicoDto);
						}

						if (servicoDto.getNomeServico() != null) {
							vinculoServicoContratoDto.setNomeServico(servicoDto.getNomeServico());
						}
					}
					
					// AcordoServicoContratoDTO acordoServicoContratoDTO = this.getAcordoServicoContratoService().getAcordoServicoContratoByIdServicoContrato(servicoContratoDto.getIdServicoContrato(), "T");
					AcordoServicoContratoDTO acordoServicoContratoDTO = this.getAcordoServicoContratoService().getAcordoServicoContratoAtualByIdServicoContrato(servicoContratoDto.getIdServicoContrato());
					
					if (acordoServicoContratoDTO != null) {
						Integer idTempoAtendimento = acordoServicoContratoDTO.getIdAcordoNivelServico();
						AcordoNivelServicoDTO acordoNivelServicoDTO = new AcordoNivelServicoDTO();
						acordoNivelServicoDTO.setIdAcordoNivelServico(idTempoAtendimento);

						acordoNivelServicoDTO = this.getAcordoNivelServicoService().restore(acordoNivelServicoDTO);

						if (acordoNivelServicoDTO != null) {
							vinculoServicoContratoDto.setServicoContratoTempoAtendimento(acordoNivelServicoDTO.getTituloSLA() + " - " + acordoNivelServicoDTO.getDescricaoSLA());
						}
					}
					
					HTMLForm form = document.getForm("formVinculoServicoContrato");
					form.setValues(vinculoServicoContratoDto);

					if (servicoContratoDto.getExpandir() != null && servicoContratoDto.getExpandir().equalsIgnoreCase("S")) {
						document.executeScript("setCheckedExpandirS();");
					} else {
						document.executeScript("setCheckedExpandirN();");
					}
					
					if (servicoContratoDto.getReiniciaSla() != null && servicoContratoDto.getReiniciaSla().equalsIgnoreCase("S")) {
						document.executeScript("setCheckedReiniciaS();");
					} else {
						document.executeScript("setCheckedReiniciaN();");
					}

					ArrayList<FluxoServicoDTO> listaFluxos = new ArrayList<FluxoServicoDTO>();
					Collection<FluxoServicoDTO> grupoFluxo = this.getFluxoServicoService().findByIdServicoContrato(servicoContratoDto.getIdServicoContrato());

					if (grupoFluxo != null && !grupoFluxo.isEmpty()) {
						for (FluxoServicoDTO fluxoServicoDTO : grupoFluxo) {
							listaFluxos.add(fluxoServicoDTO);
						}
					}

					geraTabelaFluxoServico(listaFluxos, document, request);
					
					String listaTempFluxosSerializados = br.com.citframework.util.WebUtil.serializeObjects(listaFluxos, WebUtil.getLanguage(request));

					document.executeScript("setaListaFluxo('" + listaTempFluxosSerializados + "');");
				}
			}
		}
	}

	public void carregaTabelaServicosRequisicaoContrato(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		GerenciamentoPortfolioVinculoServicoContratoDTO vinculoServicoContratoDto = (GerenciamentoPortfolioVinculoServicoContratoDTO) document.getBean();
		setPermissoesPortfolioVinculoServicoContrato(document, request, response);

		try {
			montaHTMLServicosRequisicaoContrato(vinculoServicoContratoDto, document, request);
		} catch (Exception e) {
			e.printStackTrace();
		}

		document.executeScript("depoisCarregarServicosRequisicaoContrato();");
	}

	private void montaHTMLServicosRequisicaoContrato(GerenciamentoPortfolioVinculoServicoContratoDTO vinculoServicoContratoDto, DocumentHTML document, HttpServletRequest request)
			throws ServiceException, Exception {
		if(!WebUtil.validarSeUsuarioEstaNaSessao(request, document)){return;}

		HTMLElement divListaServicosRequisicao = document.getElementById("divDinamicoListaServicosRequisicaoContrato");

		String filtroServicoRequisicao = vinculoServicoContratoDto.getFiltroServicoRequisicao();
		if (filtroServicoRequisicao == null) {
			filtroServicoRequisicao = "";
		}

		Integer itensPorPagina = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANT_RETORNO_PESQUISA, "10"));

		Integer paginaSelecionadaRequisicao = vinculoServicoContratoDto.getPaginaSelecionadaRequisicao();
		if (paginaSelecionadaRequisicao == null || paginaSelecionadaRequisicao == 0) {
			paginaSelecionadaRequisicao = 1;
		}

		Pageable pageable = new PageRequest(paginaSelecionadaRequisicao - 1, itensPorPagina);

		Integer idPortfolio = vinculoServicoContratoDto.getIdPortfolioServico();
		Integer idServicoRelacionado = vinculoServicoContratoDto.getIdServicoRelacionado();
		Integer idContrato = vinculoServicoContratoDto.getIdContrato();
		String tipoServico = TipoServico.SERVICO_REQUISICAO.getIdentificador();

		Collection<ServicoDTO> listServicoRequisicao = getServicoService()
				.listServicosVinculadoAoContrato(tipoServico, idPortfolio, idServicoRelacionado, idContrato, filtroServicoRequisicao, pageable, false)
				.getContent();

		if (listServicoRequisicao != null && !listServicoRequisicao.isEmpty()) {
			divListaServicosRequisicao.setInnerHTML(geraHTMLReqIncContrato(request, idContrato, listServicoRequisicao, TipoServico.SERVICO_REQUISICAO.getIdentificador()));

			Integer totalPaginasRequisicao = getServicoService()
					.listServicosVinculadoAoContrato(tipoServico, idPortfolio, idServicoRelacionado, idContrato, filtroServicoRequisicao, pageable, true)
					.getTotalPages();

			HTMLElement paginacaoServicosRequisicao = document.getElementById("paginacaoServicosRequisicaoContrato");
			String funcaoJsPaginarRequisicao = "paginarServicosRequisicaoContrato";
			paginacaoServicosRequisicao.setInnerHTML(UtilHTML.paginacaoHtml(request, funcaoJsPaginarRequisicao, totalPaginasRequisicao, paginaSelecionadaRequisicao));
		} else {
			final StringBuilder htmlDivSemRegistros = new StringBuilder();
			htmlDivSemRegistros.append("<h4>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nenhumServicoRequisicaoRegistrado") + "</h4>");
			divListaServicosRequisicao.setInnerHTML(htmlDivSemRegistros.toString());
		}
	}

	public void carregaTabelaServicosIncidenteContrato(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		GerenciamentoPortfolioVinculoServicoContratoDTO vinculoServicoContratoDto = (GerenciamentoPortfolioVinculoServicoContratoDTO) document.getBean();
		setPermissoesPortfolioVinculoServicoContrato(document, request, response);
		try {
			montaHTMLServicosIncidenteContrato(vinculoServicoContratoDto, document, request);
		} catch (Exception e) {
			e.printStackTrace();
		}

		document.executeScript("depoisCarregarServicosIncidenteContrato();");
	}

	private void montaHTMLServicosIncidenteContrato(GerenciamentoPortfolioVinculoServicoContratoDTO vinculoServicoContratoDto, DocumentHTML document, HttpServletRequest request)
			throws ServiceException, Exception {
		if(!WebUtil.validarSeUsuarioEstaNaSessao(request, document)){return;}

		HTMLElement divListaServicosIncidente = document.getElementById("divDinamicoListaServicosIncidenteContrato");

		String filtroServicoIncidente = vinculoServicoContratoDto.getFiltroServicoIncidente();
		if (filtroServicoIncidente == null) {
			filtroServicoIncidente = "";
		}

		Integer itensPorPagina = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANT_RETORNO_PESQUISA, "10"));

		Integer paginaSelecionadaIncidente = vinculoServicoContratoDto.getPaginaSelecionadaIncidente();
		if (paginaSelecionadaIncidente == null || paginaSelecionadaIncidente == 0) {
			paginaSelecionadaIncidente = 1;
		}

		Pageable pageable = new PageRequest(paginaSelecionadaIncidente - 1, itensPorPagina);

		Integer idPortfolio = vinculoServicoContratoDto.getIdPortfolioServico();
		Integer idServicoRelacionado = vinculoServicoContratoDto.getIdServicoRelacionado();
		Integer idContrato = vinculoServicoContratoDto.getIdContrato();
		String tipoServico = TipoServico.SERVICO_INCIDENTE.getIdentificador();

		Collection<ServicoDTO> listServicoIncidente = getServicoService()
				.listServicosVinculadoAoContrato(tipoServico, idPortfolio, idServicoRelacionado, idContrato, filtroServicoIncidente, pageable, false).getContent();

		if (listServicoIncidente != null && !listServicoIncidente.isEmpty()) {
			divListaServicosIncidente.setInnerHTML(geraHTMLReqIncContrato(request, idContrato, listServicoIncidente, TipoServico.SERVICO_INCIDENTE.getIdentificador()));

			Integer totalPaginasIncidente = getServicoService()
					.listServicosVinculadoAoContrato(tipoServico, idPortfolio, idServicoRelacionado, idContrato, filtroServicoIncidente, pageable, true)
					.getTotalPages();

			HTMLElement paginacaoServicosIncidente = document.getElementById("paginacaoServicosIncidenteContrato");
			String funcaoJsPaginarIncidente = "paginarServicosIncidenteContrato";
			paginacaoServicosIncidente.setInnerHTML(UtilHTML.paginacaoHtml(request, funcaoJsPaginarIncidente, totalPaginasIncidente, paginaSelecionadaIncidente));
		} else {
			final StringBuilder htmlDivSemRegistros = new StringBuilder();
			htmlDivSemRegistros.append("<h4>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nenhumServicoIncidenteRegistrado") + "</h4>");
			divListaServicosIncidente.setInnerHTML(htmlDivSemRegistros.toString());
		}
	}

	public void carregaTabelaServicosProcedimentoContrato(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		GerenciamentoPortfolioVinculoServicoContratoDTO vinculoServicoContratoDto = (GerenciamentoPortfolioVinculoServicoContratoDTO) document.getBean();
		setPermissoesPortfolioVinculoServicoContrato(document, request, response);
		try {
			montaHTMLServicosProcedimentoContrato(vinculoServicoContratoDto, document, request);
		} catch (Exception e) {
			e.printStackTrace();
		}

		document.executeScript("depoisCarregarServicosProcedimentoContrato();");
	}

	private void montaHTMLServicosProcedimentoContrato(GerenciamentoPortfolioVinculoServicoContratoDTO vinculoServicoContratoDto, DocumentHTML document, HttpServletRequest request)
			throws ServiceException, Exception {
		if(!WebUtil.validarSeUsuarioEstaNaSessao(request, document)){return;}

		HTMLElement divListaServicosProcedimento = document.getElementById("divDinamicoListaServicoProcedimentoContrato");

		String filtroServicoProcedimento = vinculoServicoContratoDto.getFiltroServicoProcedimento();
		if (filtroServicoProcedimento == null) {
			filtroServicoProcedimento = "";
		}

		Integer itensPorPagina = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANT_RETORNO_PESQUISA, "10"));

		Integer paginaSelecionadaProcedimento = vinculoServicoContratoDto.getPaginaSelecionadaProcedimento();
		if (paginaSelecionadaProcedimento == null || paginaSelecionadaProcedimento == 0) {
			paginaSelecionadaProcedimento = 1;
		}

		Pageable pageable = new PageRequest(paginaSelecionadaProcedimento - 1, itensPorPagina);

		Integer idPortfolio = vinculoServicoContratoDto.getIdPortfolioServico();
		Integer idServicoRelacionado = vinculoServicoContratoDto.getIdServicoRelacionado();
		Integer idContrato = vinculoServicoContratoDto.getIdContrato();
		String tipoServico = TipoServico.SERVICO_PROCEDIMENTO.getIdentificador();

		Collection<ServicoDTO> listServicoProcedimento = getServicoService()
				.listServicosVinculadoAoContrato(tipoServico, idPortfolio, idServicoRelacionado, idContrato, filtroServicoProcedimento, pageable, false).getContent();

		if (listServicoProcedimento != null && !listServicoProcedimento.isEmpty()) {
			divListaServicosProcedimento.setInnerHTML(geraHTMLReqIncContrato(request, idContrato, listServicoProcedimento, TipoServico.SERVICO_PROCEDIMENTO.getIdentificador()));

			Integer totalPaginasProcedimento = getServicoService()
					.listServicosVinculadoAoContrato(tipoServico, idPortfolio, idServicoRelacionado, idContrato, filtroServicoProcedimento, pageable, true)
					.getTotalPages();

			HTMLElement paginacaoServicosProcedimento = document.getElementById("paginacaoServicosProcedimento");
			String funcaoJsPaginarProcedimento = "paginarServicosProcedimentoContrato";
			paginacaoServicosProcedimento.setInnerHTML(UtilHTML.paginacaoHtml(request, funcaoJsPaginarProcedimento, totalPaginasProcedimento, paginaSelecionadaProcedimento));
		} else {
			final StringBuilder htmlDivSemRegistros = new StringBuilder();
			htmlDivSemRegistros.append("<h4>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nenhumServicoProcedimentoRegistrado") + "</h4>");
			divListaServicosProcedimento.setInnerHTML(htmlDivSemRegistros.toString());
		}
	}

	public static String geraHTMLReqIncContrato(final HttpServletRequest request, Integer idContrato, Collection<ServicoDTO> listServicos, String tipoServico) {
		StringBuilder sb = new StringBuilder();

		sb.append(geraCabecalhoReqIncContrato(request, tipoServico));
		for (ServicoDTO servico : listServicos) {
			sb.append(geraDadosReqIncContrato(request, idContrato, tipoServico, servico));
		}
		sb.append(geraFinalReqIncContrato(tipoServico));

		return sb.toString();
	}

	private static String geraCabecalhoReqIncContrato(final HttpServletRequest request, String tipoServico) {
		StringBuilder sb = new StringBuilder();

		sb.append("<div class='row-fluid'> ");
		sb.append("	<div class=\"table-responsive tabela\">");
		sb.append("		<table class=\"table table-bordered table-striped table-condensed table-vertical-center checkboxs js-table-sortable ui-sortable\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.id") + "</th> ");

		if (Enumerados.TipoServico.SERVICO_REQUISICAO.getIdentificador().equalsIgnoreCase(tipoServico)) {
			sb.append("				<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nomeServicoRequisicao") + "</th> ");
		} else if (Enumerados.TipoServico.SERVICO_INCIDENTE.getIdentificador().equalsIgnoreCase(tipoServico)) {
			sb.append("				<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nomeServicoIncidente") + "</th> ");
		} else if(Enumerados.TipoServico.SERVICO_PROCEDIMENTO.getIdentificador().equalsIgnoreCase(tipoServico)){
			sb.append("				<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nomeServicoProcedimento") + "</th> ");
		}

		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.acoes") + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody> ");

		return sb.toString();
	}

	private static String geraDadosReqIncContrato(final HttpServletRequest request, Integer idContrato, String tipoServico, ServicoDTO servico) {
		StringBuilder sb = new StringBuilder();
		String onClickServico = "";
		String onClickEditarServico = "";
		String onClickDesvincularServico = "";

		if (Enumerados.TipoServico.SERVICO_REQUISICAO.getIdentificador().equalsIgnoreCase(tipoServico)) {
			onClickServico = "avancarServicoRequisicaoContrato";
			onClickEditarServico = "editarServicoRequisicaoContrato";
			onClickDesvincularServico = "desvincularServicoReqIncContrato";
		} else if (Enumerados.TipoServico.SERVICO_INCIDENTE.getIdentificador().equalsIgnoreCase(tipoServico)) {
			onClickServico = "avancarServicoIncidenteContrato";
			onClickEditarServico = "editarServicoIncidenteContrato";
			onClickDesvincularServico = "desvincularServicoReqIncContrato";
		} else if (Enumerados.TipoServico.SERVICO_PROCEDIMENTO.getIdentificador().equalsIgnoreCase(tipoServico)) {
			onClickServico = "avancarServicoProcedimentoContrato";
			onClickEditarServico = "editarServicoProcedimentoContrato";
			onClickDesvincularServico = "desvincularServicoReqIncContrato";
		}

		sb.append("		<tr>");
		sb.append("			<td class=\"center\">" + servico.getIdServico() + "</td> ");
		sb.append("			<td>" + UtilHTML.encodeHTML(servico.getNomeServico()) + "</td> ");
		sb.append("			<td class=\"center\" style=\"width: 90px;\"> ");
		if (onClickServico.equalsIgnoreCase("avancarServicoRequisicaoContrato")) {
			sb.append("				<a onclick=\"" + onClickServico + "(this, " + idContrato + ", " + servico.getIdServico() + ", '" + servico.getNomeServico().replaceAll("[^a-zA-Z ]", " ")
					+ "');document.formVinculoServicoContrato.editar.value='S'\" class=\"btn-action glyphicons right_arrow btn-default\"><i></i></a> ");
		} else {
			sb.append("				<a onclick=\"" + onClickServico + "(this, " + idContrato + ", " + servico.getIdServico() + ", '" + servico.getNomeServico().replaceAll("[^a-zA-Z ]", " ")
					+ "');\" class=\"btn-action glyphicons right_arrow btn-default\"><i></i></a> ");
		}
		if(permissao.isGravar()){
			sb.append("				<a onclick=\"" + onClickEditarServico + "(this, " + idContrato + ", " + servico.getIdServico()
				+ ");\" class=\"btn-action glyphicons pencil btn-success\"><i></i></a> ");
		}
		if (permissao.isGravar()) {
			sb.append("				<a onclick=\"" + onClickDesvincularServico + "(this, " + idContrato + ", " + servico.getIdServico() + ", '" + tipoServico
				+ "');\" class=\"btn-action glyphicons remove_2 btn-default\"><i></i></a> ");
		}
		sb.append("			</td> ");
		sb.append("		</tr> ");

		return sb.toString();
	}

	private static String geraFinalReqIncContrato(String tipoServico) {
		StringBuilder sb = new StringBuilder();
		sb.append("			</tbody> ");
		sb.append("		</table>");
		sb.append("	</div>");
		sb.append("</div>");
		sb.append("<div class='row-fluid'> ");

		if (Enumerados.TipoServico.SERVICO_REQUISICAO.getIdentificador().equalsIgnoreCase(tipoServico)) {
			sb.append("	<div id=\"paginacaoServicosRequisicaoContrato\" class=\"divPaginacao\"></div>");
		} else if (Enumerados.TipoServico.SERVICO_INCIDENTE.getIdentificador().equalsIgnoreCase(tipoServico)) {
			sb.append("	<div id=\"paginacaoServicosIncidenteContrato\" class=\"divPaginacao\"></div>");
		} else if (Enumerados.TipoServico.SERVICO_PROCEDIMENTO.getIdentificador().equalsIgnoreCase(tipoServico)) {
			sb.append("	<div id=\"paginacaoServicosProcedimentoContrato\" class=\"divPaginacao\"></div>");
		}

		sb.append("</div>");

		return sb.toString();
	}

	public void desvincularServicoReqIncContrato(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		setPermissoesPortfolioVinculoServicoContrato(document, request, response);

		GerenciamentoPortfolioVinculoServicoContratoDTO vinculoServicoContratoDto = (GerenciamentoPortfolioVinculoServicoContratoDTO) document.getBean();

		boolean seDesvinculado = false;

		try {
			if (vinculoServicoContratoDto != null && vinculoServicoContratoDto.getIdServicoSelecionado() != null && vinculoServicoContratoDto.getIdContrato() != null) {
				if (permissao.isGravar()) {
					Integer idServico = vinculoServicoContratoDto.getIdServicoSelecionado();
					Integer idContrato = vinculoServicoContratoDto.getIdContrato();

					ServicoContratoDTO servicoContratoDto = this.getServicoContratoService().findByIdContratoAndIdServico(idContrato, idServico);

					if (servicoContratoDto != null && servicoContratoDto.getIdServicoContrato() != null) {
						seDesvinculado = true;

						boolean seExisteSolicitacao = this.getServicoContratoService().verificaSeExisteSolicitacaoAbertaVinculadoComServico(idServico, idContrato);
						if (seExisteSolicitacao) {
							document.executeScript("JANELA_AGUARDE_MENU.hide();");
							//document.executeScript("showServicosContrato('" + servicoContrato.getIdContrato() + "');");
							document.executeScript("notificacao('" + UtilI18N.internacionaliza(request, "informacoesContrato.servicoNaoPodeSerRemovido") + "', '')");
							return;
						}

						this.getServicoContratoService().deletarByIdServicoContrato(servicoContratoDto, document);

						this.montaHTMLServicosIncidenteContrato(vinculoServicoContratoDto, document, request);
						this.montaHTMLServicosRequisicaoContrato(vinculoServicoContratoDto, document, request);
						this.montaHTMLServicosProcedimentoContrato(vinculoServicoContratoDto, document, request);

					} else {
						seDesvinculado = false;
					}
				} else {
					document.executeScript("notificacaoErro('citcorpore.comum.permissaoFuncionalidade');");
					document.executeScript("JANELA_AGUARDE_MENU.hide();");
					return;
				}

			} else {
				seDesvinculado = false;
			}

			if (seDesvinculado) {
				document.executeScript("notificacao('" + UtilI18N.internacionaliza(request, "gerenciaportfolio.servicoDesvinculadoSucesso") + "', '')");
			} else {
				document.executeScript("notificacao('" + UtilI18N.internacionaliza(request, "gerenciaportfolio.servicoDesvinculadoErro") + "', '')");
			}

		} catch (Exception e) {
			e.printStackTrace();
			document.executeScript("notificacao('" + UtilI18N.internacionaliza(request, "gerenciaportfolio.servicoDesvinculadoErro") + "', '')");
		}

		document.executeScript("JANELA_AGUARDE_MENU.hide();");

	}

	/**
	 * @author rodrigo.dorighello
	 * @since 16.09.2015
	 */
	public void listaServicosReqIncAVincularContrato(Integer idContrato, List<Integer> listaIdsServicosVincular, final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {

		document.executeScript("JANELA_AGUARDE_MENU.show();");

		if (idContrato > 0 && listaIdsServicosVincular != null && !listaIdsServicosVincular.isEmpty()) {
			document.executeScript("montarTabelaVincularListaServicos('" + Util.listIntegerToListStr(listaIdsServicosVincular)+"," + "');");
		}

		document.executeScript("JANELA_AGUARDE_MENU.hide();");

		//Mudar para os servios que foram add em geraHtmlTabelaServicosVincular();
		document.executeScript("depoisVincularListaServicosRequisicao();");
	}

	public void geraTabelaServicosVincular(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioVinculoServicoContratoDTO vinculoServicoContratoDto = (GerenciamentoPortfolioVinculoServicoContratoDTO) document.getBean(); 

		ArrayList<Integer> listaServicoNaoAdd = new ArrayList<>();
		ArrayList<ServicoDTO> listaServicoAdd = new ArrayList<ServicoDTO>();
		
		Integer idContrato = vinculoServicoContratoDto.getIdContrato();
		List<Integer> listIdServicosVincular = Util.listStrToListInteger(vinculoServicoContratoDto.getListaIdsStrServicosContratoVinculados());
		Collections.sort(listIdServicosVincular);
		
		HTMLElement divDinamicoListaServicosVincular = document.getElementById("divDinamicoListaServicosVincular");
		
		StringBuilder sb = new StringBuilder();
		sb.append(geraHtmlCabecalhoTabelaServicosVincular(request));
		
		for (Integer idServico : listIdServicosVincular) {
			try {
				
				if (this.getServicoContratoService().findByIdContratoAndIdServico(idContrato, idServico) == null) {
					ServicoDTO servicoDto = new ServicoDTO();
					servicoDto.setIdServico(idServico);
					servicoDto = getServicoService().restore(servicoDto);
					
					if (servicoDto != null && servicoDto.getIdServico() != null && servicoDto.getNomeServico() != null) {
						sb.append(geraHtmlDadosTabelaServicosVincular(servicoDto.getIdServico(), servicoDto.getNomeServico()));
						listaServicoAdd.add(servicoDto);
						
					} else {
						listaServicoNaoAdd.add(idServico);
					}
				} else {
					listaServicoNaoAdd.add(idServico);
				}
			} catch (Exception e) {
				listaServicoNaoAdd.add(idServico);
				e.printStackTrace();
			}
		}
		
		sb.append(geraHTMLFinalTabelaServicosVincular());
		
		divDinamicoListaServicosVincular.setInnerHTML(sb.toString());
		
		if (!listaServicoNaoAdd.isEmpty() && listaServicoNaoAdd.get(0) == null) {
			String titulo = "0 " + UtilI18N.internacionaliza(request, "gerenciaportfolio.servicosVinculadosErro");
			document.executeScript("notificacao('" + titulo + "')");
		} else if (!listaServicoNaoAdd.isEmpty()) {
			String titulo = listaServicoNaoAdd.size() + " " + UtilI18N.internacionaliza(request, "gerenciaportfolio.servicosVinculadosErro");
			String msg = Util.listIntegerToListStr(listaServicoNaoAdd);
			document.executeScript("notificacao('" + titulo + "', '" + msg + "')");
		}
	}

	/**
	 * Gera o html do cabealho da tabela dos servios  vincular
	 *
	 * @throws Exception
	 * @author rodrigo.dorighello
	 * @since 01.10.2015
	 */
	private String geraHtmlCabecalhoTabelaServicosVincular(HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		sb.append("<div class='row-fluid' id='tabelaServicosVincular'> ");
		sb.append("	<div class=\"table-responsive tabela\">");
		sb.append("		<table class=\"table table-bordered table-striped table-condensed table-vertical-center checkboxs js-table-sortable ui-sortable\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.id") + "</th> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "servico.nome") + "</th> ");
		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.acoes") + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody> ");

		return sb.toString();
	}

	/**
	 * Gera o html dos dados da tabela dos servios  vincular
	 *
	 * @author rodrigo.dorighello
	 * @since 01.10.2015
	 */
	private String geraHtmlDadosTabelaServicosVincular(Integer idServico, String nomeServico) {
		StringBuilder sb = new StringBuilder();

		sb.append("		<tr data-idservico='"+idServico+"'>");
		sb.append("			<td class=\"center\">" + idServico + "</td> ");
		sb.append("			<td>" + nomeServico + "</td> ");
		sb.append("			<td class=\"center\" style=\"width: 30px;\">");
		sb.append("				<a onclick=\"removerServicoAVincular(this);\" class=\"btn-action glyphicons remove_2 btn-danger\"><i></i></a>");
		sb.append("			</td> ");
		sb.append("		</tr> ");

		return sb.toString();
	}

	/**
	 * Gera o html do final da tabela dos servios  vincular
	 *
	 * @author rodrigo.dorighello
	 * @since 01.10.2015
	 */
	private String geraHTMLFinalTabelaServicosVincular() {
		StringBuilder sb = new StringBuilder();
		sb.append("			</tbody> ");
		sb.append("		</table>");
		sb.append("	</div>");
		sb.append("</div>");

		return sb.toString();
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	public void gravarFluxo(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioVinculoServicoContratoDTO vinculoServicoContratoDto = (GerenciamentoPortfolioVinculoServicoContratoDTO) document.getBean();

		if (vinculoServicoContratoDto != null) {
			/*
			 * Faz validaes manuais.
			 */
			if (vinculoServicoContratoDto.getIdTipoFluxo() == null) {
				document.executeScript("notificacao('" + UtilI18N.internacionaliza(request, "gerenciaportfolio.vinculoServicoContrato.fluxoServico.obrigatorioFluxo") + "', '');");
				return;
			}

			if (vinculoServicoContratoDto.getIdFase() == null) {
				document.executeScript("notificacao('" + UtilI18N.internacionaliza(request, "gerenciaportfolio.vinculoServicoContrato.fluxoServico.obrigatorioFase") + "', '');");
				return;
			}

			if (vinculoServicoContratoDto.getPrincipal() == null) {
				document.executeScript("notificacao('" + UtilI18N.internacionaliza(request, "gerenciaportfolio.vinculoServicoContrato.fluxoServico.obrigatorioFluxoPrincipal") + "', '');");
				return;
			}

			FluxoServicoDTO fluxoServicoDto = new FluxoServicoDTO();

			fluxoServicoDto.setIdTipoFluxo(vinculoServicoContratoDto.getIdTipoFluxo());
			fluxoServicoDto.setIdFase(vinculoServicoContratoDto.getIdFase());
			fluxoServicoDto.setPrincipal(vinculoServicoContratoDto.getPrincipal());

			try {
				ArrayList<FluxoServicoDTO> listaFluxos = null;

				//Verifica se j existem outros fluxos adicionados.
				if (vinculoServicoContratoDto.getListaTempFluxosSerializados() != null && !vinculoServicoContratoDto.getListaTempFluxosSerializados().equals("")) {
					listaFluxos = (ArrayList) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(FluxoServicoDTO.class, "listaTempFluxosSerializados", request);

					if (listaFluxos != null && listaFluxos.size() > 0) {
						boolean seJaExisteFluxoServico = false;

						for (int i = 0; i < listaFluxos.size(); i++) {
							if (listaFluxos.get(i).getIdTipoFluxo() != null && listaFluxos.get(i).getIdTipoFluxo().equals(fluxoServicoDto.getIdTipoFluxo())) {
								if (listaFluxos.get(i).getIdFase() != null && listaFluxos.get(i).getIdFase().equals(fluxoServicoDto.getIdFase())) {
									if (listaFluxos.get(i).getPrincipal() != null && listaFluxos.get(i).getPrincipal().equals(fluxoServicoDto.getPrincipal())) {
										seJaExisteFluxoServico = true;
										break;
									}
								}

							}
						}

						if (seJaExisteFluxoServico) {
							document.executeScript("notificacao('" + UtilI18N.internacionaliza(request, "gerenciaportfolio.vinculoServicoContrato.fluxoServico.fluxoServicoExistente") + "', '');");
							return;
						}
					}
				}

				if (listaFluxos == null) {
					listaFluxos = new ArrayList<FluxoServicoDTO>();
				}

				listaFluxos.add(fluxoServicoDto);

				geraTabelaFluxoServico(listaFluxos, document, request);

				String listaTempFluxosSerializados = br.com.citframework.util.WebUtil.serializeObjects(listaFluxos, WebUtil.getLanguage(request));

				document.executeScript("depoisGravarFluxo('" + listaTempFluxosSerializados + "');");
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	/**
	 * Gera a tabela de fluxos de servio
	 *
	 * @throws Exception
	 * @author rodrigo.dorighello
	 * @since 01.10.2015
	 */
	private void geraTabelaFluxoServico(ArrayList<FluxoServicoDTO> listaFluxos, DocumentHTML document, HttpServletRequest request) throws Exception {

		HTMLElement divDinamicoFluxoServico = document.getElementById("divDinamicoFluxoServico");

		StringBuilder sb = new StringBuilder();
		sb.append(geraHtmlCabecalhoTabelaFluxoServico(request));

		for (int i = 0; i < listaFluxos.size(); i++) {
			FluxoServicoDTO fluxoServicoDto = listaFluxos.get(i);
			sb.append(geraHtmlDadosTabelaFluxoServico(fluxoServicoDto.getIdTipoFluxo(), fluxoServicoDto.getIdFase(), fluxoServicoDto.getPrincipal(), request));
		}

		sb.append(geraHTMLFinalTabelaFluxoServico());

		divDinamicoFluxoServico.setInnerHTML(sb.toString());
	}

	/**
	 * Gera o html do cabealho da tabela dos fluxos servios
	 *
	 * @throws Exception
	 * @author rodrigo.dorighello
	 * @since 01.10.2015
	 */
	private String geraHtmlCabecalhoTabelaFluxoServico(HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		sb.append("<div class='row-fluid' id='tabelaFluxoServico'> ");
		sb.append("	<div class=\"table-responsive tabela\">");
		sb.append("		<table class=\"table table-bordered table-striped table-condensed table-vertical-center checkboxs js-table-sortable ui-sortable\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "visao.fluxo") + "</th> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "visao.fase") + "</th> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "visao.fluxoPrincipal") + "</th> ");
		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.acoes") + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody> ");

		return sb.toString();
	}

	/**
	 * Gera o html dos dados da tabela dos fluxos servios
	 *
	 * @author rodrigo.dorighello
	 * @since 01.10.2015
	 */
	private String geraHtmlDadosTabelaFluxoServico(Integer idTipoFluxo, Integer idFase, String principal, HttpServletRequest request) {

		FluxoDTO fluxoDto = new FluxoDTO();

		try {
			fluxoDto = this.getFluxoService().findByTipoFluxo(idTipoFluxo);
		} catch (Exception e) {
			e.printStackTrace();
		}

		String nomeFluxo = "";
		if (fluxoDto != null && fluxoDto.getNomeFluxo() != null) {
			nomeFluxo = fluxoDto.getNomeFluxo();
		}

		FaseServicoDTO faseServicoDto = new FaseServicoDTO();
		faseServicoDto.setIdFase(idFase);

		try {
			faseServicoDto = this.getFaseServicoService().restore(faseServicoDto);
		} catch (Exception e) {
			e.printStackTrace();
		}

		String nomeFase = "";

		if (faseServicoDto != null && faseServicoDto.getNomeFase() != null) {
			FaseServicoFluxo faseServico = FaseServicoFluxo.fromIdentificador(faseServicoDto.getNomeFase());
			nomeFase = faseServico != null ? UtilI18N.internacionaliza(request, faseServico.getChave()) : faseServicoDto.getNomeFase();
		}

		String fluxoPrincipal = "";
		if (principal != null) {
			if (principal.equalsIgnoreCase("S")) {
				fluxoPrincipal = UtilI18N.internacionaliza(request, "citcorpore.comum.sim");
			} else {
				if (principal.equalsIgnoreCase("N")) {
					fluxoPrincipal = UtilI18N.internacionaliza(request, "citcorpore.comum.nao");
				}
			}
		}

		StringBuilder sb = new StringBuilder();

		sb.append("		<tr>");
		sb.append("			<td>" + nomeFluxo + "</td> ");
		sb.append("			<td>" + nomeFase + "</td> ");
		sb.append("			<td>" + fluxoPrincipal + "</td> ");
		sb.append("			<td class=\"center\" style=\"width: 30px;\">");
		sb.append("				<a onclick=\"removerFluxoServico(this);\" class=\"btn-action glyphicons remove_2 btn-danger\"><i></i></a>");
		sb.append("			</td> ");
		sb.append("		</tr> ");

		return sb.toString();
	}

	/**
	 * Gera o html do final da tabela dos fluxos servios
	 *
	 * @author rodrigo.dorighello
	 * @since 01.10.2015
	 */
	private String geraHTMLFinalTabelaFluxoServico() {
		StringBuilder sb = new StringBuilder();
		sb.append("			</tbody> ");
		sb.append("		</table>");
		sb.append("	</div>");
		sb.append("</div>");

		return sb.toString();
	}
	

	/**
	 * Mtodo para vincular vrios servios de requisio ou incidente ao
	 * contrato a partir da lookup com checkbox
	 *
	 * @author rodrigo.dorighello
	 * @since 16.10.2015
	 */
	public void adicionaTabelaLOOKUP_SERVICOS_VINCULAR_CONTRATO(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioVinculoServicoContratoDTO vinculoServicoContratoDto = (GerenciamentoPortfolioVinculoServicoContratoDTO) document.getBean();
		
		Integer idContrato = vinculoServicoContratoDto.getIdContrato();

		if (vinculoServicoContratoDto != null && idContrato != null && vinculoServicoContratoDto.getColAllLOOKUP_SERVICOS_VINCULAR_CONTRATO() != null) {

			String listaStr = vinculoServicoContratoDto.getColAllLOOKUP_SERVICOS_VINCULAR_CONTRATO();

			List<Integer> listaIdsServicosVincular = Util.listStrToListIntegerWithSplit(listaStr, ";");
			listaServicosReqIncAVincularContrato(idContrato, listaIdsServicosVincular, document, request, response);
		}
	}
	
	public void carregaListaServicosVincularContrato(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoPortfolioVinculoServicoContratoDTO vinculoServicoContratoDto = (GerenciamentoPortfolioVinculoServicoContratoDTO) document.getBean();
		
		Integer idPortfolioServico = vinculoServicoContratoDto.getIdPortfolioServico();
		Integer idServicoRelacionado = vinculoServicoContratoDto.getIdServicoRelacionado();
		String tipoServico = vinculoServicoContratoDto.getTipoServico();
		Integer idContrato = vinculoServicoContratoDto.getIdContrato();
		
		if(idPortfolioServico != null && idServicoRelacionado != null && idContrato != null && !UtilStrings.isNullOrEmpty(tipoServico)) {
			List<Integer> idsServicosRelacionados = this.getServicoAutoRelacionamentoService().listIdsServicosRelacionadosVincularContrato(idPortfolioServico, idServicoRelacionado, tipoServico, idContrato);
			
			if(!idsServicosRelacionados.isEmpty()) {
				listaServicosReqIncAVincularContrato(idContrato, idsServicosRelacionados, document, request, response);
			}
		}
		
	}

	private ServicoService getServicoService() throws ServiceException {
		if (servicoService == null) {
			servicoService = (ServicoService) ServiceLocator.getInstance().getService(ServicoService.class, null);
		}
		return servicoService;
	}
	
	private ServicoAutoRelacionamentoService getServicoAutoRelacionamentoService() throws ServiceException {
		if (servicoAutoRelacionamentoService == null) {
			servicoAutoRelacionamentoService = (ServicoAutoRelacionamentoService) ServiceLocator.getInstance().getService(ServicoAutoRelacionamentoService.class, null);
		}
		return servicoAutoRelacionamentoService;
	}

	private ServicoContratoService getServicoContratoService() throws Exception {
		if (servicoContratoService == null) {
			servicoContratoService = (ServicoContratoService) ServiceLocator.getInstance().getService(ServicoContratoService.class, null);
		}
		return servicoContratoService;
	}

	private CondicaoOperacaoService getCondicaoOperacaoService() throws ServiceException {
		if (condicaoOperacaoService == null) {
			condicaoOperacaoService = (CondicaoOperacaoService) ServiceLocator.getInstance().getService(CondicaoOperacaoService.class, null);
		}
		return condicaoOperacaoService;
	}

	private ModeloEmailService getModeloEmailService() throws ServiceException {
		if (modeloEmailService == null) {
			modeloEmailService = (ModeloEmailService) ServiceLocator.getInstance().getService(ModeloEmailService.class, null);
		}
		return modeloEmailService;
	}

	private GrupoService getGrupoService() throws ServiceException {
		if (grupoService == null) {
			grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
		}
		return grupoService;
	}

	private CalendarioService getCalendarioService() throws ServiceException {
		if (calendarioService == null) {
			calendarioService = (CalendarioService) ServiceLocator.getInstance().getService(CalendarioService.class, null);
		}
		return calendarioService;
	}

	private FluxoService getFluxoService() throws ServiceException {
		if (fluxoService == null) {
			fluxoService = (FluxoService) ServiceLocator.getInstance().getService(FluxoService.class, null);
		}
		return fluxoService;
	}

	private FluxoServicoService getFluxoServicoService() throws ServiceException {
		if (fluxoServicoService == null) {
			fluxoServicoService = (FluxoServicoService) ServiceLocator.getInstance().getService(FluxoServicoService.class, null);
		}
		return fluxoServicoService;
	}

	private FaseServicoService getFaseServicoService() throws ServiceException {
		if (faseServicoService == null) {
			faseServicoService = (FaseServicoService) ServiceLocator.getInstance().getService(FaseServicoService.class, null);
		}
		return faseServicoService;
	}
	
	private AcordoServicoContratoService getAcordoServicoContratoService() throws ServiceException {
		if (acordoServicoContratoService == null) {
			acordoServicoContratoService = (AcordoServicoContratoService) ServiceLocator.getInstance().getService(AcordoServicoContratoService.class, null);
		}
		return acordoServicoContratoService;
	}

	private AcordoNivelServicoService getAcordoNivelServicoService() throws ServiceException {
		if (acordoNivelServicoService == null) {
			acordoNivelServicoService = (AcordoNivelServicoService) ServiceLocator.getInstance().getService(AcordoNivelServicoService.class, null);
		}
		return acordoNivelServicoService;
	}

	@Override
	public Class<GerenciamentoPortfolioVinculoServicoContratoDTO> getBeanClass() {
		return GerenciamentoPortfolioVinculoServicoContratoDTO.class;
	}

}
