package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;

import br.com.centralit.bpm.dto.ElementoFluxoDTO;
import br.com.centralit.bpm.dto.TarefaFluxoDTO;
import br.com.centralit.bpm.util.Enumerated;
import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citcorpore.bean.BIConsultaDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoProblemasDTO;
import br.com.centralit.citcorpore.bean.ProblemaDTO;
import br.com.centralit.citcorpore.bean.SmartReportDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.integracao.ProblemaDAO;
import br.com.centralit.citcorpore.negocio.BIConsultaService;
import br.com.centralit.citcorpore.negocio.ExecucaoProblemaService;
import br.com.centralit.citcorpore.negocio.ProblemaService;
import br.com.centralit.citcorpore.negocio.SmartReportService;
import br.com.centralit.citcorpore.util.Enumerados.ModuloExibicaoRelatorio;
import br.com.centralit.citcorpore.util.Enumerados.ProblemRequestStatus;
import br.com.centralit.citcorpore.util.Enumerados.SimNao;
import br.com.centralit.citcorpore.util.Enumerados.TipoDate;
import br.com.centralit.citcorpore.util.Enumerados.TipoExibicaoRelatorio;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;
import br.com.citframework.util.UtilStrings;

public class GerenciamentoProblemas extends AjaxFormAction {
	private BIConsultaService biConsultaService;
	private SmartReportService smartReportService;

	@Override
	public Class<GerenciamentoProblemasDTO> getBeanClass() {
		return GerenciamentoProblemasDTO.class;
	}

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		exibeTarefas(document, request, response);
		loadRelatorios(document, request, response);

		UsuarioDTO usuario = WebUtil.getUsuario(request);
		if(usuario != null && usuario.getNomeUsuario() != null){
			request.setAttribute("login", WebUtil.getUsuario(request).getNomeUsuario());
		}
	}

	public void exibeTarefas(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		ProblemaDTO problemaDto = new ProblemaDTO();
		UsuarioDTO usuario = WebUtil.getUsuario(request);
		GerenciamentoProblemasDTO gerenciamentoBean = (GerenciamentoProblemasDTO) document.getBean();

		ExecucaoProblemaService execucaoProblemaService = (ExecucaoProblemaService) ServiceLocator.getInstance().getService(ExecucaoProblemaService.class, null);
		List<TarefaFluxoDTO> colTarefas = execucaoProblemaService.recuperaTarefas(usuario.getLogin());
		if (colTarefas == null) {
			return;
		}

		boolean bFiltroPorSolicitacao = false;
		if(gerenciamentoBean != null){
			bFiltroPorSolicitacao = gerenciamentoBean.getIdProblemaSel() != null && gerenciamentoBean.getIdProblemaSel().length() > 0;
		}
		List<TarefaFluxoDTO> colTarefasFiltradas = new ArrayList<TarefaFluxoDTO>();
		if (!bFiltroPorSolicitacao) {
			colTarefasFiltradas.addAll(colTarefas);
		} else {
			for (TarefaFluxoDTO tarefaDto : colTarefas) {
				boolean bAdicionar = false;
				String idProblema = "" + ((ProblemaDTO) tarefaDto.getProblemaDto()).getIdProblema();
				bAdicionar = idProblema.indexOf(gerenciamentoBean.getIdProblemaSel()) >= 0;
				if (bAdicionar) {
					colTarefasFiltradas.add(tarefaDto);
				}
			}
		}
		List<TarefaFluxoDTO> colTarefasFiltradasFinal = new ArrayList<TarefaFluxoDTO>();
		HashMap<String, String> mapAtr = new HashMap<String, String>();
		mapAtr.put(UtilI18N.internacionaliza(request, "citcorpore.comum.sematribuicao"), UtilI18N.internacionaliza(request, "citcorpore.comum.sematribuicao"));
		for (TarefaFluxoDTO tarefaDto : colTarefasFiltradas) {
			problemaDto = (ProblemaDTO) tarefaDto.getProblemaDto();
			problemaDto.setDataHoraInicioSLAStr("");
			problemaDto.setDescricao("");
			problemaDto.setDataHoraLimiteStr(UtilDatas.convertDateToString(TipoDate.TIMESTAMP_DEFAULT, problemaDto.getDataHoraLimite(), WebUtil.getLanguage(request)));
			problemaDto.setDataHoraInicioSLAStr(UtilDatas.convertDateToString(TipoDate.TIMESTAMP_DEFAULT, problemaDto.getDataHoraInicioSLA(), WebUtil.getLanguage(request)));
			problemaDto.setDataHoraCapturaStr(UtilDatas.convertDateToString(TipoDate.TIMESTAMP_DEFAULT, problemaDto.getDataHoraCaptura(), WebUtil.getLanguage(request)));

			if (problemaDto.getResponsavel() != null) {
				if (!mapAtr.containsKey(problemaDto.getResponsavel())) {
					mapAtr.put(problemaDto.getResponsavel(), problemaDto.getResponsavel());
				}
			}

			if (gerenciamentoBean.getAtribuidaCompartilhada() == null || gerenciamentoBean.getAtribuidaCompartilhada().trim().equalsIgnoreCase("")) {
				colTarefasFiltradasFinal.add(tarefaDto);
			} else {
				if (gerenciamentoBean.getAtribuidaCompartilhada().trim().equalsIgnoreCase(UtilI18N.internacionaliza(request, "citcorpore.comum.sematribuicao"))) {
					if (tarefaDto.getResponsavelAtual() == null || tarefaDto.getResponsavelAtual().trim().equalsIgnoreCase("")) {
						colTarefasFiltradasFinal.add(tarefaDto);
					}
				} else {
					if (gerenciamentoBean.getAtribuidaCompartilhada().trim().equalsIgnoreCase(tarefaDto.getResponsavelAtual())) {
						colTarefasFiltradasFinal.add(tarefaDto);
					}
				}
			}
		}

		if (gerenciamentoBean != null && gerenciamentoBean.getIdProblemaSel() != null && !gerenciamentoBean.getIdProblemaSel().trim().equalsIgnoreCase("")) {
			/**
			 * Por excesso(ou no?) de zelo, foi colocado esse try-catch na converso do valor retornado por "gerenciamentoBean.getIdProblemaSel()", que  uma String, em Integer. O mtodo que  da api
			 * Java padro, "Integer.valueOf(String s)", emite uma exceo quando no consegue fazer o parse, da a necessidade do try-catch. alterado por rcs (Rafael Csar Soyer) - Analista
			 * Desenvolvedor data: 07/04/2015 email: rafael.soyer@centrait.com.br
			 */
			try {
				Integer integer_idProblemaSel = Integer.valueOf(gerenciamentoBean.getIdProblemaSel());
				problemaDto.setIdProblema(integer_idProblemaSel);
			} catch (NumberFormatException numb_exc) {
				numb_exc.printStackTrace();
			}
		}

		String tarefasStr = serializaTarefas(colTarefasFiltradasFinal, request);

		document.executeScript("exibirGraficos('" + tarefasStr + "');");

		montarTabelaProblemas(document, request, colTarefasFiltradasFinal);

		loadRelatoriosEspecificos(document, request, response);
	}

	private String serializaTarefas(List<TarefaFluxoDTO> colTarefas, HttpServletRequest request) throws Exception {
		if (colTarefas == null) {
			return null;
		}
		for (TarefaFluxoDTO tarefaDto : colTarefas) {
			String elementoFluxo_serialize = StringEscapeUtils.escapeJavaScript(br.com.citframework.util.WebUtil.serializeObject(tarefaDto.getElementoFluxoDto(), WebUtil.getLanguage(request)));
			String problema_serialize = StringEscapeUtils.escapeJavaScript(br.com.citframework.util.WebUtil.serializeObject(tarefaDto.getProblemaDto(), WebUtil.getLanguage(request)));

			tarefaDto.setElementoFluxo_serialize(elementoFluxo_serialize);
			tarefaDto.setProblema_serialize(problema_serialize);
		}
		return br.com.citframework.util.WebUtil.serializeObjects(colTarefas, WebUtil.getLanguage(request));
	}

	private void montarTabelaProblemas(DocumentHTML document, HttpServletRequest request, List<TarefaFluxoDTO> colTarefasFiltradasFinal) throws Exception {
		HTMLElement divTabelaProblemas = document.getElementById("divConteudoLista");
		StringBuilder conteudoHtml = new StringBuilder();

		if (colTarefasFiltradasFinal == null || colTarefasFiltradasFinal.isEmpty()) {
			conteudoHtml.append("<div class='separator'></div>");
			conteudoHtml.append("<h4 class=\"align-center\">").append(UtilI18N.internacionaliza(request, "MSG04")).append("</h4>");
		} else {
			ArrayList<String> colunas = new ArrayList<String>();
			colunas.add("citcorpore.comum.numero");
			colunas.add("citcorpore.comum.titulo");
			colunas.add("contrato.contrato");
			colunas.add("solicitacaoServico.dataHoraCriacao");
			colunas.add("gerenciaservico.pri");
			colunas.add("solicitacaoServico.prazoLimite");
			colunas.add("solicitacaoServico.solicitante");
			colunas.add("citcorpore.comum.status");
			colunas.add("tarefa.tarefa_atual");
			colunas.add("citcorpore.comum.grupoExecutor");
			colunas.add("tarefa.responsavelatual");
			colunas.add("citcorpore.comum.acoes");


			conteudoHtml.append(UtilHTML.geraHTMLCabecalhoTabela(request, colunas));
			for (TarefaFluxoDTO tarefa : colTarefasFiltradasFinal) {
				conteudoHtml.append(geraHtmlDadosTabela(request, tarefa));
			}
			conteudoHtml.append(UtilHTML.geraHTMLRodapeTabela());
		}

		divTabelaProblemas.setInnerHTML(conteudoHtml.toString());

		document.executeScript("configuraCamposResponsivosTabelaProblemas()");
	}

	private String geraHtmlDadosTabela(final HttpServletRequest request, TarefaFluxoDTO tarefa) throws Exception {
		StringBuilder sb = new StringBuilder();
		sb.append("		<tr>");

		ProblemaDTO problema = (ProblemaDTO) tarefa.getProblemaDto();
		ElementoFluxoDTO elementoFluxo = tarefa.getElementoFluxoDto();

		if (problema != null) {
			sb.append("			<td>".concat(UtilNumbersAndDecimals.nullToVazio(problema.getIdProblema())).concat("</td>"));
			sb.append("			<td>".concat(UtilStrings.nullToVazio(problema.getTitulo())).concat("</td>"));
			sb.append("			<td>".concat(UtilStrings.nullToVazio(problema.getContrato())).concat("</td>"));
			sb.append("			<td>".concat(UtilStrings.nullToVazio(problema.getDataHoraCapturaStr())).concat("</td>"));

			if (problema.getPrioridade() != null && problema.getPrioridade().equals(new Integer(1))) {
				sb.append("			<td>".concat(UtilNumbersAndDecimals.nullToVazio(problema.getPrioridade()))
						.concat("&nbsp;<img src='").concat(Constantes.getValue("CONTEXTO_APLICACAO")).concat("/imagens/b.gif' style='cursor: pointer;' title='")
						.concat(UtilI18N.internacionaliza(request, "gerenciaservico.prioridadealta"))
						.concat("'/></td>"));
			} else {
				sb.append("			<td>".concat(UtilNumbersAndDecimals.nullToVazio(problema.getPrioridade())).concat("</td>"));
			}

			if (problema.getDataHoraLimiteStr() != null && !problema.getDataHoraLimiteStr().equals("")) {
				sb.append("			<td>".concat(UtilStrings.nullToVazio(problema.getDataHoraLimiteStr()).substring(0, 10)).concat("</td>"));
			} else {
				sb.append("			<td>".concat(UtilStrings.nullToVazio(problema.getDataHoraLimiteStr())).concat("</td>"));
			}

			sb.append("			<td>".concat(UtilStrings.nullToVazio(problema.getSolicitante())).concat("</td>"));

			if (problema.getAtrasoSLA() > new Double(0) && !ProblemRequestStatus.SUSPENDED.getId().equals(problema.getIdStatus())) {
				sb.append("			<td>".concat("<img src='").concat(Constantes.getValue("CONTEXTO_APLICACAO")).concat("/imagens/b.gif' style='cursor: pointer;' title='")
						.concat(UtilI18N.internacionaliza(request, "gerenciaservico.atrasada"))
						.concat("'/>").concat(UtilI18N.internacionaliza(request, "gerenciaservico.atrasada")).concat("</td>"));
			} else {
				sb.append("			<td>".concat(UtilI18N.internacionaliza(request, problema.getDescrStatus())).concat("</td>"));
			}

			sb.append("			<td>".concat(UtilStrings.nullToVazio(elementoFluxo.getDocumentacao())).concat("</td>"));
			sb.append("			<td>".concat(UtilStrings.nullToVazio(problema.getNomeGrupoAtual())).concat("</td>"));
			sb.append("			<td>".concat(UtilStrings.nullToVazio(problema.getResponsavel())).concat("</td>"));

			geraAcoesTabela(request, sb, tarefa, problema, elementoFluxo);
		}

		sb.append("		</tr> ");

		return sb.toString();
	}

	private void geraAcoesTabela(final HttpServletRequest request, StringBuilder sb, TarefaFluxoDTO tarefa, ProblemaDTO problema, ElementoFluxoDTO elementoFluxo) throws Exception {
		sb.append("			<td class=\"center\" style=\"width: 200px;\"> ");
		sb.append("				<div class='span12'>");
		sb.append("					<div class='span4'>");

		// Visualizar Solicitao
		String onclickVisualizarSolicitacao = "visualizarSolicitacao(".concat(UtilNumbersAndDecimals.nullToVazio(problema.getIdProblema())).concat(")");
		geraSpanButton(request, sb, "btn-action glyphicons search btn-primary mt2", "problema.vizualizarCadastroProblema", onclickVisualizarSolicitacao);

		// Relatrios Especficos
		sb.append(
"					<span class='btn-action glyphicons charts btn-primary gp-relatorios-especificos mt2' style='cursor:pointer;' data-idespecifico='"
				.concat(UtilNumbersAndDecimals.nullToVazio(problema.getIdProblema())).concat("' data-title='")
				.concat(UtilI18N.internacionaliza(request, "menu.nome.relatorio"))
				.concat("' tabindex='0' data-toggle='popover' data-trigger='focus'  data-container='body' ")
				.concat("data-placement='top' data-html='true' data-content='' ")
				.concat("onclick='javascript: return false;'>").concat("<i title='").concat(UtilI18N.internacionaliza(request, "menu.nome.relatorio")).concat("'></i></span>"));

		sb.append("					</div>");
		sb.append("					<div class='span8'>");

		geraDropdownInicio(request, sb);

		// Agendar Problema
		String onclickAgendarProblema = "agendaAtividade(".concat(UtilNumbersAndDecimals.nullToVazio(problema.getIdProblema())).concat(")");
		geraAcoesDropdown(request, sb, onclickAgendarProblema, "gerenciaservico.agendaratividade");
		if (!ProblemRequestStatus.SUSPENDED.getId().equals(problema.getIdStatus())
				&& SimNao.SIM.getValorStr().equalsIgnoreCase(tarefa.getSuspender())) {

			String onclickPrepararSuspensao = "prepararSuspensao(".concat(UtilNumbersAndDecimals.nullToVazio(problema.getIdProblema())).concat(")");
			geraAcoesDropdown(request, sb, onclickPrepararSuspensao, "gerenciaservico.suspenderProblema");
		} else if (ProblemRequestStatus.SUSPENDED.getId().equals(problema.getIdStatus())
				&& SimNao.SIM.getValorStr().equalsIgnoreCase(tarefa.getReativar())) {

			String onclickReativarMudanca = "reativarProblema(".concat(UtilNumbersAndDecimals.nullToVazio(problema.getIdProblema())).concat(")");
			geraAcoesDropdown(request, sb, onclickReativarMudanca, "gerenciaservico.reativarProblema");
		}

		UsuarioDTO usuario = WebUtil.getUsuario(request);
		String loginUsuario = UtilStrings.nullToVazio(usuario.getLogin());

		if (!ProblemRequestStatus.SUSPENDED.getId().equals(problema.getIdStatus())
				&& SimNao.SIM.getValorStr().equalsIgnoreCase(tarefa.getExecutar())) {

			if (problema.getResponsavel() == null || !loginUsuario.equalsIgnoreCase(problema.getResponsavel())) {
				String onclickCapturar = "capturarTarefa(\"".concat(UtilStrings.nullToVazio(problema.getResponsavel())).concat("\",")
						.concat(UtilNumbersAndDecimals.nullToVazio(tarefa.getIdItemTrabalho())).concat(",")
						.concat(UtilNumbersAndDecimals.nullToVazio(problema.getIdProblema())).concat(")");

				geraAcoesDropdown(request, sb, onclickCapturar, "gerenciaservico.capturartarefa");
			}

			String onclickExecutarTarefa = "prepararExecucaoTarefa(".concat(UtilNumbersAndDecimals.nullToVazio(tarefa.getIdItemTrabalho())).concat(",")
					.concat(UtilNumbersAndDecimals.nullToVazio(problema.getIdProblema())).concat(",\"E\");");

			geraAcoesDropdown(request, sb, onclickExecutarTarefa, "gerenciaservico.iniciarexecutartarefa");
		}

		geraDropdownFim(sb);

		sb.append("					</div>");
		sb.append("				</div>");
		sb.append("			</td>");
	}

	private void geraSpanButton(HttpServletRequest request, StringBuilder sb, String clazz, String chaveTitulo, String onclick) {
		sb.append("<span class='".concat(clazz).concat("' title='"));
		sb.append(UtilI18N.internacionaliza(request, chaveTitulo));
		sb.append("' onclick='");
		sb.append(onclick);
		sb.append("' style='cursor:pointer;'><i></i></span>");
	}

	private void geraDropdownInicio(HttpServletRequest request, StringBuilder sb) throws Exception {
		sb.append("						<div id='acoes' class='btn-group btn-block w15 aLeft dropup span11'>");
		sb.append("							<div class='leadcontainer' data-toggle='dropdown'>");
		sb.append("								<button type='button' class='btn dropdown-lead btn-default'>" + UtilI18N.internacionaliza(request, "solicitacaoServico.acao") + "</button>");
		sb.append("							</div>");
		sb.append("							<a class='btn btn-default dropdown-toggle solicitacoes-toggle' data-toggle='dropdown'><span class='caret'></span> </a>");
		sb.append("							<ul class='dropdown-menu pull-right'>");
	}

	private void geraAcoesDropdown(HttpServletRequest request, StringBuilder sb, String onclick, String chaveTexto) throws Exception {
		sb.append("								<li onclick='".concat(onclick).concat("'><a >").concat(UtilI18N.internacionaliza(request, chaveTexto)).concat("</a></li>"));
	}

	private void geraDropdownFim(StringBuilder sb) {
		sb.append("							</ul>");
		sb.append("						</div>");
	}

	public void preparaExecucaoTarefa(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert("Sesso expirada! Favor efetuar logon novamente!");
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		GerenciamentoProblemasDTO gerenciamentoBean = (GerenciamentoProblemasDTO) document.getBean();
		if (gerenciamentoBean.getIdTarefa() == null) {
			return;
		}

		if(gerenciamentoBean.getIdProblema() == null) {
			return;
		}

		ExecucaoProblemaService execucaoProblemaService = (ExecucaoProblemaService) ServiceLocator.getInstance().getService(ExecucaoProblemaService.class, null);
		TarefaFluxoDTO tarefaDto = execucaoProblemaService.recuperaTarefa(usuario.getLogin(), gerenciamentoBean.getIdTarefa());
		if (tarefaDto == null || tarefaDto.getElementoFluxoDto() == null || !tarefaDto.getExecutar().equals("S") || tarefaDto.getElementoFluxoDto().getTipoInteracao() == null) {
			return;
		}

		if (tarefaDto.getElementoFluxoDto().getTipoInteracao().equals(Enumerated.INTERACTION_VIEW)) {
			if (tarefaDto.getIdVisao() != null) {
				document.executeScript("exibirVisao('" + UtilI18N.internacionaliza(request, "gerenciaservico.iniciarexecutartarefa") + " " + tarefaDto.getElementoFluxoDto().getDocumentacao() + "','"
						+ tarefaDto.getIdVisao() + "','"
						+ tarefaDto.getElementoFluxoDto().getIdFluxo() + "','" + tarefaDto.getIdItemTrabalho() + "','" + gerenciamentoBean.getAcaoFluxo() + "');");
			} else {
				document.alert("Viso para tarefa \"" + tarefaDto.getElementoFluxoDto().getDocumentacao() + "\" no encontrada");
			}
		} else {
			String caracterParmURL = "?";
			if (tarefaDto.getElementoFluxoDto().getUrl().indexOf("?") > -1) { // Se na URL ja tiver ?, entao colocar &
				caracterParmURL = "&";
			}
			document.executeScript("exibirUrl('" + UtilI18N.internacionaliza(request, "gerenciaservico.iniciarexecutartarefa") + " " + tarefaDto.getElementoFluxoDto().getDocumentacao() + "','"
					+ tarefaDto.getElementoFluxoDto().getUrl() + caracterParmURL
					+ "idProblema=" + gerenciamentoBean.getIdProblema() + "&idTarefa=" + tarefaDto.getIdItemTrabalho() + "&acaoFluxo=" + gerenciamentoBean.getAcaoFluxo() + "');");
		}
	}

	public void reativaProblema(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert("Sesso expirada! Favor efetuar logon novamente!");
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		GerenciamentoProblemasDTO gerenciamentoBean = (GerenciamentoProblemasDTO) document.getBean();
		if (gerenciamentoBean.getIdProblema() == null) {
			return;
		}

		ProblemaService problemaService = (ProblemaService) ServiceLocator.getInstance().getService(ProblemaService.class, null);
		ProblemaDTO problemaDto = problemaService.restoreAll(gerenciamentoBean.getIdProblema());
		problemaService.reativa(usuario, problemaDto);
		exibeTarefas(document, request, response);
		document.executeScript("JANELA_AGUARDE_MENU.hide()");
	}

	public void capturaTarefa(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		GerenciamentoProblemasDTO problemaBean = (GerenciamentoProblemasDTO) document.getBean();

		if (problemaBean.getIdTarefa() == null) {
			return;
		}

		if (problemaBean.getIdProblema() == null){
			return;
		}

		ProblemaDTO problemaDto = new ProblemaDTO();
		ProblemaDAO problemaDao = new ProblemaDAO();
		problemaDto.setIdProblema(problemaBean.getIdProblema());
		problemaDto.setIdProprietario(usuario.getIdUsuario());
		problemaDao.updateNotNull(problemaDto);



		ExecucaoProblemaService execucaoProblemaService = (ExecucaoProblemaService) ServiceLocator.getInstance().getService(ExecucaoProblemaService.class, null);
		execucaoProblemaService.executa(usuario, problemaBean.getIdTarefa(), Enumerated.ACTION_START);
		exibeTarefas(document, request, response);

		problemaBean = null;

		document.executeScript("JANELA_AGUARDE_MENU.hide()");
	}

	private BIConsultaService getBIConsultaService() throws ServiceException {
		if (biConsultaService == null) {
			biConsultaService = (BIConsultaService) ServiceLocator.getInstance().getService(BIConsultaService.class, null);
		}
		return biConsultaService;
	}

	private void loadRelatorios(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		StringBuilder sb = new StringBuilder();
		UsuarioDTO usuario = WebUtil.getUsuario(request);

		Collection<BIConsultaDTO> biConsultaListDTO = getBIConsultaService().findByTipoModuloExibicao(TipoExibicaoRelatorio.GERAL.getIdentificador(),
				ModuloExibicaoRelatorio.GERENCIAMENTO_PROBLEMA.getIdentificador());

		if (biConsultaListDTO != null && !biConsultaListDTO.isEmpty()) {
			for (BIConsultaDTO biConsultaDTO : biConsultaListDTO) {
				sb.append("<a href='#' onclick='openReport(&#39;" + biConsultaDTO.getTipoConsulta() + "&#39;, " + biConsultaDTO.getIdConsulta() + ",&#39;" + biConsultaDTO.getNomeConsulta()
						+ "&#39;); return false;'>" + biConsultaDTO.getNomeConsulta() + "</a><br/>");
			}
		}

		Collection<SmartReportDTO> listSmartReport = getSmartReportService().findByIdsGrupoUsuarioAndTipoModuloExibicao(usuario.getColGrupos(), TipoExibicaoRelatorio.GERAL.getIdentificador(),
				ModuloExibicaoRelatorio.GERENCIAMENTO_PROBLEMA.getIdentificador());

		if (listSmartReport != null && !listSmartReport.isEmpty()) {
			for (SmartReportDTO smartReportDTO : listSmartReport) {
				sb.append("<a href='#' onclick='UtilSmartReport.open(" + smartReportDTO.getIdSmartReport() + ", null); return false;'>" + smartReportDTO.getIdentificacao() + "</a><br/>");
			}
		}

		if (sb.length() == 0) {
			sb.append(UtilI18N.internacionaliza(request, "citcorpore.comum.resultado"));
		}

		document.executeScript("initReports(\"" + sb.toString() + "\", 'G');");
	}

	private void loadRelatoriosEspecificos(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		StringBuilder sb = new StringBuilder();
		UsuarioDTO usuario = WebUtil.getUsuario(request);

		Collection<BIConsultaDTO> biConsultaListDTO = getBIConsultaService().findByTipoModuloExibicao(TipoExibicaoRelatorio.ESPECIFICO.getIdentificador(),
				ModuloExibicaoRelatorio.GERENCIAMENTO_PROBLEMA.getIdentificador());

		if (biConsultaListDTO != null && !biConsultaListDTO.isEmpty()) {
			for (BIConsultaDTO biConsultaDTO : biConsultaListDTO) {
				sb.append("<a href='#' onclick='openReport(&#39;" + biConsultaDTO.getTipoConsulta() + "&#39;, " + biConsultaDTO.getIdConsulta() + ",&#39;" + biConsultaDTO.getNomeConsulta()
						+ "&#39;, &#39;E&#39;, ${idespecifico}); return false;'>" + biConsultaDTO.getNomeConsulta() + "</a><br/>");
			}
		}

		Collection<SmartReportDTO> listSmartReport = getSmartReportService().findByIdsGrupoUsuarioAndTipoModuloExibicao(usuario.getColGrupos(), TipoExibicaoRelatorio.ESPECIFICO.getIdentificador(),
				ModuloExibicaoRelatorio.GERENCIAMENTO_PROBLEMA.getIdentificador());

		if (listSmartReport != null && !listSmartReport.isEmpty()) {
			for (SmartReportDTO smartReportDTO : listSmartReport) {
				sb.append("<a href='#' onclick='UtilSmartReport.open(" + smartReportDTO.getIdSmartReport() + ", ${idespecifico}); return false;'>" + smartReportDTO.getIdentificacao() + "</a><br/>");
			}
		}

		if (sb.length() == 0) {
			sb.append(UtilI18N.internacionaliza(request, "citcorpore.comum.resultado"));
		}

		document.executeScript("initReports(\"" + sb.toString() + "\", 'E');");
	}

	private SmartReportService getSmartReportService() throws ServiceException {
		if (smartReportService == null) {
			smartReportService = (SmartReportService) ServiceLocator.getInstance().getService(SmartReportService.class, null);
		}
		return smartReportService;
	}

}