package br.com.centralit.citcorpore.ajaxForms;

import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import br.com.centralit.bpm.dto.ElementoFluxoDTO;
import br.com.centralit.bpm.dto.ItemTrabalhoFluxoDTO;
import br.com.centralit.bpm.dto.TarefaFluxoDTO;
import br.com.centralit.bpm.integracao.ItemTrabalhoFluxoDao;
import br.com.centralit.bpm.negocio.ItemTrabalho;
import br.com.centralit.bpm.util.Enumerated;
import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citajax.html.HTMLTable;
import br.com.centralit.citajax.util.CitAjaxWebUtil;
import br.com.centralit.citcorpore.bean.AcordoNivelServicoDTO;
import br.com.centralit.citcorpore.bean.AcordoServicoContratoDTO;
import br.com.centralit.citcorpore.bean.BIConsultaDTO;
import br.com.centralit.citcorpore.bean.BaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.CadastroTemplateIncidenteRequisicaoDTO;
import br.com.centralit.citcorpore.bean.CadastroTemplateIncidenteRequisicaoICDTO;
import br.com.centralit.citcorpore.bean.CategoriaServicoDTO;
import br.com.centralit.citcorpore.bean.CidadesDTO;
import br.com.centralit.citcorpore.bean.ClienteDTO;
import br.com.centralit.citcorpore.bean.ContratoDTO;
import br.com.centralit.citcorpore.bean.EmpregadoDTO;
import br.com.centralit.citcorpore.bean.ExecucaoSolicitacaoDTO;
import br.com.centralit.citcorpore.bean.FornecedorDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoServicosDTO;
import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.ImpactoDTO;
import br.com.centralit.citcorpore.bean.IntegranteViagemDTO;
import br.com.centralit.citcorpore.bean.ItemCfgSolicitacaoServDTO;
import br.com.centralit.citcorpore.bean.ItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.OrigemAtendimentoDTO;
import br.com.centralit.citcorpore.bean.ParamRecuperacaoTarefasDTO;
import br.com.centralit.citcorpore.bean.PrioridadeDTO;
import br.com.centralit.citcorpore.bean.RequisicaoViagemDTO;
import br.com.centralit.citcorpore.bean.RoteiroViagemDTO;
import br.com.centralit.citcorpore.bean.ServicoContratoDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.bean.SmartReportDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.UnidadeDTO;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citcorpore.bean.UrgenciaDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.integracao.AcordoNivelServicoDao;
import br.com.centralit.citcorpore.integracao.ExecucaoSolicitacaoDao;
import br.com.centralit.citcorpore.metainfo.bean.VisaoDTO;
import br.com.centralit.citcorpore.metainfo.negocio.VisaoService;
import br.com.centralit.citcorpore.negocio.AcordoNivelServicoService;
import br.com.centralit.citcorpore.negocio.AcordoServicoContratoService;
import br.com.centralit.citcorpore.negocio.BIConsultaService;
import br.com.centralit.citcorpore.negocio.BaseConhecimentoService;
import br.com.centralit.citcorpore.negocio.CadastroTemplateIncidenteRequisicaoICService;
import br.com.centralit.citcorpore.negocio.CadastroTemplateIncidenteRequisicaoService;
import br.com.centralit.citcorpore.negocio.CategoriaServicoService;
import br.com.centralit.citcorpore.negocio.CidadesService;
import br.com.centralit.citcorpore.negocio.ClienteService;
import br.com.centralit.citcorpore.negocio.ContratoService;
import br.com.centralit.citcorpore.negocio.ElementoFluxoService;
import br.com.centralit.citcorpore.negocio.EmpregadoService;
import br.com.centralit.citcorpore.negocio.ExecucaoSolicitacaoService;
import br.com.centralit.citcorpore.negocio.FornecedorService;
import br.com.centralit.citcorpore.negocio.GrupoService;
import br.com.centralit.citcorpore.negocio.IntegranteViagemService;
import br.com.centralit.citcorpore.negocio.ItemCfgSolicitacaoServService;
import br.com.centralit.citcorpore.negocio.ItemConfiguracaoService;
import br.com.centralit.citcorpore.negocio.OrigemAtendimentoService;
import br.com.centralit.citcorpore.negocio.PrioridadeSolicitacoesService;
import br.com.centralit.citcorpore.negocio.RequisicaoViagemService;
import br.com.centralit.citcorpore.negocio.RoteiroViagemService;
import br.com.centralit.citcorpore.negocio.ServicoContratoService;
import br.com.centralit.citcorpore.negocio.ServicoService;
import br.com.centralit.citcorpore.negocio.SmartReportService;
import br.com.centralit.citcorpore.negocio.SolicitacaoServicoService;
import br.com.centralit.citcorpore.negocio.UnidadeService;
import br.com.centralit.citcorpore.negocio.UsuarioService;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.ItensPorPagina;
import br.com.centralit.citcorpore.util.Enumerados.MatrizPrioridade;
import br.com.centralit.citcorpore.util.Enumerados.ModuloExibicaoRelatorio;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.Enumerados.ServiceDemandType;
import br.com.centralit.citcorpore.util.Enumerados.ServiceRequestStatus;
import br.com.centralit.citcorpore.util.Enumerados.SimNao;
import br.com.centralit.citcorpore.util.Enumerados.TipoAcordoContrato;
import br.com.centralit.citcorpore.util.Enumerados.TipoCatalogoServico;
import br.com.centralit.citcorpore.util.Enumerados.TipoDate;
import br.com.centralit.citcorpore.util.Enumerados.TipoExibicaoRelatorio;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.Util;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.centralit.citged.bean.ControleGEDDTO;
import br.com.centralit.citged.negocio.ControleGEDService;
import br.com.centralit.websocket.server.DashboardSolicitacoesWebSocketServlet;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.core.Page;
import br.com.citframework.integracao.core.PageRequest;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;
import br.com.citframework.util.UtilStrings;

/**
 * Controller da Pgina GerenciamentoServicos.jsp.
 */
@SuppressWarnings({ "rawtypes", "deprecation", "unchecked" })
public class GerenciamentoServicos2 extends AjaxFormAction {

	private GerenciamentoServicosDTO gerenciamentoServicosDTO = new GerenciamentoServicosDTO();
	private Set<ContratoDTO> hashContratos = new HashSet<ContratoDTO>();
	private ContratoService contratoService;
	private SolicitacaoServicoService solicitacaoServicoService;
	private ExecucaoSolicitacaoService execucaoSolicitacaoService;
	private ControleGEDService controleGedService;
	private OrigemAtendimentoService origemAtendimentoService;
	private ItemConfiguracaoService itemConfiguracaoService;
	private ItemCfgSolicitacaoServService itemCfgSolicitacaoServService;
	private ClienteService clienteService;
	private FornecedorService fornecedorService;
	private RequisicaoViagemService requisicaoViagemService;
	private BIConsultaService biConsultaService;
	private ServicoService servicoService;
	private GrupoService grupoService;
	private ElementoFluxoService elementoFluxoService;
	private UnidadeService unidadeService;
	private EmpregadoService empregadoService;
	private CategoriaServicoService categoriaServicoService;
	private ServicoContratoService servicoContratoService;
	private AcordoNivelServicoService acordoNivelServicoService;
	private AcordoServicoContratoService acordoServicoContratoService;
	private PrioridadeSolicitacoesService prioridadeSolicitacoesService;
	private BaseConhecimentoService baseConhecimentoService;
	private UsuarioService usuarioService;
	private CadastroTemplateIncidenteRequisicaoService cadastroTemplateIncidenteRequisicaoService;
	private CadastroTemplateIncidenteRequisicaoICService cadastroTemplateIncidenteRequisicaoICService;
	private VisaoService visaoService;
	private SmartReportService smartReportService;

	@Override
	public Class<GerenciamentoServicosDTO> getBeanClass() {
		return GerenciamentoServicosDTO.class;
	}

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		loadRelatorios(document, request, response);
		loadRelatoriosEspecificos(document, request, response);

		carregarItensFiltro(request);
		carregarTemplates(document, request, response);

		loadOpcoes(document, request, response);
		atualizarLista(document, request, response);
		
		if (request.getParameter("ServiceRequestID") != null) {
			this.pesquisarItensFiltro(document, request, response);
		}
	}

	public void loadOpcoes(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		HTMLSelect tipoVisualizacao = document.getSelectById("tipoVisualizacao");
		tipoVisualizacao.removeAllOptions();
		tipoVisualizacao.addOption("-1", UtilI18N.internacionaliza(request, "citcorpore.comum.todos"));
		tipoVisualizacao.addOption("possoExecutar", UtilI18N.internacionaliza(request, "gerenciamentoservico.possoExecutar"));
		tipoVisualizacao.addOption("possoVisualizar", UtilI18N.internacionaliza(request, "gerenciamentoservico.possoVisualizar"));

		HTMLSelect situacaoSla = document.getSelectById("situacaoSla");
		situacaoSla.removeAllOptions();
		situacaoSla.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.todos"));
		situacaoSla.addOption("vencido", UtilI18N.internacionaliza(request, "gerenciamentoservico.vencido"));
		situacaoSla.addOption("aguardandoAprovacao", UtilI18N.internacionaliza(request, "gerenciamentoservico.aguardandoAprovacao"));
		situacaoSla.addOption("avencer30min", UtilI18N.internacionaliza(request, "gerenciamentoservico.avencer30min"));
		situacaoSla.addOption("avencer60min", UtilI18N.internacionaliza(request, "gerenciamentoservico.avencer60min"));
		situacaoSla.addOption("avencer90min", UtilI18N.internacionaliza(request, "gerenciamentoservico.avencer90min"));
		situacaoSla.addOption("avencer2h", UtilI18N.internacionaliza(request, "gerenciamentoservico.avencer2h"));
		situacaoSla.addOption("avencer3h", UtilI18N.internacionaliza(request, "gerenciamentoservico.avencer3h"));
		situacaoSla.addOption("avencerHoje", UtilI18N.internacionaliza(request, "gerenciamentoservico.avencerHoje"));
		if (ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_CALENDARIO_PADRAO, null) != null) {
			situacaoSla.addOption("avencerProxDiaUtil", UtilI18N.internacionaliza(request, "gerenciamentoservico.avencerProxDiaUtil"));
		}

		HTMLSelect ordenarPor = document.getSelectById("ordenarPor");
		ordenarPor.removeAllOptions();
		ordenarPor.addOption("-1", UtilI18N.internacionaliza(request, "citcorpore.comum.todos"));
		ordenarPor.addOption("NSolicitacao", UtilI18N.internacionaliza(request, "gerenciamentoservico.NSolicitacao"));
		ordenarPor.addOption("servico", UtilI18N.internacionaliza(request, "gerenciamentoservico.servico"));
		ordenarPor.addOption("responsavel", UtilI18N.internacionaliza(request, "gerenciamentoservico.responsavel"));
		ordenarPor.addOption("prioridade", UtilI18N.internacionaliza(request, "gerenciamentoservico.prioridade"));
		ordenarPor.addOption("idStatus", UtilI18N.internacionaliza(request, "gerenciamentoservico.situacao"));
		ordenarPor.addOption("descricao", UtilI18N.internacionaliza(request, "gerenciamentoservico.descricao"));
		ordenarPor.addOption("dataHoraLimite", UtilI18N.internacionaliza(request, "gerenciamentoservico.dataHoraLimite"));
		ordenarPor.addOption("dataHoraLimiteCriacao", UtilI18N.internacionaliza(request, "gerenciamentoservico.dataHoraLimiteCriacao"));

		HTMLSelect idContrato = document.getSelectById("idContrato");
		idContrato.removeAllOptions();

		if (this.getHashContratos().size() < 1) {
			idContrato.addOption("-1", UtilI18N.internacionaliza(request, "citcorpore.comum.todos"));
		} else {
			idContrato.addOption("-1", UtilI18N.internacionaliza(request, "citcorpore.comum.todos"));

			if (this.getHashContratos().size() == 1) {
				Iterator iter = this.getHashContratos().iterator();
				ContratoDTO contratoDTO = (ContratoDTO) iter.next();

				idContrato.addOption(contratoDTO.getIdContrato().toString(), contratoDTO.getNome());
			} else {
				for (ContratoDTO element : this.getHashContratos()) {
					idContrato.addOption(element.getIdContrato().toString(), element.getNome());
				}
			}
		}

		HTMLSelect idTipo = document.getSelectById("idTipo");
		idTipo.removeAllOptions();
		idTipo.addOption("-1", UtilI18N.internacionaliza(request, "citcorpore.comum.todos"));

		for (ServiceDemandType serviceDemandType : ServiceDemandType.valuesWithoutOS()) {
			idTipo.addOption(String.valueOf(serviceDemandType.getId()), UtilI18N.internacionaliza(request, serviceDemandType.getI18NKey()));
		}

		HTMLSelect idGrupoAtual = document.getSelectById("idGrupoAtual");
		idGrupoAtual.removeAllOptions();
		idGrupoAtual.addOption("-1", UtilI18N.internacionaliza(request, "citcorpore.comum.todos"));
		idGrupoAtual.addOption("0", UtilI18N.internacionaliza(request, "citcorpore.comum.sematribuicao"));

		Collection<GrupoDTO> listGrupoExecutor = getGrupoService().getGruposByIdEmpregado(WebUtil.getUsuario(request).getIdEmpregado());
		if (listGrupoExecutor != null) {
			for (GrupoDTO element : listGrupoExecutor) {
				idGrupoAtual.addOption(element.getIdGrupo().toString(), element.getNome());
			}
		}

		HTMLSelect tarefaAtual = document.getSelectById("tarefaAtual");
		tarefaAtual.removeAllOptions();
		tarefaAtual.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.todos"));

		Collection<ElementoFluxoDTO> listTarefaAtual = getElementoFluxoService().listaElementoFluxo("");
		if (listTarefaAtual != null && !listTarefaAtual.isEmpty()) {
			for (ElementoFluxoDTO elementoFluxoDTO : listTarefaAtual) {
				if (elementoFluxoDTO.getDocumentacao() != null && !elementoFluxoDTO.getDocumentacao().isEmpty()) {
					tarefaAtual.addOption(elementoFluxoDTO.getDocumentacao(), elementoFluxoDTO.getDocumentacao());
				}
			}
		}

		HTMLSelect idStatus = document.getSelectById("idStatus");
		idStatus.removeAllOptions();
		idStatus.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.todos"));
		idStatus.addOption(ServiceRequestStatus.IN_PROGRESS.getId().toString(), UtilI18N.internacionaliza(request, ServiceRequestStatus.IN_PROGRESS.getI18NKey()));
		idStatus.addOption(ServiceRequestStatus.REOPENED.getId().toString(), UtilI18N.internacionaliza(request, ServiceRequestStatus.REOPENED.getI18NKey()));
		idStatus.addOption(ServiceRequestStatus.SOLVED.getId().toString(), UtilI18N.internacionaliza(request, ServiceRequestStatus.SOLVED.getI18NKey()));
		idStatus.addOption(ServiceRequestStatus.SUSPENDED.getId().toString(), UtilI18N.internacionaliza(request, ServiceRequestStatus.SUSPENDED.getI18NKey()));
		idStatus.addOption(ServiceRequestStatus.CANCELED.getId().toString(), UtilI18N.internacionaliza(request, ServiceRequestStatus.CANCELED.getI18NKey()));

		HTMLSelect itensPorPagina = document.getSelectById("itensPorPagina");
		itensPorPagina.removeAllOptions();

		for (ItensPorPagina valor : ItensPorPagina.values()) {
			itensPorPagina.addOption(valor.getValor().toString(), valor.getValor().toString());
		}

		Collection<GrupoDTO> listaGruposUsuario = getGrupoService().listGruposPorUsuario(usuario.getIdUsuario());
		for (GrupoDTO grupoDTO : listaGruposUsuario) {
			if (grupoDTO.getPermiteSuspensaoReativacao() != null && grupoDTO.getPermiteSuspensaoReativacao().equalsIgnoreCase("S")) {
				document.executeScript("$('.btn-suspender-reativar').removeClass('hide');");
				break;
			}
		}
	}

	/**
	 * Renderiza os Grficos da Guia Grficos da Tela de Gerenciamento de Servios.
	 *
	 * @param document
	 *            - DocumentHTML
	 * @param request
	 *            - HttpServletRequest
	 * @param response
	 *            - HttpServletResponse
	 * @throws Exception
	 */
	public void renderizarGraficos(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(request);

		if (usuario == null) {
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		this.setGerenciamentoServicosDTO((GerenciamentoServicosDTO) document.getBean());
		GerenciamentoServicosDTO gerenciamentoServicoDto = this.getGerenciamentoServicosDTO();
		List<TarefaFluxoDTO> colecao = (List<TarefaFluxoDTO>) listarTarefas(null, null, usuario, request, true, gerenciamentoServicoDto);

		HashMap<String, Object> mapGrupoAtual = new HashMap<String, Object>();
		document.getSelectById("idGrupoAtual").removeAllOptions();
		document.getSelectById("idGrupoAtual").addOption("", "-- " + UtilI18N.internacionaliza(request, "citcorpore.comum.todos") + " --");
		document.getSelectById("idGrupoAtual").addOption("", "-- " + UtilI18N.internacionaliza(request, "citcorpore.comum.sematribuicao") + " --");

		for (TarefaFluxoDTO tarefaDto : colecao) {
			SolicitacaoServicoDTO dtoSol = (SolicitacaoServicoDTO) tarefaDto.getSolicitacaoDto();
			if (dtoSol.getGrupoAtual() != null && StringUtils.isNotBlank(dtoSol.getGrupoAtual())) {
				if (!mapGrupoAtual.containsKey(dtoSol.getIdGrupoAtual().toString())) {
					String idGrupo = UtilStrings.removeCaracteresEspeciais(dtoSol.getIdGrupoAtual().toString());
					String nome = UtilStrings.removeCaracteresEspeciais(dtoSol.getGrupoAtual());
					mapGrupoAtual.put(UtilStrings.removeCaracteresEspeciais(dtoSol.getIdGrupoAtual().toString()), dtoSol.getGrupoAtual());
					document.getSelectById("idGrupoAtual").addOption(idGrupo, nome);
				}
			}
		}

		String tarefasStr = serializaTarefas(colecao, request);
		document.executeScript("exibirGraficos('" + tarefasStr + "');");
	}

	/**
	 * Serializa a Lista de Tarefas.
	 *
	 * @param colTarefas
	 *            - List<TarefaFluxoDTO>
	 * @param request
	 * @return String
	 * @throws Exception
	 */
	private String serializaTarefas(List<TarefaFluxoDTO> colTarefas, HttpServletRequest request) throws Exception {
		if (colTarefas == null) {
			return null;
		}

		for (TarefaFluxoDTO tarefaDto : colTarefas) {
			tarefaDto.setElementoFluxo_serialize(br.com.citframework.util.WebUtil.serializeObject(tarefaDto.getElementoFluxoDto(), WebUtil.getLanguage(request)));
			tarefaDto.setSolicitacao_serialize(br.com.citframework.util.WebUtil.serializeObject(tarefaDto.getSolicitacaoDto(), WebUtil.getLanguage(request)));
		}

		return br.com.citframework.util.WebUtil.serializeObjects(colTarefas, WebUtil.getLanguage(request));
	}

	public void exibirResumoSolicitacoes(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(request);

		if (usuario == null) {
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		renderizarResumoSolicitacoes(document, request);

		document.executeScript("JANELA_AGUARDE_MENU.hide()");
	}

	private void renderizarResumoSolicitacoes(DocumentHTML document, HttpServletRequest request) throws ServiceException, Exception {
		GerenciamentoServicosDTO gerenciamentoServicos = (GerenciamentoServicosDTO) document.getBean();
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		List<SolicitacaoServicoDTO> listSolicitacoes = this.recuperaSolicitacoesDoUsuarioComFiltro(document, request, gerenciamentoServicos);

		StringBuilder sb = new StringBuilder();
		HashMap HashMapSituacao = new HashMap();
		HashMap hashMapPrazoLimite = new HashMap();
		Integer qtdPrazoLimite = 0;
		Integer qtdTipoSolicitacao = 0;
		Integer qtdSituacao = 0;
		Integer qtdPrioridade = 0;

		hashMapPrazoLimite = resumoPorPrazoLimite(listSolicitacoes);
		Collection<PrioridadeDTO> colResumoPorPrioridade = resumoPorPrioridade(listSolicitacoes);
		Map<String, Integer> mapTipoSolicitacaoServico = resumoPorTipoSolicitacaoServico(listSolicitacoes);
		HashMapSituacao = resumoPorSituacao(listSolicitacoes);

		Integer quantidadeSolicitacoes = 0;
		for (Map.Entry<String, Integer> entry : mapTipoSolicitacaoServico.entrySet()) {
			if (entry.getValue() != null) {
				quantidadeSolicitacoes += entry.getValue() ;
			}
		}
		if (quantidadeSolicitacoes > 0) {
			String quantidadeSolicitacoesStr = String.valueOf(quantidadeSolicitacoes);
			document.getElementById("quantidadeSolicitacoes").setValue(quantidadeSolicitacoesStr);
		}

		HTMLElement tab3 = document.getElementById("tab-3");

		sb.append("<div class='tab-pane' id='tab3-3'> ");
		sb.append("	<div class='row-fluid'> ");
		sb.append("		<div class='span12'> ");
		sb.append("			<div class='row-fluid'> ");
		sb.append("				<div class='span6'>	");
		sb.append("					<div class='widget'> ");
		sb.append("						<div class='widget-head'> ");
		sb.append("							<h4 class='heading'><i></i>" + UtilI18N.internacionaliza(request, "solicitacaoServico.prazoLimite") + "</h4> ");
		sb.append("						</div> ");
		sb.append("						<div class='widget-body'> ");
		sb.append("							<table class='table table-bordered table-striped'> ");
		sb.append("								<tbody> ");
		for (Object resumo : hashMapPrazoLimite.entrySet()) {
			String resumoSTR = resumo.toString();
			String[] arrayResumo = resumoSTR.split("=");
			for (int i = 0; i < arrayResumo.length; i++) {
				if (i >= 1) {
					continue;
				}
				sb.append("									<tr> ");
				if (arrayResumo[0].equalsIgnoreCase("Prazo Normal")) {
					sb.append("										<td class='center'>" + UtilI18N.internacionaliza(request, "solicitacaoservico.prazonormal") + "</td> ");
				} else if (arrayResumo[0].equalsIgnoreCase("Prazo a Vencer")) {
					sb.append("										<td class='center'>" + UtilI18N.internacionaliza(request, "solicitacaoservico.prazoavencer") + "</td> ");
				} else if (arrayResumo[0].equalsIgnoreCase("Prazo Vencido")) {
					sb.append("										<td class='center'>" + UtilI18N.internacionaliza(request, "solicitacaoservico.prazovencido") + "</td> ");
				} else {
					sb.append("										<td class='center'>" + arrayResumo[0] + "</td> ");
				}
				sb.append("										<td>" + arrayResumo[1] + "</td> ");
				sb.append("									</tr> ");
				if (arrayResumo[1] != null) {
					qtdPrazoLimite += Integer.parseInt(arrayResumo[1]);
				}
			}
		}
		sb.append("										<td class='center'><h4 class='blue'><b>" + UtilI18N.internacionaliza(request, "pagamentoProjeto.total") + "</b></h4></td> ");
		sb.append("										<td><h4 class='blue'><b>" + qtdPrazoLimite + "</b></h4></td> ");
		sb.append("								</tbody> ");
		sb.append("							</table> ");
		sb.append("						</div> ");
		sb.append("					</div> ");
		sb.append("				</div> ");
		sb.append("				<div class='span6'>	");
		sb.append("					<div class='widget'> ");
		sb.append("						<div class='widget-head'> ");
		sb.append("							<h4 class='heading'><i></i>" + UtilI18N.internacionaliza(request, "solicitacaoServico.prioridade") + "</h4> ");
		sb.append("						</div> ");
		sb.append("						<div class='widget-body'> ");
		sb.append("							<table class='table table-bordered table-striped'> ");
		sb.append("								<tbody> ");
		for (PrioridadeDTO dto : colResumoPorPrioridade) {
			sb.append("									<tr> ");
			sb.append("										<td class='center'>" + dto.getNomePrioridade() + "</td> ");
			sb.append("										<td>" + dto.getQuantidade() + "</td> ");
			sb.append("									</tr> ");
			if (dto.getQuantidade() != null) {
				qtdPrioridade += dto.getQuantidade();
			}
		}
		sb.append("										<td class='center'><h4 class='blue'><b>" + UtilI18N.internacionaliza(request, "pagamentoProjeto.total") + "</b></h4></td> ");
		sb.append("										<td><h4 class='blue'><b>" + qtdPrioridade + "</b></h4></td> ");
		sb.append("								</tbody> ");
		sb.append("							</table> ");
		sb.append("						</div> ");
		sb.append("					</div> ");
		sb.append("				</div> ");
		sb.append("			</div> ");
		sb.append("		</div> ");
		sb.append("	</div> ");
		sb.append("	<div class='row-fluid'> ");
		sb.append("		<div class='span12'> ");
		sb.append("			<div class='row-fluid'> ");
		sb.append("				<div class='span6'>	");
		sb.append("					<div class='widget'> ");
		sb.append("						<div class='widget-head'> ");
		sb.append("							<h4 class='heading'><i></i>" + UtilI18N.internacionaliza(request, "solicitacaoServico.tipoSolicitacao") + "</h4> ");
		sb.append("						</div> ");
		sb.append("						<div class='widget-body'> ");
		sb.append("							<table class='table table-bordered table-striped'> ");
		sb.append("								<tbody> ");

		for (Map.Entry<String, Integer> tipoSolicitacaoServico : mapTipoSolicitacaoServico.entrySet()) {
			sb.append("									<tr> ");
			sb.append("										<td class='center'>" + UtilI18N.internacionaliza(request, tipoSolicitacaoServico.getKey()) + "</td> ");
			sb.append("										<td>" + tipoSolicitacaoServico.getValue() + "</td> ");
			sb.append("									</tr> ");
			if (tipoSolicitacaoServico.getValue() != null) {
				qtdTipoSolicitacao += tipoSolicitacaoServico.getValue();
			}
		}

		sb.append("										<td class='center'><h4 class='blue'><b>" + UtilI18N.internacionaliza(request, "pagamentoProjeto.total") + "</b></h4></td> ");
		sb.append("										<td><h4 class='blue'><b>" + qtdTipoSolicitacao + "</b></h4></td> ");
		sb.append("								</tbody> ");
		sb.append("							</table> ");
		sb.append("						</div> ");
		sb.append("					</div> ");
		sb.append("				</div> ");
		sb.append("				<div class='span6'>	");
		sb.append("					<div class='widget'> ");
		sb.append("						<div class='widget-head'> ");
		sb.append("							<h4 class='heading'><i></i>" + UtilI18N.internacionaliza(request, "solicitacaoServico.situacao") + "</h4> ");
		sb.append("						</div> ");
		sb.append("						<div class='widget-body'> ");
		sb.append("							<table class='table table-bordered table-striped'> ");
		sb.append("								<tbody> ");
		for (Enumerados.ServiceRequestStatus str : Enumerados.ServiceRequestStatus.values()) {
			if (HashMapSituacao.get(str) == null) {
				continue;
			}

			sb.append("									<tr> ");
			sb.append("										<td class='center'>" + UtilI18N.internacionaliza(request, str.getI18NKey()) + "</td> ");
			sb.append("										<td>" + HashMapSituacao.get(str) + "</td> ");
			sb.append("									</tr> ");

			qtdSituacao += (Integer) HashMapSituacao.get(str);
		}
		sb.append("										<td class='center'><h4 class='blue'><b>" + UtilI18N.internacionaliza(request, "pagamentoProjeto.total") + "</b></h4></td> ");
		sb.append("										<td><h4 class='blue'><b>" + qtdSituacao + "</b></h4></td> ");
		sb.append("								</tbody> ");
		sb.append("							</table> ");
		sb.append("						</div> ");
		sb.append("					</div> ");
		sb.append("				</div> ");
		sb.append("			</div> ");
		sb.append("		</div> ");
		sb.append("	</div> ");
		sb.append("</div> ");

		tab3.setInnerHTML(sb.toString());

	}

	/**
	 * Recupera todas as solicitaes do usurio com os filtros da tela.
	 *
	 * @author douglas.japiassu
	 * @since 12.08.2016
	 */
	public List<SolicitacaoServicoDTO> recuperaSolicitacoesDoUsuarioComFiltro(DocumentHTML document, HttpServletRequest request, GerenciamentoServicosDTO gerenciamentoServicos) throws ServiceException, Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(request);

		String COLABORADORES_VINC_CONTRATOS = ParametroUtil.getValorParametroCitSmartHashMap(br.com.centralit.citcorpore.util.Enumerados.ParametroSistema.COLABORADORES_VINC_CONTRATOS, "N");

		if (COLABORADORES_VINC_CONTRATOS == null) {
			COLABORADORES_VINC_CONTRATOS = "N";
		}

		Collection<ContratoDTO> listContratoUsuarioLogado = null;

		if (COLABORADORES_VINC_CONTRATOS != null && COLABORADORES_VINC_CONTRATOS.equalsIgnoreCase("S")) {
			listContratoUsuarioLogado = this.getContratoService().findAtivosByIdEmpregado(usuario.getIdEmpregado());
		} else {
			listContratoUsuarioLogado = this.getContratoService().listAtivos();
		}

		return getSolicitacaoServicoService(request).recuperaSolicitacoesPorUsuarioComFiltro(usuario, listContratoUsuarioLogado, gerenciamentoServicos);
	}

	private Map<String, Integer> resumoPorTipoSolicitacaoServico(List<SolicitacaoServicoDTO> listSolicitacoes) throws Exception {
		Map<String, Integer> mapTipoDemandaServico = new HashMap<>();
		mapTipoDemandaServico = this.getSolicitacaoServicoService(null).resumoTipoDemandaServico(listSolicitacoes);
		return mapTipoDemandaServico;
	}

	private Collection<PrioridadeDTO> resumoPorPrioridade(List<SolicitacaoServicoDTO> listSolicitacoes) throws Exception {
		Collection<PrioridadeDTO> colPrioridade = new ArrayList<PrioridadeDTO>();
		colPrioridade = this.getSolicitacaoServicoService(null).resumoPrioridade(listSolicitacoes);
		return colPrioridade;
	}

	private HashMap resumoPorPrazoLimite(List<SolicitacaoServicoDTO> listSolicitacoes) throws Exception {
		HashMap hashMap = new HashMap();
		hashMap = this.getSolicitacaoServicoService(null).resumoPorPrazoLimite(listSolicitacoes);
		return hashMap;
	}

	private HashMap resumoPorSituacao(List<SolicitacaoServicoDTO> listSolicitacoes) throws Exception {
		HashMap hashMap = new HashMap();
		hashMap = this.getSolicitacaoServicoService(null).resumoPorSituacao(listSolicitacoes);
		return hashMap;
	}

	public void carregarItensFiltro(HttpServletRequest request) throws Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			return;
		}

		Collection<ContratoDTO> listContratoDtoAtivo = null;

		String COLABORADORES_VINC_CONTRATOS = ParametroUtil.getValorParametroCitSmartHashMap(br.com.centralit.citcorpore.util.Enumerados.ParametroSistema.COLABORADORES_VINC_CONTRATOS, "N");
		if (COLABORADORES_VINC_CONTRATOS == null) {
			COLABORADORES_VINC_CONTRATOS = "N";
		}

		if (COLABORADORES_VINC_CONTRATOS != null && COLABORADORES_VINC_CONTRATOS.equalsIgnoreCase("S")) {
			listContratoDtoAtivo = this.getContratoService().findAtivosByIdEmpregado(usuario.getIdEmpregado());
		} else {
			listContratoDtoAtivo = this.getContratoService().listAtivos();
		}

		if (listContratoDtoAtivo != null && !listContratoDtoAtivo.isEmpty()) {

			for (ContratoDTO contratoDto : listContratoDtoAtivo) {

				String nomeCliente = "";
				String nomeFornecedor = "";

				ClienteDTO clienteDto = new ClienteDTO();

				clienteDto.setIdCliente(contratoDto.getIdCliente());

				clienteDto = (ClienteDTO) this.getClienteService().restore(clienteDto);

				if (clienteDto != null) {
					nomeCliente = clienteDto.getNomeRazaoSocial();
				}

				FornecedorDTO fornecedorDto = new FornecedorDTO();

				fornecedorDto.setIdFornecedor(contratoDto.getIdFornecedor());

				fornecedorDto = (FornecedorDTO) this.getFornecedorService().restore(fornecedorDto);

				if (fornecedorDto != null) {
					nomeFornecedor = fornecedorDto.getRazaoSocial();
				}

				String nomeContrato = "" + contratoDto.getNumero() + " de " + UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, contratoDto.getDataContrato(), WebUtil.getLanguage(request)) + " (" + nomeCliente + " - " + nomeFornecedor + ")";

				contratoDto.setNome(nomeContrato);

				getHashContratos().add(contratoDto);
			}
		}
	}

	/**
	 * Atualiza e recarrega a lista de solicitaes de servios
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	public void atualizarLista(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		UsuarioDTO usuario = WebUtil.getUsuario(request);

		if (usuario == null) {
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		this.setGerenciamentoServicosDTO((GerenciamentoServicosDTO) document.getBean());
		String paginaselecionada = document.getElementById("paginaselecionada").getValue();
		if (paginaselecionada != null) {
			this.getGerenciamentoServicosDTO().setPaginaSelecionada(Integer.parseInt(paginaselecionada));
		}

		this.recarregarLista(document, request, response);

		/**
		 * A linha foi adicionada porque estava fechando o modal e o load antes de recarregar a grid de solicitao. assim ele so vai fechar o modal depois que carregar a grid.
		 *
		 * @author maycon.fernandes
		 * @since 25/10/2013 14:35
		 */
		document.executeScript("fecharModal()");
	}

	public void atualizacaoAutomatica(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(request);

		if (usuario == null) {
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		this.setGerenciamentoServicosDTO((GerenciamentoServicosDTO) document.getBean());
		String paginaselecionada = document.getElementById("paginaselecionada").getValue();
		if (paginaselecionada != null) {
			this.getGerenciamentoServicosDTO().setPaginaSelecionada(Integer.parseInt(paginaselecionada));
		}

		this.recarregarLista(document, request, response);

		document.executeScript("refreshView()");
	}

	/**
	 * FireEvent chamado para recarregar a Lista de Solicitao de Servio de acordo com o Pgina Selecionada.
	 *
	 * @param document
	 *            - DocumentHTML
	 * @param request
	 *            - HttpServletRequest
	 * @param response
	 *            - HttpServletResponse
	 * @throws Exception
	 * @author valdoilo.damasceno
	 * @since 27.01.2015. Melhoria implementada na Operao Usain Bolt
	 */
	public void recarregarLista(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuarioLogado = WebUtil.getUsuario(request);

		if (usuarioLogado == null) {
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		GerenciamentoServicosDTO gerenciamentoServicosDTO = (GerenciamentoServicosDTO) document.getBean();

		StringBuilder sb = new StringBuilder();

		Integer itensPorPagina = gerenciamentoServicosDTO.getItensPorPagina() == null ? 5 : gerenciamentoServicosDTO.getItensPorPagina();

		Integer paginaSelecionada = gerenciamentoServicosDTO.getPaginaSelecionada();

		if (paginaSelecionada == null) {
			paginaSelecionada = 1;
		}

		Integer tipoLista = gerenciamentoServicosDTO.getTipoLista() == null ? 1 : gerenciamentoServicosDTO.getTipoLista();

		/** O mtodo atualizarListaTarefasAndReturnTotalPaginas unificou as funcionalidades dos mtodos atualizaListaTarefas e totalPaginas. Operao Usain Bolt. valdoilo.damasceno */
		Pageable pageable = new PageRequest(paginaSelecionada - 1, itensPorPagina);
		Integer totalPaginasFinal = this.getExecucaoSolicitacaoService().atualizarListaTarefasAndReturnTotalPaginas(usuarioLogado, this.getGerenciamentoServicosDTO(), pageable);

		renderizarLista(sb, request, itensPorPagina, paginaSelecionada, false, tipoLista);

		/**
		 * Alterado: Mrio Motivo: Invertendo as posies para quantificar o total de pginas e definir no objeto de gerenciamentoDto Autor: flavio.santana Data/Hora: 13/11/2013
		 */
		paginaSelecionada = totalPaginasFinal == 1 ? 1 : paginaSelecionada;

		HTMLElement contentSolicitacao = document.getElementById("content-solicitacao");

		if (sb != null && !sb.toString().isEmpty()) {
			contentSolicitacao.setInnerHTML(sb.toString());
		} else {
			contentSolicitacao.setInnerHTML("<div class='center'>" + UtilI18N.internacionaliza(request, "citcorpore.comum.resultado") + "</div>");
		}

		document.executeScript("inicializaPopover()");

		carregarItensPaginacao(document, request, totalPaginasFinal);

		loadRelatoriosEspecificos(document, request, response);

		HTMLForm form = document.getForm("formGerenciamento");
		form.setValues(gerenciamentoServicosDTO);

		document.executeScript("fechaJanelaAguarde()");
	}

	/**
	 * Responsvel por renderizar a listagem de Solicitaes na tela de Gerenciamento de Servios.
	 *
	 * @param sb
	 * @param request
	 * @param itensPorPagina
	 * @param paginaSelecionada
	 * @param flag
	 * @param tipoLista
	 * @throws Exception
	 */
	public void renderizarLista(StringBuilder sb, HttpServletRequest request, Integer itensPorPagina, Integer paginaSelecionada, boolean flag, Integer tipoLista) throws Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(request);
		GerenciamentoServicosDTO gerenciamentoServicoDto = this.getGerenciamentoServicosDTO();

		String language = (String) request.getSession().getAttribute("locale");

		Collection<TarefaFluxoDTO> listTarefaSolicitacaoServico = this.listarTarefas(itensPorPagina, paginaSelecionada, usuario, request, false, gerenciamentoServicoDto);

		String locale = (String) request.getSession().getAttribute("locale");
		if (locale == null) {
			locale = "pt";
		}

		if (listTarefaSolicitacaoServico != null && !listTarefaSolicitacaoServico.isEmpty()) {

			for (TarefaFluxoDTO tarefaFluxoDto : listTarefaSolicitacaoServico) {
				SolicitacaoServicoDTO solicitacaoServicoDto = (SolicitacaoServicoDTO) tarefaFluxoDto.getSolicitacaoDto();

				StringBuilder htmlRequisicaoViagem = null;
				RequisicaoViagemDTO requisicaoViagem = getRequisicaoViagemService(request).recuperaRequisicaoPelaSolicitacao(solicitacaoServicoDto.getIdSolicitacaoServico());

				if (requisicaoViagem != null) {
					htmlRequisicaoViagem = new StringBuilder();

					RoteiroViagemService roteiroViagemService = (RoteiroViagemService) ServiceLocator.getInstance().getService(RoteiroViagemService.class, null);
					CidadesService cidadeService = (CidadesService) ServiceLocator.getInstance().getService(CidadesService.class, null);
					IntegranteViagemService integranteViagemService = (IntegranteViagemService) ServiceLocator.getInstance().getService(IntegranteViagemService.class, null);

					RoteiroViagemDTO roteiroViagemDTO = null;
					CidadesDTO origem = null;
					CidadesDTO destino = null;

					Collection<IntegranteViagemDTO> colIntegrantes = integranteViagemService.recuperaIntegrantesViagemByIdSolicitacao(requisicaoViagem.getIdSolicitacaoServico());

					NumberFormat nf = NumberFormat.getCurrencyInstance(new Locale("pt", "BR"));
					DecimalFormat decimal = (DecimalFormat) nf;
					decimal.applyPattern("#,##0.00");

					htmlRequisicaoViagem.append("<b>Requisio de viagem:</b><br>");
					htmlRequisicaoViagem.append(requisicaoViagem.getDescricaoMotivo());
					htmlRequisicaoViagem.append("<br><br>");
					htmlRequisicaoViagem.append("<b>Integrantes:</b>");

					if (colIntegrantes != null) {

						for (IntegranteViagemDTO integrante : colIntegrantes) {
							roteiroViagemDTO = roteiroViagemService.findByIdIntegrante(integrante.getIdIntegranteViagem());
							origem = (CidadesDTO) ((List) cidadeService.findNomeByIdCidade(roteiroViagemDTO.getOrigem())).get(0);
							destino = (CidadesDTO) ((List) cidadeService.findNomeByIdCidade(roteiroViagemDTO.getDestino())).get(0);

							htmlRequisicaoViagem.append("<ul>");
							htmlRequisicaoViagem.append("<li>");
							htmlRequisicaoViagem.append("<span>" + integrante.getNome()).append(" - ida ").append(UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, roteiroViagemDTO.getIda(), UtilI18N.getLocale(request))).append(" - volta ").append(UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, roteiroViagemDTO.getVolta(), UtilI18N.getLocale(request))).append(" - ")
									.append(origem.getNomeCidade()).append("/").append(origem.getNomeUf()).append(" - ").append(destino.getNomeCidade()).append("/").append(destino.getNomeUf()).append("</span>");
							htmlRequisicaoViagem.append("</li>").append("</ul>");
						}
					}
				}

				// Faz o clculo da SLA
				String hh = "";
				String mm = "";
				if (solicitacaoServicoDto.getIdContrato() != null || solicitacaoServicoDto.getIdServico() != null) {

					hh = solicitacaoServicoDto.getPrazoHH().toString();
					mm = solicitacaoServicoDto.getPrazoMM().toString();
					/**
					 * Se os minutos forem 60, corrige o tempo
					 *
					 * @author thyen.chang
					 * @since 03/03/2015
					 */
					if (mm.equals("60")) {
						mm = "00";
						hh = new Integer(Integer.parseInt(hh) + 1).toString();
					}

					if (hh.length() == 1) {
						hh = "0" + hh;
					}
					if (mm.length() == 1) {
						mm = "0" + mm;
					}

				}

				String cssPrioridade = setarCssPrioridade(solicitacaoServicoDto.getPrioridade());
				String cssPrazo = setarCssPrazo(solicitacaoServicoDto);
				String HTMLprazo = setarHtmlPrazo(solicitacaoServicoDto, request);
				String situacaoSLA = "";
				if (solicitacaoServicoDto.getSituacaoSLA().equalsIgnoreCase("N")) {
					situacaoSLA = UtilI18N.internacionaliza(locale, "citcorpore.comum.naoIniciado");
				} else if (solicitacaoServicoDto.getSituacaoSLA().equalsIgnoreCase("S")) {
					situacaoSLA = UtilI18N.internacionaliza(locale, "citcorpore.comum.suspenso");
				}

				sb.append("<div class=\"box-generic\">");
				sb.append(HTMLprazo);

				sb.append("<div class=\"content-row\">");
				sb.append("	<div class=\"content-item\">");
				sb.append("		<h5>" + UtilI18N.internacionaliza(locale, "citcorpore.comum.numero") + "</h5>");
				sb.append("		<span>" + solicitacaoServicoDto.getIdSolicitacaoServico() + "</span>");
				sb.append("	</div>");
				sb.append("	<div class=\"content-item\">");
				sb.append("		<h5>" + UtilI18N.internacionaliza(locale, "citcorpore.comum.tipo") + "</h5>");
				sb.append("		<span class=\"" + ( ServiceDemandType.INCIDENT.equals(ServiceDemandType.fromId(solicitacaoServicoDto.getIdTipoDemandaServico())) ? "incidente" : "verde-negrito") + "\">");
				sb.append("		").append(UtilI18N.internacionaliza(request, ServiceDemandType.chaveFromId(solicitacaoServicoDto.getIdTipoDemandaServico())));
				sb.append("		</span>");
				sb.append("	</div>");
				sb.append("	<div class=\"content-item labelOverflowTresPontinhos max-width-300\">");
				sb.append("		<h5>" + UtilI18N.internacionaliza(locale, "citcorpore.comum.solicitacao") + "</h5>");
				sb.append("		<span class=\"servico\" title=\"" + solicitacaoServicoDto.getNomeServico() + "\">" + solicitacaoServicoDto.getNomeServico() + "</span>");
				sb.append("	</div>");

				sb.append("	<div class=\"content-item\">");
				sb.append("		<h5>" + UtilI18N.internacionaliza(locale, "tempoAtendimento.descTempoAtendimento") + "</h5>");
				if ((solicitacaoServicoDto.getPrazoHH().equals(0) || solicitacaoServicoDto.getPrazoHH() == null) && (solicitacaoServicoDto.getPrazoMM().equals(0) || solicitacaoServicoDto.getPrazoMM() == null) && !ServiceRequestStatus.SUSPENDED.getId().equals(solicitacaoServicoDto.getIdStatus())) {
					sb.append("		<span class=\"\">" + UtilI18N.internacionaliza(locale, "citcorpore.comum.aCombinar") + "</span>");
				} else if (!hh.equals("") && !mm.equals("") && !ServiceRequestStatus.SUSPENDED.getId().equals(solicitacaoServicoDto.getIdStatus())) {
					sb.append("		<span class= \"" + cssPrazo + "\"> " + hh + ":" + mm + " " + situacaoSLA + "</span>");
				} else {
					sb.append("		<span class= \"" + cssPrazo + "\"></span>");
				}
				sb.append("	</div>");

				if (!ServiceRequestStatus.SUSPENDED.getId().equals(solicitacaoServicoDto.getIdStatus())) {
					if (!solicitacaoServicoDto.getSituacaoSLA().equalsIgnoreCase("S") || solicitacaoServicoDto.getAtrasoSLA() > 0) {
						sb.append("	<div class=\"content-item\">");
						sb.append("		<h5>" + UtilI18N.internacionaliza(locale, "solicitacaoServico.prazoLimite") + "</h5>");
						sb.append("		<span class=\"" + cssPrazo + "\">" + UtilStrings.nullToVazio(solicitacaoServicoDto.obterDataHoraLimiteStrWithLanguage(language)) + "</span>");
						sb.append("	</div>");
					}
				}

				if (solicitacaoServicoDto.getAtrasoSLA() > 0 && !ServiceRequestStatus.SUSPENDED.getId().equals(solicitacaoServicoDto.getIdStatus())) {
					sb.append("	<div class=\"content-item\">");
					sb.append("		<h5>" + UtilI18N.internacionaliza(locale, "tarefa.atraso") + "</h5>");
					sb.append("		<span class=\"" + cssPrazo + "\">" + solicitacaoServicoDto.getAtrasoSLAStr() + "</span>");
					sb.append("	</div>");
				}

				sb.append("	<div class=\"content-item\">");
				sb.append("		<h5>" + UtilI18N.internacionaliza(locale, "solicitacaoServico.prioridade") + "</h5>");
				sb.append("		<span class=\"" + cssPrioridade + "\">" + solicitacaoServicoDto.getPrioridade() + "</span>");
				sb.append("	</div>");

				String strDocumentacao = tarefaFluxoDto != null && tarefaFluxoDto.getElementoFluxoDto() != null && tarefaFluxoDto.getElementoFluxoDto().getDocumentacao() != null ? tarefaFluxoDto.getElementoFluxoDto().getDocumentacao() : "";

				if (strDocumentacao != null && !strDocumentacao.isEmpty()) {
					sb.append("	<div class=\"content-item\">");
					sb.append("		<h5>" + UtilI18N.internacionaliza(locale, "solicitacaoServico.tarefaatual.desc") + "</h5>");
					sb.append("		<span>" + strDocumentacao + "</span>");
					sb.append("	</div>");
				}

				if (tarefaFluxoDto.getResponsavelAtual() != null && !tarefaFluxoDto.getResponsavelAtual().isEmpty()) {
					sb.append("	<div class=\"content-item labelOverflowTresPontinhos max-width-300\">");
					sb.append("		<h5>" + UtilI18N.internacionaliza(locale, "citcorpore.comum.responsavel") + "</h5>");
					sb.append("		<span>" + tarefaFluxoDto.getResponsavelAtual() + "</span>");
					sb.append("	</div>");
				}

				sb.append("	<div class=\"content-item\">");
				sb.append("		<h5>" + UtilI18N.internacionaliza(locale, "solicitacaoServico.situacao") + "</h5>");
				sb.append("		<span>" + UtilI18N.internacionaliza(request, ServiceRequestStatus.getChaveFromId(solicitacaoServicoDto.getIdStatus())) + "</span>");
				sb.append("	</div>");

				sb.append("	<div class=\"content-item labelOverflowTresPontinhos max-width-300\">");
				sb.append("		<h5>" + UtilI18N.internacionaliza(locale, "requisitosla.contrato") + "</h5>");
				sb.append("		<span title=\"" + solicitacaoServicoDto.getContrato() + "\">" + solicitacaoServicoDto.getContrato() + "</span>");
				sb.append("	</div>");

				sb.append("	<div class=\"content-item\">");
				sb.append("		<h5>" + UtilI18N.internacionaliza(locale, "solicitacaoServico.dataHoraCriacao") + "</h5>");
				sb.append("		<span class=\"verde-negrito\">" + solicitacaoServicoDto.obterDataHoraSolicitacaoStrWithLanguage(language) + "</span>");
				sb.append("	</div>");

				sb.append("	<div class=\"content-item labelOverflowTresPontinhos max-width-300\">");
				sb.append("		<h5>" + UtilI18N.internacionaliza(locale, "citcorpore.comum.criadopor") + "</h5>");
				sb.append("		<span title=\"" + solicitacaoServicoDto.getResponsavel() + "\">" + solicitacaoServicoDto.getResponsavel() + "</span>");
				sb.append("	</div>");

				sb.append("	<div class=\"content-item labelOverflowTresPontinhos max-width-300\">");
				sb.append("		<h5><div class=\"pull-left\">" + UtilI18N.internacionaliza(locale, "solicitacaoServico.solicitante") + "</div><span data-content=\"");

				if (solicitacaoServicoDto.getEmailcontato() != null && !solicitacaoServicoDto.getEmailcontato().trim().isEmpty()) {
					sb.append("<span>" + UtilI18N.internacionaliza(locale, "citcorpore.comum.email") + ": " + solicitacaoServicoDto.getEmailcontato() + "</span><br/>");
				}

				if (solicitacaoServicoDto.getTelefonecontato() != null && !solicitacaoServicoDto.getTelefonecontato().trim().isEmpty()) {
					sb.append("<span>" + UtilI18N.internacionaliza(locale, "citcorpore.comum.telefone") + ": " + solicitacaoServicoDto.getTelefonecontato() + "</span>");
				}

				sb.append("\" class=\"pull-right informacoesSolicitante\" data-toggle=\"popover\"><i class=\"material-icons md-16\">info</i></span><div class='clearfix'></div></h5>");
				sb.append("		<span title=\"" + solicitacaoServicoDto.getSolicitanteUnidade() + "\">" + solicitacaoServicoDto.getSolicitanteUnidade() + "</span>");
				sb.append("	</div>");

				if (solicitacaoServicoDto.getGrupoAtual() != null && !solicitacaoServicoDto.getGrupoAtual().isEmpty()) {
					sb.append("	<div class=\"content-item\">");
					sb.append("		<h5>" + UtilI18N.internacionaliza(locale, "citcorpore.comum.grupoExecutor") + "</h5>");
					sb.append("		<span>" + solicitacaoServicoDto.getGrupoAtual() + "</span>");
					sb.append("	</div>");
				}

				if (solicitacaoServicoDto.getQtdefilhas() != null && !solicitacaoServicoDto.getQtdefilhas().equals(0)) {
					sb.append("	<div class=\"content-item\">");
					sb.append("		<h5>" + UtilI18N.internacionaliza(locale, "gerenciaservico.solicitacoesRelacionadas") + "</h5>");
					sb.append("		<a href=\"javascript: return false;\" class=\"no-decoration\" onclick=\"modalSolicitacoesFilhas(" + solicitacaoServicoDto.getIdSolicitacaoServico() + ");\">" + solicitacaoServicoDto.getQtdefilhas() + " "
							+ (solicitacaoServicoDto.getQtdefilhas() == 1 ? UtilI18N.internacionaliza(locale, "citcorpore.comum.solicitacao") : UtilI18N.internacionaliza(locale, "gerenciaservico.solicitacoes")) + "</a>");
					sb.append("	</div>");
				}

				if (solicitacaoServicoDto.getIdSolicitacaoRelacionada() != null) {
					sb.append("	<div class=\"content-item\">");
					sb.append("		<h5>" + UtilI18N.internacionaliza(locale, "gerenciaservico.solicitacaoOrigem") + "</h5>");
					sb.append("		<a href=\"javascript: return false;\" class=\"verde-negrito no-decoration\" onclick=\"visualizarSolicitacaoPaiEnvioDoAction(" + solicitacaoServicoDto.getIdSolicitacaoRelacionada() + ")\">" + solicitacaoServicoDto.getIdSolicitacaoRelacionada() + "</a>");
					sb.append("	</div>");
				}

				if (tarefaFluxoDto.getCompartilhamento() != null && !tarefaFluxoDto.getCompartilhamento().trim().equals("")) {
					sb.append("	<div class=\"content-item\">");
					sb.append("		<h5>" + UtilI18N.internacionaliza(locale, "tarefa.compartilhadacom") + "</h5>");
					sb.append("		<span>" + tarefaFluxoDto.getCompartilhamento() + "</span>");
					sb.append("	</div>");
				}

				sb.append("	<div class=\"clearfix\"></div>");
				sb.append("</div>");
				sb.append("<div class=\"separator bottom\"></div>");

				sb.append("<div class=\"row-fluid\">");
				sb.append("	<div class=\"span3\">");
				sb.append("		<button type=\"button\" class=\"btn btn-default solicitacao-mostrar-mais-detalhes\"><i class=\"material-icons md-16\">expand_more</i></button>");

				if (solicitacaoServicoDto.getQtdeItensConfiguracaoRelacionados() != null && solicitacaoServicoDto.getQtdeItensConfiguracaoRelacionados() > 0) {
					sb.append("		<button type=\"button\" class=\"btn btn-default\" onclick='pesquisarItensDeConfiguracaoRelacionados(\"" + solicitacaoServicoDto.getIdSolicitacaoServico() + "\");' title=\"" + UtilI18N.internacionaliza(request, "itemConfiguracaoTree.itensConfiguracao") + "\"><span class=\"count-label\">" + solicitacaoServicoDto.getQtdeItensConfiguracaoRelacionados()
							+ "</span><i class=\"material-icons md-16 pull-right\">devices</i></button>");
				}

				if (solicitacaoServicoDto.getQtdeAnexos() == null) {
					solicitacaoServicoDto.setQtdeAnexos(new Integer(0));
					Collection colAnexos = this.getControleGedService().listByIdTabelaAndID(ControleGEDDTO.TABELA_SOLICITACAOSERVICO, solicitacaoServicoDto.getIdSolicitacaoServico());
					if (colAnexos != null) {
						solicitacaoServicoDto.setQtdeAnexos(colAnexos.size());
					}
				}

				if (solicitacaoServicoDto.getQtdeAnexos() > 0) {
					sb.append("		<button type=\"button\" class=\"btn btn-default\" onclick='pesquisarAnexos(\"" + solicitacaoServicoDto.getIdSolicitacaoServico() + "\");' title=\"" + UtilI18N.internacionaliza(request, "solicitacaoServico.possuiAnexo") + "\"><span class=\"count-label\">" + solicitacaoServicoDto.getQtdeAnexos()
							+ "</span><i class=\"material-icons md-16 pull-right\">attach_file</i></button>");
				}

				sb.append("	</div>");
				sb.append("	<div class=\"span9 text-right\">");
				sb.append("		<button type=\"button\" class=\"btn btn-default gir-relatorios-especificos\" data-idespecifico='" + solicitacaoServicoDto.getIdSolicitacaoServico()
						+ "' onclick=\"javascript:return false;\" tabindex=\"0\" data-toggle=\"popover\" data-trigger=\"focus\" data-container=\"body\" data-placement=\"left\" data-html=\"true\" data-content=\"\" data-title=\"Relatrios\" data-original-title=\"\" title="
						+ UtilI18N.internacionaliza(locale, "menu.nome.relatorio") + "><i class=\"material-icons md-16\">equalizer</i></button>");

				if (requisicaoViagem == null) {
					sb.append("		<button type=\"button\" class=\"btn btn-default\" title=\"" + UtilI18N.internacionaliza(locale, "citcorpore.comum.descricao") + "\" onclick='chamarModalDescricaoSolicitacao(\"" + StringEscapeUtils.escapeJavaScript(StringEscapeUtils.escapeHtml(solicitacaoServicoDto.getDescricao())) + "\"," + solicitacaoServicoDto.getIdSolicitacaoServico()
							+ " )'><i class=\"material-icons md-16\">description</i></button>");
				} else {
					sb.append("		<button type=\"button\" class=\"btn btn-default\" title=\"" + UtilI18N.internacionaliza(locale, "citcorpore.comum.descricao") + "\" onclick='chamarModalDescricaoSolicitacao(\"" + htmlRequisicaoViagem.toString().replace("\"", "'") + "\"," + solicitacaoServicoDto.getIdSolicitacaoServico() + " )'><i class=\"material-icons md-16\">description</i></button>");
				}

				sb.append("		<button type=\"button\" class=\"btn btn-default\" title=\"" + UtilI18N.internacionaliza(locale, "gerenciaservico.visualizar") + "\" onclick=\"visualizarSolicitacao(" + solicitacaoServicoDto.getIdSolicitacaoServico() + "," + tarefaFluxoDto.getIdItemTrabalho() + ")\"><i class=\"material-icons md-16\">visibility</i></button>");

				if (tarefaFluxoDto.getExecutar().equals("S") && !ServiceRequestStatus.SUSPENDED.getId().equals(solicitacaoServicoDto.getIdStatus())) {
					sb.append("		<button type=\"button\" class=\"btn btn-default\" onclick='prepararExecucaoTarefa(" + tarefaFluxoDto.getIdItemTrabalho() + "," + solicitacaoServicoDto.getIdSolicitacaoServico() + ",\"E\");'>" + UtilI18N.internacionaliza(locale, "citcorpore.comum.executar") + "</button>");
				}

				if (tarefaFluxoDto.getExecutar().equals("S") && !tarefaFluxoDto.getResponsavelAtual().trim().equals(usuario.getNomeUsuario().trim()) && !ServiceRequestStatus.SUSPENDED.getId().equals(solicitacaoServicoDto.getIdStatus())) {
					sb.append("		<button type=\"button\" class=\"btn btn-default\" onclick='capturarTarefa(\"" + tarefaFluxoDto.getResponsavelAtual() + "\"," + tarefaFluxoDto.getIdItemTrabalho() + ");'>" + UtilI18N.internacionaliza(locale, "gerenciaservico.capturartarefa") + "</button>");
				}

				sb.append("		<div class=\"btn-group solicitacao-mais-opcoes dropup\">");
				sb.append("			<div class=\"leadcontainer\">");
				sb.append("				<button type=\"button\" class=\"btn dropdown-lead btn-default\" onclick=\"abrirMaisOpcoes(this);\">" + UtilI18N.internacionaliza(locale, "bi.painelControle.conexao.maisOpcoes") + "</button>");
				sb.append("			</div>");
				sb.append("			<a class=\"btn btn-default dropdown-toggle\" data-toggle=\"dropdown\" href=\"#\"><span class=\"caret\"></span> </a>");
				sb.append("			<ul class=\"dropdown-menu pull-right text-left \">");

				if (tarefaFluxoDto.getDelegar().equals("S") && !ServiceRequestStatus.SUSPENDED.getId().equals(solicitacaoServicoDto.getIdStatus())) {
					sb.append("			<li onclick='exibirDelegacaoTarefa(" + tarefaFluxoDto.getIdItemTrabalho() + "," + solicitacaoServicoDto.getIdSolicitacaoServico() + ",\"" + tarefaFluxoDto.getElementoFluxoDto().getDocumentacao() + "\");'><a >" + UtilI18N.internacionaliza(locale, "citcorpore.comum.delegar") + "</a></li>");
				}

				if (tarefaFluxoDto.getSuspender().equals("S") && !ServiceRequestStatus.SUSPENDED.getId().equals(solicitacaoServicoDto.getIdStatus())) {
					sb.append("			<li onclick='prepararSuspensao(" + tarefaFluxoDto.getIdItemTrabalho() + "," + solicitacaoServicoDto.getIdSolicitacaoServico() + ")'><a >" + UtilI18N.internacionaliza(locale, "citcorpore.comum.suspender") + "</a></li>");
				}

				if (ServiceRequestStatus.IN_PROGRESS.getId().equals(solicitacaoServicoDto.getIdStatus())) {
					sb.append("  		<li onclick='adicionarIdContratoNaLookup(" + solicitacaoServicoDto.getIdContrato() + ");carregarModalDuplicarSolicitacao(" + solicitacaoServicoDto.getIdSolicitacaoServico() + ");montaParametrosAutocompleteSol(" + solicitacaoServicoDto.getIdContrato() + ")';><a >" + UtilI18N.internacionaliza(locale, "gerenciaservico.duplicarSolicitacao") + "</a></li>");
				}

				sb.append("  		<li onclick='exibirSubSolicitacoes(" + solicitacaoServicoDto.getIdSolicitacaoServico() + ")';><a >" + UtilI18N.internacionaliza(locale, "gerenciaservico.exibirsubsolicitacoes") + "</a></li>");
				sb.append("			<li class='divider'></li>");

				if (tarefaFluxoDto.getReativar().equals("S") && ServiceRequestStatus.SUSPENDED.getId().equals(solicitacaoServicoDto.getIdStatus())) {
					sb.append("			<li onclick='reativarSolicitacao(" + tarefaFluxoDto.getIdItemTrabalho() + "," + solicitacaoServicoDto.getIdSolicitacaoServico() + ")'><a >" + UtilI18N.internacionaliza(locale, "gerenciaservico.reativarsolicitacao") + "</a></li>");
				}

				if (tarefaFluxoDto.getAlterarSLA().equals("S") && !ServiceRequestStatus.SUSPENDED.getId().equals(solicitacaoServicoDto.getIdStatus()) && !solicitacaoServicoDto.getSituacaoSLA().equals(Enumerados.SituacaoSLA.S.toString()) && !solicitacaoServicoDto.getSituacaoSLA().equals(Enumerados.SituacaoSLA.N.toString())) {
					sb.append("			<li onclick='prepararMudancaSLA(" + tarefaFluxoDto.getIdItemTrabalho() + ", " + solicitacaoServicoDto.getIdSolicitacaoServico() + ")'><a >" + UtilI18N.internacionaliza(locale, "citcorpore.comum.alterarSLA") + "</a></li>");
				}

				if (tarefaFluxoDto.getAlterarSLA().equals("S") && !ServiceRequestStatus.SUSPENDED.getId().equals(solicitacaoServicoDto.getIdStatus())) {
					sb.append("			<li onclick='reclassificarSolicitacao(" + tarefaFluxoDto.getIdItemTrabalho() + ", " + solicitacaoServicoDto.getIdSolicitacaoServico() + ")'><a >" + UtilI18N.internacionaliza(locale, "citcorpore.comum.reclassificaosolicitacao") + "</a></li>");
				}

				sb.append("				<li onclick='agendaAtividade(" + solicitacaoServicoDto.getIdSolicitacaoServico() + ")'><a >" + UtilI18N.internacionaliza(locale, "gerenciaservico.agendaratividade") + "</a></li>");

				sb.append("			</ul>");
				sb.append("		</div>");
				sb.append("	</div>");
				sb.append("</div>");

				sb.append("</div>");
				sb.append("<div class=\"separator bottom\"></div>");
			}
		}
	}

	/**
	 * Retorna a lista de tarefas do fluxo juntamente com as solicitaes de servios.
	 *
	 * @param itensPorPagina
	 *            - Quantidade de registros por pgina.
	 * @param paginaSelecionada
	 *            - Pgina selecionada.
	 * @param usuario
	 *            - usurio logado.
	 * @param request
	 *            - HttpServletRequest
	 * @param grafico
	 *            - boolean (true - tela de grficos)
	 * @param gerenciamento
	 *            - GerenciamentoServicosDTO
	 * @return Collection<TarefaFluxoDTO>
	 * @throws Exception
	 * @author valdoilo.damasceno
	 * @since 23.10.2013 - s 20:30
	 */
	public Collection<TarefaFluxoDTO> listarTarefas(Integer itensPorPagina, Integer paginaSelecionada, UsuarioDTO usuario, HttpServletRequest request, boolean grafico, GerenciamentoServicosDTO gerenciamento) throws Exception {

		List<TarefaFluxoDTO> colTarefas = null;
		List<SolicitacaoServicoDTO> listSolicitacaoServico = new ArrayList<SolicitacaoServicoDTO>();

		if (paginaSelecionada == null) {
			paginaSelecionada = 1;
		}

		if (itensPorPagina != null) {
			if (this.getGerenciamentoServicosDTO() != null && this.getGerenciamentoServicosDTO().getIdContrato() == null && this.getGerenciamentoServicosDTO().getIdTipo() == null && gerenciamento != null) {
				this.setGerenciamentoServicosDTO(gerenciamento);
			}
		}

		String COLABORADORES_VINC_CONTRATOS = ParametroUtil.getValorParametroCitSmartHashMap(br.com.centralit.citcorpore.util.Enumerados.ParametroSistema.COLABORADORES_VINC_CONTRATOS, "N");

		if (COLABORADORES_VINC_CONTRATOS == null) {
			COLABORADORES_VINC_CONTRATOS = "N";
		}

		Collection<ContratoDTO> listContratoUsuarioLogado = null;

		if (COLABORADORES_VINC_CONTRATOS != null && COLABORADORES_VINC_CONTRATOS.equalsIgnoreCase("S")) {
			listContratoUsuarioLogado = this.getContratoService().findAtivosByIdEmpregado(usuario.getIdEmpregado());
		} else {
			listContratoUsuarioLogado = this.getContratoService().listAtivos();
		}

		if (!grafico) {
			/** Chamada do mtodo recuperaTarefas otimizado. Operao Usain Bolt - 27.01.2015 - carlos.santos */
			final ParamRecuperacaoTarefasDTO param = new ParamRecuperacaoTarefasDTO(usuario.getLogin(), gerenciamento, listContratoUsuarioLogado);
			final Pageable pageable = new PageRequest(paginaSelecionada - 1, itensPorPagina);
			final Page<TarefaFluxoDTO> resultPage = this.getExecucaoSolicitacaoService().recuperaTarefas(param, pageable);
			colTarefas = resultPage.getContent();
		} else {
			colTarefas = this.getExecucaoSolicitacaoService().recuperaTarefas(usuario.getLogin(), this.getGerenciamentoServicosDTO(), listContratoUsuarioLogado);
		}

		List<TarefaFluxoDTO> colTarefasFiltradasFinal = new ArrayList<>();

		if (colTarefas != null && !colTarefas.isEmpty()) {
			boolean asc = true;
			for (TarefaFluxoDTO tarefaDto : colTarefas) {
				SolicitacaoServicoDTO solicitacaoServicoDto = (SolicitacaoServicoDTO) tarefaDto.getSolicitacaoDto();
				listSolicitacaoServico.add(solicitacaoServicoDto);
				solicitacaoServicoDto.setDataHoraLimiteToString(""); // Apenas forca atualizacao
				solicitacaoServicoDto.setDataHoraSolicitacaoToString(""); // Apenas forca atualizacao
				solicitacaoServicoDto.setDescricaoSemFormatacao(Util.tratarAspasSimples(UtilStrings.nullToNaoDisponivel(solicitacaoServicoDto.getDescricaoSemFormatacao())));
				solicitacaoServicoDto.setDescricaoForTitle(Util.tratarAspasSimples(solicitacaoServicoDto.getDescricao()));
				solicitacaoServicoDto.setDescricao(Util.tratarAspasSimples(solicitacaoServicoDto.getDescricao()));// tratamento para Aspas Simples
				solicitacaoServicoDto.setDescricao(Util.converterHtmlQuadro(solicitacaoServicoDto.getDescricao())); // tratamento para codigo html
				solicitacaoServicoDto.setDescricao(Util.converterCaracteresInadequadosParaTexto(solicitacaoServicoDto.getDescricao())); // tratamento de caracteres inadequados para texto
				solicitacaoServicoDto.setResposta("");
				solicitacaoServicoDto.setDetalhamentoCausa("");
				if (solicitacaoServicoDto.getSlaACombinar() == null) {
					solicitacaoServicoDto.setSlaACombinar("N");
				}
				int prazoHH = 0;
				int prazoMM = 0;

				if (solicitacaoServicoDto.getPrazoHH() != null) {
					prazoHH = solicitacaoServicoDto.getPrazoHH();
				}
				if (solicitacaoServicoDto.getPrazoMM() != null) {
					prazoMM = solicitacaoServicoDto.getPrazoMM();
				}
				if (prazoHH == 0 && prazoMM == 0) {
					solicitacaoServicoDto.setSlaACombinar("S");
					solicitacaoServicoDto.setAtrasoSLA(0);
					solicitacaoServicoDto.setAtrasoSLAStr("");
					solicitacaoServicoDto.setDataHoraLimiteStr("");
				}
				if (solicitacaoServicoDto.getSlaACombinar().equalsIgnoreCase("S") || ServiceRequestStatus.SUSPENDED.getId().equals(solicitacaoServicoDto.getIdStatus())
						|| !solicitacaoServicoDto.isSLAEmAnamento()) {
					solicitacaoServicoDto.setDataHoraLimite(null);
					solicitacaoServicoDto.setAtrasoSLA(0);
					solicitacaoServicoDto.setAtrasoSLAStr("");
					if (asc) {
						tarefaDto.setDataHoraLimite(new Timestamp(UtilDatas.alteraData(UtilDatas.getDataAtual(), 10, Calendar.YEAR).getTime()));
					} else {
						tarefaDto.setDataHoraLimite(new Timestamp(UtilDatas.alteraData(UtilDatas.getDataAtual(), -10, Calendar.YEAR).getTime()));
					}
				}

				if (solicitacaoServicoDto.getSolicitanteUnidade() != null && StringUtils.isNotBlank(solicitacaoServicoDto.getSolicitanteUnidade())) {
					solicitacaoServicoDto.setSolicitante(""); // pra nao enviar no JSON
				} else {
					if (solicitacaoServicoDto.getSolicitante() != null && StringUtils.isNotBlank(solicitacaoServicoDto.getSolicitante())) {
						solicitacaoServicoDto.setSolicitanteUnidade(Util.tratarAspasSimples(solicitacaoServicoDto.getSolicitante()));
					} else {
						solicitacaoServicoDto.setSolicitanteUnidade(UtilI18N.internacionaliza(request, "citcorpore.comum.naoInformado"));
					}
				}
				colTarefasFiltradasFinal.add(tarefaDto);
			}
		}

		return colTarefasFiltradasFinal;
	}

	/**
	 * Carrega e atualiza os itens da paginao numerada e informa a quantidade de resultados Ex.: Primeiro  1 2 3 4 5  ltimo 1 De 7 Resultados
	 *
	 * @param document
	 * @param request
	 * @param totalPaginasFinal
	 */
	public void carregarItensPaginacao(DocumentHTML document, HttpServletRequest request, Integer totalPaginasFinal) throws Exception {
		StringBuilder sb = new StringBuilder();
		GerenciamentoServicosDTO gerenciamentoServicosDTO = (GerenciamentoServicosDTO) document.getBean();
		Integer paginaSelecionada = gerenciamentoServicosDTO.getPaginaSelecionada();
		if (paginaSelecionada == null) {
			paginaSelecionada = 1;
		}

		paginacaoGerenciamento(totalPaginasFinal, sb, paginaSelecionada, request);
		document.executeScript("carregarValorClasse(\"" + sb.toString() + "\", \"paginacaoGerenciamento\")");
	}

	/**
	 * Realiza a regra de paginao das solicitaes Explicao: Se o nmero de pginas for maior do que cinco, j  possvel criar os intervalos. Se a pgina atual for menor do que cinco (o adjacente
	 * esta configurado com 2)  feito um lao. No for, enquanto a varivel 'i' for menor do que seis os nmeros so mostrados fazendo uma verificao para saber qual  a pgina atual que exige uma
	 * estilizao diferente. Mas se a pgina atual for maior do que quatro e menor do que a ltima menos trs,  uma pgina intermediria. Primeiro so anexadas a primeira e ltima pginas. Depois 
	 * feito um lao para definir as adjacentes. A varivel 'adjacentes' recebeu neste cdigo o valor dois. Para enteder melhor este lao vamos supor que estamos na pgina seis. A varivel 'i' vai
	 * receber quatro (atual - adjacentes), enquanto ela for menor do que oito (atual + adjacentes) os nmeros links gerados com uma verificao para saber qual  a pgina atual. Por fim so anexadas
	 * a ltima e penltima pginas. O ltimo else  para quando a pgina atual esta perto do final da numerao. So anexadas a primeira e ltima pginas alm dos trs pontos. A varivel 'i' recebe o
	 * resultado da ltima pgina menos oito (4+2*2) enquanto no for menor ou igual a este nmero, os links so gerados.
	 *
	 * @param totalPaginas
	 * @param sb
	 * @param paginaSelecionada
	 * @param request
	 */
	public void paginacaoGerenciamento(Integer totalPaginas, StringBuilder sb, Integer paginaSelecionada, HttpServletRequest request) throws Exception {
		String locale = (String) request.getSession().getAttribute("locale");
		if (locale == null) {
			locale = "pt";
		}

		final Integer adjacentes = 2;
		if (paginaSelecionada == null) {
			paginaSelecionada = 1;
		}

		sb.append("<div class='pagination pagination-right margin-none'>");
		sb.append("		<ul>");

		sb.append("			<li " + (totalPaginas == 0 || paginaSelecionada == 1 ? "class='disabled'" : "value='1' onclick='paginarItens(this.value);'") + " ><a>" + UtilI18N.internacionaliza(locale, "citcorpore.comum.primeiro") + "</a></li>");
		sb.append("			<li " + (totalPaginas == 0 || totalPaginas == 1 || paginaSelecionada == 1 ? "class='disabled'" : "value='" + (paginaSelecionada - 1) + "' onclick='paginarItens(this.value);'") + "><a>&laquo;</a></li>");
		if (totalPaginas <= 5) {
			for (int i = 1; i <= totalPaginas; i++) {
				if (i == paginaSelecionada) {
					sb.append("<li id='" + i + "' value='" + i + "' onclick='paginarItens(this.value);' class='active'><a >" + i + "</a></li> ");
				} else {
					sb.append("<li id='" + i + "' value='" + i + "' onclick='paginarItens(this.value);'><a >" + i + "</a></li> ");
				}
			}
		} else {
			if (totalPaginas > 5) {
				if (paginaSelecionada < 1 + 2 * adjacentes) {
					for (int i = 1; i < 2 + 2 * adjacentes; i++) {
						if (i == paginaSelecionada) {
							sb.append("<li id='" + i + "' value='" + i + "' onclick='paginarItens(this.value);' class='active'><a >" + i + "</a></li> ");
						} else {
							sb.append("<li id='" + i + "' value='" + i + "' onclick='paginarItens(this.value);'><a >" + i + "</a></li> ");
						}
					}
				} else if (paginaSelecionada > 2 * adjacentes && paginaSelecionada < totalPaginas - 3) {
					for (int i = paginaSelecionada - adjacentes; i <= paginaSelecionada + adjacentes; i++) {
						if (i == paginaSelecionada) {
							sb.append("<li id='" + i + "' value='" + i + "' onclick='paginarItens(this.value);' class='active'><a >" + i + "</a></li> ");
						} else {
							sb.append("<li id='" + i + "' value='" + i + "' onclick='paginarItens(this.value);'><a >" + i + "</a></li> ");
						}
					}
				} else {
					for (int i = totalPaginas - 2 * adjacentes; i <= totalPaginas; i++) {
						if (i == paginaSelecionada) {
							sb.append("<li id='" + i + "' value='" + i + "' onclick='paginarItens(this.value);' class='active'><a >" + i + "</a></li> ");
						} else {
							sb.append("<li id='" + i + "' value='" + i + "' onclick='paginarItens(this.value);'><a >" + i + "</a></li> ");
						}
					}
				}
			}
		}
		sb.append("			<li " + (totalPaginas == 0 || totalPaginas == 1 || paginaSelecionada.equals(totalPaginas) ? "class='disabled'" : "value='" + (paginaSelecionada + 1) + "' onclick='paginarItens(this.value);'") + " ><a >&raquo;</a></li>");
		sb.append("			<li " + (totalPaginas == 0 || paginaSelecionada.equals(totalPaginas) ? "class='disabled'" : "value='" + totalPaginas + "' onclick='paginarItens(this.value);'") + " ><a >" + UtilI18N.internacionaliza(locale, "citcorpore.comum.ultimo") + "</a></li> ");

		sb.append("		</ul>");
		sb.append("</div>");
	}

	/**
	 * Realiza a paginao dos itens e recarrega a lista de solicitaes
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	public void paginarItens(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		this.setGerenciamentoServicosDTO((GerenciamentoServicosDTO) document.getBean());
		this.recarregarLista(document, request, response);

		document.executeScript("refreshView()");
	}

	/***
	 * Realiza o filtro de pesquisa da pgina de gerenciamento - Seta os itens do filtro no GerenciamentoServicosDTO - Recarrega a lista de solicitaes de acordo com os filtros informados
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	public void pesquisarItensFiltro(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(request);

		if (usuario == null) {
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}
		GerenciamentoServicosDTO gerenciamentoServicosDTO = (GerenciamentoServicosDTO) document.getBean();
		
		if (request.getParameter("ServiceRequestID") != null) {
			Integer idSolicitacaoServico = Integer.parseInt(request.getParameter("ServiceRequestID"));
			gerenciamentoServicosDTO.setIdSolicitacao(idSolicitacaoServico);
		}
				
		this.setGerenciamentoServicosDTO(gerenciamentoServicosDTO);
		this.recarregarLista(document, request, response);

		document.executeScript("refreshView()");
		document.executeScript("fecharModal()");
	}

	/**
	 * Prepada a execuo da tarefa.
	 *
	 * @param document
	 *            - DocumentHTML
	 * @param request
	 *            - HttpServletRequest
	 * @param response
	 *            - HttpServletResponse
	 * @throws Exception
	 */
	public void preparaExecucaoTarefa(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		GerenciamentoServicosDTO gerenciamentoBean = (GerenciamentoServicosDTO) document.getBean();
		if (gerenciamentoBean.getIdTarefa() == null) {
			return;
		}

		ElementoFluxoDTO elemento = this.getExecucaoSolicitacaoService().consultaElementoFluxoPeloIdItemTrabalho(gerenciamentoBean.getIdTarefa());

		if (elemento.getTipoInteracao().equals(br.com.centralit.bpm.util.Enumerated.INTERACTION_VIEW)) {

			VisaoDTO visaoDTO = getVisaoService().findByIdentificador(elemento.getVisao());

			if (visaoDTO.getIdVisao() != null) {
				document.executeScript("exibirVisao('" + UtilI18N.internacionaliza(request, "gerenciaservico.executartarefa") + " " + elemento.getDocumentacao() + "','"
						+ visaoDTO.getIdVisao() + "','" + elemento.getIdFluxo() + "','" + gerenciamentoBean.getIdTarefa() + "','" + gerenciamentoBean.getAcaoFluxo() + "');");
			} else {
				document.alert(UtilI18N.internacionaliza(request, "gerenciaservico.visaotarefa") + " \"" + elemento.getDocumentacao() + "\" "
						+ UtilI18N.internacionaliza(request, "gerenciaservico.naoencontrado"));
			}
		} else {

			String caracterParmURL = "?";
			if (elemento.getUrl().indexOf("?") > -1) { // Se na URL ja conter ?, entao colocar &
				caracterParmURL = "&";
			}
			document.executeScript("exibirUrl('" + UtilI18N.internacionaliza(request, "gerenciaservico.executartarefa") + " " + elemento.getDocumentacao() + "','"
					+ elemento.getUrl() + caracterParmURL + "idSolicitacaoServico=" + gerenciamentoBean.getIdSolicitacaoSel()
					+ "&idTarefa=" + gerenciamentoBean.getIdTarefa() + "&acaoFluxo=" + gerenciamentoBean.getAcaoFluxo() + "');");
		}
	}

	public void buscarItemTtrabalhoSolicitacao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoServicosDTO gerenciamentoServicosDTO = (GerenciamentoServicosDTO) document.getBean();
		SolicitacaoServicoDTO valor = this.getSolicitacaoServicoService(null).buscarNumeroItemTrabalhoPorNumeroSolicitacao(Integer.valueOf(gerenciamentoServicosDTO.getIdSolicitacaoSel()));
		document.executeScript("visualizarSolicitacaoPaiEnvio(" + Integer.valueOf(gerenciamentoServicosDTO.getIdSolicitacaoSel()) + "," + valor.getIdItemFluxoTrabalho() + ");");
	}

	private void loadRelatorios(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		StringBuilder sb = new StringBuilder();
		UsuarioDTO usuario = WebUtil.getUsuario(request);

		Collection<BIConsultaDTO> biConsultaListDTO = getBIConsultaService().findByTipoModuloExibicao(TipoExibicaoRelatorio.GERAL.getIdentificador(), ModuloExibicaoRelatorio.GERENCIAMENTO_INCIDENTE_REQUISICAO.getIdentificador());

		if (biConsultaListDTO != null && !biConsultaListDTO.isEmpty()) {
			for (BIConsultaDTO biConsultaDTO : biConsultaListDTO) {
				sb.append("<a href='#' onclick='openReport(&#39;" + biConsultaDTO.getTipoConsulta() + "&#39;, " + biConsultaDTO.getIdConsulta() + ",&#39;" + biConsultaDTO.getNomeConsulta() + "&#39;, &#39;G&#39;); return false;'>" + biConsultaDTO.getNomeConsulta() + "</a><br/>");
			}
		}

		Collection<SmartReportDTO> listSmartReport = getSmartReportService().findByIdsGrupoUsuarioAndTipoModuloExibicao(usuario.getColGrupos(), TipoExibicaoRelatorio.GERAL.getIdentificador(),
				ModuloExibicaoRelatorio.GERENCIAMENTO_INCIDENTE_REQUISICAO.getIdentificador());

		if (listSmartReport != null && !listSmartReport.isEmpty()) {
			for (SmartReportDTO smartReportDTO : listSmartReport) {
				sb.append("<a href='#' onclick='UtilSmartReport.open(" + smartReportDTO.getIdSmartReport() + ", null); return false;'>" + smartReportDTO.getIdentificacao() + "</a><br/>");
			}
		}

		if (sb.length() == 0) {
			sb.append(UtilI18N.internacionaliza(request, "citcorpore.comum.resultado"));
		}

		document.executeScript("initReports(\"" + sb.toString() + "\", 'G');");
	}

	private void loadRelatoriosEspecificos(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		StringBuilder sb = new StringBuilder();
		UsuarioDTO usuario = WebUtil.getUsuario(request);

		Collection<BIConsultaDTO> biConsultaListDTO = getBIConsultaService().findByTipoModuloExibicao(TipoExibicaoRelatorio.ESPECIFICO.getIdentificador(), ModuloExibicaoRelatorio.GERENCIAMENTO_INCIDENTE_REQUISICAO.getIdentificador());

		if (biConsultaListDTO != null && !biConsultaListDTO.isEmpty()) {
			for (BIConsultaDTO biConsultaDTO : biConsultaListDTO) {
				sb.append("<a href='#' onclick='openReport(&#39;" + biConsultaDTO.getTipoConsulta() + "&#39;, " + biConsultaDTO.getIdConsulta() + ",&#39;" + biConsultaDTO.getNomeConsulta() + "&#39;, &#39;E&#39;, ${idespecifico}); return false;'>" + biConsultaDTO.getNomeConsulta() + "</a><br/>");
			}
		}

		Collection<SmartReportDTO> listSmartReport = getSmartReportService().findByIdsGrupoUsuarioAndTipoModuloExibicao(usuario.getColGrupos(), TipoExibicaoRelatorio.ESPECIFICO.getIdentificador(),
				ModuloExibicaoRelatorio.GERENCIAMENTO_INCIDENTE_REQUISICAO.getIdentificador());

		if (listSmartReport != null && !listSmartReport.isEmpty()) {
			for (SmartReportDTO smartReportDTO : listSmartReport) {
				sb.append("<a href='#' onclick='UtilSmartReport.open(" + smartReportDTO.getIdSmartReport() + ", ${idespecifico}); return false;'>" + smartReportDTO.getIdentificacao() + "</a><br/>");
			}
		}

		if (sb.length() == 0) {
			sb.append(UtilI18N.internacionaliza(request, "citcorpore.comum.resultado"));
		}

		document.executeScript("initReports(\"" + sb.toString() + "\", 'E');");
	}

	/**
	 * Lista os itens de configurao relacionados a solicitao de servio.
	 *
	 */
	public void pesquisarItensDeConfiguracaoRelacionados(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoServicosDTO gerenciamentoServicosDTO = (GerenciamentoServicosDTO) document.getBean();
		SolicitacaoServicoDTO solicitacaoServicoDto = new SolicitacaoServicoDTO();

		if (gerenciamentoServicosDTO != null && gerenciamentoServicosDTO.getIdSolicitacaoSel() != null) {
			solicitacaoServicoDto.setIdSolicitacaoServico(Integer.valueOf(gerenciamentoServicosDTO.getIdSolicitacaoSel()));
			SolicitacaoServicoDTO solicitacaoServicoAux = (SolicitacaoServicoDTO) this.getSolicitacaoServicoService(null).restore(solicitacaoServicoDto);

			if (solicitacaoServicoDto != null) {
				Collection<ItemCfgSolicitacaoServDTO> col = this.getItemCfgSolicitacaoServService().findByIdSolicitacaoServico(solicitacaoServicoAux.getIdSolicitacaoServico());

				if (col != null && !col.isEmpty()) {
					for (ItemCfgSolicitacaoServDTO itemCfgSolicitacaoServAux : col) {
						ItemConfiguracaoDTO itemConfiguracaoAux = new ItemConfiguracaoDTO();
						itemConfiguracaoAux.setIdItemConfiguracao(itemCfgSolicitacaoServAux.getIdItemConfiguracao());
						itemConfiguracaoAux = (ItemConfiguracaoDTO) this.getItemConfiguracaoService().restore(itemConfiguracaoAux);
						if (itemConfiguracaoAux != null) {
							itemCfgSolicitacaoServAux.setIdentificacaoStatus(itemConfiguracaoAux.getIdentificacaoStatus());
							itemCfgSolicitacaoServAux.setIdentificacao(itemConfiguracaoAux.getIdentificacao());
						}
					}
				}

				StringBuilder script = new StringBuilder();

				String html = this.gerarHtmlComListaItensConfiguracao(col, gerenciamentoServicosDTO.getIdSolicitacaoSel(), script, request);

				document.getElementById("ItemConfiguracaoSolicitacao").setInnerHTML(html);

				document.executeScript("$('#modal_itemConfiguracao').modal('show');");
			}
		}

		solicitacaoServicoDto = null;
	}

	private String gerarHtmlComListaItensConfiguracao(Collection<ItemCfgSolicitacaoServDTO> listItemCfgSolicitacaoServDTO, String numeroSolicitacaoPai, StringBuilder script, HttpServletRequest request) {
		StringBuilder html = new StringBuilder();

		html.append("<table class='dynamicTable table table-striped table-bordered table-condensed dataTable' width='100%'>");
		html.append("<tr>");
		html.append("<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.numero") + "</th>");
		html.append("<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.identificacao") + "</th>");
		html.append("<th>" + UtilI18N.internacionaliza(request, "solicitacaoServico.informacao") + "</th>");
		html.append("</tr>");

		if (listItemCfgSolicitacaoServDTO != null && !listItemCfgSolicitacaoServDTO.isEmpty()) {

			for (ItemCfgSolicitacaoServDTO dto : listItemCfgSolicitacaoServDTO) {
				html.append("<tr>");
				html.append("<hidden id='idItemConfiguracao' value='" + dto.getIdItemConfiguracao() + "'/>");
				html.append("<hidden id='idIdentificacaoItem' value='" + dto.getIdentificacaoStatus() + "'/>");
				html.append("<td>" + dto.getIdItemConfiguracao() + "</td>");
				html.append("<td>" + dto.getIdentificacao() + "</td>");
				html.append("<td>" + "<a class='btn-action glyphicons circle_info btn-default' onclick='popupAtivos(\"" + dto.getIdItemConfiguracao() + "\")'><i></i></a>" + "</td>");
				html.append("</tr>");
			}
		}
		html.append("</table>");
		return html.toString();
	}

	public void pesquisarAnexos(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoServicosDTO gerenciamentoServicosDTO = (GerenciamentoServicosDTO) document.getBean();
		StringBuilder html = new StringBuilder();

		if (gerenciamentoServicosDTO != null && gerenciamentoServicosDTO.getIdSolicitacaoSel() != null) {
			Collection<ControleGEDDTO> colAnexos = this.getControleGedService().listByIdTabelaAndID(ControleGEDDTO.TABELA_SOLICITACAOSERVICO, Integer.valueOf(gerenciamentoServicosDTO.getIdSolicitacaoSel()));
			if (colAnexos != null && !colAnexos.isEmpty()) {
				html.append("<table class='dynamicTable table table-striped table-bordered table-condensed dataTable' width='100%'>");
				html.append("<tr>");
				html.append("<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.nome") + "</th>");
				html.append("<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.descricao") + "</th>");
				html.append("<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.acao") + "</th>");
				html.append("</tr>");

				for (ControleGEDDTO controleGEDDTO : colAnexos) {
					html.append("<tr>");
					html.append("<td>" + (controleGEDDTO.getNomeArquivo() != null && !controleGEDDTO.getNomeArquivo().isEmpty() ? controleGEDDTO.getNomeArquivo() : "") + "</td>");
					html.append("<td>" + (controleGEDDTO.getDescricaoArquivo() != null && !controleGEDDTO.getDescricaoArquivo().isEmpty() ? controleGEDDTO.getDescricaoArquivo() : "") + "</td>");
					html.append("<td>" + "<a class='btn-action glyphicons download btn-default' onclick='obtemArquivoTemporario(\"ID=" + controleGEDDTO.getIdControleGED() + "\")'><i></i></a>" + "</td>");
					html.append("</tr>");
				}

				html.append("</table>");
			}
		}

		document.getElementById("AnexosSolicitacao").setInnerHTML(html.toString());

		document.executeScript("$('#modal_anexos').modal('show');");
	}

	public void chamaComboOrigem(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect selectOrigem = document.getSelectById("idOrigem");
		selectOrigem.removeAllOptions();
		List<OrigemAtendimentoDTO> todasOrigens = (List) this.getOrigemAtendimentoService().list();
		List<OrigemAtendimentoDTO> origensNaoExcluidas = new ArrayList<OrigemAtendimentoDTO>();
		String origemPadrao = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.ORIGEM_PADRAO, "");

		selectOrigem.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
		if (todasOrigens != null) {
			for (OrigemAtendimentoDTO origemAtendimento : todasOrigens) {
				if (origemAtendimento.getDataFim() == null) {
					origensNaoExcluidas.add(origemAtendimento);
				}
			}
			selectOrigem.addOptions(origensNaoExcluidas, "idOrigem", "descricao", origemPadrao);
		}
	}

	public void abrirListaDeSubSolicitacoes(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoServicosDTO gerenciamentoServicosDTO = (GerenciamentoServicosDTO) document.getBean();
		SolicitacaoServicoDTO solicitacaoServicoDto = new SolicitacaoServicoDTO();
		String html = "";

		if (gerenciamentoServicosDTO != null && gerenciamentoServicosDTO.getIdSolicitacaoSel() != null) {
			solicitacaoServicoDto.setIdSolicitacaoServico(Integer.valueOf(gerenciamentoServicosDTO.getIdSolicitacaoSel()));
			SolicitacaoServicoDTO solicitacaoServicoAux = (SolicitacaoServicoDTO) this.getSolicitacaoServicoService(null).restore(solicitacaoServicoDto);
			Collection<SolicitacaoServicoDTO> colFinal = new ArrayList<SolicitacaoServicoDTO>();
			if (solicitacaoServicoAux != null) {
				if (solicitacaoServicoAux.getIdSolicitacaoRelacionada() != null) {
					solicitacaoServicoAux.setIdSolicitacaoServico(solicitacaoServicoAux.getIdSolicitacaoRelacionada());
					SolicitacaoServicoDTO solicitacaoServicoAux2 = (SolicitacaoServicoDTO) this.getSolicitacaoServicoService(null).restore(solicitacaoServicoAux);
					if (solicitacaoServicoAux2 != null) {
						colFinal.add(solicitacaoServicoAux2);
					}
				}
			}

			Collection<SolicitacaoServicoDTO> solicitacoesRelacionadas = this.getSolicitacaoServicoService(null).listSolicitacaoServicoRelacionadaPai(solicitacaoServicoDto.getIdSolicitacaoServico());

			if (solicitacoesRelacionadas != null) {
				colFinal.addAll(solicitacoesRelacionadas);
			}

			if (colFinal != null && !colFinal.isEmpty()) {
				StringBuilder script = new StringBuilder();

				if (solicitacaoServicoAux != null && solicitacaoServicoAux.getIdSolicitacaoRelacionada() != null) {
					html = this.gerarHtmlComListaSubSolicitacoes(colFinal, script, request, solicitacaoServicoAux.getIdSolicitacaoRelacionada());
				} else {
					html = this.gerarHtmlComListaSubSolicitacoes(colFinal, script, request, 0);
				}
			} else {
				html = UtilI18N.internacionaliza(request, "MSG04");
			}


			document.getElementById("solicitacaoRelacionada").setInnerHTML(html);
		}

		solicitacaoServicoDto = null;
	}

	private String gerarHtmlComListaSubSolicitacoes(Collection<SolicitacaoServicoDTO> listSolicitacaoServicoRelacionada, StringBuilder script, HttpServletRequest request, int idsolicitacaoPai) {
		StringBuilder html = new StringBuilder();

		html.append("<table class='dynamicTable table table-striped table-bordered table-condensed dataTable' width='100%'");
		html.append("<tr>");
		html.append("<th>" + UtilI18N.internacionaliza(request, "solicitacaoServico.numerosolicitacao") + "</th>");
		html.append("<th>" + UtilI18N.internacionaliza(request, "solicitacaoServico.dataabertura") + "</th>");
		html.append("<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.prazo") + "</th>");
		html.append("<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.descricao") + "</th>");
		html.append("<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.resposta") + "</th>");
		html.append("<th>" + UtilI18N.internacionaliza(request, "solicitacaoServico.situacao") + "</th>");
		html.append("<th>" + UtilI18N.internacionaliza(request, "solicitacaoServico.prazoLimite") + "</th>");
		html.append("</tr>");

		if (listSolicitacaoServicoRelacionada != null && !listSolicitacaoServicoRelacionada.isEmpty()) {

			for (SolicitacaoServicoDTO solicitacaoServicoRelacionada : listSolicitacaoServicoRelacionada) {
				if (idsolicitacaoPai != solicitacaoServicoRelacionada.getIdSolicitacaoServico()) {
					html.append("<tr>");
					html.append("<hidden id='idSolicitante' value='" + solicitacaoServicoRelacionada.getIdSolicitante() + "'/>");
					html.append("<hidden id='idResponsavel' value='" + solicitacaoServicoRelacionada.getIdResponsavel() + "'/>");
					html.append("<td style='text-align: center;'>" + solicitacaoServicoRelacionada.getIdSolicitacaoServico() + "</td>");
					html.append("<td id='dataHoraSolicitacao'>" + UtilDatas.formatTimestamp(solicitacaoServicoRelacionada.getDataHoraSolicitacao()) + "</td>");
					html.append("<td>" + solicitacaoServicoRelacionada.getPrazoHH() + ":" + solicitacaoServicoRelacionada.getPrazoMM() + "</td>");
					html.append("<td>" + solicitacaoServicoRelacionada.getDescricao() + "</td>");
					html.append("<td>" + (solicitacaoServicoRelacionada.getResposta() != null ? solicitacaoServicoRelacionada.getResposta() : "-") + "</td>");

					html.append("<td>".concat(UtilI18N.internacionaliza(request, ServiceRequestStatus.getChaveFromId(solicitacaoServicoRelacionada.getIdStatus()))).concat("</td>"));

					if (solicitacaoServicoRelacionada.getDataHoraLimite() != null) {
						html.append("<td>" + UtilDatas.formatTimestamp(solicitacaoServicoRelacionada.getDataHoraLimite()) + "</td>");
					} else {
						html.append("<td> combinar</td>");
					}

					html.append("</tr>");
				}
			}
		}
		html.append("</table>");
		return html.toString();
	}

	/**
	 * @param solicitacaoServicoDTO
	 * @param request
	 * @throws Exception
	 *             Seta o ribbon (Etiqueta) na lateral do box mostrando se est normal, suspensa, vencido ou menos de 1 hora p/ vencer
	 **/
	private String setarHtmlPrazo(SolicitacaoServicoDTO solicitacaoServicoDTO, HttpServletRequest request) throws Exception {
		String htmlPrioridade = "";

		if (solicitacaoServicoDTO != null && solicitacaoServicoDTO.getDemanda() != null && solicitacaoServicoDTO.getDemanda().equalsIgnoreCase("Incidente")) {

			if (verificarIncidenteCritico(solicitacaoServicoDTO, request)) {
				return htmlPrioridade = "<div class='ribbon-wrapper small'><div class='ribbon critical'>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.incidenteCritico") + "</div></div>";

			}
		}

		// VENCIDA
		if (solicitacaoServicoDTO != null && solicitacaoServicoDTO.getAtrasoSLA() > 0 && !ServiceRequestStatus.CANCELED.getId().equals(solicitacaoServicoDTO.getIdStatus())) {
			if (solicitacaoServicoDTO.getDataHoraLimite() != null) {
				Timestamp dataHoraLimite = solicitacaoServicoDTO.getDataHoraLimite();
				Timestamp dataHoraComparacao = UtilDatas.getDataHoraAtual();
				if (solicitacaoServicoDTO.encerrada()) {
					dataHoraComparacao = solicitacaoServicoDTO.getDataHoraFim();
				}
				if (dataHoraComparacao != null) {
					if (dataHoraComparacao.compareTo(dataHoraLimite) > 0) {
						htmlPrioridade = "<div class='ribbon-wrapper small'><div class='ribbon danger'>" + UtilI18N.internacionaliza(request, "citcorpore.comum.vencido") + "</div></div>";
					}
				}
			}
		} else {
			if (ServiceRequestStatus.SUSPENDED.getId().equals(solicitacaoServicoDTO.getIdStatus())) {
				// SUSPENSA
				htmlPrioridade = "<div class='ribbon-wrapper small'><div class='ribbon'>" + UtilI18N.internacionaliza(request, "citcorpore.comum.suspensa") + "</div></div>";
			} else if (UtilStrings.nullToVazio(solicitacaoServicoDTO.getSituacaoSLA()).equalsIgnoreCase("S")) {
				// MENOS DE 1zh
				htmlPrioridade = "<div class='ribbon-wrapper small'><div class='ribbon'>" + UtilI18N.internacionaliza(request, "gerenciaservico.sla.suspenso") + "</div></div>";
			} else if (solicitacaoServicoDTO.getFalta1Hora() == true) {
				// A VENCER
				htmlPrioridade = "<div class='ribbon-wrapper small'><div class='ribbon warning'>" + UtilI18N.internacionaliza(request, "citcorpore.comum.avencer") + "</div></div>";
			} else {
				// NORMAL
				htmlPrioridade = "<div class='ribbon-wrapper small'><div class='ribbon success'>" + UtilI18N.internacionaliza(request, "citcorpore.comum.normal") + "</div></div>";
			}
		}
		return htmlPrioridade;
	}

	public void gravarCadastroRapido(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		try {
			UsuarioDTO usuario = WebUtil.getUsuario(request);
			if (usuario == null) {
				document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
				document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
				return;
			}

			GerenciamentoServicosDTO gerenciamentoServicosDTO = (GerenciamentoServicosDTO) document.getBean();

			SolicitacaoServicoDTO solicitacaoServicoDto = new SolicitacaoServicoDTO();

			solicitacaoServicoDto.setIdSolicitante(gerenciamentoServicosDTO.getIdSolicitanteCadastroRapido());
			solicitacaoServicoDto.setTelefonecontato(gerenciamentoServicosDTO.getTelefoneContatoCadastroRapido());
			solicitacaoServicoDto.setEmailcontato(gerenciamentoServicosDTO.getEmailContatoCadastroRapido());
			solicitacaoServicoDto.setIdTipoDemandaServico(gerenciamentoServicosDTO.getIdTipoDemandaServicoCadastroRapido());
			solicitacaoServicoDto.setIdServico(gerenciamentoServicosDTO.getIdServicoCadastroRapido());
			solicitacaoServicoDto.setIdServicoNegocioTecnico(gerenciamentoServicosDTO.getIdServicoNegocioTecnicoBuscaCadastroRapido());
			solicitacaoServicoDto.setIdCategoriaServico(gerenciamentoServicosDTO.getIdCategoriaServicoCadastroRapido());
			solicitacaoServicoDto.setIdContrato(gerenciamentoServicosDTO.getIdContratoCadastroRapido());
			solicitacaoServicoDto.setIdUnidade(gerenciamentoServicosDTO.getIdUnidadeCadastroRapido());
			solicitacaoServicoDto.setIdOrigem(gerenciamentoServicosDTO.getIdOrigemContatoCadastroRapido());
			solicitacaoServicoDto.setImpacto(gerenciamentoServicosDTO.getImpactoCadastroRapido());
			solicitacaoServicoDto.setUrgencia(gerenciamentoServicosDTO.getUrgenciaCadastroRapido());
			solicitacaoServicoDto.setDescricao(gerenciamentoServicosDTO.getDescricaoCadastroRapido());
			solicitacaoServicoDto.setNomecontato(gerenciamentoServicosDTO.getNomeContatoCadastroRapido());
			solicitacaoServicoDto.setIdStatus(ServiceRequestStatus.IN_PROGRESS.getId());
			solicitacaoServicoDto.setDetalhamentoCausa(gerenciamentoServicosDTO.getDetalhamentoCausaCadastroRapido());
			solicitacaoServicoDto.setResposta("");
			solicitacaoServicoDto.setRegistroexecucao("");

			solicitacaoServicoDto.setEnviaEmailCriacao("N");
			solicitacaoServicoDto.setEnviaEmailFinalizacao("N");
			solicitacaoServicoDto.setEnviaEmailAcoes("N");

			final Collection<GrupoDTO> listGrupoDoEmpregadoLogado = this.getGrupoService().getGruposByEmpregado(usuario.getIdEmpregado());

			if (listGrupoDoEmpregadoLogado != null && !listGrupoDoEmpregadoLogado.isEmpty()) {
				for (final GrupoDTO grupoDto : listGrupoDoEmpregadoLogado) {
					if (grupoDto.getAbertura() != null && grupoDto.getAbertura().trim().equals("S")) {
						solicitacaoServicoDto.setEnviaEmailCriacao("S");
					}

					if (grupoDto.getEncerramento() != null && grupoDto.getEncerramento().trim().equals("S")) {
						solicitacaoServicoDto.setEnviaEmailFinalizacao("S");
					}

					if (grupoDto.getAndamento() != null && grupoDto.getAndamento().trim().equals("S")) {
						solicitacaoServicoDto.setEnviaEmailAcoes("S");
					}
				}
			}

			ServicoContratoDTO servicoContratoDto = null;
			if (solicitacaoServicoDto != null) {
				servicoContratoDto = this.getServicoContratoService().findByIdContratoAndIdServico(gerenciamentoServicosDTO.getIdContratoCadastroRapido(), gerenciamentoServicosDTO.getIdServicoCadastroRapido());
			}

			if (servicoContratoDto != null) {
				Integer idGrupoNivel1 = null;

				if (servicoContratoDto.getIdGrupoNivel1() != null && servicoContratoDto.getIdGrupoNivel1().intValue() > 0) {
					idGrupoNivel1 = servicoContratoDto.getIdGrupoNivel1();
				} else {
					final String idGrupoN1 = ParametroUtil.getValor(ParametroSistema.ID_GRUPO_PADRAO_NIVEL1, null, null);
					if (idGrupoN1 != null && !idGrupoN1.trim().equalsIgnoreCase("")) {
						try {
							idGrupoNivel1 = Integer.valueOf(idGrupoN1);
						} catch (final Exception e) {
							e.printStackTrace();
						}
					}
				}

				if (idGrupoNivel1 == null || idGrupoNivel1.intValue() <= 0) {
					document.alert(UtilI18N.internacionaliza(request, "solicitacaoservico.validacao.grupoatendnivel"));
					return;
				} else {
					solicitacaoServicoDto.setIdServicoContrato(servicoContratoDto.getIdServicoContrato());
					solicitacaoServicoDto.setIdGrupoNivel1(idGrupoNivel1);
				}

				solicitacaoServicoDto.setIdGrupoAtual(servicoContratoDto.getIdGrupoExecutor());
			}

			final Collection<UploadDTO> arquivosUpados = (Collection<UploadDTO>) request.getSession(true).getAttribute("colUploadsGED2");

			if (solicitacaoServicoDto != null) {
				solicitacaoServicoDto.setColArquivosUpload(arquivosUpados);
			}

			List<Integer> idsItemConfiguracao = new Gson().fromJson(gerenciamentoServicosDTO.getIdsItemConfiguracaoCadastroRapido(), new TypeToken<List<Integer>>() {
			}.getType());

			List<ItemConfiguracaoDTO> colItensIC = new ArrayList<>();

			if (idsItemConfiguracao != null && !idsItemConfiguracao.isEmpty()) {
				for (Integer idItemConfiguracao : idsItemConfiguracao) {
					ItemConfiguracaoDTO itemConfiguracao = new ItemConfiguracaoDTO();
					itemConfiguracao.setIdItemConfiguracao(idItemConfiguracao);
					colItensIC.add(itemConfiguracao);
				}
			}

			if (solicitacaoServicoDto != null && !colItensIC.isEmpty()) {
				solicitacaoServicoDto.setColItensICSerialize(colItensIC);
			}

			if (solicitacaoServicoDto != null) {
				solicitacaoServicoDto.setUsuarioDto(usuario);
				solicitacaoServicoDto.setRegistradoPor(usuario.getNomeUsuario());
			}

			try {
				if (solicitacaoServicoDto != null && (solicitacaoServicoDto.getIdSolicitacaoServico() == null || solicitacaoServicoDto.getIdSolicitacaoServico().intValue() == 0)) {
					solicitacaoServicoDto = (SolicitacaoServicoDTO) getSolicitacaoServicoService(request).create(solicitacaoServicoDto);

					solicitacaoServicoDto = getSolicitacaoServicoService(request).restoreAll(solicitacaoServicoDto.getIdSolicitacaoServico());

					if (gerenciamentoServicosDTO.getIdStatusCadastroRapido() != null && (gerenciamentoServicosDTO.getIdStatusCadastroRapido().equals(ServiceRequestStatus.SOLVED.getId()) || gerenciamentoServicosDTO.getIdStatusCadastroRapido().equals(ServiceRequestStatus.CANCELED.getId()))) {
						solicitacaoServicoDto.setIdStatus(gerenciamentoServicosDTO.getIdStatusCadastroRapido());
						solicitacaoServicoDto.setAcaoFluxo(Enumerated.ACTION_EXECUTE);
						solicitacaoServicoDto.setResposta(gerenciamentoServicosDTO.getRespostaCadastroRapido());

						Collection<ExecucaoSolicitacaoDTO> colExecucao = new ExecucaoSolicitacaoDao().listByIdSolicitacao(solicitacaoServicoDto.getIdSolicitacaoServico());
						if (colExecucao != null) {
							for (ExecucaoSolicitacaoDTO execucaoSolicitacaoDto : colExecucao) {
								execucaoSolicitacaoDto.getIdInstanciaFluxo();
								ItemTrabalhoFluxoDao itemTrabalhoFluxoDao = new ItemTrabalhoFluxoDao();
								Collection<ItemTrabalhoFluxoDTO> colItens = itemTrabalhoFluxoDao.findDisponiveisByIdInstancia(execucaoSolicitacaoDto.getIdInstanciaFluxo());
								if (colItens != null) {
									for (ItemTrabalhoFluxoDTO itemTrabalhoFluxoDto : colItens) {
										ItemTrabalho itemTrabalho = ItemTrabalho.getItemTrabalho(itemTrabalhoFluxoDto.getIdItemTrabalho());
										solicitacaoServicoDto.setIdTarefa(itemTrabalho.getIdItemTrabalho());
									}
								}
							}
						}

						UsuarioDTO usuarioDto = getUsuarioService().restoreByIdEmpregado(solicitacaoServicoDto.getIdSolicitante());
						solicitacaoServicoDto.setUsuarioDto(usuarioDto);

						this.getSolicitacaoServicoService(request).update(solicitacaoServicoDto);
					}

					String comando = "mostraMensagemInsercao('<h3>" + UtilI18N.internacionaliza(request, "MSG05") + ".<br>" + UtilI18N.internacionaliza(request, "gerenciaservico.numerosolicitacao") + " <b><u>" + solicitacaoServicoDto.getIdSolicitacaoServico() + "</u></b> " + UtilI18N.internacionaliza(request, "citcorpore.comum.crida") + ".<br><br>"
							+ UtilI18N.internacionaliza(request, "prioridade.prioridade") + ": " + solicitacaoServicoDto.getIdPrioridade();

					if (solicitacaoServicoDto.getPrazoHH() > 0 || solicitacaoServicoDto.getPrazoMM() > 0) {
						int slaHH = solicitacaoServicoDto.getPrazoHH();
						int slaMM = solicitacaoServicoDto.getPrazoMM();
						solicitacaoServicoDto.setPrazoHH(slaHH + slaMM / 60);
						solicitacaoServicoDto.setPrazoMM(slaMM % 60);
						comando = comando + " - SLA: " + solicitacaoServicoDto.getSLAStr() + "";
					}
					comando = comando + "</h3>')";

					document.executeScript(comando);

					DashboardSolicitacoesWebSocketServlet.sendAll(request);

					return;
				}
			} catch (final Exception e) {
				String msgErro = e.getMessage();
				msgErro = msgErro.replaceAll("java.lang.Exception:", "");
				msgErro = msgErro.replaceAll("br.com.citframework.excecao.ServiceException:", "");
				msgErro = msgErro.replaceAll("br.com.citframework.excecao.LogicException:", "");
				msgErro = msgErro.replaceAll("br.com.citframework.excecao.LogicException:", "");
				msgErro = msgErro.replaceAll("br.com.centralit.citcorpore.exception.LogicException:", "");
				msgErro = msgErro.replaceAll("br.com.centralit.citajax.exception.LogicException:", "");
				msgErro = msgErro.replaceAll("Wrapped", "");
				msgErro = msgErro.replaceAll("params.get\\(\"execucaoFluxo\"\\).recuperaGrupoAprovador\\(\\);", "");
				msgErro = msgErro.replaceAll("!params.get\\(\"execucaoFluxo\"\\).exigeAutorizacao\\(\\);", "");
				msgErro = msgErro.replaceAll("\\(script#1\\)", "");

				document.alert(UtilI18N.internacionaliza(request, msgErro));

				return;
			}
		} finally {
			document.executeScript("JANELA_AGUARDE_MENU.hide()");
		}
	}

	public void loadCadastroRapido(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		request.getSession(true).setAttribute("colUploadsGED2", null);
		request.getSession(true).setAttribute("flagGerenciamento", "S");

		carregaUnidadeCadastroRapido(document, request, response);
		carregaOrigemCadastroRapido(document, request, response);
		carregarComboTipoCatalogoServicoSolicitacao(document, request, response);
		carregarComboTipoDemanda(document, request, response);
		carregarCombosImpactoUrgencia(document, request, response);

		GerenciamentoServicosDTO gerenciamentoServicosDTO = (GerenciamentoServicosDTO) document.getBean();

		if (gerenciamentoServicosDTO.getIdTemplate() != null) {
			loadTemplate(document, request, response);
		}
	}

	public void loadTemplate(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		GerenciamentoServicosDTO gerenciamentoServicosDTO = (GerenciamentoServicosDTO) document.getBean();

		if (gerenciamentoServicosDTO.getIdTemplate() != null) {
			CadastroTemplateIncidenteRequisicaoDTO cadastroTemplateIncidenteRequisicaoDTO = new CadastroTemplateIncidenteRequisicaoDTO();
			cadastroTemplateIncidenteRequisicaoDTO.setIdTemplateIncidenteRequisicao(gerenciamentoServicosDTO.getIdTemplate());

			cadastroTemplateIncidenteRequisicaoDTO = getCadastroTemplateIncidenteRequisicaoService().restore(cadastroTemplateIncidenteRequisicaoDTO);

			if (cadastroTemplateIncidenteRequisicaoDTO != null && cadastroTemplateIncidenteRequisicaoDTO.getIdSolicitante() != null) {
				document.getElementById("idSolicitanteCadastroRapido").setValue(cadastroTemplateIncidenteRequisicaoDTO.getIdSolicitante().toString());

				EmpregadoDTO empregadoDto = new EmpregadoDTO();
				empregadoDto.setIdEmpregado(cadastroTemplateIncidenteRequisicaoDTO.getIdSolicitante());

				empregadoDto = (EmpregadoDTO) getEmpregadoService().restore(empregadoDto);

				if (empregadoDto != null && empregadoDto.getIdEmpregado() != null) {
					cadastroTemplateIncidenteRequisicaoDTO.setIdSolicitante(empregadoDto.getIdEmpregado());

					if (empregadoDto.getNome() != null) {
						document.getElementById("nomeSolicitanteCadastroRapido").setValue(empregadoDto.getNome());
					}
				}
			}

			if (cadastroTemplateIncidenteRequisicaoDTO.getIdOrigem() != null) {
				document.getSelectById("idOrigemContatoCadastroRapido").setValue(cadastroTemplateIncidenteRequisicaoDTO.getIdOrigem().toString());
			}

			HTMLSelect idContratoCadastroRapido = document.getSelectById("idContratoCadastroRapido");

			idContratoCadastroRapido.removeAllOptions();

			if (cadastroTemplateIncidenteRequisicaoDTO.getIdSolicitante() != null) {
				Collection<ContratoDTO> listContratoAtivo = this.getContratoService().findAtivosByIdEmpregado(cadastroTemplateIncidenteRequisicaoDTO.getIdSolicitante());

				if (listContratoAtivo != null && !listContratoAtivo.isEmpty()) {
					for (final ContratoDTO contratoDto : listContratoAtivo) {
						contratoDto.setNome(this.tratarNomeContrato(contratoDto, document.getLanguage()));
					}

					if (listContratoAtivo.size() > 0) {
						idContratoCadastroRapido.addOptions(listContratoAtivo, "idContrato", "nome", cadastroTemplateIncidenteRequisicaoDTO.getIdContrato().toString());
					}
				}
			} else {
				ContratoDTO contratoDTO = new ContratoDTO();
				contratoDTO.setIdContrato(cadastroTemplateIncidenteRequisicaoDTO.getIdContrato());

				contratoDTO = getContratoService().restore(contratoDTO);

				idContratoCadastroRapido.addOption(contratoDTO.getIdContrato().toString(), this.tratarNomeContrato(contratoDTO, document.getLanguage()));
			}

			StringBuilder objeto;
			final String UNIDADE_AUTOCOMPLETE = ParametroUtil.getValorParametroCitSmartHashMap(br.com.centralit.citcorpore.util.Enumerados.ParametroSistema.UNIDADE_AUTOCOMPLETE, "N");

			if (UNIDADE_AUTOCOMPLETE != null && UNIDADE_AUTOCOMPLETE.equalsIgnoreCase("S")) {
				objeto = new StringBuilder();

				objeto.append("<h5 class='campoObrigatorio'>" + UtilI18N.internacionaliza(request, "unidade.unidade") + "</h5>");
				objeto.append("<input type='text' id='unidadeDesCadastroRapido' name='unidadeDesCadastroRapido' class='span12' onfocus='montaParametrosAutocompleteUnidade();'>");
				objeto.append("<input type='hidden' id='idUnidadeCadastroRapido' name='idUnidadeCadastroRapido' value='0'/>");
				document.getElementById("divUnidadeCadastroRapido").setInnerHTML(objeto.toString());

				document.executeScript("geraAutoComplete()");
			} else {
				objeto = new StringBuilder();

				objeto.append("<h5 class='campoObrigatorio'>" + UtilI18N.internacionaliza(request, "unidade.unidade") + "</h5>");
				objeto.append("<select id='idUnidadeCadastroRapido' name='idUnidadeCadastroRapido' class='span12' required='required'></select>");

				document.getElementById("divUnidadeCadastroRapido").setInnerHTML(objeto.toString());

				HTMLSelect idUnidadeCadastroRapido = document.getSelectById("idUnidadeCadastroRapido");
				idUnidadeCadastroRapido.removeAllOptions();
				idUnidadeCadastroRapido.addOption("0", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

				String parametroUnidadeVinculadoAContratos = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.UNIDADE_VINC_CONTRATOS, "N");

				if (parametroUnidadeVinculadoAContratos.trim().equalsIgnoreCase("S")) {
					final Integer idContrato = cadastroTemplateIncidenteRequisicaoDTO.getIdContrato();

					if (idContrato != null) {
						final ArrayList<UnidadeDTO> unidades = (ArrayList) this.getUnidadeService().listHierarquiaMultiContratos(idContrato);

						if (unidades != null && !unidades.isEmpty()) {
							for (final UnidadeDTO unidade : unidades) {
								if (unidade.getDataFim() == null) {
									idUnidadeCadastroRapido.addOption(unidade.getIdUnidade().toString(), StringEscapeUtils.escapeJavaScript(unidade.getNomeNivel()));
								}
							}
						}
					}
				} else {
					final ArrayList<UnidadeDTO> unidades = (ArrayList) this.getUnidadeService().listHierarquia();

					if (unidades != null && !unidades.isEmpty()) {
						for (final UnidadeDTO unidade : unidades) {
							if (unidade.getDataFim() == null) {
								idUnidadeCadastroRapido.addOption(unidade.getIdUnidade().toString(), StringEscapeUtils.escapeJavaScript(unidade.getNomeNivel()));
							}
						}
					}
				}
			}

			Collection<CadastroTemplateIncidenteRequisicaoICDTO> colCadastroTemplateIncidenteRequisicaoICDTO = getCadastroTemplateIncidenteRequisicaoICService().listByIdTemplateIncidenteRequisicao(cadastroTemplateIncidenteRequisicaoDTO.getIdTemplateIncidenteRequisicao());
			if (colCadastroTemplateIncidenteRequisicaoICDTO != null && !colCadastroTemplateIncidenteRequisicaoICDTO.isEmpty()) {
				for (CadastroTemplateIncidenteRequisicaoICDTO cadastroTemplateIncidenteRequisicaoICDTO : colCadastroTemplateIncidenteRequisicaoICDTO) {
					ItemConfiguracaoDTO itemConfiguracaoDTO = getItemConfiguracaoService().restoreByIdItemConfiguracao(cadastroTemplateIncidenteRequisicaoICDTO.getIdItemConfiguracao());

					document.executeScript("selectedItemConfiguracao(" + itemConfiguracaoDTO.getIdItemConfiguracao() + ", '" + itemConfiguracaoDTO.getIdentificacao() + "')");
				}
			}

			if (cadastroTemplateIncidenteRequisicaoDTO.getIdContrato() != null) {
				document.getSelectById("idContratoCadastroRapido").setValue(cadastroTemplateIncidenteRequisicaoDTO.getIdContrato().toString());
			}

			if (cadastroTemplateIncidenteRequisicaoDTO.getIdUnidade() != null) {
				document.getElementById("idUnidadeCadastroRapido").setValue(cadastroTemplateIncidenteRequisicaoDTO.getIdUnidade().toString());

				if (UNIDADE_AUTOCOMPLETE != null && UNIDADE_AUTOCOMPLETE.equalsIgnoreCase("S")) {
					HTMLElement unidadeDesCadastroRapido = document.getElementById("unidadeDesCadastroRapido");
					unidadeDesCadastroRapido.setValue(this.getUnidadeService().retornaNomeUnidadeByID(cadastroTemplateIncidenteRequisicaoDTO.getIdUnidade()));
				}
			}

			if (cadastroTemplateIncidenteRequisicaoDTO.getEmailSolicitante() != null) {
				document.getElementById("emailContatoCadastroRapido").setValue(cadastroTemplateIncidenteRequisicaoDTO.getEmailSolicitante());
			}
			if (cadastroTemplateIncidenteRequisicaoDTO.getIdTipoDemandaServico() != null) {
				document.getElementById("idTipoDemandaServicoCadastroRapido").setValue(cadastroTemplateIncidenteRequisicaoDTO.getIdTipoDemandaServico().toString());
			}

			if (cadastroTemplateIncidenteRequisicaoDTO != null && cadastroTemplateIncidenteRequisicaoDTO.getIdServico() != null) {
				document.getElementById("idServicoCadastroRapido").setValue(cadastroTemplateIncidenteRequisicaoDTO.getIdServico().toString());

				ServicoDTO servicoDto = new ServicoDTO();
				servicoDto.setIdServico(cadastroTemplateIncidenteRequisicaoDTO.getIdServico());

				servicoDto = (ServicoDTO) getServicoService().restore(servicoDto);

				if (servicoDto != null && servicoDto.getIdServico() != null && servicoDto.getNomeServico() != null) {
					cadastroTemplateIncidenteRequisicaoDTO.setServico(servicoDto.getNomeServico());
					document.getElementById("servicoBuscaCadastroRapido").setValue(servicoDto.getNomeServico());
				}
			}

			if (null != cadastroTemplateIncidenteRequisicaoDTO.getUtilizaCategoriaServico() && cadastroTemplateIncidenteRequisicaoDTO.getUtilizaCategoriaServico().equals("S")) {
				document.executeScript("habilitaCheckCategoriaServico()");
				this.carregarComboCategoriaServico(document, request, response);
			} else {
				document.executeScript("desabilitaCheckCategoriaServico()");
			}

			HTMLSelect idTipoCatalogoServicoSolicitacaoCadastroRapido = document.getSelectById("idTipoCatalogoServicoSolicitacaoCadastroRapido");
			idTipoCatalogoServicoSolicitacaoCadastroRapido.setValue(cadastroTemplateIncidenteRequisicaoDTO.getIdTipoCatalogoServicoSoli());
			idTipoCatalogoServicoSolicitacaoCadastroRapido.setDisabled(true);

			HTMLElement servicoNegocioTecnicoBuscaCadastroRapido = document.getElementById("servicoNegocioTecnicoBuscaCadastroRapido");
			ServicoDTO servicoDto = this.getServicoService().findByIdServico(cadastroTemplateIncidenteRequisicaoDTO.getIdServicoNegocioTecBusc());
			if (servicoDto != null) {
				servicoNegocioTecnicoBuscaCadastroRapido.setValue(servicoDto.getNomeServico());
			}

			HTMLSelect impactoCadastroRapido = document.getSelectById("impactoCadastroRapido");
			HTMLSelect urgenciaCadastroRapido = document.getSelectById("urgenciaCadastroRapido");

			impactoCadastroRapido.setDisabled(false);
			urgenciaCadastroRapido.setDisabled(false);

			if (cadastroTemplateIncidenteRequisicaoDTO.getIdServico() != null && cadastroTemplateIncidenteRequisicaoDTO.getIdContrato() != null) {
				ServicoContratoDTO servicoContratoDto = this.getServicoContratoService().findByIdContratoAndIdServico(cadastroTemplateIncidenteRequisicaoDTO.getIdContrato(), cadastroTemplateIncidenteRequisicaoDTO.getIdServico());

				if (servicoContratoDto != null) {
					AcordoNivelServicoDTO acordoNivelServicoDto = this.getAcordoNivelServicoService().findAtivoByIdServicoContrato(servicoContratoDto.getIdServicoContrato(), "T");
					if (acordoNivelServicoDto == null) {
						// Se nao houver acordo especifico, ou seja, associado direto ao servicocontrato, entao busca um acordo geral que esteja vinculado ao servicocontrato.
						final AcordoServicoContratoDTO acordoServicoContratoDTO = this.getAcordoServicoContratoService().findAtivoByIdServicoContrato(servicoContratoDto.getIdServicoContrato(), "T");
						if (acordoServicoContratoDTO == null) {
							document.alert(UtilI18N.internacionaliza(request, "solicitacaoservico.validacao.tempoacordo"));
							return;
						}
						// Apos achar a vinculacao do acordo com o servicocontrato, entao faz um restore do acordo de nivel de servico.
						acordoNivelServicoDto = new AcordoNivelServicoDTO();
						acordoNivelServicoDto.setIdAcordoNivelServico(acordoServicoContratoDTO.getIdAcordoNivelServico());
						acordoNivelServicoDto = (AcordoNivelServicoDTO) new AcordoNivelServicoDao().restore(acordoNivelServicoDto);
						if (acordoNivelServicoDto == null) {
							// Se nao houver acordo especifico, ou seja, associado direto ao servicocontrato
							document.alert(UtilI18N.internacionaliza(request, "solicitacaoservico.validacao.tempoacordo"));
							return;
						}
					}

					if (acordoNivelServicoDto.getPermiteMudarImpUrg() != null && acordoNivelServicoDto.getPermiteMudarImpUrg().equalsIgnoreCase("N")) {
						if (acordoNivelServicoDto.getImpacto() != null) {
							impactoCadastroRapido.setValue("" + acordoNivelServicoDto.getImpacto());
							impactoCadastroRapido.setDisabled(true);
						} else {
							impactoCadastroRapido.setValue("B");
						}
					} else {
						if (cadastroTemplateIncidenteRequisicaoDTO.getImpacto() != null) {
							impactoCadastroRapido.setValue(cadastroTemplateIncidenteRequisicaoDTO.getImpacto());
						}
					}

					if (acordoNivelServicoDto.getPermiteMudarImpUrg() != null && acordoNivelServicoDto.getPermiteMudarImpUrg().equalsIgnoreCase("N")) {
						if (acordoNivelServicoDto.getUrgencia() != null) {
							urgenciaCadastroRapido.setValue("" + acordoNivelServicoDto.getUrgencia());
							urgenciaCadastroRapido.setDisabled(true);
						} else {
							urgenciaCadastroRapido.setValue("B");
						}
					} else {
						if (cadastroTemplateIncidenteRequisicaoDTO.getUrgencia() != null) {
							urgenciaCadastroRapido.setValue(cadastroTemplateIncidenteRequisicaoDTO.getUrgencia());
						}
					}
				} else {
					impactoCadastroRapido.setValue("B");
					urgenciaCadastroRapido.setValue("B");
				}
			}

			document.getElementById("descricaoCadastroRapido").setValue(StringEscapeUtils.escapeJavaScript(CitAjaxWebUtil.decodificaEnter(cadastroTemplateIncidenteRequisicaoDTO.getDescricao())));

			document.executeScript("calcularSLA();");
		}
	}

	public void unloadCadastroRapido(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		request.getSession(true).setAttribute("flagGerenciamento", null);
		request.getSession(true).setAttribute("colUploadsGED2", null);
	}

	public void carregaContratosCadastroRapido(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		GerenciamentoServicosDTO gerenciamentoServicosDTO = (GerenciamentoServicosDTO) document.getBean();

		HTMLSelect idContratoCadastroRapido = document.getSelectById("idContratoCadastroRapido");

		idContratoCadastroRapido.removeAllOptions();

		if (gerenciamentoServicosDTO.getIdSolicitanteCadastroRapido() != null) {
			Collection<ContratoDTO> listContratoAtivo = this.getContratoService().findAtivosByIdEmpregado(gerenciamentoServicosDTO.getIdSolicitanteCadastroRapido());

			if (listContratoAtivo != null && !listContratoAtivo.isEmpty()) {
				for (final ContratoDTO contratoDto : listContratoAtivo) {
					contratoDto.setNome(this.tratarNomeContrato(contratoDto, document.getLanguage()));
				}

				if (listContratoAtivo.size() > 0) {
					idContratoCadastroRapido.addOptions(listContratoAtivo, "idContrato", "nome", Iterables.get(listContratoAtivo, 0).getIdContrato().toString());
				}
			}
		}

		document.executeScript("changeContrato();");
	}

	public void carregaItemConfiguracaoSolicitante(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		GerenciamentoServicosDTO gerenciamentoServicosDTO = (GerenciamentoServicosDTO) document.getBean();

		Collection<ItemConfiguracaoDTO> colItemConfiguracao = this.getItemConfiguracaoService().findByIdProprietario(gerenciamentoServicosDTO.getIdSolicitanteCadastroRapido());

		if (colItemConfiguracao != null && !colItemConfiguracao.isEmpty()) {
			for (ItemConfiguracaoDTO itemConfiguracaoDTO : colItemConfiguracao) {
				document.executeScript("selectedItemConfiguracao(" + itemConfiguracaoDTO.getIdItemConfiguracao() + ", '" + itemConfiguracaoDTO.getIdentificacao() + "')");
			}
		}
	}

	public void carregaBaseConhecimentoAssoc(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		GerenciamentoServicosDTO gerenciamentoServicosDTO = (GerenciamentoServicosDTO) document.getBean();

		document.getElementById("divScript").setInnerHTML(UtilI18N.internacionaliza(request, "solicitacaoservico.validacao.scriptservico"));

		if (gerenciamentoServicosDTO.getIdServicoCadastroRapido() == null) {
			document.executeScript("JANELA_AGUARDE_MENU.hide()");
			return;
		}

		ServicoDTO servicoDto = new ServicoDTO();
		servicoDto.setIdServico(gerenciamentoServicosDTO.getIdServicoCadastroRapido());
		servicoDto = (ServicoDTO) this.getServicoService().restore(servicoDto);
		if (servicoDto != null) {
			if (servicoDto.getIdBaseconhecimento() != null) {
				BaseConhecimentoDTO baseConhecimentoDTO = new BaseConhecimentoDTO();
				baseConhecimentoDTO.setIdBaseConhecimento(servicoDto.getIdBaseconhecimento());
				baseConhecimentoDTO = (BaseConhecimentoDTO) this.getBaseConhecimentoService().restore(baseConhecimentoDTO);
				if (baseConhecimentoDTO != null) {
					document.getElementById("divScript").setInnerHTML(baseConhecimentoDTO.getConteudo());
				}
			}
		}

		document.executeScript("JANELA_AGUARDE_MENU.hide()");
	}

	private String tratarNomeContrato(final ContratoDTO contratoDto, final String language) throws Exception {
		String nomeCliente = "";
		String nomeFornecedor = "";

		ClienteDTO clienteDto = new ClienteDTO();

		clienteDto.setIdCliente(contratoDto.getIdCliente());

		clienteDto = (ClienteDTO) this.getClienteService().restore(clienteDto);

		if (clienteDto != null) {
			nomeCliente = clienteDto.getNomeRazaoSocial();
		}

		FornecedorDTO fornecedorDto = new FornecedorDTO();

		fornecedorDto.setIdFornecedor(contratoDto.getIdFornecedor());

		fornecedorDto = (FornecedorDTO) this.getFornecedorService().restore(fornecedorDto);

		if (fornecedorDto != null) {
			nomeFornecedor = fornecedorDto.getRazaoSocial();
		}

		final String nomeContrato = "" + contratoDto.getNumero() + " de " + UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, contratoDto.getDataContrato(), language) + " (" + nomeCliente + " - " + nomeFornecedor + ")";

		return nomeContrato;
	}

	public void carregaUnidadeCadastroRapido(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		GerenciamentoServicosDTO gerenciamentoServicosDTO = (GerenciamentoServicosDTO) document.getBean();

		StringBuilder objeto;
		final String UNIDADE_AUTOCOMPLETE = ParametroUtil.getValorParametroCitSmartHashMap(br.com.centralit.citcorpore.util.Enumerados.ParametroSistema.UNIDADE_AUTOCOMPLETE, "N");

		if (UNIDADE_AUTOCOMPLETE != null && UNIDADE_AUTOCOMPLETE.equalsIgnoreCase("S")) {
			objeto = new StringBuilder();

			objeto.append("<h5 class='campoObrigatorio'>" + UtilI18N.internacionaliza(request, "unidade.unidade") + "</h5>");
			objeto.append("<input type='text' id='unidadeDesCadastroRapido' name='unidadeDesCadastroRapido' class='span12' onfocus='montaParametrosAutocompleteUnidade();'>");
			objeto.append("<input type='hidden' id='idUnidadeCadastroRapido' name='idUnidadeCadastroRapido' value='0'/>");
			document.getElementById("divUnidadeCadastroRapido").setInnerHTML(objeto.toString());

			document.executeScript("geraAutoComplete()");
		} else {
			objeto = new StringBuilder();

			objeto.append("<h5 class='campoObrigatorio'>" + UtilI18N.internacionaliza(request, "unidade.unidade") + "</h5>");
			objeto.append("<select id='idUnidadeCadastroRapido' name='idUnidadeCadastroRapido' class='span12' required='required' onchange='changeUnidade();'></select>");

			document.getElementById("divUnidadeCadastroRapido").setInnerHTML(objeto.toString());

			HTMLSelect idUnidadeCadastroRapido = document.getSelectById("idUnidadeCadastroRapido");
			idUnidadeCadastroRapido.removeAllOptions();
			idUnidadeCadastroRapido.addOption("0", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

			String parametroUnidadeVinculadoAContratos = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.UNIDADE_VINC_CONTRATOS, "N");

			if (parametroUnidadeVinculadoAContratos.trim().equalsIgnoreCase("S")) {
				final Integer idContrato = gerenciamentoServicosDTO.getIdContratoCadastroRapido();

				if (idContrato != null) {
					final ArrayList<UnidadeDTO> unidades = (ArrayList) this.getUnidadeService().listHierarquiaMultiContratos(idContrato);

					if (unidades != null && !unidades.isEmpty()) {
						if (unidades.size() == 1) {
							idUnidadeCadastroRapido.addOptions(unidades, "idUnidade", "nomeNivel", unidades.get(0).getIdUnidade().toString());
						} else {
							idUnidadeCadastroRapido.addOptions(unidades, "idUnidade", "nomeNivel", "");
						}
					}
				}
			} else {
				final ArrayList<UnidadeDTO> unidades = (ArrayList) this.getUnidadeService().listHierarquia();

				if (unidades != null && !unidades.isEmpty()) {
					if (unidades.size() == 1) {
						idUnidadeCadastroRapido.addOptions(unidades, "idUnidade", "nomeNivel", unidades.get(0).getIdUnidade().toString());
					} else {
						idUnidadeCadastroRapido.addOptions(unidades, "idUnidade", "nomeNivel", "");
					}
				}
			}
		}
	}

	public void carregaOrigemCadastroRapido(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final HTMLSelect idOrigemContatoCadastroRapido = document.getSelectById("idOrigemContatoCadastroRapido");
		idOrigemContatoCadastroRapido.removeAllOptions();

		final ArrayList<OrigemAtendimentoDTO> todasOrigens = (ArrayList) this.getOrigemAtendimentoService().list();
		final ArrayList<OrigemAtendimentoDTO> origensNaoExcluidas = new ArrayList<OrigemAtendimentoDTO>();

		String origemPadrao = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.ORIGEM_PADRAO, "");

		idOrigemContatoCadastroRapido.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
		if (todasOrigens != null) {
			for (final OrigemAtendimentoDTO origemAtendimento : todasOrigens) {
				if (origemAtendimento.getDataFim() == null) {
					origensNaoExcluidas.add(origemAtendimento);
				}
			}

			idOrigemContatoCadastroRapido.addOptions(origensNaoExcluidas, "idOrigem", "descricao", origemPadrao);
		}
	}

	public void carregarComboTipoCatalogoServicoSolicitacao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		final HTMLSelect idTipoCatalogoServicoSolicitacao = document.getSelectById("idTipoCatalogoServicoSolicitacaoCadastroRapido");
		idTipoCatalogoServicoSolicitacao.setDisabled(false);
		idTipoCatalogoServicoSolicitacao.removeAllOptions();
		idTipoCatalogoServicoSolicitacao.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

		for (TipoCatalogoServico tipoCatalogoServico : TipoCatalogoServico.values()) {
			idTipoCatalogoServicoSolicitacao.addOption(tipoCatalogoServico.getIdentificador(), UtilI18N.internacionaliza(request, tipoCatalogoServico.getChave()));
		}

		idTipoCatalogoServicoSolicitacao.setValue(TipoCatalogoServico.SERVICO_NEGOCIO.getIdentificador());
	}

	public void verificaTipoDeAcordoDoContrato(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		GerenciamentoServicosDTO gerenciamentoServicosDTO = (GerenciamentoServicosDTO) document.getBean();

		if (gerenciamentoServicosDTO.getIdContratoCadastroRapido() != null) {
			ContratoDTO contrato = new ContratoDTO();
			contrato.setIdContrato(gerenciamentoServicosDTO.getIdContratoCadastroRapido());

			contrato = getContratoService().restore(contrato);

			if (contrato != null) {
				final HTMLSelect idTipoCatalogoServicoSolicitacao = document.getSelectById("idTipoCatalogoServicoSolicitacaoCadastroRapido");

				if (TipoAcordoContrato.CONTRATO.getIdentificador().equalsIgnoreCase(contrato.getTipo())) {
					idTipoCatalogoServicoSolicitacao.setValue(TipoCatalogoServico.SERVICO_NEGOCIO.getIdentificador());
				} else {
					idTipoCatalogoServicoSolicitacao.setValue(TipoCatalogoServico.SERVICO_TECNICO.getIdentificador());
				}

				idTipoCatalogoServicoSolicitacao.setDisabled(true);
			}
		}
	}

	public void carregarComboTipoDemanda(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		final HTMLSelect idTipoDemandaServico = document.getSelectById("idTipoDemandaServicoCadastroRapido");

		idTipoDemandaServico.removeAllOptions();
		idTipoDemandaServico.addOption("0", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

		for (ServiceDemandType serviceDemandType : ServiceDemandType.valuesWithoutOSAndProcedure()) {
			idTipoDemandaServico.addOption(String.valueOf(serviceDemandType.getId()), UtilI18N.internacionaliza(request, serviceDemandType.getI18NKey()));
		}
	}

	public void carregarCombosImpactoUrgencia(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception, ServiceException {
		final HTMLSelect impacto = document.getSelectById("impactoCadastroRapido");
		impacto.removeAllOptions();

		final HTMLSelect urgencia = document.getSelectById("urgenciaCadastroRapido");
		urgencia.removeAllOptions();

		if (!ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.CALCULAR_PRIORIDADE_SOLICITACAO_DINAMICAMENTE, "N").trim().equalsIgnoreCase("S")) {
			impacto.addOption("B", UtilI18N.internacionaliza(request, "citcorpore.comum.baixa"));
			impacto.addOption("M", UtilI18N.internacionaliza(request, "citcorpore.comum.media"));
			impacto.addOption("A", UtilI18N.internacionaliza(request, "citcorpore.comum.alta"));

			urgencia.addOption("B", UtilI18N.internacionaliza(request, "citcorpore.comum.baixa"));
			urgencia.addOption("M", UtilI18N.internacionaliza(request, "citcorpore.comum.media"));
			urgencia.addOption("A", UtilI18N.internacionaliza(request, "citcorpore.comum.alta"));
		} else {
			final Collection<UrgenciaDTO> listUrgenciaDTO = this.getPrioridadeSolicitacoesService().consultaUrgencia();

			if (listUrgenciaDTO != null && !listUrgenciaDTO.isEmpty()) {
				for (final UrgenciaDTO urgenciaTemp : listUrgenciaDTO) {
					urgencia.addOption(urgenciaTemp.getSiglaUrgencia().toString().trim(), urgenciaTemp.getNivelUrgencia());
				}
			}

			final Collection<ImpactoDTO> listImpactoDTO = this.getPrioridadeSolicitacoesService().consultaImpacto();

			if (listImpactoDTO != null && !listImpactoDTO.isEmpty()) {
				for (final ImpactoDTO impactoTemp : listImpactoDTO) {
					impacto.addOption(impactoTemp.getSiglaImpacto().toString().trim(), impactoTemp.getNivelImpacto());
				}
			}
		}
	}

	public void definirFiltrosServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoServicosDTO gerenciamentoServicosDTO = (GerenciamentoServicosDTO) document.getBean();

		if (SimNao.SIM.getValorStr().equalsIgnoreCase(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.SOLICITACAO_SERVICO_FILTRAR_CATEGORIA_SERVICO, SimNao.NAO.getValorStr()))) {
			this.carregarComboCategoriaServico(document, request, "");
			document.executeScript("ocultarCheckboxUtilizarCategoriaServico()");
		}

		if (gerenciamentoServicosDTO.getIdContratoCadastroRapido() != null && gerenciamentoServicosDTO.getIdServicoCadastroRapido() != null) {
			ServicoDTO servicoRelacionado = this.getServicoService().recuperaServicoRelacionado(gerenciamentoServicosDTO.getIdContratoCadastroRapido(), gerenciamentoServicosDTO.getIdServicoCadastroRapido());

			HTMLElement servicoNegocioTecnicoBuscaCadastroRapido = document.getElementById("servicoNegocioTecnicoBuscaCadastroRapido");
			servicoNegocioTecnicoBuscaCadastroRapido.setValue(UtilStrings.nullToVazio(servicoRelacionado.getNomeServico()));

			HTMLElement idServicoNegocioTecnicoBuscaCadastroRapido = document.getElementById("idServicoNegocioTecnicoBuscaCadastroRapido");
			idServicoNegocioTecnicoBuscaCadastroRapido.setValue(UtilNumbersAndDecimals.nullToVazio(servicoRelacionado.getIdServico()));

			if (UtilStrings.isNotVazio(servicoRelacionado.getTipoServico())) {
				HTMLSelect idTipoCatalogoServicoSolicitacaoCadastroRapido = document.getSelectById("idTipoCatalogoServicoSolicitacaoCadastroRapido");
				idTipoCatalogoServicoSolicitacaoCadastroRapido.setValue(UtilStrings.nullToVazio(servicoRelacionado.getTipoServico()));
			}

			ServicoDTO servico = this.getServicoService().findById(gerenciamentoServicosDTO.getIdServicoCadastroRapido());

			HTMLSelect idTipoDemandaServicoCadastroRapido = document.getSelectById("idTipoDemandaServicoCadastroRapido");
			idTipoDemandaServicoCadastroRapido.setValue(UtilNumbersAndDecimals.nullToVazio(servico.getIdTipoDemandaServico()));

			HTMLSelect idCategoriaServicoCadastroRapido = document.getSelectById("idCategoriaServicoCadastroRapido");
			idCategoriaServicoCadastroRapido.setValue(UtilNumbersAndDecimals.nullToVazio(servico.getIdCategoriaServico()));
		}
	}

	public void restaurarSolicitante(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoServicosDTO gerenciamentoServicosDTO = (GerenciamentoServicosDTO) document.getBean();

		if (gerenciamentoServicosDTO.getIdSolicitanteCadastroRapido() != null) {
			final String UNIDADE_AUTOCOMPLETE = ParametroUtil.getValorParametroCitSmartHashMap(br.com.centralit.citcorpore.util.Enumerados.ParametroSistema.UNIDADE_AUTOCOMPLETE, "N");

			EmpregadoDTO empregadoDTO = new EmpregadoDTO();
			empregadoDTO.setIdEmpregado(gerenciamentoServicosDTO.getIdSolicitanteCadastroRapido());
			empregadoDTO = (EmpregadoDTO) this.getEmpregadoService().restore(empregadoDTO);

			if (empregadoDTO.getEmail() != null) {
				HTMLElement emailContatoCadastroRapido = document.getElementById("emailContatoCadastroRapido");
				emailContatoCadastroRapido.setValue(empregadoDTO.getEmail().trim());
			}

			if (empregadoDTO.getTelefone() != null) {
				HTMLElement telefoneContatoCadastroRapido = document.getElementById("telefoneContatoCadastroRapido");
				telefoneContatoCadastroRapido.setValue(empregadoDTO.getTelefone().trim());
			}

			if (empregadoDTO.getIdUnidade() != null) {
				HTMLElement idUnidadeCadastroRapido = document.getElementById("idUnidadeCadastroRapido");
				idUnidadeCadastroRapido.setValue(String.valueOf(empregadoDTO.getIdUnidade()));

				if (UNIDADE_AUTOCOMPLETE != null && UNIDADE_AUTOCOMPLETE.equalsIgnoreCase("S")) {
					HTMLElement unidadeDesCadastroRapido = document.getElementById("unidadeDesCadastroRapido");
					unidadeDesCadastroRapido.setValue(this.getUnidadeService().retornaNomeUnidadeByID(empregadoDTO.getIdUnidade()));
				}
			}
		}
	}

	public void carregarComboCategoriaServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		carregarComboCategoriaServico(document, request, "");
	}

	private void carregarComboCategoriaServico(final DocumentHTML document, final HttpServletRequest request, String valorDefault) throws Exception {
		GerenciamentoServicosDTO gerenciamentoServicosDTO = (GerenciamentoServicosDTO) document.getBean();

		if (gerenciamentoServicosDTO != null) {
			List<CategoriaServicoDTO> listaDeCategorias = new ArrayList<CategoriaServicoDTO>();

			if (SimNao.SIM.getValorStr().equalsIgnoreCase(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.SOLICITACAO_SERVICO_FILTRAR_CATEGORIA_SERVICO, SimNao.SIM.getValorStr()))) {
				listaDeCategorias = getCategoriaServicoService().findCategoriaRelacionadaAoServicoContrato(gerenciamentoServicosDTO.getIdContratoCadastroRapido(), gerenciamentoServicosDTO.getIdServicoNegocioTecnicoBuscaCadastroRapido());
			} else {
				listaDeCategorias = (List<CategoriaServicoDTO>) this.getCategoriaServicoService().listHierarquia();
			}

			final HTMLSelect idCategoriaServico = document.getSelectById("idCategoriaServicoCadastroRapido");
			idCategoriaServico.removeAllOptions();
			idCategoriaServico.addOption("0", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

			if ((listaDeCategorias == null || listaDeCategorias.isEmpty()) && SimNao.SIM.getValorStr().equalsIgnoreCase(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.SOLICITACAO_SERVICO_FILTRAR_CATEGORIA_SERVICO, SimNao.SIM.getValorStr()))) {
				document.executeScript("naoEncontrouRegistrosCategoriaServico();");
			} else if (listaDeCategorias != null && !listaDeCategorias.isEmpty()) {
				idCategoriaServico.addOptions(listaDeCategorias, "idCategoriaServico", "nomeCategoriaServico", valorDefault);
			}

			document.executeScript("depoisCarregarComboCategoria();");
		}
	}

	public void verificaImpactoUrgencia(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		GerenciamentoServicosDTO gerenciamentoServicosDTO = (GerenciamentoServicosDTO) document.getBean();

		HTMLSelect impactoCadastroRapido = document.getSelectById("impactoCadastroRapido");
		HTMLSelect urgenciaCadastroRapido = document.getSelectById("urgenciaCadastroRapido");

		impactoCadastroRapido.setDisabled(false);
		urgenciaCadastroRapido.setDisabled(false);

		if (gerenciamentoServicosDTO.getIdServicoCadastroRapido() == null || gerenciamentoServicosDTO.getIdContratoCadastroRapido() == null) {
			return;
		}

		ServicoContratoDTO servicoContratoDto = this.getServicoContratoService().findByIdContratoAndIdServico(gerenciamentoServicosDTO.getIdContratoCadastroRapido(), gerenciamentoServicosDTO.getIdServicoCadastroRapido());

		if (servicoContratoDto != null) {
			AcordoNivelServicoDTO acordoNivelServicoDto = this.getAcordoNivelServicoService().findAtivoByIdServicoContrato(servicoContratoDto.getIdServicoContrato(), "T");
			if (acordoNivelServicoDto == null) {
				// Se nao houver acordo especifico, ou seja, associado direto ao servicocontrato, entao busca um acordo geral que esteja vinculado ao servicocontrato.
				final AcordoServicoContratoDTO acordoServicoContratoDTO = this.getAcordoServicoContratoService().findAtivoByIdServicoContrato(servicoContratoDto.getIdServicoContrato(), "T");
				if (acordoServicoContratoDTO == null) {
					document.alert(UtilI18N.internacionaliza(request, "solicitacaoservico.validacao.tempoacordo"));
					return;
				}
				// Apos achar a vinculacao do acordo com o servicocontrato, entao faz um restore do acordo de nivel de servico.
				acordoNivelServicoDto = new AcordoNivelServicoDTO();
				acordoNivelServicoDto.setIdAcordoNivelServico(acordoServicoContratoDTO.getIdAcordoNivelServico());
				acordoNivelServicoDto = (AcordoNivelServicoDTO) new AcordoNivelServicoDao().restore(acordoNivelServicoDto);
				if (acordoNivelServicoDto == null) {
					// Se nao houver acordo especifico, ou seja, associado direto ao servicocontrato
					document.alert(UtilI18N.internacionaliza(request, "solicitacaoservico.validacao.tempoacordo"));
					return;
				}
			}
			if (acordoNivelServicoDto.getImpacto() != null) {
				impactoCadastroRapido.setValue("" + acordoNivelServicoDto.getImpacto());
				if (acordoNivelServicoDto.getPermiteMudarImpUrg() != null && acordoNivelServicoDto.getPermiteMudarImpUrg().equalsIgnoreCase("N")) {
					impactoCadastroRapido.setDisabled(true);
				}
			} else {
				impactoCadastroRapido.setValue("B");
			}
			if (acordoNivelServicoDto.getUrgencia() != null) {
				urgenciaCadastroRapido.setValue("" + acordoNivelServicoDto.getUrgencia());
				if (acordoNivelServicoDto.getPermiteMudarImpUrg() != null && acordoNivelServicoDto.getPermiteMudarImpUrg().equalsIgnoreCase("N")) {
					urgenciaCadastroRapido.setDisabled(true);
				}
			} else {
				urgenciaCadastroRapido.setValue("B");
			}
		} else {
			impactoCadastroRapido.setValue("B");
			urgenciaCadastroRapido.setValue("B");
		}
	}

	public void calculaSLA(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		String sla = "";
		SolicitacaoServicoDTO solicitacaoServicoDTO = new SolicitacaoServicoDTO();
		try {
			GerenciamentoServicosDTO gerenciamentoServicosDTO = (GerenciamentoServicosDTO) document.getBean();

			if (gerenciamentoServicosDTO.getIdContratoCadastroRapido() == null || gerenciamentoServicosDTO.getIdContratoCadastroRapido().intValue() == 0) {
				throw new LogicException("Contrato no encontrado");
			}
			if (gerenciamentoServicosDTO.getIdServicoCadastroRapido() == null || gerenciamentoServicosDTO.getIdServicoCadastroRapido().intValue() == 0) {
				throw new LogicException("Servio no encontrado");
			}

			solicitacaoServicoDTO.setIdSolicitante(gerenciamentoServicosDTO.getIdSolicitanteCadastroRapido());
			solicitacaoServicoDTO.setIdContrato(gerenciamentoServicosDTO.getIdContratoCadastroRapido());
			solicitacaoServicoDTO.setIdServico(gerenciamentoServicosDTO.getIdServicoCadastroRapido());
			solicitacaoServicoDTO.setIdUnidade(gerenciamentoServicosDTO.getIdUnidadeCadastroRapido());
			solicitacaoServicoDTO.setImpacto(gerenciamentoServicosDTO.getImpactoCadastroRapido());
			solicitacaoServicoDTO.setUrgencia(gerenciamentoServicosDTO.getUrgenciaCadastroRapido());
			solicitacaoServicoDTO.setIdTipoDemandaServico(gerenciamentoServicosDTO.getIdTipoDemandaServicoCadastroRapido());

			sla = this.getSolicitacaoServicoService(request).calculaSLAMultinivel(solicitacaoServicoDTO, document, request);

			if (sla.equals("")) {
				sla = "N/A";
			}

			MatrizPrioridade matrizPrioridade = MatrizPrioridade.getMatrizPrioridade(solicitacaoServicoDTO.getUrgencia(), solicitacaoServicoDTO.getImpacto());
			document.executeScript("exibeCalculoSLA('".concat(sla).concat("','").concat(matrizPrioridade.getCor()).concat("');"));

		} catch (final Exception e) {
			e.printStackTrace();
			if (sla.equals("")) {
				sla = "N/A";
			}

			document.executeScript("exibeCalculoSLA('".concat(sla).concat("','');"));
		}
	}

	public void listarServicosNegocioTecnico(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		GerenciamentoServicosDTO gerenciamentoServicosDTO = (GerenciamentoServicosDTO) document.getBean();

		final HTMLTable tblListaServicosNegocioTecnico = document.getTableById("tblListaServicosNegocioTecnico");
		tblListaServicosNegocioTecnico.deleteAllRows();

		final Collection<ServicoDTO> colServicos = this.getServicoService().findAutocompleteServicoNegocioTecnico(gerenciamentoServicosDTO.getIdContratoCadastroRapido(), gerenciamentoServicosDTO.getIdTipoCatalogoServicoSolicitacaoCadastroRapido(), "");
		if (colServicos != null && !colServicos.isEmpty()) {
			tblListaServicosNegocioTecnico.addRowsByCollection(colServicos, new String[] { "idServico", "nomeServico" }, null, null, null, "selecionarServicoNegocioTecnico", null);
			document.executeScript("$('#modal_infoServicosNegocioTecnico').modal('show')");
		} else {
			document.alert(UtilI18N.internacionaliza(request, "MSG04"));
		}

		document.executeScript("depoisListarServicos();");
	}

	public void listarServicos(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		GerenciamentoServicosDTO gerenciamentoServicosDTO = (GerenciamentoServicosDTO) document.getBean();

		final HTMLTable tblListaServicos = document.getTableById("tblListaServicos");
		tblListaServicos.deleteAllRows();

		final Collection<ServicoDTO> colServicos = this.getServicoService().findAutocompleteServico(gerenciamentoServicosDTO.getIdTipoDemandaServicoCadastroRapido(), gerenciamentoServicosDTO.getIdContratoCadastroRapido(), gerenciamentoServicosDTO.getIdCategoriaServicoCadastroRapido(), "", gerenciamentoServicosDTO.getIdServicoNegocioTecnicoBuscaCadastroRapido());
		if (colServicos != null && !colServicos.isEmpty()) {
			tblListaServicos.addRowsByCollection(colServicos, new String[] { "idServico", "nomeServico" }, null, null, null, "selecionarServico", null);
			document.executeScript("$('#modal_infoServicos').modal('show')");
		} else {
			if (gerenciamentoServicosDTO.getIdCategoriaServicoCadastroRapido() == null) {
				document.alert(UtilI18N.internacionaliza(request, "solicitacaoServico.semServicoParaTipoSolicitacaoContrato"));
			} else {
				document.alert(UtilI18N.internacionaliza(request, "solicitacaoServico.semServicoParaTipoSolicitacaoContratoCategoriaServico"));
			}
		}

		document.executeScript("depoisListarServicos();");
	}

	public void restoreItemConfiguracao(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		GerenciamentoServicosDTO gerenciamentoServicosDTO = (GerenciamentoServicosDTO) document.getBean();

		int prioridade = 0;
		int prioridadeObj = 0;

		List<Integer> idsItemConfiguracao = new Gson().fromJson(gerenciamentoServicosDTO.getIdsItemConfiguracaoCadastroRapido(), new TypeToken<List<Integer>>() {
		}.getType());

		if (idsItemConfiguracao != null && !idsItemConfiguracao.isEmpty()) {
			for (Integer idItemConfiguracao : idsItemConfiguracao) {
				ItemConfiguracaoDTO itemConfiguracaoDTO2 = new ItemConfiguracaoDTO();

				itemConfiguracaoDTO2.setIdItemConfiguracao(idItemConfiguracao);
				itemConfiguracaoDTO2 = (ItemConfiguracaoDTO) this.getItemConfiguracaoService().restore(itemConfiguracaoDTO2);

				if (itemConfiguracaoDTO2.getUrgencia() != null && itemConfiguracaoDTO2.getImpacto() != null) {
					if (itemConfiguracaoDTO2.getUrgencia().equalsIgnoreCase("B") && itemConfiguracaoDTO2.getImpacto().equalsIgnoreCase("B")) {
						prioridadeObj = 1;
					} else if (itemConfiguracaoDTO2.getUrgencia().equalsIgnoreCase("B") && itemConfiguracaoDTO2.getImpacto().equalsIgnoreCase("M")) {
						prioridadeObj = 2;
					} else if (itemConfiguracaoDTO2.getUrgencia().equalsIgnoreCase("B") && itemConfiguracaoDTO2.getImpacto().equalsIgnoreCase("A")) {
						prioridadeObj = 3;
					} else if (itemConfiguracaoDTO2.getUrgencia().equalsIgnoreCase("M") && itemConfiguracaoDTO2.getImpacto().equalsIgnoreCase("B")) {
						prioridadeObj = 2;
					} else if (itemConfiguracaoDTO2.getUrgencia().equalsIgnoreCase("M") && itemConfiguracaoDTO2.getImpacto().equalsIgnoreCase("M")) {
						prioridadeObj = 3;
					} else if (itemConfiguracaoDTO2.getUrgencia().equalsIgnoreCase("M") && itemConfiguracaoDTO2.getImpacto().equalsIgnoreCase("A")) {
						prioridadeObj = 4;
					} else if (itemConfiguracaoDTO2.getUrgencia().equalsIgnoreCase("A") && itemConfiguracaoDTO2.getImpacto().equalsIgnoreCase("B")) {
						prioridadeObj = 3;
					} else if (itemConfiguracaoDTO2.getUrgencia().equalsIgnoreCase("A") && itemConfiguracaoDTO2.getImpacto().equalsIgnoreCase("M")) {
						prioridadeObj = 4;
					} else if (itemConfiguracaoDTO2.getUrgencia().equalsIgnoreCase("A") && itemConfiguracaoDTO2.getImpacto().equalsIgnoreCase("A")) {
						prioridadeObj = 5;
					}
					if (prioridadeObj > prioridade) {
						prioridade = prioridadeObj;
						document.getSelectById("urgenciaCadastroRapido").setValue(itemConfiguracaoDTO2.getUrgencia());
						document.getSelectById("impactoCadastroRapido").setValue(itemConfiguracaoDTO2.getImpacto());
					}
				}
			}
		}
	}

	/**
	 * Verificar se o servico da solicitacao e critico
	 *
	 * @param solicitacaoServicoDTO
	 * @param request
	 * @return
	 */
	private boolean verificarIncidenteCritico(SolicitacaoServicoDTO solicitacaoServicoDTO, HttpServletRequest request) {

		if (solicitacaoServicoDTO.getIdSolicitacaoServico() == null || solicitacaoServicoDTO.getIdServico() == null) {
			return false;
		}

		ServicoDTO servicoCritico;
		try {
			servicoCritico = getServicoService().findById(solicitacaoServicoDTO.getIdServico());

			if (servicoCritico != null && servicoCritico.getIncidenteCritico() != null && servicoCritico.getIncidenteCritico().equalsIgnoreCase("S")) {
				return true;
			}

		} catch (Exception e) {
			return false;
		}

		return false;

	}

	/**
	 * @param solicitacaoServicoDTO
	 * @throws Exception
	 *             Seta o css (cor) em "prioridade" alterando a cor de acordo com a mesma
	 * **/
	private String setarCssPrioridade(String prioridade) throws Exception {
		String cssPrioridade = "";
		if (prioridade.equalsIgnoreCase("1") || prioridade.equalsIgnoreCase("2")) {
			cssPrioridade = "prioridade Alta";
		}
		if (prioridade.equalsIgnoreCase("3")) {
			cssPrioridade = "prioridade Media";
		}
		if (prioridade.equalsIgnoreCase("4") || prioridade.equalsIgnoreCase("5")) {
			cssPrioridade = "prioridade Baixa";
		}
		return cssPrioridade;
	}

	/**
	 * @param solicitacaoServicoDTO
	 * @throws Exception
	 *             Seta o css (cor) em "prazo limite" do box mostrando se est norma, suspensa, vencido ou menos de 1 hora p/ vencer
	 **/
	private String setarCssPrazo(SolicitacaoServicoDTO solicitacaoServicoDTO) throws Exception {
		String cssPrioridade = "";
		if (solicitacaoServicoDTO.getAtrasoSLA() > 0 && !ServiceRequestStatus.CANCELED.getId().equals(solicitacaoServicoDTO.getIdStatus())) {
			if (solicitacaoServicoDTO.getDataHoraLimite() != null) {
				Timestamp dataHoraLimite = solicitacaoServicoDTO.getDataHoraLimite();
				Timestamp dataHoraComparacao = UtilDatas.getDataHoraAtual();
				if (solicitacaoServicoDTO.encerrada()) {
					dataHoraComparacao = solicitacaoServicoDTO.getDataHoraFim();
				}
				if (dataHoraComparacao != null) {
					if (dataHoraComparacao.compareTo(dataHoraLimite) > 0) {
						cssPrioridade = "prazoVencido";

					}
				}
			}
		} else {
			if (solicitacaoServicoDTO.getFalta1Hora() == true) {
				cssPrioridade = "prazoAVencer";
			} else {
				cssPrioridade = "prazoNormal";
			}
		}
		return cssPrioridade;
	}

	public void capturaTarefa(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(request);

		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		GerenciamentoServicosDTO gerenciamentoBean = (GerenciamentoServicosDTO) document.getBean();
		if (gerenciamentoBean.getIdTarefa() == null) {
			return;
		}

		this.getExecucaoSolicitacaoService().captura(usuario, gerenciamentoBean.getIdTarefa());
		gerenciamentoBean = null;

		document.executeScript("$('#modal_confirm').modal('hide');");
		document.executeScript("pesquisarItensFiltro();");
	}

	public void reativaSolicitacao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(request);

		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		GerenciamentoServicosDTO gerenciamentoBean = (GerenciamentoServicosDTO) document.getBean();
		if (gerenciamentoBean.getIdSolicitacaoSel() == null) {
			return;
		} else {
			Integer idSolicitacao = Integer.parseInt(gerenciamentoBean.getIdSolicitacaoSel());
			gerenciamentoBean.setIdSolicitacao(idSolicitacao);
		}

		SolicitacaoServicoDTO solicitacaoServicoDto = this.getSolicitacaoServicoService(request).restoreAll(gerenciamentoBean.getIdSolicitacao());
		this.getSolicitacaoServicoService(request).reativa(usuario, solicitacaoServicoDto);

		document.executeScript("pesquisarItensFiltro();");

		gerenciamentoBean = null;
		solicitacaoServicoDto = null;
	}

	public void carregarTemplates(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		Collection<CadastroTemplateIncidenteRequisicaoDTO> colCadastroTemplateIncidenteRequisicaoDTO = getCadastroTemplateIncidenteRequisicaoService().list();

		StringBuilder sb = new StringBuilder();

		if (colCadastroTemplateIncidenteRequisicaoDTO != null && !colCadastroTemplateIncidenteRequisicaoDTO.isEmpty()) {
			sb.append("<ul>");

			for (CadastroTemplateIncidenteRequisicaoDTO cadastroTemplateIncidenteRequisicaoDTO : colCadastroTemplateIncidenteRequisicaoDTO) {
				sb.append("<li><i class='material-icons md-16 pull-left'>chevron_right</i>&nbsp;<a href='javascript: return false;' onclick='abrirCadastroRapido(" + cadastroTemplateIncidenteRequisicaoDTO.getIdTemplateIncidenteRequisicao() + ");'>" + cadastroTemplateIncidenteRequisicaoDTO.getNomeTemplate() + "</a></li>");
			}

			sb.append("</ul>");
		} else {
			sb.append("<div class='text-center'>" + UtilI18N.internacionaliza(request, "MSG04") + "</div>");
		}

		document.executeScript("$(\"#templateSolicitacoes\").html(\"" + StringEscapeUtils.escapeJavaScript(sb.toString()) + "\")");
	}

	public Set<ContratoDTO> getHashContratos() {
		return hashContratos;
	}

	public void setHashContratos(Set<ContratoDTO> hashContratos) {
		this.hashContratos = hashContratos;
	}

	public GerenciamentoServicosDTO getGerenciamentoServicosDTO() {
		return gerenciamentoServicosDTO;
	}

	public void setGerenciamentoServicosDTO(GerenciamentoServicosDTO gerenciamentoServicosDTO) {
		this.gerenciamentoServicosDTO = gerenciamentoServicosDTO;
	}

	private ContratoService getContratoService() throws Exception {
		if (contratoService == null) {
			contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
		}
		return contratoService;
	}

	protected ExecucaoSolicitacaoService getExecucaoSolicitacaoService() throws Exception {
		if (execucaoSolicitacaoService == null) {
			execucaoSolicitacaoService = (ExecucaoSolicitacaoService) ServiceLocator.getInstance().getService(ExecucaoSolicitacaoService.class, null);
		}
		return execucaoSolicitacaoService;
	}

	private SolicitacaoServicoService getSolicitacaoServicoService(HttpServletRequest request) throws Exception {
		if (solicitacaoServicoService == null) {
			if (request == null) {
				solicitacaoServicoService = (SolicitacaoServicoService) ServiceLocator.getInstance().getService(SolicitacaoServicoService.class, null);
			} else {
				solicitacaoServicoService = (SolicitacaoServicoService) ServiceLocator.getInstance().getService(SolicitacaoServicoService.class, WebUtil.getUsuarioSistema(request));
			}
		}
		return solicitacaoServicoService;
	}

	/**
	 * Retorna instncia de ControleGEDService.
	 *
	 * @return ControleGEDService
	 * @author valdoilo.damasceno
	 * @since 02.03.2015
	 */
	public ControleGEDService getControleGedService() throws ServiceException {
		if (controleGedService == null) {
			controleGedService = (ControleGEDService) ServiceLocator.getInstance().getService(ControleGEDService.class, null);
		}
		return controleGedService;
	}

	/**
	 * Retorna instncia de OrigemAtendimentoService.
	 *
	 * @return OrigemAtendimentoService
	 * @author valdoilo.damasceno
	 * @since 02.03.2015
	 */
	public OrigemAtendimentoService getOrigemAtendimentoService() throws ServiceException {
		if (origemAtendimentoService == null) {
			origemAtendimentoService = (OrigemAtendimentoService) ServiceLocator.getInstance().getService(OrigemAtendimentoService.class, null);
		}
		return origemAtendimentoService;
	}

	/**
	 * Retorna instncia de ItemConfiguracaoService.
	 *
	 * @return ItemConfiguracaoService
	 * @author valdoilo.damasceno
	 * @since 02.03.2015
	 */
	public ItemConfiguracaoService getItemConfiguracaoService() throws ServiceException {
		if (itemConfiguracaoService == null) {
			itemConfiguracaoService = (ItemConfiguracaoService) ServiceLocator.getInstance().getService(ItemConfiguracaoService.class, null);
		}
		return itemConfiguracaoService;
	}

	/**
	 * Retorna instncia de ItemCfgSolicitacaoServService.
	 *
	 * @return ItemCfgSolicitacaoServService
	 * @author valdoilo.damasceno
	 * @since 02.03.2015
	 */
	public ItemCfgSolicitacaoServService getItemCfgSolicitacaoServService() throws ServiceException {
		if (itemCfgSolicitacaoServService == null) {
			itemCfgSolicitacaoServService = (ItemCfgSolicitacaoServService) ServiceLocator.getInstance().getService(ItemCfgSolicitacaoServService.class, null);
		}
		return itemCfgSolicitacaoServService;
	}

	/**
	 * Retorna instncia de ClienteService.
	 *
	 * @return ClienteService
	 * @author valdoilo.damasceno
	 * @since 02.03.2015
	 */
	public ClienteService getClienteService() throws ServiceException {
		if (clienteService == null) {
			clienteService = (ClienteService) ServiceLocator.getInstance().getService(ClienteService.class, null);
		}
		return clienteService;
	}

	/**
	 * Retorna instncia de FornecedorService.
	 *
	 * @return FornecedorService
	 * @author valdoilo.damasceno
	 * @since 02.03.2015
	 */
	public FornecedorService getFornecedorService() throws ServiceException {
		if (fornecedorService == null) {
			fornecedorService = (FornecedorService) ServiceLocator.getInstance().getService(FornecedorService.class, null);
		}
		return fornecedorService;
	}

	/**
	 * Retorna instancia do service da RequisicaoViagem
	 * @param request
	 * @return
	 * @throws Exception
	 */
	private RequisicaoViagemService getRequisicaoViagemService(HttpServletRequest request) throws Exception {

		if (requisicaoViagemService == null) {
			if (request == null) {
				requisicaoViagemService = (RequisicaoViagemService) ServiceLocator.getInstance().getService(RequisicaoViagemService.class, null);
			} else {
				requisicaoViagemService = (RequisicaoViagemService) ServiceLocator.getInstance().getService(RequisicaoViagemService.class, WebUtil.getUsuarioSistema(request));
			}
		}
		return requisicaoViagemService;
	}

	private BIConsultaService getBIConsultaService() throws ServiceException {
		if (biConsultaService == null) {
			biConsultaService = (BIConsultaService) ServiceLocator.getInstance().getService(BIConsultaService.class, null);
		}
		return biConsultaService;
	}

	private ServicoService getServicoService() throws ServiceException {
		if (servicoService == null) {
			servicoService = (ServicoService) ServiceLocator.getInstance().getService(ServicoService.class, null);
		}
		return servicoService;
	}

	private GrupoService getGrupoService() throws ServiceException {
		if (grupoService == null) {
			grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
		}
		return grupoService;
	}

	private ElementoFluxoService getElementoFluxoService() throws ServiceException {
		if (elementoFluxoService == null) {
			elementoFluxoService = (ElementoFluxoService) ServiceLocator.getInstance().getService(ElementoFluxoService.class, null);
		}
		return elementoFluxoService;
	}

	private UnidadeService getUnidadeService() throws ServiceException {
		if (unidadeService == null) {
			unidadeService = (UnidadeService) ServiceLocator.getInstance().getService(UnidadeService.class, null);
		}
		return unidadeService;
	}

	private EmpregadoService getEmpregadoService() throws ServiceException {
		if (empregadoService == null) {
			empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, null);
		}
		return empregadoService;
	}

	private CategoriaServicoService getCategoriaServicoService() throws ServiceException {
		if (categoriaServicoService == null) {
			categoriaServicoService = (CategoriaServicoService) ServiceLocator.getInstance().getService(CategoriaServicoService.class, null);
		}
		return categoriaServicoService;
	}

	private ServicoContratoService getServicoContratoService() throws ServiceException {
		if (servicoContratoService == null) {
			servicoContratoService = (ServicoContratoService) ServiceLocator.getInstance().getService(ServicoContratoService.class, null);
		}
		return servicoContratoService;
	}

	private AcordoNivelServicoService getAcordoNivelServicoService() throws ServiceException {
		if (acordoNivelServicoService == null) {
			acordoNivelServicoService = (AcordoNivelServicoService) ServiceLocator.getInstance().getService(AcordoNivelServicoService.class, null);
		}
		return acordoNivelServicoService;
	}

	private AcordoServicoContratoService getAcordoServicoContratoService() throws ServiceException {
		if (acordoServicoContratoService == null) {
			acordoServicoContratoService = (AcordoServicoContratoService) ServiceLocator.getInstance().getService(AcordoServicoContratoService.class, null);
		}
		return acordoServicoContratoService;
	}

	private PrioridadeSolicitacoesService getPrioridadeSolicitacoesService() throws ServiceException {
		if (prioridadeSolicitacoesService == null) {
			prioridadeSolicitacoesService = (PrioridadeSolicitacoesService) ServiceLocator.getInstance().getService(PrioridadeSolicitacoesService.class, null);
		}
		return prioridadeSolicitacoesService;
	}

	private BaseConhecimentoService getBaseConhecimentoService() throws ServiceException {
		if (baseConhecimentoService == null) {
			baseConhecimentoService = (BaseConhecimentoService) ServiceLocator.getInstance().getService(BaseConhecimentoService.class, null);
		}
		return baseConhecimentoService;
	}

	private UsuarioService getUsuarioService() throws ServiceException {
		if (usuarioService == null) {
			usuarioService = (UsuarioService) ServiceLocator.getInstance().getService(UsuarioService.class, null);
		}
		return usuarioService;
	}

	private CadastroTemplateIncidenteRequisicaoService getCadastroTemplateIncidenteRequisicaoService() throws ServiceException {
		if (cadastroTemplateIncidenteRequisicaoService == null) {
			cadastroTemplateIncidenteRequisicaoService = (CadastroTemplateIncidenteRequisicaoService) ServiceLocator.getInstance().getService(CadastroTemplateIncidenteRequisicaoService.class, null);
		}
		return cadastroTemplateIncidenteRequisicaoService;
	}

	private CadastroTemplateIncidenteRequisicaoICService getCadastroTemplateIncidenteRequisicaoICService() throws ServiceException {
		if (cadastroTemplateIncidenteRequisicaoICService == null) {
			cadastroTemplateIncidenteRequisicaoICService = (CadastroTemplateIncidenteRequisicaoICService) ServiceLocator.getInstance().getService(CadastroTemplateIncidenteRequisicaoICService.class, null);
		}
		return cadastroTemplateIncidenteRequisicaoICService;
	}

	private VisaoService getVisaoService() throws ServiceException {
		if (visaoService == null) {
			visaoService = (VisaoService) ServiceLocator.getInstance().getService(VisaoService.class, null);
		}
		return visaoService;
	}

	private SmartReportService getSmartReportService() throws ServiceException {
		if (smartReportService == null) {
			smartReportService = (SmartReportService) ServiceLocator.getInstance().getService(SmartReportService.class, null);
		}
		return smartReportService;
	}
}
