package br.com.centralit.citcorpore.ajaxForms;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.GerentePentahoDTO;
import br.com.centralit.citcorpore.bean.ParametroCorporeDTO;
import br.com.centralit.citcorpore.negocio.ParametroCorporeService;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;

/**
 * Gerente da apresentao do relatorio Pentaho.
 * @author ibimon.morais
 * @see 12/02/2016
 */
public class GerentePentaho  extends AjaxFormAction {
	private ParametroCorporeService parametroCorporeService;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		boolean userAutenticado = WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		if (userAutenticado) {
			ParametroCorporeDTO param = getParametroCorporeService().getParamentroAtivo(ParametroSistema.URL_PENTAHO.id());
			document.executeScript("abrirPopupGerenciaPentaho('" + param.getValor() + "');");
		}
	}

	@Override
	public Class<GerentePentahoDTO> getBeanClass() {
		return GerentePentahoDTO.class;
	}

	public ParametroCorporeService getParametroCorporeService() throws ServiceException {
		if (this.parametroCorporeService == null) {
			this.parametroCorporeService = (ParametroCorporeService) ServiceLocator.getInstance().getService(ParametroCorporeService.class, null);
		}
		return parametroCorporeService;
	}

	public void setParametroCorporeService(ParametroCorporeService parametroCorporeService) {
		this.parametroCorporeService = parametroCorporeService;
	}

}