package br.com.centralit.citcorpore.ajaxForms;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.FileItem;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.AtributosFinanceirosDTO;
import br.com.centralit.citcorpore.negocio.ImportarAtributosFinanceirosService;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Enumerados.AuditoriaAcoes;
import br.com.centralit.citcorpore.util.Upload;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;


public class ImportarAtributosFinanceiros extends AjaxFormAction {
	
	
	@Override
	public Class<AtributosFinanceirosDTO> getBeanClass() {
		return AtributosFinanceirosDTO.class;
	}

	private ImportarAtributosFinanceirosService importarAtributosFinanceirosService;
	
	@SuppressWarnings("rawtypes")
	@Override
	public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		HashMap hshRetorno[] = null;
		Upload upload = new Upload();
		AtributosFinanceirosDTO atributosFinanceirosDTO = (AtributosFinanceirosDTO) document.getBean();
        try {
            hshRetorno = upload.doUploadAll(request);
	        if (hshRetorno != null) {
	
	            Collection fileItems = hshRetorno[1].values();
	            String fileName = "";
	            FileItem fi;
	            String mensagemRetorno = "importaratributofinanceiro.falhaimportacao";
	            if (fileItems != null && !fileItems.isEmpty()) {
					Collection<AtributosFinanceirosDTO> listaAtributosFinanceiros = new ArrayList<AtributosFinanceirosDTO>();
	            	File arquivo = null;
	                Iterator it = fileItems.iterator();
	                while (it.hasNext()) {
	                    fi = (FileItem) it.next();
	
	                    if (fi.getName().length() < 1) {
	                    	mensagemRetorno =  "cargaCatalagoServico.selecionarArquivo";
	                        break;
	                    }
	
	                    String extensao = br.com.centralit.citcorpore.util.Util.getFileExtension(fi.getName());
	                    if (!extensao.equalsIgnoreCase("xml") 
	                    		&& !extensao.equalsIgnoreCase("csv")
	                    		&& !extensao.equalsIgnoreCase("xls")
	                    		&& !extensao.equalsIgnoreCase("xlsx") ) {
	                    	mensagemRetorno = "importaratributofinanceiro.erroformato";
	                        break;
	                    }
	                    fileName = fi.getName();
	                    arquivo = new File(CITCorporeUtil.CAMINHO_REAL_APP + "tempFiles/" + fileName);
	                    fi.write(arquivo);
	                    
	                    Integer idServico = null;
	                    if(atributosFinanceirosDTO != null){
	                    	idServico = atributosFinanceirosDTO.getIdServico();
	                    }
						if (idServico != null) {
							if (extensao.equalsIgnoreCase("xml"))
								listaAtributosFinanceiros = getImportarAtributosFinanceirosService().gerarCargaXml(arquivo, idServico);
							else if (extensao.equalsIgnoreCase("xls"))
								listaAtributosFinanceiros = getImportarAtributosFinanceirosService().gerarCargaXls(arquivo, idServico);
							else if (extensao.equalsIgnoreCase("xlsx"))
								listaAtributosFinanceiros = getImportarAtributosFinanceirosService().gerarCargaXlsx(arquivo, idServico);
							else if (extensao.equalsIgnoreCase("csv"))
								listaAtributosFinanceiros = getImportarAtributosFinanceirosService().gerarCargaCsv(arquivo, idServico);

							if (listaAtributosFinanceiros != null && !listaAtributosFinanceiros.isEmpty()) {
								boolean isGravarSucesso = getImportarAtributosFinanceirosService().gravaListAtributosFinanceiros(listaAtributosFinanceiros);
								if (isGravarSucesso) {
									mensagemRetorno = "importaratributofinanceiro.sucesso";
									List<Integer> listaIds = new ArrayList<Integer>();
									for (AtributosFinanceirosDTO atributosFinanceirosimportados : listaAtributosFinanceiros) {
										listaIds.add(atributosFinanceirosimportados.getIdFinanceiroServico());
									}
									atributosFinanceirosDTO.setIdsAtributosFinanceirosOcorrenciaServico(listaIds.toString());
									atributosFinanceirosDTO.setAcaoAtributosFinanceirosOcorrenciaServico(AuditoriaAcoes.ADICIONADO.getIdentificador());
									this.salvarOcorrenciaServicoAtributosFinanceirosImportados(atributosFinanceirosDTO, document, request);
								} else {
									mensagemRetorno = "importaratributofinanceiro.falhaimportacao";
								}
							} else {
								mensagemRetorno = "importaratributofinanceiro.arquivovazio";
							}

						}
	                }

	                document.alert(UtilI18N.internacionaliza(request, mensagemRetorno));
	            	document.executeScript("parent.fecharModalImportar()");
	            }
	        }
        } catch (Exception e){
    		throw e;
        } finally {
    		document.executeScript("parent.escondeJanelaAguarde()");
        }
	}
	
	private ImportarAtributosFinanceirosService getImportarAtributosFinanceirosService() throws ServiceException{
		if(importarAtributosFinanceirosService == null){
			importarAtributosFinanceirosService = (ImportarAtributosFinanceirosService) ServiceLocator.getInstance().getService(ImportarAtributosFinanceirosService.class, null);
		}
		return importarAtributosFinanceirosService;
	}

	/**
	 * @author deborah.ferreira
	 * @since 26.01.2016
	 */
	public void salvarOcorrenciaServicoAtributosFinanceirosImportados(final AtributosFinanceirosDTO atributosFinanceirosDTO, final DocumentHTML document, final HttpServletRequest request)
			throws Exception {
		GerenciamentoPortfolioOcorrenciasServico gerenciamentoPortfolioOcorrenciasServico = new GerenciamentoPortfolioOcorrenciasServico();
		gerenciamentoPortfolioOcorrenciasServico.salvaOcorrenciaServicoAtributosFinanceiros(atributosFinanceirosDTO.getIdServico(),
				atributosFinanceirosDTO.getIdsAtributosFinanceirosOcorrenciaServico(), atributosFinanceirosDTO, document, request);
	}

}
