package br.com.centralit.citcorpore.ajaxForms;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.FileItem;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.CargaPortfolioServicoDTO;
import br.com.centralit.citcorpore.negocio.ImportarCargaPortfolioServicoService;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Enumerados.CamposCargaServicoPortfolio;
import br.com.centralit.citcorpore.util.Enumerados.LogicExceptionCause;
import br.com.centralit.citcorpore.util.Enumerados.TipoDate;
import br.com.centralit.citcorpore.util.Upload;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;

@SuppressWarnings({ "rawtypes" })
public class ImportarCargaPortfolioServico extends AjaxFormAction {
	private ImportarCargaPortfolioServicoService importarCargaPortfolioServicoService;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		HashMap hshRetorno[] = null;
		Upload upload = new Upload();
		try {
			hshRetorno = upload.doUploadAll(request);
			if (hshRetorno != null) {

				Collection fileItems = hshRetorno[1].values();
				String fileName = "";
				FileItem fi;
				String mensagemRetorno = "cargaPortfolioServico.validacao.falhaimportacao";
				if (fileItems != null && !fileItems.isEmpty()) {
					Collection<CargaPortfolioServicoDTO> listaCargaPortfolioServico = new ArrayList<CargaPortfolioServicoDTO>();
					File arquivo = null;
					Iterator it = fileItems.iterator();
					while (it.hasNext()) {
						fi = (FileItem) it.next();

						if (fi.getName().length() < 1) {
							mensagemRetorno = "cargaCatalagoServico.selecionarArquivo";
							break;
						}

						String extensao = br.com.centralit.citcorpore.util.Util.getFileExtension(fi.getName());
						if (!extensao.equalsIgnoreCase("xls") && !extensao.equalsIgnoreCase("xlsx")) {
							mensagemRetorno = "cargaPortfolioServico.validacao.erroformato";
							break;
						}
						fileName = fi.getName();
						arquivo = new File(CITCorporeUtil.CAMINHO_REAL_APP + "tempFiles/" + fileName);
						fi.write(arquivo);

						if (extensao.equalsIgnoreCase("xls"))
							listaCargaPortfolioServico = getImportarCargaPortfolioServicoService().gerarCargaXls(request, arquivo);

						if (extensao.equalsIgnoreCase("xlsx"))
							listaCargaPortfolioServico = getImportarCargaPortfolioServicoService().gerarCargaXlsx(request, arquivo);

						if (listaCargaPortfolioServico != null && !listaCargaPortfolioServico.isEmpty()) {
							printCargaPortfolioServico(request, listaCargaPortfolioServico);

							boolean isGravarSucesso = getImportarCargaPortfolioServicoService().gravarCargaPortfolioServico(request, listaCargaPortfolioServico);
							if (isGravarSucesso) {
								mensagemRetorno = "cargaPortfolioServico.validacao.sucesso";
							} else {
								mensagemRetorno = "cargaPortfolioServico.validacao.falhaimportacao";
							}
						} else {
							mensagemRetorno = "cargaPortfolioServico.validacao.erroImportar";
						}

					}

					document.alert(UtilI18N.internacionaliza(request, mensagemRetorno));
				}
			}
		} catch (LogicException le) {
			if (le.getCause() != null && LogicExceptionCause.IMPORT_ERROR.getIdStr().equals(le.getCause().getMessage())) {
				LogicExceptionCause logicExceptionCause = LogicExceptionCause.fromIdStr(le.getCause().getMessage());
				String causaErro = logicExceptionCause != null ? UtilI18N.internacionaliza(request, logicExceptionCause.getI18NKey()) : "ERROR";
				document.executeScript("ImportarCargaPortfolioServico.exibirErro('".concat(causaErro).concat("', \"").concat(le.getMessage()).concat("\")"));
			} else {
				document.alert(UtilI18N.internacionaliza(request, LogicExceptionCause.IMPORT_ERROR.getI18NKey())+". " + UtilI18N.internacionaliza(request, le.getMessage()));
			}
		} catch (Exception e) {
			throw e;
		} finally {
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
		}

	}
	
	private void printCargaPortfolioServico(HttpServletRequest request, Collection<CargaPortfolioServicoDTO> listaCargaPortfolioServico) {
		System.out.println("---------- "+UtilI18N.internacionaliza(request, "cargaPortfolioServico.nome")+" ----------");
		System.out.print(" | ");
		for (CamposCargaServicoPortfolio campoCarga : CamposCargaServicoPortfolio.values()) {
			System.out.print(UtilI18N.internacionaliza(request, campoCarga.getChave()));
			System.out.print(" | ");
		}
		System.out.println("");
		for (CargaPortfolioServicoDTO carga : listaCargaPortfolioServico) {
			System.out.print(" | ");
			System.out.print(carga.getCargaNomePortfolio());
			System.out.print(" | ");
			System.out.print(carga.getCargaNomeServico());
			System.out.print(" | ");
			System.out.print(carga.getCargaCategoriaNegocioServico());
			System.out.print(" | ");
			System.out.print(UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, carga.getCargaDataImplantacaoServico(), WebUtil.getLanguage(request)));
			System.out.print(" | ");
			System.out.print(carga.getCargaFaseServico());
			System.out.print(" | ");
			System.out.print(carga.getCargaStatusServico());
			System.out.print(" | ");
			System.out.print(carga.getCargaCriticidadeClassificacaoServico());
			System.out.print(" | ");
			System.out.print(carga.getCargaTipoInvestimentoClassificacaoServico());
			System.out.print(" | ");
			System.out.print(carga.getCargaDemandaClassificacaoServico());
			System.out.print(" | ");
			System.out.print(carga.getCargaRetornoFinanceiroClassificacaoServico());
			System.out.print(" | ");
			System.out.print(carga.getCargaNomeServicoIncReq());
			System.out.print(" | ");
			System.out.print(carga.getCargaSituacaoServicoIncReq());
			System.out.print(" | ");
			System.out.print(UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, carga.getCargaDataImplantacaoServicoIncReq(), WebUtil.getLanguage(request)));
			System.out.print(" | ");
			System.out.print(carga.getCargaTipoDemandaServicoIncReq());
			System.out.print(" | ");
			System.out.print(carga.getCargaCategoriaServicoIncReq());
			System.out.print(" | ");
			System.out.print(carga.getCargaDispPortalServicoIncReq());

			System.out.println("");
		}
		System.out.println("---------- ---------- ---------- ---------- ---------- ---------- ---------- ----------");
	}


	private ImportarCargaPortfolioServicoService getImportarCargaPortfolioServicoService() throws ServiceException {
		if (importarCargaPortfolioServicoService == null) {
			importarCargaPortfolioServicoService = (ImportarCargaPortfolioServicoService) ServiceLocator.getInstance().getService(ImportarCargaPortfolioServicoService.class, null);
		}
		return importarCargaPortfolioServicoService;
	}

	@Override
	public Class<CargaPortfolioServicoDTO> getBeanClass() {
		return CargaPortfolioServicoDTO.class;
	}

}
