package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citcorpore.bean.ImportarIndicadorCapacidadeDTO;
import br.com.centralit.citcorpore.bean.IndicadorCapacidadeDTO;
import br.com.centralit.citcorpore.bean.IndicadorCapacidadeServicoDTO;
import br.com.centralit.citcorpore.negocio.IndicadorCapacidadeService;
import br.com.centralit.citcorpore.negocio.IndicadorCapacidadeServicoService;
import br.com.centralit.citcorpore.negocio.OcorrenciaServicoService;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.PagesPortfolio;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;

public class ImportarIndicadoresCapacidade extends AjaxFormAction {

	private IndicadorCapacidadeService indicadorCapacidadeService;
	private IndicadorCapacidadeServicoService indicadorCapacidadeServicoService;
	private OcorrenciaServicoService ocorrenciaServicoService;
	private static Permissoes permissao;
	
	@Override
	public Class<ImportarIndicadorCapacidadeDTO> getBeanClass() {
		return ImportarIndicadorCapacidadeDTO.class;
	}

	@Override
	public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		permissao = new Permissoes(document, request, PagesPortfolio.SERVICO_NEGOCIO_INDICADORES_CAPACIDADE_PERFORMANCE.getCaminho());
		ImportarIndicadorCapacidadeDTO beanDto = (ImportarIndicadorCapacidadeDTO) document.getBean();

		if (beanDto != null && !UtilNumbersAndDecimals.isNull(beanDto.getIdServico())) {
			this.restoreIndicadoresCapacidade(beanDto, document, request);
		}

	}
	
	public void save(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		if (permissao.isGravar()) {
			ImportarIndicadorCapacidadeDTO beanDto = (ImportarIndicadorCapacidadeDTO) document.getBean();
			if (beanDto.getIndicadorCapacidadeCheck() != null) {
				for (Integer idIndicadorCapacidade : beanDto.getIndicadorCapacidadeCheck()) {
					IndicadorCapacidadeServicoDTO indicadorCapacidadeServicoDTO = new IndicadorCapacidadeServicoDTO();
					indicadorCapacidadeServicoDTO.setIdServico(beanDto.getIdServico());
					indicadorCapacidadeServicoDTO.setIdIndicadorCapacidade(idIndicadorCapacidade);
					getIndicadorCapacidadeServicoService().create(indicadorCapacidadeServicoDTO);
				}
				this.getOcorrenciaServicoService().salvaOcorrenciaServicoCapacidade(beanDto.getIdServico(), Enumerados.AuditoriaAcoes.VINCULADO.getIdentificador(), beanDto.getIndicadorCapacidadeCheck(), document,
						request);
			}
			document.executeScript("atualizaTelaIndicadorCapacidadeServico();");
			document.executeScript("Modal.close('modal-portfolio-indicador-capacidade-adicionar');");
		} else {
			document.executeScript("Modal.close('modal-portfolio-indicador-capacidade-adicionar');");
			document.executeScript("notificacaoErro('citcorpore.comum.naoFoiPossivelVincular','citcorpore.comum.usuarioSemPermissao')");
		}
	}

	private void restoreIndicadoresCapacidade(ImportarIndicadorCapacidadeDTO indicadorCapacidadeService, final DocumentHTML document, final HttpServletRequest request) throws ServiceException, Exception {
		if(indicadorCapacidadeService != null && indicadorCapacidadeService.getIdServico() != null){
			this.preencheTabela(indicadorCapacidadeService, document, request);
		}

	}

	private void preencheTabela(ImportarIndicadorCapacidadeDTO indicadorCapacidadeService, final DocumentHTML document, final HttpServletRequest request) throws ServiceException, Exception {
		HTMLElement divTabela = document.getElementById("tabelaIndicadoresCapacidade");
		ImportarIndicadorCapacidadeDTO beanDto = (ImportarIndicadorCapacidadeDTO) document.getBean();
		document.executeScript("limpaTabelaIndicadoresCapacidade()");
		List<Integer> listIdIndicadorCapacidade = convertListIndicadorCapacidadeServicoToListIdIndicadorCapacidade(getIndicadorCapacidadeServicoService().listAllByIdServico(beanDto.getIdServico()));
		Collection<IndicadorCapacidadeDTO> listIndicadores = getIndicadorCapacidadeService().list();
		StringBuilder sb = new StringBuilder();
		if(listIndicadores != null && !listIndicadores.isEmpty()){
			sb.append("		<table class='dynamicTable table table-striped table-bordered' id='tableIndicadorCapacidade'> ");
			sb.append("			<thead> ");
			sb.append("				<tr> ");
			sb.append("					<th><input type='checkbox' name='indicadorCapacidadeAll' id='indicadorCapacidadeAll' onChange='markAll()'/></th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.nome") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.valor") + "</th> ");
			sb.append("				</tr> ");
			sb.append("			</thead> ");
			sb.append("			<tbody> ");

			for (IndicadorCapacidadeDTO indicadorCapacidadeDTO : listIndicadores) {
				Integer id = indicadorCapacidadeDTO.getIdIndicadorCapacidade();
				if(!listIdIndicadorCapacidade.contains(indicadorCapacidadeDTO.getIdIndicadorCapacidade())){
					sb.append("		<tr>");
					sb.append("			<td>")
						.append("			<input class='checkIndicadorCapacidade' type='checkbox' name='indicadorCapacidadeCheck' onChange='checkCheckBoxes()' id='indicador").append(id).append("' value='").append(id).append("'").append(" />")
						.append("		</td>");
					sb.append("			<td>"+indicadorCapacidadeDTO.getNome()+"</td>");
					sb.append("			<td>"+indicadorCapacidadeDTO.getValor().toString()+"</td>");
					sb.append("		</tr>");
				}
			}
			sb.append("			</tbody> ");
			sb.append("		</table> ");
			sb.append("");

			sb.append("<div class='separator'></div>");
			divTabela.appendHTML(sb.toString());
		}else{
			sb.append("<h4>" + UtilI18N.internacionaliza(request, "gerenciamentoportfolio.indicadoresCapacidade.nenhumIndicadorCapacidadeCadastrado"));
			divTabela.appendHTML(sb.toString());
		}
	}
	
	private List<Integer> convertListIndicadorCapacidadeServicoToListIdIndicadorCapacidade(List<IndicadorCapacidadeServicoDTO> listIndicadorCapacidadeServico){
		List<Integer> listId = new ArrayList<>();
		if(listId != null){
			for(IndicadorCapacidadeServicoDTO indicador : listIndicadorCapacidadeServico){
				listId.add(indicador.getIdIndicadorCapacidade());
			}
		}
		return listId;
	}

	private IndicadorCapacidadeService getIndicadorCapacidadeService() throws ServiceException{
		if(indicadorCapacidadeService == null)
			indicadorCapacidadeService = (IndicadorCapacidadeService) ServiceLocator.getInstance().getService(IndicadorCapacidadeService.class, null);
		return indicadorCapacidadeService;
	}
	
	private IndicadorCapacidadeServicoService getIndicadorCapacidadeServicoService() throws ServiceException{
		if(indicadorCapacidadeServicoService == null)
			indicadorCapacidadeServicoService = (IndicadorCapacidadeServicoService) ServiceLocator.getInstance().getService(IndicadorCapacidadeServicoService.class, null);
		return indicadorCapacidadeServicoService	;
	}

	private OcorrenciaServicoService getOcorrenciaServicoService() throws ServiceException {
		if (ocorrenciaServicoService == null)
			ocorrenciaServicoService = (OcorrenciaServicoService) ServiceLocator.getInstance().getService(OcorrenciaServicoService.class, null);
		return ocorrenciaServicoService;
	}

}
