package br.com.centralit.citcorpore.ajaxForms;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.FileItem;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.IndicadorCapacidadeDTO;
import br.com.centralit.citcorpore.negocio.IndicadorCapacidadeService;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Upload;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;

public class IndicadorCapacidade extends AjaxFormAction {

	@Override
	public Class<IndicadorCapacidadeDTO> getBeanClass() {
		return IndicadorCapacidadeDTO.class;
	}

	private IndicadorCapacidadeService indicadorCapacidadeService;
	
	@SuppressWarnings("rawtypes")
	@Override
	public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		HashMap hshRetorno[] = null;
		Upload upload = new Upload();
        try {
            hshRetorno = upload.doUploadAll(request);
	        if (hshRetorno != null) {
	
	            Collection fileItems = hshRetorno[1].values();
	            String fileName = "";
	            FileItem fi;
	            String mensagemRetorno = "importaratributofinanceiro.falhaimportacao";
	            if (fileItems != null && !fileItems.isEmpty()) {
	            	File arquivo = null;
	                Iterator it = fileItems.iterator();
	                while (it.hasNext()) {
	                    fi = (FileItem) it.next();
	
	                    if (fi.getName().length() < 1) {
	                    	mensagemRetorno =  "cargaCatalagoServico.selecionarArquivo";
	                        break;
	                    }
	
	                    String extensao = br.com.centralit.citcorpore.util.Util.getFileExtension(fi.getName());
	                    if (!extensao.equalsIgnoreCase("xml") 
	                    		&& !extensao.equalsIgnoreCase("csv")
	                    		&& !extensao.equalsIgnoreCase("xls")
	                    		&& !extensao.equalsIgnoreCase("xlsx") ) {
	                    	mensagemRetorno = "importaratributofinanceiro.erroformato";
	                        break;
	                    }
	                    fileName = fi.getName();
	                    arquivo = new File(CITCorporeUtil.CAMINHO_REAL_APP + "tempFiles/" + fileName);
	                    fi.write(arquivo);
	                    mensagemRetorno = getIndicadorCapacidadeService().importarDados(arquivo, request);

	                    document.alert(UtilI18N.internacionaliza(request, mensagemRetorno));
					}
                }
            }
        } catch (Exception e){
    		throw e;
        } finally {
        }
	}
	
	public void save(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		IndicadorCapacidadeDTO indicadorCapacidadeDTO = (IndicadorCapacidadeDTO) document.getBean();
		String mensagem = "MSE02";
		if(indicadorCapacidadeDTO.getIdIndicadorCapacidade() == null){
			indicadorCapacidadeDTO = (IndicadorCapacidadeDTO) getIndicadorCapacidadeService().create(indicadorCapacidadeDTO);
			if(indicadorCapacidadeDTO.getIdIndicadorCapacidade() != null){
				mensagem = "MSG05";
			}
		} else {
			getIndicadorCapacidadeService().update(indicadorCapacidadeDTO);
			mensagem = "MSG06";
		}
		document.executeScript("notificacaoI18N('".concat(mensagem).concat("');"));
		document.executeScript("limpar()");
	}
	
	public void restore(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		IndicadorCapacidadeDTO indicadorCapacidadeDTO = (IndicadorCapacidadeDTO) document.getBean();
		indicadorCapacidadeDTO = (IndicadorCapacidadeDTO) getIndicadorCapacidadeService().restore(indicadorCapacidadeDTO);
		document.getForm("form").clear();
		document.getForm("form").setValues(indicadorCapacidadeDTO);

	}
	
	public void delete(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		IndicadorCapacidadeDTO indicadorCapacidadeDTO = (IndicadorCapacidadeDTO) document.getBean();
		if(indicadorCapacidadeDTO != null && indicadorCapacidadeDTO.getIdIndicadorCapacidade() != null){
			getIndicadorCapacidadeService().delete(indicadorCapacidadeDTO);
			document.executeScript("notificacaoI18N('MSG07');");
			document.executeScript("limpar()");
		}else{
			document.executeScript("notificacaoErro('MSG04');");
		}
	}

	
	private IndicadorCapacidadeService getIndicadorCapacidadeService() throws ServiceException{
		if(indicadorCapacidadeService == null){
			indicadorCapacidadeService = (IndicadorCapacidadeService) ServiceLocator.getInstance().getService(IndicadorCapacidadeService.class, null);
		}
		return indicadorCapacidadeService;
	}

}
