package br.com.centralit.citcorpore.ajaxForms;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

import javax.naming.InitialContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;

import br.com.centralit.authentication.Auth;
import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citcorpore.bean.ADUserDTO;
import br.com.centralit.citcorpore.bean.BaseDTO;
import br.com.centralit.citcorpore.bean.EmailDTO;
import br.com.centralit.citcorpore.bean.EmpresaDTO;
import br.com.centralit.citcorpore.bean.GedDTO;
import br.com.centralit.citcorpore.bean.GeralDTO;
import br.com.centralit.citcorpore.bean.ICDTO;
import br.com.centralit.citcorpore.bean.InstalacaoDTO;
import br.com.centralit.citcorpore.bean.LdapDTO;
import br.com.centralit.citcorpore.bean.LogDTO;
import br.com.centralit.citcorpore.bean.ParametroCorporeDTO;
import br.com.centralit.citcorpore.bean.SmtpDTO;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.integracao.ad.LDAPUtils;
import br.com.centralit.citcorpore.metainfo.bean.VisaoDTO;
import br.com.centralit.citcorpore.metainfo.negocio.VisaoService;
import br.com.centralit.citcorpore.negocio.DataBaseMetaDadosService;
import br.com.centralit.citcorpore.negocio.EmpresaService;
import br.com.centralit.citcorpore.negocio.InstalacaoService;
import br.com.centralit.citcorpore.negocio.MenuService;
import br.com.centralit.citcorpore.negocio.ParametroCorporeService;
import br.com.centralit.citcorpore.negocio.ScriptsService;
import br.com.centralit.citcorpore.negocio.VersaoService;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.FiltroSegurancaCITSmart;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.centralit.citcorpore.versao.Versao;
import br.com.centralit.dto.L;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.ConnectionProvider;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.SQLConfig;
import br.com.citframework.util.ScriptRunner;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.XmlReadLookup;

public class Instalacao extends AjaxFormAction {

	private InstalacaoService instalacaoService;
	private MenuService menuService;
	private ParametroCorporeService parametroCorporeService;
	private ScriptsService scriptsService;
	private VersaoService versaoService;
	private EmpresaService empresaService;

	private final String DEFAULT = "";

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
	}

	/**
	 * Carrega os paramatros do LDAP
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws ServiceException
	 * @throws Exception
	 */
	public void carregaParametrosLDAP(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		document.executeScript("deleteAllRowsTabelaAtributosLdap()");

		document.executeScript("addLinhaTabelaAtributosLdap(" + ParametroSistema.LDAP_URL.id() + ",'" + this.escape(ParametroSistema.LDAP_URL.getCampoParametroInternacionalizado(request)) + "','"
				+ this.escapeValor(ParametroSistema.LDAP_URL) + " ')");
		document.executeScript("addLinhaTabelaAtributosLdap(" + ParametroSistema.DOMINIO_AD.id() + ",'" + this.escape(ParametroSistema.DOMINIO_AD.getCampoParametroInternacionalizado(request)) + "','"
				+ this.escapeValor(ParametroSistema.DOMINIO_AD) + " ')");
		document.executeScript("addLinhaTabelaAtributosLdap(" + ParametroSistema.LDAP_SUBDOMINIO.id() + ",'"
				+ this.escape(ParametroSistema.LDAP_SUBDOMINIO.getCampoParametroInternacionalizado(request)) + "','" + this.escapeValor(ParametroSistema.LDAP_SUBDOMINIO) + " ')");
		document.executeScript("addLinhaTabelaAtributosLdap(" + ParametroSistema.LDAD_SUFIXO_DOMINIO.id() + ",'"
				+ this.escape(ParametroSistema.LDAD_SUFIXO_DOMINIO.getCampoParametroInternacionalizado(request)) + "','" + this.escapeValor(ParametroSistema.LDAD_SUFIXO_DOMINIO) + " ')");
		document.executeScript("addLinhaTabelaAtributosLdap(" + ParametroSistema.LOGIN_AD.id() + ",'" + this.escape(ParametroSistema.LOGIN_AD.getCampoParametroInternacionalizado(request)) + "','"
				+ this.escapeValor(ParametroSistema.LOGIN_AD) + " ')");
		document.executeScript("addLinhaTabelaAtributosLdap(" + ParametroSistema.SENHA_AD.id() + ",'" + this.escape(ParametroSistema.SENHA_AD.getCampoParametroInternacionalizado(request)) + "','"
				+ this.escapeValor(ParametroSistema.SENHA_AD) + " ')");
		document.executeScript("addLinhaTabelaAtributosLdap(" + ParametroSistema.LDAP_FILTRO.id() + ",'" + this.escape(ParametroSistema.LDAP_FILTRO.getCampoParametroInternacionalizado(request))
				+ "','" + this.escapeValor(ParametroSistema.LDAP_FILTRO) + " ')");
		document.executeScript("addLinhaTabelaAtributosLdap(" + ParametroSistema.LDAP_ATRIBUTO.id() + ",'" + this.escape(ParametroSistema.LDAP_ATRIBUTO.getCampoParametroInternacionalizado(request))
				+ "','" + this.escapeValor(ParametroSistema.LDAP_ATRIBUTO) + " ')");
		document.executeScript("addLinhaTabelaAtributosLdap(" + ParametroSistema.LDAP_SN_LAST_NAME.id() + ",'"
				+ this.escape(ParametroSistema.LDAP_SN_LAST_NAME.getCampoParametroInternacionalizado(request)) + "','" + this.escapeValor(ParametroSistema.LDAP_SN_LAST_NAME) + " ')");
		document.executeScript("addLinhaTabelaAtributosLdap(" + ParametroSistema.ID_PERFIL_ACESSO_DEFAULT.id() + ",'"
				+ this.escape(ParametroSistema.ID_PERFIL_ACESSO_DEFAULT.getCampoParametroInternacionalizado(request)) + "','" + this.escapeValor(ParametroSistema.ID_PERFIL_ACESSO_DEFAULT) + " ')");
		document.executeScript("addLinhaTabelaAtributosLdap(" + ParametroSistema.ID_GRUPO_PADRAO_LDAP.id() + ",'"
				+ this.escape(ParametroSistema.ID_GRUPO_PADRAO_LDAP.getCampoParametroInternacionalizado(request)) + "','" + this.escapeValor(ParametroSistema.ID_GRUPO_PADRAO_LDAP) + " ')");
		document.executeScript("addLinhaTabelaAtributosLdap(" + ParametroSistema.NUMERO_COLABORADORES_CONSULTA_AD.id() + ",'"
				+ this.escape(ParametroSistema.NUMERO_COLABORADORES_CONSULTA_AD.getCampoParametroInternacionalizado(request)) + "','"
				+ this.escapeValor(ParametroSistema.NUMERO_COLABORADORES_CONSULTA_AD) + " ')");
		document.executeScript("addLinhaTabelaAtributosLdap(" + ParametroSistema.LDAP_MOSTRA_BOTAO.id() + ",'"
				+ StringEscapeUtils.escapeJavaScript(ParametroSistema.LDAP_MOSTRA_BOTAO.getCampoParametroInternacionalizado(request)) + "','"
				+ this.escapeValor(ParametroSistema.LDAP_MOSTRA_BOTAO, "N") + " ')");
	}

	public void carregaEmail(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		document.executeScript("deleteAllRowsTabelaAtributosEmail()");

		document.executeScript("addLinhaEmail(" + ParametroSistema.SMTP_ENVIO_RemetenteNotificacoesSolicitacao.id() + "," + "'"
				+ this.escape(ParametroSistema.SMTP_ENVIO_RemetenteNotificacoesSolicitacao.getCampoParametroInternacionalizado(request)) + "'," + "'"
				+ this.escapeValor(ParametroSistema.SMTP_ENVIO_RemetenteNotificacoesSolicitacao) + "'," + "'N')");
		document.executeScript("addLinhaEmail(" + ParametroSistema.SMTP_ENVIO_Usuario.id() + "," + "'" + this.escape(ParametroSistema.SMTP_ENVIO_Usuario.getCampoParametroInternacionalizado(request))
				+ "'," + "'" + this.escapeValor(ParametroSistema.SMTP_ENVIO_Usuario) + "'," + "'N')");
		document.executeScript("addLinhaEmail(" + ParametroSistema.SMTP_ENVIO_Senha.id() + "," + "'" + this.escape(ParametroSistema.SMTP_ENVIO_Senha.getCampoParametroInternacionalizado(request))
				+ "'," + "'" + this.escapeValor(ParametroSistema.SMTP_ENVIO_Senha) + "'," + "'N')");
		document.executeScript("addLinhaEmail(" + ParametroSistema.SMTP_ENVIO_Autenticacao.id() + "," + "'"
				+ this.escape(ParametroSistema.SMTP_ENVIO_Autenticacao.getCampoParametroInternacionalizado(request)) + "'," + "'" + this.escapeValor(ParametroSistema.SMTP_ENVIO_Autenticacao) + "',"
				+ "'S')");
		document.executeScript("changeCheck()");
	}

	/**
	 * Carrega as informaes dos parametros do sistema para log
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws ServiceException
	 * @throws Exception
	 */
	public void carregaLog(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		document.executeScript("deleteAllRowsTabelaAtributosLog()");

		document.executeScript("addLinhaLog(" + ParametroSistema.USE_LOG.id() + "," + "'" + StringEscapeUtils.escapeJavaScript(ParametroSistema.USE_LOG.getCampoParametroInternacionalizado(request))
				+ "'," + "'" + this.escapeValor(ParametroSistema.USE_LOG) + "'," + "'S','','','')");
		document.executeScript("addLinhaLog(" + ParametroSistema.FILE_LOG.id() + "," + "'" + this.escape(ParametroSistema.FILE_LOG.getCampoParametroInternacionalizado(request)) + "'," + "'"
				+ this.escapeValor(ParametroSistema.FILE_LOG) + "'," + "'N', '', '', '')");
		document.executeScript("addLinhaLog(" + ParametroSistema.PATH_LOG.id() + "," + "'" + this.escape(ParametroSistema.PATH_LOG.getCampoParametroInternacionalizado(request)) + "'," + "'"
				+ this.escapeValor(ParametroSistema.PATH_LOG) + "'," + "'N', 'true', 'onblur', 'validaDiretorio(this);')");
		document.executeScript("addLinhaLog(" + ParametroSistema.TIPO_LOG.id() + "," + "'" + this.escape(ParametroSistema.TIPO_LOG.getCampoParametroInternacionalizado(request)) + "'," + "'"
				+ this.escapeValor(ParametroSistema.TIPO_LOG) + "'," + "'N','true','','')");
		document.executeScript("addLinhaLog(" + ParametroSistema.EXT_LOG.id() + "," + "'" + this.escape(ParametroSistema.EXT_LOG.getCampoParametroInternacionalizado(request)) + "'," + "'"
				+ this.escapeValor(ParametroSistema.EXT_LOG) + "'," + "'N','','','')");
		document.executeScript("changeCheck()");
	}

	/**
	 * Carrega as informaes do gerenciamento eletronico de documentos
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws ServiceException
	 * @throws Exception
	 */
	public void carregaGED(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		document.executeScript("deleteAllRowsTabelaAtributosGed()");
		document.executeScript("addLinhaGed(" + ParametroSistema.DISKFILEUPLOAD_REPOSITORYPATH.id() + "," + "'"
				+ this.escape(ParametroSistema.DISKFILEUPLOAD_REPOSITORYPATH.getCampoParametroInternacionalizado(request)) + "'," + "'"
				+ this.escapeValor(ParametroSistema.DISKFILEUPLOAD_REPOSITORYPATH) + "'," + "'N', 'true', 'onblur', 'validaDiretorio(this);')");

		document.executeScript("addLinhaGed(" + ParametroSistema.GedDiretorio.id() + "," + "'" + this.escape(ParametroSistema.GedDiretorio.getCampoParametroInternacionalizado(request)) + "'," + "'"
				+ this.escapeValor(ParametroSistema.GedDiretorio) + "'," + "'N', 'true', 'onblur', 'validaDiretorio(this);')");
		document.executeScript("changeCheck()");
	}

	/**
	 * Carrega as informaes do gerenciamento eletronico de documentos
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws ServiceException
	 * @throws Exception
	 */
	public void carregaSMTP(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		document.executeScript("deleteAllRowsTabelaAtributosSMTP()");

		document.executeScript("addLinhaSMTP(" + ParametroSistema.SMTP_ENVIO_Servidor.id() + "," + "'" + this.escape(ParametroSistema.SMTP_ENVIO_Servidor.getCampoParametroInternacionalizado(request))
				+ "'," + "'" + this.escapeValor(ParametroSistema.SMTP_ENVIO_Servidor) + "'," + "'N', '')");
		document.executeScript("addLinhaSMTP(" + ParametroSistema.SMTP_ENVIO_Porta.id() + "," + "'" + this.escape(ParametroSistema.SMTP_ENVIO_Porta.getCampoParametroInternacionalizado(request))
				+ "'," + "'" + this.escapeValor(ParametroSistema.SMTP_ENVIO_Porta) + "'," + "'N', 'Format[Numero]')");
		document.executeScript("addLinhaSMTP(" + ParametroSistema.SMTP_LEITURA_Servidor.id() + "," + "'"
				+ this.escape(ParametroSistema.SMTP_LEITURA_Servidor.getCampoParametroInternacionalizado(request)) + "'," + "'" + this.escapeValor(ParametroSistema.SMTP_LEITURA_Servidor) + "',"
				+ "'N', '')");
		document.executeScript("addLinhaSMTP(" + ParametroSistema.SMTP_LEITURA_Usuario.id() + "," + "'"
				+ this.escape(ParametroSistema.SMTP_LEITURA_Usuario.getCampoParametroInternacionalizado(request)) + "'," + "'" + this.escapeValor(ParametroSistema.SMTP_LEITURA_Usuario) + "',"
				+ "'N', '')");
		document.executeScript("addLinhaSMTP(" + ParametroSistema.SMTP_LEITURA_Senha.id() + "," + "'" + this.escape(ParametroSistema.SMTP_LEITURA_Senha.getCampoParametroInternacionalizado(request))
				+ "'," + "'" + this.escapeValor(ParametroSistema.SMTP_LEITURA_Senha) + "'," + "'N', '')");
		document.executeScript("addLinhaSMTP(" + ParametroSistema.SMTP_LEITURA_Provider.id() + "," + "'"
				+ this.escape(ParametroSistema.SMTP_LEITURA_Provider.getCampoParametroInternacionalizado(request)) + "'," + "'" + this.escapeValor(ParametroSistema.SMTP_LEITURA_Provider) + "',"
				+ "'N', '')");
		document.executeScript("addLinhaSMTP(" + ParametroSistema.SMTP_LEITURA_Porta.id() + "," + "'" + this.escape(ParametroSistema.SMTP_LEITURA_Porta.getCampoParametroInternacionalizado(request))
				+ "'," + "'" + this.escapeValor(ParametroSistema.SMTP_LEITURA_Porta) + "'," + "'N', 'Format[Numero]')");
		document.executeScript("addLinhaSMTP(" + ParametroSistema.SMTP_LEITURA_Pasta.id() + "," + "'" + this.escape(ParametroSistema.SMTP_LEITURA_Pasta.getCampoParametroInternacionalizado(request))
				+ "'," + "'" + this.escapeValor(ParametroSistema.SMTP_LEITURA_Pasta) + "'," + "'N', '')");
		document.executeScript("addLinhaSMTP(" + ParametroSistema.SMTP_LEITURA_LIMITE_.id() + "," + "'"
				+ this.escape(ParametroSistema.SMTP_LEITURA_LIMITE_.getCampoParametroInternacionalizado(request)) + "'," + "'" + this.escapeValor(ParametroSistema.SMTP_LEITURA_LIMITE_) + "',"
				+ "'N', 'Format[Numero]')");
		document.executeScript("changeCheck()");
	}

	/**
	 * Carrega as informaes do gerenciamento eletronico de documentos
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws ServiceException
	 * @throws Exception
	 */
	public void carregaParametrosIC(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		document.executeScript("deleteAllRowsTabelaAtributosIC()");

		document.executeScript("addLinhaParametrosIC(" + ParametroSistema.CICLO_DE_VIDA_IC_DESENVOLVIMENTO.id() + "," + "'"
				+ this.escape(ParametroSistema.CICLO_DE_VIDA_IC_DESENVOLVIMENTO.getCampoParametroInternacionalizado(request)) + "'," + "'"
				+ this.escapeValor(ParametroSistema.CICLO_DE_VIDA_IC_DESENVOLVIMENTO) + "'," + "'N', '', '', '', '')");
		document.executeScript("addLinhaParametrosIC(" + ParametroSistema.CICLO_DE_VIDA_IC_PRODUCAO.id() + "," + "'"
				+ this.escape(ParametroSistema.CICLO_DE_VIDA_IC_PRODUCAO.getCampoParametroInternacionalizado(request)) + "'," + "'" + this.escapeValor(ParametroSistema.CICLO_DE_VIDA_IC_PRODUCAO)
				+ "'," + "'N', '', '', '', '')");
		document.executeScript("addLinhaParametrosIC(" + ParametroSistema.CICLO_DE_VIDA_IC_HOMOLOGACAO.id() + "," + "'"
				+ this.escape(ParametroSistema.CICLO_DE_VIDA_IC_HOMOLOGACAO.getCampoParametroInternacionalizado(request)) + "'," + "'"
				+ this.escapeValor(ParametroSistema.CICLO_DE_VIDA_IC_HOMOLOGACAO) + "'," + "'N', '', '', '', '')");
		document.executeScript("addLinhaParametrosIC(" + ParametroSistema.NOME_INVENTARIO.id() + "," + "'" + this.escape(ParametroSistema.NOME_INVENTARIO.getCampoParametroInternacionalizado(request))
				+ "'," + "'" + this.escapeValor(ParametroSistema.NOME_INVENTARIO) + "'," + "'N', '', '', '', '')");
		document.executeScript("addLinhaParametrosIC(" + ParametroSistema.ITEM_CONFIGURACAO_MUDANCA.id() + "," + "'"
				+ StringEscapeUtils.escapeJavaScript(ParametroSistema.ITEM_CONFIGURACAO_MUDANCA.getCampoParametroInternacionalizado(request)) + "'," + "'"
				+ this.escapeValor(ParametroSistema.ITEM_CONFIGURACAO_MUDANCA) + "'," + "'S', '', '', '', '')");
		document.executeScript("addLinhaParametrosIC(" + ParametroSistema.ENVIO_PADRAO_EMAIL_IC.id() + "," + "'"
				+ this.escape(ParametroSistema.ENVIO_PADRAO_EMAIL_IC.getCampoParametroInternacionalizado(request)) + "'," + "'" + this.escapeValor(ParametroSistema.ENVIO_PADRAO_EMAIL_IC) + "',"
				+ "'N', '', '', '', 'Format[Numero]')");
		document.executeScript("addLinhaParametrosIC(" + ParametroSistema.AVISAR_DATAEXPIRACAO_LICENCA.id() + "," + "'"
				+ this.escape(ParametroSistema.AVISAR_DATAEXPIRACAO_LICENCA.getCampoParametroInternacionalizado(request)) + "'," + "'"
				+ this.escapeValor(ParametroSistema.AVISAR_DATAEXPIRACAO_LICENCA) + "'," + "'N', '', '', '', 'Format[Numero]')");
		document.executeScript("addLinhaParametrosIC(" + ParametroSistema.ENVIAR_EMAIL_DATAEXPIRACAO.id() + "," + "'"
				+ this.escape(ParametroSistema.ENVIAR_EMAIL_DATAEXPIRACAO.getCampoParametroInternacionalizado(request)) + "'," + "'" + this.escapeValor(ParametroSistema.ENVIAR_EMAIL_DATAEXPIRACAO)
				+ "'," + "'N', '', '', '', 'Format[Numero]')");

		document.executeScript("changeCheck()");
	}

	/**
	 * Carrega as informaes de base de conhecimento
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws ServiceException
	 * @throws Exception
	 */
	public void carregaParametrosBase(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		document.executeScript("deleteAllRowsTabelaAtributosBase()");
		document.executeScript("addLinhaParametrosBase(" + ParametroSistema.LUCENE_DIR_BASECONHECIMENTO.id() + "," + "'"
				+ this.escape(ParametroSistema.LUCENE_DIR_BASECONHECIMENTO.getCampoParametroInternacionalizado(request)) + "'," + "'" + this.escapeValor(ParametroSistema.LUCENE_DIR_BASECONHECIMENTO)
				+ "'," + "'N', 'true', 'onblur', 'validaDiretorio(this);', '')");
		document.executeScript("addLinhaParametrosBase(" + ParametroSistema.LUCENE_DIR_PALAVRAGEMEA.id() + "," + "'"
				+ this.escape(ParametroSistema.LUCENE_DIR_PALAVRAGEMEA.getCampoParametroInternacionalizado(request)) + "'," + "'" + this.escapeValor(ParametroSistema.LUCENE_DIR_PALAVRAGEMEA) + "',"
				+ "'N', 'true', 'onblur', 'validaDiretorio(this);', '')");
		document.executeScript("addLinhaParametrosBase(" + ParametroSistema.LUCENE_DIR_ANEXOBASECONHECIMENTO.id() + "," + "'"
				+ this.escape(ParametroSistema.LUCENE_DIR_ANEXOBASECONHECIMENTO.getCampoParametroInternacionalizado(request)) + "'," + "'"
				+ this.escapeValor(ParametroSistema.LUCENE_DIR_ANEXOBASECONHECIMENTO) + "'," + "'N', 'true', 'onblur', 'validaDiretorio(this);', '')");
		document.executeScript("addLinhaParametrosBase(" + ParametroSistema.AVISAR_DATAEXPIRACAO_BASECONHECIMENTO.id() + "," + "'"
				+ this.escape(ParametroSistema.AVISAR_DATAEXPIRACAO_BASECONHECIMENTO.getCampoParametroInternacionalizado(request)) + "'," + "'"
				+ this.escapeValor(ParametroSistema.AVISAR_DATAEXPIRACAO_BASECONHECIMENTO) + "'," + "'N', '', '', '', 'Format[Numero]')");
		document.executeScript("changeCheck()");
	}

	/**
	 * Carrega as informaes de base de conhecimento
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws ServiceException
	 * @throws Exception
	 */
	public void carregaParametrosGerais(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		document.executeScript("deleteAllRowsTabelaAtributosGerais()");

		document.executeScript("addLinhaParametrosGerais(" + ParametroSistema.URL_Sistema.id() + "," + "'"
				+ StringEscapeUtils.escapeJavaScript(ParametroSistema.URL_Sistema.getCampoParametroInternacionalizado(request)) + "'," + "'" + this.escapeValor(ParametroSistema.URL_Sistema) + "',"
				+ "'N','')");

		/*
		 * Rodrigo Pecci Acorse - 09/12/2013 14h25 - #126457 Adiciona o input que solicita o nome do schema somente se o banco de dados for diferente de Sql Server e Oracle
		 */
		if (!CITCorporeUtil.SGBD_PRINCIPAL.equalsIgnoreCase(SQLConfig.SQLSERVER) && !CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.ORACLE)) {
			document.executeScript("addLinhaParametrosGerais(" + ParametroSistema.DB_SCHEMA.id() + "," + "'" + this.escape(ParametroSistema.DB_SCHEMA.getCampoParametroInternacionalizado(request))
					+ "'," + "'" + this.escapeValor(ParametroSistema.DB_SCHEMA) + "'," + "'N','true')");
		}
		document.executeScript("changeCheck()");
	}

	/**
	 * Gera a chave inicial.
	 * 
	 * @param document
	 * @param request
	 * @param response
	 * @throws ServiceException
	 * @throws Exception
	 */
	public void gerarChaveInicial(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		String k = UUID.randomUUID().toString();

		HTMLElement genKey = document.getElementById("genKey");
		genKey.setValue(k);
	}

	/**
	 * Ativao da chave do Citsmart.
	 * 
	 * @param document
	 * @param request
	 * @param response
	 * @throws ServiceException
	 * @throws Exception
	 */
	public void validarChave(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		final InstalacaoDTO instalacaoDTO = (InstalacaoDTO) document.getBean();

		if (instalacaoDTO.getChave() == null || instalacaoDTO.getChave().isEmpty()) {
			document.alert(UtilI18N.internacionaliza(request, "start.instalacao.validaChave") + ".");
			document.executeScript("document.frmChave.chave.focus()");
		} else {
			L l = new L();
			l.setA(instalacaoDTO.getChave());
			l.setI(Versao.getVersao());
			l.setJ(Versao.getTipoAplicacao());
			l.setK(instalacaoDTO.getGenKey());

			L lCheck = Auth.cl(l);

			if (lCheck != null && lCheck.isC()) {
				Auth.cp(l, true);

				EmpresaDTO empresaDTO = new EmpresaDTO();
				empresaDTO.setIdEmpresa(1);
				empresaDTO.setNomeEmpresa(lCheck.getG());
				empresaDTO.setDetalhamento(lCheck.getH());

				request.getSession().setAttribute("empresa", empresaDTO);

				this.setSession(request, instalacaoDTO.getCurrent());

				document.executeScript("$(\".next:not(.finish)\").trigger(\"click\");");
			} else {
				document.alert(UtilI18N.internacionaliza(request, "start.instalacao.chaveInvalida") + ".");
				document.executeScript("document.frmChave.chave.focus()");
			}
		}

		document.executeScript("showPag();");
	}

	/**
	 * Gera carga inicial do banco
	 *
	 * @throws Exception
	 * @throws ServiceException
	 */
	public void gerarCargaInicial(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		final InstalacaoDTO instalacaoDTO = (InstalacaoDTO) document.getBean();

		if (Auth.activated) {
			final ArrayList<Integer> progressoInstalacao = (ArrayList<Integer>) request.getSession().getAttribute("progressoInstalacao");

			if (this.verificaParametrosConexao(document, request, response)) {
				try (Connection conn = ConnectionProvider.getConnection(Constantes.getValue("DATABASE_ALIAS"))) {
					if (progressoInstalacao == null || !progressoInstalacao.contains(instalacaoDTO.getCurrent())) {
						final ScriptRunner runner = new ScriptRunner(conn, true, true);
						runner.setDelimiter("(;(\r)?\n)|(--\n)", false);
						try {
							runner.runScript(new File(CITCorporeUtil.CAMINHO_REAL_APP + "/scripts_deploy/" + conn.getMetaData().getDatabaseProductName().replaceAll(" ", "_") + ".sql"));
						} catch (final Exception er) {
						}

						/**
						 * Mata da sesso o parametro de instalao
						 */
						final ServletContext context = request.getSession().getServletContext();
						context.setAttribute("instalacao", null);

						this.setSession(request, instalacaoDTO.getCurrent());
					}

					this.carregaParametrosLDAP(document, request, response);
					document.executeScript("$(\".next:not(.finish)\").trigger(\"click\");");
				} catch (final Exception e) {
				}
			} else {
				document.alert(UtilI18N.internacionaliza(request, "start.instalacao.validaConexao"));
			}

			document.executeScript("showPag();");
		} else {
			document.alert(UtilI18N.internacionaliza(request, "start.instalacao.chaveNaoEncontrada"));
		}
	}

	/**
	 * Testa os parametros de Conexo LDAP
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws ServiceException
	 * @throws Exception
	 */
	public void testaLDAP(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		final Collection<ADUserDTO> listaAdUserDto = LDAPUtils.testarConexao();

		for (final ADUserDTO adUserDto : listaAdUserDto) {
			if (adUserDto != null) {
				final StringBuilder stringBuilder = new StringBuilder();
				stringBuilder.append("sAMAccountName: " + this.getDisponivel(request, adUserDto.getsAMAccountName()));
				stringBuilder.append("\nE-mail: " + this.getDisponivel(request, adUserDto.getMail()));
				stringBuilder.append("\nCN: " + this.getDisponivel(request, adUserDto.getCN()));
				stringBuilder.append("\nSN: " + this.getDisponivel(request, adUserDto.getSN()));
				stringBuilder.append("\nDN: " + this.getDisponivel(request, adUserDto.getDN()));
				stringBuilder.append("\nDisplay Name: " + this.getDisponivel(request, adUserDto.getDisplayName()));

				document.alert(stringBuilder.toString());
			} else {
				document.alert(UtilI18N.internacionaliza(request, "ldap.conexaofalhou"));
			}
		}
	}

	/**
	 * Grava os parametros do LDAP informados pelo usurio
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws ServiceException
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public void configuraLDAP(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		final InstalacaoDTO ldap = (InstalacaoDTO) document.getBean();

		if (Auth.activated) {
			final ParametroCorporeService parametroCorporeService = this.getParametroCorporeService();

			// Atualiza o metodo de autencicao de pasta 1 Proprio / 2LDAP 
			final ParametroCorporeDTO metodoAutenticacaoPasta = new ParametroCorporeDTO();
			metodoAutenticacaoPasta.setId(ParametroSistema.METODO_AUTENTICACAO_Pasta.id());
			metodoAutenticacaoPasta.setValor(ldap.getMetodoAutenticacao());
			this.getParametroCorporeService().atualizarParametros(metodoAutenticacaoPasta);

			if (ldap.getMetodoAutenticacao().equals("2")) {
				final Collection<ADUserDTO> listaAdUser = LDAPUtils.testarConexao();

				for (final ADUserDTO adUserDto : listaAdUser) {
					if (adUserDto != null) {
						ldap.setListLdapDTO(br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(LdapDTO.class, "listAtributoLdapSerializado", request));
						if (ldap.getListLdapDTO() != null && !ldap.getListLdapDTO().isEmpty()) {
							for (final LdapDTO parametroLDAP : ldap.getListLdapDTO()) {
								final ParametroCorporeDTO parametroCorpore = new ParametroCorporeDTO();
								parametroCorpore.setId(Integer.parseInt(parametroLDAP.getIdAtributoLdap().trim()));
								parametroCorpore.setValor(parametroLDAP.getValorAtributoLdap().trim());
								parametroCorporeService.atualizarParametros(parametroCorpore);
							}
						}

						document.executeScript("$(\".next:not(.finish)\").trigger(\"click\");");
					} else {
						document.alert(UtilI18N.internacionaliza(request, "instalacao.parametrosConexaoInvalidos"));
					}
				}
			} else {
				document.executeScript("$(\".next:not(.finish)\").trigger(\"click\");");
			}

			this.setSession(request, ldap.getCurrent());
			this.carregaEmail(document, request, response);

			document.executeScript("showPag();");
		} else {
			document.alert(UtilI18N.internacionaliza(request, "start.instalacao.chaveNaoEncontrada"));
		}
	}

	@SuppressWarnings("unchecked")
	public void configuraEmail(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		final InstalacaoDTO emailDto = (InstalacaoDTO) document.getBean();

		if (Auth.activated) {
			final ParametroCorporeService parametroCorporeService = this.getParametroCorporeService();

			emailDto.setListEmailDTO(br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(EmailDTO.class, "listAtributoEmailSerializado", request));
			if (emailDto.getListEmailDTO() != null && !emailDto.getListEmailDTO().isEmpty()) {
				for (final EmailDTO parametroLdap : emailDto.getListEmailDTO()) {
					final ParametroCorporeDTO parametroCorporeDto = new ParametroCorporeDTO();
					parametroCorporeDto.setId(Integer.parseInt(parametroLdap.getIdAtributoEmail().trim()));
					parametroCorporeDto.setValor(parametroLdap.getValorAtributoEmail().trim());
					parametroCorporeService.atualizarParametros(parametroCorporeDto);
				}
			}

			this.setSession(request, emailDto.getCurrent());
			this.carregaLog(document, request, response);
			document.executeScript("$(\".next:not(.finish)\").trigger(\"click\");");

			document.executeScript("showPag();");
		} else {
			document.alert(UtilI18N.internacionaliza(request, "start.instalacao.chaveNaoEncontrada"));
		}
	}

	/**
	 * Grava as informaes de log do sistema
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws ServiceException
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public void configuraLog(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		final InstalacaoDTO log = (InstalacaoDTO) document.getBean();

		if (Auth.activated) {
			log.setListLogDTO(br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(LogDTO.class, "listAtributoLogSerializado", request));
			if (log.getListLogDTO() != null && !log.getListLogDTO().isEmpty()) {
				for (final LogDTO parametroLdap : log.getListLogDTO()) {
					final ParametroCorporeDTO parametroCorpore = new ParametroCorporeDTO();
					parametroCorpore.setId(Integer.parseInt(parametroLdap.getIdAtributoLog().trim()));
					parametroCorpore.setValor(parametroLdap.getValorAtributoLog().trim());
					this.getParametroCorporeService().atualizarParametros(parametroCorpore);
				}
			}

			this.setSession(request, log.getCurrent());
			this.carregaGED(document, request, response);

			document.executeScript("$(\".next:not(.finish)\").trigger(\"click\");");

			document.executeScript("showPag();");
		} else {
			document.alert(UtilI18N.internacionaliza(request, "start.instalacao.chaveNaoEncontrada"));
		}

	}

	/**
	 * Grava as informaes de Ged do sistema
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws ServiceException
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public void configuraGed(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		final InstalacaoDTO ged = (InstalacaoDTO) document.getBean();

		if (Auth.activated) {
			final ParametroCorporeService parametroCorporeService = this.getParametroCorporeService();

			// Atualiza ged interno 
			final ParametroCorporeDTO gedInterno = new ParametroCorporeDTO();
			gedInterno.setId(ParametroSistema.GedInterno.id());
			gedInterno.setValor("S");
			parametroCorporeService.atualizarParametros(gedInterno);

			// Atualiza a ged interno bd 
			final ParametroCorporeDTO gedInternoBD = new ParametroCorporeDTO();
			gedInternoBD.setId(ParametroSistema.GedInternoBD.id());
			gedInternoBD.setValor("N");
			parametroCorporeService.atualizarParametros(gedInternoBD);

			ged.setListGedDTO(br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(GedDTO.class, "listAtributoGedSerializado", request));
			if (ged.getListGedDTO() != null && !ged.getListGedDTO().isEmpty()) {
				for (final GedDTO parametroLdap : ged.getListGedDTO()) {
					final ParametroCorporeDTO parametroCorpore = new ParametroCorporeDTO();
					parametroCorpore.setId(Integer.parseInt(parametroLdap.getIdAtributoGed().trim()));
					parametroCorpore.setValor(parametroLdap.getValorAtributoGed().trim());
					parametroCorporeService.atualizarParametros(parametroCorpore);
				}
			}

			this.setSession(request, ged.getCurrent());
			this.carregaSMTP(document, request, response);

			document.executeScript("$(\".next:not(.finish)\").trigger(\"click\");");

			document.executeScript("showPag();");
		} else {
			document.alert(UtilI18N.internacionaliza(request, "start.instalacao.chaveNaoEncontrada"));
		}
	}

	/**
	 * Grava as informaes de SMTP do sistema
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws ServiceException
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public void configuraSMTP(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		final InstalacaoDTO smtp = (InstalacaoDTO) document.getBean();

		if (Auth.activated) {
			smtp.setListSmtpDTO(br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(SmtpDTO.class, "listAtributoSMTPSerializado", request));
			if (smtp.getListSmtpDTO() != null && !smtp.getListSmtpDTO().isEmpty()) {
				for (final SmtpDTO parametroLdap : smtp.getListSmtpDTO()) {
					final ParametroCorporeDTO parametroCorpore = new ParametroCorporeDTO();
					parametroCorpore.setId(Integer.parseInt(parametroLdap.getIdAtributoSMTP().trim()));
					parametroCorpore.setValor(parametroLdap.getValorAtributoSMTP().trim());
					this.getParametroCorporeService().atualizarParametros(parametroCorpore);
				}
			}

			this.setSession(request, smtp.getCurrent());
			this.carregaParametrosIC(document, request, response);

			document.executeScript("$(\".next:not(.finish)\").trigger(\"click\");");

			document.executeScript("showPag();");
		} else {
			document.alert(UtilI18N.internacionaliza(request, "start.instalacao.chaveNaoEncontrada"));
		}

	}

	/**
	 * Grava as informaes de parametros para item de configurao do sistema
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws ServiceException
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public void configuraParametrosIC(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		final InstalacaoDTO paramIC = (InstalacaoDTO) document.getBean();

		if (Auth.activated) {
			paramIC.setListIcDTO(br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(ICDTO.class, "listAtributoICSerializado", request));
			if (paramIC.getListIcDTO() != null && !paramIC.getListIcDTO().isEmpty()) {
				for (final ICDTO parametroLdap : paramIC.getListIcDTO()) {
					final ParametroCorporeDTO parametroCorpore = new ParametroCorporeDTO();
					parametroCorpore.setId(Integer.parseInt(parametroLdap.getIdAtributoIC().trim()));
					parametroCorpore.setValor(parametroLdap.getValorAtributoIC().trim());
					this.getParametroCorporeService().atualizarParametros(parametroCorpore);
				}
			}

			this.setSession(request, paramIC.getCurrent());
			this.carregaParametrosBase(document, request, response);

			document.executeScript("$(\".next:not(.finish)\").trigger(\"click\");");

			document.executeScript("showPag();");
		} else {
			document.alert(UtilI18N.internacionaliza(request, "start.instalacao.chaveNaoEncontrada"));
		}

	}

	/**
	 * Grava as informaes de parametros para base de conhecimento do sistema
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws ServiceException
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public void configuraParametrosBase(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		final InstalacaoDTO paramBase = (InstalacaoDTO) document.getBean();

		if (Auth.activated) {
			paramBase.setListBaseDTO(br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(BaseDTO.class, "listAtributoBaseSerializado", request));
			if (paramBase.getListBaseDTO() != null && !paramBase.getListBaseDTO().isEmpty()) {
				for (final BaseDTO parametroLdap : paramBase.getListBaseDTO()) {
					final ParametroCorporeDTO parametroCorpore = new ParametroCorporeDTO();
					parametroCorpore.setId(Integer.parseInt(parametroLdap.getIdAtributoBase().trim()));
					parametroCorpore.setValor(parametroLdap.getValorAtributoBase().trim());
					this.getParametroCorporeService().atualizarParametros(parametroCorpore);
				}
			}

			this.setSession(request, paramBase.getCurrent());
			this.carregaParametrosGerais(document, request, response);

			document.executeScript("$(\".next:not(.finish)\").trigger(\"click\");");

			document.executeScript("showPag();");
		} else {
			document.alert(UtilI18N.internacionaliza(request, "start.instalacao.chaveNaoEncontrada"));
		}
	}

	@SuppressWarnings("unchecked")
	public void configuraParametrosGerais(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		final InstalacaoDTO paramBase = (InstalacaoDTO) document.getBean();

		if (Auth.activated) {
			final ParametroCorporeService parametroCorporeService = this.getParametroCorporeService();
			final InstalacaoService instalacaoService = this.getInstalacaoService();
			final MenuService menuService = this.getMenuService();

			this.carregaScript();

			/*
			 * Rodrigo Pecci Acorse - 06/12/2013 15h30 - #126457 Seta o schema nos parametros do sistema se o banco for Oracle.
			 */
			if (CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.ORACLE)) {
				String userName = null;

				final DataSource ds = (DataSource) new InitialContext().lookup(Constantes.getValue("CONTEXTO_CONEXAO") + Constantes.getValue("DATABASE_ALIAS"));
				if (ds != null) {
					try (Connection conn = ds.getConnection()) {
						userName = conn.getMetaData().getUserName();
						if (userName != null && !userName.equals("")) {
							final ParametroCorporeDTO parametroCorporeSchema = new ParametroCorporeDTO();
							parametroCorporeSchema.setId(ParametroSistema.DB_SCHEMA.id());
							parametroCorporeSchema.setValor(userName);
							parametroCorporeService.atualizarParametros(parametroCorporeSchema);
						}
					}
				}
			}

			final ParametroCorporeDTO cadastroSolicitacaoServico = new ParametroCorporeDTO();
			cadastroSolicitacaoServico.setId(ParametroSistema.PAGE_CADADTRO_SOLICITACAOSERVICO.id());
			cadastroSolicitacaoServico.setValor("/pages/solicitacaoServicoMultiContratos/solicitacaoServicoMultiContratos.load");
			parametroCorporeService.atualizarParametros(cadastroSolicitacaoServico);

			final ParametroCorporeDTO nomeFluxoPadraoServicos = new ParametroCorporeDTO();
			nomeFluxoPadraoServicos.setId(ParametroSistema.NomeFluxoPadraoServicos.id());
			nomeFluxoPadraoServicos.setValor("SolicitacaoServico");
			parametroCorporeService.atualizarParametros(nomeFluxoPadraoServicos);

			final ParametroCorporeDTO grupoPadraoNivel1 = new ParametroCorporeDTO();
			grupoPadraoNivel1.setId(ParametroSistema.ID_GRUPO_PADRAO_NIVEL1.id());
			grupoPadraoNivel1.setValor("2");
			parametroCorporeService.atualizarParametros(grupoPadraoNivel1);

			final ParametroCorporeDTO idFaseExecucaoServicos = new ParametroCorporeDTO();
			idFaseExecucaoServicos.setId(ParametroSistema.IDFaseExecucaoServicos.id());
			idFaseExecucaoServicos.setValor("2");
			parametroCorporeService.atualizarParametros(idFaseExecucaoServicos);

			final ParametroCorporeDTO colaboradoresVinculoContratos = new ParametroCorporeDTO();
			colaboradoresVinculoContratos.setId(ParametroSistema.COLABORADORES_VINC_CONTRATOS.id());
			colaboradoresVinculoContratos.setValor("S");
			parametroCorporeService.atualizarParametros(colaboradoresVinculoContratos);

			paramBase.setListGeralDTO(br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(GeralDTO.class, "listAtributoGeraisSerializado", request));
			if (paramBase.getListGeralDTO() != null && !paramBase.getListGeralDTO().isEmpty()) {
				for (final GeralDTO parametroLdap : paramBase.getListGeralDTO()) {
					final ParametroCorporeDTO parametroCorporeDto = new ParametroCorporeDTO();
					parametroCorporeDto.setId(Integer.parseInt(parametroLdap.getIdAtributoGeral().trim()));
					parametroCorporeDto.setValor(parametroLdap.getValorAtributoGeral().trim());
					parametroCorporeService.atualizarParametros(parametroCorporeDto);
				}
			}

			try {
				System.out.println("CITSMART - Criando parametros novos... iniciando.");
				parametroCorporeService.criarParametrosNovos();
				System.out.println("CITSMART - Criando parametros novos... pronto.");
			} catch (final Exception e) {
				e.printStackTrace();
			}

			// Carrega os menus
			final String separator = System.getProperty("file.separator");
			final String diretorioReceita = CITCorporeUtil.CAMINHO_REAL_APP + "XMLs" + separator;
			final File file = new File(diretorioReceita + "menu.xml");
			menuService.gerarCarga(file);

			/* Carregando as dinamic views */
			try {
				this.carregaVisoes(request);

				request.getSession().setAttribute("progressoInstalacao", null);

				final ScriptsService scriptsService = this.getScriptsService();
				if (scriptsService.haScriptDeVersaoComErro()) {
					scriptsService.marcaErrosScriptsComoCorrigidos();
				}

				UsuarioDTO usuarioDTO = new UsuarioDTO();
				usuarioDTO.setIdUsuario(1);

				final VersaoService versaoService = this.getVersaoService();
				versaoService.validaVersoes(usuarioDTO);

				final EmpresaDTO empresaDTO = (EmpresaDTO) request.getSession().getAttribute("empresa");
				EmpresaDTO empresaRestoreDTO = (EmpresaDTO) getEmpresaService().restore(empresaDTO);

				if (empresaRestoreDTO == null) {
					empresaDTO.setDataInicio(UtilDatas.getDataAtual());
					getEmpresaService().create(empresaDTO);
				} else {
					getEmpresaService().update(empresaDTO);
				}

				request.getSession().setAttribute("empresa", null);

				/**
				 * Define a instalao com sucesso
				 */
				final InstalacaoDTO instalacaoDTO = new InstalacaoDTO();
				instalacaoDTO.setSucesso("S");
				instalacaoService.create(instalacaoDTO);

				this.reload(document, request, "citcorpore.comum.citsmartInstaladoComSucesso");
				// forcei o usurio relogar por problemas de carregamento de menu.
				request.getSession(true).setAttribute("menuPadrao", null);
			} catch (final Exception ex) {
				document.alert(ex.getMessage());
			}
		} else {
			document.alert(UtilI18N.internacionaliza(request, "start.instalacao.chaveNaoEncontrada"));
		}
	}

	/**
	 *
	 * @param request
	 * @param atributoLdap
	 * @return
	 */
	private String getDisponivel(final HttpServletRequest request, final String atributoLdap) {
		if (StringUtils.isBlank(atributoLdap)) {
			return UtilI18N.internacionaliza(request, "ldap.naodiponivel");
		}
		return atributoLdap;
	}

	/**
	 * Verifica o status da conexo
	 *
	 * @throws SQLException
	 */
	public boolean verificaParametrosConexao(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final InstalacaoDTO conexao = (InstalacaoDTO) document.getBean();

		final Connection conn = ConnectionProvider.getConnection(Constantes.getValue("DATABASE_ALIAS"));
		if (conn.getMetaData().getDatabaseProductName().equalsIgnoreCase(conexao.getDriverConexao())) {
			conn.close();
			return true;
		}
		return false;
	}

	/**
	 * Define o valor da sesso para os passos da instalao
	 *
	 * @param request
	 * @param sessao
	 */
	public void setSession(final HttpServletRequest request, final Integer index) {
		ArrayList<Integer> progressoInstalacao = (ArrayList<Integer>) request.getSession().getAttribute("progressoInstalacao");

		if (progressoInstalacao != null && !progressoInstalacao.isEmpty()) {
			try {
				progressoInstalacao.add(index);
				request.getSession().setAttribute("progressoInstalacao", progressoInstalacao);
			} catch (final Exception e) {
			}
		} else {
			progressoInstalacao = new ArrayList<>();
			progressoInstalacao.add(index);

			request.getSession().setAttribute("progressoInstalacao", progressoInstalacao);
		}
	}


	/**
	 * D um location para a pgina inicial
	 *
	 * @param document
	 * @param request
	 */
	public void reload(final DocumentHTML document, final HttpServletRequest request, final String mensagem) {
		String comando = "window.location = '" + request.getContextPath() + "/pages/login/login.load";
		if (mensagem != null && !mensagem.trim().isEmpty()) {
			comando += "?mensagem=" + mensagem;
		}
		comando += "';";
		document.executeScript(comando);
	}

	/**
	 * D um location para a pgina inicial
	 *
	 * @param document
	 * @param request
	 */
	public void reloadPaginaScript(final DocumentHTML document, final HttpServletRequest request) {
		document.executeScript("window.location = '" + request.getContextPath() + "/pages/scripts/scripts.load?upgrade=sim';");
	}

	/**
	 * Valida se Existe o diretrio
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws ServiceException
	 * @throws Exception
	 */
	public void validaDiretorio(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		final InstalacaoDTO diretorio = (InstalacaoDTO) document.getBean();
		final String campo = diretorio.getCampoDiretorio();
		if (!diretorio.getDiretorio().equals("")) {
			if (!new File(diretorio.getDiretorio()).isDirectory()) {
				document.alert(UtilI18N.internacionaliza(request, "start.instalacao.diretorioNaoEncontrado"));
				if (campo != null) {
					document.executeScript("$('#" + campo + "').val('');");
					document.executeScript("$('#" + campo + "').focus();");
				}
			}
		}
	}

	/**
	 * Realiza a leitura de um arquivo e incrementa em uma lista de uploads
	 *
	 * @param dir
	 * @param lista
	 * @return
	 */
	public static List<UploadDTO> listDirectoryAppend(final File dir, final java.util.List<UploadDTO> lista) {
		if (dir.isDirectory()) {
			final String[] filhos = dir.list();
			for (final String filho : filhos) {
				final File nome = new File(dir, filho);
				if (nome.isFile()) {
					if (nome.getName().endsWith(".citVision")) {
						lista.add(new UploadDTO(nome.getName(), nome.getPath()));
					}
				} else if (nome.isDirectory()) {
					listDirectoryAppend(nome, lista);
				}
			}
		} else {
			lista.add(new UploadDTO(dir.getName(), dir.getPath()));
		}
		return lista;
	}

	/**
	 * Carrega as Visoes da Dinamic Views para instalao do sistema
	 *
	 * @throws ServiceException
	 * @throws Exception
	 */
	@SuppressWarnings("rawtypes")
	public void carregaVisoes(final HttpServletRequest request) throws ServiceException, Exception {
		final DataBaseMetaDadosService dataBaseMetaDadosService = (DataBaseMetaDadosService) ServiceLocator.getInstance().getService(DataBaseMetaDadosService.class, null);

		final Collection colection = dataBaseMetaDadosService.getDataBaseMetaDadosUtil();
		if (colection != null && !colection.isEmpty()) {
			/* Carregando metaDados */
			dataBaseMetaDadosService.carregaTodosMetaDados(colection);

			final List<UploadDTO> lista = new ArrayList<UploadDTO>();
			listDirectoryAppend(new File(CITCorporeUtil.CAMINHO_REAL_APP + "/visoesExportadas"), lista);

			this.importaVisoes(lista);
		} else {
			throw new Exception(UtilI18N.internacionaliza(request, "start.metaDadosException"));
		}
	}

	/**
	 * Carrega rotina de script
	 *
	 * @throws ServiceException
	 * @throws Exception
	 */
	public void carregaScript() {
		try {
			final ScriptsService scriptsService = this.getScriptsService();
			System.out.println("CITSMART - Executando rotina de scripts... iniciando.");
			final String erro = scriptsService.executaRotinaScripts();
			if (erro != null && !erro.isEmpty()) {
				System.out.println("CITSMART - Problema ao executar rotina. Detalhes:\n" + erro);
			} else {
				System.out.println("CITSMART - Executando rotina de scripts... pronto.");
			}
			final VersaoService versaoService = this.getVersaoService();
			FiltroSegurancaCITSmart.setHaVersoesSemValidacao(versaoService.haVersoesSemValidacao());
		} catch (final Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 *
	 * @param arquivosUpados
	 * @throws Exception
	 * @throws ServiceException
	 */
	public void importaVisoes(final List<UploadDTO> arquivosUpados) throws ServiceException, Exception {
		final VisaoService visaoService = (VisaoService) ServiceLocator.getInstance().getService(VisaoService.class, null);
		FileReader reader = null;
		VisaoDTO visaoAtual = null;
		VisaoDTO visaoDtoXML = new VisaoDTO();

		int countImport = 0;
		int countAtualiza = 0;

		if (arquivosUpados != null && arquivosUpados.size() > 0) {

			for (final UploadDTO uploadDTO : arquivosUpados) {
				final String path = uploadDTO.getPath();
				if (path != null && !path.isEmpty()) {
					try {
						reader = new FileReader(path);
					} catch (final FileNotFoundException e) {
						e.printStackTrace();
					}
					final XStream x = new XStream(new DomDriver("ISO-8859-1"));
					visaoDtoXML = (VisaoDTO) x.fromXML(reader);
					visaoAtual = visaoService.visaoExistente(visaoDtoXML.getIdentificador());
					// Determina o tipo da importao
					if (visaoAtual == null) {
						try {
							visaoService.importar(visaoDtoXML);
							countImport++;
						} catch (final Exception e) {
							System.out.println("Erro ao importar viso: " + visaoDtoXML.getIdentificador());
							e.printStackTrace();
						}
					} else {
						try {
							visaoService.atualizarVisao(visaoAtual, visaoDtoXML);
							countAtualiza++;
						} catch (final Exception e) {
							System.out.println("Erro ao atualizar viso: " + visaoDtoXML.getIdentificador());
							e.printStackTrace();
						}
					}
				}
			}
			System.out.println("Vises importadas com sucesso: " + countImport + "\n" + "Vises atualizadas com sucesso: " + countAtualiza);

		} else {
			System.out.println("Nenhum arquivo foi selecionado!");
		}

	}

	private String escape(final String valor) {
		return StringEscapeUtils.escapeJavaScript(valor);
	}

	private String escapeValor(final ParametroSistema parametro, final String df) throws Exception {
		return ParametroUtil.getValorParametroCitSmartHashMap(parametro, df);
	}

	private String escapeValor(final ParametroSistema parametro) throws Exception {
		return this.escape(ParametroUtil.getValorParametroCitSmartHashMap(parametro, DEFAULT));
	}

	public void internacionaliza(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final InstalacaoDTO bean = (InstalacaoDTO) document.getBean();

		final String idiomaPadrao = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.IDIOMAPADRAO, "pt").toLowerCase();

		request.getSession(true).setAttribute("menu", null);
		request.getSession(true).setAttribute("menuPadrao", null);

		WebUtil webUtil = new WebUtil();

		if (bean != null) {
			if (bean.getLocale() != null) {
				webUtil.setLocale(bean.getLocale().trim(), request);
				XmlReadLookup.getInstance(new Locale(bean.getLocale().trim()));
			} else {
				webUtil.setLocale(idiomaPadrao, request);
				XmlReadLookup.getInstance(new Locale(idiomaPadrao));
			}
		} else {
			webUtil.setLocale(idiomaPadrao, request);
			XmlReadLookup.getInstance(new Locale(idiomaPadrao));
		}
		document.executeScript("window.location.reload()");
	}

	@Override
	public Class<InstalacaoDTO> getBeanClass() {
		return InstalacaoDTO.class;
	}

	private InstalacaoService getInstalacaoService() throws Exception {
		if (instalacaoService == null) {
			instalacaoService = (InstalacaoService) ServiceLocator.getInstance().getService(InstalacaoService.class, null);
		}
		return instalacaoService;
	}

	private MenuService getMenuService() throws Exception {
		if (menuService == null) {
			menuService = (MenuService) ServiceLocator.getInstance().getService(MenuService.class, null);
		}
		return menuService;
	}

	private ParametroCorporeService getParametroCorporeService() throws Exception {
		if (parametroCorporeService == null) {
			parametroCorporeService = (ParametroCorporeService) ServiceLocator.getInstance().getService(ParametroCorporeService.class, null);
		}
		return parametroCorporeService;
	}

	private ScriptsService getScriptsService() throws Exception {
		if (scriptsService == null) {
			scriptsService = (ScriptsService) ServiceLocator.getInstance().getService(ScriptsService.class, null);
		}
		return scriptsService;
	}

	private VersaoService getVersaoService() throws Exception {
		if (versaoService == null) {
			versaoService = (VersaoService) ServiceLocator.getInstance().getService(VersaoService.class, null);
		}
		return versaoService;
	}

	private EmpresaService getEmpresaService() throws Exception {
		if (empresaService == null) {
			empresaService = (EmpresaService) ServiceLocator.getInstance().getService(EmpresaService.class, null);
		}
		return empresaService;
	}

}
