package br.com.centralit.citcorpore.ajaxForms;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.json.JSONObject;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citcorpore.bean.JornadaTrabalhoDTO;
import br.com.centralit.citcorpore.negocio.JornadaTrabalhoService;
import br.com.centralit.citcorpore.util.Util;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Reflexao;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;

/**
 * @author rosana.godinho
 *
 */
public class JornadaTrabalho extends AjaxFormAction {

	/**
	 * Inicializa os dados ao carregar a tela.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
	}

	/**
	 * Inclui registro.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		JornadaTrabalhoDTO jornadaTrabalho = (JornadaTrabalhoDTO) document.getBean();
		JornadaTrabalhoService jornadaTrabalhoService = (JornadaTrabalhoService) ServiceLocator.getInstance().getService(JornadaTrabalhoService.class, WebUtil.getUsuarioSistema(request));

		if (jornadaTrabalho.getTipoHorario() != null && jornadaTrabalho.getTipoHorario().equals(2) && !Util.isNullOrEmpty(jornadaTrabalho.getJson())) {
			JornadaTrabalhoDTO jornadaTrabalhoHora24hs = (JornadaTrabalhoDTO) br.com.citframework.util.WebUtil.convertJsonToObject(JornadaTrabalhoDTO.class, new JSONObject(jornadaTrabalho.getJson()));
			Reflexao.copyPropertyValues(jornadaTrabalhoHora24hs, jornadaTrabalho);
		}
		
		jornadaTrabalho = configurarDataFinalComo24Horas(jornadaTrabalho);
		
		String msgErro = jornadaValida(jornadaTrabalho); 
		if(msgErro != null && !msgErro.equals("")){
			document.alert(UtilI18N.internacionaliza(request, msgErro));
			return;
		}

		if (jornadaTrabalho.getIdJornada() == null) {
			if (jornadaTrabalhoService.verificaJornadaExistente(jornadaTrabalho)) {
				document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.registroJaCadastrado"));
				return;
			}
			jornadaTrabalho.setDataInicio(UtilDatas.getDataAtual());
			jornadaTrabalhoService.create(jornadaTrabalho);
			document.alert(UtilI18N.internacionaliza(request, "MSG05"));
		} else {
			if (jornadaTrabalhoService.verificaJornadaExistente(jornadaTrabalho)) {
				document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.registroJaCadastrado"));
				return;
			}
			jornadaTrabalhoService.update(jornadaTrabalho);
			document.alert(UtilI18N.internacionaliza(request, "MSG06"));
		}
		HTMLForm form = document.getForm("form");
		form.clear();

		document.executeScript("limpar_LOOKUP_JORNADATRABALHO()");
	}

	/**
	 * Configura a data termino com 24:00 caso seja 00:00
	 * @param jornadaTrabalho
	 * @return
	 */
	private JornadaTrabalhoDTO configurarDataFinalComo24Horas(JornadaTrabalhoDTO jornadaTrabalho) {
		double horaFinal = 0;
		try {

			if(jornadaTrabalho.getTermino5() != null && jornadaTrabalho.getTermino5().trim().length() > 0){
				horaFinal = Util.getHoraDbl(jornadaTrabalho.getTermino5());
				if(horaFinal == 0){
					jornadaTrabalho.setTermino5("24:00");
				}
			}
			if(jornadaTrabalho.getTermino4().trim() != null && jornadaTrabalho.getTermino4().trim().length() > 0){
				horaFinal = Util.getHoraDbl(jornadaTrabalho.getTermino4());
				if(horaFinal == 0){
					jornadaTrabalho.setTermino4("24:00");
				}
			}
			if(jornadaTrabalho.getTermino3().trim() != null && jornadaTrabalho.getTermino3().trim().length() > 0){
				horaFinal = Util.getHoraDbl(jornadaTrabalho.getTermino3());
				if(horaFinal == 0){
					jornadaTrabalho.setTermino3("24:00");
				}
			}
			if(jornadaTrabalho.getTermino2().trim() != null && jornadaTrabalho.getTermino2().trim().length() > 0){
				horaFinal = Util.getHoraDbl(jornadaTrabalho.getTermino2());
				if(horaFinal == 0){
					jornadaTrabalho.setTermino2("24:00");
				}
			}
			if(jornadaTrabalho.getTermino1().trim() != null && jornadaTrabalho.getTermino1().trim().length() > 0){
				horaFinal = Util.getHoraDbl(jornadaTrabalho.getTermino1());
				if(horaFinal == 0){
					jornadaTrabalho.setTermino1("24:00");
				}
			}
			
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return jornadaTrabalho;
	}

	
	/**
	 * Valida se a jornada e valida retornando mensagem do problema
	 * 
	 * Data termino posterior nao pode ser maior ou igual a data inicial atual
	 * 
	 * @author gilberto.nery
	 * @since 2016-09-30
	 * 
	 * @param jornadaTrabalho
	 * @return "": jornada valida || msg contendo o erro da jornada invalida
	 */
	private String jornadaValida(JornadaTrabalhoDTO jornadaTrabalho) {
		
		double horaInicial = -1;
		double horaFinal = -1;
		double horaFinalJornadaAnterior = -1;
		
		try {
			if(jornadaTrabalho != null){
				
				if(jornadaTrabalho.getTermino1().trim() != null && jornadaTrabalho.getTermino1().trim().length() > 0){
					horaInicial = Util.getHoraDbl(jornadaTrabalho.getInicio1());
					horaFinal = Util.getHoraDbl(jornadaTrabalho.getTermino1());
					if(horaInicial >= horaFinal){
						return "jornadaTrabalho.validarDataInicioIgualDataTermino";
					} 
					horaFinalJornadaAnterior = horaFinal;
				}
				
				if(jornadaTrabalho.getTermino2().trim() != null && jornadaTrabalho.getTermino2().trim().length() > 0){
					horaInicial = Util.getHoraDbl(jornadaTrabalho.getInicio2());
					horaFinal = Util.getHoraDbl(jornadaTrabalho.getTermino2());
					if(horaInicial >= horaFinal){
						return "jornadaTrabalho.validarDataInicioIgualDataTermino";
					} else {
						if(horaInicial <= horaFinalJornadaAnterior){
							return "jornadaTrabalho.validarDataInicioMaiorIgualDataTerminoAnterior";
						}
						horaFinalJornadaAnterior = horaFinal;
					}
				}
				
				if(jornadaTrabalho.getTermino3().trim() != null && jornadaTrabalho.getTermino3().trim().length() > 0){
					horaInicial = Util.getHoraDbl(jornadaTrabalho.getInicio3());
					horaFinal = Util.getHoraDbl(jornadaTrabalho.getTermino3());
					if(horaInicial >= horaFinal){
						return "jornadaTrabalho.validarDataInicioIgualDataTermino";
					} else {
						if(horaInicial <= horaFinalJornadaAnterior){
							return "jornadaTrabalho.validarDataInicioMaiorIgualDataTerminoAnterior";
						}
						horaFinalJornadaAnterior = horaFinal;
					}
				}
				
				if(jornadaTrabalho.getTermino4().trim() != null && jornadaTrabalho.getTermino4().trim().length() > 0){
					horaInicial = Util.getHoraDbl(jornadaTrabalho.getInicio4());
					horaFinal = Util.getHoraDbl(jornadaTrabalho.getTermino4());
					if(horaInicial >= horaFinal){
						return "jornadaTrabalho.validarDataInicioIgualDataTermino";
					} else {
						if(horaInicial <= horaFinalJornadaAnterior){
							return "jornadaTrabalho.validarDataInicioMaiorIgualDataTerminoAnterior";
						}
						horaFinalJornadaAnterior = horaFinal;
					}
				}
				
				if(jornadaTrabalho.getTermino5().trim() != null && jornadaTrabalho.getTermino5().trim().length() > 0){
					horaInicial = Util.getHoraDbl(jornadaTrabalho.getInicio5());
					horaFinal = Util.getHoraDbl(jornadaTrabalho.getTermino5());
					horaFinalJornadaAnterior = Util.getHoraDbl(jornadaTrabalho.getTermino5());
					if(horaInicial >= horaFinal){
						return "jornadaTrabalho.validarDataInicioIgualDataTermino";
					}
				}
				
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return "";
	}

	/**
	 * Restaura os dados ao clicar em um registro.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		JornadaTrabalhoDTO jornadaTrabalhoDto = (JornadaTrabalhoDTO) document.getBean();
		JornadaTrabalhoService jornadaTrabalhoService = (JornadaTrabalhoService) ServiceLocator.getInstance().getService(JornadaTrabalhoService.class, null);

		jornadaTrabalhoDto = (JornadaTrabalhoDTO) jornadaTrabalhoService.restore(jornadaTrabalhoDto);

		HTMLForm form = document.getForm("form");
		form.clear();
		form.setValues(jornadaTrabalhoDto);
		document.executeScript("onChangeTipoHorario();");

	}

	/**
	 * Exclui um registro.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	public void delete(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		JornadaTrabalhoDTO jornadaTrabalhoDto = (JornadaTrabalhoDTO) document.getBean();
		JornadaTrabalhoService jornadaTrabalhoService = (JornadaTrabalhoService) ServiceLocator.getInstance().getService(JornadaTrabalhoService.class, WebUtil.getUsuarioSistema(request));
		String resp = "";

		if (jornadaTrabalhoDto.getIdJornada().intValue() > 0) {
			resp = jornadaTrabalhoService.deletarJornada(jornadaTrabalhoDto.getIdJornada());
		}

		HTMLForm form = document.getForm("form");
		form.clear();
		document.alert(resp);

		document.executeScript("limpar_LOOKUP_JORNADATRABALHO()");
	}

	@Override
	public Class<JornadaTrabalhoDTO> getBeanClass() {
		return JornadaTrabalhoDTO.class;
	}

}
