package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Enumerados.TipoDate;
import br.com.centralit.citcorpore.util.UtilRelatorio;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.dto.LogDados;
import br.com.citframework.integracao.core.Page;
import br.com.citframework.integracao.core.PageRequest;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.LogDadosService;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

/**
 * @author Flvio
 *
 */
public class LogController extends AjaxFormAction {
	
	UsuarioDTO usuario;
	
	@Override
	public void load (DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
    	UsuarioDTO usrDto = WebUtil.getUsuario(request);
    	if(usrDto == null){
    		return;
    	}

		document.getElementById("labelPaginaAtual").setInnerHTML("1");
		document.getElementById("paginaAtual").setValue("1");
		document.getElementById("paginacao").setValue("1");
		document.getElementById("quantidadeTotalLogs").setValue("0");

		document.executeScript("escondeControlePaginacao();");
    	
    	document.getSelectById("nomeTabela").removeAllOptions();
    	LogDadosService logsService = (LogDadosService) ServiceLocator.getInstance().getService(LogDadosService.class, null);
		Collection<LogDados> col = logsService.listNomeTabelaObjetoNegocio();
		document.getSelectById("nomeTabela").addOption("", "-- " + UtilI18N.internacionaliza(request, "citcorpore.comum.todos") + " --");
		document.getSelectById("nomeTabela").addOptions(col, "nomeTabela", "nomeTabela", null);

     }
    
	public String contentLog(List<LogDados> listLog, HttpServletRequest request, Pageable page) throws Exception {
    	
    	StringBuilder html = new StringBuilder();
		html.append("<div id='table'><table class='table table-bordered table-hover'");
		html.append(
				"<thead>" + 
				"	<tr>" +
				"		<th style='width:15%;'>" + UtilI18N.internacionaliza(request, "logs.nomeUsuario") + "</th>" +
				"		<th style='width:10%;'>" + UtilI18N.internacionaliza(request, "logs.tabela") + "</th>" +
				"		<th style='width:5%;'>" + UtilI18N.internacionaliza(request, "logs.operacao") + "</th>" +
				"		<th style='width:10%;'>" + UtilI18N.internacionaliza(request, "citcorpore.comum.datahora") + "</th>" +
				"		<th style='width:60%;'>" + UtilI18N.internacionaliza(request, "logs.dados") + "</th>" +
				"		</tr>" + "</thead><tbody>");
		
    	if(!listLog.isEmpty()) {
	    	for (LogDados logDados : listLog) 	{
	    		html.append(
	    				
	    				"<tr>" +
		    				"<td style='text-align: left;'>" + logDados.getNomeUsuario() + "</td>" +
		    				"<td style='text-align: left;'>" + logDados.getNomeTabela() + "</td>" +
		    				"<td style='text-align: left;'>" + (logDados.getOperacao().equals("I") ? UtilI18N.internacionaliza(request, "logs.inclusao") : UtilI18N.internacionaliza(request, "logs.alteracao")) + "</td>" +
		    				"<td style='text-align: left;'>" + (logDados.getDataLog() == null ? "" : UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, logDados.getDataLog(), WebUtil.getLanguage(request))) + "</td>" +
							"<td style='text-align: left;'>" + logDados.getDados() + "</td>" +
						"</tr>");
			}
    	} else {
			html.append("<tr><td colspan='5'>" + UtilI18N.internacionaliza(request, "MSG04") + "</td></tr>");
    	}
		html.append("</tbody></table></div>");

		return html.toString();
    }
    
	public void filtrar(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document))
			return;

		document.executeScript("exibeControlePaginacao();");

		LogDados log = (LogDados) document.getBean();
		LogDadosService logsService = (LogDadosService) ServiceLocator.getInstance().getService(LogDadosService.class, null);

		if (log.getDataInicio() == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.validacao.datainicio"));
			document.executeScript("escondeJanelaAguarde();");
			return;
		}
		if (log.getDataFim() == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.validacao.datafim"));
			document.executeScript("escondeJanelaAguarde();");
			return;
		}

		if (log.getPaginaAtual() == null || log.getPaginaAtual().equals(0))
			log.setPaginaAtual(1);

		Pageable pageable = new PageRequest(log.getPaginaAtual() - 1, log.getQuantidadeLogsPorPagina());
		HTMLElement page = document.getElementById("page");

		Page<LogDados> resultPage = logsService.listarLogsPaginado(log, pageable);
		if (resultPage == null) {
			document.alert(UtilI18N.internacionaliza(request, "conexaoBI.log.naoExisteLog"));
			document.executeScript("escondeJanelaAguarde();");
			return;
		}

		page.setInnerHTML(contentLog(resultPage.getContent(), request, pageable));

		document.getElementById("labelPaginaAtual").setInnerHTML("1");

		document.getElementById("controlePaginacao").setInnerHTML(
				UtilHTML.paginacaoHtml(request, "paginarServico", resultPage.getTotalPages(), pageable.getPageNumber() + 1));

		HTMLForm form = document.getForm("form");
		form.setValues(log);

		document.executeScript("escondeJanelaAguarde();");
	}

	/**
	 * Faz a impresso do relatrio no formato pdf.
	 * 
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author Flavio.santana
	 */
	public void imprimirRelatorio(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HttpSession session = request.getSession();
		LogDados logDados = (LogDados) document.getBean();
		LogDadosService logDadosService = (LogDadosService) ServiceLocator.getInstance().getService(LogDadosService.class, null);
		
		usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			document.executeScript("escondeJanelaAguarde();");
			return;
		}

		if (logDados.getDataInicio() == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.validacao.datainicio"));
			document.executeScript("escondeJanelaAguarde();");
			return;
		}
		if (logDados.getDataFim() == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.validacao.datafim"));
			document.executeScript("escondeJanelaAguarde();");
			return;
		}
		
		/*Iterando a lista*/
		ArrayList<LogDados> colLogs = (ArrayList<LogDados>) logDadosService.listLogs(logDados);
    	if(colLogs == null)
    	{
    		colLogs = new ArrayList<LogDados>();
    	}
    	
		Date dt = new Date();
		String strCompl = "" + dt.getTime();
		String caminhoJasper = CITCorporeUtil.CAMINHO_REAL_APP + Constantes.getValue("CAMINHO_RELATORIOS") + "RelatorioLogs.jasper";
		String diretorioReceita = CITCorporeUtil.CAMINHO_REAL_APP + "/tempFiles";
		String diretorioRelativoOS = Constantes.getValue("SERVER_ADDRESS") + Constantes.getValue("CONTEXTO_APLICACAO") + "/tempFiles";

		Map<String, Object> parametros = new HashMap<String, Object>();
		parametros = UtilRelatorio.trataInternacionalizacaoLocale(session, parametros);
		
		parametros.put("TITULO_RELATORIO", UtilI18N.internacionaliza(request, "relatorioLogs.titulo"));
		parametros.put("CIDADE", getCidadeParametrizada(request));
		parametros.put("DATA_HORA", UtilDatas.getDataHoraAtual());
		parametros.put("NOME_USUARIO", usuario.getNomeUsuario());
		parametros.put("dataInicio", logDados.getDataInicio());
		parametros.put("dataFim", logDados.getDataFim());

		if (colLogs.size() == 0) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.relatorioVazio"));
			document.executeScript("escondeJanelaAguarde();");
			return;
		}

		JRDataSource dataSource = new JRBeanCollectionDataSource(colLogs);

		JasperPrint print = JasperFillManager.fillReport(caminhoJasper, parametros, dataSource);
		JasperExportManager.exportReportToPdfFile(print, diretorioReceita + "/RelatorioLogs" + strCompl + "_" + usuario.getIdUsuario() + ".pdf");

		document.executeScript("window.open('" + Constantes.getValue("SERVER_ADDRESS") + Constantes.getValue("CONTEXTO_APLICACAO") + "/printPDF/printPDF.jsp?url="
				+ diretorioRelativoOS + "/RelatorioLogs" + strCompl + "_" + usuario.getIdUsuario() + ".pdf')");

		document.executeScript("escondeJanelaAguarde();");
	}
    
    @Override
	public Class<LogDados> getBeanClass(){
    	return LogDados.class;
    }
 
}