package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.authentication.Auth;
import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citcorpore.bean.EmailAlteracaoSenhaDTO;
import br.com.centralit.citcorpore.bean.EmpregadoDTO;
import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.LoginDTO;
import br.com.centralit.citcorpore.bean.PerfilAcessoDTO;
import br.com.centralit.citcorpore.bean.PerfilAcessoUsuarioDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.integracao.ad.LDAPUtils;
import br.com.centralit.citcorpore.mail.MensagemEmail;
import br.com.centralit.citcorpore.negocio.EmpregadoService;
import br.com.centralit.citcorpore.negocio.GrupoService;
import br.com.centralit.citcorpore.negocio.InstalacaoService;
import br.com.centralit.citcorpore.negocio.PerfilAcessoService;
import br.com.centralit.citcorpore.negocio.PerfilAcessoUsuarioService;
import br.com.centralit.citcorpore.negocio.UsuarioService;
import br.com.centralit.citcorpore.negocio.VersaoService;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.CriptoUtils;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.centralit.citcorpore.versao.Versao;
import br.com.centralit.dto.L;
import br.com.centralit.util.AuthEncryption;
import br.com.citframework.dto.IDto;
import br.com.citframework.dto.Usuario;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.PersistenceEngine;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Reflexao;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.XmlReadLookup;

@SuppressWarnings({ "rawtypes", "unchecked" })
public class Login extends AjaxFormAction {

	private static final String DEFAULT_ALGORITMO_CRIPTOGRAFIA_SENHA = "SHA-1";
	private static final String STATUS_ATIVO = "A";
	private static final String METODO_AUTENTICACAO_LDAP = "2";
	public static String recarregaPagina = "S";

	@Override
	public Class getBeanClass() {
		return LoginDTO.class;
	}

	private AuthEncryption authEncryption;
	private Map<String, String> props = new HashMap<>();

	@Override
	public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {

		final InstalacaoService instalacaoService = (InstalacaoService) ServiceLocator.getInstance().getService(InstalacaoService.class, null);
		if (!instalacaoService.isSucessoInstalacao() && request.getSession().getAttribute("progressoInstalacao") == null) {
			document.executeScript("LOGIN.load.insertMessage('<label>" + UtilI18N.internacionaliza(request, "instalacao.mensagemInsucesso1") + "</label>"
					+ "<label>" + UtilI18N.internacionaliza(request, "instalacao.mensagemInsucesso2") + "</label>"
					+ "<label>" + UtilI18N.internacionaliza(request, "instalacao.mensagemInsucesso3") + "</label>"
					+ "<label>" + UtilI18N.internacionaliza(request, "instalacao.mensagemInsucessoAviso1") + "</label>"
					+ "<label>" + UtilI18N.internacionaliza(request, "instalacao.mensagemInsucessoAviso2") + "</label>"
					+ "<label>" + UtilI18N.internacionaliza(request, "instalacao.mensagemInsucessoAviso3") + "</label>"
					+ "<label>" + UtilI18N.internacionaliza(request, "instalacao.mensagemInsucessoAviso4") + "</label>"
					+ "<label>" + UtilI18N.internacionaliza(request, "instalacao.mensagemInsucessoAvisoManual") + "</label>" + "')");
		}

		final HTMLForm form = document.getForm("form");
		document.focusInFirstActivateField(form);

		if (request.getParameter("logout") != null && "yes".equalsIgnoreCase(request.getParameter("logout"))) {
			logout(document, request);
		}

		clearSessions(request);

		setDefaultLanguage(request);

		final String mensagem = request.getParameter("mensagem");
		if (mensagem != null && !mensagem.isEmpty()) {
			document.alert(UtilI18N.internacionaliza(request, mensagem));
		}

		if (!Auth.activated) {
			document.executeScript("Modal.open(\"modal-empresa\");");
		}
	}

	private void logout(final DocumentHTML document, final HttpServletRequest request) {
		WebUtil.removeUsuarioFromSession(request);
		Login.recarregaPagina = "S";

		document.executeScript("window.location.href = '" + CITCorporeUtil.CAMINHO_SERVIDOR + request.getContextPath() + "/pages/login/login.load'");
	}

	private void clearSessions(final HttpServletRequest request) {
		ServletContext context = request.getSession().getServletContext();
		if (context.getAttribute("instalacao") == null && request.getSession().getAttribute("progressoInstalacao") == null && (request.getSession().getAttribute("locale") == null || request.getSession().getAttribute("locale").equals("")) && request.getSession().getAttribute("abrePortal") == null) {
			request.getSession().invalidate();
		}
	}

	/**
	 * @gilberto.nery
	 *
	 * Setar o idioma padrao do sistema, caso nao exista nenhum ele captura o do browser, caso nenhum seja encontrado seta com default o portugues
	 *
	 */
	private void setDefaultLanguage(final HttpServletRequest request) {
		if (request.getSession() == null || request.getSession().getAttribute("locale") == null || request.getSession().getAttribute("locale") == "") {

			String idiomaPadrao = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.IDIOMAPADRAO, "").toLowerCase();

			if (idiomaPadrao == null || idiomaPadrao.trim().equals("")) {

				idiomaPadrao = "pt";
				if (request.getHeader("Accept-Language") != null && !request.getHeader("Accept-Language").trim().equals("")) {
					String linguagem = request.getHeader("Accept-Language");
					if (linguagem.length() > 2) {

						linguagem = linguagem.substring(0, 2);

						if (linguagem.contains("en")) {
							idiomaPadrao = "en";
						} else if (linguagem.contains("es")) {
							idiomaPadrao = "es";
						}
					}
				}
			}

			WebUtil webUtil = new WebUtil();
			webUtil.setLocale(idiomaPadrao, request);
			XmlReadLookup.getInstance(new Locale(idiomaPadrao));
			recarregaPagina = "N";
		}
	}
	

	public void Login_onsave(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final InstalacaoService instalacaoService = (InstalacaoService) ServiceLocator.getInstance().getService(InstalacaoService.class, null);
		if (!instalacaoService.isSucessoInstalacao() && request.getSession().getAttribute("progressoInstalacao") == null) {
			this.load(document, request, response);
			document.executeScript("LOGIN.close_wait();");
			return;
		}

		final LoginDTO login = (LoginDTO) document.getBean();
		document.getForm("form");
		boolean isAdmin = false;
		if (login != null) {
			/**
			 * Motivo: Inerso da validao de login Autor: Flvio.santana Data/Hora: 05/11/2013 17:30
			 */
			if (login.getUser() == null || login.getUser().trim().equalsIgnoreCase("")) {
				document.executeScript("LOGIN.close_wait();");
				document.alert(UtilI18N.internacionaliza(request, "login.digite_login"));
				return;
			}
			if (login.getSenha() == null || login.getSenha().trim().equalsIgnoreCase("")) {
				document.alert(UtilI18N.internacionaliza(request, "login.digite_senha"));
				document.executeScript("LOGIN.close_wait();");
				return;
			}
		} else {
			document.alert(UtilI18N.internacionaliza(request, "login.nao_confere"));
			document.executeScript("LOGIN.close_wait();");
			return;
		}

		final UsuarioDTO usrDto = new UsuarioDTO();
		final UsuarioService usuarioService = (UsuarioService) ServiceLocator.getInstance().getService(UsuarioService.class, null);
		final String metodoAutenticacao = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.METODO_AUTENTICACAO_Pasta, METODO_AUTENTICACAO_LDAP);

		isAdmin = "admin".equalsIgnoreCase(login.getUser()) || "consultor".equalsIgnoreCase(login.getUser());

		if (metodoAutenticacao != null && metodoAutenticacao.trim().equalsIgnoreCase(METODO_AUTENTICACAO_LDAP)) {
			if (!isAdmin) {
				if (request.getSession().getAttribute("progressoInstalacao") != null) {
					document.executeScript("LOGIN.close_wait();");
					document.alert(UtilI18N.internacionaliza(request, "usuario.permissaoInstalacao"));
					return;
				} else {
					usuarioService.sincronizaUsuarioAD(LDAPUtils.autenticacaoAD(login.getUser(), login.getSenha()), login, false);
				}
			}
		} else {
			System.out.println(UtilI18N.internacionaliza(request, "login.configNaoSincronizarComAD"));
		}

		String algoritmo = br.com.citframework.util.Constantes.getValue("ALGORITMO_CRIPTOGRAFIA_SENHA", DEFAULT_ALGORITMO_CRIPTOGRAFIA_SENHA);
		if (algoritmo == null || !algoritmo.trim().equalsIgnoreCase("")) {
			algoritmo = DEFAULT_ALGORITMO_CRIPTOGRAFIA_SENHA;
		}
		login.setSenha(CriptoUtils.generateHash(login.getSenha(), algoritmo));

		final boolean veririficaVazio = usuarioService.listSeVazio();
		if (!veririficaVazio && "admin".equalsIgnoreCase(login.getUser())) {
			createFirstUser(login, usrDto, usuarioService);
		}

		final UsuarioDTO usuarioBean = usuarioService.restoreByLogin(login.getUser(), login.getSenha());
		if (usuarioBean == null) {
			document.executeScript("LOGIN.close_wait();");
			document.alert(UtilI18N.internacionaliza(request, "login.nao_confere"));
			return;
		}

		if (metodoAutenticacao == null || metodoAutenticacao.trim().equalsIgnoreCase("")) {
			document.executeScript("LOGIN.close_wait();");
			document.alert(UtilI18N.internacionaliza(request, "login.metodoAutenticaoNaoConfigurado"));
			return;
		}

		if (usuarioBean.getStatus().equalsIgnoreCase(STATUS_ATIVO) && login.getSenha().equals(usuarioBean.getSenha())) {
			if (!Auth.activated) {
				document.executeScript("Modal.open(\"modal-empresa\");");
				document.executeScript("LOGIN.close_wait();");
			}

			if (usuarioBean.getIdEmpresa() == null) {
				usuarioBean.setIdEmpresa(1);
			}
			final Usuario usuarioFramework = new Usuario();
			final UsuarioDTO usr = new UsuarioDTO();
			usr.setIdUsuario(usuarioBean.getIdUsuario());
			usr.setNomeUsuario(usuarioBean.getNomeUsuario());
			usr.setIdGrupo(usuarioBean.getIdGrupo());
			usr.setIdEmpresa(usuarioBean.getIdEmpresa());
			usr.setIdEmpregado(usuarioBean.getIdEmpregado());
			usr.setLogin(usuarioBean.getLogin());
			usr.setStatus(usuarioBean.getStatus());
			usr.setIdPerfilAcessoUsuario(this.getIdPerfilAcessoUsuario(usuarioBean.getIdUsuario()));
			/**
			 * Se  'admin' o acesso  irrestrito
			 */
			if (isAdmin) {
				usr.setAcessoCitsmart("S");
			} else {
				usr.setAcessoCitsmart(this.getAcessoCitsmart(usr.getIdPerfilAcessoUsuario(), usr.getIdUsuario()));
			}
			usr.setEmail(usuarioBean.getEmail());
			// utilizado para log
			PersistenceEngine.setUsuarioSessao(usuarioBean);
			Reflexao.copyPropertyValues(usr, usuarioFramework);
			br.com.citframework.util.WebUtil.setUsuario(usuarioFramework, request);

			setGruposInUsuario(usuarioBean, usr);
			WebUtil.setUsuario(usr, request);

			if (usr != null) {
				final Problema problema = new Problema();
				problema.notificarPrazoSolucionarProblemaExpirou(document, request, response, usr);
			}

			// Verificao de instalao
			ArrayList<Integer> progressoInstalacao = (ArrayList<Integer>) request.getSession().getAttribute("progressoInstalacao");
			if (progressoInstalacao != null) {
				document.executeScript("window.location = '" + CITCorporeUtil.CAMINHO_SERVIDOR + request.getContextPath() + "/pages/instalacao/instalacao.load';");
			} else {
				final VersaoService versaoService = (VersaoService) ServiceLocator.getInstance().getService(VersaoService.class, null);
				final String idPerfilAcessoAdministrador = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_PERFIL_ACESSO_ADMINISTRADOR, "1");
				final boolean usuarioTemPerfilDeAdministrador = usr.getIdPerfilAcessoUsuario() != null
						&& usr.getIdPerfilAcessoUsuario().toString().trim().equals(idPerfilAcessoAdministrador.trim());
				if (versaoService.haVersoesSemValidacao() && !usuarioTemPerfilDeAdministrador) {
					document.executeScript("LOGIN.close_wait();");
					document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.citsmartAtualizado"));
					return;
				}
				document.executeScript("LOGIN.signIn()");
			}

			/**
			 * Caso tenha ficado alguma carga de menu no session, remove a referncia para peg-la novamente ao carregar o menu
			 *
			 * @author thyen.chang
			 * @since 12/02/2015
			 */
			if (request.getSession(true).getAttribute("menuPadrao") != null) {
				request.getSession(true).removeAttribute("menuPadrao");
			}

			abrePortalSeEstiverConfigurado(document, request);

		} else {
			document.executeScript("LOGIN.close_wait();");
			document.alert(UtilI18N.internacionaliza(request, "login.nao_confere"));
			request.getSession().invalidate();
			return;
		}
	}

	private void createFirstUser(final LoginDTO login, final UsuarioDTO usrDto, final UsuarioService usuarioService)
			throws ServiceException, LogicException {
		usrDto.setDataInicio(UtilDatas.getDataAtual());
		usrDto.setLogin(login.getUser());
		usrDto.setSenha(login.getSenha());
		usrDto.setNomeUsuario("Administrador");
		usrDto.setStatus(STATUS_ATIVO);

		usuarioService.createFirs(usrDto);
	}

	private void setGruposInUsuario(final UsuarioDTO usuarioBean, final UsuarioDTO usr) throws ServiceException, LogicException {
		final GrupoService grupoSegService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
		final Collection<GrupoDTO> colGrupos = grupoSegService.getGruposByPessoa(usuarioBean.getIdEmpregado());
		GrupoDTO grpSeg;
		String[] grupos = null;
		if (colGrupos != null) {
			grupos = new String[colGrupos.size()];
			for (int i = 0; i < colGrupos.size(); i++) {
				grpSeg = (GrupoDTO) ((List) colGrupos).get(i);
				grupos[i] = grpSeg.getSigla();
			}
		} else {
			grupos = new String[1];
			grupos[0] = "";
		}

		usr.setGrupos(grupos);
		usr.setColGrupos(colGrupos);
	}

	private void abrePortalSeEstiverConfigurado(final DocumentHTML document, final HttpServletRequest request) {
		final String abrePortal = (String) request.getSession().getAttribute("abrePortal");
		final String parametroPortal = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.LOGIN_PORTAL, "N");

		if (parametroPortal.equalsIgnoreCase("S") || abrePortal != null && abrePortal.equalsIgnoreCase("S")) {
			final String habilitaNovoPortal = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.HABILITAR_NOVO_PORTAL, "S");

			if (habilitaNovoPortal.equalsIgnoreCase("S") || habilitaNovoPortal.equalsIgnoreCase("Y")) {
				document.executeScript("window.location = '" + CITCorporeUtil.CAMINHO_SERVIDOR + request.getContextPath() + "/pages/smartPortal/smartPortal.load';");
			} else {
				document.executeScript("window.location = '" + CITCorporeUtil.CAMINHO_SERVIDOR + request.getContextPath() + "/pages/portal/portal.load';");
			}

			request.getSession().setAttribute("abrePortal", null);
		}
	}

	/**
	 * Adicionado tratamento para quando usurio no possui perfil de acesso 30/12/2014 - 10:18
	 *
	 *
	 * @author thyen.chang
	 * @param idPerfilAcessoUsuario
	 * @param idUsuario
	 * @return
	 * @throws ServiceException
	 * @throws Exception
	 */
	private String getAcessoCitsmart(final Integer idPerfilAcessoUsuario, final Integer idUsuario) throws ServiceException, Exception {

		final PerfilAcessoService perfilAcessoService = (PerfilAcessoService) ServiceLocator.getInstance().getService(PerfilAcessoService.class, null);

		PerfilAcessoDTO perfilAcessoDTO = new PerfilAcessoDTO();

		perfilAcessoDTO.setIdPerfilAcesso(idPerfilAcessoUsuario);

		perfilAcessoDTO = perfilAcessoService.findByIdPerfilAcesso(perfilAcessoDTO);

		if (perfilAcessoDTO != null && perfilAcessoDTO.getAcessoSistemaCitsmart() != null && !perfilAcessoDTO.getAcessoSistemaCitsmart().isEmpty() && perfilAcessoDTO.getAcessoSistemaCitsmart().equals("S")) {
			return perfilAcessoDTO.getAcessoSistemaCitsmart();
		} else {
			return perfilAcessoService.getAcessoCitsmartByUsuario(idUsuario);
		}
	}

	private Integer getIdPerfilAcessoUsuario(final Integer idUsuario) throws ServiceException, Exception {
		final PerfilAcessoUsuarioService perfilAcessoService = (PerfilAcessoUsuarioService) ServiceLocator.getInstance().getService(PerfilAcessoUsuarioService.class, null);
		PerfilAcessoUsuarioDTO perfilAcessoDTO = new PerfilAcessoUsuarioDTO();
		perfilAcessoDTO.setIdUsuario(idUsuario);
		perfilAcessoDTO = perfilAcessoService.listByIdUsuario(perfilAcessoDTO);
		if (perfilAcessoDTO == null) {
			return null;
		} else {
			return perfilAcessoDTO.getIdPerfilAcesso();
		}
	}

	public void redefinirSenha(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		// Obtendo o login ou e-mail informado na popup de recuperao de senha.
		final LoginDTO loginDTO = (LoginDTO) document.getBean();
		if (loginDTO != null) {
			// Obtendo servios para consultar informaes de usurio e
			// empregado.
			final UsuarioService usuarioService = (UsuarioService) ServiceLocator.getInstance().getService(UsuarioService.class, null);
			final EmpregadoService empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, null);
			try {
				if (usuarioService != null) {
					UsuarioDTO usuarioDTO = null;
					EmpregadoDTO empregadoDTO = null;
					// Verificando se foi informado um valor.
					if (loginDTO.getLogin() != null) {
						if (loginDTO.getLogin().trim().equals("")) {
							document.alert(UtilI18N.internacionaliza(request, "login.necessarioInformarEmailOuLogin"));
							document.executeScript("$('#login').focus()");
							return;
						}

						// Verificando se o valor informado  um e-mail.
						if (loginDTO.getLogin().matches("\\b[a-z0-9._%+-]+@[a-z0-9.-]+\\.[a-z]{2,4}\\b")) {
							// Obtendo o empregado a partir o e-mail.
							empregadoDTO = empregadoService.restoreByEmail(loginDTO.getLogin());
							usuarioDTO = usuarioService.restoreByIdEmpregado(empregadoDTO.getIdEmpregado());
						} else { // caso no seja, assume que  login.
							// Restaurando o usurio atravs do login.
							usuarioDTO = usuarioService.restoreByLogin(loginDTO.getLogin());
							empregadoDTO = empregadoService.restoreByIdUsuario(usuarioDTO.getIdUsuario());
							// Obtendo o empregado.
							if (empregadoDTO != null) {
								empregadoDTO = empregadoService.restoreEmpregadosAtivosById(empregadoDTO.getIdEmpregado());
							}
						}

						if (empregadoDTO.getIdEmpregado() != null && empregadoDTO.getIdEmpregado() > 0) {
							String algoritmo = br.com.citframework.util.Constantes.getValue("ALGORITMO_CRIPTOGRAFIA_SENHA", DEFAULT_ALGORITMO_CRIPTOGRAFIA_SENHA);
							if (algoritmo == null || !algoritmo.trim().equalsIgnoreCase("")) {
								algoritmo = DEFAULT_ALGORITMO_CRIPTOGRAFIA_SENHA;
							}

							final EmailAlteracaoSenhaDTO emailAlteracaoSenhaDTO = new EmailAlteracaoSenhaDTO();
							emailAlteracaoSenhaDTO.setLogin(usuarioDTO.getLogin());
							emailAlteracaoSenhaDTO.setNomeEmpregado(empregadoDTO.getNome());
							final UUID uuid = UUID.randomUUID();
							String novaSenha = uuid.toString();
							novaSenha = novaSenha.replaceAll("-", "");
							novaSenha = novaSenha.substring(0, 7);
							emailAlteracaoSenhaDTO.setNovaSenha(novaSenha);
							usuarioDTO.setSenha(CriptoUtils.generateHash(novaSenha, algoritmo));
							usuarioService.updateNotNull(usuarioDTO);
							emailAlteracaoSenhaDTO.setLink(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.URL_Sistema, "33"));

							final String ID_MODELO_EMAIL_ALTERACAO_SENHA = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_MODELO_EMAIL_ALTERACAO_SENHA, "18");
							final MensagemEmail mensagem = new MensagemEmail(Integer.parseInt(ID_MODELO_EMAIL_ALTERACAO_SENHA.trim()), new IDto[] { emailAlteracaoSenhaDTO });
							mensagem.envia(empregadoDTO.getEmail(), "", ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.SMTP_ENVIO_RemetenteNotificacoesSolicitacao, "10"));
							document.alert(String.format(UtilI18N.internacionaliza(request, "login.alteracaoSenha.notificacaoEnvioEmail"), empregadoDTO.getNome(), empregadoDTO.getEmail()));
						}
					}
				}
			} catch (final Exception e) {
				document.alert(UtilI18N.internacionaliza(request, "login.alteracaoSenha.cancelamento"));
				e.printStackTrace();
			}
		}
	}

	public void internacionaliza(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final LoginDTO login = (LoginDTO) document.getBean();

		String IDIOMAPADRAO = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.IDIOMAPADRAO, " ").toLowerCase();

		if (IDIOMAPADRAO == null) {
			IDIOMAPADRAO = "";
		}

		request.getSession(true).setAttribute("menu", null);
		request.getSession(true).setAttribute("menuPadrao", null);

		WebUtil webUtil = new WebUtil();

		if (login != null) {

			if (login.getLocale() != null) {
				webUtil.setLocale(login.getLocale().trim(), request);
				XmlReadLookup.getInstance(new Locale(login.getLocale().trim()));
			} else {
				webUtil.setLocale(IDIOMAPADRAO, request);
				XmlReadLookup.getInstance(new Locale(IDIOMAPADRAO));
			}
		} else {
			webUtil.setLocale(IDIOMAPADRAO, request);
			XmlReadLookup.getInstance(new Locale(IDIOMAPADRAO));
		}
		document.executeScript("window.location.reload()");
	}

	public void gerarChaveInicial(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		Map<String, String> props = getAuthEncryption().rp();

		String k = null;
		if (props != null && props.get("k") != null && !props.get("k").isEmpty()) {
			k = props.get("k");
		} else {
			k = UUID.randomUUID().toString();
		}

		HTMLElement genKey = document.getElementById("genKey");
		genKey.setValue(k);
	}

	/**
	 * Fora a validao da licena do cliente.
	 * 
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	public void validarChave(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		LoginDTO loginDTO = (LoginDTO) document.getBean();

		if (loginDTO.getChave() != null && !loginDTO.getChave().isEmpty()) {
			L l = new L();
			l.setA(loginDTO.getChave());
			l.setI(Versao.getVersao());
			l.setJ(Versao.getTipoAplicacao());
			l.setK(loginDTO.getGenKey());

			L lCheck = Auth.cl(l);

			if (lCheck != null) {
				if (lCheck.isC()) {
					Auth.cp(l, true);

					document.alert(UtilI18N.internacionaliza(request, "validarChaveSeguranca.validacaoRealizada"));
					document.executeScript("Modal.close(\"modal-empresa\");");
				} else {
					document.alert(UtilI18N.internacionaliza(request, "validarChaveSeguranca.validacaoRealizadaInvalida"));
				}

				return;
			} else {
				document.alert(UtilI18N.internacionaliza(request, "validarChaveSeguranca.validacaoNaoRealizada"));
			}
		} else {
			document.alert(UtilI18N.internacionaliza(request, "validarChaveSeguranca.validacaoNaoRealizada"));
		}
	}

	public AuthEncryption getAuthEncryption() {
		if (authEncryption == null) {
			authEncryption = new AuthEncryption();
		}

		return authEncryption;
	}
}