package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citcorpore.bean.MapaDesenhoCatalogoNegocioDTO;
import br.com.centralit.citcorpore.bean.MapaDesenhoCatalogoNegocioImagemDTO;
import br.com.centralit.citcorpore.bean.MapaDesenhoCatalogoNegocioImagemRelacaoDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.negocio.MapaDesenhoCatalogoNegocioImagemRelacaoService;
import br.com.centralit.citcorpore.negocio.MapaDesenhoCatalogoNegocioImagemService;
import br.com.centralit.citcorpore.negocio.ServicoService;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilStrings;
import br.com.citframework.util.WebUtil;

@SuppressWarnings({ "unchecked", "rawtypes" })
public class MapaDesenhoCatalogoNegocio extends AjaxFormAction {

	private ArrayList<Integer> itensDeletadosInesperadamente;

	@Override
	public Class getBeanClass() {
		return MapaDesenhoCatalogoNegocioDTO.class;
	}

	public void selecionarProcessoNegocio(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		MapaDesenhoCatalogoNegocioDTO mapa = (MapaDesenhoCatalogoNegocioDTO) document.getBean();

		String serializacaoProcessoNegocioMapaImg = getSerializacaoProcessoNegocioMapaImg(mapa, request);
		serializacaoProcessoNegocioMapaImg = StringEscapeUtils.escapeJavaScript(serializacaoProcessoNegocioMapaImg);
		mapa.setSerializacaoListCatalogoNegocioImagem(serializacaoProcessoNegocioMapaImg);

		itensDeletadosInesperadamente = new ArrayList<Integer>();
		if (this.itensDeletadosInesperadamente.size() > 0) {
			document.alert(UtilI18N.internacionaliza(request, "mapaDesenhoServico.algunsItensForamDeletadosPorOutrasFontes") + itensDeletadosInesperadamente.toString());
		}
		HTMLForm form = document.getForm("form");
		form.setValues(mapa);

		document.executeScript("atualizaProcessoNegocioMapa('" + serializacaoProcessoNegocioMapaImg + "');");
	}

	private String getSerializacaoProcessoNegocioMapaImg(MapaDesenhoCatalogoNegocioDTO mapa, HttpServletRequest request) throws Exception {

		MapaDesenhoCatalogoNegocioImagemService processoNegocioImagemService = (MapaDesenhoCatalogoNegocioImagemService) ServiceLocator.getInstance().getService(
				MapaDesenhoCatalogoNegocioImagemService.class, null);
		
		MapaDesenhoCatalogoNegocioImagemRelacaoService processoNegocioImagemRelacaoService = (MapaDesenhoCatalogoNegocioImagemRelacaoService) ServiceLocator.getInstance().getService(
				MapaDesenhoCatalogoNegocioImagemRelacaoService.class, null);

		ArrayList<MapaDesenhoCatalogoNegocioImagemDTO> listProcessoNegocioImagem = (ArrayList) processoNegocioImagemService.findByIdCatalogoNegocio(mapa.getIdCatalogoNegocio());

		String serializado = null;

		if (listProcessoNegocioImagem != null) {

			for (MapaDesenhoCatalogoNegocioImagemDTO img : listProcessoNegocioImagem) {

				ServicoService servicoService = (ServicoService) ServiceLocator.getInstance().getService(ServicoService.class, null);
				ServicoDTO servicoDto = new ServicoDTO();
				servicoDto.setIdServico(img.getIdServico());
				servicoDto = (ServicoDTO) servicoService.restore(servicoDto);
				
				if (servicoDto != null) {
					img.setNomeServico(servicoDto.getNomeServico());
				}else{
					itensDeletadosInesperadamente.add(img.getIdServico());
					processoNegocioImagemService.delete(img);
				}
				
				if (img.getIdCatalogoNegocioMapaImg() != null) {
					Collection<MapaDesenhoCatalogoNegocioImagemRelacaoDTO> listProcessoNegocioImagemRelacaoPai = processoNegocioImagemRelacaoService.findByIdCatalogoNegocioMapaImgFilho(img);

					if (listProcessoNegocioImagemRelacaoPai != null && !listProcessoNegocioImagemRelacaoPai.isEmpty()) {
						String colSerializado = WebUtil.serializeObjects(listProcessoNegocioImagemRelacaoPai, WebUtil.getLanguage(request));
						img.setSerializacaoListPaisCatNegImgRelacaoDTOs(colSerializado);
					}
				}
			}
		}
		serializado = WebUtil.serializeObjects(listProcessoNegocioImagem, WebUtil.getLanguage(request));

		return serializado;
	}

	public void selecionarServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		MapaDesenhoCatalogoNegocioDTO mapa = (MapaDesenhoCatalogoNegocioDTO) document.getBean();

		ServicoService servicoService = (ServicoService) ServiceLocator.getInstance().getService(ServicoService.class, null);
		ServicoDTO servicoDto = new ServicoDTO();
		servicoDto.setIdServico(mapa.getIdServico());
		servicoDto = (ServicoDTO) servicoService.restore(servicoDto);

		if (servicoDto != null) {
			mapa.setNomeServico(servicoDto.getNomeServico());
			mapa.setIdServico(servicoDto.getIdServico());

			HTMLForm form = document.getForm("form");
			form.clear();
			form.setValues(mapa);
		}
	}

	public void salvarProcessoNegocio(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		ArrayList<MapaDesenhoCatalogoNegocioImagemDTO> listaItens = (ArrayList) WebUtil.deserializeCollectionFromRequest(MapaDesenhoCatalogoNegocioImagemDTO.class,
				"serializacaoListCatalogoNegocioImagem", request);

		MapaDesenhoCatalogoNegocioImagemService processoNegocioImagemService = (MapaDesenhoCatalogoNegocioImagemService) ServiceLocator.getInstance().getService(MapaDesenhoCatalogoNegocioImagemService.class, null);
		
		MapaDesenhoCatalogoNegocioImagemRelacaoService processoNegocioImagemRelacaoServico = (MapaDesenhoCatalogoNegocioImagemRelacaoService) ServiceLocator.getInstance().getService(MapaDesenhoCatalogoNegocioImagemRelacaoService.class, null);
		
		if (listaItens != null) {
			for (MapaDesenhoCatalogoNegocioImagemDTO img : listaItens) {
				if (img.getIdCatalogoNegocioMapaImg() == 0) {
					processoNegocioImagemService.create(img);
				} else {
					processoNegocioImagemService.update(img);
				}
				//Salvar itens na tabela de relao
				if (img.getSerializacaoListPaisCatNegImgRelacaoDTOs() != null && UtilStrings.isNotVazio(img.getSerializacaoListPaisCatNegImgRelacaoDTOs())) {
					Collection<MapaDesenhoCatalogoNegocioImagemRelacaoDTO> listaProcessoNegocioImagemRelacao = WebUtil.deserializeCollectionFromString(
							MapaDesenhoCatalogoNegocioImagemRelacaoDTO.class, img.getSerializacaoListPaisCatNegImgRelacaoDTOs());

					for (MapaDesenhoCatalogoNegocioImagemRelacaoDTO imagemRelacao : listaProcessoNegocioImagemRelacao) {
						if (imagemRelacao != null && imagemRelacao.getIdCatalogoNegocioMapaImgFilho() != null && imagemRelacao.getIdCatalogoNegocioMapaImgPai() != null) {
							MapaDesenhoCatalogoNegocioImagemRelacaoDTO imgAux = processoNegocioImagemRelacaoServico.findByIdCatalogoNegocioMapaImgFilhoAndIdImgPai(imagemRelacao);
							if(imgAux == null){
								processoNegocioImagemRelacaoServico.create(imagemRelacao);
							}
						}
					}
				}

			}
		}
		selecionarProcessoNegocio(document, request, response);
		document.executeScript("UtilMapa.mostrarMsgTemporaria('msg', 4," + UtilI18N.internacionaliza(request, "MSG06") + " );");
	}

	public void excluirProcessoNegocioImagem(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		MapaDesenhoCatalogoNegocioDTO mapa = (MapaDesenhoCatalogoNegocioDTO) document.getBean();
		
		MapaDesenhoCatalogoNegocioImagemService processoNegocioImagemService = (MapaDesenhoCatalogoNegocioImagemService) ServiceLocator.getInstance().getService(MapaDesenhoCatalogoNegocioImagemService.class, null);
		MapaDesenhoCatalogoNegocioImagemDTO imagemDto = new MapaDesenhoCatalogoNegocioImagemDTO();
		imagemDto.setIdCatalogoNegocioMapaImg(mapa.getIdCatalogoNegocioMapaImg());
		
		MapaDesenhoCatalogoNegocioImagemRelacaoService processoNegocioImagemRelacaoService = (MapaDesenhoCatalogoNegocioImagemRelacaoService) ServiceLocator.getInstance().getService(MapaDesenhoCatalogoNegocioImagemRelacaoService.class, null);
		processoNegocioImagemRelacaoService.deleteRelacaoByIdPai(imagemDto);
		processoNegocioImagemRelacaoService.deleteRelacaoByIdFilho(imagemDto);
		
		processoNegocioImagemService.delete(imagemDto);
		String serializacaoProcessoNegocioMapaImg = getSerializacaoProcessoNegocioMapaImg(mapa, request);
		mapa.setSerializacaoListCatalogoNegocioImagem(serializacaoProcessoNegocioMapaImg);
		HTMLForm form = document.getForm("form");
		form.setValues(mapa);

		document.executeScript("finalizaExclusaoImagemProcessoNegocio('" + serializacaoProcessoNegocioMapaImg + "');");
	}

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

	}

}
