package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.BaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.ConhecimentoMidiaSoftwareDTO;
import br.com.centralit.citcorpore.bean.MidiaDTO;
import br.com.centralit.citcorpore.bean.MidiaSoftwareChaveDTO;
import br.com.centralit.citcorpore.bean.MidiaSoftwareDTO;
import br.com.centralit.citcorpore.bean.TipoSoftwareDTO;
import br.com.centralit.citcorpore.negocio.ItemConfiguracaoService;
import br.com.centralit.citcorpore.negocio.MidiaService;
import br.com.centralit.citcorpore.negocio.MidiaSoftwareChaveService;
import br.com.centralit.citcorpore.negocio.MidiaSoftwareService;
import br.com.centralit.citcorpore.negocio.TipoSoftwareService;
import br.com.centralit.lucene.Lucene;
import br.com.citframework.dto.IDto;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;

public class MidiaSoftware extends AjaxFormAction {

	private MidiaSoftwareDTO midiaSoftwareBean;

	public void load(DocumentHTML document, HttpServletRequest request,HttpServletResponse response) throws Exception {

		MidiaService midiaService = (MidiaService) ServiceLocator.getInstance().getService(
				MidiaService.class, null);
		HTMLSelect selectMidia = (HTMLSelect) document.getSelectById("idMidia");
		Collection<MidiaDTO> lista =  midiaService.list();

		selectMidia.removeAllOptions();
		selectMidia.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
		for (MidiaDTO sis : lista) {
			if(sis.getNome().equalsIgnoreCase("Carto de Memria")){
				selectMidia.addOption(String.valueOf(sis.getIdMidia()),UtilI18N.internacionaliza(request, "midiaSoftware.cartaoMemoria"));
			} else if(sis.getNome().equalsIgnoreCase("Disquete")){
				selectMidia.addOption(String.valueOf(sis.getIdMidia()), UtilI18N.internacionaliza(request, "midiaSoftware.disquete"));
			} else if(sis.getNome().equalsIgnoreCase("Fita Magntica")){
				selectMidia.addOption(String.valueOf(sis.getIdMidia()), UtilI18N.internacionaliza(request, "midiaSoftware.fitaMagnetica"));
			} else if(sis.getNome().equalsIgnoreCase("Outros")){
				selectMidia.addOption(String.valueOf(sis.getIdMidia()), UtilI18N.internacionaliza(request, "colaborador.outros"));
			} else{
				selectMidia.addOption(String.valueOf(sis.getIdMidia()), sis.getNome());
			}
		}

		TipoSoftwareService tipoSoftwareService = (TipoSoftwareService) ServiceLocator.getInstance().getService(
				TipoSoftwareService.class, null);
		HTMLSelect selectTipo = (HTMLSelect) document.getSelectById("idTipoSoftware");
		Collection<TipoSoftwareDTO> lista2 = tipoSoftwareService.list();

		selectTipo.removeAllOptions();
		selectTipo.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
		for (TipoSoftwareDTO sis : lista2) {
			if(sis.getNome().equalsIgnoreCase("Auxiliar de Escritrio")){
				selectTipo.addOption(String.valueOf(sis.getIdTipoSoftware()), UtilI18N.internacionaliza(request, "midiaSoftware.auxiliarDeEscritorio"));
			}else if(sis.getNome().equalsIgnoreCase("Comunicador Instantneo")){
				selectTipo.addOption(String.valueOf(sis.getIdTipoSoftware()), UtilI18N.internacionaliza(request, "midiaSoftware.comunicadorInstantaneo"));
			}else if(sis.getNome().equalsIgnoreCase("Editor de Imagem")){
				selectTipo.addOption(String.valueOf(sis.getIdTipoSoftware()), UtilI18N.internacionaliza(request, "midiaSoftware.editorImagem"));
			}else if(sis.getNome().equalsIgnoreCase("Editor de Texto")){
				selectTipo.addOption(String.valueOf(sis.getIdTipoSoftware()), UtilI18N.internacionaliza(request, "midiaSoftware.editorTexto"));
			}else if(sis.getNome().equalsIgnoreCase("Navegador")){
				selectTipo.addOption(String.valueOf(sis.getIdTipoSoftware()), UtilI18N.internacionaliza(request, "midiaSoftware.navegador"));
			}else if(sis.getNome().equalsIgnoreCase("Outros")){
				selectTipo.addOption(String.valueOf(sis.getIdTipoSoftware()), UtilI18N.internacionaliza(request, "colaborador.outros"));
			}else if(sis.getNome().equalsIgnoreCase("Sistema Operacional")){
				selectTipo.addOption(String.valueOf(sis.getIdTipoSoftware()), UtilI18N.internacionaliza(request, "citcorpore.comum.sistemaOperacional"));
			} else {
				selectTipo.addOption(String.valueOf(sis.getIdTipoSoftware()), sis.getNome());
		    }
		}
	}

	public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		MidiaSoftwareDTO midiaSoftware = (MidiaSoftwareDTO) document.getBean();
		MidiaSoftwareService midiaSoftwareService = (MidiaSoftwareService) ServiceLocator.getInstance().getService(MidiaSoftwareService.class, null);
		midiaSoftware = (MidiaSoftwareDTO) midiaSoftwareService.restore(midiaSoftware);

		this.geraHtmlMidiaSoftwareChave(midiaSoftware.getMidiaSoftwareChaves(), document, request);
		this.geraHtmlBaseConhecimento(midiaSoftware.getConhecimentos(), document, request);

		HTMLForm form = document.getForm("form");
		form.clear();
		form.setValues(midiaSoftware);
	}
	
	@SuppressWarnings("unchecked")
	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		MidiaSoftwareDTO midiaSoftware = (MidiaSoftwareDTO) document.getBean();
		MidiaSoftwareService midiaSoftwareService = (MidiaSoftwareService) ServiceLocator.getInstance().getService(MidiaSoftwareService.class, null);
		
		List<MidiaSoftwareChaveDTO> listaChaves =  (List<MidiaSoftwareChaveDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(MidiaSoftwareChaveDTO.class, "midiaSoftwareChaveSerializada", request);
		midiaSoftware.setMidiaSoftwareChaves(listaChaves);
		
		List<ConhecimentoMidiaSoftwareDTO> listaConhecimentos =  (List<ConhecimentoMidiaSoftwareDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(ConhecimentoMidiaSoftwareDTO.class, "conhecimentosSerializados", request);
		midiaSoftware.setConhecimentos(listaConhecimentos);
		
		if (midiaSoftware.getIdMidiaSoftware() == null || midiaSoftware.getIdMidiaSoftware() == 0) {
			if (midiaSoftwareService.consultarMidiasAtivas(midiaSoftware)) {
				document.alert(UtilI18N.internacionaliza(request, "MSE01"));
				return;
			}
			midiaSoftware.setDataInicio(UtilDatas.getDataAtual());
			midiaSoftwareService.create(midiaSoftware);
			document.alert(UtilI18N.internacionaliza(request, "MSG05"));
			
		} else {
			if (midiaSoftwareService.consultarMidiasAtivas(midiaSoftware)) {
				document.alert(UtilI18N.internacionaliza(request, "MSE01"));
				return;
			}
			midiaSoftwareService.update(midiaSoftware);
			document.alert(UtilI18N.internacionaliza(request, "MSG06"));
		}
		
		HTMLForm form = document.getForm("form");
		form.clear();
		document.executeScript("limpar()");
	}

	public void excluir(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		MidiaSoftwareDTO midiaSoftware = (MidiaSoftwareDTO) document.getBean();
		MidiaSoftwareService midiaSoftwareService = (MidiaSoftwareService) ServiceLocator.getInstance().getService(MidiaSoftwareService.class, null);
		ItemConfiguracaoService itemService = (ItemConfiguracaoService) ServiceLocator.getInstance().getService(ItemConfiguracaoService.class, null);

		if(!itemService.verificaMidiaSoftware(midiaSoftware.getIdMidiaSoftware())) {
			midiaSoftware.setDataFim(UtilDatas.getDataAtual());
			midiaSoftwareService.update(midiaSoftware);

			HTMLForm form = document.getForm("form");
			form.clear();
			document.executeScript("limpar()");
			document.alert(UtilI18N.internacionaliza(request, "MSG07"));
		}else {
			document.alert("Mdia possui vnculos a Item de configurao");
		}
	}
	
	public void geraHtmlMidiaSoftwareChave(Collection<MidiaSoftwareChaveDTO> colMidiaSoftwareChave, DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLElement divMidiaSoftwareChave = document.getElementById("divMidiaSoftwareChave");
		StringBuilder sb = new StringBuilder();
		if (colMidiaSoftwareChave != null && !colMidiaSoftwareChave.isEmpty()) {

			sb.append(geraCabecalhoTabelaMidiaSoftwareChave(request));
			for (MidiaSoftwareChaveDTO midiaSoftwareChaveDTO : colMidiaSoftwareChave) {
				sb.append(geraDadosTabelaMidiaSoftwareChave(midiaSoftwareChaveDTO.getIdMidiaSoftwareChave(), midiaSoftwareChaveDTO.getChave(), midiaSoftwareChaveDTO.getQtdPermissoes(), request));
			}
			sb.append(geraFinalTabela());

		} else {
			sb.append("<h4>" + UtilI18N.internacionaliza(request, "midiaSoftware.nenhumaLicencaAdicionada") + "</h4>");
		}
		divMidiaSoftwareChave.setInnerHTML(sb.toString());
		document.executeScript("limpaCamposLicenca();");
	}
	
	public void addLinhaTabelaMidiaSoftwareChave(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLElement tblMidiaSoftwareChave = document.getElementById("tblMidiaSoftwareChave");
		MidiaSoftwareDTO midiaSoftware = (MidiaSoftwareDTO) document.getBean();
		if (midiaSoftware!=null) {
			MidiaSoftwareChaveService midiaSoftwareChaveService = (MidiaSoftwareChaveService) ServiceLocator.getInstance().getService(MidiaSoftwareChaveService.class, null);
			if (midiaSoftwareChaveService.chaveNaoCadastrada(midiaSoftware.getIdMidiaSoftware(),midiaSoftware.getChave())){
				tblMidiaSoftwareChave.appendHTML(geraDadosTabelaMidiaSoftwareChave(midiaSoftware.getIdMidiaSoftwareChave(), midiaSoftware.getChave(), midiaSoftware.getQtdPermissoes(), request));
				document.executeScript("limpaCamposLicenca();");
			} else {
				document.executeScript("notificacaoErro('midiaSoftware.chaveJaCadastradaEmOutraMidia','');");
			}
		}
	}
	
	public void addTabelaMidiaSoftwareChave(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLElement divMidiaSoftwareChave = document.getElementById("divMidiaSoftwareChave");
		MidiaSoftwareDTO midiaSoftware = (MidiaSoftwareDTO) document.getBean();

		StringBuilder sb = new StringBuilder();

		sb.append(geraCabecalhoTabelaMidiaSoftwareChave(request));
		sb.append(geraDadosTabelaMidiaSoftwareChave(midiaSoftware.getIdMidiaSoftwareChave(), midiaSoftware.getChave(), midiaSoftware.getQtdPermissoes(), request));
		sb.append(geraFinalTabela());
		divMidiaSoftwareChave.setInnerHTML(sb.toString());
		
		document.executeScript("limpaCamposLicenca();");
	}
	
	private String geraCabecalhoTabelaMidiaSoftwareChave(HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		sb.append("	<div class=\"table-responsive tabela\" >");
		sb.append("		<table id='tblMidiaSoftwareChave' class=\"table table-bordered table-striped table-condensed\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th class='span7'>").append(UtilI18N.internacionaliza(request, "midiaSoftware.chave")).append("</th> ");
		sb.append("					<th class='span4'>").append(UtilI18N.internacionaliza(request, "midiaSoftware.qtdPermissoes")).append("</th> ");
		sb.append("					<th class='span1'>").append(UtilI18N.internacionaliza(request, "citcorpore.comum.acoes")).append("</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody id='tbodyTblMidiaSoftwareChave'> ");

		return sb.toString();
	}
	
	private String geraDadosTabelaMidiaSoftwareChave(final Integer idMidiaSoftwareChave, final String chave, final Integer qtdPermissoes, final HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();
		String onMouseOver = "onmouseover=\"abreTooltip(this, '" + UtilI18N.internacionaliza(request, "midiaSoftware.excluirLicenca") + "')\" onmouseout=\"fechaTooltip();\"";

		sb.append("		<tr id='").append(idMidiaSoftwareChave).append("'>");
		sb.append("			<td>").append(chave).append("</td> ");
		sb.append("			<td>").append(qtdPermissoes).append("</td> ");
		sb.append("			<td class=\"center visualizacaoHide\" style=\"width: 30px;\">");
		sb.append("				<a onclick=\"removerMidiaSoftwareChaveFromTable(this);\" ").append(onMouseOver).append(" class=\"btn-action glyphicons remove_2 btn-default\"><i></i></a>");
		sb.append("			</td> ");
		sb.append("		</tr> ");

		return sb.toString();
	}

	public void geraHtmlBaseConhecimento(Collection<ConhecimentoMidiaSoftwareDTO> colConhecimento, DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLElement divConhecimento = document.getElementById("divConhecimento");
		StringBuilder sb = new StringBuilder();
		if (colConhecimento != null && !colConhecimento.isEmpty()) {

			sb.append(geraCabecalhoTabelaBaseConhecimento(request));
			for (ConhecimentoMidiaSoftwareDTO conhecimentoMidiaSoftwareDTO : colConhecimento) {
				sb.append(geraDadosTabelaBaseConhecimento(conhecimentoMidiaSoftwareDTO.getIdConhecimentoMidiaSoftware(), conhecimentoMidiaSoftwareDTO.getIdBaseConhecimento(), conhecimentoMidiaSoftwareDTO.getTitulo(), request));
			}
			sb.append(geraFinalTabela());

		} else {
			sb.append("<h4>" + UtilI18N.internacionaliza(request, "citcorpore.comum.nenhumConhecimentoVinculado") + "</h4>");
		}
		divConhecimento.setInnerHTML(sb.toString());
	}
	
	public void addLinhaTabelaBaseConhecimento(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLElement tblBaseConhecimento = document.getElementById("tblBaseConhecimento");
		MidiaSoftwareDTO midiaSoftware = (MidiaSoftwareDTO) document.getBean();
		if (midiaSoftware!=null) {
			tblBaseConhecimento.appendHTML(geraDadosTabelaBaseConhecimento(midiaSoftware.getIdConhecimentoMidiaSoftware(), midiaSoftware.getIdBaseConhecimento(), midiaSoftware.getTitulo(), request));
		}
		document.executeScript("Modal.close('modal-pesquisaConhecimento');");
	}
	
	public void addTabelaBaseConhecimento(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLElement divConhecimento = document.getElementById("divConhecimento");
		MidiaSoftwareDTO midiaSoftware = (MidiaSoftwareDTO) document.getBean();

		StringBuilder sb = new StringBuilder();

		sb.append(geraCabecalhoTabelaBaseConhecimento(request));
		sb.append(geraDadosTabelaBaseConhecimento(midiaSoftware.getIdConhecimentoMidiaSoftware(), midiaSoftware.getIdBaseConhecimento(), midiaSoftware.getTitulo(), request));
		sb.append(geraFinalTabela());
		divConhecimento.setInnerHTML(sb.toString());
		document.executeScript("Modal.close('modal-pesquisaConhecimento');");
	}
	
	private String geraCabecalhoTabelaBaseConhecimento(HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		sb.append("	<div class=\"table-responsive tabela\" >");
		sb.append("		<table id='tblBaseConhecimento' class=\"table table-bordered table-striped table-condensed\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th class='span4'>").append(UtilI18N.internacionaliza(request, "baseConhecimentoView.id")).append("</th> ");
		sb.append("					<th>").append(UtilI18N.internacionaliza(request, "baseConhecimento.titulo")).append("</th> ");
		sb.append("					<th class='span1'>").append(UtilI18N.internacionaliza(request, "citcorpore.comum.acoes")).append("</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody id='tbodyTblBaseConhecimento'> ");

		return sb.toString();
	}
	
	private String geraDadosTabelaBaseConhecimento(final Long idConhecimentoMidiaSoftware, final Integer idBaseConhecimento, final String titulo, final HttpServletRequest request) {
		
		StringBuilder sb = new StringBuilder();
		String onMouseOver = "onmouseover=\"abreTooltip(this, '" + UtilI18N.internacionaliza(request, "baseConhecimento.removerConhecimento") + "')\" onmouseout=\"fechaTooltip();\"";

		sb.append("		<tr id='").append(idConhecimentoMidiaSoftware).append("'>");
		sb.append("			<td>").append(idBaseConhecimento).append("</td> ");
		sb.append("			<td>").append(titulo).append("</td> ");
		sb.append("			<td class=\"center visualizacaoHide\" style=\"width: 30px;\">");
		sb.append("				<a onclick=\"removerBaseConhecimentoFromTable(this);\" ").append(onMouseOver).append(" class=\"btn-action glyphicons remove_2 btn-default\"><i></i></a>");
		sb.append("			</td> ");
		sb.append("		</tr> ");

		return sb.toString();
	}

	private String geraFinalTabela() {
		StringBuilder sb = new StringBuilder();
		
		sb.append("			</tbody> ");
		sb.append("		</table>");
		sb.append("	</div>");
		
		return sb.toString();
	}
	
	public void setMidiaSoftwareBean(IDto softwares) {
		this.midiaSoftwareBean = (MidiaSoftwareDTO) softwares;
	}
	
	public void pesquisaLucene(DocumentHTML document, HttpServletRequest request,HttpServletResponse response) throws Exception{
		MidiaSoftwareDTO midiaSoftware = (MidiaSoftwareDTO) document.getBean();
		if ((midiaSoftware!=null)&&(midiaSoftware.getPesquisa()!=null)&&(midiaSoftware.getPesquisa().length()>0)){
			StringBuilder sbResultado = new StringBuilder();
			
			BaseConhecimentoDTO baseConhecimentoDTO = new BaseConhecimentoDTO();
			baseConhecimentoDTO.setTermoPesquisa(midiaSoftware.getPesquisa());
			
			Lucene lucene = new Lucene();
			ArrayList<BaseConhecimentoDTO> listaResultado = lucene.pesquisaBaseConhecimento(baseConhecimentoDTO);
			
			String onMouseOver = "onmouseover=\"abreTooltip(this, '" + UtilI18N.internacionaliza(request, "baseConhecimento.vincularBaseConhecimento") + "')\" onmouseout=\"fechaTooltip();\"";
			
			sbResultado.append("	<div class=\"table-responsive tabela\" >");
			sbResultado.append("		<table id='tblResultadoBaseConhecimento' class=\"table table-bordered table-striped table-condensed\"> ");
			sbResultado.append("			<thead> ");
			sbResultado.append("				<tr> ");
			sbResultado.append("					<th class='span2'>").append(UtilI18N.internacionaliza(request, "baseConhecimentoView.id")).append("</th> ");
			sbResultado.append("					<th>").append(UtilI18N.internacionaliza(request, "baseConhecimento.titulo")).append("</th> ");
			sbResultado.append("					<th style='width:30px;'>").append(UtilI18N.internacionaliza(request, "citcorpore.comum.acao")).append("</th> ");
			sbResultado.append("				</tr> ");
			sbResultado.append("			</thead> ");
			sbResultado.append("			<tbody id='tbodyTblResultadoBaseConhecimento'> ");
			for (BaseConhecimentoDTO baseConhecimento : listaResultado) {
				sbResultado.append("				<tr> ");
				sbResultado.append("					<td>").append(baseConhecimento.getIdBaseConhecimento()).append("</td> ");
				sbResultado.append("					<td>").append(baseConhecimento.getTitulo()).append("</td> ");
				sbResultado.append("					<td class=\"center visualizacaoHide\" style=\"vertical-align:middle;\">");
				sbResultado.append("						<a onclick=\"escolherBaseConhecimentoFromTable(this);\" ").append(UtilHTML.geraTooltip("baseConhecimento.vincularBaseConhecimento")).append(" class=\"btn-action glyphicons ok_2 btn-primary\"><i></i></a>");
				sbResultado.append("					</td> ");
				sbResultado.append("				</tr> ");
			}
			sbResultado.append(geraFinalTabela());
			
			HTMLElement divResultadoPesquisa = document.getElementById("divResultadoPesquisa");
			if (divResultadoPesquisa!=null){
				divResultadoPesquisa.setInnerHTML(sbResultado.toString());
			}
			document.executeScript("Modal.open('modal-pesquisaConhecimento');");
		}
		document.executeScript("JANELA_AGUARDE_MENU.hide();");
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public Class getBeanClass() {
		return MidiaSoftwareDTO.class;
	}

	public MidiaSoftwareDTO getMidiaSoftwareBean() {
		return this.midiaSoftwareBean;
	}

}