package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Arrays;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.GerenciaConfiguracaoParametrosDTO;
import br.com.centralit.citcorpore.bean.ParametroCorporeDTO;
import br.com.centralit.citcorpore.negocio.ParametroCorporeService;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.citframework.service.ServiceLocator;

public class MobileGerenciamentoDeParametros extends AjaxFormAction {
	private GerenciaConfiguracaoParametrosDTO gerenciaConfiguracaoParametrosDTO;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		ArrayList<Enumerados.ParametroSistema> listParametros = new ArrayList<Enumerados.ParametroSistema>(
			Arrays.asList(
					Enumerados.ParametroSistema.MOBILE_CONTRATO_PADRAO,
					Enumerados.ParametroSistema.MOBILE_SERVICO_PADRAO_SOLICITACAO,
					Enumerados.ParametroSistema.MOBILE_ORIGEM_PADRAO_SOLICITACAO,
					Enumerados.ParametroSistema.MOBILE_NOTIFICACAO_SEM_RESPONSAVEL
			)
		);

		for(Enumerados.ParametroSistema parametro : listParametros){
			document.executeScript("addLinhaTabelaAtributos(" + parametro.id() + ",'"
					+ StringUtils.replace(parametro.getCampoParametroInternacionalizado(request), "'", "\\'") + "','"
					+ StringEscapeUtils.escapeJavaScript(StringUtils.replace(ParametroUtil.getValorParametroCitSmartHashMap(parametro, ""), "'", "\'")) + "', '"
					+ parametro.tipoCampo() + "')"
			);
		}

			document.executeScript("renderiza()");

	}

	@SuppressWarnings("unchecked")
	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		this.setGerenciaConfiguracaoParametrosDTO((GerenciaConfiguracaoParametrosDTO) document.getBean());

		this.getGerenciaConfiguracaoParametrosDTO().setListConfiguracaoParametrosDTO(br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(GerenciaConfiguracaoParametrosDTO.class, "listConfiguracaoParametroSerializado", request));
		ParametroCorporeService parametroCorporeService = (ParametroCorporeService) ServiceLocator.getInstance().getService(ParametroCorporeService.class, null);

		if (this.getGerenciaConfiguracaoParametrosDTO() != null
				&& this.getGerenciaConfiguracaoParametrosDTO().getListConfiguracaoParametroDTO() != null && !this.getGerenciaConfiguracaoParametrosDTO().getListConfiguracaoParametroDTO().isEmpty()) {

			for (GerenciaConfiguracaoParametrosDTO parametroGerenciaConfiguracaoParametrosDTO : this.getGerenciaConfiguracaoParametrosDTO().getListConfiguracaoParametroDTO()) {
				ParametroCorporeDTO parametroCorporeDTO = new ParametroCorporeDTO();

				parametroCorporeDTO.setId(Integer.parseInt(parametroGerenciaConfiguracaoParametrosDTO.getId().trim()));
				parametroCorporeDTO = (ParametroCorporeDTO) parametroCorporeService.restore(parametroCorporeDTO);

				if (parametroCorporeDTO.getTipoDado() != null && parametroCorporeDTO.getTipoDado().equalsIgnoreCase("Boolean")) {
					parametroCorporeDTO.setValor(Internacionalizar.internacionalizaOptionSN(request, "save", parametroGerenciaConfiguracaoParametrosDTO.getValorAtributoConfiguracaoParametro()));
				} else {
					parametroCorporeDTO.setValor(parametroGerenciaConfiguracaoParametrosDTO.getValorAtributoConfiguracaoParametro().trim());
				}

				parametroCorporeService.atualizarParametros(parametroCorporeDTO);
			}
			document.executeScript("notificacaoI18N('MSG06');");
		}
	}

	@Override
	public Class<GerenciaConfiguracaoParametrosDTO> getBeanClass() {
		return GerenciaConfiguracaoParametrosDTO.class;
	}

	public GerenciaConfiguracaoParametrosDTO getGerenciaConfiguracaoParametrosDTO() {
		return gerenciaConfiguracaoParametrosDTO;
	}

	public void setGerenciaConfiguracaoParametrosDTO(GerenciaConfiguracaoParametrosDTO gerenciaConfiguracaoParametrosDTO) {
		this.gerenciaConfiguracaoParametrosDTO = gerenciaConfiguracaoParametrosDTO;
	}
}
