package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLTable;
import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.negocio.GrupoService;
import br.com.centralit.citsmart.rest.bean.MobileGerenciamentoDeWebServicesDTO;
import br.com.centralit.citsmart.rest.bean.RestOperationDTO;
import br.com.centralit.citsmart.rest.bean.RestPermissionDTO;
import br.com.centralit.citsmart.rest.service.RestOperationService;
import br.com.centralit.citsmart.rest.service.RestPermissionService;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;

@SuppressWarnings({ "unchecked", "rawtypes" })
public class MobileGerenciamentoDeWebServices extends AjaxFormAction {
	private MobileGerenciamentoDeWebServicesDTO mobileGerenciamentoDeWebServicesDTO;

	private RestOperationService restOperationService;
	private RestPermissionService restPermissionService;
	private GrupoService grupoService;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		this.restoreLinkedGroupsInWebServices(document, request, response);
		this.restoreCitsmartMobileWebServices(document, request, response);
	}

	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		List<Integer> listIdsGroupsRestPermissionDTO = new ArrayList();

		try {
			final Collection<RestPermissionDTO> colGrupos = br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(RestPermissionDTO.class, "colGrupoSerialize", request);
			if (colGrupos != null) {
				for (final RestPermissionDTO restPermissionDTO : colGrupos) {
					listIdsGroupsRestPermissionDTO.add(restPermissionDTO.getIdGrupo());
				}
			}

			Collection<RestOperationDTO> colRestOperationDTO = this.getRestOperationService().listCitsmartMobileWebServices();

			if (colRestOperationDTO != null && !colRestOperationDTO.isEmpty()) {
				for (final RestOperationDTO restOperationDTO : colRestOperationDTO) {
					for (int k = 0; k < listIdsGroupsRestPermissionDTO.size(); k++) {
						RestPermissionDTO restPermissionDTO = new RestPermissionDTO();
						restPermissionDTO.setIdGroup(listIdsGroupsRestPermissionDTO.get(k));
						restPermissionDTO.setIdRestOperation(restOperationDTO.getIdRestOperation());
						restPermissionDTO.setStatus(restOperationDTO.getStatus());

						if (this.getRestPermissionService().verifyIfExists(restPermissionDTO.getIdRestOperation(), restPermissionDTO.getIdGroup())) {
							this.getRestPermissionService().update(restPermissionDTO);
						} else {
							this.getRestPermissionService().create(restPermissionDTO);
						}
					}
				}
				document.alert(UtilI18N.internacionaliza(request, "citsmartMobile.configuracaoWebservices.grupoVinculadoComSucesso"));
			}
		} finally {
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
			this.restoreLinkedGroupsInWebServices(document, request, response);
		}
	}

	public void restoreLinkedGroupsInWebServices(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		Collection<GrupoDTO> colGrupos = new ArrayList();
		final Collection<RestPermissionDTO> colPermissoes = this.getRestPermissionService().listCitsmartMobileLinkedGroups();

		if (colPermissoes != null && !colPermissoes.isEmpty()) {
			for (RestPermissionDTO restPermissionDTO : colPermissoes) {
				restPermissionDTO.setIdGrupo(restPermissionDTO.getIdGroup());
				GrupoDTO grupoDto = new GrupoDTO();
				grupoDto.setIdGrupo(restPermissionDTO.getIdGroup());
				grupoDto = (GrupoDTO) this.getGrupoService().restore(grupoDto);
				if (grupoDto != null) {
					grupoDto.getNome();
				}
				if (!colGrupos.contains(grupoDto))
					colGrupos.add(grupoDto);
			}
		}
		if (colGrupos != null && !colGrupos.isEmpty()) {
			final HTMLTable table = document.getTableById("tabelaGrupos");
			table.deleteAllRows();
			table.addRowsByCollection(colGrupos, new String[] { "", "idGrupo", "nome" }, null, null, new String[] { "gerarButtonDeleteGrupo" }, null, null);

			document.executeScript("$('#divTabelaGrupos').css('display', '');");
		} else {
			document.executeScript("$('#divTabelaGrupos').css('display', 'none');");
		}
	}
	
	public void unlinkGroupInWebServices(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		this.setMobileGerenciamentoDeWebServicesDTO((MobileGerenciamentoDeWebServicesDTO) document.getBean());

		try {
			if (this.getMobileGerenciamentoDeWebServicesDTO() != null && this.getMobileGerenciamentoDeWebServicesDTO().getIdGrupo() != null) {
				this.getRestPermissionService().unlinkGroupInWebServices(this.getMobileGerenciamentoDeWebServicesDTO().getIdGrupo());

				final HTMLTable table = document.getTableById("tabelaGrupos");
				table.deleteRow(this.getMobileGerenciamentoDeWebServicesDTO().getRowIndex());
				document.alert(UtilI18N.internacionaliza(request, "citsmartMobile.configuracaoWebservices.grupoDesvinculadoComSucesso"));
			}
		} finally {
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
			this.restoreLinkedGroupsInWebServices(document, request, response);
		}
	}
	

	public void restoreCitsmartMobileWebServices(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		Collection<RestOperationDTO> listRestOperationDTO = this.getRestOperationService().listCitsmartMobileWebServices();
		this.refreshTableCitsmartMobileWebServices(document, request, listRestOperationDTO);
	}
	
	private void refreshTableCitsmartMobileWebServices(DocumentHTML document, HttpServletRequest request, Collection<RestOperationDTO> listRestOperations) throws Exception {
		HTMLElement divDinamicoListaCitsmartMobileWebServices = document.getElementById("divDinamicoListaCitsmartMobileWebServices");

		if (listRestOperations != null) {
			divDinamicoListaCitsmartMobileWebServices.setInnerHTML(buildHTMLTableCitsmartMobileWebServices(request, listRestOperations));

		} else {
			divDinamicoListaCitsmartMobileWebServices = document.getElementById("divDinamicoListaCitsmartMobileWebServices");
			StringBuilder sb = new StringBuilder();
			sb.append("<h4>" + UtilI18N.internacionaliza(request, "citsmartMobile.configuracaoWebservices.nenhumWebServiceCadastrado") + "</h4>");
			divDinamicoListaCitsmartMobileWebServices.setInnerHTML(sb.toString());
		}
	}

	private String buildHTMLTableCitsmartMobileWebServices(HttpServletRequest request, Collection<RestOperationDTO> listRestOperations) throws Exception {
		StringBuilder sb = new StringBuilder();
		if (listRestOperations != null) {
			sb.append(buildHTMLHeaderTableCitsmartMobileWebServices(request));
			
			for (RestOperationDTO restOperationDTO : listRestOperations) {
				sb.append(buildHTMLDataTableCitsmartMobileWebServices(restOperationDTO, request));
			}
			sb.append(buildHTMLEndTableCitsmartMobileWebServices());
		}
		return sb.toString();
	}

	private String buildHTMLHeaderTableCitsmartMobileWebServices(HttpServletRequest request) throws Exception {
		StringBuilder sb = new StringBuilder();

		sb.append("<div class='row-fluid' id='divTableWebServices'> ");
		sb.append("	<div class=\"table-responsive tabela\">");
		sb.append("		<table class=\"table table-bordered table-striped table-condensed table-vertical-center checkboxs js-table-sortable ui-sortable\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th> ID </th> ");
		sb.append("					<th>" + UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "citcorpore.comum.nome")) + "</th> ");
		sb.append("					<th>" + UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "citcorpore.comum.descricao")) + "</th> ");
		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.acoes") + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody> ");

		return sb.toString();
	}
	
	private String buildHTMLDataTableCitsmartMobileWebServices(RestOperationDTO restOperationDTO, HttpServletRequest request) throws Exception {
		StringBuilder sb = new StringBuilder();

		String onClickShowWebService = "";
		String onClickEditWebService = "";
		String onMouseOverShowWebService = "";
		String onMouseOverEditWebService = "";

		onMouseOverShowWebService = UtilI18N.internacionaliza(request, "citsmartMobile.configuracaoWebservices.showWebService");
		
		onMouseOverEditWebService = UtilI18N.internacionaliza(request, "citsmartMobile.configuracaoWebservices.editWebService");

		sb.append("		<tr>");
		sb.append("			<td>" + restOperationDTO.getIdRestOperation() + "</td> ");
		sb.append("			<td>" + restOperationDTO.getName() + "</td> ");
		sb.append("			<td>" + restOperationDTO.getDescription() + "</td> ");
		sb.append("			<td class=\"center\" style=\"width: 90px;\"> ");

		// showButton
		sb.append("<span class='btn-action glyphicons search btn-primary mt2' title='").append(onMouseOverShowWebService).append("' ");
		sb.append("onclick='showWebService($(this).parent().parent().find(\"td:first-child\").text());' style='cursor:pointer;'><i></i></span> ");
		// editButton
		sb.append(" <span class='btn-action glyphicons pencil btn-primary mt2' title='").append(onMouseOverEditWebService).append("' ");
		sb.append("onclick='editWebService($(this).parent().parent().find(\"td:first-child\").text());' style='cursor:pointer;'><i></i></span>");

		sb.append("			</td> ");
		sb.append("		</tr> ");

		return sb.toString();
	}

	private String buildHTMLEndTableCitsmartMobileWebServices() {
		StringBuilder sb = new StringBuilder();
		sb.append("			</tbody> ");
		sb.append("		</table>");
		sb.append("	</div>");
		sb.append("</div>");

		return sb.toString();
	}

	public void filtrarWebService(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		this.setMobileGerenciamentoDeWebServicesDTO((MobileGerenciamentoDeWebServicesDTO) document.getBean());

		if (this.getMobileGerenciamentoDeWebServicesDTO() != null) {

			if (this.getMobileGerenciamentoDeWebServicesDTO().getTextoPesquisado() == null || this.getMobileGerenciamentoDeWebServicesDTO().getTextoPesquisado().isEmpty()) {
				this.restoreCitsmartMobileWebServices(document, request, response);
			} else {
				Collection<RestOperationDTO> listRestOperations = this.getRestOperationService().listByText(this.getMobileGerenciamentoDeWebServicesDTO().getTextoPesquisado());
				if (listRestOperations != null && !listRestOperations.isEmpty()) {
					refreshTableCitsmartMobileWebServices(document, request, listRestOperations);
				}else{
					HTMLElement divDinamico = document.getElementById("divDinamicoListaCitsmartMobileWebServices");
					String listaVazia = "<h4>" + UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "gerenciaportfolio.nenhumGrupoOuUsuarioVinculado")) + "</h4>";
					divDinamico.setInnerHTML(listaVazia);
				}
			}
		}
	}

	@Override
	public Class<MobileGerenciamentoDeWebServicesDTO> getBeanClass() {
		return MobileGerenciamentoDeWebServicesDTO.class;
	}

	private MobileGerenciamentoDeWebServicesDTO getMobileGerenciamentoDeWebServicesDTO() {
		return this.mobileGerenciamentoDeWebServicesDTO;
	}

	private void setMobileGerenciamentoDeWebServicesDTO(MobileGerenciamentoDeWebServicesDTO mobileGerenciamentoDeWebServicesDTO) {
		this.mobileGerenciamentoDeWebServicesDTO = mobileGerenciamentoDeWebServicesDTO;
	}

	private RestOperationService getRestOperationService() throws ServiceException {
		if (restOperationService == null) {
			restOperationService = (RestOperationService) ServiceLocator.getInstance().getService(RestOperationService.class, null);
		}

		return restOperationService;
	}

	private RestPermissionService getRestPermissionService() throws ServiceException {
		if (restPermissionService == null) {
			restPermissionService = (RestPermissionService) ServiceLocator.getInstance().getService(RestPermissionService.class, null);
		}

		return restPermissionService;
	}

	private GrupoService getGrupoService() throws ServiceException {
		if (grupoService == null) {
			grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
		}

		return grupoService;
	}
}