package br.com.centralit.citcorpore.ajaxForms;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.google.gson.Gson;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.CategoriaOcorrenciaDTO;
import br.com.centralit.citcorpore.bean.ContatoRequisicaoMudancaDTO;
import br.com.centralit.citcorpore.bean.JustificativaSolicitacaoDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaMudancaDTO;
import br.com.centralit.citcorpore.bean.OrigemOcorrenciaDTO;
import br.com.centralit.citcorpore.bean.RequisicaoMudancaDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.integracao.CategoriaOcorrenciaDAO;
import br.com.centralit.citcorpore.integracao.OrigemOcorrenciaDAO;
import br.com.centralit.citcorpore.negocio.JustificativaSolicitacaoService;
import br.com.centralit.citcorpore.negocio.OcorrenciaMudancaService;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.OccurrenceCategory;
import br.com.centralit.citcorpore.util.Enumerados.TipoDate;
import br.com.centralit.citcorpore.util.Util;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilStrings;
import net.htmlparser.jericho.Source;

public class OcorrenciaMudanca extends AjaxFormAction  {

	private OcorrenciaMudancaDTO ocorrenciaMudancaDto;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
    	ocorrenciaMudancaDto = (OcorrenciaMudancaDTO) document.getBean();
    	
    	if(!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
    		return;
		}
    	
    	UsuarioDTO usuario = WebUtil.getUsuario(request);

    	geraComboCategoria(document, request);
    	geraComboOrigem(document, request);
    	document.getElementById("registradopor").setValue(usuario.getNomeUsuario() );

    	String listaDeInformacoes = this.listInfoRegExecucaoRequisicaoMudanca(usuario.getLocale());
    	
    	if (ocorrenciaMudancaDto != null && listaDeInformacoes != null && listaDeInformacoes.trim() != null) {
			document.getElementById("divRelacaoOcorrencias").setInnerHTML(listaDeInformacoes);
		}


    }

    private void geraComboCategoria(DocumentHTML document, HttpServletRequest request) throws Exception {
    	HTMLSelect comboTipoDemanda = document.getSelectById("categoria");
    	comboTipoDemanda.removeAllOptions();
    	comboTipoDemanda.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione") );

		for (OccurrenceCategory c : OccurrenceCategory.values()) {
			if (!c.equals(OccurrenceCategory.SLA_CHANGE) && !c.equals(OccurrenceCategory.RECLASSIFICATION) && !c.equals(OccurrenceCategory.ACTIVITY_SCHEDULE) && !c.equals(OccurrenceCategory.REQUEST_SUSPENSION)
					&& !c.equals(OccurrenceCategory.REQUEST_REACTIVATION) && !c.equals(OccurrenceCategory.REQUEST_CLOSING) && !c.equals(OccurrenceCategory.REQUEST_REOPENING) && !c.equals(OccurrenceCategory.REQUEST_DIRECTION)
					&& !c.equals(OccurrenceCategory.TASK_SHARING) && !c.equals(OccurrenceCategory.CREATION)) {
				comboTipoDemanda.addOption(c.name().toString(), UtilI18N.internacionaliza(request, c.getI18NKey()));
    		}
    	}
    }

    private void geraComboOrigem(DocumentHTML document, HttpServletRequest request) throws Exception {
    	HTMLSelect comboTipoDemanda = document.getSelectById("origem");
    	comboTipoDemanda.removeAllOptions();
    	comboTipoDemanda.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione") );

    	for(Enumerados.OrigemOcorrencia c : Enumerados.OrigemOcorrencia.values() ) {
    		comboTipoDemanda.addOption(c.getSigla().toString(), c.getDescricao() );
    	}
    }



    /**
	 * Retorna uma lista de informaes da entidade ocorrencia
	 *
	 * @param requisicaoMudancaDto
	 * @param request
	 * @return
	 * @throws ServiceException
	 * @throws Exception
	 * @author geber.costa
	 */
	public String listInfoRegExecucaoRequisicaoMudanca(String locale) throws ServiceException, Exception {
		JustificativaSolicitacaoService justificativaService = (JustificativaSolicitacaoService) ServiceLocator.getInstance().getService(JustificativaSolicitacaoService.class, null);

		OcorrenciaMudancaService ocorrenciaMudancaService = (OcorrenciaMudancaService) ServiceLocator.getInstance().getService(OcorrenciaMudancaService.class, null);

		Collection<OcorrenciaMudancaDTO> col = ocorrenciaMudancaService.findByIdRequisicaoMudanca(ocorrenciaMudancaDto.getIdRequisicaoMudanca());

		CategoriaOcorrenciaDAO categoriaOcorrenciaDAO = new CategoriaOcorrenciaDAO();
		OrigemOcorrenciaDAO origemOcorrenciaDAO = new OrigemOcorrenciaDAO();

		CategoriaOcorrenciaDTO categoriaOcorrenciaDTO = new CategoriaOcorrenciaDTO();
		OrigemOcorrenciaDTO origemOcorrenciaDTO = new OrigemOcorrenciaDTO();

		//
		String strBuffer = "<table class='dynamicTable table table-striped table-bordered table-condensed dataTable' style='table-layout: fixed;'>";
    	strBuffer += "<tr>";
    	strBuffer += "<td class='linhaSubtituloGridOcorr'>";
		strBuffer += UtilI18N.internacionaliza(locale, "ocorrenciaMudanca.codigoocorrencia");
		strBuffer += "</td>";
		strBuffer += "<td class='linhaSubtituloGridOcorr'>";
		strBuffer += UtilI18N.internacionaliza(locale, "ocorrenciaMudanca.informacaoocorrencia");
		strBuffer += "</td>";
		strBuffer += "<td class='linhaSubtituloGridOcorr'>";
		strBuffer += UtilI18N.internacionaliza(locale, "citcorpore.comum.categoria");
		strBuffer += "</td>";
		strBuffer += "<td class='linhaSubtituloGridOcorr'>";
		strBuffer += UtilI18N.internacionaliza(locale, "citcorpore.comum.origem");
		strBuffer += "</td>";
		strBuffer += "<td class='linhaSubtituloGridOcorr'>";
		strBuffer += UtilI18N.internacionaliza(locale, "ocorrenciaMudanca.tempoGasto");
		strBuffer += "</td>";
		strBuffer += "</tr>";
		//

		if (col != null) {

			for (OcorrenciaMudancaDTO ocorrenciaMudancaDto : col) {

				String ocorrencia = UtilStrings.nullToVazio(ocorrenciaMudancaDto.getOcorrencia());

				if (ocorrenciaMudancaDto.getOcorrencia() != null) {
					Source source = new Source(ocorrenciaMudancaDto.getOcorrencia());
					ocorrenciaMudancaDto.setOcorrencia(source.getTextExtractor().toString());
				}

				if (ocorrenciaMudancaDto.getIdJustificativa() != null) {
					JustificativaSolicitacaoDTO justificativaDto = new JustificativaSolicitacaoDTO();
					justificativaDto.setIdJustificativa(ocorrenciaMudancaDto.getIdJustificativa() );
					justificativaDto = (JustificativaSolicitacaoDTO) justificativaService.restore(justificativaDto);
					if (justificativaDto != null) {
						ocorrencia += "<br>" + UtilI18N.internacionaliza(locale, "citcorpore.comum.justificativa") + ": " + justificativaDto.getDescricaoJustificativa() + "<br>";
					}
				}

				if (ocorrenciaMudancaDto.getComplementoJustificativa() != null) {
					ocorrencia += "<br>" + UtilI18N.internacionaliza(locale, "gerenciaservico.mudarsla.complementojustificativa")
					+ ": <b>" + ocorrenciaMudancaDto.getComplementoJustificativa() + "<br>";
				}

				String dadosMudanca = UtilStrings.nullToVazio(ocorrenciaMudancaDto.getDadosMudanca());

				if (dadosMudanca.length() > 0) {
					try {
						RequisicaoMudancaDTO solicitacaoDto = new Gson().fromJson(dadosMudanca,RequisicaoMudancaDTO.class);

						if (solicitacaoDto != null) {
							if(solicitacaoDto.getDescrStatus() != null && !solicitacaoDto.getDescrStatus().isEmpty())
								solicitacaoDto.setDescrStatus( UtilI18N.internacionaliza(locale, solicitacaoDto.getDescrStatus()));
							
							dadosMudanca = solicitacaoDto.recuperaDadosStr(locale);
						}
					} catch (Exception e) {
						dadosMudanca = "";
					}
				}

				String informacoesContato = UtilStrings.nullToVazio(ocorrenciaMudancaDto.getInformacoesContato() );

				if (informacoesContato.length() > 0) {
					try {
						ContatoRequisicaoMudancaDTO contatoDto = new Gson().fromJson(informacoesContato, ContatoRequisicaoMudancaDTO.class);
						if (contatoDto != null) {
							informacoesContato = contatoDto.recuperaDadosStr();
						}
					} catch (Exception e) {
						informacoesContato = "";
					}
				}

				ocorrencia = ocorrencia.replaceAll("\"", "");
				informacoesContato = informacoesContato.replaceAll("\"", "");
				ocorrencia = ocorrencia.replaceAll("\n", "<br>");
				informacoesContato = informacoesContato.replaceAll("\n", "<br>");
				dadosMudanca = dadosMudanca.replaceAll("\n", "<br>");
				ocorrencia = UtilHTML.encodeHTML(ocorrencia.replaceAll("\'", "") );
				informacoesContato = UtilHTML.encodeHTML(informacoesContato.replaceAll("\'", "") );

				strBuffer += "<tr>";
				strBuffer += "<td rowspan='4'>";
				strBuffer += "<b>" + ocorrenciaMudancaDto.getIdOcorrencia() + "</b>";
				strBuffer += "</td>";
	        	strBuffer += "<td>";
	        	strBuffer += "<b>" + UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, ocorrenciaMudancaDto.getDataregistro(), locale) + " - " + ocorrenciaMudancaDto.getHoraregistro();
	        	strBuffer += " - </b>" + UtilI18N.internacionaliza(locale, "ocorrenciaMudanca.registradopor") + ": <b>" + ocorrenciaMudancaDto.getRegistradopor() + "</b>";
	        	strBuffer += "</td>";

				// Categoria Ocorrncia
	        	strBuffer += "<td>";
	        	if (ocorrenciaMudancaDto.getIdCategoriaOcorrencia() != null && ocorrenciaMudancaDto.getIdCategoriaOcorrencia() != 0) {
	        		categoriaOcorrenciaDTO.setIdCategoriaOcorrencia(ocorrenciaMudancaDto.getIdCategoriaOcorrencia() );
	        		categoriaOcorrenciaDTO = (CategoriaOcorrenciaDTO) categoriaOcorrenciaDAO.restore(categoriaOcorrenciaDTO);
	        		strBuffer +=  UtilI18N.internacionaliza(locale, "citcorpore.comum.categoria") + ": <b>" + categoriaOcorrenciaDTO.getNome() + "</b>";
	        	} else {
	        		strBuffer +=  UtilI18N.internacionaliza(locale, "citcorpore.comum.categoria") + ": ";
	        	}
	        	strBuffer += "</td>";

				// Origem Ocorrncia
				strBuffer += "<td>";
				if (ocorrenciaMudancaDto.getIdOrigemOcorrencia() != null && ocorrenciaMudancaDto.getIdOrigemOcorrencia() != 0) {
					origemOcorrenciaDTO.setIdOrigemOcorrencia(ocorrenciaMudancaDto.getIdOrigemOcorrencia() );
					origemOcorrenciaDTO = (OrigemOcorrenciaDTO)	origemOcorrenciaDAO.restore(origemOcorrenciaDTO);
					strBuffer += UtilI18N.internacionaliza(locale, "origemAtendimento.origem") + ": <b>" + origemOcorrenciaDTO.getNome() + "</b>";
				} else {
					strBuffer += UtilI18N.internacionaliza(locale, "origemAtendimento.origem") + ": ";
				}
				strBuffer += "</td>";

				strBuffer += "<td>";
				strBuffer += UtilI18N.internacionaliza(locale, "ocorrenciaMudanca.tempoGasto") + ": <b><br />" + (ocorrenciaMudancaDto.getTempoGasto() != null ? ""
				+ ocorrenciaMudancaDto.getTempoGasto() + " min" : "--") + "</b>";
				strBuffer += "</td>";
				strBuffer += "</tr>";

				if (dadosMudanca == null || dadosMudanca.trim().equalsIgnoreCase("") ) {
					strBuffer += "<tr>";
        			strBuffer += "<td colspan='4' style='word-wrap: break-word;overflow:hidden;'>";
					strBuffer += UtilI18N.internacionaliza(locale, "citcorpore.comum.descricao") + ": <b>" + ocorrenciaMudancaDto.getDescricao() + "<br><br></b>";
        			strBuffer += "</td>";
        			strBuffer += "</tr>";
				} else {
					strBuffer += "<tr>";
    				strBuffer += "<td colspan='4' style='word-wrap: break-word;overflow:hidden;'>";

    				if (dadosMudanca != null && !dadosMudanca.trim().equalsIgnoreCase("") ) {
    					strBuffer += "<br>" + UtilI18N.internacionaliza(locale, "ocorrenciaMudanca.dadosrequisicaomudanca") + ": <b><br>" + dadosMudanca + "<br><br></b>";
    				}

    				strBuffer += "</td>";
        			strBuffer += "</tr>";
				}

				strBuffer += "<tr>";
				strBuffer += "<td colspan='4' style='word-wrap: break-word;overflow:hidden;'>";

				if (ocorrencia.length() > 0) {
					strBuffer += UtilI18N.internacionaliza(locale, "citcorpore.comum.ocorrencia") + ": <br><b>" + ocorrencia + "<br><br></b>";
				} else {
					strBuffer += "&nbsp;";
				}
				strBuffer += "</td>";
				strBuffer += "</tr>";

				if (informacoesContato == null || informacoesContato.trim().equalsIgnoreCase("") ) {
					strBuffer += "<tr>";
        			strBuffer += "<td colspan='4' style='word-wrap: break-word;overflow:hidden;'>";
        			if (ocorrenciaMudancaDto.getInformacoesContato() != null && ocorrenciaMudancaDto.getInformacoesContato().length() > 0) {
						strBuffer += UtilI18N.internacionaliza(locale, "citcorpore.comum.informacaoContato") + ": <br><b>" + ocorrenciaMudancaDto.getInformacoesContato() + "<br><br></b>";
					} else {
						strBuffer += "&nbsp;";
					}
        			strBuffer += "</td>";
        			strBuffer += "</tr>";
				} else {
					strBuffer += "<tr>";
        			strBuffer += "<td colspan='4' style='word-wrap: break-word;overflow:hidden;'>";
        			if (informacoesContato.length() > 0) {
						strBuffer += UtilI18N.internacionaliza(locale, "citcorpore.comum.informacaoContato") + ": <br><b>" + informacoesContato + "<br><br></b>";
					} else {
						strBuffer += "&nbsp;";
					}
    				strBuffer += "</td>";
					strBuffer += "</tr>";
				}
			}
		}
		strBuffer += "</table>";

		categoriaOcorrenciaDTO = null;
		origemOcorrenciaDTO = null;

		return strBuffer;
	}



	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
    	UsuarioDTO usuario = WebUtil.getUsuario(request);

    	if (usuario == null) {
    		document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada")	);
    		document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
    		return;
    	}

    	ocorrenciaMudancaDto = (OcorrenciaMudancaDTO) document.getBean();

    	if (ocorrenciaMudancaDto.getIdCategoriaOcorrencia() == null) {
    		document.alert(UtilI18N.internacionaliza(request, "MSE03") );
    		return;
    	}

		if (Util.isNullOrEmpty(ocorrenciaMudancaDto.getIdOrigemOcorrencia())) {
    		document.alert(UtilI18N.internacionaliza(request, "MSE4") );
    		return;
    	}

    	ocorrenciaMudancaDto.setDataInicio(UtilDatas.getDataAtual() );
    	ocorrenciaMudancaDto.setRegistradopor(usuario.getNomeUsuario() );
    	ocorrenciaMudancaDto.setDataregistro(UtilDatas.getDataAtual() );
    	ocorrenciaMudancaDto.setHoraregistro(UtilDatas.formatHoraFormatadaStr(UtilDatas.getHoraAtual() ) );
    	ocorrenciaMudancaDto.setIdRequisicaoMudanca(ocorrenciaMudancaDto.getIdRequisicaoMudanca() );
    	getService().create(ocorrenciaMudancaDto);
    	document.alert(UtilI18N.internacionaliza(request, "MSG05") );
    	HTMLForm form = document.getForm("formOcorrenciaMudanca");
    	form.clear();
    	document.executeScript("Modal.close('modal-requisicao-mudanca-ocorrencias');");
    }

	 private OcorrenciaMudancaService getService() throws ServiceException, Exception {
		 OcorrenciaMudancaService ocorrenciaMudancaService = (OcorrenciaMudancaService) ServiceLocator.getInstance().getService(OcorrenciaMudancaService.class, null);
	    	return ocorrenciaMudancaService;
	    }

	@Override
	public Class<OcorrenciaMudancaDTO> getBeanClass() {
		return OcorrenciaMudancaDTO.class;
	}

	public OcorrenciaMudancaDTO getOcorrenciaMudancaDto() {
		return ocorrenciaMudancaDto;
	}

	public void setOcorrenciaMudancaDto(OcorrenciaMudancaDTO ocorrenciaMudancaDto) {
		this.ocorrenciaMudancaDto = ocorrenciaMudancaDto;
	}


	public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		OcorrenciaMudancaDTO ocorrencia = (OcorrenciaMudancaDTO) document.getBean();
		ocorrencia = (OcorrenciaMudancaDTO) getService().restore(ocorrencia);
		HTMLForm form = document.getForm("formOcorrenciaMudanca");

		form.clear();
		form.setValues(ocorrencia);
    }
}
