package br.com.centralit.citcorpore.ajaxForms;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.json.JSONArray;
import org.json.JSONObject;

import com.google.gson.Gson;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.PermissaoAcessoControleDTO;
import br.com.centralit.citcorpore.bean.PermissaoAcessoPaginaDTO;
import br.com.centralit.citcorpore.negocio.PermissaoAcessoPaginaService;
import br.com.centralit.citcorpore.util.Enumerados.PagesPortfolio;
import br.com.centralit.citcorpore.util.Enumerados.SimNao;
import br.com.centralit.citcorpore.util.Enumerados.TipoPerfilAcesso;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilStrings;

public class PermissaoAcessoPortfolio extends AjaxFormAction {

	private PermissaoAcessoPaginaService permissaoAcessoPaginaService;

	@Override
	public Class<PermissaoAcessoControleDTO> getBeanClass() {
		return PermissaoAcessoControleDTO.class;
	}

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

	}

	public void restorePerfilAcesso(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		PermissaoAcessoControleDTO bean = (PermissaoAcessoControleDTO) document.getBean();

		if (bean.getIdPerfilAcesso() != null) {
			carregaTabelaPerfilAcessoPortfolio(document, request, bean.getIdPerfilAcesso());
		}

	}

	private void carregaTabelaPerfilAcessoPortfolio(DocumentHTML document, HttpServletRequest request, Integer idPerfilAcesso) throws ServiceException, Exception {
		JSONArray permissaoAcessoPortfolio = new JSONArray();

		Collection<PermissaoAcessoPaginaDTO> colPaginas = this.getPermissaoAcessoPaginaService().getPaginasByPerfilAcesso(idPerfilAcesso, TipoPerfilAcesso.PORTFOLIO.getIdentificador());

		if (colPaginas == null) {
			for (PagesPortfolio page : PagesPortfolio.values()) {
				JSONObject obj = new JSONObject(page);

				obj.put("caminho", page.getCaminho());
				obj.put("fase", UtilStrings.isNullOrEmpty(page.getChaveFase()) ? "" : UtilI18N.internacionaliza(request, page.getChaveFase()));
				obj.put("nomePagina", UtilStrings.isNullOrEmpty(page.getChave()) ? "" : UtilI18N.internacionaliza(request, page.getChave()));

				obj.put("permissaoPesquisar", "");
				obj.put("permissaoGravar", "");
				obj.put("permissaoDeletar", "");

				permissaoAcessoPortfolio.put(obj);
			}
		} else {
			for (PermissaoAcessoPaginaDTO permissaoAcessoPaginaDTO : colPaginas) {
				PagesPortfolio page = PagesPortfolio.fromCaminho(permissaoAcessoPaginaDTO.getCaminho());

				if (page != null) {
					JSONObject obj = new JSONObject();

					obj.put("caminho", page.getCaminho());
					obj.put("fase", UtilI18N.internacionaliza(request, page.getChaveFase()));
					obj.put("nomePagina", UtilI18N.internacionaliza(request, page.getChave()));

					obj.put("permissaoPesquisar", SimNao.SIM.getValorStr().equalsIgnoreCase(permissaoAcessoPaginaDTO.getPesquisa()) ? "checked='checked'" : "");
					obj.put("permissaoGravar", SimNao.SIM.getValorStr().equalsIgnoreCase(permissaoAcessoPaginaDTO.getGrava()) ? "checked='checked'" : "");
					obj.put("permissaoDeletar", SimNao.SIM.getValorStr().equalsIgnoreCase(permissaoAcessoPaginaDTO.getDeleta()) ? "checked='checked'" : "");

					permissaoAcessoPortfolio.put(obj);
				}
			}
		}

		document.executeScript("PerfilAcessoPortfolio.montaTabela(" + permissaoAcessoPortfolio.toString() + ");");
	}

	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		PermissaoAcessoControleDTO bean = (PermissaoAcessoControleDTO) document.getBean();
		bean = new Gson().fromJson(bean.getJson(), PermissaoAcessoControleDTO.class);

		if (bean != null && bean.getIdPerfilAcesso() != null && bean.getPermissaoAcessoPaginas() != null && !bean.getPermissaoAcessoPaginas().isEmpty()) {
			this.getPermissaoAcessoPaginaService().salvar(bean.getIdPerfilAcesso(), TipoPerfilAcesso.PORTFOLIO.getIdentificador(), bean.getPermissaoAcessoPaginas());
		}

		document.executeScript("notificacaoI18N('MSG14')");
	}


	private PermissaoAcessoPaginaService getPermissaoAcessoPaginaService() throws ServiceException {
		if (permissaoAcessoPaginaService == null) {
			permissaoAcessoPaginaService = (PermissaoAcessoPaginaService) ServiceLocator.getInstance().getService(PermissaoAcessoPaginaService.class, null);
		}

		return permissaoAcessoPaginaService;
	}
}