package br.com.centralit.citcorpore.ajaxForms;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.quartz.JobExecutionException;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.ItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.PesquisaItemConfiguracaoDTO;
import br.com.centralit.citcorpore.negocio.PesquisaItemConfiguracaoService;
import br.com.centralit.citcorpore.quartz.job.VerificaValidadeLicenca;
import br.com.centralit.citcorpore.util.Enumerados.CriticidadeIC;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.Enumerados.StatusIC;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.integracao.core.PageRequest;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;

public class PesquisaItemConfiguracao extends AjaxFormAction {

	private PesquisaItemConfiguracaoService pesquisaItemConfiguracaoService;

	@Override
	public Class<PesquisaItemConfiguracaoDTO> getBeanClass() {
		return PesquisaItemConfiguracaoDTO.class;
	}

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		String ocultarAreaExibirFilhos = request.getParameter("ocultarAreaExibirFilhos");
		if (ocultarAreaExibirFilhos != null) {
			document.executeScript("ocultarAreaExibirFilhos()");
		}

		String idItemPai = request.getParameter("idItemPai");
		if (idItemPai != null) {
			document.executeScript("$('#isFiltroSomenteFilhos').val('true');");
			document.executeScript("$('#idItemPai').val('" + idItemPai + "');");
		} else {
			document.executeScript("$('#isFiltroSomenteFilhos').val('false');");
			document.executeScript("$('#idItemPai').val(null);");
		}

		document.focusInFirstActivateField(null);
		document.executeScript("$('#loading_overlay').hide();");
		carregaComboStatus(document, request, response);
		carregaComboCriticidade(document, request, response);
	}

	private void carregaComboStatus(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect comboStatus = document.getSelectById("filtroStatus");
		this.inicializarCombo(comboStatus, request);

		for (StatusIC statusIc : StatusIC.values()) {
			comboStatus.addOption(String.valueOf(statusIc.getItem()), UtilI18N.internacionaliza(request, statusIc.getChaveInternacionalizacao()));
		}
	}

	private void carregaComboCriticidade(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect comboCriticidade = document.getSelectById("filtroCriticidade");
		this.inicializarCombo(comboCriticidade, request);

		for (CriticidadeIC criticidadeIc : CriticidadeIC.values()) {
			comboCriticidade.addOption(String.valueOf(criticidadeIc.getItem()), UtilI18N.internacionaliza(request, criticidadeIc.getDescricao()));
		}
	}

	private void inicializarCombo(HTMLSelect combo, HttpServletRequest request) throws Exception {
		combo.removeAllOptions();
		combo.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
	}

	public void pesquisarItemConfiguracao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		PesquisaItemConfiguracaoDTO pesquisaItemConfiguracaDto = (PesquisaItemConfiguracaoDTO) document.getBean();

		Integer itensPorPagina = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANT_RETORNO_PESQUISA, "10"));

		Integer paginaSelecionada = pesquisaItemConfiguracaDto.getPaginaSelecionada();
		if (paginaSelecionada == null || paginaSelecionada == 0) {
			paginaSelecionada = 1;
		}

		Pageable pageable = new PageRequest(paginaSelecionada - 1, itensPorPagina);
		HTMLElement divListaItens = document.getElementById("divDinamicoPesquisaItemConfiguracao");

		Collection<ItemConfiguracaoDTO> listItemConfiguracao = getPesquisaItemConfiguracaoService().listItemConfiguracaoByPesquisaDTO(pesquisaItemConfiguracaDto, pageable, false).getContent();

		if (listItemConfiguracao != null && !listItemConfiguracao.isEmpty()) {
			divListaItens.setInnerHTML(geraHTMLListaItemConfiguracao(request, listItemConfiguracao));

			Integer totalPaginas = getPesquisaItemConfiguracaoService().listItemConfiguracaoByPesquisaDTO(pesquisaItemConfiguracaDto, pageable, true).getTotalPages();

			HTMLElement paginacaoItemConfiguracao = document.getElementById("paginacaoItemConfiguracao");
			String funcaoJsPaginar = "paginarItemConfiguracao";
			paginacaoItemConfiguracao.setInnerHTML(UtilHTML.paginacaoHtml(request, funcaoJsPaginar, totalPaginas, paginaSelecionada));
		} else {
			final StringBuilder htmlDivSemRegistros = new StringBuilder();
			htmlDivSemRegistros.append("<h4>" + UtilI18N.internacionaliza(request, "MSG04") + "</h4>");
			divListaItens.setInnerHTML(htmlDivSemRegistros.toString());
		}

		document.executeScript("depoisCarregarTabelaItemConfiguracao();");
	}

	public void verificarExpiracao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws JobExecutionException {
		VerificaValidadeLicenca verificaValidadeLicenca = new VerificaValidadeLicenca();
		verificaValidadeLicenca.execute(null);
		document.alert(UtilI18N.internacionaliza(request, "pesquisaItemConfiguracao.executadoVerifEnviadoEmailResponsaveis"));
	}

	private String geraHTMLListaItemConfiguracao(HttpServletRequest request, Collection<ItemConfiguracaoDTO> listItemConfiguracao) {
		StringBuilder sb = new StringBuilder();

		sb.append(geraHtmlCabecalho(request));

		for (ItemConfiguracaoDTO itemConfiguracao : listItemConfiguracao) {
			sb.append(geraHtmlDadosTabela(request, itemConfiguracao));
		}

		sb.append(geraHTMLFinalTabela());

		return sb.toString();
	}

	private String geraHtmlCabecalho(final HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		sb.append("<div class='row-fluid'> ");
		sb.append("	<div class=\"table-responsive tabela\">");
		sb.append("		<table class=\"table table-bordered table-striped table-condensed table-vertical-center checkboxs js-table-sortable ui-sortable\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "lookup.id") + "</th> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.identificacao") + "</th> ");
		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.informacao") + "</th> ");
		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.acoes") + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody> ");

		return sb.toString();
	}

	private String geraHtmlDadosTabela(final HttpServletRequest request, ItemConfiguracaoDTO itemConfiguracao) {
		StringBuilder sb = new StringBuilder();

		sb.append("				<tr>");
		sb.append("					<td class=\"center\">" + itemConfiguracao.getIdItemConfiguracao() + "</td> ");
		sb.append("					<td>" + UtilHTML.encodeHTML(itemConfiguracao.getIdentificacao()) + "</td> ");
		sb.append("					<td class=\"center\" style=\"width: 60px;\"> ");
		sb.append("						<a onclick=\"exibirDialogInformacoes(");
		sb.append(itemConfiguracao.getIdItemConfiguracao());
		sb.append("						 );\" style=\"cursor: pointer;\" class=\"btn-action glyphicons circle_info btn-default\"><i></i></a> ");
		sb.append("					</td> ");
		sb.append("					<td class=\"center\" style=\"width: 60px;\"> ");
		sb.append("						<a onclick=\"popupAtivos(");
		sb.append(itemConfiguracao.getIdItemConfiguracao());
		sb.append(" , '");
		sb.append(itemConfiguracao.getIdentificacao());
		sb.append("						');\" style=\"cursor: pointer;\" class=\"btn-action glyphicons circle_ok btn-success\"><i></i></a> ");
		sb.append("					</td> ");
		sb.append("				</tr> ");

		return sb.toString();
	}

	private String geraHTMLFinalTabela() {
		StringBuilder sb = new StringBuilder();
		sb.append("			</tbody> ");
		sb.append("		</table>");
		sb.append("	</div>");
		sb.append("</div>");
		sb.append("<div class='row-fluid'> ");
		sb.append("	<div id=\"paginacaoItemConfiguracao\" class=\"divPaginacao\"></div>");
		sb.append("</div>");

		return sb.toString();
	}

	private PesquisaItemConfiguracaoService getPesquisaItemConfiguracaoService() throws ServiceException {
		if (pesquisaItemConfiguracaoService == null) {
			pesquisaItemConfiguracaoService = (PesquisaItemConfiguracaoService) ServiceLocator.getInstance().getService(PesquisaItemConfiguracaoService.class, null);
		}

		return pesquisaItemConfiguracaoService;
	}

}
