/**
 *
 */
package br.com.centralit.citcorpore.ajaxForms;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import br.com.centralit.bpm.dto.FluxoDTO;
import br.com.centralit.bpm.dto.PermissoesFluxoDTO;
import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.ContratoDTO;
import br.com.centralit.citcorpore.bean.FaseServicoDTO;
import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.OrigemAtendimentoDTO;
import br.com.centralit.citcorpore.bean.PesquisaRequisicaoLiberacaoDTO;
import br.com.centralit.citcorpore.bean.PrioridadeDTO;
import br.com.centralit.citcorpore.bean.RequisicaoLiberacaoDTO;
import br.com.centralit.citcorpore.bean.UnidadeDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.negocio.ContatoRequisicaoLiberacaoService;
import br.com.centralit.citcorpore.negocio.ContratoService;
import br.com.centralit.citcorpore.negocio.ContratoServiceEjb;
import br.com.centralit.citcorpore.negocio.EmpregadoService;
import br.com.centralit.citcorpore.negocio.FaseServicoService;
import br.com.centralit.citcorpore.negocio.GrupoService;
import br.com.centralit.citcorpore.negocio.OrigemAtendimentoService;
import br.com.centralit.citcorpore.negocio.PermissoesFluxoService;
import br.com.centralit.citcorpore.negocio.PrioridadeService;
import br.com.centralit.citcorpore.negocio.RequisicaoLiberacaoService;
import br.com.centralit.citcorpore.negocio.UnidadeService;
import br.com.centralit.citcorpore.negocio.UsuarioService;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.ReleaseRequestStatus;
import br.com.centralit.citcorpore.util.Enumerados.ServiceDemandType;
import br.com.centralit.citcorpore.util.Enumerados.TipoDate;
import br.com.centralit.citcorpore.util.UtilRelatorio;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.centralit.citged.bean.ControleGEDDTO;
import br.com.centralit.citged.negocio.ControleGEDService;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.fill.JRAbstractLRUVirtualizer;
import net.sf.jasperreports.engine.fill.JRGzipVirtualizer;
import net.sf.jasperreports.engine.xml.JRXmlLoader;

@SuppressWarnings({ "rawtypes", "unchecked", "unused" })
public class PesquisaRequisicaoLiberacao extends AjaxFormAction {

	UsuarioDTO usuario;
	private String localeSession = null;

	@Override
	public Class getBeanClass() {
		return PesquisaRequisicaoLiberacaoDTO.class;
	}

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		usuario = WebUtil.getUsuario(request);

		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		document.getSelectById("idContrato").removeAllOptions();
		ContratoService contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
		Collection colContrato = contratoService.list();
		document.getSelectById("idContrato").addOption("", "-- " + UtilI18N.internacionaliza(request, "citcorpore.comum.todos") + " --");
		document.getSelectById("idContrato").addOptions(colContrato, "idContrato", "numero", null);

		document.getSelectById("idPrioridade").removeAllOptions();
		PrioridadeService prioridadeService = (PrioridadeService) ServiceLocator.getInstance().getService(PrioridadeService.class, null);
		Collection col = prioridadeService.list();
		document.getSelectById("idPrioridade").addOption("", "-- " + UtilI18N.internacionaliza(request, "citcorpore.comum.todos") + " --");
		document.getSelectById("idPrioridade").addOptions(col, "idPrioridade", "nomePrioridade", null);

		preencherComboIdStatus(document, request);

		document.getSelectById("idGrupoAtual").removeAllOptions();
		GrupoService grupoSegurancaService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
		Collection colGrupos = grupoSegurancaService.findGruposAtivos();
		document.getSelectById("idGrupoAtual").addOption("", "-- " + UtilI18N.internacionaliza(request, "citcorpore.comum.todos") + " --");
		document.getSelectById("idGrupoAtual").addOptions(colGrupos, "idGrupo", "nome", null);

		document.getSelectById("idFaseAtual").removeAllOptions();
		FaseServicoService faseServicoService = (FaseServicoService) ServiceLocator.getInstance().getService(FaseServicoService.class, null);
		Collection<FaseServicoDTO>  colFases = faseServicoService.list();
		Enumerados.FaseServicoFluxo faseServico;
		if (colFases != null) {
			for (FaseServicoDTO faseServicoDTO : colFases){
					if(faseServicoDTO!=null && faseServicoDTO.getNomeFase()!=null){
						faseServico = Enumerados.FaseServicoFluxo.fromIdentificador(faseServicoDTO.getNomeFase());
						if(faseServico!=null) {
							faseServicoDTO.setNomeFase(UtilI18N.internacionaliza(request, faseServico.getChave()));
						}
					}
			}
		}
		document.getSelectById("idFaseAtual").addOption("", "-- " + UtilI18N.internacionaliza(request, "citcorpore.comum.todos") + " --");
		document.getSelectById("idFaseAtual").addOptions(colFases, "idFase", "nomeFase", null);

		document.getSelectById("idOrigem").removeAllOptions();
		OrigemAtendimentoService origemAtendimentoService = (OrigemAtendimentoService) ServiceLocator.getInstance().getService(OrigemAtendimentoService.class, null);
		Collection colOrigem = origemAtendimentoService.list();
		document.getSelectById("idOrigem").addOption("", "-- " + UtilI18N.internacionaliza(request, "citcorpore.comum.todos") + " --");
		document.getSelectById("idOrigem").addOptions(colOrigem, "idOrigem", "descricao", null);

		HTMLSelect comboTipoDemandaServico = document.getSelectById("idTipoDemandaServico");
		comboTipoDemandaServico.removeAllOptions();
		comboTipoDemandaServico.addOption("", "-- " + UtilI18N.internacionaliza(request, "citcorpore.comum.todos") + " --");
		for (ServiceDemandType serviceDemandType : ServiceDemandType.values()) {
			comboTipoDemandaServico.addOption(String.valueOf(serviceDemandType.getId()), UtilI18N.internacionaliza(request, serviceDemandType.getI18NKey()));
		}
	}

	private void preencherComboIdStatus(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect comboIdStatus = document.getSelectById("idStatus");
		comboIdStatus.removeAllOptions();
		comboIdStatus.addOption("", "-- " + UtilI18N.internacionaliza(request, "citcorpore.comum.todos") + " --");

		for (ReleaseRequestStatus status : ReleaseRequestStatus.values()) {
			comboIdStatus.addOption(status.getId().toString(), UtilI18N.internacionaliza(request, status.getI18NKey()));
		}
	}

	public void preencheSolicitacoesRelacionadas(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws ServiceException, Exception {
		usuario = WebUtil.getUsuario(request);

		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
			return;
		}

		PesquisaRequisicaoLiberacaoDTO pesquisaRequisicaoLiberacaoDto = (PesquisaRequisicaoLiberacaoDTO) document.getBean();

		RequisicaoLiberacaoService liberacaoService = (RequisicaoLiberacaoService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoService.class, null);
		List<RequisicaoLiberacaoDTO> listaRequisicaoLiberacaoPorCriterios = (List<RequisicaoLiberacaoDTO>) liberacaoService.listaRequisicaoLiberacaoPorCriterios(pesquisaRequisicaoLiberacaoDto);


		if (pesquisaRequisicaoLiberacaoDto.getDataInicio() == null) {
			pesquisaRequisicaoLiberacaoDto.setDataInicio(UtilDatas.strToSQLDate("01/01/1970"));
		}

		if (pesquisaRequisicaoLiberacaoDto.getDataFim() == null) {
			pesquisaRequisicaoLiberacaoDto.setDataFim(new java.sql.Date(UtilDatas.alteraData(UtilDatas.getDataAtual(), 365, Calendar.DAY_OF_YEAR).getTime()));
		}

		if (pesquisaRequisicaoLiberacaoDto.getDataInicioFechamento() == null) {
			pesquisaRequisicaoLiberacaoDto.setDataInicioFechamento(UtilDatas.strToSQLDate("01/01/1970"));
		}

		if (pesquisaRequisicaoLiberacaoDto.getDataFimFechamento() == null) {
			pesquisaRequisicaoLiberacaoDto.setDataFimFechamento(new java.sql.Date(UtilDatas.alteraData(UtilDatas.getDataAtual(), 365, Calendar.DAY_OF_YEAR).getTime()));
		}

		RequisicaoLiberacaoService requisicaoLiberacaoService = (RequisicaoLiberacaoService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoService.class, null);

		StringBuilder script = new StringBuilder();
		if (listaRequisicaoLiberacaoPorCriterios == null || listaRequisicaoLiberacaoPorCriterios.isEmpty()) {
                    document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.validacao.criterioinformado"));
                    document.getElementById("tblResumo").setInnerHTML(UtilI18N.internacionaliza(request, "citcorpore.comum.validacao.criterioinformado"));
		} else {
                    document.getElementById("tblResumo").setInnerHTML(montaHTMLResumoSolicitacoes(listaRequisicaoLiberacaoPorCriterios, script, request, response));
		}
		document.executeScript(script.toString());
		document.executeScript("temporizador.init()");
		document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();

	}

	private String montaHTMLResumoSolicitacoes(List<RequisicaoLiberacaoDTO> resumo, StringBuilder script, HttpServletRequest request, HttpServletResponse response) throws ServiceException, Exception {
		usuario = WebUtil.getUsuario(request);
		StringBuilder html = new StringBuilder();
		RequisicaoLiberacaoService requisicaoLiberacaoService = (RequisicaoLiberacaoService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoService.class, WebUtil.getUsuarioSistema(request));
		PermissoesFluxoService permissoesFluxoService = (PermissoesFluxoService) ServiceLocator.getInstance().getService(PermissoesFluxoService.class, null);
		EmpregadoService empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, null);
		GrupoService grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
		UsuarioService usuarioService = (UsuarioService) ServiceLocator.getInstance().getService(UsuarioService.class, null);
		ContratoServiceEjb contratoSerivce = new ContratoServiceEjb();

		html.append("<table class='table' id='tbRetorno' width='100%' style = 'font-size: 10px' >");
		html.append("<tr>");
		html.append("<th>&nbsp;</th>");
		html.append("<th>&nbsp;</th>");
		html.append("<th>&nbsp;</th>");
		html.append("<th>&nbsp;</th>");
		html.append("<th>" + UtilI18N.internacionaliza(request, "pesquisarequisicaoliberacao.numero") + "</th>");
		html.append("<th>" + UtilI18N.internacionaliza(request, "contrato.contrato") + "</th>");
		html.append("<th>" + UtilI18N.internacionaliza(request, "pesquisarequisicaoliberacao.solicitante") + "</th>");
		html.append("<th>" + UtilI18N.internacionaliza(request, "pesquisarequisicaoliberacao.dataCriacao") + "</th>");
		html.append("<th>" + UtilI18N.internacionaliza(request, "pesquisarequisicaoliberacao.prioridade") + "</th>");
		html.append("<th>" + UtilI18N.internacionaliza(request, "pesquisarequisicaoliberacao.situacao") + "</th>");
		html.append("<th>" + UtilI18N.internacionaliza(request, "pesquisarequisicaoliberacao.datainicial") + "</th>");
		html.append("<th>" + UtilI18N.internacionaliza(request, "pesquisarequisicaoliberacao.datalimite") + "</th>");
		html.append("<th>" + UtilI18N.internacionaliza(request, "pesquisarequisicaoliberacao.grupoexecutor") + "</th>");
		html.append("<th>" + UtilI18N.internacionaliza(request, "solicitacaoServico.fechamento") + "</th>");
		html.append("</tr>");
		HashMap<String, PermissoesFluxoDTO> mapPermissoes = new HashMap();
		for (RequisicaoLiberacaoDTO r : resumo) {

			RequisicaoLiberacaoDTO reqDto = new RequisicaoLiberacaoDTO();
			reqDto.setIdRequisicaoLiberacao(r.getIdRequisicaoLiberacao());

			FluxoDTO fluxoDto = requisicaoLiberacaoService.recuperaFluxo(reqDto);
			if (fluxoDto == null) {
				continue;
			}

			html.append("<tr>");
			html.append("<hidden id='idSolicitante' value='" + r.getIdSolicitante() + "'/>");
			html.append("<hidden id='idResponsavel' value='" + r.getIdResponsavel() + "'/>");

			PermissoesFluxoDTO permFluxoDto = mapPermissoes.get("" + fluxoDto.getIdFluxo());
			if (permFluxoDto == null) {
				permFluxoDto = permissoesFluxoService.findByUsuarioAndFluxo(usuario, fluxoDto);
				if (permFluxoDto != null) {
					mapPermissoes.put("" + fluxoDto.getIdFluxo(), permFluxoDto);
				}
			}
			html.append("<td><img src='" + br.com.citframework.util.Constantes.getValue("SERVER_ADDRESS") + br.com.citframework.util.Constantes.getValue("CONTEXTO_APLICACAO") + "/imagens/search.png' border='0' title='"
					+ UtilI18N.internacionaliza(request, "pesquisasolicitacao.consultasolicitacaoincidente") + "' onclick='consultarOcorrencias(\"" + r.getIdRequisicaoLiberacao() + "\")' style='cursor:pointer'/></td>");

			if (permFluxoDto != null && permFluxoDto.getReabrir() != null && permFluxoDto.getReabrir().equalsIgnoreCase("S")) {
				if (r.encerrada()) {
					html.append("<td><img src='" + br.com.citframework.util.Constantes.getValue("SERVER_ADDRESS") + br.com.citframework.util.Constantes.getValue("CONTEXTO_APLICACAO") + "/imagens/reabrir.jpg' border='0' title='"
							+ UtilI18N.internacionaliza(request, "pesquisasolicitacao.reabrirsol") + "' onclick='reabrir(\"" + r.getIdRequisicaoLiberacao() + "\")' style='cursor:pointer'/></td>");
				} else {
					html.append("<td>&nbsp;</td>");
				}
			} else {
				html.append("<td>&nbsp;</td>");
			}

			html.append("<td><a style='cursor:pointer' onclick='visualizarSolicitacao(" + reqDto.getIdRequisicaoLiberacao() + ")' >" + "" + UtilI18N.internacionaliza(request, "citcorpore.comum.visualizar") + "</a></td>");

			ControleGEDService controleGedService = (ControleGEDService) ServiceLocator.getInstance().getService(ControleGEDService.class, null);
			Collection colAnexos = controleGedService.listByIdTabelaAndID(ControleGEDDTO.TABELA_SOLICITACAOSERVICO, r.getIdRequisicaoLiberacao());

			if (colAnexos != null && !colAnexos.isEmpty()) {
				html.append("<td><img src='" + br.com.citframework.util.Constantes.getValue("SERVER_ADDRESS") + br.com.citframework.util.Constantes.getValue("CONTEXTO_APLICACAO")
						+ "/imagens/Paperclip4-black-32.png' width='16' height='16' border='0' title='" + UtilI18N.internacionaliza(request, "pesquisasolicitacao.visualizaranexos") + "' id='btAnexos' onclick='anexos(\""
						+ r.getIdRequisicaoLiberacao() + "\")' style='cursor:pointer'/></td>");
			} else {
				html.append(
						"<td><img src='" + br.com.citframework.util.Constantes.getValue("SERVER_ADDRESS") + br.com.citframework.util.Constantes.getValue("CONTEXTO_APLICACAO") + "/imagens/file.png' width='16' height='16' border='0' title='"
								+ UtilI18N.internacionaliza(request, "pesquisasolicitacao.visualizaranexos") + "' id='btAnexos' onclick='anexos(\"" + r.getIdRequisicaoLiberacao() + "\")' style='cursor:pointer'/></td>");
			}
			r.setNomeSolicitante(empregadoService.restoreByIdEmpregado(r.getIdSolicitante()).getNome());
			html.append("<td>" + r.getIdRequisicaoLiberacao() + "</td>");
			html.append("<td>" + contratoSerivce.montaNomeDoContratoParaGridDePesquisa(r.getIdContrato(), request) + "</td>");
			html.append("<td>" + r.getNomeSolicitante() + "</td>");
			html.append("<td>" + UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, r.getDataHoraCaptura(), WebUtil.getLanguage(request)) + "</td>");
			html.append("<td>" + r.getPrioridade() + "</td>");

			r.setDescrStatus(UtilI18N.internacionaliza(request, r.getDescrStatus()));

			html.append("<td>" + r.getDescrStatus() + "</td>");

			if (r.getDataHoraInicioAgendada() != null) {
				html.append("<td>" + UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, r.getDataHoraInicioAgendada(), WebUtil.getLanguage(request)) + "</td>");
			} else {
				html.append("<td>&nbsp;</td>");
			}
			if (r.getDataHoraTerminoAgendada() != null) {
				html.append("<td>" + UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, r.getDataHoraTerminoAgendada(), WebUtil.getLanguage(request)) + "</td>");
			} else {
				html.append("<td>&nbsp;</td>");
			}

			GrupoDTO grupoDTO = new GrupoDTO();
			grupoDTO.setIdGrupo(r.getIdGrupoAtual());

			String grupoAtual = ((GrupoDTO) grupoService.restore(grupoDTO)).getNome();
			html.append("<td>" + grupoAtual + "</td>");

			String fechamento = "&nbsp;";

			if (r.getFechamento() != null) {
				fechamento = r.getFechamento();
			}

			html.append("<td> " + fechamento + " </td>");

			html.append("</tr>");
		}
		html.append("</table>");
		return html.toString();
	}

	public void reabre(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws ServiceException, Exception {
		usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}
		PesquisaRequisicaoLiberacaoDTO pesquisaRequisicaoLiberacaoDto = (PesquisaRequisicaoLiberacaoDTO) document.getBean();
		RequisicaoLiberacaoDTO requisicaoLiberacaoDto = new RequisicaoLiberacaoDTO();
		RequisicaoLiberacaoService liberacaoService = (RequisicaoLiberacaoService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoService.class, null);
		if (pesquisaRequisicaoLiberacaoDto.getIdRequisicaoLiberacao() == null) {
			document.alert(UtilI18N.internacionaliza(request, "pesquisasolicitacao.informeReabrir"));
			return;
		} else {
			requisicaoLiberacaoDto.setIdRequisicaoLiberacao(pesquisaRequisicaoLiberacaoDto.getIdRequisicaoLiberacao());
			requisicaoLiberacaoDto = (RequisicaoLiberacaoDTO) liberacaoService.restore(requisicaoLiberacaoDto);
			liberacaoService.reabre(usuario, requisicaoLiberacaoDto);
		}

		document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.reaberta"));
		document.executeScript("filtrar()");
	}

	public void imprimirRelatorio(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HttpSession session = request.getSession();
		PesquisaRequisicaoLiberacaoDTO pesquisaRequisicaoLiberacaoDto = (PesquisaRequisicaoLiberacaoDTO) document.getBean();
		RequisicaoLiberacaoService requisicaoLiberacaoService = (RequisicaoLiberacaoService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoService.class, null);
		GrupoDTO grupoDto = new GrupoDTO();
		GrupoService grupoSegurancaService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
		OrigemAtendimentoDTO origemDto = new OrigemAtendimentoDTO();
		OrigemAtendimentoService origemAtendimentoService = (OrigemAtendimentoService) ServiceLocator.getInstance().getService(OrigemAtendimentoService.class, null);
		FaseServicoDTO faseDto = new FaseServicoDTO();
		FaseServicoService faseServicoService = (FaseServicoService) ServiceLocator.getInstance().getService(FaseServicoService.class, null);
		PrioridadeDTO prioridadeDto = new PrioridadeDTO();
		PrioridadeService prioridadeService = (PrioridadeService) ServiceLocator.getInstance().getService(PrioridadeService.class, null);
		ContratoDTO contratoDto = new ContratoDTO();
		ContratoService contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
		UsuarioDTO usuarioDto = new UsuarioDTO();
		UsuarioService usuarioService = (UsuarioService) ServiceLocator.getInstance().getService(UsuarioService.class, null);
		UnidadeDTO unidadeDto = new UnidadeDTO();
		UnidadeService unidadeService = (UnidadeService) ServiceLocator.getInstance().getService(UnidadeService.class, null);
		ContatoRequisicaoLiberacaoService contatoRequisicaoLiberacaoService = (ContatoRequisicaoLiberacaoService) ServiceLocator.getInstance().getService(ContatoRequisicaoLiberacaoService.class, null);

		usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
			return;
		}

		if (pesquisaRequisicaoLiberacaoDto.getDataInicio() == null) {
			pesquisaRequisicaoLiberacaoDto.setDataInicio(UtilDatas.strToSQLDate("01/01/1970"));
		}

		if (pesquisaRequisicaoLiberacaoDto.getDataFim() == null) {
			pesquisaRequisicaoLiberacaoDto.setDataFim(new java.sql.Date(UtilDatas.alteraData(UtilDatas.getDataAtual(), 365, Calendar.DAY_OF_YEAR).getTime()));
		}

		if (pesquisaRequisicaoLiberacaoDto.getDataInicioFechamento() == null) {
			pesquisaRequisicaoLiberacaoDto.setDataInicioFechamento(UtilDatas.strToSQLDate("01/01/1970"));
		} else {
			pesquisaRequisicaoLiberacaoDto.setIdStatus(ReleaseRequestStatus.CONCLUDED.getId());
		}

		if (pesquisaRequisicaoLiberacaoDto.getDataFimFechamento() == null) {
			pesquisaRequisicaoLiberacaoDto.setDataFimFechamento(new java.sql.Date(UtilDatas.alteraData(UtilDatas.getDataAtual(), 365, Calendar.DAY_OF_YEAR).getTime()));
		} else {
			pesquisaRequisicaoLiberacaoDto.setIdStatus(ReleaseRequestStatus.CONCLUDED.getId());
		}

		ArrayList<RequisicaoLiberacaoDTO> listaRequisicaoLiberacaoPorCriterios = (ArrayList<RequisicaoLiberacaoDTO>) requisicaoLiberacaoService.listaRequisicaoLiberacaoPorCriterios(pesquisaRequisicaoLiberacaoDto);

		for (RequisicaoLiberacaoDTO requisicaoLiberacaoDTO : listaRequisicaoLiberacaoPorCriterios) {
			requisicaoLiberacaoDTO.setDescrStatus(UtilI18N.internacionaliza(request, ReleaseRequestStatus.chaveFromId(requisicaoLiberacaoDTO.getIdStatus())));
		}

		if (listaRequisicaoLiberacaoPorCriterios == null || listaRequisicaoLiberacaoPorCriterios.size() == 0) {
			document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.relatorioVazio"));
			return;
		}

		Date dt = new Date();
		String strCompl = "" + dt.getTime();
		String caminhoJasper = CITCorporeUtil.CAMINHO_REAL_APP + Constantes.getValue("CAMINHO_RELATORIOS") + "RelatorioPesquisaRequisicaoLiberacao.jasper";
		String diretorioReceita = CITCorporeUtil.CAMINHO_REAL_APP + "/tempFiles";
		String diretorioRelativoOS = Constantes.getValue("SERVER_ADDRESS") + Constantes.getValue("CONTEXTO_APLICACAO") + "/tempFiles";

		Map<String, Object> parametros = new HashMap<String, Object>();
		parametros = UtilRelatorio.trataInternacionalizacaoLocale(session, parametros);

		parametros.put("TITULO_RELATORIO", UtilI18N.internacionaliza(request, "citcorporeRelatorio.comum.relatorioRequisicoesLiberacoes"));
		parametros.put("CIDADE", getCidadeParametrizada(request)+",");
		parametros.put("DATA_HORA", UtilDatas.getDataHoraAtual());
		parametros.put("NOME_USUARIO", usuario.getNomeUsuario());
		parametros.put("dataInicial", pesquisaRequisicaoLiberacaoDto.getDataInicio());
		parametros.put("dataFinal", pesquisaRequisicaoLiberacaoDto.getDataFim());
		parametros.put("exibirCampoDescricao", pesquisaRequisicaoLiberacaoDto.getExibirCampoDescricao());
		parametros.put("quantidade", listaRequisicaoLiberacaoPorCriterios.size());
		if (pesquisaRequisicaoLiberacaoDto.getNomeItemConfiguracao() != null && !pesquisaRequisicaoLiberacaoDto.getNomeItemConfiguracao().equalsIgnoreCase("")) {
			parametros.put("nomeItemConfiguracao", pesquisaRequisicaoLiberacaoDto.getNomeItemConfiguracao());
		} else {
			parametros.put("nomeItemConfiguracao", null);
		}
		if (!pesquisaRequisicaoLiberacaoDto.getNomeSolicitante().equalsIgnoreCase("")) {
			parametros.put("nomeSolicitante", pesquisaRequisicaoLiberacaoDto.getNomeSolicitante());
		} else {

			parametros.put("nomeSolicitante", null);
		}

		if (pesquisaRequisicaoLiberacaoDto.getIdTipoDemandaServico() != null) {
			ServiceDemandType tipoDemandaServico = ServiceDemandType.fromId(pesquisaRequisicaoLiberacaoDto.getIdTipoDemandaServico());
			String nomeTipoDemandaServico = null;
			if(tipoDemandaServico != null) {
				nomeTipoDemandaServico = UtilI18N.internacionaliza(request, tipoDemandaServico.getI18NKey());
				pesquisaRequisicaoLiberacaoDto.setNomeTipoDemandaServico(nomeTipoDemandaServico);
			}
			parametros.put("tipo", nomeTipoDemandaServico);
		} else {
			parametros.put("tipo", pesquisaRequisicaoLiberacaoDto.getNomeTipoDemandaServico());
		}
		if (pesquisaRequisicaoLiberacaoDto.getIdRequisicaoLiberacaoPesquisa() != null) {
			parametros.put("numero", pesquisaRequisicaoLiberacaoDto.getIdRequisicaoLiberacaoPesquisa());
		} else {
			parametros.put("numero", pesquisaRequisicaoLiberacaoDto.getIdRequisicaoLiberacaoPesquisa());
		}
		if (!UtilNumbersAndDecimals.isNullOrZeroOrEmpty(pesquisaRequisicaoLiberacaoDto.getIdStatus())) {
			parametros.put("situacao", UtilI18N.internacionaliza(request, pesquisaRequisicaoLiberacaoDto.getDescrStatus()));
		} else {
			parametros.put("situacao", null);
		}

		if (pesquisaRequisicaoLiberacaoDto.getIdGrupoAtual() != null) {
			grupoDto.setIdGrupo(pesquisaRequisicaoLiberacaoDto.getIdGrupoAtual());
			grupoDto = (GrupoDTO) grupoSegurancaService.restore(grupoDto);
			pesquisaRequisicaoLiberacaoDto.setGrupoAtual(grupoDto.getSigla());
			parametros.put("grupoSolucionador", pesquisaRequisicaoLiberacaoDto.getGrupoAtual());
		} else {
			parametros.put("grupoSolucionador", pesquisaRequisicaoLiberacaoDto.getGrupoAtual());
		}
		if (pesquisaRequisicaoLiberacaoDto.getIdOrigem() != null) {
			origemDto.setIdOrigem(pesquisaRequisicaoLiberacaoDto.getIdOrigem());
			origemDto = (OrigemAtendimentoDTO) origemAtendimentoService.restore(origemDto);
			pesquisaRequisicaoLiberacaoDto.setOrigem(origemDto.getDescricao());
			parametros.put("origem", pesquisaRequisicaoLiberacaoDto.getOrigem());
		} else {
			parametros.put("origem", pesquisaRequisicaoLiberacaoDto.getOrigem());
		}
		if (pesquisaRequisicaoLiberacaoDto.getIdFaseAtual() != null) {
			faseDto.setIdFase(pesquisaRequisicaoLiberacaoDto.getIdFaseAtual());
			faseDto = (FaseServicoDTO) faseServicoService.restore(faseDto);
			pesquisaRequisicaoLiberacaoDto.setFaseAtual(faseDto.getNomeFase());
			parametros.put("fase", pesquisaRequisicaoLiberacaoDto.getFaseAtual());
		} else {
			parametros.put("fase", pesquisaRequisicaoLiberacaoDto.getFaseAtual());
		}
		if (pesquisaRequisicaoLiberacaoDto.getIdPrioridade() != null) {
			prioridadeDto.setIdPrioridade(pesquisaRequisicaoLiberacaoDto.getIdPrioridade());
			prioridadeDto = (PrioridadeDTO) prioridadeService.restore(prioridadeDto);
			pesquisaRequisicaoLiberacaoDto.setPrioridade(prioridadeDto.getNomePrioridade());
			parametros.put("prioridade", pesquisaRequisicaoLiberacaoDto.getPrioridade());
		} else {
			parametros.put("prioridade", pesquisaRequisicaoLiberacaoDto.getPrioridade());
		}

		if (pesquisaRequisicaoLiberacaoDto.getIdContrato() != null) {
			contratoDto.setIdContrato(pesquisaRequisicaoLiberacaoDto.getIdContrato());
			contratoDto = (ContratoDTO) contratoService.restore(contratoDto);
			parametros.put("contrato", contratoDto.getNumero());
		} else {
			parametros.put("contrato", contratoDto.getNumero());
		}

		if (pesquisaRequisicaoLiberacaoDto.getNomeContato() != null) {

			parametros.put("nomeContato", pesquisaRequisicaoLiberacaoDto.getNomeContato());
		} else {
			parametros.put("nomeContato", null);
		}
		if (pesquisaRequisicaoLiberacaoDto.getIdUnidade() != null) {
			unidadeDto.setIdUnidade(pesquisaRequisicaoLiberacaoDto.getIdUnidade());
			unidadeDto = (UnidadeDTO) unidadeService.restore(unidadeDto);
			parametros.put("unidade", unidadeDto.getNome());
		} else {
			parametros.put("unidade", null);
		}


		try {
			JRDataSource dataSource = new JRBeanCollectionDataSource(listaRequisicaoLiberacaoPorCriterios);

			// Instancia o arquivo de swap, informando:
			// Diretorio,
			// Tamanho de cada bloco (4kb)
			// Numero mnimo de blocos que o swap ser aumentado sempre que
			// estiver cheio
			// JRSwapFile arquivoSwap = new JRSwapFile(diretorioReceita, 4096,
			// 25);

			// Instancia o virtualizador
			// JRAbstractLRUVirtualizer virtualizer = new
			// JRSwapFileVirtualizer(25, arquivoSwap, true);

			JRAbstractLRUVirtualizer virtualizer = new JRGzipVirtualizer(500);

			// Seta o parametro REPORT_VIRTUALIZER com a instncia da
			// virtualizao
			parametros.put(JRParameter.REPORT_VIRTUALIZER, virtualizer);

			// Preenche o relatrio e exibe numa GUI
			Timestamp ts1 = UtilDatas.getDataHoraAtual();
			JasperPrint jp = JasperFillManager.fillReport(caminhoJasper, parametros, dataSource);
			Timestamp ts2 = UtilDatas.getDataHoraAtual();
			double tempo = UtilDatas.calculaDiferencaTempoEmMilisegundos(ts2, ts1);
			System.out.println("########## Tempo fillReport: " + tempo);

			JasperExportManager.exportReportToPdfFile(jp, diretorioReceita + "/RelatorioRequisicaoLiberacao" + strCompl + "_" + usuario.getIdUsuario() + ".pdf");
			document.executeScript("window.open('" + Constantes.getValue("SERVER_ADDRESS") + Constantes.getValue("CONTEXTO_APLICACAO") + "/printPDF/printPDF.jsp?url=" + diretorioRelativoOS
					+ "/RelatorioRequisicaoLiberacao" + strCompl + "_" + usuario.getIdUsuario() + ".pdf')");
			// JasperViewer.viewReport(jp,false);

		} catch (OutOfMemoryError e) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.erro.erroServidor"));
		}
		/*
		 * JRDataSource dataSource = new JRBeanCollectionDataSource(listaSolicitacaoServicoPorCriterios);
		 *
		 * JasperPrint print = JasperFillManager.fillReport(caminhoJasper, parametros, dataSource); JasperExportManager.exportReportToPdfFile(print, diretorioReceita + "/RelatorioSolicitacaoServico" +
		 * strCompl + "_" + usuario.getIdUsuario() + ".pdf");
		 *
		 * document.executeScript("window.open('" + Constantes.getValue("SERVER_ADDRESS") + Constantes.getValue("CONTEXTO_APLICACAO") + "/printPDF/printPDF.jsp?url=" + diretorioRelativoOS +
		 * "/RelatorioSolicitacaoServico" + strCompl + "_" + usuario.getIdUsuario() + ".pdf')");
		 */
		document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();

	}

	public void imprimirRelatorioXls(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HttpSession session = request.getSession();
		PesquisaRequisicaoLiberacaoDTO pesquisaRequisicaoLiberacaoDto = (PesquisaRequisicaoLiberacaoDTO) document.getBean();
		RequisicaoLiberacaoService liberacaoService = (RequisicaoLiberacaoService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoService.class, null);
		GrupoDTO grupoDto = new GrupoDTO();
		GrupoService grupoSegurancaService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
		OrigemAtendimentoDTO origemDto = new OrigemAtendimentoDTO();
		OrigemAtendimentoService origemAtendimentoService = (OrigemAtendimentoService) ServiceLocator.getInstance().getService(OrigemAtendimentoService.class, null);
		FaseServicoDTO faseDto = new FaseServicoDTO();
		FaseServicoService faseServicoService = (FaseServicoService) ServiceLocator.getInstance().getService(FaseServicoService.class, null);
		PrioridadeDTO prioridadeDto = new PrioridadeDTO();
		PrioridadeService prioridadeService = (PrioridadeService) ServiceLocator.getInstance().getService(PrioridadeService.class, null);
		ContratoDTO contratoDto = new ContratoDTO();
		ContratoService contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
		UsuarioDTO usuarioDto = new UsuarioDTO();
		UsuarioService usuarioService = (UsuarioService) ServiceLocator.getInstance().getService(UsuarioService.class, null);
		UnidadeDTO unidadeDto = new UnidadeDTO();
		UnidadeService unidadeService = (UnidadeService) ServiceLocator.getInstance().getService(UnidadeService.class, null);

		usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
			return;
		}

		if (pesquisaRequisicaoLiberacaoDto.getDataInicio() == null) {
			pesquisaRequisicaoLiberacaoDto.setDataInicio(UtilDatas.strToSQLDate("01/01/1970"));
		}

		if (pesquisaRequisicaoLiberacaoDto.getDataFim() == null) {
			pesquisaRequisicaoLiberacaoDto.setDataFim(new java.sql.Date(UtilDatas.alteraData(UtilDatas.getDataAtual(), 365, Calendar.DAY_OF_YEAR).getTime()));
		}

		if (pesquisaRequisicaoLiberacaoDto.getDataInicioFechamento() == null) {
			pesquisaRequisicaoLiberacaoDto.setDataInicioFechamento(UtilDatas.strToSQLDate("01/01/1970"));
		}

		if (pesquisaRequisicaoLiberacaoDto.getDataFimFechamento() == null) {
			pesquisaRequisicaoLiberacaoDto.setDataFimFechamento(new java.sql.Date(UtilDatas.alteraData(UtilDatas.getDataAtual(), 365, Calendar.DAY_OF_YEAR).getTime()));
		}

		ArrayList<RequisicaoLiberacaoDTO> listaRequisicaoLiberacaoPorCriterios = (ArrayList<RequisicaoLiberacaoDTO>) liberacaoService.listaRequisicaoLiberacaoPorCriterios(pesquisaRequisicaoLiberacaoDto);

		for (RequisicaoLiberacaoDTO requisicaoLiberacaoDTO : listaRequisicaoLiberacaoPorCriterios) {
			requisicaoLiberacaoDTO.setDescrStatus(UtilI18N.internacionaliza(request, ReleaseRequestStatus.chaveFromId(requisicaoLiberacaoDTO.getIdStatus())));
		}

		if (listaRequisicaoLiberacaoPorCriterios == null || listaRequisicaoLiberacaoPorCriterios.size() == 0) {
			document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.relatorioVazio"));
			return;
		}

		Date dt = new Date();
		String strCompl = "" + dt.getTime();
		String caminhoJasper = CITCorporeUtil.CAMINHO_REAL_APP + Constantes.getValue("CAMINHO_RELATORIOS") + "RelatorioPesquisaRequisicaoLiberacaoXls.jasper";
		String diretorioReceita = CITCorporeUtil.CAMINHO_REAL_APP + "/tempFiles";
		String diretorioRelativoOS = Constantes.getValue("SERVER_ADDRESS") + Constantes.getValue("CONTEXTO_APLICACAO") + "/tempFiles";

		Map<String, Object> parametros = new HashMap<String, Object>();
		parametros = UtilRelatorio.trataInternacionalizacaoLocale(session, parametros);

		parametros.put("TITULO_RELATORIO", UtilI18N.internacionaliza(request, "citcorporeRelatorio.comum.relatorioRequisicoesLiberacoes"));
		parametros.put("CIDADE", getCidadeParametrizada(request)+",");
		parametros.put("DATA_HORA", UtilDatas.getDataHoraAtual());
		parametros.put("NOME_USUARIO", usuario.getNomeUsuario());
		parametros.put("dataInicio", pesquisaRequisicaoLiberacaoDto.getDataInicio());
		parametros.put("dataFim", pesquisaRequisicaoLiberacaoDto.getDataFim());
		parametros.put("exibirCampoDescricao", pesquisaRequisicaoLiberacaoDto.getExibirCampoDescricao());
		parametros.put("quantidade", listaRequisicaoLiberacaoPorCriterios.size());
		if (pesquisaRequisicaoLiberacaoDto.getNomeItemConfiguracao() != null && !pesquisaRequisicaoLiberacaoDto.getNomeItemConfiguracao().equalsIgnoreCase("")) {
			parametros.put("nomeItemConfiguracao", pesquisaRequisicaoLiberacaoDto.getNomeItemConfiguracao());
		} else {
		parametros.put("nomeItemConfiguracao", null);
		}
		if (!pesquisaRequisicaoLiberacaoDto.getNomeSolicitante().equalsIgnoreCase("")) {
			parametros.put("nomeSolicitante", pesquisaRequisicaoLiberacaoDto.getNomeSolicitante());
		} else {

			parametros.put("nomeSolicitante", null);
		}

		parametros.put("dataFim", pesquisaRequisicaoLiberacaoDto.getDataFim());
		if (pesquisaRequisicaoLiberacaoDto.getIdTipoDemandaServico() != null) {
			ServiceDemandType tipoDemandaServico = ServiceDemandType.fromId(pesquisaRequisicaoLiberacaoDto.getIdTipoDemandaServico());
			String nomeTipoDemandaServico = null;
			if(tipoDemandaServico != null) {
				nomeTipoDemandaServico = UtilI18N.internacionaliza(request, tipoDemandaServico.getI18NKey());
				pesquisaRequisicaoLiberacaoDto.setNomeTipoDemandaServico(nomeTipoDemandaServico);
			}
			parametros.put("tipo", nomeTipoDemandaServico);
		} else {
			parametros.put("tipo", pesquisaRequisicaoLiberacaoDto.getNomeTipoDemandaServico());
		}
		if (pesquisaRequisicaoLiberacaoDto.getIdRequisicaoLiberacaoPesquisa() != null) {
			parametros.put("numero", pesquisaRequisicaoLiberacaoDto.getIdRequisicaoLiberacaoPesquisa());
		} else {
			parametros.put("numero", pesquisaRequisicaoLiberacaoDto.getIdRequisicaoLiberacaoPesquisa());
		}
		if (!UtilNumbersAndDecimals.isNullOrZeroOrEmpty(pesquisaRequisicaoLiberacaoDto.getIdStatus())) {
			parametros.put("situacao", UtilI18N.internacionaliza(request, pesquisaRequisicaoLiberacaoDto.getDescrStatus()));
		} else {
			parametros.put("situacao", null);
		}

		if (pesquisaRequisicaoLiberacaoDto.getIdGrupoAtual() != null) {
			grupoDto.setIdGrupo(pesquisaRequisicaoLiberacaoDto.getIdGrupoAtual());
			grupoDto = (GrupoDTO) grupoSegurancaService.restore(grupoDto);
			pesquisaRequisicaoLiberacaoDto.setGrupoAtual(grupoDto.getSigla());
			parametros.put("grupoSolucionador", pesquisaRequisicaoLiberacaoDto.getGrupoAtual());
		} else {
			parametros.put("grupoSolucionador", pesquisaRequisicaoLiberacaoDto.getGrupoAtual());
		}
		if (pesquisaRequisicaoLiberacaoDto.getNomeContato() != null) {
			parametros.put("nomeContato", pesquisaRequisicaoLiberacaoDto.getNomeContato());
		} else {
			parametros.put("nomeContato", null);
		}
		if (pesquisaRequisicaoLiberacaoDto.getIdOrigem() != null) {
			origemDto.setIdOrigem(pesquisaRequisicaoLiberacaoDto.getIdOrigem());
			origemDto = (OrigemAtendimentoDTO) origemAtendimentoService.restore(origemDto);
			pesquisaRequisicaoLiberacaoDto.setOrigem(origemDto.getDescricao());
			parametros.put("origem", pesquisaRequisicaoLiberacaoDto.getOrigem());
		} else {
			parametros.put("origem", pesquisaRequisicaoLiberacaoDto.getOrigem());
		}
		if (pesquisaRequisicaoLiberacaoDto.getIdFaseAtual() != null) {
			faseDto.setIdFase(pesquisaRequisicaoLiberacaoDto.getIdFaseAtual());
			faseDto = (FaseServicoDTO) faseServicoService.restore(faseDto);
			pesquisaRequisicaoLiberacaoDto.setFaseAtual(faseDto.getNomeFase());
			parametros.put("fase", pesquisaRequisicaoLiberacaoDto.getFaseAtual());
		} else {
			parametros.put("fase", pesquisaRequisicaoLiberacaoDto.getFaseAtual());
		}
		if (pesquisaRequisicaoLiberacaoDto.getIdPrioridade() != null) {
			prioridadeDto.setIdPrioridade(pesquisaRequisicaoLiberacaoDto.getIdPrioridade());
			prioridadeDto = (PrioridadeDTO) prioridadeService.restore(prioridadeDto);
			pesquisaRequisicaoLiberacaoDto.setPrioridade(prioridadeDto.getNomePrioridade());
			parametros.put("prioridade", pesquisaRequisicaoLiberacaoDto.getPrioridade());
		} else {
			parametros.put("prioridade", pesquisaRequisicaoLiberacaoDto.getPrioridade());
		}

		if (pesquisaRequisicaoLiberacaoDto.getIdContrato() != null) {
			contratoDto.setIdContrato(pesquisaRequisicaoLiberacaoDto.getIdContrato());
			contratoDto = (ContratoDTO) contratoService.restore(contratoDto);
			parametros.put("contrato", contratoDto.getNumero());
		} else {
			parametros.put("contrato", contratoDto.getNumero());
		}

		if (pesquisaRequisicaoLiberacaoDto.getIdResponsavel() != null) {
			usuarioDto.setIdUsuario(pesquisaRequisicaoLiberacaoDto.getIdResponsavel());
			usuarioDto = (UsuarioDTO) usuarioService.restore(usuarioDto);
			parametros.put("responsavel", usuarioDto.getNomeUsuario());
		} else {
			parametros.put("responsavel", null);
		}
		if (pesquisaRequisicaoLiberacaoDto.getIdUnidade() != null) {
			unidadeDto.setIdUnidade(pesquisaRequisicaoLiberacaoDto.getIdUnidade());
			unidadeDto = (UnidadeDTO) unidadeService.restore(unidadeDto);
			parametros.put("unidade", unidadeDto.getNome());
		} else {
			parametros.put("unidade", null);
		}

		try {
			JRDataSource dataSource = new JRBeanCollectionDataSource(listaRequisicaoLiberacaoPorCriterios);

			JasperDesign desenho = JRXmlLoader.load(CITCorporeUtil.CAMINHO_REAL_APP + Constantes.getValue("CAMINHO_RELATORIOS") + "RelatorioPesquisaRequisicaoLiberacaoXls.jrxml");

			JasperReport relatorio = JasperCompileManager.compileReport(desenho);

			JasperPrint impressao = JasperFillManager.fillReport(relatorio, parametros, dataSource);

			JRXlsExporter exporter = new JRXlsExporter();
			exporter.setParameter(JRXlsExporterParameter.JASPER_PRINT, impressao);
			exporter.setParameter(JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, Boolean.TRUE);
			exporter.setParameter(JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, Boolean.TRUE);
			exporter.setParameter(JRXlsExporterParameter.OUTPUT_FILE_NAME, diretorioReceita + "/RelatorioPesquisaSolicitacaoServicoXls" + strCompl + "_" + usuario.getIdUsuario() + ".xls");

			exporter.exportReport();

			document.executeScript("window.open('" + Constantes.getValue("SERVER_ADDRESS") + Constantes.getValue("CONTEXTO_APLICACAO") + "/printPDF/printPDF.jsp?url=" + diretorioRelativoOS
					+ "/RelatorioPesquisaSolicitacaoServicoXls" + strCompl + "_" + usuario.getIdUsuario() + ".xls')");
		} catch (OutOfMemoryError e) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.erro.erroServidor"));
		}
		document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();

	}

	public void restoreUpload(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws ServiceException, Exception {

		request.getSession(true).setAttribute("colUploadsGED", null);
		/* Realida o refresh do iframe */
		document.executeScript("document.getElementById('fraUpload_uploadAnexos').contentWindow.location.reload(true)");

		usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}
		PesquisaRequisicaoLiberacaoDTO pesquisaRequisicaoLiberacaoDto = (PesquisaRequisicaoLiberacaoDTO) document.getBean();

		if (pesquisaRequisicaoLiberacaoDto.getIdRequisicaoLiberacao() == null) {
			return;
		}
		ControleGEDService controleGedService = (ControleGEDService) ServiceLocator.getInstance().getService(ControleGEDService.class, null);
		Collection colAnexos = controleGedService.listByIdTabelaAndID(ControleGEDDTO.TABELA_REQUISICAOLIBERACAO, pesquisaRequisicaoLiberacaoDto.getIdRequisicaoLiberacao());
		Collection colAnexosUploadDTO = controleGedService.convertListControleGEDToUploadDTO(colAnexos);

		request.getSession(true).setAttribute("colUploadsGED", colAnexosUploadDTO);
		document.executeScript("$('#POPUP_menuAnexos').dialog('open');");
	}

}