package br.com.centralit.citcorpore.ajaxForms;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;

import com.google.gson.Gson;

import br.com.centralit.bpm.dto.PermissoesFluxoDTO;
import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.ContratoDTO;
import br.com.centralit.citcorpore.bean.EmpregadoDTO;
import br.com.centralit.citcorpore.bean.FaseServicoDTO;
import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaSolicitacaoDTO;
import br.com.centralit.citcorpore.bean.OrigemAtendimentoDTO;
import br.com.centralit.citcorpore.bean.PesquisaSolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.PrioridadeDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.UnidadeDTO;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.negocio.CalendarioService;
import br.com.centralit.citcorpore.negocio.ContratoService;
import br.com.centralit.citcorpore.negocio.EmpregadoService;
import br.com.centralit.citcorpore.negocio.FaseServicoService;
import br.com.centralit.citcorpore.negocio.GrupoService;
import br.com.centralit.citcorpore.negocio.OcorrenciaSolicitacaoService;
import br.com.centralit.citcorpore.negocio.OrigemAtendimentoService;
import br.com.centralit.citcorpore.negocio.PermissoesFluxoService;
import br.com.centralit.citcorpore.negocio.PrioridadeService;
import br.com.centralit.citcorpore.negocio.ServicoContratoService;
import br.com.centralit.citcorpore.negocio.ServicoService;
import br.com.centralit.citcorpore.negocio.SolicitacaoServicoService;
import br.com.centralit.citcorpore.negocio.UnidadeService;
import br.com.centralit.citcorpore.negocio.UsuarioService;
import br.com.centralit.citcorpore.util.Arvore;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.Enumerados.ServiceDemandType;
import br.com.centralit.citcorpore.util.Enumerados.ServiceRequestStatus;
import br.com.centralit.citcorpore.util.Enumerados.TipoAcordoContrato;
import br.com.centralit.citcorpore.util.Enumerados.TipoCatalogoServico;
import br.com.centralit.citcorpore.util.Enumerados.TipoDate;
import br.com.centralit.citcorpore.util.LogoRel;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.UtilRelatorio;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.centralit.citged.bean.ControleGEDDTO;
import br.com.centralit.citged.negocio.ControleGEDService;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;
import br.com.citframework.util.UtilStrings;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.fill.JRAbstractLRUVirtualizer;
import net.sf.jasperreports.engine.fill.JRGzipVirtualizer;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsxReportConfiguration;
import net.sf.jasperreports.export.XlsxReportConfiguration;

public class PesquisaSolicitacoesServicos extends AjaxFormAction {

	private ContratoService contratoService;
	private SolicitacaoServicoService solicitacaoServicoService;
	private PermissoesFluxoService permissoesFluxoService;
	private ServicoContratoService servicoContratoService;
	private ServicoService servicoService;
	private CalendarioService calendarioService;

	private UsuarioDTO usuario;

	@Override
	public Class<PesquisaSolicitacaoServicoDTO> getBeanClass() {
		return PesquisaSolicitacaoServicoDTO.class;
	}

	@Override
	public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		usuario = WebUtil.getUsuario(request);

		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		document.getSelectById("idContrato").removeAllOptions();
		final ContratoService contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
		final Collection<ContratoDTO> colContrato = contratoService.list();
		document.getSelectById("idContrato").addOption("", "-- " + UtilI18N.internacionaliza(request, "citcorpore.comum.todos") + " --");
		document.getSelectById("idContrato").addOptions(colContrato, "idContrato", "numero", null);

		document.getSelectById("idPrioridade").removeAllOptions();
		final PrioridadeService prioridadeService = (PrioridadeService) ServiceLocator.getInstance().getService(PrioridadeService.class, null);
		final Collection<PrioridadeDTO> col = prioridadeService.list();
		document.getSelectById("idPrioridade").addOption("", "-- " + UtilI18N.internacionaliza(request, "citcorpore.comum.todos") + " --");
		document.getSelectById("idPrioridade").addOptions(col, "idPrioridade", "nomePrioridade", null);

		document.getSelectById("idGrupoAtual").removeAllOptions();
		final GrupoService grupoSegurancaService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
		final Collection<GrupoDTO> colGrupos = grupoSegurancaService.findGruposAtivos();
		document.getSelectById("idGrupoAtual").addOption("", "-- " + UtilI18N.internacionaliza(request, "citcorpore.comum.todos") + " --");
		document.getSelectById("idGrupoAtual").addOptions(colGrupos, "idGrupo", "nome", null);

		document.getSelectById("idFaseAtual").removeAllOptions();
		final FaseServicoService faseServicoService = (FaseServicoService) ServiceLocator.getInstance().getService(FaseServicoService.class, null);
		final Collection<FaseServicoDTO> colFases = faseServicoService.list();
		Enumerados.FaseServicoFluxo faseServico;
		if (colFases != null) {
			for (FaseServicoDTO faseServicoDTO : colFases){
					if(faseServicoDTO!=null && faseServicoDTO.getNomeFase()!=null){
						faseServico = Enumerados.FaseServicoFluxo.fromIdentificador(faseServicoDTO.getNomeFase());
					if (faseServico != null) {
						faseServicoDTO.setNomeFase(UtilI18N.internacionaliza(request, faseServico.getChave()));
					}
			}
		}
		}
		document.getSelectById("idFaseAtual").addOption("", "-- " + UtilI18N.internacionaliza(request, "citcorpore.comum.todos") + " --");
		document.getSelectById("idFaseAtual").addOptions(colFases, "idFase", "nomeFase", null);

		document.getSelectById("idOrigem").removeAllOptions();
		final OrigemAtendimentoService origemAtendimentoService = (OrigemAtendimentoService) ServiceLocator.getInstance().getService(OrigemAtendimentoService.class, null);
		final Collection<OrigemAtendimentoDTO> colOrigem = origemAtendimentoService.list();
		document.getSelectById("idOrigem").addOption("", "-- " + UtilI18N.internacionaliza(request, "citcorpore.comum.todos") + " --");
		document.getSelectById("idOrigem").addOptions(colOrigem, "idOrigem", "descricao", null);

		ServiceLocator.getInstance().getService(UnidadeService.class, null);
		final String UNIDADE_AUTOCOMPLETE = ParametroUtil.getValorParametroCitSmartHashMap(br.com.centralit.citcorpore.util.Enumerados.ParametroSistema.UNIDADE_AUTOCOMPLETE, "N");
		StringBuilder objeto;

		if (UNIDADE_AUTOCOMPLETE != null && UNIDADE_AUTOCOMPLETE.equalsIgnoreCase("S")) {
			objeto = new StringBuilder();
			objeto.append("<input type='text' name='unidadeDes' id='unidadeDes' style='width: 100%;' onkeydown='onkeypressUnidadeDes();' onfocus='montaParametrosAutocompleteUnidade();' class='span12'>");
			objeto.append("<input type='hidden' name='idUnidade' id='idUnidade' value='0'/>");
			document.getElementById("divUnidade").setInnerHTML(objeto.toString());
			document.executeScript("montaParametrosAutocompleteUnidade()");
		} else {
			objeto = new StringBuilder();
			objeto.append("<select  class='span12' name='idUnidade' id='idUnidade'></select>");
			document.getElementById("divUnidade").setInnerHTML(objeto.toString());
			this.preencherComboUnidade(document, request, response);
		}

		this.limpaRegistrosDaPesquisa(document);

		this.carregarComboTipoCatalogoServicoSolicitacao(document, request);

		this.carregarComboTipoDemanda(document, request);

		this.carregarComboIdStatus(document, request);
	}

	/**
	 * @author rodrigo.guilherme
	 * @since 04.12.2015
	 */
	private void carregarComboTipoCatalogoServicoSolicitacao(final DocumentHTML document, final HttpServletRequest request) throws ServiceException, Exception {
		final HTMLSelect idTipoCatalogoServicoSolicitacao = document.getSelectById("idTipoCatalogoServicoSolicitacao");
		idTipoCatalogoServicoSolicitacao.setDisabled(false);
		idTipoCatalogoServicoSolicitacao.removeAllOptions();
		idTipoCatalogoServicoSolicitacao.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

		for(TipoCatalogoServico tipoCatalogoServico : TipoCatalogoServico.values()) {
			idTipoCatalogoServicoSolicitacao.addOption(tipoCatalogoServico.getIdentificador(), UtilI18N.internacionaliza(request, tipoCatalogoServico.getChave()));
		}

		verificaTipoDeAcordoDoContrato(document, request, null);
	}

	/**
	 * @author douglas.japiassu
	 * @since 10.05.2016
	 */
	private void carregarComboIdStatus(final DocumentHTML document, final HttpServletRequest request) throws ServiceException, Exception {
		final HTMLSelect idStatus = document.getSelectById("idStatus");
		idStatus.setDisabled(false);
		idStatus.removeAllOptions();
		idStatus.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

		for (ServiceRequestStatus requestStatus : ServiceRequestStatus.values()) {
			idStatus.addOption(requestStatus.getId().toString(), UtilI18N.internacionaliza(request, requestStatus.getI18NKey()));
		}
	}

	/**
	 * Carrega Combo de Tipo Demanda Servio.
	 *
	 * @param document
	 * @param request
	 * @throws ServiceException
	 * @throws Exception
	 * @author valdoilo.damasceno
	 * @since 03.11.2013
	 */
	private void carregarComboTipoDemanda(final DocumentHTML document, final HttpServletRequest request) throws ServiceException, Exception {
		final HTMLSelect idTipoDemandaServico = document.getSelectById("idTipoDemandaServico");
		idTipoDemandaServico.removeAllOptions();
		idTipoDemandaServico.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

		for (ServiceDemandType serviceDemandType : ServiceDemandType.valuesWithoutOS()) {
			idTipoDemandaServico.addOption(String.valueOf(serviceDemandType.getId()), UtilI18N.internacionaliza(request, serviceDemandType.getI18NKey()));
		}
	}

	/**
	 * De acordo com o Contrato selecionado, a combo ser setada.
	 *
	 * @author rodrigo.guilherme
	 */
	public void verificaTipoDeAcordoDoContrato(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final PesquisaSolicitacaoServicoDTO pesquisaSolicitacaoServicoDto = (PesquisaSolicitacaoServicoDTO) document.getBean();

		final HTMLSelect idTipoCatalogoServicoSolicitacao = document.getSelectById("idTipoCatalogoServicoSolicitacao");

		if (pesquisaSolicitacaoServicoDto.getIdContrato() != null) {
			ContratoDTO contrato = new ContratoDTO();
			contrato.setIdContrato(pesquisaSolicitacaoServicoDto.getIdContrato());

			contrato = getContratoService().restore(contrato);

			if (contrato != null) {

				if (TipoAcordoContrato.CONTRATO.getIdentificador().equalsIgnoreCase(contrato.getTipo())) {
					idTipoCatalogoServicoSolicitacao.setValue(TipoCatalogoServico.SERVICO_NEGOCIO.getIdentificador());
				} else {
					idTipoCatalogoServicoSolicitacao.setValue(TipoCatalogoServico.SERVICO_TECNICO.getIdentificador());
				}

				idTipoCatalogoServicoSolicitacao.setDisabled(true);
			}else{
				idTipoCatalogoServicoSolicitacao.setValue("");
				idTipoCatalogoServicoSolicitacao.setDisabled(false);
			}
		}else{
			idTipoCatalogoServicoSolicitacao.setValue("");
			idTipoCatalogoServicoSolicitacao.setDisabled(false);
		}
	}

	/**
	 * Mtodo de paginao para um mais eficiente.
	 *
	 * @since 11/12/2014
	 * @author thyen.chang
	 */
	public void preencheSolicitacoesRelacionadas(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {

		usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
			return;
		}

		request.getRequestURI();
		String paginacao;

		final PesquisaSolicitacaoServicoDTO pesquisaSolicitacaoServicoDto = (PesquisaSolicitacaoServicoDTO) document.getBean();

		if (request.getParameter("paginacao") != null && !request.getParameter("paginacao").equals("")) {
			paginacao = UtilStrings.decodeCaracteresEspeciais(request.getParameter("paginacao"));
		} else {
			paginacao = "0";
		}

		Integer pagAtual;
		if (pesquisaSolicitacaoServicoDto.getTotalItens().intValue()>0){
			final Integer quantidadeItensPorPagina = pesquisaSolicitacaoServicoDto.getTotalItensPorPagina();
			pagAtual = pesquisaSolicitacaoServicoDto.getPagAtual();

			// Definindo qual ser a pgina que ser aberta
			switch (paginacao) {
			case "-1" : 						//=>Registro anterior
				pagAtual = pagAtual - 1;
				if (pagAtual<=0){
					pagAtual = 1;
				}
				break;
			case "1": // =>Prximo registro
				pagAtual = pagAtual + 1;
				if (pagAtual>pesquisaSolicitacaoServicoDto.getTotalPagina()){
					pagAtual = pesquisaSolicitacaoServicoDto.getTotalPagina();
				}
				break;
			case "2": // =>ltimo registro
				pagAtual = pesquisaSolicitacaoServicoDto.getTotalPagina();
				break;
			default:							//paginacao="0" ou qualquer valor => Primeiro registro
				pagAtual = 1;
				break;
			}

			final SolicitacaoServicoService solicitacaoService = (SolicitacaoServicoService) ServiceLocator.getInstance().getService(SolicitacaoServicoService.class, null);

			// Passamos o usurio para que o sistema possa obter os IDs das unidades
			// que ele pode acessar!
			pesquisaSolicitacaoServicoDto.setUsuarioLogado(usuario);

			final ArrayList<SolicitacaoServicoDTO> listaSolicitacaoServicoPorCriterios = (ArrayList<SolicitacaoServicoDTO>) solicitacaoService.listPesquisaAvancadaPaginada(pesquisaSolicitacaoServicoDto, pagAtual, quantidadeItensPorPagina);

			if (listaSolicitacaoServicoPorCriterios != null) {
				document.getElementById("tblResumo").setInnerHTML(this.geraHtmlTabela(listaSolicitacaoServicoPorCriterios, request));
			} else {
				document.getElementById("tblResumo").setInnerHTML(UtilI18N.internacionaliza(request, "citcorpore.comum.validacao.criterioinformado"));
			}
		} else {
			pagAtual = 0;
			document.getElementById("tblResumo").setInnerHTML(UtilI18N.internacionaliza(request, "citcorpore.comum.validacao.criterioinformado"));
		}

		document.getElementById("paginaAtual").setInnerHTML(pagAtual.toString());
		document.getElementById("pagAtual").setValue(pagAtual.toString());

		document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();

	}

	public void setNumeroPaginas(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {

		final PesquisaSolicitacaoServicoDTO pesquisaSolicitacaoServicoDto = (PesquisaSolicitacaoServicoDTO) document.getBean();

		final SolicitacaoServicoService solicitacaoService = (SolicitacaoServicoService) ServiceLocator.getInstance().getService(SolicitacaoServicoService.class, null);

		Integer noTotalItens, noTotalPaginas, quantidadePorPagina, paginaAtual;

		// Passamos o usurio para que o sistema possa obter os IDs das unidades que ele pode acessar!
		pesquisaSolicitacaoServicoDto.setUsuarioLogado(WebUtil.getUsuario(request));

		final String origemBusca = request.getParameter("origemSolicitacao");

		final boolean isDetalhado = origemBusca.equals("pdfdetalhado")||origemBusca.equals("xlsdetalhado");

		noTotalItens = solicitacaoService.listaRelatorioGetQuantidadeRegistros(pesquisaSolicitacaoServicoDto, isDetalhado).intValue();

		if (noTotalItens.intValue()>0){
			paginaAtual = 1;
			quantidadePorPagina = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANT_RETORNO_PESQUISA, "5"));
			noTotalPaginas = (int) Math.ceil(noTotalItens.doubleValue() / quantidadePorPagina.doubleValue());
		} else {
			paginaAtual = 0;
			quantidadePorPagina = 0;
			noTotalPaginas = 0;
		}

		document.getElementById("paginacao").setValue("0");
		document.getElementById("pagAtual").setValue(paginaAtual.toString());
		document.getElementById("paginaAtual").setInnerHTML(paginaAtual.toString());
        document.getElementById("paginaTotal").setInnerHTML(noTotalPaginas.toString());
        document.getElementById("totalPagina").setValue(noTotalPaginas.toString());
        document.getElementById("totalItens").setValue(noTotalItens.toString());
        document.getElementById("totalItensPorPagina").setValue(quantidadePorPagina.toString());

			switch (request.getParameter("origemSolicitacao")) {
			case "pesquisa":
				document.executeScript("executaPesquisa('pesquisa');");
				break;
			case "pdf":
				document.executeScript("executaPesquisa('pdf');");
				break;
			case "xls":
				document.executeScript("executaPesquisa('xls');");
				break;
			case "pdfdetalhado":
				document.executeScript("executaPesquisa('pdfdetalhado');");
				break;
			case "xlsdetalhado":
				document.executeScript("executaPesquisa('xlsdetalhado');");
				break;
			}
		}

	private String geraHtmlTabela(final ArrayList<SolicitacaoServicoDTO> solicitacoes, final HttpServletRequest request) throws ServiceException, Exception {
		StringBuilder sb = new StringBuilder();

		sb.append(geraHtmlCabecalhoTabela(request));

		for(SolicitacaoServicoDTO solicitacaoDto : solicitacoes){
			sb.append(geraHtmlDadosTabela(solicitacaoDto, solicitacaoDto.getPermissoesFluxoDTO(), request));
		}

		sb.append(geraHTMLFinalTabela());

		return sb.toString();
	}

	private String geraHtmlCabecalhoTabela(HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		sb.append("<div class='row-fluid' id='tabelaSolicitacoes'> ");
		sb.append("	<div class=\"table-responsive tabela\">");
		sb.append("		<table class=\"table table-bordered table-striped table-condensed table-vertical-center checkboxs js-table-sortable ui-sortable \" > ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th style=\"text-align: center;\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.acoes") + "</th> ");
		sb.append("					<th style=\"width: 1%; text-align: center;\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.id") + "</th> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "servico.servico"));
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "solicitacaoServico.requisicaoIncidente") + "</th>");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.tipo") + "</th>");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "solicitacaoServico.solicitante") + "</th>");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.criador") + "</th>");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "solicitacaoServico.datahoraabertura") + "</th>");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "tempoAtendimento.descResumidoTA") + "</th>");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "solicitacaoServico.descricao") + "</th>");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "solicitacaoServico.solucaoResposta") + "</th>");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "solicitacaoServico.situacao") + "</th>");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "solicitacaoServico.datahoralimite") + "</th>");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "unidade.grupo") + "</th>");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "solicitacaoServico.datahoraencerramento") + "</th>");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "solicitacaoServico.temporestante") + "</th>");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "solicitacaoServico.responsavelatual.desc"));
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody> ");

		return sb.toString();
	}

	private String geraHtmlDadosTabela(SolicitacaoServicoDTO solicitacaoDto, PermissoesFluxoDTO permFluxoDto, HttpServletRequest request){
		StringBuilder sb = new StringBuilder();

		String idTarefaStr = "null";
		if (solicitacaoDto.getIdTarefa() != null) {
			idTarefaStr = solicitacaoDto.getIdTarefa().toString();
		}

		sb.append("	<tr> ");
		sb.append("		<td > ");
		sb.append("			<div style=\"width:70px;\" class=\"btn-group btn-block w15 aLeft dropdown span11\"> ");
		sb.append("				<div class=\"leadcontainer\" data-toggle=\"dropdown\"> ");
		sb.append("					<button type=\"button\" class=\"btn dropdown-lead btn-default\">" + UtilI18N.internacionaliza(request, "solicitacaoServico.acao") + "</button>");
		sb.append("				</div> ");
		sb.append("				<a class=\"btn btn-default dropdown-toggle solicitacoes-toggle\" data-toggle=\"dropdown\"><span class=\"caret\"></span> </a> ");
		sb.append("				<ul class=\"dropdown-menu pull-left\"> ");
		sb.append("					<li style=\"width: 100%; cursor: pointer;\" onclick=\"consultarOcorrencias(" + solicitacaoDto.getIdSolicitacaoServico() + ")\"><a>"
				+ UtilI18N.internacionaliza(request, "pesquisasolicitacao.consultasolicitacaoincidente") + "</a></li> ");
		sb.append("					<li style=\"width: 100%; cursor: pointer;\" onclick=\"visualizarSolicitacao(" + solicitacaoDto.getIdSolicitacaoServico() + ", " + idTarefaStr + ")\"><a>"
				+ UtilI18N.internacionaliza(request, "pesquisasolicitacao.visualizarRequisicaoIncidente") + "</a></li> ");
		sb.append("					<li style=\"width: 100%; cursor: pointer;\" onclick=\"anexos(" + solicitacaoDto.getIdSolicitacaoServico() + ")\"><a>" + UtilI18N.internacionaliza(request, "pesquisasolicitacao.visualizaranexos")
				+ "</a></li> ");

		if (permFluxoDto != null && permFluxoDto.getReabrir() != null && permFluxoDto.getReabrir().equalsIgnoreCase("S")) {
			if (solicitacaoDto.encerrada()) {
				sb.append("			<li style=\"width: 100%; cursor: pointer;\" onclick=\"reabrir(" + idTarefaStr + ", " + solicitacaoDto.getIdSolicitacaoServico() + ")\"><a>"
						+ UtilI18N.internacionaliza(request, "pesquisasolicitacao.reabrirsol")
						+ "</a></li> ");
			}
		}

		if (solicitacaoDto.getIdSolicitacaoPai() != null) {
			sb.append("				<li style=\"width: 100%; cursor: pointer;\" onclick=\"visualizarSolicitacaoPrincipal(").append(solicitacaoDto.getIdSolicitacaoPai()).append(")\"><a>");
			sb.append(UtilI18N.internacionaliza(request, "pesquisasolicitacao.visualizarRequisicaoIncidentePrincipal")).append("</a></li> ");
		}

		sb.append("				</ul> ");
		sb.append("			</div>");
		sb.append("		</td> ");

		sb.append("		<td>" + solicitacaoDto.getIdSolicitacaoServico() + "</td>");

		if (solicitacaoDto.getNomeServicoRelacionado() != null) {
			sb.append("<td>" + solicitacaoDto.getNomeServicoRelacionado() + "</td>");
		} else {
			sb.append("<td>&nbsp;</td>");
		}

		sb.append("		<td>" + solicitacaoDto.getNomeServico().replace(".", ". ") + "</td>");
		sb.append("		<td>" + UtilI18N.internacionaliza(request, ServiceDemandType.chaveFromId(solicitacaoDto.getIdTipoDemandaServico())) + "</td>");
		sb.append("		<td>" + solicitacaoDto.getNomeSolicitante() + "</td>");
		sb.append("		<td>" + solicitacaoDto.getResponsavel() + "</td>");

		if (solicitacaoDto.getSeqReabertura() == null || solicitacaoDto.getSeqReabertura().intValue() == 0) {
			sb.append("	<td>" + UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, solicitacaoDto.getDataHoraSolicitacao(), WebUtil.getLanguage(request)) + "</td>");
		} else {
			sb.append("	<td>" + UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, solicitacaoDto.getDataHoraSolicitacao(), WebUtil.getLanguage(request)) + "<br>"
					+ UtilI18N.internacionaliza(request, "solicitacaoServico.seqreabertura") + ": <span style='color:red'><b>" + solicitacaoDto.getSeqReabertura() + "</b></span></td>");
		}

		final boolean slaACombinar = (solicitacaoDto.getPrazoHH() == null || solicitacaoDto.getPrazoHH() == 0) && (solicitacaoDto.getPrazoMM() == null || solicitacaoDto.getPrazoMM() == 0);
		if (slaACombinar) {
			sb.append("	<td>" + UtilI18N.internacionaliza(request, "citcorpore.comum.aCombinar") + "</td>");
		} else {
			String hh = solicitacaoDto.getPrazoHH().toString();
			String mm = solicitacaoDto.getPrazoMM().toString();
				if(Integer.parseInt(mm) > 59){
					hh = String.valueOf(Integer.parseInt(hh) + Integer.parseInt(mm) / 60);
					mm = String.valueOf(Integer.parseInt(mm) % 60);
				}
				if (mm.length() == 1) {
					mm = "0" + mm;
				}
			sb.append("<td>" + hh + ":" + mm + "</td>");
			}

		sb.append("		<td>" + UtilStrings.nullToVazio(UtilStrings.unescapeJavaString(solicitacaoDto.getDescricaoSemFormatacao())) + "</td>");
		sb.append("		<td>" + UtilStrings.nullToVazio(UtilStrings.unescapeJavaString(solicitacaoDto.getResposta())) + "</td>");

		sb.append("		<td>" + solicitacaoDto.obterSituacaoInternacionalizada(request) + "</td>");

		if (solicitacaoDto.getDataHoraLimite() != null && !slaACombinar) {
			sb.append("	<td>" + UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, solicitacaoDto.getDataHoraLimite(), WebUtil.getLanguage(request)) + "</td>");
		} else {
			sb.append("	<td>&nbsp;</td>");
		}

		sb.append("		<td>" + UtilStrings.nullToVazio(solicitacaoDto.getSiglaGrupo()) + "</td>");

		if (solicitacaoDto.getDataHoraFim() != null) {
			sb.append("<td>" + UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, solicitacaoDto.getDataHoraFim(), WebUtil.getLanguage(request)) + "</td>");
		} else {
			sb.append("	<td>&nbsp;</td>");
		}

		sb.append("<td><label id='tempoRestante" + solicitacaoDto.getIdSolicitacaoServico() + "'></label><div id='barraProgresso" + solicitacaoDto.getIdSolicitacaoServico() + "'></div></td>");

		if (solicitacaoDto.getResponsavelAtual() != null) {
			sb.append("<td>" + solicitacaoDto.getResponsavelAtual() + "</td>");
		} else {
			sb.append("<td>&nbsp;</td>");
		}

		sb.append("	</tr> ");

		return sb.toString();
	}

	private String geraHTMLFinalTabela() {
		StringBuilder sb = new StringBuilder();
		sb.append("			</tbody> ");
		sb.append("		</table>");
		sb.append("	</div>");
		sb.append("</div>");

		return sb.toString();
	}

	public void reabre(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}
		final PesquisaSolicitacaoServicoDTO pesquisaSolicitacaoServicoDto = (PesquisaSolicitacaoServicoDTO) document.getBean();
		SolicitacaoServicoDTO solicitacaoServicoDto = new SolicitacaoServicoDTO();
		final SolicitacaoServicoService solicitacaoService = (SolicitacaoServicoService) ServiceLocator.getInstance().getService(SolicitacaoServicoService.class, null);
		if (pesquisaSolicitacaoServicoDto.getIdSolicitacaoServico() == null) {
			document.alert(UtilI18N.internacionaliza(request, "pesquisasolicitacao.informeReabrir"));
			return;
		} else {
			solicitacaoServicoDto.setIdSolicitacaoServico(pesquisaSolicitacaoServicoDto.getIdSolicitacaoServico());
			solicitacaoServicoDto = (SolicitacaoServicoDTO) solicitacaoService.restore(solicitacaoServicoDto);
			solicitacaoServicoDto.setUsuarioDto(usuario);

			int numDias;
			int numDiasParametro;
			boolean permiteReabrir = false;

			try {
				numDias = 0;
				Date data = solicitacaoServicoDto.getDataHoraFim();

				do {
					if (this.getCalendarioService().isBusinessDay(solicitacaoServicoDto.getIdCalendario(), data)) {
						numDias++;
					}
					data = UtilDatas.getProximoDia(data);
				}while (data.compareTo(UtilDatas.getDataAtual()) < 1);

				numDiasParametro = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.DIAS_LIMITE_REABERTURA_INCIDENTE_REQUISICAO, null));

				if (numDias <= numDiasParametro) {
					permiteReabrir = true;
				}
			} catch (final NumberFormatException ne) {
				document.alert(UtilI18N.internacionaliza(request, "pesquisasolicitacao.prazoReaberturaNaoConfigurado"));
				return;
			}

			if (!permiteReabrir) {
				document.alert(UtilI18N.internacionaliza(request, "pesquisasolicitacao.prazoReaberturaExcedido"));
				return;
			} else {
				boolean validaContrato = this.getServicoContratoService().validaContratoServico(solicitacaoServicoDto.getIdServicoContrato());
				if (validaContrato) {
					solicitacaoServicoDto.setIdTarefa(pesquisaSolicitacaoServicoDto.getIdTarefa());
					solicitacaoService.reabre(usuario, solicitacaoServicoDto);
				} else {
					document.alert(UtilI18N.internacionaliza(request, "pesquisasolicitacao.contratoFechadoInvalido"));
					return;
				}
			}
		}

		document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.reaberta"));
		document.executeScript("filtrar()");
	}

	public void verificaServicoAtivoSolicitacao(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}
		final PesquisaSolicitacaoServicoDTO pesquisaSolicitacaoServicoDto = (PesquisaSolicitacaoServicoDTO) document.getBean();
		final ServicoContratoService servicoContratoService = (ServicoContratoService) ServiceLocator.getInstance().getService(ServicoContratoService.class, null);
		if (pesquisaSolicitacaoServicoDto.getIdSolicitacaoServico() == null) {
			document.alert(UtilI18N.internacionaliza(request, "pesquisasolicitacao.informeReabrir"));
			return;
		} else {
			final boolean seServicoAtivo = servicoContratoService.verificaServicoEstaVinculadoContrato(pesquisaSolicitacaoServicoDto.getIdSolicitacaoServico());
			if (!seServicoAtivo) {
				document.executeScript("verificaServico(" + pesquisaSolicitacaoServicoDto.getIdTarefa() + ", '" + pesquisaSolicitacaoServicoDto.getIdSolicitacaoServico() + "')");
			} else {
				this.reabre(document, request, response);
			}
		}

	}

	/**
	 * alterado por rcs - Analista Desenvolvedor <a href="rafael.soyer@centralit.com.br">rafael.soyer@centralit.com.br</a>
	 * data alterao rcs: 02/10/2015
	 * comentrio alterao rcs: modularizao de cdigo.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	public void imprimirRelatorio(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		usuario = WebUtil.getUsuario(request);

		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
			return;
		}

		final PesquisaSolicitacaoServicoDTO pesquisaSolicitacaoServicoDto = (PesquisaSolicitacaoServicoDTO) document.getBean();

		if (!Objects.equals(pesquisaSolicitacaoServicoDto, null)) {
			final SolicitacaoServicoService solicitacaoService = (SolicitacaoServicoService) ServiceLocator.getInstance().getService(SolicitacaoServicoService.class, null);
			pesquisaSolicitacaoServicoDto.setUsuarioLogado(usuario);// Passamos o usurio para que o sistema possa obter os IDs das unidades que ele pode acessar!

			ArrayList<SolicitacaoServicoDTO> listaSolicitacaoServicoPorCriterios = (ArrayList<SolicitacaoServicoDTO>) solicitacaoService.listPesquisaAvancadaRelatorio(pesquisaSolicitacaoServicoDto);

			if (CollectionUtils.isEmpty(listaSolicitacaoServicoPorCriterios)) {
				document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.relatorioVazio"));
			} else {

				if (!ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANTIDADE_REGISTROS_PESQUISA_AVANCADA, "-1").equals("-1")
						&& listaSolicitacaoServicoPorCriterios.size() > Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANTIDADE_REGISTROS_PESQUISA_AVANCADA, "0"))) {
					document.alert(UtilI18N.internacionaliza(request, "citcorporeRelatorio.comum.registroMaiorPermitido"));
					document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
					return;
				}

				final StringBuilder sb_podeReceberVariosValores = new StringBuilder();
				this.trataCamposDasSolicitacoesParaImprimirRelatorio(pesquisaSolicitacaoServicoDto, listaSolicitacaoServicoPorCriterios, request);
				Map<String, Object> parametros = new HashMap<>();
				parametros = UtilRelatorio.trataInternacionalizacaoLocale(request.getSession(), parametros);
				this.putParametrosParaImprimirRelatorio(parametros, pesquisaSolicitacaoServicoDto, request, listaSolicitacaoServicoPorCriterios.size());

				sb_podeReceberVariosValores.append(CITCorporeUtil.CAMINHO_REAL_APP);
				sb_podeReceberVariosValores.append(Constantes.getValue("CAMINHO_RELATORIOS"));
				sb_podeReceberVariosValores.append("RelatorioPesquisaSolicitacaoServico.jrxml");
				final String caminhoRelatorio = sb_podeReceberVariosValores.toString();

				sb_podeReceberVariosValores.setLength(0);
				sb_podeReceberVariosValores.append(CITCorporeUtil.CAMINHO_REAL_APP);
				sb_podeReceberVariosValores.append("/tempFiles");
				final String diretorioReceita = sb_podeReceberVariosValores.toString();

				sb_podeReceberVariosValores.setLength(0);
				sb_podeReceberVariosValores.append(Constantes.getValue("SERVER_ADDRESS"));
				sb_podeReceberVariosValores.append(Constantes.getValue("CONTEXTO_APLICACAO"));
				sb_podeReceberVariosValores.append("/tempFiles");
				final String diretorioRelativoOS = sb_podeReceberVariosValores.toString();

				sb_podeReceberVariosValores.setLength(0);
				final String strCompl = sb_podeReceberVariosValores.append(new Date().getTime()).toString();

				final Timestamp ts1 = UtilDatas.getDataHoraAtual();

				try {
					JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(listaSolicitacaoServicoPorCriterios);
					final JasperDesign desenho = JRXmlLoader.load(caminhoRelatorio);
					desenho.setLanguage("java");
					final JasperReport relatorio = JasperCompileManager.compileReport(desenho);
					final JasperPrint jp = JasperFillManager.fillReport(relatorio, parametros, dataSource);
					final Timestamp ts2 = UtilDatas.getDataHoraAtual();
					final double tempo = UtilDatas.calculaDiferencaTempoEmMilisegundos(ts2, ts1);

					sb_podeReceberVariosValores.setLength(0);
					sb_podeReceberVariosValores.append("########## Tempo fillReport: ");
					sb_podeReceberVariosValores.append(tempo);
					System.out.println(sb_podeReceberVariosValores.toString());

					sb_podeReceberVariosValores.setLength(0);
					sb_podeReceberVariosValores.append(diretorioReceita);
					sb_podeReceberVariosValores.append("/RelatorioSolicitacaoServico");
					sb_podeReceberVariosValores.append(strCompl);
					sb_podeReceberVariosValores.append("_");
					sb_podeReceberVariosValores.append(usuario.getIdUsuario());
					sb_podeReceberVariosValores.append(".pdf");
					JasperExportManager.exportReportToPdfFile(jp, sb_podeReceberVariosValores.toString());

					sb_podeReceberVariosValores.setLength(0);
					sb_podeReceberVariosValores.append("window.open('");
					sb_podeReceberVariosValores.append(Constantes.getValue("SERVER_ADDRESS"));
					sb_podeReceberVariosValores.append(Constantes.getValue("CONTEXTO_APLICACAO"));
					sb_podeReceberVariosValores.append("/printPDF/printPDF.jsp?url=");
					sb_podeReceberVariosValores.append(diretorioRelativoOS);
					sb_podeReceberVariosValores.append("/RelatorioSolicitacaoServico");
					sb_podeReceberVariosValores.append(strCompl);
					sb_podeReceberVariosValores.append("_");
					sb_podeReceberVariosValores.append(usuario.getIdUsuario());
					sb_podeReceberVariosValores.append(".pdf')");
					document.executeScript(sb_podeReceberVariosValores.toString());
				} catch (JRException jRExc) {
					jRExc.printStackTrace();
				} catch (final OutOfMemoryError e) {
					/*
					 * Desenvolvedor: Thiago Matias - Data: 30/10/2013 - Horrio: 15h35min - ID Citsmart: 122665 - Motivo/Comentrio: alterando o a chave de citcorpore.erro.memoria para
					 * citsmart.erro.memoria
					 */
					e.printStackTrace();
					document.alert(UtilI18N.internacionaliza(request, "citsmart.erro.memoria"));
				} catch (Exception exc) {
					exc.printStackTrace();
				}
			}
		}

		document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
		this.limpaRegistrosDaPesquisa(document);
	}

	final private void putParametrosParaImprimirRelatorio(final Map<String, Object> parametros, final PesquisaSolicitacaoServicoDTO pesquisaSolicitacaoServicoDto, final HttpServletRequest request, final int qtdSolicitacoes)
			throws Exception {

		if (!Objects.equals(pesquisaSolicitacaoServicoDto, null) && !Objects.equals(parametros, null)) {
			UsuarioDTO usuarioDto = new UsuarioDTO();
			final UsuarioService usuarioService = (UsuarioService) ServiceLocator.getInstance().getService(UsuarioService.class, null);

			parametros.put("TITULO_RELATORIO", UtilI18N.internacionaliza(request, "citcorporeRelatorio.pesquisaSolicitacoesServicos"));
			parametros.put("CIDADE", getCidadeParametrizada(request));
			parametros.put("DATA_HORA", UtilDatas.getDataHoraAtual());
			parametros.put("NOME_USUARIO", usuario.getNomeUsuario());
			parametros.put("dataInicio", pesquisaSolicitacaoServicoDto.getDataInicio() == null ? pesquisaSolicitacaoServicoDto.getDataInicioFechamento() : pesquisaSolicitacaoServicoDto.getDataInicio());
			parametros.put("dataFim", pesquisaSolicitacaoServicoDto.getDataFim() == null ? pesquisaSolicitacaoServicoDto.getDataFimFechamento() : pesquisaSolicitacaoServicoDto.getDataFim());
			parametros.put("Logo", LogoRel.getFile());
			parametros.put("exibirCampoDescricao", pesquisaSolicitacaoServicoDto.getExibirCampoDescricao());
			parametros.put("quantidade", qtdSolicitacoes);
			parametros.put("criado_por", UtilI18N.internacionaliza(request, "citcorpore.comum.criadopor") + ":");

			if (StringUtils.isNotBlank(pesquisaSolicitacaoServicoDto.getNomeItemConfiguracao())) {
				parametros.put("nomeItemConfiguracao", pesquisaSolicitacaoServicoDto.getNomeItemConfiguracao());
			} else {
				parametros.put("nomeItemConfiguracao", null);
			}

			if (StringUtils.isNotBlank(pesquisaSolicitacaoServicoDto.getNomeSolicitante())) {
				parametros.put("nomeSolicitante", pesquisaSolicitacaoServicoDto.getNomeSolicitante());
			} else {
				parametros.put("nomeSolicitante", null);
			}

			if (pesquisaSolicitacaoServicoDto.getIdTipoDemandaServico() != null) {
				ServiceDemandType tipoDemandaServico = ServiceDemandType.fromId(pesquisaSolicitacaoServicoDto.getIdTipoDemandaServico());
				String nomeTipoDemandaServico = null;
				if(tipoDemandaServico != null) {
					nomeTipoDemandaServico = UtilI18N.internacionaliza(request, tipoDemandaServico.getI18NKey());
					pesquisaSolicitacaoServicoDto.setNomeTipoDemandaServico(nomeTipoDemandaServico);
				}
				parametros.put("tipo", nomeTipoDemandaServico);
			} else {
				parametros.put("tipo", pesquisaSolicitacaoServicoDto.getNomeTipoDemandaServico());
			}

			if (pesquisaSolicitacaoServicoDto.getIdSolicitacaoServicoPesquisa() != null) {
				parametros.put("numero", pesquisaSolicitacaoServicoDto.getIdSolicitacaoServicoPesquisa());
			} else {
				parametros.put("numero", pesquisaSolicitacaoServicoDto.getIdSolicitacaoServicoPesquisa());
			}

			if (!UtilNumbersAndDecimals.nullToVazio(pesquisaSolicitacaoServicoDto.getIdStatus()).isEmpty()) {
				parametros.put("situacao", pesquisaSolicitacaoServicoDto.recuperaSituacaoInternacionalizada(request));
			} else {
				parametros.put("situacao", null);
			}

			if (pesquisaSolicitacaoServicoDto.getIdGrupoAtual() != null) {
				GrupoDTO grupoDto = new GrupoDTO();
				final GrupoService grupoSegurancaService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
				grupoDto.setIdGrupo(pesquisaSolicitacaoServicoDto.getIdGrupoAtual());
				grupoDto = (GrupoDTO) grupoSegurancaService.restore(grupoDto);
				pesquisaSolicitacaoServicoDto.setGrupoAtual(grupoDto.getSigla());
				parametros.put("grupoSolucionador", pesquisaSolicitacaoServicoDto.getGrupoAtual());
			} else {
				parametros.put("grupoSolucionador", pesquisaSolicitacaoServicoDto.getGrupoAtual());
			}

			if (pesquisaSolicitacaoServicoDto.getIdOrigem() != null) {
				OrigemAtendimentoDTO origemDto = new OrigemAtendimentoDTO();
				final OrigemAtendimentoService origemAtendimentoService = (OrigemAtendimentoService) ServiceLocator.getInstance().getService(OrigemAtendimentoService.class, null);
				origemDto.setIdOrigem(pesquisaSolicitacaoServicoDto.getIdOrigem());
				origemDto = (OrigemAtendimentoDTO) origemAtendimentoService.restore(origemDto);
				pesquisaSolicitacaoServicoDto.setOrigem(UtilStrings.unescapeJavaString(origemDto.getDescricao()));
				parametros.put("origem", pesquisaSolicitacaoServicoDto.getOrigem());
			} else {
				parametros.put("origem", pesquisaSolicitacaoServicoDto.getOrigem());
			}

			if (pesquisaSolicitacaoServicoDto.getIdFaseAtual() != null) {
				FaseServicoDTO faseDto = new FaseServicoDTO();
				final FaseServicoService faseServicoService = (FaseServicoService) ServiceLocator.getInstance().getService(FaseServicoService.class, null);
				faseDto.setIdFase(pesquisaSolicitacaoServicoDto.getIdFaseAtual());
				faseDto = (FaseServicoDTO) faseServicoService.restore(faseDto);
				pesquisaSolicitacaoServicoDto.setFaseAtual(faseDto.getNomeFase());
				parametros.put("fase", pesquisaSolicitacaoServicoDto.getFaseAtual());
			} else {
				parametros.put("fase", pesquisaSolicitacaoServicoDto.getFaseAtual());
			}

			if (pesquisaSolicitacaoServicoDto.getIdPrioridade() != null) {
				PrioridadeDTO prioridadeDto = new PrioridadeDTO();
				final PrioridadeService prioridadeService = (PrioridadeService) ServiceLocator.getInstance().getService(PrioridadeService.class, null);
				prioridadeDto.setIdPrioridade(pesquisaSolicitacaoServicoDto.getIdPrioridade());
				prioridadeDto = (PrioridadeDTO) prioridadeService.restore(prioridadeDto);
				pesquisaSolicitacaoServicoDto.setPrioridade(prioridadeDto.getNomePrioridade());
				parametros.put("prioridade", pesquisaSolicitacaoServicoDto.getPrioridade());
			} else {
				parametros.put("prioridade", pesquisaSolicitacaoServicoDto.getPrioridade());
			}

			if (pesquisaSolicitacaoServicoDto.getIdContrato() != null) {
				ContratoDTO contratoDto = new ContratoDTO();
				final ContratoService contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
				contratoDto.setIdContrato(pesquisaSolicitacaoServicoDto.getIdContrato());
				contratoDto = (ContratoDTO) contratoService.restore(contratoDto);
				parametros.put("contrato", contratoDto.getNumero());
			} else {
				parametros.put("contrato", null);
			}

			if (pesquisaSolicitacaoServicoDto.getIdResponsavel() != null) {
				usuarioDto.setIdUsuario(pesquisaSolicitacaoServicoDto.getIdResponsavel());
				usuarioDto = (UsuarioDTO) usuarioService.restore(usuarioDto);
				parametros.put("responsavel", usuarioDto.getNomeUsuario());
			} else {
				parametros.put("responsavel", null);
			}

			if (pesquisaSolicitacaoServicoDto.getIdUsuarioResponsavelAtual() != null) {
				usuarioDto.setIdUsuario(pesquisaSolicitacaoServicoDto.getIdUsuarioResponsavelAtual());
				usuarioDto = (UsuarioDTO) usuarioService.restore(usuarioDto);
				parametros.put("nomeUsuarioResponsavelAtual", usuarioDto.getNomeUsuario());
			} else {
				parametros.put("nomeUsuarioResponsavelAtual", null);
			}

			if (pesquisaSolicitacaoServicoDto.getIdUnidade() != null) {
				UnidadeDTO unidadeDto = new UnidadeDTO();
				final UnidadeService unidadeService = (UnidadeService) ServiceLocator.getInstance().getService(UnidadeService.class, null);
				unidadeDto.setIdUnidade(pesquisaSolicitacaoServicoDto.getIdUnidade());
				unidadeDto = (UnidadeDTO) unidadeService.restore(unidadeDto);

				if (unidadeDto != null && StringUtils.isNotBlank(unidadeDto.getNome())) {
					parametros.put("unidade", unidadeDto.getNome());
				} else {
					parametros.put("unidade", null);
				}
			} else {
				parametros.put("unidade", null);
			}

			if(pesquisaSolicitacaoServicoDto.getIdTipoCatalogoServicoSolicitacao() != null){
				if(pesquisaSolicitacaoServicoDto.getIdTipoCatalogoServicoSolicitacao().equalsIgnoreCase("N")){
					parametros.put("catalogo", UtilI18N.internacionaliza(request, "solicitacaoServico.filtros.catalogoServicoNegocio"));
				}
				if(pesquisaSolicitacaoServicoDto.getIdTipoCatalogoServicoSolicitacao().equalsIgnoreCase("A")){
					parametros.put("catalogo", UtilI18N.internacionaliza(request, "solicitacaoServico.filtros.catalogoServicoTecnico"));
				}
			}

			if(pesquisaSolicitacaoServicoDto.getIdServicoRelacionado() != null){
				ServicoDTO servicoDto = new ServicoDTO();
				servicoDto.setIdServico(pesquisaSolicitacaoServicoDto.getIdServicoRelacionado());
				servicoDto = this.getServicoService().restore(servicoDto);
				parametros.put("servicoRelacionadoNome", servicoDto.getNomeServico());
			}

			if(pesquisaSolicitacaoServicoDto.getIdTipoDemandaServico() != null){
				if(pesquisaSolicitacaoServicoDto.getIdTipoDemandaServico() == 1) {
					parametros.put("tipoDemandaServico", "Request");
				}
				if(pesquisaSolicitacaoServicoDto.getIdTipoDemandaServico() == 3) {
					parametros.put("tipoDemandaServico", "Procedure");
				}
				if(pesquisaSolicitacaoServicoDto.getIdTipoDemandaServico() == 4) {
					parametros.put("tipoDemandaServico", "Incident");
				}
			}

			if(pesquisaSolicitacaoServicoDto.getIdServico() != null){
				ServicoDTO servicoDto = new ServicoDTO();
				servicoDto.setIdServico(pesquisaSolicitacaoServicoDto.getIdServico());
				servicoDto = this.getServicoService().restore(servicoDto);
				parametros.put("servicoNome", servicoDto.getNomeServico());
			}




			parametros.put("nomeTarefaString", UtilI18N.internacionaliza(request, "citcorporeRelatorio.comum.nomeTarefa"));
			parametros.put(JRParameter.REPORT_VIRTUALIZER, new JRGzipVirtualizer(50));// Seta o parametro REPORT_VIRTUALIZER com a instncia da virtualizao
		}
	}

	final private void trataCamposDasSolicitacoesParaImprimirRelatorio(final PesquisaSolicitacaoServicoDTO pesquisaSolicitacaoServicoDto, final ArrayList<SolicitacaoServicoDTO> listaSolicitacaoServicoPorCriterios,
			final HttpServletRequest request) {
		if (!Objects.equals(pesquisaSolicitacaoServicoDto, null) && CollectionUtils.isNotEmpty(listaSolicitacaoServicoPorCriterios)) {
			boolean nomeUsuarioRespAtualNotBlank = StringUtils.isNotBlank(pesquisaSolicitacaoServicoDto.getNomeUsuarioResponsavelAtual());

			for (final SolicitacaoServicoDTO solicitacaoServico : listaSolicitacaoServicoPorCriterios) {

				String resposta = tratarRespostaSolicitacao(solicitacaoServico);
				solicitacaoServico.setResposta(UtilStrings.unescapeJavaString(resposta));

				if ((solicitacaoServico.getPrazoHH() == null || solicitacaoServico.getPrazoHH() == 0) && (solicitacaoServico.getPrazoMM() == null || solicitacaoServico.getPrazoMM() == 0)) {
					solicitacaoServico.setSlaACombinar("S");
				} else {
					String mm = solicitacaoServico.getPrazoMM().toString();
					String hh = solicitacaoServico.getPrazoHH().toString();
					if(Integer.parseInt(mm) > 59){
						hh = String.valueOf(Integer.parseInt(hh) + Integer.parseInt(mm) / 60);
						mm = String.valueOf(Integer.parseInt(mm) % 60);
					}
					if (mm.length() == 1) {
						mm = "0" + mm;
					}
					solicitacaoServico.setPrazoMM(Integer.parseInt(mm));
					solicitacaoServico.setPrazoHH(Integer.parseInt(hh));
					solicitacaoServico.setSlaACombinar("N");
				}
				String descricaoSemFormatacao = tratarDescricaoSemFormatacao(solicitacaoServico);
				solicitacaoServico.setDescricaoSemFormatacao(UtilStrings.unescapeJavaString(descricaoSemFormatacao));
				solicitacaoServico.setDescricao(UtilStrings.unescapeJavaString(solicitacaoServico.getDescricao()));

				if (nomeUsuarioRespAtualNotBlank) {
					solicitacaoServico.setNomeUsuarioResponsavelAtual(pesquisaSolicitacaoServicoDto.getNomeUsuarioResponsavelAtual());
				}

				if (StringUtils.isBlank(solicitacaoServico.getResponsavelAtual())) {
					solicitacaoServico.setResponsavelAtual(UtilI18N.internacionaliza(request, "citcorporeRelatorio.comum.semResponsavelAtual"));
				}

				if (StringUtils.isBlank(solicitacaoServico.getNomeTarefa())) {
					solicitacaoServico.setNomeTarefa(UtilI18N.internacionaliza(request, "citcorpore.comum.naoInformado"));
				}

				if(solicitacaoServico!= null && solicitacaoServico.getDescrSituacao()!=null) {
					solicitacaoServico.setDescrSituacao(UtilI18N.internacionaliza(request, solicitacaoServico.getDescrSituacao()));
				}

			}
		}
    }

	public void imprimirRelatorioXlsDetalhado(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final HttpSession session = request.getSession();
		final PesquisaSolicitacaoServicoDTO pesquisaSolicitacaoServicoDto = (PesquisaSolicitacaoServicoDTO) document.getBean();
		final SolicitacaoServicoService solicitacaoService = (SolicitacaoServicoService) ServiceLocator.getInstance().getService(SolicitacaoServicoService.class, null);
		GrupoDTO grupoDto = new GrupoDTO();
		final GrupoService grupoSegurancaService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
		OrigemAtendimentoDTO origemDto = new OrigemAtendimentoDTO();
		final OrigemAtendimentoService origemAtendimentoService = (OrigemAtendimentoService) ServiceLocator.getInstance().getService(OrigemAtendimentoService.class, null);
		FaseServicoDTO faseDto = new FaseServicoDTO();
		final FaseServicoService faseServicoService = (FaseServicoService) ServiceLocator.getInstance().getService(FaseServicoService.class, null);
		PrioridadeDTO prioridadeDto = new PrioridadeDTO();
		final PrioridadeService prioridadeService = (PrioridadeService) ServiceLocator.getInstance().getService(PrioridadeService.class, null);
		ContratoDTO contratoDto = new ContratoDTO();
		final ContratoService contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
		UsuarioDTO usuarioDto = new UsuarioDTO();
		final UsuarioService usuarioService = (UsuarioService) ServiceLocator.getInstance().getService(UsuarioService.class, null);
		UnidadeDTO unidadeDto = new UnidadeDTO();
		final UnidadeService unidadeService = (UnidadeService) ServiceLocator.getInstance().getService(UnidadeService.class, null);

		usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
			return;
		}

		// Passamos o usurio para que o sistema possa obter os IDs das unidades que ele pode acessar!
		pesquisaSolicitacaoServicoDto.setUsuarioLogado(usuario);

		final ArrayList<SolicitacaoServicoDTO> listaSolicitacaoServicoPorCriterios = (ArrayList<SolicitacaoServicoDTO>) solicitacaoService.listPesquisaAvancadaRelatorioDetalhado(pesquisaSolicitacaoServicoDto);

		if (listaSolicitacaoServicoPorCriterios == null || listaSolicitacaoServicoPorCriterios.size() == 0) {
			document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.relatorioVazio"));
			return;
		}

		if (!ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANTIDADE_REGISTROS_PESQUISA_AVANCADA, "-1").equals("-1")
				&& listaSolicitacaoServicoPorCriterios.size() > Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANTIDADE_REGISTROS_PESQUISA_AVANCADA, "0"))) {
			document.alert(UtilI18N.internacionaliza(request, "citcorporeRelatorio.comum.registroMaiorPermitido"));
			document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
			return;
		}

		for (final SolicitacaoServicoDTO solicitacaoServico : listaSolicitacaoServicoPorCriterios) {
			String resposta = UtilStrings.unescapeJavaString(solicitacaoServico.getResposta());
			if (resposta != null && resposta.length() > 1500) {
				resposta = resposta.substring(0, 1500);
			}
			solicitacaoServico.setResposta(UtilStrings.unescapeJavaString(resposta));
			if ((solicitacaoServico.getPrazoHH() == null || solicitacaoServico.getPrazoHH() == 0) && (solicitacaoServico.getPrazoMM() == null || solicitacaoServico.getPrazoMM() == 0)) {
				solicitacaoServico.setSlaACombinar("S");
			} else {
				solicitacaoServico.setSlaACombinar("N");
			}

			String descricaoSemFormatacao = tratarDescricaoSemFormatacao(solicitacaoServico);
			solicitacaoServico.setDescricaoSemFormatacao(UtilStrings.unescapeJavaString(descricaoSemFormatacao));
			solicitacaoServico.setDescricao(UtilStrings.unescapeJavaString(solicitacaoServico.getDescricao()));

			if (pesquisaSolicitacaoServicoDto.getNomeUsuarioResponsavelAtual() != null) {
				solicitacaoServico.setNomeUsuarioResponsavelAtual(pesquisaSolicitacaoServicoDto.getNomeUsuarioResponsavelAtual());
			}

			/**
			 * Cria SLA para solicitacao
			 *
			 * @author thyen.chang
			 */
			if (solicitacaoServico != null && solicitacaoServico.getPrazoHH() != null && solicitacaoServico.getPrazoMM() != null) {
				solicitacaoServico.setSla((solicitacaoServico.getPrazoHH() < 10 ? "0" + solicitacaoServico.getPrazoHH().toString() : solicitacaoServico.getPrazoHH().toString()) + ":"
						+ (solicitacaoServico.getPrazoMM() < 10 ? "0" + solicitacaoServico.getPrazoMM().toString() : solicitacaoServico.getPrazoMM().toString()));
			} else {
				solicitacaoServico.setSla("");
			}

			/**
			 * Determina localidade caso no exista
			 *
			 * @author thyen.chang
			 */
			if (solicitacaoServico != null && (solicitacaoServico.getLocalidade() == null || solicitacaoServico.getLocalidade().equals(""))) {
				solicitacaoServico.setLocalidade(UtilI18N.internacionaliza(request, "citcorpore.comum.naoInformado"));
			}

			/**
			 * Determina responsvel caso no exista
			 *
			 * @author thyen.chang
			 */
			if (solicitacaoServico != null && solicitacaoServico.getResponsavelAtual() == null) {
				solicitacaoServico.setResponsavelAtual(UtilI18N.internacionaliza(request, "citcorporeRelatorio.comum.semResponsavelAtual"));
			}

			if (solicitacaoServico != null && solicitacaoServico.getNomeTarefa() == null) {
				solicitacaoServico.setNomeTarefa(UtilI18N.internacionaliza(request, "citcorpore.comum.naoInformado"));
			}

			if (solicitacaoServico != null && solicitacaoServico.getResposta() != null) {
				solicitacaoServico.setResposta(formataCaracteresInvlidos(solicitacaoServico.getResposta()));
			}

			if(solicitacaoServico!= null && solicitacaoServico.getDescrSituacao()!=null) {
				solicitacaoServico.setDescrSituacao(UtilI18N.internacionaliza(request, solicitacaoServico.getDescrSituacao()));
			}
		}

		final Date dt = new Date();
		final String strCompl = "" + dt.getTime();
		final String diretorioReceita = CITCorporeUtil.CAMINHO_REAL_APP + "/tempFiles";
		final String diretorioRelativoOS = Constantes.getValue("SERVER_ADDRESS") + Constantes.getValue("CONTEXTO_APLICACAO") + "/tempFiles";

		Map<String, Object> parametros = new HashMap<>();
		parametros = UtilRelatorio.trataInternacionalizacaoLocale(session, parametros);

		parametros.put("TITULO_RELATORIO", UtilI18N.internacionaliza(request, "citcorporeRelatorio.pesquisaSolicitacoesServicosDetalhado"));
		parametros.put("CIDADE", getCidadeParametrizada(request));
		parametros.put("DATA_HORA", UtilDatas.getDataHoraAtual());
		parametros.put("NOME_USUARIO", usuario.getNomeUsuario());
		parametros.put("dataInicio", pesquisaSolicitacaoServicoDto.getDataInicio() == null ? pesquisaSolicitacaoServicoDto.getDataInicioFechamento() : pesquisaSolicitacaoServicoDto.getDataInicio());
		parametros.put("dataFim", pesquisaSolicitacaoServicoDto.getDataFim() == null ? pesquisaSolicitacaoServicoDto.getDataFimFechamento() : pesquisaSolicitacaoServicoDto.getDataFim());
		parametros.put("Logo", LogoRel.getFile());
		parametros.put("exibirCampoDescricao", pesquisaSolicitacaoServicoDto.getExibirCampoDescricao());
		parametros.put("quantidade", listaSolicitacaoServicoPorCriterios.size());
		parametros.put("criado_por", UtilI18N.internacionaliza(request, "citcorpore.comum.criadopor") + ":");

		if (pesquisaSolicitacaoServicoDto.getNomeItemConfiguracao() != null && !pesquisaSolicitacaoServicoDto.getNomeItemConfiguracao().equalsIgnoreCase("")) {
			parametros.put("nomeItemConfiguracao", pesquisaSolicitacaoServicoDto.getNomeItemConfiguracao());
		} else {
			parametros.put("nomeItemConfiguracao", null);
		}
		if (pesquisaSolicitacaoServicoDto.getNomeSolicitante() != null && !pesquisaSolicitacaoServicoDto.getNomeSolicitante().equalsIgnoreCase("")) {
			parametros.put("nomeSolicitante", pesquisaSolicitacaoServicoDto.getNomeSolicitante());
		} else {
			parametros.put("nomeSolicitante", null);
		}

		if (pesquisaSolicitacaoServicoDto.getIdTipoDemandaServico() != null) {
			ServiceDemandType tipoDemandaServico = ServiceDemandType.fromId(pesquisaSolicitacaoServicoDto.getIdTipoDemandaServico());
			String nomeTipoDemandaServico = null;
			if(tipoDemandaServico != null) {
				nomeTipoDemandaServico = UtilI18N.internacionaliza(request, tipoDemandaServico.getI18NKey());
				pesquisaSolicitacaoServicoDto.setNomeTipoDemandaServico(nomeTipoDemandaServico);
			}
			parametros.put("tipo", nomeTipoDemandaServico);
		} else {
			parametros.put("tipo", pesquisaSolicitacaoServicoDto.getNomeTipoDemandaServico());
		}
		if (pesquisaSolicitacaoServicoDto.getIdSolicitacaoServicoPesquisa() != null) {
			parametros.put("numero", pesquisaSolicitacaoServicoDto.getIdSolicitacaoServicoPesquisa());
		} else {
			parametros.put("numero", pesquisaSolicitacaoServicoDto.getIdSolicitacaoServicoPesquisa());
		}
		if (!UtilNumbersAndDecimals.nullToVazio(pesquisaSolicitacaoServicoDto.getIdStatus()).isEmpty()) {
			parametros.put("situacao", pesquisaSolicitacaoServicoDto.recuperaSituacaoInternacionalizada(request));
		} else {
			parametros.put("situacao", null);
		}

		if (pesquisaSolicitacaoServicoDto.getIdGrupoAtual() != null) {
			grupoDto.setIdGrupo(pesquisaSolicitacaoServicoDto.getIdGrupoAtual());
			grupoDto = (GrupoDTO) grupoSegurancaService.restore(grupoDto);
			pesquisaSolicitacaoServicoDto.setGrupoAtual(grupoDto.getSigla());
			parametros.put("grupoSolucionador", pesquisaSolicitacaoServicoDto.getGrupoAtual());
		} else {
			parametros.put("grupoSolucionador", pesquisaSolicitacaoServicoDto.getGrupoAtual());
		}
		if (pesquisaSolicitacaoServicoDto.getIdOrigem() != null) {
			origemDto.setIdOrigem(pesquisaSolicitacaoServicoDto.getIdOrigem());
			origemDto = (OrigemAtendimentoDTO) origemAtendimentoService.restore(origemDto);
			pesquisaSolicitacaoServicoDto.setOrigem(UtilStrings.unescapeJavaString(origemDto.getDescricao()));
			parametros.put("origem", pesquisaSolicitacaoServicoDto.getOrigem());
		} else {
			parametros.put("origem", pesquisaSolicitacaoServicoDto.getOrigem());
		}
		if (pesquisaSolicitacaoServicoDto.getIdFaseAtual() != null) {
			faseDto.setIdFase(pesquisaSolicitacaoServicoDto.getIdFaseAtual());
			faseDto = (FaseServicoDTO) faseServicoService.restore(faseDto);
			pesquisaSolicitacaoServicoDto.setFaseAtual(faseDto.getNomeFase());
			parametros.put("fase", pesquisaSolicitacaoServicoDto.getFaseAtual());
		} else {
			parametros.put("fase", pesquisaSolicitacaoServicoDto.getFaseAtual());
		}
		if (pesquisaSolicitacaoServicoDto.getIdPrioridade() != null) {
			prioridadeDto.setIdPrioridade(pesquisaSolicitacaoServicoDto.getIdPrioridade());
			prioridadeDto = (PrioridadeDTO) prioridadeService.restore(prioridadeDto);
			pesquisaSolicitacaoServicoDto.setPrioridade(prioridadeDto.getNomePrioridade());
			parametros.put("prioridade", pesquisaSolicitacaoServicoDto.getPrioridade());
		} else {
			parametros.put("prioridade", pesquisaSolicitacaoServicoDto.getPrioridade());
		}

		if (pesquisaSolicitacaoServicoDto.getIdContrato() != null) {
			contratoDto.setIdContrato(pesquisaSolicitacaoServicoDto.getIdContrato());
			contratoDto = (ContratoDTO) contratoService.restore(contratoDto);
			parametros.put("contrato", contratoDto.getNumero());
		} else {
			parametros.put("contrato", contratoDto.getNumero());
		}

		if (pesquisaSolicitacaoServicoDto.getIdResponsavel() != null) {
			usuarioDto.setIdUsuario(pesquisaSolicitacaoServicoDto.getIdResponsavel());
			usuarioDto = (UsuarioDTO) usuarioService.restore(usuarioDto);
			parametros.put("responsavel", usuarioDto.getNomeUsuario());
		} else {
			parametros.put("responsavel", null);
		}

		if (pesquisaSolicitacaoServicoDto.getIdUsuarioResponsavelAtual() != null) {
			usuarioDto.setIdUsuario(pesquisaSolicitacaoServicoDto.getIdUsuarioResponsavelAtual());
			usuarioDto = (UsuarioDTO) usuarioService.restore(usuarioDto);
			parametros.put("nomeUsuarioResponsavelAtual", usuarioDto.getNomeUsuario());
		} else {
			parametros.put("nomeUsuarioResponsavelAtual", null);
		}

		if (pesquisaSolicitacaoServicoDto.getIdUnidade() != null) {
			unidadeDto.setIdUnidade(pesquisaSolicitacaoServicoDto.getIdUnidade());
			unidadeDto = (UnidadeDTO) unidadeService.restore(unidadeDto);
			if (unidadeDto != null && unidadeDto.getNome() != null) {
				parametros.put("unidade", unidadeDto.getNome());
			} else {
				parametros.put("unidade", null);
			}
		} else {
			parametros.put("unidade", null);
		}

		parametros.put("nomeTarefaString", UtilI18N.internacionaliza(request, "citcorporeRelatorio.comum.nomeTarefa"));

		try {
			final JRDataSource dataSource = new JRBeanCollectionDataSource(listaSolicitacaoServicoPorCriterios);
			final JasperDesign desenho = JRXmlLoader.load(CITCorporeUtil.CAMINHO_REAL_APP + Constantes.getValue("CAMINHO_RELATORIOS") + "RelatorioPesquisaSolicitacaoServicoXlsDetalhado.jrxml");
			desenho.setLanguage("java");
			final JasperReport relatorio = JasperCompileManager.compileReport(desenho);
			final JasperPrint impressao = JasperFillManager.fillReport(relatorio, parametros, dataSource);
			final JRXlsxExporter exporter = new JRXlsxExporter();
			exporter.setExporterInput(new SimpleExporterInput(impressao));
			exporter.setExporterOutput(new SimpleOutputStreamExporterOutput(diretorioReceita + "/RelatorioPesquisaSolicitacaoServicoXlsDetalhado" + strCompl + "_" + usuario.getIdUsuario() + ".xlsx"));
            XlsxReportConfiguration xlsxReportConfiguration = new SimpleXlsxReportConfiguration();
            exporter.setConfiguration(xlsxReportConfiguration);
			exporter.exportReport();
			document.executeScript("window.open('" + Constantes.getValue("SERVER_ADDRESS") + Constantes.getValue("CONTEXTO_APLICACAO") + "/printPDF/printPDF.jsp?url=" + diretorioRelativoOS
					+ "/RelatorioPesquisaSolicitacaoServicoXlsDetalhado" + strCompl + "_" + usuario.getIdUsuario() + ".xlsx')");
		} catch (final OutOfMemoryError e) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.erro.erroServidor"));
		}
		document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
		this.limpaRegistrosDaPesquisa(document);
	}

	public void restoreUpload(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		request.getSession(true).setAttribute("colUploadsGED", null);
		/* Realida o refresh do iframe */
		document.executeScript("document.getElementById('fraUpload_uploadAnexos').contentWindow.location.reload(true)");

		usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}
		final PesquisaSolicitacaoServicoDTO pesquisaSolicitacaoServicoDto = (PesquisaSolicitacaoServicoDTO) document.getBean();

		if (pesquisaSolicitacaoServicoDto.getIdSolicitacaoServico() == null) {
			return;
		}
		final ControleGEDService controleGedService = (ControleGEDService) ServiceLocator.getInstance().getService(ControleGEDService.class, null);
		final Collection<ControleGEDDTO> colAnexos = controleGedService.listByIdTabelaAndID(ControleGEDDTO.TABELA_SOLICITACAOSERVICO, pesquisaSolicitacaoServicoDto.getIdSolicitacaoServico());
		final Collection<UploadDTO> colAnexosUploadDTO = controleGedService.convertListControleGEDToUploadDTO(colAnexos);

		request.getSession(true).setAttribute("colUploadsGED", colAnexosUploadDTO);
		document.executeScript("$('#POPUP_menuAnexos').dialog('open');");
	}

	public String mostrarOcorrencia(HttpServletRequest request) throws Exception {
		final OcorrenciaSolicitacaoService ocorrenciaSolicitacaoService = (OcorrenciaSolicitacaoService) ServiceLocator.getInstance().getService(OcorrenciaSolicitacaoService.class, null);
		final Collection<OcorrenciaSolicitacaoDTO> col = ocorrenciaSolicitacaoService.findByIdSolicitacaoServico(13458);
		for (final OcorrenciaSolicitacaoDTO ocorrenciaSolicitacaoDTO : col) {
			String dadosSolicitacao = UtilStrings.nullToVazio(ocorrenciaSolicitacaoDTO.getDadosSolicitacao());
			SolicitacaoServicoDTO solicitacaoDto = null;
			if (dadosSolicitacao.length() > 0) {
				try {
					solicitacaoDto = new Gson().fromJson(dadosSolicitacao, SolicitacaoServicoDTO.class);
					if (solicitacaoDto != null) {
						dadosSolicitacao = solicitacaoDto.recuperaDadosStr(usuario.getLocale());

						if (ServiceRequestStatus.SOLVED.getId().equals(solicitacaoDto.getIdStatus()) && !solicitacaoDto.getRegistradoPor().equals("Automtico")) {
							return solicitacaoDto.getRegistradoPor();
						}
					}
				} catch (final Exception e) {
					dadosSolicitacao = "";
				}
			}
			System.out.println(dadosSolicitacao);
		}
		return "";
	}

	public void imprimirRelatorioDetalhado(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final HttpSession session = request.getSession();
		final PesquisaSolicitacaoServicoDTO pesquisaSolicitacaoServicoDto = (PesquisaSolicitacaoServicoDTO) document.getBean();
		final SolicitacaoServicoService solicitacaoService = (SolicitacaoServicoService) ServiceLocator.getInstance().getService(SolicitacaoServicoService.class, null);
		GrupoDTO grupoDto = new GrupoDTO();
		final GrupoService grupoSegurancaService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
		OrigemAtendimentoDTO origemDto = new OrigemAtendimentoDTO();
		final OrigemAtendimentoService origemAtendimentoService = (OrigemAtendimentoService) ServiceLocator.getInstance().getService(OrigemAtendimentoService.class, null);
		FaseServicoDTO faseDto = new FaseServicoDTO();
		final FaseServicoService faseServicoService = (FaseServicoService) ServiceLocator.getInstance().getService(FaseServicoService.class, null);
		PrioridadeDTO prioridadeDto = new PrioridadeDTO();
		final PrioridadeService prioridadeService = (PrioridadeService) ServiceLocator.getInstance().getService(PrioridadeService.class, null);
		ContratoDTO contratoDto = new ContratoDTO();
		final ContratoService contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
		UsuarioDTO usuarioDto = new UsuarioDTO();
		final UsuarioService usuarioService = (UsuarioService) ServiceLocator.getInstance().getService(UsuarioService.class, null);
		UnidadeDTO unidadeDto = new UnidadeDTO();
		final UnidadeService unidadeService = (UnidadeService) ServiceLocator.getInstance().getService(UnidadeService.class, null);

		usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
			return;
		}

		// Passamos o usurio para que o sistema possa obter os IDs das unidades que ele pode acessar!
		pesquisaSolicitacaoServicoDto.setUsuarioLogado(usuario);

		ArrayList<SolicitacaoServicoDTO> listaSolicitacaoServicoPorCriterios = (ArrayList<SolicitacaoServicoDTO>) solicitacaoService.listPesquisaAvancadaRelatorioDetalhado(pesquisaSolicitacaoServicoDto);

		if (listaSolicitacaoServicoPorCriterios == null || listaSolicitacaoServicoPorCriterios.size() == 0) {
			document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.relatorioVazio"));
			return;
		}

		if (!ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANTIDADE_REGISTROS_PESQUISA_AVANCADA, "-1").equals("-1")
				&& listaSolicitacaoServicoPorCriterios.size() > Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANTIDADE_REGISTROS_PESQUISA_AVANCADA, "0"))) {
			document.alert(UtilI18N.internacionaliza(request, "citcorporeRelatorio.comum.registroMaiorPermitido"));
			document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
			return;
		}

		for (final SolicitacaoServicoDTO solicitacaoServico : listaSolicitacaoServicoPorCriterios) {
			String resposta = UtilStrings.unescapeJavaString(solicitacaoServico.getResposta());
			if (resposta != null && resposta.length() > 1500) {
				resposta = resposta.substring(0, 1500);
			}

			if ((solicitacaoServico.getPrazoHH() == null || solicitacaoServico.getPrazoHH() == 0) && (solicitacaoServico.getPrazoMM() == null || solicitacaoServico.getPrazoMM() == 0)) {
				solicitacaoServico.setSlaACombinar("S");
			} else {
				solicitacaoServico.setSlaACombinar("N");
			}

			String descricaoSemFormatacao = tratarDescricaoSemFormatacao(solicitacaoServico);
			solicitacaoServico.setDescricaoSemFormatacao(UtilStrings.unescapeJavaString(descricaoSemFormatacao));
			solicitacaoServico.setDescricao(UtilStrings.unescapeJavaString(solicitacaoServico.getDescricao()));

			if (pesquisaSolicitacaoServicoDto.getNomeUsuarioResponsavelAtual() != null) {
				solicitacaoServico.setNomeUsuarioResponsavelAtual(pesquisaSolicitacaoServicoDto.getNomeUsuarioResponsavelAtual());
			}

			/**
			 * Cria SLA para solicitacao
			 *
			 * @author thyen.chang
			 */
			if (solicitacaoServico != null && solicitacaoServico.getPrazoHH() != null && solicitacaoServico.getPrazoMM() != null) {
				solicitacaoServico.setSla((solicitacaoServico.getPrazoHH() < 10 ? "0" + solicitacaoServico.getPrazoHH().toString() : solicitacaoServico.getPrazoHH().toString()) + ":"
						+ (solicitacaoServico.getPrazoMM() < 10 ? "0" + solicitacaoServico.getPrazoMM().toString() : solicitacaoServico.getPrazoMM().toString()));
			} else {
				solicitacaoServico.setSla("");
			}

			/**
			 * Determina localidade caso no exista
			 *
			 * @author thyen.chang
			 */
			if (solicitacaoServico != null && (solicitacaoServico.getLocalidade() == null || solicitacaoServico.getLocalidade().equals(""))) {
				solicitacaoServico.setLocalidade(UtilI18N.internacionaliza(request, "citcorpore.comum.naoInformado"));
			}

			/**
			 * Determina responsvel caso no exista
			 *
			 * @author thyen.chang
			 */
			if (solicitacaoServico != null && solicitacaoServico.getResponsavelAtual() == null) {
				solicitacaoServico.setResponsavelAtual(UtilI18N.internacionaliza(request, "citcorporeRelatorio.comum.semResponsavelAtual"));
			}

			if (solicitacaoServico != null && solicitacaoServico.getNomeTarefa() == null) {
				solicitacaoServico.setNomeTarefa(UtilI18N.internacionaliza(request, "citcorpore.comum.naoInformado"));
			}

			if(solicitacaoServico!= null && solicitacaoServico.getDescrSituacao()!=null) {
				solicitacaoServico.setDescrSituacao(UtilI18N.internacionaliza(request, solicitacaoServico.getDescrSituacao()));
			}

		}

		final Date dt = new Date();
		final String strCompl = "" + dt.getTime();
		final String caminhoRelatorio = CITCorporeUtil.CAMINHO_REAL_APP + Constantes.getValue("CAMINHO_RELATORIOS") + "RelatorioPesquisaSolicitacaoServicoDetalhado.jrxml";
		final String diretorioReceita = CITCorporeUtil.CAMINHO_REAL_APP + "/tempFiles";
		final String diretorioRelativoOS = Constantes.getValue("SERVER_ADDRESS") + Constantes.getValue("CONTEXTO_APLICACAO") + "/tempFiles";

		Map<String, Object> parametros = new HashMap<>();

		parametros = UtilRelatorio.trataInternacionalizacaoLocale(session, parametros);

		parametros.put("TITULO_RELATORIO", UtilI18N.internacionaliza(request, "citcorporeRelatorio.pesquisaSolicitacoesServicosDetalhado"));
		parametros.put("CIDADE", getCidadeParametrizada(request));
		parametros.put("DATA_HORA", UtilDatas.getDataHoraAtual());
		parametros.put("NOME_USUARIO", usuario.getNomeUsuario());
		parametros.put("dataInicio", pesquisaSolicitacaoServicoDto.getDataInicio() == null ? pesquisaSolicitacaoServicoDto.getDataInicioFechamento() : pesquisaSolicitacaoServicoDto.getDataInicio());
		parametros.put("dataFim", pesquisaSolicitacaoServicoDto.getDataFim() == null ? pesquisaSolicitacaoServicoDto.getDataFimFechamento() : pesquisaSolicitacaoServicoDto.getDataFim());
		parametros.put("Logo", LogoRel.getFile());
		parametros.put("exibirCampoDescricao", UtilStrings.unescapeJavaString(pesquisaSolicitacaoServicoDto.getExibirCampoDescricao()));
		parametros.put("quantidade", listaSolicitacaoServicoPorCriterios.size());
		parametros.put("criado_por", UtilI18N.internacionaliza(request, "citcorpore.comum.criadopor") + ":");

		if (pesquisaSolicitacaoServicoDto.getNomeItemConfiguracao() != null && !pesquisaSolicitacaoServicoDto.getNomeItemConfiguracao().equalsIgnoreCase("")) {
			parametros.put("nomeItemConfiguracao", pesquisaSolicitacaoServicoDto.getNomeItemConfiguracao());
		} else {
			parametros.put("nomeItemConfiguracao", null);
		}
		if (pesquisaSolicitacaoServicoDto.getNomeSolicitante() != null && !pesquisaSolicitacaoServicoDto.getNomeSolicitante().equalsIgnoreCase("")) {
			parametros.put("nomeSolicitante", pesquisaSolicitacaoServicoDto.getNomeSolicitante());
		} else {
			parametros.put("nomeSolicitante", null);
		}

		if (pesquisaSolicitacaoServicoDto.getIdTipoDemandaServico() != null) {
			ServiceDemandType tipoDemandaServico = ServiceDemandType.fromId(pesquisaSolicitacaoServicoDto.getIdTipoDemandaServico());
			String nomeTipoDemandaServico = null;
			if(tipoDemandaServico != null) {
				nomeTipoDemandaServico = UtilI18N.internacionaliza(request, tipoDemandaServico.getI18NKey());
				pesquisaSolicitacaoServicoDto.setNomeTipoDemandaServico(nomeTipoDemandaServico);
			}
			parametros.put("tipo", nomeTipoDemandaServico);
		} else {
			parametros.put("tipo", pesquisaSolicitacaoServicoDto.getNomeTipoDemandaServico());
		}
		if (pesquisaSolicitacaoServicoDto.getIdSolicitacaoServicoPesquisa() != null) {
			parametros.put("numero", pesquisaSolicitacaoServicoDto.getIdSolicitacaoServicoPesquisa());
		} else {
			parametros.put("numero", pesquisaSolicitacaoServicoDto.getIdSolicitacaoServicoPesquisa());
		}
		if (!UtilNumbersAndDecimals.nullToVazio(pesquisaSolicitacaoServicoDto.getIdStatus()).isEmpty()) {
			parametros.put("situacao", pesquisaSolicitacaoServicoDto.recuperaSituacaoInternacionalizada(request));
		} else {
			parametros.put("situacao", null);
		}

		if (pesquisaSolicitacaoServicoDto.getIdGrupoAtual() != null) {
			grupoDto.setIdGrupo(pesquisaSolicitacaoServicoDto.getIdGrupoAtual());
			grupoDto = (GrupoDTO) grupoSegurancaService.restore(grupoDto);
			pesquisaSolicitacaoServicoDto.setGrupoAtual(grupoDto.getSigla());
			parametros.put("grupoSolucionador", pesquisaSolicitacaoServicoDto.getGrupoAtual());
		} else {
			parametros.put("grupoSolucionador", pesquisaSolicitacaoServicoDto.getGrupoAtual());
		}
		if (pesquisaSolicitacaoServicoDto.getIdOrigem() != null) {
			origemDto.setIdOrigem(pesquisaSolicitacaoServicoDto.getIdOrigem());
			origemDto = (OrigemAtendimentoDTO) origemAtendimentoService.restore(origemDto);
			pesquisaSolicitacaoServicoDto.setOrigem(UtilStrings.unescapeJavaString(origemDto.getDescricao()));
			parametros.put("origem", pesquisaSolicitacaoServicoDto.getOrigem());
		} else {
			parametros.put("origem", pesquisaSolicitacaoServicoDto.getOrigem());
		}
		if (pesquisaSolicitacaoServicoDto.getIdFaseAtual() != null) {
			faseDto.setIdFase(pesquisaSolicitacaoServicoDto.getIdFaseAtual());
			faseDto = (FaseServicoDTO) faseServicoService.restore(faseDto);
			pesquisaSolicitacaoServicoDto.setFaseAtual(faseDto.getNomeFase());
			parametros.put("fase", pesquisaSolicitacaoServicoDto.getFaseAtual());
		} else {
			parametros.put("fase", pesquisaSolicitacaoServicoDto.getFaseAtual());
		}
		if (pesquisaSolicitacaoServicoDto.getIdPrioridade() != null) {
			prioridadeDto.setIdPrioridade(pesquisaSolicitacaoServicoDto.getIdPrioridade());
			prioridadeDto = (PrioridadeDTO) prioridadeService.restore(prioridadeDto);
			pesquisaSolicitacaoServicoDto.setPrioridade(prioridadeDto.getNomePrioridade());
			parametros.put("prioridade", pesquisaSolicitacaoServicoDto.getPrioridade());
		} else {
			parametros.put("prioridade", pesquisaSolicitacaoServicoDto.getPrioridade());
		}

		if (pesquisaSolicitacaoServicoDto.getIdContrato() != null) {
			contratoDto.setIdContrato(pesquisaSolicitacaoServicoDto.getIdContrato());
			contratoDto = (ContratoDTO) contratoService.restore(contratoDto);
			parametros.put("contrato", contratoDto.getNumero());
		} else {
			parametros.put("contrato", contratoDto.getNumero());
		}

		if (pesquisaSolicitacaoServicoDto.getIdResponsavel() != null) {
			usuarioDto.setIdUsuario(pesquisaSolicitacaoServicoDto.getIdResponsavel());
			usuarioDto = (UsuarioDTO) usuarioService.restore(usuarioDto);
			parametros.put("responsavel", usuarioDto.getNomeUsuario());
		} else {
			parametros.put("responsavel", null);
		}

		if (pesquisaSolicitacaoServicoDto.getIdUsuarioResponsavelAtual() != null) {
			usuarioDto.setIdUsuario(pesquisaSolicitacaoServicoDto.getIdUsuarioResponsavelAtual());
			usuarioDto = (UsuarioDTO) usuarioService.restore(usuarioDto);
			parametros.put("nomeUsuarioResponsavelAtual", usuarioDto.getNomeUsuario());
		} else {
			parametros.put("nomeUsuarioResponsavelAtual", null);
		}

		if (pesquisaSolicitacaoServicoDto.getIdUnidade() != null) {
			unidadeDto.setIdUnidade(pesquisaSolicitacaoServicoDto.getIdUnidade());
			unidadeDto = (UnidadeDTO) unidadeService.restore(unidadeDto);
			if (unidadeDto != null && unidadeDto.getNome() != null) {
				parametros.put("unidade", unidadeDto.getNome());
			} else {
				parametros.put("unidade", null);
			}
		} else {
			parametros.put("unidade", null);
		}

		parametros.put("nomeTarefaString", UtilI18N.internacionaliza(request, "citcorporeRelatorio.comum.nomeTarefa"));

		try {
			JRDataSource dataSource = new JRBeanCollectionDataSource(listaSolicitacaoServicoPorCriterios);

			JRAbstractLRUVirtualizer virtualizer = new JRGzipVirtualizer(50);

			// Seta o parametro REPORT_VIRTUALIZER com a instncia da virtualizao
			parametros.put(JRParameter.REPORT_VIRTUALIZER, virtualizer);

			// Preenche o relatrio e exibe numa GUI
			final Timestamp ts1 = UtilDatas.getDataHoraAtual();
			final JasperDesign desenho = JRXmlLoader.load(caminhoRelatorio);
			desenho.setLanguage("java");
			final JasperReport relatorio = JasperCompileManager.compileReport(desenho);
			final JasperPrint jp = JasperFillManager.fillReport(relatorio, parametros, dataSource);
			final Timestamp ts2 = UtilDatas.getDataHoraAtual();
			final double tempo = UtilDatas.calculaDiferencaTempoEmMilisegundos(ts2, ts1);
			System.out.println("########## Tempo fillReport: " + tempo);

			JasperExportManager.exportReportToPdfFile(jp, diretorioReceita + "/RelatorioSolicitacaoServicoDetalhado" + strCompl + "_" + usuario.getIdUsuario() + ".pdf");
			document.executeScript("window.open('" + Constantes.getValue("SERVER_ADDRESS") + Constantes.getValue("CONTEXTO_APLICACAO") + "/printPDF/printPDF.jsp?url=" + diretorioRelativoOS + "/RelatorioSolicitacaoServicoDetalhado"
					+ strCompl + "_" + usuario.getIdUsuario() + ".pdf')");
			virtualizer = null;
			dataSource = null;
			listaSolicitacaoServicoPorCriterios = null;
		} catch (final OutOfMemoryError e) {
			/*
			 * Desenvolvedor: Thiago Matias - Data: 30/10/2013 - Horrio: 15h35min - ID Citsmart: 122665 - Motivo/Comentrio: alterando o a chave de citcorpore.erro.memoria para citsmart.erro.memoria
			 */
			document.alert(UtilI18N.internacionaliza(request, "citsmart.erro.memoria"));
		}
		document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
		this.limpaRegistrosDaPesquisa(document);
	}

	public void imprimirRelatorioXls(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final HttpSession session = request.getSession();
		final PesquisaSolicitacaoServicoDTO pesquisaSolicitacaoServicoDto = (PesquisaSolicitacaoServicoDTO) document.getBean();
		final SolicitacaoServicoService solicitacaoService = (SolicitacaoServicoService) ServiceLocator.getInstance().getService(SolicitacaoServicoService.class, null);
		GrupoDTO grupoDto = new GrupoDTO();
		final GrupoService grupoSegurancaService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
		OrigemAtendimentoDTO origemDto = new OrigemAtendimentoDTO();
		final OrigemAtendimentoService origemAtendimentoService = (OrigemAtendimentoService) ServiceLocator.getInstance().getService(OrigemAtendimentoService.class, null);
		FaseServicoDTO faseDto = new FaseServicoDTO();
		final FaseServicoService faseServicoService = (FaseServicoService) ServiceLocator.getInstance().getService(FaseServicoService.class, null);
		PrioridadeDTO prioridadeDto = new PrioridadeDTO();
		final PrioridadeService prioridadeService = (PrioridadeService) ServiceLocator.getInstance().getService(PrioridadeService.class, null);
		ContratoDTO contratoDto = new ContratoDTO();
		final ContratoService contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
		UsuarioDTO usuarioDto = new UsuarioDTO();
		final UsuarioService usuarioService = (UsuarioService) ServiceLocator.getInstance().getService(UsuarioService.class, null);
		UnidadeDTO unidadeDto = new UnidadeDTO();
		final UnidadeService unidadeService = (UnidadeService) ServiceLocator.getInstance().getService(UnidadeService.class, null);

		usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
			return;
		}

		// Passamos o usurio para que o sistema possa obter os IDs das unidades que ele pode acessar!
		pesquisaSolicitacaoServicoDto.setUsuarioLogado(usuario);

		final List<SolicitacaoServicoDTO> listaSolicitacaoServicoPorCriterios = solicitacaoService.listPesquisaAvancadaRelatorio(pesquisaSolicitacaoServicoDto);

		if (listaSolicitacaoServicoPorCriterios == null || listaSolicitacaoServicoPorCriterios.size() == 0) {
			document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.relatorioVazio"));
			return;
		}

		if (!ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANTIDADE_REGISTROS_PESQUISA_AVANCADA, "-1").equals("-1")
				&& listaSolicitacaoServicoPorCriterios.size() > Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANTIDADE_REGISTROS_PESQUISA_AVANCADA, "0"))) {
			document.alert(UtilI18N.internacionaliza(request, "citcorporeRelatorio.comum.registroMaiorPermitido"));
			document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
			return;
		}

		for (final SolicitacaoServicoDTO solicitacaoServico : listaSolicitacaoServicoPorCriterios) {
			String resposta = tratarRespostaSolicitacao(solicitacaoServico);
			solicitacaoServico.setResposta(UtilStrings.unescapeJavaString(resposta));

			if ((solicitacaoServico.getPrazoHH() == null || solicitacaoServico.getPrazoHH() == 0) && (solicitacaoServico.getPrazoMM() == null || solicitacaoServico.getPrazoMM() == 0)) {
				solicitacaoServico.setSlaACombinar("S");
			} else {
				solicitacaoServico.setSlaACombinar("N");
			}

			String descricaoSemFormatacao = tratarDescricaoSemFormatacao(solicitacaoServico);
			solicitacaoServico.setDescricaoSemFormatacao(UtilStrings.unescapeJavaString(descricaoSemFormatacao));
			solicitacaoServico.setDescricao(UtilStrings.unescapeJavaString(solicitacaoServico.getDescricao()));

			if (pesquisaSolicitacaoServicoDto.getNomeUsuarioResponsavelAtual() != null) {
				solicitacaoServico.setNomeUsuarioResponsavelAtual(pesquisaSolicitacaoServicoDto.getNomeUsuarioResponsavelAtual());
			}

			if (solicitacaoServico != null && solicitacaoServico.getResponsavelAtual() == null) {
				solicitacaoServico.setResponsavelAtual(UtilI18N.internacionaliza(request, "citcorporeRelatorio.comum.semResponsavelAtual"));
			}

			if (solicitacaoServico != null && solicitacaoServico.getNomeTarefa() == null) {
				solicitacaoServico.setNomeTarefa(UtilI18N.internacionaliza(request, "citcorpore.comum.naoInformado"));
			}

			if (solicitacaoServico != null && solicitacaoServico.getResposta() != null) {
				solicitacaoServico.setResposta(formataCaracteresInvlidos(solicitacaoServico.getResposta()));
			}

			if(solicitacaoServico!= null && solicitacaoServico.getDescrSituacao()!=null) {
				solicitacaoServico.setDescrSituacao(UtilI18N.internacionaliza(request, solicitacaoServico.getDescrSituacao()));
			}

		}

		final Date dt = new Date();
		final String strCompl = "" + dt.getTime();
		final String diretorioReceita = CITCorporeUtil.CAMINHO_REAL_APP + "/tempFiles";
		final String diretorioRelativoOS = Constantes.getValue("SERVER_ADDRESS") + Constantes.getValue("CONTEXTO_APLICACAO") + "/tempFiles";

		Map<String, Object> parametros = new HashMap<>();
		parametros = UtilRelatorio.trataInternacionalizacaoLocale(session, parametros);

		parametros.put("TITULO_RELATORIO", UtilI18N.internacionaliza(request, "citcorporeRelatorio.pesquisaSolicitacoesServicos"));
		parametros.put("CIDADE", getCidadeParametrizada(request));
		parametros.put("DATA_HORA", UtilDatas.getDataHoraAtual());
		parametros.put("NOME_USUARIO", usuario.getNomeUsuario());
		parametros.put("dataInicio", pesquisaSolicitacaoServicoDto.getDataInicio() == null ? pesquisaSolicitacaoServicoDto.getDataInicioFechamento() : pesquisaSolicitacaoServicoDto.getDataInicio());
		parametros.put("dataFim", pesquisaSolicitacaoServicoDto.getDataFim() == null ? pesquisaSolicitacaoServicoDto.getDataFimFechamento() : pesquisaSolicitacaoServicoDto.getDataFim());
		parametros.put("Logo", LogoRel.getFile());
		parametros.put("exibirCampoDescricao", pesquisaSolicitacaoServicoDto.getExibirCampoDescricao());
		parametros.put("quantidade", listaSolicitacaoServicoPorCriterios.size());
		parametros.put("criado_por", UtilI18N.internacionaliza(request, "citcorpore.comum.criadopor") + ":");

		if (pesquisaSolicitacaoServicoDto.getNomeItemConfiguracao() != null && !pesquisaSolicitacaoServicoDto.getNomeItemConfiguracao().equalsIgnoreCase("")) {
			parametros.put("nomeItemConfiguracao", pesquisaSolicitacaoServicoDto.getNomeItemConfiguracao());
		} else {
			parametros.put("nomeItemConfiguracao", null);
		}
		if (pesquisaSolicitacaoServicoDto.getNomeSolicitante() != null && !pesquisaSolicitacaoServicoDto.getNomeSolicitante().equalsIgnoreCase("")) {
			parametros.put("nomeSolicitante", pesquisaSolicitacaoServicoDto.getNomeSolicitante());
		} else {
			parametros.put("nomeSolicitante", null);
		}

		if (pesquisaSolicitacaoServicoDto.getIdTipoDemandaServico() != null) {
			ServiceDemandType tipoDemandaServico = ServiceDemandType.fromId(pesquisaSolicitacaoServicoDto.getIdTipoDemandaServico());
			String nomeTipoDemandaServico = null;
			if(tipoDemandaServico != null) {
				nomeTipoDemandaServico = UtilI18N.internacionaliza(request, tipoDemandaServico.getI18NKey());
				pesquisaSolicitacaoServicoDto.setNomeTipoDemandaServico(nomeTipoDemandaServico);
			}
			parametros.put("tipo", nomeTipoDemandaServico);
		} else {
			parametros.put("tipo", pesquisaSolicitacaoServicoDto.getNomeTipoDemandaServico());
		}
		if (pesquisaSolicitacaoServicoDto.getIdSolicitacaoServicoPesquisa() != null) {
			parametros.put("numero", pesquisaSolicitacaoServicoDto.getIdSolicitacaoServicoPesquisa());
		} else {
			parametros.put("numero", pesquisaSolicitacaoServicoDto.getIdSolicitacaoServicoPesquisa());
		}
		if (!UtilNumbersAndDecimals.nullToVazio(pesquisaSolicitacaoServicoDto.getIdStatus()).isEmpty()) {
			parametros.put("situacao", pesquisaSolicitacaoServicoDto.recuperaSituacaoInternacionalizada(request));
		} else {
			parametros.put("situacao", null);
		}

		if (pesquisaSolicitacaoServicoDto.getIdGrupoAtual() != null) {
			grupoDto.setIdGrupo(pesquisaSolicitacaoServicoDto.getIdGrupoAtual());
			grupoDto = (GrupoDTO) grupoSegurancaService.restore(grupoDto);
			pesquisaSolicitacaoServicoDto.setGrupoAtual(grupoDto.getSigla());
			parametros.put("grupoSolucionador", pesquisaSolicitacaoServicoDto.getGrupoAtual());
		} else {
			parametros.put("grupoSolucionador", pesquisaSolicitacaoServicoDto.getGrupoAtual());
		}
		if (pesquisaSolicitacaoServicoDto.getIdOrigem() != null) {
			origemDto.setIdOrigem(pesquisaSolicitacaoServicoDto.getIdOrigem());
			origemDto = (OrigemAtendimentoDTO) origemAtendimentoService.restore(origemDto);
			pesquisaSolicitacaoServicoDto.setOrigem(UtilStrings.unescapeJavaString(origemDto.getDescricao()));
			parametros.put("origem", pesquisaSolicitacaoServicoDto.getOrigem());
		} else {
			parametros.put("origem", pesquisaSolicitacaoServicoDto.getOrigem());
		}
		if (pesquisaSolicitacaoServicoDto.getIdFaseAtual() != null) {
			faseDto.setIdFase(pesquisaSolicitacaoServicoDto.getIdFaseAtual());
			faseDto = (FaseServicoDTO) faseServicoService.restore(faseDto);
			pesquisaSolicitacaoServicoDto.setFaseAtual(faseDto.getNomeFase());
			parametros.put("fase", pesquisaSolicitacaoServicoDto.getFaseAtual());
		} else {
			parametros.put("fase", pesquisaSolicitacaoServicoDto.getFaseAtual());
		}
		if (pesquisaSolicitacaoServicoDto.getIdPrioridade() != null) {
			prioridadeDto.setIdPrioridade(pesquisaSolicitacaoServicoDto.getIdPrioridade());
			prioridadeDto = (PrioridadeDTO) prioridadeService.restore(prioridadeDto);
			pesquisaSolicitacaoServicoDto.setPrioridade(prioridadeDto.getNomePrioridade());
			parametros.put("prioridade", pesquisaSolicitacaoServicoDto.getPrioridade());
		} else {
			parametros.put("prioridade", pesquisaSolicitacaoServicoDto.getPrioridade());
		}

		if (pesquisaSolicitacaoServicoDto.getIdContrato() != null) {
			contratoDto.setIdContrato(pesquisaSolicitacaoServicoDto.getIdContrato());
			contratoDto = (ContratoDTO) contratoService.restore(contratoDto);
			parametros.put("contrato", contratoDto.getNumero());
		} else {
			parametros.put("contrato", contratoDto.getNumero());
		}

		if (pesquisaSolicitacaoServicoDto.getIdResponsavel() != null) {
			usuarioDto.setIdUsuario(pesquisaSolicitacaoServicoDto.getIdResponsavel());
			usuarioDto = (UsuarioDTO) usuarioService.restore(usuarioDto);
			parametros.put("responsavel", usuarioDto.getNomeUsuario());
		} else {
			parametros.put("responsavel", null);
		}

		if (pesquisaSolicitacaoServicoDto.getIdUsuarioResponsavelAtual() != null) {
			usuarioDto.setIdUsuario(pesquisaSolicitacaoServicoDto.getIdUsuarioResponsavelAtual());
			usuarioDto = (UsuarioDTO) usuarioService.restore(usuarioDto);
			parametros.put("nomeUsuarioResponsavelAtual", usuarioDto.getNomeUsuario());
		} else {
			parametros.put("nomeUsuarioResponsavelAtual", null);
		}

		if (pesquisaSolicitacaoServicoDto.getIdUnidade() != null) {
			unidadeDto.setIdUnidade(pesquisaSolicitacaoServicoDto.getIdUnidade());
			unidadeDto = (UnidadeDTO) unidadeService.restore(unidadeDto);
			if (unidadeDto != null && unidadeDto.getNome() != null) {
				parametros.put("unidade", unidadeDto.getNome());
			} else {
				parametros.put("unidade", null);
			}
		} else {
			parametros.put("unidade", null);
		}

		parametros.put("nomeTarefaString", UtilI18N.internacionaliza(request, "citcorporeRelatorio.comum.nomeTarefa"));

		try {
			final JRDataSource dataSource = new JRBeanCollectionDataSource(listaSolicitacaoServicoPorCriterios);
			final JasperDesign desenho = JRXmlLoader.load(CITCorporeUtil.CAMINHO_REAL_APP + Constantes.getValue("CAMINHO_RELATORIOS") + "RelatorioPesquisaSolicitacaoServicoXls.jrxml");
			desenho.setLanguage("java");
			final JasperReport relatorio = JasperCompileManager.compileReport(desenho);
			final JasperPrint impressao = JasperFillManager.fillReport(relatorio, parametros, dataSource);
			final JRXlsxExporter exporter = new JRXlsxExporter();
			exporter.setExporterInput(new SimpleExporterInput(impressao));
			exporter.setExporterOutput(new SimpleOutputStreamExporterOutput(diretorioReceita + "/RelatorioPesquisaSolicitacaoServicoXls" + strCompl + "_" + usuario.getIdUsuario() + ".xlsx"));
            XlsxReportConfiguration xlsxReportConfiguration = new SimpleXlsxReportConfiguration();
            exporter.setConfiguration(xlsxReportConfiguration);
			exporter.exportReport();
			document.executeScript("window.open('" + Constantes.getValue("SERVER_ADDRESS") + Constantes.getValue("CONTEXTO_APLICACAO") + "/printPDF/printPDF.jsp?url=" + diretorioRelativoOS
					+ "/RelatorioPesquisaSolicitacaoServicoXls" + strCompl + "_" + usuario.getIdUsuario() + ".xlsx')");
		} catch (final OutOfMemoryError e) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.erro.erroServidor"));
		}
		document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
		this.limpaRegistrosDaPesquisa(document);
	}

	/**
	 * defeito-182765 - PesquisaSolicitacoesServicos.java_(#tratarDescricaoSemFormatacao).
	 *
	 * @since 10/12/2015
	 * @author ibimon.morais
	 */
	private String tratarDescricaoSemFormatacao(final SolicitacaoServicoDTO solicitacaoServico) {
		String descricaoSemFormatacao = UtilStrings.fixEncoding(solicitacaoServico.getDescricaoSemFormatacao());
		if (descricaoSemFormatacao != null && descricaoSemFormatacao.length() > 1500) {
			descricaoSemFormatacao = solicitacaoServico.getDescricaoSemFormatacao().substring(0, 1500);
		}
		return descricaoSemFormatacao;
	}

	/**
	 * defeito-182765 - PesquisaSolicitacoesServicos.java_(#tratarRespostaSolicitacao).
	 *
	 * @since 10/12/2015
	 * @author ibimon.morais
	 */
	private String tratarRespostaSolicitacao(final SolicitacaoServicoDTO solicitacaoServico) {
		String resposta = solicitacaoServico.getResposta();
		if (resposta != null && resposta.length() > 1500) {
			resposta = resposta.substring(0, 1500);
		}
		return resposta;
	}

	public void onChangeContrato(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {

		try{
			verificaTipoDeAcordoDoContrato(document, request, response);

			preencherComboUnidade(document, request, response);
		}catch(Exception e){
			throw new Exception(e);
		}finally{
			document.executeScript("afterOnChangeContrato();");
		}

	}

	public void preencherComboUnidade(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) {

		final String UNIDADE_AUTOCOMPLETE = ParametroUtil.getValorParametroCitSmartHashMap(br.com.centralit.citcorpore.util.Enumerados.ParametroSistema.UNIDADE_AUTOCOMPLETE, "N");
		if (UNIDADE_AUTOCOMPLETE == null || !UNIDADE_AUTOCOMPLETE.equalsIgnoreCase("S")) {
			usuario = WebUtil.getUsuario(request);
			final PesquisaSolicitacaoServicoDTO pesquisaSolicitacaoServicoDto = (PesquisaSolicitacaoServicoDTO) document.getBean();
			final String UNIDADE_VINC_CONTRATOS = ParametroUtil.getValorParametroCitSmartHashMap(br.com.centralit.citcorpore.util.Enumerados.ParametroSistema.UNIDADE_VINC_CONTRATOS, "N");

			Integer idContrato = 0;
			if (UNIDADE_VINC_CONTRATOS != null && UNIDADE_VINC_CONTRATOS.equalsIgnoreCase("S")) {
				idContrato = pesquisaSolicitacaoServicoDto.getIdContrato() != null && pesquisaSolicitacaoServicoDto.getIdContrato().intValue() > 0 ? pesquisaSolicitacaoServicoDto.getIdContrato().intValue() : -1;
			}

			EmpregadoDTO empregadoDTO = new EmpregadoDTO();
			try {
				final EmpregadoService empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, null);

				empregadoDTO.setIdEmpregado(usuario.getIdEmpregado());
				empregadoDTO = (EmpregadoDTO) empregadoService.restore(empregadoDTO);
			} catch (final LogicException e1) {
				e1.printStackTrace();
			} catch (final ServiceException e1) {
				e1.printStackTrace();
			} catch (final Exception e) {
				e.printStackTrace();
			}
			final Integer idUnidadeColaborador = empregadoDTO.getIdUnidade() != null && empregadoDTO.getIdUnidade().intValue() > 0 ? empregadoDTO.getIdUnidade() : 0;

			final String tipoHierarquia = ParametroUtil.getValorParametroCitSmartHashMap(br.com.centralit.citcorpore.util.Enumerados.ParametroSistema.TIPO_HIERARQUIA_UNIDADE, "1");

			new ArrayList<UnidadeDTO>();
			Arvore arvore = new Arvore();
			try {
				final UnidadeService unidadeService = (UnidadeService) ServiceLocator.getInstance().getService(UnidadeService.class, null);
				arvore = unidadeService.obtemArvoreUnidades("", idContrato, idUnidadeColaborador, tipoHierarquia, 0);
			} catch (final Exception e1) {
				e1.printStackTrace();
			}

			HTMLSelect comboUnidade;
			try {
				comboUnidade = document.getSelectById("idUnidade");
				if (comboUnidade != null) {
					comboUnidade.removeAllOptions();
					comboUnidade.addOption("0", UtilI18N.internacionaliza(request, "citcorpore.comum.todas"));

					for (int i = 0; i < arvore.getListaID().size(); i++) {
						comboUnidade.addOption(arvore.getListaID().get(i).toString(), StringEscapeUtils.escapeJavaScript(arvore.getListaTexto().get(i)));
					}
				}
			} catch (final Exception e) {
				e.printStackTrace();
			}
		}
	}

	/**
	 * Funo para retirar caracteres HTML invlidos no relatrio XLS
	 *
	 * @param texto
	 * @return
	 */
	public static String formataCaracteresInvlidos(final String texto) {
		return Jsoup.parse(texto).text();
	}

	public void limpaRegistrosDaPesquisa(final DocumentHTML document) throws Exception {
		document.getElementById("paginacao").setValue("0");
		document.getElementById("pagAtual").setValue("0");
		document.getElementById("paginaAtual").setInnerHTML("0");
		document.getElementById("paginaTotal").setInnerHTML("0");
		document.getElementById("totalPagina").setValue("0");
		document.getElementById("totalItens").setValue("0");
		document.getElementById("totalItensPorPagina").setValue("0");

		document.getElementById("tblResumo").setInnerHTML(" ");
	}

	public void visualizarSolicitacaoPrincipal(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final PesquisaSolicitacaoServicoDTO pesquisaSolicitacaoServicoDto = (PesquisaSolicitacaoServicoDTO) document.getBean();

		SolicitacaoServicoDTO solicitacaoPrincipalDTO = new SolicitacaoServicoDTO();

		if (pesquisaSolicitacaoServicoDto.getIdSolicitacaoServicoPrincipal() != null) {
			solicitacaoPrincipalDTO = this.getSolicitacaoServicoService().restoreSolicitacaoServicoWithIdTarefa(pesquisaSolicitacaoServicoDto.getIdSolicitacaoServicoPrincipal());
			document.executeScript(
					"visualizarSolicitacao(".concat(String.valueOf(solicitacaoPrincipalDTO.getIdSolicitacaoServico())).concat(",").concat(String.valueOf(solicitacaoPrincipalDTO.getIdTarefa())).concat(")"));
		}
	};

	private ContratoService getContratoService() throws ServiceException {
		if (contratoService == null) {
			contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
		}
		return contratoService;
	}

	private SolicitacaoServicoService getSolicitacaoServicoService() throws ServiceException {
		if (solicitacaoServicoService == null) {
			solicitacaoServicoService = (SolicitacaoServicoService) ServiceLocator.getInstance().getService(SolicitacaoServicoService.class, null);
		}
		return solicitacaoServicoService;
	}

	private PermissoesFluxoService getPermissoesFluxoService() throws ServiceException {
		if (permissoesFluxoService == null) {
			permissoesFluxoService = (PermissoesFluxoService) ServiceLocator.getInstance().getService(PermissoesFluxoService.class, null);
		}
		return permissoesFluxoService;
	}

	private ServicoContratoService getServicoContratoService() throws ServiceException {
		if (servicoContratoService == null) {
			servicoContratoService = (ServicoContratoService) ServiceLocator.getInstance().getService(ServicoContratoService.class, null);
		}
		return servicoContratoService;
	}

	private ServicoService getServicoService() throws ServiceException {
		if (servicoService == null) {
			servicoService = (ServicoService) ServiceLocator.getInstance().getService(ServicoService.class, null);
		}
		return servicoService;
	}

	private CalendarioService getCalendarioService() throws ServiceException {
		if (calendarioService == null) {
			calendarioService = (CalendarioService) ServiceLocator.getInstance().getService(CalendarioService.class, null);
		}
		return calendarioService;
	}
}