package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.AcaoPlanoMelhoriaDTO;
import br.com.centralit.citcorpore.bean.EmpregadoDTO;
import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.KpiObjetivoMonitoramentoDTO;
import br.com.centralit.citcorpore.bean.ObjetivoMonitoramentoDTO;
import br.com.centralit.citcorpore.bean.ObjetivoPlanoMelhoriaDTO;
import br.com.centralit.citcorpore.bean.PlanoMelhoriaDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.negocio.AcaoPlanoMelhoriaService;
import br.com.centralit.citcorpore.negocio.ContratoService;
import br.com.centralit.citcorpore.negocio.EmpregadoService;
import br.com.centralit.citcorpore.negocio.FornecedorService;
import br.com.centralit.citcorpore.negocio.GrupoService;
import br.com.centralit.citcorpore.negocio.KpiObjetivoMonitoramentoService;
import br.com.centralit.citcorpore.negocio.ObjetivoMonitoramentoService;
import br.com.centralit.citcorpore.negocio.ObjetivoPlanoMelhoriaService;
import br.com.centralit.citcorpore.negocio.PlanoMelhoriaService;
import br.com.centralit.citcorpore.negocio.Responsable;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.Util;
import br.com.centralit.citcorpore.util.UtilRelatorio;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.Reflexao;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

@SuppressWarnings({ "rawtypes" })
public class PlanoMelhoria extends AjaxFormAction {

	private UsuarioDTO usuarioDto;
	private static Permissoes permissao;

	private GrupoService grupoService;
	private EmpregadoService empregadoService;
	private KpiObjetivoMonitoramentoService kpiService;
	private PlanoMelhoriaService planoMelhoriaService;
	private ObjetivoPlanoMelhoriaService objetivoPlanoMelhoriaService;
	private AcaoPlanoMelhoriaService acaoPlanoMelhoriaService;
	private ObjetivoMonitoramentoService objetivoMonitoramentoService;
	private FornecedorService fornecedorService;
	private ContratoService contratoService;

	private UsuarioDTO getUsuarioDTO(HttpServletRequest request) {
		if (Util.isNullOrEmpty(usuarioDto)) {
			usuarioDto = WebUtil.getUsuario(request);
		}
		return usuarioDto;
	}

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		permissao = new Permissoes(document, request);

		Collection listaFornecedores = getFornecedorService().list();

		document.getSelectById("idFornecedor").removeAllOptions();
		document.getSelectById("idContrato").removeAllOptions();

		document.getSelectById("idFornecedor").addOption("-1", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
		document.getSelectById("idContrato").addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

		if (listaFornecedores != null) {
			document.getSelectById("idFornecedor").addOptions(listaFornecedores, "idFornecedor", "razaoSocial", null);
		}

		// Carrega combo de tipo responsavel.
		HTMLSelect tipoResponsavelObjetivo = document.getSelectById("tipoResponsavelObjetivo");
		HTMLSelect tipoResponsavelAcao = document.getSelectById("tipoResponsavelAcao");
		HTMLSelect tipoResponsavelMonitoramento = document.getSelectById("tipoResponsavelMonitoramento");

		popuplarTipoResponsavel(request, tipoResponsavelObjetivo, tipoResponsavelAcao, tipoResponsavelMonitoramento);
	}

	private void popuplarTipoResponsavel(HttpServletRequest request, HTMLSelect... htmls) {
		for (HTMLSelect html : htmls) {
			if (!Util.isNullOrEmpty(html)) {
				html.removeAllOptions();
				html.addOption("0", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
				html.addOption("U", UtilI18N.internacionaliza(request, "citcorpore.comum.usuario"));
				html.addOption("G", UtilI18N.internacionaliza(request, "controle.grupo"));
			}
		}
	}

	@Override
	public Class<PlanoMelhoriaDTO> getBeanClass() {
		return PlanoMelhoriaDTO.class;
	}

	public void carregarContratos(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		PlanoMelhoriaDTO planoMelhoriaDTO = (PlanoMelhoriaDTO) document.getBean();
		carregarContratos(planoMelhoriaDTO, document, request);
	}

	private void carregarContratos(PlanoMelhoriaDTO planoMelhoriaDTO, DocumentHTML document, HttpServletRequest request) throws Exception {

		if (planoMelhoriaDTO.getIdFornecedor() != null && planoMelhoriaDTO.getIdFornecedor() > -1) {
			Collection contratos = getContratoService().findByIdFornecedor(planoMelhoriaDTO.getIdFornecedor());

			document.getSelectById("idContrato").removeAllOptions();

			document.getSelectById("idContrato").addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

			if (contratos != null) {
				document.getSelectById("idContrato").addOptions(contratos, "idContrato", "numero", null);

				// edio do plano de melhoria
				if (planoMelhoriaDTO.getIdPlanoMelhoria() != null) {

					planoMelhoriaDTO = getPlanoMelhoriaService().restore(planoMelhoriaDTO);

					if (planoMelhoriaDTO.getIdContrato() != null) {
						document.executeScript("$('#idContrato').val(" + planoMelhoriaDTO.getIdContrato() + ")");
					}
				}
			}
		}
	}

	// -- PLANO

	public void gravarPlano(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		PlanoMelhoriaDTO planoMelhoriaDTO = (PlanoMelhoriaDTO) document.getBean();

		planoMelhoriaDTO.setModificadoPor(getUsuarioDTO(request).getNomeUsuario());
		planoMelhoriaDTO.setUltModificacao(UtilDatas.getDataAtual());

		if (planoMelhoriaDTO.getIdPlanoMelhoria() == null || planoMelhoriaDTO.getIdPlanoMelhoria().intValue() == 0) {
			planoMelhoriaDTO.setCriadoPor(getUsuarioDTO(request).getNomeUsuario());
			planoMelhoriaDTO.setDataCriacao(UtilDatas.getDataAtual());
			planoMelhoriaDTO = getPlanoMelhoriaService().create(planoMelhoriaDTO);
			document.alert(UtilI18N.internacionaliza(request, "MSG05"));

			if (planoMelhoriaDTO != null && planoMelhoriaDTO.getIdPlanoMelhoria() != null) {
				HTMLForm form = document.getForm("form");
				form.setValues(planoMelhoriaDTO);
			}

		} else {
			getPlanoMelhoriaService().update(planoMelhoriaDTO);
			document.alert(UtilI18N.internacionaliza(request, "MSG06"));
		}

		document.executeScript("editarPlano();");
	}

	public void editarPlano(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		PlanoMelhoriaDTO planoMelhoriaDTO = (PlanoMelhoriaDTO) document.getBean();

		if (planoMelhoriaDTO.getIdPlanoMelhoria() == null || planoMelhoriaDTO.getIdPlanoMelhoria().intValue() == 0) {
			document.alert(UtilI18N.internacionaliza(request, "planoMelhoria.informevazio"));
			document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
			return;
		}

		planoMelhoriaDTO = (PlanoMelhoriaDTO) getPlanoMelhoriaService().restore(planoMelhoriaDTO);
		document.getForm("form").setValues(planoMelhoriaDTO);
		carregarContratos(planoMelhoriaDTO, document, request);
		atualizarTabelaObjetivos(document, request, response);
		document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
	}

	public void excluirPlano(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		PlanoMelhoriaDTO planoMelhoriaDTO = (PlanoMelhoriaDTO) document.getBean();

		getPlanoMelhoriaService().delete(planoMelhoriaDTO);
		document.executeScript("limparPlano();");

		document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
	}

	// -- OBJETIVO

	public void carregarObjetivos(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		document.getSelectById("objetivos").addOption("-1", UtilI18N.internacionaliza(request, "planoMelhoria.selecioneumobjetivo"));
		PlanoMelhoriaDTO planoMelhoriaDTO = (PlanoMelhoriaDTO) document.getBean();

		List<ObjetivoPlanoMelhoriaDTO> lista = getObjetivoPlanoMelhoriaService().listObjetivosPlanoMelhoria(planoMelhoriaDTO.getIdPlanoMelhoria());
		if (lista != null && lista.size() > 0) {
			for (ObjetivoPlanoMelhoriaDTO dto : lista) {
				document.getSelectById("objetivos").addOption(String.valueOf(dto.getIdObjetivoPlanoMelhoria()), dto.getTituloObjetivo());
			}

			document.executeScript("selecionarObjetivo(" + lista.get(0).getIdObjetivoPlanoMelhoria() + ");");
		}
	}

	public void gravarObjetivo(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		PlanoMelhoriaDTO planoMelhoriaDTO = (PlanoMelhoriaDTO) document.getBean();

		if (UtilNumbersAndDecimals.nullToZero(planoMelhoriaDTO.getIdPlanoMelhoria()).equals(0)) {
			document.alert(UtilI18N.internacionaliza(request, "planoMelhoria.informevazio"));
		} else {

			ObjetivoPlanoMelhoriaDTO objetivoPlanoMelhoriaDTO = new ObjetivoPlanoMelhoriaDTO();
			Reflexao.copyPropertyValues(planoMelhoriaDTO, objetivoPlanoMelhoriaDTO);

			document.executeScript("fecharModalObjetivo()");

			objetivoPlanoMelhoriaDTO.setIdPlanoMelhoria(planoMelhoriaDTO.getIdPlanoMelhoria());
			objetivoPlanoMelhoriaDTO.setModificadoPor(getUsuarioDTO(request).getNomeUsuario());
			objetivoPlanoMelhoriaDTO.setUltModificacao(UtilDatas.getDataAtual());

			if (objetivoPlanoMelhoriaDTO.getIdObjetivoPlanoMelhoria() == null || objetivoPlanoMelhoriaDTO.getIdObjetivoPlanoMelhoria().intValue() == 0) {
				objetivoPlanoMelhoriaDTO.setCriadoPor(getUsuarioDTO(request).getNomeUsuario());
				objetivoPlanoMelhoriaDTO.setDataCriacao(UtilDatas.getDataAtual());
				getObjetivoPlanoMelhoriaService().create(objetivoPlanoMelhoriaDTO);
				document.alert(UtilI18N.internacionaliza(request, "MSG05"));
			} else {
				getObjetivoPlanoMelhoriaService().update(objetivoPlanoMelhoriaDTO);
				document.alert(UtilI18N.internacionaliza(request, "MSG06"));
			}

			HTMLForm form = document.getForm("formObjetivo");
			form.clear();

			refreshTable(document, request, getObjetivoPlanoMelhoriaService().listObjetivosPlanoMelhoriaAsIDto(objetivoPlanoMelhoriaDTO.getIdPlanoMelhoria()), "divTabelaObjetivos");
		}
	}

	public void editarObjetivo(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		PlanoMelhoriaDTO planoMelhoriaDTO = (PlanoMelhoriaDTO) document.getBean();

		if (planoMelhoriaDTO.getIdObjetivoPlanoMelhoria() == null || planoMelhoriaDTO.getIdObjetivoPlanoMelhoria().intValue() == 0) {
			document.alert(UtilI18N.internacionaliza(request, "planoMelhoria.objetivo.informevazio"));
			document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
			return;
		}

		ObjetivoPlanoMelhoriaDTO objetivoPlanoMelhoriaDTO = new ObjetivoPlanoMelhoriaDTO();
		objetivoPlanoMelhoriaDTO.setIdObjetivoPlanoMelhoria(planoMelhoriaDTO.getIdObjetivoPlanoMelhoria());
		objetivoPlanoMelhoriaDTO = (ObjetivoPlanoMelhoriaDTO) getObjetivoPlanoMelhoriaService().restore(objetivoPlanoMelhoriaDTO);
		objetivoPlanoMelhoriaDTO.setIdPlanoMelhoria(objetivoPlanoMelhoriaDTO.getIdPlanoMelhoria());

		addNomeDoResponsavel(document, objetivoPlanoMelhoriaDTO);

		document.getForm("formObjetivo").setValues(objetivoPlanoMelhoriaDTO);
		document.getElementById("idPlanoMelhoria").setValue("" + objetivoPlanoMelhoriaDTO.getIdPlanoMelhoria());
		document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
	}

	private void addNomeDoResponsavel(DocumentHTML document, Responsable dtoAsResponsable) throws LogicException, ServiceException {
		Integer id = dtoAsResponsable.getValidIdResponsavel();
		boolean isGrupo = dtoAsResponsable.isGrupo();
		boolean isResponsavel = dtoAsResponsable.isResponsavel();
		String nomeDoResponsavel = "";

		GrupoDTO grupoDTO = new GrupoDTO();
		EmpregadoDTO empregadoDTO = new EmpregadoDTO();

		if (isGrupo) {
			if (!Util.isNullOrEmpty(document)) {
				document.executeScript("$($('#tipoResponsavel').val()).val('G');");
			}

			grupoDTO.setIdGrupo(id);
			grupoDTO = (GrupoDTO) getGrupoService().restore(grupoDTO);
			if (!Util.isNullOrEmpty(grupoDTO)) {
				nomeDoResponsavel = grupoDTO.getNome();
			}

		} else if (isResponsavel) {
			if (!Util.isNullOrEmpty(document)) {
				document.executeScript("$($('#tipoResponsavel').val()).val('U');");
			}

			empregadoDTO.setIdEmpregado(id);
			empregadoDTO = (EmpregadoDTO) getEmpregadoService().restore(empregadoDTO);
			if (!Util.isNullOrEmpty(empregadoDTO)) {
				nomeDoResponsavel = empregadoDTO.getNome();
			}
		}

		dtoAsResponsable.addNomeDoResponsavel(nomeDoResponsavel);
	}

	public void excluirObjetivo(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		try {
			getObjetivoPlanoMelhoriaService().delete((PlanoMelhoriaDTO) document.getBean());
			refreshTables(document, request, response);
		} catch (Exception e) {
			document.executeScript("alertaAoDeletar()");
		}
	}

	public void atualizarTabelaObjetivos(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		PlanoMelhoriaDTO planoMelhoriaDTO = (PlanoMelhoriaDTO) document.getBean();
		refreshTable(document, request, getObjetivoPlanoMelhoriaService().listObjetivosPlanoMelhoriaAsIDto(planoMelhoriaDTO.getIdPlanoMelhoria()), "divTabelaObjetivos");
	}

	// -- AO

	public void editarAcao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		PlanoMelhoriaDTO planoMelhoriaDTO = (PlanoMelhoriaDTO) document.getBean();

		if (planoMelhoriaDTO.getIdAcaoPlanoMelhoria() == null || planoMelhoriaDTO.getIdAcaoPlanoMelhoria().intValue() == 0) {
			document.alert(UtilI18N.internacionaliza(request, "planoMelhoria.objetivo.informevazio"));
			document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
			return;
		}

		AcaoPlanoMelhoriaDTO acaoPlanoMelhoriaDTO = new AcaoPlanoMelhoriaDTO();
		acaoPlanoMelhoriaDTO.setIdAcaoPlanoMelhoria(planoMelhoriaDTO.getIdAcaoPlanoMelhoria());
		acaoPlanoMelhoriaDTO = (AcaoPlanoMelhoriaDTO) getAcaoPlanoMelhoriaService().restore(acaoPlanoMelhoriaDTO);

		addNomeDoResponsavel(document, acaoPlanoMelhoriaDTO);

		document.getForm("formAcao").setValues(acaoPlanoMelhoriaDTO);
		document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
	}

	public void gravarAcao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		PlanoMelhoriaDTO planoMelhoriaDTO = (PlanoMelhoriaDTO) document.getBean();

		if (planoMelhoriaDTO != null && planoMelhoriaDTO.getIdPlanoMelhoria() != null) {

			AcaoPlanoMelhoriaDTO acaoPlanoMelhoriaDTO = new AcaoPlanoMelhoriaDTO();
			Reflexao.copyPropertyValues(planoMelhoriaDTO, acaoPlanoMelhoriaDTO);

			acaoPlanoMelhoriaDTO.setIdObjetivoPlanoMelhoria(planoMelhoriaDTO.getIdObjetivoPlanoMelhoria());

			ObjetivoPlanoMelhoriaDTO objetivoPlanoMelhoriaDTO = new ObjetivoPlanoMelhoriaDTO();
			objetivoPlanoMelhoriaDTO.setIdObjetivoPlanoMelhoria(planoMelhoriaDTO.getIdObjetivoPlanoMelhoria());
			objetivoPlanoMelhoriaDTO = (ObjetivoPlanoMelhoriaDTO) getObjetivoPlanoMelhoriaService().restore(objetivoPlanoMelhoriaDTO);

			if (objetivoPlanoMelhoriaDTO != null) {
				acaoPlanoMelhoriaDTO.setIdPlanoMelhoria(objetivoPlanoMelhoriaDTO.getIdPlanoMelhoria());
			}

			acaoPlanoMelhoriaDTO.setModificadoPor(getUsuarioDTO(request).getNomeUsuario());
			acaoPlanoMelhoriaDTO.setUltModificacao(UtilDatas.getDataAtual());

			if (acaoPlanoMelhoriaDTO.getIdAcaoPlanoMelhoria() == null || acaoPlanoMelhoriaDTO.getIdAcaoPlanoMelhoria().intValue() == 0) {
				acaoPlanoMelhoriaDTO.setCriadoPor(getUsuarioDTO(request).getNomeUsuario());
				acaoPlanoMelhoriaDTO.setDataCriacao(UtilDatas.getDataAtual());
				acaoPlanoMelhoriaDTO.setTituloAcao(planoMelhoriaDTO.getTituloAcao());
				acaoPlanoMelhoriaDTO.setResponsavelAcao(planoMelhoriaDTO.getResponsavelAcao());
				getAcaoPlanoMelhoriaService().create(acaoPlanoMelhoriaDTO);
				document.alert(UtilI18N.internacionaliza(request, "MSG05"));
			} else {
				getAcaoPlanoMelhoriaService().update(acaoPlanoMelhoriaDTO);
				document.alert(UtilI18N.internacionaliza(request, "MSG06"));
			}

			document.executeScript("fecharModalAcao()");

			atualizarTabelaAcoes(document, request, response);
		}
	}

	private void atualizarTabelaAcoes(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		PlanoMelhoriaDTO dto = (PlanoMelhoriaDTO) document.getBean();
		refreshTable(document, request, getAcaoPlanoMelhoriaService().listAcaoPlanoMelhoriaAsIDto(dto.getIdObjetivoPlanoMelhoria()), "divTabelaAcoes");
	}

	public void excluirAcao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		getAcaoPlanoMelhoriaService().delete((PlanoMelhoriaDTO) document.getBean());
		atualizarTabelaAcoes(document, request, response);
	}

	// -- MONITORAMENTO

	private void atualizarTabelaMonitoramento(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		PlanoMelhoriaDTO dto = (PlanoMelhoriaDTO) document.getBean();
		refreshTable(document, request, getObjetivoMonitoramentoService().listObjetivosMonitoramentoAsDTO(dto.getIdObjetivoPlanoMelhoria()), "divTabelaMonitoramento");
	}

	public void editarMonitoramento(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		PlanoMelhoriaDTO planoMelhoriaDTO = (PlanoMelhoriaDTO) document.getBean();

		if (planoMelhoriaDTO.getIdObjetivoMonitoramento() == null || planoMelhoriaDTO.getIdObjetivoMonitoramento().intValue() == 0) {
			document.alert(UtilI18N.internacionaliza(request, "planoMelhoria.monitoramento.informevazio"));
			document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
			return;
		}

		ObjetivoMonitoramentoDTO objetivoMonitoramentoDTO = new ObjetivoMonitoramentoDTO();
		objetivoMonitoramentoDTO.setIdObjetivoMonitoramento(planoMelhoriaDTO.getIdObjetivoMonitoramento());
		objetivoMonitoramentoDTO = (ObjetivoMonitoramentoDTO) getObjetivoMonitoramentoService().restore(objetivoMonitoramentoDTO);

		addNomeDoResponsavel(document, objetivoMonitoramentoDTO);

		objetivoMonitoramentoDTO.setKpi(null);

		document.getForm("formMonitoramento").setValues(objetivoMonitoramentoDTO);
		document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();

		atualizarTabelaMonitoramento(document, request, response);
		atualizarTabelaKpi(document, request, response);
	}

	public boolean gravarMonitoramentoComValidacaoDeKpi(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		PlanoMelhoriaDTO dto = (PlanoMelhoriaDTO) document.getBean();
		if (getKpiObjetivoMonitoramentoService().hasKpi(dto.getIdObjetivoMonitoramento())) {
			if (gravarMonitoramento(document, request, response)) {
				document.alert(UtilI18N.internacionaliza(request, "MSG05"));
			} else {
				document.alert(UtilI18N.internacionaliza(request, "MSG06"));
			}

			document.executeScript("fecharModalMonitoramento()");
			atualizarTabelaMonitoramento(document, request, response);
			return true;
		} else {
			document.executeScript("alert(i18n_message('acordoNivelServico.informarCampos'));");
			return false;
		}
	}

	private boolean gravarMonitoramento(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		PlanoMelhoriaDTO planoMelhoriaDTO = (PlanoMelhoriaDTO) document.getBean();

		ObjetivoMonitoramentoDTO objetivoMonitoramentoDTO = new ObjetivoMonitoramentoDTO();
		Reflexao.copyPropertyValues(planoMelhoriaDTO, objetivoMonitoramentoDTO);

		objetivoMonitoramentoDTO.setIdObjetivoPlanoMelhoria(planoMelhoriaDTO.getIdObjetivoPlanoMelhoria());
		objetivoMonitoramentoDTO.setModificadoPor(getUsuarioDTO(request).getNomeUsuario());
		objetivoMonitoramentoDTO.setUltModificacao(UtilDatas.getDataAtual());

		boolean isNovo = false;

		if (objetivoMonitoramentoDTO.getIdObjetivoMonitoramento() == null || objetivoMonitoramentoDTO.getIdObjetivoMonitoramento().intValue() == 0) {
			// Criar Monitoramento
			objetivoMonitoramentoDTO.setCriadoPor(getUsuarioDTO(request).getNomeUsuario());
			objetivoMonitoramentoDTO.setDataCriacao(UtilDatas.getDataAtual());
			objetivoMonitoramentoDTO.setMedicaoMonitoramento(planoMelhoriaDTO.getMedicaoMonitoramento());

			objetivoMonitoramentoDTO = getObjetivoMonitoramentoService().create(objetivoMonitoramentoDTO);

			if (objetivoMonitoramentoDTO != null && objetivoMonitoramentoDTO.getIdObjetivoMonitoramento() != null) {
				planoMelhoriaDTO.setIdObjetivoMonitoramento(objetivoMonitoramentoDTO.getIdObjetivoMonitoramento());
			}

			isNovo = true;

		} else {
			// Editar Monitoramento
			getObjetivoMonitoramentoService().update(objetivoMonitoramentoDTO);
			isNovo = false;
		}

		HTMLForm form = document.getForm("formMonitoramento");
		form.setValues(objetivoMonitoramentoDTO);

		if (objetivoMonitoramentoDTO != null) {
			document.getElementById("idObjetivoMonitoramento").setValue(String.valueOf(objetivoMonitoramentoDTO.getIdObjetivoMonitoramento()));
		}

		atualizarTabelaMonitoramento(document, request, response);

		return isNovo;
	}

	public void excluirMonitoramento(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		PlanoMelhoriaDTO dto = (PlanoMelhoriaDTO) document.getBean();
		Collection<KpiObjetivoMonitoramentoDTO> lista = getKpiObjetivoMonitoramentoService().listKpiObjetivosMonitoramento(dto.getIdObjetivoMonitoramento());
		if (!Util.isNullOrEmpty(lista)) {
			for (KpiObjetivoMonitoramentoDTO kpi : lista) {
				getKpiObjetivoMonitoramentoService().deleteByIdKpiObjetivosMonitoramento(kpi.getIdKpiObjetivoMonitoramento());
			}
		}
		ObjetivoMonitoramentoDTO objetivo = new ObjetivoMonitoramentoDTO();
		Reflexao.copyPropertyValues(dto, objetivo);
		getObjetivoMonitoramentoService().delete(objetivo);
		atualizarTabelaMonitoramento(document, request, response);
	}

	// -- RELATRIO

	public void gerarRelatorioEmPDF(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		HttpSession session = request.getSession();
		PlanoMelhoriaDTO planoMelhoriaDTO = (PlanoMelhoriaDTO) document.getBean();

		if (planoMelhoriaDTO.getIdPlanoMelhoria() == null) {
			document.alert(UtilI18N.internacionaliza(request, "planoMelhoria.informevazio"));
			document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
			return;
		}

		ObjetivoPlanoMelhoriaDTO objetivoPlanoMelhoriaDto = new ObjetivoPlanoMelhoriaDTO();
		AcaoPlanoMelhoriaDTO acaoPlanoMelhoriaDto = new AcaoPlanoMelhoriaDTO();
		ObjetivoMonitoramentoDTO objetivoMonitoramentoDto = new ObjetivoMonitoramentoDTO();

		List<ObjetivoPlanoMelhoriaDTO> listObjetivosPlanoMelhoriaPrincipal = new ArrayList<>();
		Collection<ObjetivoMonitoramentoDTO> listObjetivosMonitoramento = null;
		List<AcaoPlanoMelhoriaDTO> listAcaoPlanoMelhoria = null;
		Collection<ObjetivoPlanoMelhoriaDTO> listDeTituloDeObjetoPlanoMelhoria = new ArrayList<ObjetivoPlanoMelhoriaDTO>();
		Collection<ObjetivoMonitoramentoDTO> listGeralDeObjetivoMelhoria = new ArrayList<ObjetivoMonitoramentoDTO>();

		Integer contObjetivo = 0;
		Integer contObjetivoMonitoramento = 0;
		Integer contAcao = 0;

		if (planoMelhoriaDTO.getIdPlanoMelhoria() != null) {
			planoMelhoriaDTO = (PlanoMelhoriaDTO) getPlanoMelhoriaService().restore(planoMelhoriaDTO);

			objetivoPlanoMelhoriaDto.setIdPlanoMelhoria(planoMelhoriaDTO.getIdPlanoMelhoria());
			acaoPlanoMelhoriaDto.setIdPlanoMelhoria(planoMelhoriaDTO.getIdPlanoMelhoria());
		}

		if (objetivoPlanoMelhoriaDto.getIdPlanoMelhoria() != null) {
			listObjetivosPlanoMelhoriaPrincipal.addAll(getObjetivoPlanoMelhoriaService().listObjetivosPlanoMelhoria(objetivoPlanoMelhoriaDto.getIdPlanoMelhoria()));
		}

		if (listObjetivosPlanoMelhoriaPrincipal != null && !listObjetivosPlanoMelhoriaPrincipal.isEmpty()) {

			for (ObjetivoPlanoMelhoriaDTO objPlanoMelhoria : listObjetivosPlanoMelhoriaPrincipal) {
				contAcao = 0;
				contObjetivo++;

				ObjetivoPlanoMelhoriaDTO obj = new ObjetivoPlanoMelhoriaDTO();

				obj.setTituloObjetivo(objPlanoMelhoria.getTituloObjetivo());
				obj.setSequencialObjetivo(contObjetivo);

				objPlanoMelhoria.setSequencialObjetivo(contObjetivo);

				planoMelhoriaDTO.setResponsavelObjetivo(objPlanoMelhoria.getResponsavelObjetivo());

				if (objPlanoMelhoria.getIdObjetivoPlanoMelhoria() != null) {
					acaoPlanoMelhoriaDto.setIdObjetivoPlanoMelhoria(objPlanoMelhoria.getIdObjetivoPlanoMelhoria());
					listAcaoPlanoMelhoria = getAcaoPlanoMelhoriaService().listAcaoPlanoMelhoria(objPlanoMelhoria.getIdObjetivoPlanoMelhoria());
					objetivoMonitoramentoDto.setIdObjetivoPlanoMelhoria(objPlanoMelhoria.getIdObjetivoPlanoMelhoria());
					listObjetivosMonitoramento = getObjetivoMonitoramentoService().listObjetivosMonitoramento(objetivoMonitoramentoDto.getIdObjetivoPlanoMelhoria());
					addNomeDoResponsavel(null, objPlanoMelhoria);
				}

				if (listAcaoPlanoMelhoria != null) {
					for (AcaoPlanoMelhoriaDTO acao : listAcaoPlanoMelhoria) {
						contAcao++;
						acao.setSequencialObjetivo(objPlanoMelhoria.getSequencialObjetivo());
						acao.setSequencialAcao(contAcao);
						acao.setResultadoEsperadoPlanoMelhoria(objPlanoMelhoria.getResultadoEsperado());
						acao.setMedicaoPlanoMelhoria(objPlanoMelhoria.getMedicaoObjetivo());
					}
				}

				if (listObjetivosMonitoramento != null) {
					for (ObjetivoMonitoramentoDTO objetivoMonitoramento : listObjetivosMonitoramento) {
						contObjetivoMonitoramento++;
						objetivoMonitoramento.setSequecialObjetivoMonitoramento(contObjetivoMonitoramento);
						objetivoMonitoramento.setTituloObjetivoPlanoMelhoria(objPlanoMelhoria.getTituloObjetivo());
						objetivoMonitoramento.setKpi(getKpiObjetivoMonitoramentoService().getKpis(objetivoMonitoramento.getIdObjetivoMonitoramento()));
						addNomeDoResponsavel(null, objetivoMonitoramento);
					}

					listGeralDeObjetivoMelhoria.addAll(listObjetivosMonitoramento);
				}

				listDeTituloDeObjetoPlanoMelhoria.add(obj);
				objPlanoMelhoria.setListObjetivosPlanoMelhoria(listDeTituloDeObjetoPlanoMelhoria);
				objPlanoMelhoria.setListAcaoPlanoMelhoria(listAcaoPlanoMelhoria);
				objPlanoMelhoria.setListObjetivosMonitoramento(listObjetivosMonitoramento);

			}

		}

		Date dt = new Date();
		String strCompl = "" + dt.getTime();
		String caminhoJasper = CITCorporeUtil.CAMINHO_REAL_APP + Constantes.getValue("CAMINHO_RELATORIOS") + "PlanoMelhoriaServicos.jasper";
		String caminhoSubRelatorioJasper = CITCorporeUtil.CAMINHO_REAL_APP + Constantes.getValue("CAMINHO_RELATORIOS");
		String diretorioReceita = CITCorporeUtil.CAMINHO_REAL_APP + "/tempFiles";
		String diretorioRelativoOS = Constantes.getValue("SERVER_ADDRESS") + Constantes.getValue("CONTEXTO_APLICACAO") + "/tempFiles";

		Map<String, Object> parametros = new HashMap<String, Object>();
		parametros = UtilRelatorio.trataInternacionalizacaoLocale(session, parametros);

		parametros.put("SUBREPORT_DIR", caminhoSubRelatorioJasper);
		parametros.put("purpose", planoMelhoriaDTO.getObjetivo());
		parametros.put("overview", planoMelhoriaDTO.getVisaoGeral());
		parametros.put("scope", planoMelhoriaDTO.getEscopo());
		parametros.put("vision", planoMelhoriaDTO.getVisao());
		parametros.put("mission", planoMelhoriaDTO.getMissao());
		parametros.put("serviceImprovementPlan", planoMelhoriaDTO.getTitulo());
		parametros.put("startDate", planoMelhoriaDTO.getDataInicioPlano());
		parametros.put("endDate", planoMelhoriaDTO.getDataFimPlano());
		parametros.put("responsible", planoMelhoriaDTO.getResponsavelObjetivo());
		parametros.put("listObjetivosMonitoramento", listGeralDeObjetivoMelhoria);
		parametros.put("caminhoLogo", CITCorporeUtil.CAMINHO_REAL_APP + "//imagens//logo//logo.png");

		JRDataSource dataSource = null;

		if (listObjetivosPlanoMelhoriaPrincipal != null) {
			dataSource = new JRBeanCollectionDataSource(listObjetivosPlanoMelhoriaPrincipal);
		}

		JasperPrint print = JasperFillManager.fillReport(caminhoJasper, parametros, dataSource);
		JasperExportManager.exportReportToPdfFile(print, diretorioReceita + "/PlanoMelhoriaServicos" + strCompl + "_" + getUsuarioDTO(request).getIdUsuario() + ".pdf");

		document.executeScript("window.open('" + Constantes.getValue("SERVER_ADDRESS") + Constantes.getValue("CONTEXTO_APLICACAO") + "/printPDF/printPDF.jsp?url=" + diretorioRelativoOS + "/PlanoMelhoriaServicos" + strCompl + "_" + getUsuarioDTO(request).getIdUsuario() + ".pdf')");
		document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
	}

	// --- MANIPULANDO <TABLE>

	private void refreshTable(DocumentHTML document, HttpServletRequest request, List<IDto> lista, String nomeDivDestinoTableGerada) throws Exception {
		HTMLElement divDinamico = document.getElementById(nomeDivDestinoTableGerada);
		String listaVazia = "<h4><i>" + UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "citcorpore.comum.listavazia")) + "</i></h4>";
		divDinamico.setInnerHTML(!Util.isNullOrEmpty(lista) && lista.size() > 0 ? gerarHTML(document, request, lista) : listaVazia);
	}

	private String gerarHTML(DocumentHTML document, HttpServletRequest request, List<IDto> lista) throws LogicException, ServiceException {
		StringBuilder sb = new StringBuilder();
		adicionarCabecalhoTabela(sb, request);
		adicionarDadosTabela(sb, request, document, lista);
		adicionarFimTabela(sb);
		return sb.toString();
	}

	private void adicionarCabecalhoTabela(StringBuilder sb, HttpServletRequest request) {
		sb.append("<div class='row-fluid' id='divTabela'> ");
		sb.append("	<div class=\"table-responsive tabela\">");
		sb.append("		<table class=\"table table-bordered table-striped table-condensed table-vertical-center checkboxs js-table-sortable ui-sortable\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th>" + UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "lookup.nome")) + "</th> ");
		sb.append("					<th class=\"center\" style=\"width:15%;\">" + UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "baseConhecimentoView.acoes")) + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
	}

	private void adicionarFimTabela(StringBuilder sb) {
		sb.append("</table>");
		sb.append("	</div>");
		sb.append("</div>");
	}

	private void adicionarDadosTabela(StringBuilder sb, HttpServletRequest request, DocumentHTML document, List<IDto> lista) throws LogicException, ServiceException {
		PlanoMelhoriaDTO planoMelhoriaDTO = (PlanoMelhoriaDTO) document.getBean();
		permissao = new Permissoes(document, request);

		if (!Util.isNullOrEmpty(lista)) {
			for (IDto dto : lista) {
				if (!Util.isNullOrEmpty(dto)) {

					String titulo = null;
					Integer id = null;
					boolean isObjetivo = dto instanceof ObjetivoPlanoMelhoriaDTO;
					boolean isSelecionado = false;
					boolean isAcao = dto instanceof AcaoPlanoMelhoriaDTO;
					boolean isMonitoramento = dto instanceof ObjetivoMonitoramentoDTO;
					boolean isKpi = dto instanceof KpiObjetivoMonitoramentoDTO;

					if (isObjetivo) {
						titulo = ((ObjetivoPlanoMelhoriaDTO) dto).getTituloObjetivo();
						id = ((ObjetivoPlanoMelhoriaDTO) dto).getIdObjetivoPlanoMelhoria();

						if (!Util.isNullOrEmpty(planoMelhoriaDTO) && planoMelhoriaDTO.getIdObjetivoPlanoMelhoria() != null) {
							isSelecionado = planoMelhoriaDTO.getIdObjetivoPlanoMelhoria().intValue() == id.intValue();
						}

					} else if (isAcao) {
						titulo = ((AcaoPlanoMelhoriaDTO) dto).getTituloAcao();
						id = ((AcaoPlanoMelhoriaDTO) dto).getIdAcaoPlanoMelhoria();

					} else if (isMonitoramento) {
						titulo = ((ObjetivoMonitoramentoDTO) dto).getTituloMonitoramento();
						id = ((ObjetivoMonitoramentoDTO) dto).getIdObjetivoMonitoramento();

					} else if (isKpi) {
						titulo = ((KpiObjetivoMonitoramentoDTO) dto).getKpi();
						id = ((KpiObjetivoMonitoramentoDTO) dto).getIdKpiObjetivoMonitoramento();
					}

					sb.append("<tbody>");
					sb.append("	<tr>");
					sb.append("		<td>");
					sb.append(titulo);
					sb.append("		</td>");
					sb.append("     <td class=\"center\" style=\"width:15%;\" > ");

					// EDITAR
					if (permissao.isGravar() && !isKpi) {
						sb.append("         <a class=\"btn-action glyphicons pencil btn-default\" key=\"");
						sb.append(UtilI18N.internacionaliza(request, "citcorpore.comum.editar"));
						sb.append("\"");
						sb.append(" onclick=\"");

						if (isObjetivo) {
							sb.append("editarObjetivo(");
						} else if (isAcao) {
							sb.append("editarAcao(");
						} else if (isMonitoramento) {
							sb.append("editarMonitoramento(");
						}

						sb.append(id);
						sb.append(")\"");
						sb.append(" onmouseout=\"fechaTooltip()\" onmouseover=\"abreTooltip(this, '");
						sb.append(UtilI18N.internacionaliza(request, "citcorpore.comum.editar"));
						sb.append("')\"");
						sb.append("          class=\"btn-action glyphicons pencil btn-default\"><i></i></a> ");
					}

					//DELETAR
					if (permissao.isDeletar()) {
						sb.append("         <a class=\"btn-action glyphicons remove_2 btn-default\" key=\"");
						sb.append(UtilI18N.internacionaliza(request, "botaoacaovisao.excluir"));
						sb.append("\"");
						sb.append(" onclick=\"");

						if (isObjetivo) {
							sb.append("excluirObjetivo(");
						} else if (isAcao) {
							sb.append("excluirAcao(");
						} else if (isMonitoramento) {
							sb.append("excluirMonitoramento(");
						} else if (isKpi) {
							sb.append("excluirKpi(");
						}

						sb.append(id);
						sb.append(")\" ");
						sb.append(" onmouseout=\"fechaTooltip()\" onmouseover=\"abreTooltip(this, '");
						sb.append(UtilI18N.internacionaliza(request, "botaoacaovisao.excluir"));
						sb.append("')\"");
						sb.append("          class=\"btn-action glyphicons remove_2 btn-default\"><i></i></a> ");
					}

					// SELECIONAR
					if (isObjetivo && !isKpi) {
						String classe = isSelecionado ? "btn-action glyphicons circle_ok btn-primary" : "btn-action glyphicons circle_ok btn-default";

						sb.append("<a id=\"button");
						sb.append(id);
						sb.append("\" class=\"");
						sb.append(classe);
						sb.append("\" ");
						sb.append("key=\"");
						sb.append(UtilI18N.internacionaliza(request, "citcorpore.comum.selecionar"));
						sb.append("\"");
						sb.append(" onclick=\"");
						sb.append("selecionarObjetivo(");
						sb.append(id);
						sb.append(")\"");
						sb.append(" onmouseout=\"fechaTooltip()\" onmouseover=\"abreTooltip(this, '");
						sb.append(UtilI18N.internacionaliza(request, "citcorpore.comum.selecionar"));
						sb.append("')\">");
						sb.append("<i></i></a> ");
					}

					sb.append("		</td>");
					sb.append("	</tr>");
					sb.append("</tbody>");
				}
			}
		}
	}

	public void refreshTables(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		atualizarTabelaMonitoramento(document, request, response);
		atualizarTabelaObjetivos(document, request, response);
		atualizarTabelaAcoes(document, request, response);
	}

	// --- KPI
	public void gravarKpi(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		KpiObjetivoMonitoramentoDTO kpi = new KpiObjetivoMonitoramentoDTO();
		PlanoMelhoriaDTO planoMelhoriaDTO = (PlanoMelhoriaDTO) document.getBean();

		kpi.setKpi(planoMelhoriaDTO.getKpi());
		kpi.setIdObjetivoMonitoramento(planoMelhoriaDTO.getIdObjetivoMonitoramento());
		kpi.setCriadoPor(getUsuarioDTO(request).getNomeUsuario());

		try {
			getKpiObjetivoMonitoramentoService().create(kpi);
			document.alert(UtilI18N.internacionaliza(request, "MSG05"));
			atualizarTabelaKpi(document, request, response);
			document.executeScript("$('#kpi').val(null);");
		} catch (Exception e) {
			document.alert(UtilI18N.internacionaliza(request, "MSE02"));
		}

		atualizarTabelaKpi(document, request, response);
	}

	public void excluirKpi(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		getKpiObjetivoMonitoramentoService().delete((PlanoMelhoriaDTO) document.getBean());
		document.executeScript("fechaTooltip()");
		atualizarTabelaKpi(document, request, response);
	}

	public void atualizarTabelaKpi(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws PersistenceException, ServiceException, Exception {
		PlanoMelhoriaDTO planoMelhoriaDTO = (PlanoMelhoriaDTO) document.getBean();
		refreshTable(document, request, getKpiObjetivoMonitoramentoService().listKpiObjetivosMonitoramentoAsDTO(planoMelhoriaDTO.getIdObjetivoMonitoramento()), "divTabelaKpi");
	}

	public void gravarPrimeiroKpi(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (gravarMonitoramento(document, request, response)) {
			gravarKpi(document, request, response);
			atualizarTabelaKpi(document, request, response);
		}
	}

	// --- SERVICES

	public ObjetivoPlanoMelhoriaService getObjetivoPlanoMelhoriaService() throws ServiceException {
		return Util.isNullOrEmpty(objetivoPlanoMelhoriaService) ? objetivoPlanoMelhoriaService = (ObjetivoPlanoMelhoriaService) ServiceLocator.getInstance().getService(ObjetivoPlanoMelhoriaService.class, null) : objetivoPlanoMelhoriaService;
	}

	public PlanoMelhoriaService getPlanoMelhoriaService() throws ServiceException {
		return Util.isNullOrEmpty(planoMelhoriaService) ? planoMelhoriaService = (PlanoMelhoriaService) ServiceLocator.getInstance().getService(PlanoMelhoriaService.class, null) : planoMelhoriaService;
	}

	public KpiObjetivoMonitoramentoService getKpiObjetivoMonitoramentoService() throws ServiceException {
		return Util.isNullOrEmpty(kpiService) ? kpiService = (KpiObjetivoMonitoramentoService) ServiceLocator.getInstance().getService(KpiObjetivoMonitoramentoService.class, null) : kpiService;
	}

	public GrupoService getGrupoService() throws ServiceException {
		return Util.isNullOrEmpty(grupoService) ? grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null) : grupoService;
	}

	public EmpregadoService getEmpregadoService() throws ServiceException {
		return Util.isNullOrEmpty(empregadoService) ? empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, null) : empregadoService;
	}

	public AcaoPlanoMelhoriaService getAcaoPlanoMelhoriaService() throws ServiceException {
		return Util.isNullOrEmpty(acaoPlanoMelhoriaService) ? acaoPlanoMelhoriaService = (AcaoPlanoMelhoriaService) ServiceLocator.getInstance().getService(AcaoPlanoMelhoriaService.class, null) : acaoPlanoMelhoriaService;
	}

	public ObjetivoMonitoramentoService getObjetivoMonitoramentoService() throws ServiceException {
		return Util.isNullOrEmpty(objetivoMonitoramentoService) ? objetivoMonitoramentoService = (ObjetivoMonitoramentoService) ServiceLocator.getInstance().getService(ObjetivoMonitoramentoService.class, null) : objetivoMonitoramentoService;
	}

	public FornecedorService getFornecedorService() throws ServiceException {
		return Util.isNullOrEmpty(fornecedorService) ? fornecedorService = (FornecedorService) ServiceLocator.getInstance().getService(FornecedorService.class, null) : fornecedorService;
	}

	public ContratoService getContratoService() throws ServiceException {
		return Util.isNullOrEmpty(contratoService) ? contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null) : contratoService;
	}
}