package br.com.centralit.citcorpore.ajaxForms;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.AcaoPlanoMelhoriaDTO;
import br.com.centralit.citcorpore.bean.ObjetivoMonitoramentoDTO;
import br.com.centralit.citcorpore.bean.ObjetivoPlanoMelhoriaDTO;
import br.com.centralit.citcorpore.bean.PlanoMelhoriaDTO;
import br.com.centralit.citcorpore.negocio.AcaoPlanoMelhoriaService;
import br.com.centralit.citcorpore.negocio.ObjetivoMonitoramentoService;
import br.com.centralit.citcorpore.negocio.ObjetivoPlanoMelhoriaService;
import br.com.centralit.citcorpore.negocio.PlanoMelhoriaService;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilStrings;

public class PlanoMelhoriaTreeView extends AjaxFormAction{
	private static boolean DEBUG = true;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		HashMap hashValores = getFormFields(request);
		if (DEBUG){
			debugValuesFromRequest(hashValores);
		}
		String idStr = (String) hashValores.get("ID");
		int id = -1;
		try{
			id = Integer.parseInt(UtilStrings.apenasNumeros(idStr));
		}catch(Exception e){}
		PlanoMelhoriaService planoMelhoriaService = (PlanoMelhoriaService) ServiceLocator.getInstance().getService(PlanoMelhoriaService.class, null);
		ObjetivoPlanoMelhoriaService objetivoPlanoMelhoriaService = (ObjetivoPlanoMelhoriaService) ServiceLocator.getInstance().getService(ObjetivoPlanoMelhoriaService.class, null);
		AcaoPlanoMelhoriaService acaoPlanoMelhoriaService = (AcaoPlanoMelhoriaService) ServiceLocator.getInstance().getService(AcaoPlanoMelhoriaService.class, null);
		ObjetivoMonitoramentoService objetivoMonitoramentoService = (ObjetivoMonitoramentoService) ServiceLocator.getInstance().getService(ObjetivoMonitoramentoService.class, null);
		StringBuilder strCab = new StringBuilder();
		String tit = "";
		if (id == -1){
			strCab.append("[{");
			strCab.append("\"id\":-1,");
			strCab.append("\"text\":\"" + UtilI18N.internacionaliza(request, "planoMelhoria.list") + "\",");
			strCab.append("\"children\":[");
			Collection colsPlanos = planoMelhoriaService.list();
			if (colsPlanos != null){
				boolean bPrim = true;
				for (Iterator it = colsPlanos.iterator(); it.hasNext();){
					PlanoMelhoriaDTO planoMelhoriaDTO = (PlanoMelhoriaDTO)it.next();
					if (!bPrim){
						strCab.append(",");
					}
					tit = planoMelhoriaDTO.getTitulo();
					tit = tit.replaceAll("\"", "");
					strCab.append("{");
					strCab.append("\"id\":" + planoMelhoriaDTO.getIdPlanoMelhoria() + ",");
					strCab.append("\"text\":\"" + tit + "\",");
					strCab.append("\"state\":\"closed\",");
					strCab.append("\"iconCls\":\"icon-melhoria\"");
					strCab.append("}");
					bPrim = false;
				}
			}
			strCab.append("]");
			strCab.append("}]");
		}else{
			if (idStr.indexOf("EDITAR-") > -1){
				document.executeScript("editaContrato('" + id + "')");
			}else if (idStr.indexOf("OBJ-") > -1){
				strCab.append("[");
				strCab.append("{");
				strCab.append("\"id\":\"NOVOOBJ-" + id + "\",");
				strCab.append("\"text\":\"" + UtilI18N.internacionaliza(request, "plano.melhoria.novo") + "\"");
				strCab.append("}");
				Collection colObjetivos = objetivoPlanoMelhoriaService.findByIdPlanoMelhoria(id);
				if (colObjetivos != null){
					for (Iterator it = colObjetivos.iterator(); it.hasNext();){
						ObjetivoPlanoMelhoriaDTO objetivoPlanoMelhoriaDTO = (ObjetivoPlanoMelhoriaDTO)it.next();
						tit = objetivoPlanoMelhoriaDTO.getTituloObjetivo();
						tit = tit.replaceAll("\"", "");
						strCab.append(",");
						strCab.append("{");
						strCab.append("\"id\":\"OBJEDT-" + objetivoPlanoMelhoriaDTO.getIdObjetivoPlanoMelhoria() + "\",");
						strCab.append("\"text\":\"" + tit + "\",");
						strCab.append("\"iconCls\":\"icon-objetivo\",");
						strCab.append("\"state\":\"closed\"");
						strCab.append("}");
					}
				}
				strCab.append("]");
			}else if (idStr.indexOf("OBJEDT-") > -1){
				strCab.append("[");
				strCab.append("{");
				strCab.append("\"id\":\"EDITAROBJ-" + id + "\",");
				strCab.append("\"text\":\"" + UtilI18N.internacionaliza(request, "plano.melhoria.editar") + "\",");
				strCab.append("\"iconCls\":\"icon-edit\"");
				strCab.append("},");
				strCab.append("{");
				strCab.append("\"id\":\"ACT-" + id + "\",");
				strCab.append("\"text\":\"" + UtilI18N.internacionaliza(request, "plano.melhoria.acoes") + "\",");
				strCab.append("\"iconCls\":\"icon-acoes\",");
				strCab.append("\"state\":\"closed\"");
				strCab.append("},");
				strCab.append("{");
				strCab.append("\"id\":\"MON-" + id + "\",");
				strCab.append("\"text\":\"" + UtilI18N.internacionaliza(request, "plano.melhoria.monitoramento") + "\",");
				strCab.append("\"iconCls\":\"icon-eyes\",");
				strCab.append("\"state\":\"closed\"");
				strCab.append("}");
				strCab.append("]");
			}else if (idStr.indexOf("ACT-") > -1){
				strCab.append("[");
				strCab.append("{");
				strCab.append("\"id\":\"NOVAACT-" + id + "\",");
				strCab.append("\"text\":\"" + UtilI18N.internacionaliza(request, "plano.melhoria.nova") + "\"");
				strCab.append("}");
				Collection colAcoes = acaoPlanoMelhoriaService.findByIdObjetivoPlanoMelhoria(id);
				if (colAcoes != null){
					for (Iterator it = colAcoes.iterator(); it.hasNext();){
						AcaoPlanoMelhoriaDTO acaoPlanoMelhoriaDTO = (AcaoPlanoMelhoriaDTO)it.next();
						tit = acaoPlanoMelhoriaDTO.getTituloAcao();
						tit = tit.replaceAll("\"", "");
						strCab.append(",");
						strCab.append("{");
						strCab.append("\"id\":\"ACTEDT-" + acaoPlanoMelhoriaDTO.getIdAcaoPlanoMelhoria() + "\",");
						strCab.append("\"text\":\"" + tit + "\",");
						strCab.append("\"iconCls\":\"icon-acao\"");
						strCab.append("}");
					}
				}
				strCab.append("]");
			}else if (idStr.indexOf("MON-") > -1){
				strCab.append("[");
				strCab.append("{");
				strCab.append("\"id\":\"NOVOMON-" + id + "\",");
				strCab.append("\"text\":\"" + UtilI18N.internacionaliza(request, "plano.melhoria.novo") + "\"");
				strCab.append("}");
				Collection colAcoes = objetivoMonitoramentoService.findByIdObjetivoPlanoMelhoria(id);
				if (colAcoes != null){
					for (Iterator it = colAcoes.iterator(); it.hasNext();){
						ObjetivoMonitoramentoDTO objetivoMonitoramentoDTO = (ObjetivoMonitoramentoDTO)it.next();
						tit = objetivoMonitoramentoDTO.getTituloMonitoramento();
						tit = tit.replaceAll("\"", "");
						strCab.append(",");
						strCab.append("{");
						strCab.append("\"id\":\"MONEDT-" + objetivoMonitoramentoDTO.getIdObjetivoMonitoramento() + "\",");
						strCab.append("\"text\":\"" + tit + "\",");
						strCab.append("\"iconCls\":\"icon-eye\"");
						strCab.append("}");
					}
				}
				strCab.append("]");
			}else{
				strCab.append("[");
				strCab.append("{");
				strCab.append("\"id\":\"EDITAR-" + id + "\",");
				strCab.append("\"text\":\"" + UtilI18N.internacionaliza(request, "plano.melhoria.editar") + "\",");
				strCab.append("\"iconCls\":\"icon-edit\"");
				strCab.append("},");
				strCab.append("{");
				strCab.append("\"id\":\"OBJ-" + id + "\",");
				strCab.append("\"text\":\"" + UtilI18N.internacionaliza(request, "plano.melhoria.objetivos") + "\",");
				strCab.append("\"iconCls\":\"icon-objetivos\",");
				strCab.append("\"state\":\"closed\"");
				strCab.append("}");
				strCab.append("]");
			}
		}

		request.setAttribute("json_retorno", strCab.toString());
	}

	@Override
	public Class getBeanClass() {
		return PlanoMelhoriaDTO.class;
	}
	private HashMap getFormFields(HttpServletRequest req){
		try {
			req.setCharacterEncoding("ISO-8859-1");
		} catch (UnsupportedEncodingException e) {
			System.out.println("PROBLEMA COM CODIFICACAO DE CARACTERES!!! [AjaxProcessEvent.getFormFields()]");
			e.printStackTrace();
		}
		HashMap formFields = new HashMap();
		Enumeration en = req.getParameterNames();
		String[] strValores;
		while(en.hasMoreElements()) {
			String nomeCampo  = (String)en.nextElement();
			strValores = req.getParameterValues(nomeCampo);
			if (strValores.length == 0){
				formFields.put(nomeCampo.toUpperCase(),UtilStrings.decodeCaracteresEspeciais(req.getParameter(nomeCampo)));
			} else {
				if (strValores.length == 1){
					formFields.put(nomeCampo.toUpperCase(),UtilStrings.decodeCaracteresEspeciais(strValores[0]));
				}else{
					formFields.put(nomeCampo.toUpperCase(),strValores);
				}
			}
		}
		return formFields;
	}

}
