package br.com.centralit.citcorpore.ajaxForms;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

import com.google.gson.Gson;

import br.com.centralit.bpm.dto.TarefaFluxoDTO;
import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citajax.html.HTMLTable;
import br.com.centralit.citcorpore.bean.BaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.CalendarioDTO;
import br.com.centralit.citcorpore.bean.CategoriaOcorrenciaDTO;
import br.com.centralit.citcorpore.bean.CategoriaProblemaDTO;
import br.com.centralit.citcorpore.bean.CategoriaServicoDTO;
import br.com.centralit.citcorpore.bean.CausaIncidenteDTO;
import br.com.centralit.citcorpore.bean.ContratoDTO;
import br.com.centralit.citcorpore.bean.EmailSolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.EmpregadoDTO;
import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.ItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.JustificativaProblemaDTO;
import br.com.centralit.citcorpore.bean.LocalidadeDTO;
import br.com.centralit.citcorpore.bean.LocalidadeUnidadeDTO;
import br.com.centralit.citcorpore.bean.OcorrenciaProblemaDTO;
import br.com.centralit.citcorpore.bean.OrigemAtendimentoDTO;
import br.com.centralit.citcorpore.bean.ProblemaBaseConhecimentoRelacionadoDTO;
import br.com.centralit.citcorpore.bean.ProblemaDTO;
import br.com.centralit.citcorpore.bean.ProblemaItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.ProblemaMudancaDTO;
import br.com.centralit.citcorpore.bean.ProblemaRelacionadoDTO;
import br.com.centralit.citcorpore.bean.ProblemaServicoNegocioDTO;
import br.com.centralit.citcorpore.bean.RequisicaoMudancaDTO;
import br.com.centralit.citcorpore.bean.RequisicaoMudancaItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.ServicoContratoDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoProblemaDTO;
import br.com.centralit.citcorpore.bean.SolucaoContornoDTO;
import br.com.centralit.citcorpore.bean.SolucaoDefinitivaDTO;
import br.com.centralit.citcorpore.bean.TemplateSolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.UnidadeDTO;
import br.com.centralit.citcorpore.bean.UnidadesAccServicosDTO;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.integracao.OcorrenciaProblemaDAO;
import br.com.centralit.citcorpore.mail.MensagemEmail;
import br.com.centralit.citcorpore.negocio.BaseConhecimentoService;
import br.com.centralit.citcorpore.negocio.CalendarioService;
import br.com.centralit.citcorpore.negocio.CategoriaOcorrenciaService;
import br.com.centralit.citcorpore.negocio.CategoriaProblemaService;
import br.com.centralit.citcorpore.negocio.CategoriaServicoService;
import br.com.centralit.citcorpore.negocio.CategoriaSolucaoService;
import br.com.centralit.citcorpore.negocio.CausaIncidenteService;
import br.com.centralit.citcorpore.negocio.ContatoProblemaService;
import br.com.centralit.citcorpore.negocio.ContratoService;
import br.com.centralit.citcorpore.negocio.EmailSolicitacaoServicoService;
import br.com.centralit.citcorpore.negocio.EmpregadoService;
import br.com.centralit.citcorpore.negocio.ExecucaoProblemaService;
import br.com.centralit.citcorpore.negocio.GrupoService;
import br.com.centralit.citcorpore.negocio.ItemConfiguracaoService;
import br.com.centralit.citcorpore.negocio.JustificativaProblemaService;
import br.com.centralit.citcorpore.negocio.LocalidadeService;
import br.com.centralit.citcorpore.negocio.LocalidadeUnidadeService;
import br.com.centralit.citcorpore.negocio.OcorrenciaProblemaService;
import br.com.centralit.citcorpore.negocio.OrigemAtendimentoService;
import br.com.centralit.citcorpore.negocio.PastaService;
import br.com.centralit.citcorpore.negocio.ProblemaBaseConhecimentoService;
import br.com.centralit.citcorpore.negocio.ProblemaItemConfiguracaoService;
import br.com.centralit.citcorpore.negocio.ProblemaMudancaService;
import br.com.centralit.citcorpore.negocio.ProblemaService;
import br.com.centralit.citcorpore.negocio.ProblemaServicoNegocioService;
import br.com.centralit.citcorpore.negocio.RequisicaoMudancaService;
import br.com.centralit.citcorpore.negocio.ServicoContratoService;
import br.com.centralit.citcorpore.negocio.ServicoService;
import br.com.centralit.citcorpore.negocio.SolicitacaoServicoProblemaService;
import br.com.centralit.citcorpore.negocio.SolicitacaoServicoService;
import br.com.centralit.citcorpore.negocio.SolucaoContornoService;
import br.com.centralit.citcorpore.negocio.SolucaoDefinitivaService;
import br.com.centralit.citcorpore.negocio.TemplateSolicitacaoServicoService;
import br.com.centralit.citcorpore.negocio.UnidadeService;
import br.com.centralit.citcorpore.negocio.UnidadesAccServicosService;
import br.com.centralit.citcorpore.negocio.UsuarioService;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.OccurrenceCategory;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.Enumerados.ProblemRequestStatus;
import br.com.centralit.citcorpore.util.Enumerados.TipoAcordoContrato;
import br.com.centralit.citcorpore.util.Enumerados.TipoCatalogoServico;
import br.com.centralit.citcorpore.util.Enumerados.TipoDate;
import br.com.centralit.citcorpore.util.Enumerados.TipoOrigemLeituraEmail;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citged.bean.ControleGEDDTO;
import br.com.centralit.citged.negocio.ControleGEDService;
import br.com.centralit.impressao.ImpressaoCadProblema;
import br.com.citframework.dto.IDto;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Configuracoes;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;
import br.com.citframework.util.UtilStrings;
import br.com.citframework.util.WebUtil;
import net.htmlparser.jericho.Source;

/**
 * @author breno.guimaraes
 *
 */
@SuppressWarnings({ "rawtypes", "unused", "unchecked" })
public class Problema extends AjaxFormAction {

	private ProblemaService problemaService;
	private EmpregadoService usuarioService;
	private CategoriaProblemaService categoriaProblemaService;
	private ProblemaItemConfiguracaoService problemaItemConfiguracaoService;
	private ItemConfiguracaoService itemConfiguracaoService;
	private PastaService pastaService;
	private SolicitacaoServicoProblemaService solicitacaoServicoProblemaService;
	private UsuarioDTO usuario;
	private ContratoService contratoService;
	private CategoriaServicoService categoriaServicoService;
	private ProblemaServicoNegocioService problemaServicoNegocioService;
	private ServicoService servicoService;
	private ProblemaMudancaService problemaMudancaService;
	private RequisicaoMudancaService requisicaoMudancaService;

	private ProblemaDTO problemaDto;

	String str_nomeFormProblema = "form";

	HTMLForm formProblema;
	private CategoriaOcorrenciaService categoriaOcorrenciaService;

	public String getStr_nomeFormProblema() {
        return str_nomeFormProblema;
    }

    public void setStr_nomeFormProblema(String str_nomeFormProblema) {
        this.str_nomeFormProblema = str_nomeFormProblema;
    }

    public HTMLForm getFormProblema() {
        return formProblema;
    }

    public void setFormProblema(HTMLForm formProblema) {
        this.formProblema = formProblema;
    }

	@Override
	public Class getBeanClass() {
		return ProblemaDTO.class;
	}

	public ProblemaDTO getProblemaDto() {
		return problemaDto;
	}

	public void setProblemaDto(ProblemaDTO problemaDto) {
		this.problemaDto = problemaDto;
	}

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String UNIDADE_AUTOCOMPLETE = ParametroUtil.getValorParametroCitSmartHashMap(br.com.centralit.citcorpore.util.Enumerados.ParametroSistema.UNIDADE_AUTOCOMPLETE, "N");
		StringBuilder objeto;
		if (UNIDADE_AUTOCOMPLETE != null && UNIDADE_AUTOCOMPLETE.equalsIgnoreCase("S")) {
			objeto = new StringBuilder();
			objeto.append("<select id='idContrato' name='idContrato' class='span12 Valid[Required] Description[\"contrato.contrato\"]' ");
			objeto.append("onchange='setaValorLookup(this);'>");
			objeto.append("</select>");
			document.getElementById("divContrato").setInnerHTML(objeto.toString());

			objeto = new StringBuilder();
			objeto.append("<input type='text' name='unidadeDes' id='unidadeDes' class='span12' onkeypress='onkeypressUnidadeDes();'>");
			objeto.append("<input type='hidden' name='idUnidade' id='idUnidade' value='0'/>");
			document.getElementById("divUnidade").setInnerHTML(objeto.toString());
			document.executeScript("montaParametrosAutocompleteUnidade()");
		} else {
			objeto = new StringBuilder();
			objeto.append("<select id='idContrato' name='idContrato' class='span12 Valid[Required] Description[\"contrato.contrato\"]' ");
			objeto.append("onchange='setaValorLookup(this);' onclick= 'carregaUnidade();'>");
			objeto.append("</select>");
			document.getElementById("divContrato").setInnerHTML(objeto.toString());

			objeto = new StringBuilder();
			objeto.append("<select name='idUnidade' id = 'idUnidade' onchange='document.form.fireEvent(\"preencherComboLocalidade\")' class='span12 Valid[Required] Description[colaborador.cadastroUnidade]'></select>");
			document.getElementById("divUnidade").setInnerHTML(objeto.toString());
		}

		/**
		 * Adicionado para fazer limpeza da seo quando for gerenciamento de Servio
		 *
		 * @author mario.junior
		 * @since 28/10/2013 08:21
		 */
		request.getSession(true).setAttribute("colUploadRequisicaoProblemaGED", null);
		this.setProblemaDto((ProblemaDTO) document.getBean());

		document.executeScript("$('#statusProblema').hide()");
		document.executeScript("$('#divResolvido').hide()");
		document.executeScript("$('#divBotaoFecharFrame').hide()");
		document.executeScript("$('#statusCancelada').hide()");

		if (this.getProblemaDto() == null || this.getProblemaDto().getIdProblema() == null) {
			document.executeScript("$('#liOcorrenciasProblema').addClass('inativo');");
		} else {
			document.executeScript("$('#liOcorrenciasProblema').removeClass('inativo');");
		}


		String descricaoSolicitacao = (String) request.getSession().getAttribute("DescricaoSolicitacao");
		request.getSession().removeAttribute("DescricaoSolicitacao");
		String iframeSolicitacao = request.getParameter("solicitacaoServico");

		if (descricaoSolicitacao != null && !descricaoSolicitacao.equalsIgnoreCase("")) {
			document.getElementById("DescricaoAuxliar").setInnerHTML(descricaoSolicitacao);
			document.executeScript("setarDescricao()");
		}

		document.getElementById("enviaEmailCriacao").setDisabled(true);

		document.getElementById("enviaEmailFinalizacao").setDisabled(true);

		usuario = br.com.centralit.citcorpore.util.WebUtil.getUsuario(request);

		if (usuario == null) {

			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));

			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");

			return;
		}

		HTMLSelect idGrupoAtual = document.getSelectById("idGrupo");

		idGrupoAtual.removeAllOptions();

		idGrupoAtual.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

		GrupoService grupoSegurancaService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
		Collection colGrupos = grupoSegurancaService.listaGruposAtivos();

		if (colGrupos != null) {
			idGrupoAtual.addOptions(colGrupos, "idGrupo", "nome", null);
		}

		ContratoService contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
		Integer idContratoSelecionado = contratoService.carregarContratos(this.getProblemaDto().getEditar(), usuario, document, request);

		String tipoCategoria = this.carregarComboTipoCatalogoServico(document, request, idContratoSelecionado);

		this.carregarComboCategoriaServico(document, request, tipoCategoria);

		this.carregaServicosMulti(document, request, response);
		if (UNIDADE_AUTOCOMPLETE != null && !UNIDADE_AUTOCOMPLETE.equalsIgnoreCase("S")) {
			this.carregaUnidade(document, request, idContratoSelecionado);
		}

		this.alimentaComboCategoriaProblema(request, document);

		this.preencherComboCausa(document, request, response);

		this.preencherComboOrigem(document, request, response);

		if (request.getParameter("chamarTelaProblema") != null && !request.getParameter("chamarTelaProblema").equalsIgnoreCase("")) {
			Integer tarefa = this.obterIdTarefa(this.getProblemaDto(), request);
			if (tarefa > 0) {
				this.getProblemaDto().setIdTarefa(tarefa);
			}
		}

		String tarefaAssociada = "N";
		if (this.getProblemaDto() != null && this.getProblemaDto().getIdTarefa() != null) {
			tarefaAssociada = "S";
			request.setAttribute("tarefaAssociada", tarefaAssociada);
		}

		if (this.getProblemaDto() != null && this.getProblemaDto().getIdContrato() != null) {
			document.getElementById("idContrato").setValue("" + problemaDto.getIdContrato());
		}

		if (this.getProblemaDto() != null && this.getProblemaDto().getIdProblema() != null) {
			this.restore(document, request, response);
			this.preencherComboCategoriaSolucaoMesmoQuandoDeleted(document, request, response);
			this.atualizaValuesFormProblema(document, request, response);
		} else {
			this.preencherComboCategoriaSolucao(document, request, response);
		}

		this.carregarInformacaoProblemaAnaliseTendencia(document, request, response);

		document.getElementById("iframeSolicitacao").setValue(iframeSolicitacao);

		if (this.getProblemaDto() != null && this.getProblemaDto().getIdProblema() != null && this.getProblemaDto().getIdProblema().intValue() > 0) {
			document.getElementById("btnImprimir").setDisabled(false);
		} else {
			document.getElementById("btnImprimir").setDisabled(true);
		}

		this.setProblemaDto(null);
		document.executeScript("parent.JANELA_AGUARDE_MENU.hide()");
	}

	public void atualizaServicos(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws ServiceException, Exception {
		ProblemaDTO problemaDTO = (ProblemaDTO) document.getBean();

		String UNIDADE_AUTOCOMPLETE = ParametroUtil.getValorParametroCitSmartHashMap(br.com.centralit.citcorpore.util.Enumerados.ParametroSistema.UNIDADE_AUTOCOMPLETE, "N");

		Integer idContratoSelecionado = problemaDTO.getIdContrato();

		String tipoCategoria = this.carregarComboTipoCatalogoServico(document, request, idContratoSelecionado);

		this.carregarComboCategoriaServico(document, request, tipoCategoria);
	}

	/**
	 * @param document
	 * @param request
	 * @param response
	 * @throws ServiceException
	 * @throws Exception
	 * @author maycon.silva
	 *
	 *         O mtodo carrega as informaes de um problema caso haja tendencia identifcada no relatorio de Analise de Tendncia
	 *
	 */
	private void carregarInformacaoProblemaAnaliseTendencia(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws ServiceException, Exception {
		if (request.getParameter("tendenciaProblema") != null && request.getParameter("tendenciaProblema").equalsIgnoreCase("S")) {
			String tipo = request.getParameter("tipo");

			if (request.getParameter("idContrato") != null && !request.getParameter("idContrato").equalsIgnoreCase("")) {
				this.getProblemaDto().setIdContrato(new Integer(request.getParameter("idContrato")));

				String UNIDADE_AUTOCOMPLETE = ParametroUtil.getValorParametroCitSmartHashMap(br.com.centralit.citcorpore.util.Enumerados.ParametroSistema.UNIDADE_AUTOCOMPLETE, "N");
				if (UNIDADE_AUTOCOMPLETE != null && !UNIDADE_AUTOCOMPLETE.equalsIgnoreCase("S")) {
					this.carregaUnidade(document, request, response);
				}

				document.executeScript("setaValorLookup('" + this.getProblemaDto().getIdContrato() + "', true);");
			}

			if (tipo != null && !tipo.trim().equalsIgnoreCase("")) {
				if (tipo.equalsIgnoreCase("servico")) {
					this.preencheServicoProblemaByTendenciaProblema(document, request, response);
				}
				if (tipo.equalsIgnoreCase("causa")) {
					this.preencheCausaProblemaByTendenciaProblema(document, request, response);
				}

				if (tipo.equalsIgnoreCase("itemConfiguracao")) {
					this.preencheItemConfiguracaoProblemaByTendenciaProblema(document, request, response);
				}
			}

			HTMLForm form = document.getForm("form");
			form.setValues(  this.getProblemaDto());
		}
	}

	/**
	 * Preenche o servio caso seja uma tendencio do tipo servio, e seta o servio na descrio do problema
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws ServiceException
	 * @throws Exception
	 * @author maycon.silva
	 *
	 *
	 */
	private void preencheServicoProblemaByTendenciaProblema(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws ServiceException, Exception {
		if (request.getParameter("id") != null && !request.getParameter("id").equalsIgnoreCase("")) {
			ServicoContratoService servicoContratoService = (ServicoContratoService) ServiceLocator.getInstance().getService(ServicoContratoService.class, null);
			ServicoContratoDTO servicoContratoDTO = new ServicoContratoDTO();
			servicoContratoDTO.setIdServicoContrato(new Integer(request.getParameter("id")));
			servicoContratoDTO = servicoContratoService.findByIdServicoContrato(servicoContratoDTO.getIdServicoContrato(), this.getProblemaDto().getIdContrato());
			this.getProblemaDto().setDescricao("Servio do Contrato: " + servicoContratoDTO.getNomeServico());
		}
	}

	/**
	 * Preenche a Causa caso seja uma tendencio do tipo Causa, e seta o Causa na descrio do problema
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws ServiceException
	 * @throws Exception
	 * @author maycon.silva
	 *
	 *
	 */
	private void preencheCausaProblemaByTendenciaProblema(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws ServiceException, Exception {
		if (request.getParameter("id") != null && !request.getParameter("id").equalsIgnoreCase("")) {
			CausaIncidenteService causaIncidenteService = (CausaIncidenteService) ServiceLocator.getInstance().getService(CausaIncidenteService.class, null);
			CausaIncidenteDTO causaIncidenteDTO = new CausaIncidenteDTO();
			causaIncidenteDTO.setIdCausaIncidente(new Integer(request.getParameter("id")));
			causaIncidenteDTO = (CausaIncidenteDTO) causaIncidenteService.restore(causaIncidenteDTO);
			this.getProblemaDto().setDescricao("Causa: " + causaIncidenteDTO.getDescricaoCausa());
			this.getProblemaDto().setIdCausa(new Integer(request.getParameter("id")));
		}
	}

	/**
	 * Preenche o Item configurao caso seja uma tendencio do tipo Item configurao, e seta o Item configurao na descrio do problema
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws ServiceException
	 * @throws Exception
	 * @author maycon.silva
	 *
	 *
	 */
	private void preencheItemConfiguracaoProblemaByTendenciaProblema(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws ServiceException, Exception {
		if (request.getParameter("id") != null && !request.getParameter("id").equalsIgnoreCase("")) {
			ItemConfiguracaoService itemConfiguracaoService = (ItemConfiguracaoService) ServiceLocator.getInstance().getService(ItemConfiguracaoService.class, null);
			ItemConfiguracaoDTO itemConfiguracaoDto = new ItemConfiguracaoDTO();
			itemConfiguracaoDto = itemConfiguracaoService.restoreByIdItemConfiguracao(new Integer(request.getParameter("id")));
			this.getProblemaDto().setDescricao("Item Configurao: " + itemConfiguracaoDto.getIdentificacao());
		}
	}

	/**
	 * Carrega combo de Origem do conhecimento
	 *
	 * @param document
	 * @param request
	 * @throws Exception
	 * @author thays.araujo
	 */
	public void preencherComboOrigem(DocumentHTML document, HttpServletRequest request) throws Exception {

		HTMLSelect combo = document.getSelectById("comboOrigem");
		combo.removeAllOptions();

		combo.addOption(BaseConhecimentoDTO.CONHECIMENTO.toString(), UtilI18N.internacionaliza(request, "baseConhecimento.conhecimento"));
		combo.addOption(BaseConhecimentoDTO.EVENTO.toString(), UtilI18N.internacionaliza(request, "justificacaoFalhas.evento"));
		combo.addOption(BaseConhecimentoDTO.MUDANCA.toString(), UtilI18N.internacionaliza(request, "requisicaMudanca.mudanca"));
		combo.addOption(BaseConhecimentoDTO.INCIDENTE.toString(), UtilI18N.internacionaliza(request, "solicitacaoServico.incidente"));
		combo.addOption(BaseConhecimentoDTO.SERVICO.toString(), UtilI18N.internacionaliza(request, "servico.servico"));
		combo.addOption(BaseConhecimentoDTO.PROBLEMA.toString(), UtilI18N.internacionaliza(request, "problema.problema"));
	}

	/**
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author breno.guimaraes
	 */
	public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		/**
		 * Adicionado para fazer limpeza da seo quando for gerenciamento de Servio
		 *
		 * @author mario.junior
		 * @since 28/10/2013 08:21
		 */
		request.getSession(true).setAttribute("colUploadRequisicaoProblemaGED", null);
		this.setProblemaDto((ProblemaDTO) document.getBean());

		UsuarioDTO usuarioDto = br.com.centralit.citcorpore.util.WebUtil.getUsuario(request);

		ProblemaDTO problemaAuxDto = this.getProblemaDto();

		if (request.getParameter("chamarTelaProblema") != null && !request.getParameter("chamarTelaProblema").equalsIgnoreCase("")) {
			this.setProblemaDto(this.getProblemaService(request).restoreAll(problemaDto));
		} else {
			this.setProblemaDto(this.getProblemaService(request).restoreAll(problemaDto.getIdProblema()));
		}

		if (this.getProblemaDto() != null) {
			String editar = problemaAuxDto.getEditar();

			ContratoService contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
			contratoService.restauraContrato(this.getProblemaDto().getIdContrato(), usuarioDto, document, request);

			document.executeScript("$('#liProcessosProblema').removeClass('inativo')");

			document.executeScript("$('#statusProblema').show()");
			document.executeScript("$('#divProblemaGrave').show()");
			document.executeScript("$('#divPrecisaMudanca').show()");
			document.executeScript("$('#divPrecisaSolucaoContorno').show()");

			this.atualizaGridProblema(document, request, response);

			problemaAuxDto.setIdErrosConhecidosStr(this.getProblemaDto().getIdErrosConhecidosStr());

			Integer idTarefa = problemaAuxDto.getIdTarefa();

			String acaoFluxo = problemaAuxDto.getAcaoFluxo();

			String escalar = problemaAuxDto.getEscalar();

			String alterarSituacao = problemaAuxDto.getAlterarSituacao();

			Integer idPhase = problemaAuxDto.getIdPhase();
			Integer idActualPhase = problemaAuxDto.getIdActualPhase();

			ContatoProblemaService contatoPloblemaService = (ContatoProblemaService) ServiceLocator.getInstance()
					.getService(ContatoProblemaService.class, null);

			OrigemAtendimentoService origemAtendimentoService = (OrigemAtendimentoService) ServiceLocator.getInstance()
					.getService(OrigemAtendimentoService.class, null);

			OrigemAtendimentoDTO origemAtendimentoDto = new OrigemAtendimentoDTO();

			if (this.getProblemaDto().getIdOrigemAtendimento() != null && this.getProblemaDto().getIdOrigemAtendimento() > 0) {
				origemAtendimentoDto.setIdOrigem(this.getProblemaDto().getIdOrigemAtendimento());
			origemAtendimentoDto = (OrigemAtendimentoDTO) origemAtendimentoService.restore(origemAtendimentoDto);
			}

			atribuirNomeProprietarioECriadorParaRequisicaoDto(this.getProblemaDto());

			atualizaInformacoesRelacionamentos(document, request);

			this.alimentaComboCategoriaProblema(request, document);

			if("Reativo".equals(this.problemaDto.getProativoReativo())){
				document.executeScript("$('input:checkbox[name=\"proativoReativo\"][value=\"Reativo\"]').prop('checked',true);");
			}

			String UNIDADE_AUTOCOMPLETE = ParametroUtil.getValorParametroCitSmartHashMap(
					br.com.centralit.citcorpore.util.Enumerados.ParametroSistema.UNIDADE_AUTOCOMPLETE, "N");

			if (UNIDADE_AUTOCOMPLETE != null && UNIDADE_AUTOCOMPLETE.equalsIgnoreCase("S")) {

				UnidadeService unidadeService = (UnidadeService) ServiceLocator.getInstance()
						.getService(UnidadeService.class, null);
				UnidadeDTO unidadeDTO = new UnidadeDTO();
					unidadeDTO.setIdUnidade(this.getProblemaDto().getIdUnidade());
				unidadeDTO = (UnidadeDTO) unidadeService.restore(unidadeDTO);

				if(unidadeDTO != null) {
					problemaDto.setUnidadeDes(unidadeDTO.getNome());
				}

			} else {
				this.restoreComboUnidade(editar,this.getProblemaDto(), document, request, response);
			}

			this.restoreComboLocalidade(this.getProblemaDto(), document, request, response);

			this.restoreComboOrigemAtendimento(this.getProblemaDto(), document, request, response);

			this.preencherComboCausa(document, request, response);

			this.carregaProblemaRelacionado(request, document, problemaAuxDto);
			this.carregaProblemaBaseConhecimentoRelacionado(request, document, problemaAuxDto);

			/**
			 * @author geber.costa verifica se no banco o acompanhamento est setado como 'N' ou 'S'
			 */

			if (this.getProblemaDto().getAcompanhamento() == null || this.getProblemaDto().getAcompanhamento().equalsIgnoreCase("N") || this.getProblemaDto().getAcompanhamento().equalsIgnoreCase("")) {
			document.getElementById("acompanhamento").setValue("N");
			} else if (this.getProblemaDto().getAcompanhamento().equals("S")) {
			document.getElementById("acompanhamento").setValue("S");
			}

			SolucaoContornoDTO solucaoContorno = this.verificaSolucaoContorno(request, response, document, this.getProblemaDto());
			SolucaoDefinitivaDTO solucaoDefinitiva = this.verificaSolucaoDefinitiva(request, response, document, this.getProblemaDto());

			this.getProblemaDto().setIdTarefa(idTarefa);

			this.getProblemaDto().setAcaoFluxo(acaoFluxo);

			this.getProblemaDto().setEscalar(escalar);

			this.getProblemaDto().setAlterarSituacao(alterarSituacao);

			this.getProblemaDto().setIdPhase(idPhase);

			this.getProblemaDto().setIdActualPhase(idActualPhase);

			if (problemaAuxDto.getChamarTelaProblema() != null
					&& problemaAuxDto.getChamarTelaProblema().equalsIgnoreCase("S")) {
				this.getProblemaDto().setChamarTelaProblema(problemaAuxDto.getChamarTelaProblema());
				document.executeScript("$('#divBotoes').hide()");
				document.executeScript("$('#divBotaoFecharFrame').show()");
			}

			if (solucaoContorno != null) {
				this.getProblemaDto().setIdSolucaoContorno(solucaoContorno.getIdSolucaoContorno());
				this.getProblemaDto().setTituloSolCon(solucaoContorno.getTitulo());
				this.getProblemaDto().setDescSolCon(solucaoContorno.getDescricao());
			}
			if (solucaoDefinitiva != null) {
				this.getProblemaDto().setIdSolucaoDefinitiva(solucaoDefinitiva.getIdSolucaoDefinitiva());
				this.getProblemaDto().setTituloSolDefinitiva(solucaoDefinitiva.getTitulo());
				this.getProblemaDto().setDescSolDefinitiva(solucaoDefinitiva.getDescricao());
			}

			verificaUltimaAtualizacao(document, request, this.getProblemaDto().getIdProblema());
			if (this.getProblemaDto().getCausaRaiz() != null && this.getProblemaDto().getSolucaoContorno() != null) {
				if (!this.getProblemaDto().getCausaRaiz().equalsIgnoreCase("") && !this.getProblemaDto().getSolucaoContorno().equalsIgnoreCase("")) {
					document.executeScript("$('#relacionarErrosConhecidos').show()");
				}
			}

			document.setBean(this.getProblemaDto());

			HTMLForm form = document.getForm("form");

			form.clear();

			/* Mantis: 2591
			 * Correo por gilmar.junior - 18.07.2016
			 *
			if (ProblemRequestStatus.REGISTERED.getId().equals(this.getProblemaDto().getIdStatus())) {
				document.executeScript("$('#rotuloCausaRaiz').removeClass('campoObrigatorio')");
				document.executeScript("$('#rotuloSolucaoContorno').removeClass('campoObrigatorio')");
			}
			*/

			if (this.getProblemaDto().getIdContrato() != null) {
			document.getSelectById("idContrato").setDisabled(true);
			}

			if (this.getProblemaDto().getIdCategoriaProblema() != null) {
			document.getSelectById("idCategoriaProblema").setDisabled(true);
			}

			form.setValues(this.getProblemaDto());

			document.executeScript("$('#radioStatusSetado').val('"+this.getProblemaDto().getIdStatus()+"')");
			document.executeScript("$('#labelRadioStatusSetado').append('"+UtilI18N.internacionaliza(request, consultaStatusProblema(this.getProblemaDto().getIdStatus()))+"')");
			document.executeScript("restaurar()");
			document.executeScript("informaNumeroSolicitacao('" + this.getProblemaDto().getIdProblema() + "')");

			String tipoCategoria = this.carregarComboTipoCatalogoServico(document, request, this.getProblemaDto().getIdContrato());

			this.carregarComboCategoriaServico(document, request, tipoCategoria);

			restoreServicoNegocio(document, request, getProblemaDto().getIdProblema());

			if (editar == null || editar.equalsIgnoreCase("")) {
				this.getProblemaDto().setEditar("S");
			} else if (editar.equalsIgnoreCase("N")) {

				document.executeScript("$('#divBarraFerramentas').hide()");
				document.executeScript("$('#divBotoes').hide()");
				document.getForm("form").lockForm();

			} else if (editar.equalsIgnoreCase("RO")) {
				document.executeScript("$('#divBarraFerramentas').show()");
				document.executeScript("$('#divBotoes').hide()");
				document.getForm("form").lockForm();
				document.executeScript("$('#fraUpload_uploadRequisicaoProblema').attr('src', '"  + Configuracoes.getCaminhoComContexto("/pages/uploadRequisicaoProblema/uploadRequisicaoProblema.load?editar=RO") + "')");
				document.executeScript("$('#abaMudanca').remove()");
				document.executeScript("$('#abaSolicitacao').remove()");
				document.executeScript("$('#abaSolucaoRetorno').remove()");
				document.executeScript("$('#abaSolucaoDefinitiva').remove()");
				document.executeScript("$('#divBaseConhecimentoErroConhecido').remove()");
				document.executeScript("$('#divBaseConhecimento').remove()");
				document.executeScript("$('#abaProblemaRelacionado').remove()");
				document.executeScript("$(\"a[href='#tabCadastroOcorrencias']\").parent().hide();");
				document.executeScript("$('#tblSolicitacaoServico').find('img').remove()");
				document.executeScript("$('#tblICs').find('img').remove()");
				document.executeScript("$('#tblRDM').find('img').remove()");
				document.executeScript("$('#tblErrosConhecidos').find('#btEditBaseConhecimento').remove()");
				document.executeScript("$('#tblProblema').find('img').remove()");
				document.executeScript("$('#btAbreCadastroCategoriaProblema').remove()");
				document.executeScript("$('#valorEditarFormEmail').val('RO')");
				document.executeScript("$('.hideOnVisualizar').remove()");
				document.executeScript("$('#lblLimparServicoNegocioTecnicoBusca').remove()");
				document.executeScript("$('#relacionarRevisaoProblemaGrave textarea').attr('disabled', 'disabled');");
				document.executeScript("$('#relacionarRevisaoProblemaGrave input').attr('disabled', 'disabled');");
				document.executeScript("$('#relacionarDiagnostico textarea').attr('disabled', 'disabled');");
				document.executeScript("$('#observacao').attr('disabled', 'disabled');");
				document.executeScript("$('#descricao').attr('disabled', 'disabled');");
				document.executeScript("$('#fechamento').attr('disabled', 'disabled');");
				document.executeScript("$('#registroexecucao').attr('disabled', 'disabled');");
				document.executeScript("$('.tblConhecimento:last-child img').remove()");
			}

			document.executeScript("parent.JANELA_AGUARDE_MENU.hide()");

			/*
			 * geber.costa Mtodo listInfoRegExecucaoProblema verifica se o id do problema  vlido , caso sim ele traz a lista de ocorrencias de problemas
			 */

			if (this.listInfoRegExecucaoProblema(this.getProblemaDto(), request) != null) {
					document.getElementById("tblOcorrencias").setInnerHTML(listInfoRegExecucaoProblema(this.getProblemaDto(), request));
			}

			this.carregaInformacoesComplementares(document, request, this.getProblemaDto());

			/**
			 * Adicionado para restaurar anexo
			 *
			 * @author mario.junior
			 * @since 31/10/2013 08:21
			 */
			ControleGEDService controleGedService = (ControleGEDService) ServiceLocator.getInstance()
					.getService(ControleGEDService.class, null);
			Collection colAnexos = controleGedService.listByIdTabelaAndID(ControleGEDDTO.TABELA_PROBLEMA, this.getProblemaDto().getIdProblema());
			Collection colAnexosUploadDTO = controleGedService.convertListControleGEDToUploadDTO(colAnexos);
			request.getSession(true).setAttribute("colUploadRequisicaoProblemaGED", colAnexosUploadDTO);
			request.getSession().setAttribute("colUploadRequisicaoProblemaGED", colAnexosUploadDTO);

				GrupoService grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class,
						null);
			Collection<GrupoDTO> lstGrupos = grupoService.getGruposByEmpregado(usuarioDto.getIdEmpregado());

			if (lstGrupos != null) {
				for (GrupoDTO g : lstGrupos) {
						if (this.getProblemaService(request).verificaPermissaoGrupoCancelar(this.getProblemaDto().getIdCategoriaProblema(), g.getIdGrupo())) {
						document.executeScript("$('#statusCancelada').show()");
						break;
					}
				}
			}
		}

		document.executeScript("$('.modal-header button.close').removeAttr('disabled')");
	}

	/**
	 * Consulta a chave internacionalizada pela descricao do status do problema
	 *
	 * @param idStatus
	 * @return
	 */
	private String consultaStatusProblema(Integer idStatus) {
		return ProblemRequestStatus.chaveFromId(idStatus);
	}

	private void carregaProblemaRelacionado(HttpServletRequest request, DocumentHTML document, ProblemaDTO problemaDto) throws Exception {
		HTMLTable tblProblmea = document.getTableById("tblProblema");
		tblProblmea.deleteAllRows();
		ProblemaService problemaservice = (ProblemaService) ServiceLocator.getInstance().getService(ProblemaService.class, null);
		if (problemaDto != null) {
			ProblemaRelacionadoDTO problemaRelacionadoDTO = new ProblemaRelacionadoDTO();
			problemaRelacionadoDTO.setIdProblema(problemaDto.getIdProblema());
			Collection col = problemaservice.findByProblemaRelacionado(problemaRelacionadoDTO);
			if (col != null) {
				tblProblmea.addRowsByCollection(col, new String[] { "idProblema", "titulo", "descrStatus", " " },
 new String[] { "idProblema" }, "Problema j cadastrado!!",
						new String[] { "exibeIconesProblema" }, null, null);
				document.executeScript("HTMLUtils.applyStyleClassInAllCells('tblProblema', 'tblProblema');");
			}
		}

	}

	private void carregaProblemaBaseConhecimentoRelacionado(HttpServletRequest request, DocumentHTML document, ProblemaDTO problemaDto) throws Exception {
		HTMLTable tblConhecimento = document.getTableById("tblConhecimento");
		tblConhecimento.deleteAllRows();
		ProblemaService problemaservice = (ProblemaService) ServiceLocator.getInstance().getService(ProblemaService.class, null);
		if (problemaDto != null) {
			ProblemaBaseConhecimentoRelacionadoDTO problemaBaseConhecimentoRelacionadoDTO = new ProblemaBaseConhecimentoRelacionadoDTO();
			problemaBaseConhecimentoRelacionadoDTO.setIdProblema(problemaDto.getIdProblema());
			BaseConhecimentoService baseConhecimentoService = (BaseConhecimentoService) ServiceLocator.getInstance().getService(BaseConhecimentoService.class, null);
			Collection<ProblemaBaseConhecimentoRelacionadoDTO> col = problemaservice.findByProblemaBaseConhecimentoRelacionado(problemaBaseConhecimentoRelacionadoDTO);
			if(col != null){
				List<BaseConhecimentoDTO> lista = new ArrayList<BaseConhecimentoDTO>();
				for (ProblemaBaseConhecimentoRelacionadoDTO pbRelacionado : col) {
					BaseConhecimentoDTO baseConhecimentoDTO = new BaseConhecimentoDTO();
					baseConhecimentoDTO.setIdBaseConhecimento(pbRelacionado.getIdBaseConhecimento());
					baseConhecimentoDTO = baseConhecimentoService.restore(baseConhecimentoDTO);
					if (!( "|" + baseConhecimentoDTO.getIdBaseConhecimento() + "|").contains(this.getProblemaDto().getIdErrosConhecidosStr())) {
						lista.add(baseConhecimentoDTO);
					}
				}
				if (!lista.isEmpty()) {
					tblConhecimento.addRowsByCollection(lista,
							new String[] { "idBaseConhecimento", "titulo", "status", " " },
							new String[] { "idBaseConhecimento" }, UtilI18N.internacionaliza(request, "baseConhecimento.conhecimentoJaCadastrado"),
							new String[] { "exibeIconesConhecimento" }, null, null);
					document.executeScript("HTMLUtils.applyStyleClassInAllCells('tblConhecimento', 'tblConhecimento');");
				}
			}
		}

	}

	/**
	 * Popula combo categoria hierarquicamente.
	 *
	 * @param document
	 * @throws Exception
	 */
	private void alimentaComboCategoriaProblema(HttpServletRequest request, DocumentHTML document) throws Exception {
		HTMLSelect combo = document.getSelectById("idCategoriaProblema");
		inicializaCombo(request, combo);

		CategoriaProblemaService categoriaProblemaService = (CategoriaProblemaService) ServiceLocator.getInstance().getService(CategoriaProblemaService.class, null);

		ArrayList<CategoriaProblemaDTO> listaCategoriaAux = (ArrayList<CategoriaProblemaDTO>) categoriaProblemaService.getAtivos();
		if (listaCategoriaAux != null) {
			for (CategoriaProblemaDTO categoriaProblemaDto : listaCategoriaAux) {
				combo.addOption(categoriaProblemaDto.getIdCategoriaProblema().toString(), StringEscapeUtils.escapeJavaScript(categoriaProblemaDto.getNomeCategoria()));

			}
		}

	}

	private void inicializaCombo(HttpServletRequest request, HTMLSelect componenteCombo) {
		componenteCombo.removeAllOptions();
		componenteCombo.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
	}

	/**
	 * Centraliza atualizao de informaes dos objetos que se relacionam com a mudana.
	 *
	 * @param request
	 *
	 * @throws ServiceException
	 * @throws Exception
	 */
	private void atualizaInformacoesRelacionamentos(DocumentHTML document, HttpServletRequest request) throws ServiceException, Exception {
		// informaes dos ics relacionados

		SolicitacaoServicoService solicitacaoServicoService = (SolicitacaoServicoService) ServiceLocator.getInstance().getService(SolicitacaoServicoService.class, null);
		ArrayList<ProblemaItemConfiguracaoDTO> listaICsRelacionados = (ArrayList<ProblemaItemConfiguracaoDTO>) getProblemaItemConfiguracaoService().findByIdProblema(problemaDto.getIdProblema());
		if (listaICsRelacionados != null) {
			ItemConfiguracaoDTO itemConfiguracaoDTO = new ItemConfiguracaoDTO();
			for (ProblemaItemConfiguracaoDTO problemaItemConfiguracaoDTO : listaICsRelacionados) {
				itemConfiguracaoDTO = getItemConfiguracaoService().restoreByIdItemConfiguracao(problemaItemConfiguracaoDTO.getIdItemConfiguracao());
				if (itemConfiguracaoDTO != null) {
					problemaItemConfiguracaoDTO.setNomeItemConfiguracao(itemConfiguracaoDTO.getIdentificacao());
				}

			}
			problemaDto.setItensConfiguracaoRelacionadosSerializado(WebUtil.serializeObjects(listaICsRelacionados, document.getLanguage()));
		}

		ArrayList<SolicitacaoServicoProblemaDTO> listaSolicitacaoServico = (ArrayList<SolicitacaoServicoProblemaDTO>) getSolicitacaoServicoProblemaService().findByIdProblema(
				problemaDto.getIdProblema());

		if (listaSolicitacaoServico != null && listaSolicitacaoServico.size() > 0) {
			for (SolicitacaoServicoProblemaDTO solicitacaoServicoProblemaDto : listaSolicitacaoServico) {
				SolicitacaoServicoDTO solicitacaoServicoDto = new SolicitacaoServicoDTO();
				if (solicitacaoServicoProblemaDto.getIdSolicitacaoServico() != null) {
					solicitacaoServicoDto = solicitacaoServicoService.restoreAll(solicitacaoServicoProblemaDto.getIdSolicitacaoServico());

				}

				if (solicitacaoServicoDto != null) {
					solicitacaoServicoProblemaDto.setNomeServico(solicitacaoServicoDto.getNomeServico());
				}

			}

			problemaDto.setSolicitacaoServicoSerializado(WebUtil.serializeObjects(listaSolicitacaoServico, document.getLanguage()));
		}

		ArrayList<ProblemaMudancaDTO> listaRequisicoesMudancasRelacionadas = (ArrayList<ProblemaMudancaDTO>) getProblemaMudancaService().findByIdProblema(problemaDto.getIdProblema());

		if (listaRequisicoesMudancasRelacionadas != null) {
			for (ProblemaMudancaDTO problemaMudanca : listaRequisicoesMudancasRelacionadas) {
				RequisicaoMudancaDTO requisicaoMudancaDto = new RequisicaoMudancaDTO();
				if (problemaMudanca.getIdRequisicaoMudanca() != null) {
					requisicaoMudancaDto = getRequisicaoMudancaService().restoreAll(problemaMudanca.getIdRequisicaoMudanca());
				}

				if (requisicaoMudancaDto != null) {
					problemaMudanca.setIdRequisicaoMudanca(requisicaoMudancaDto.getIdRequisicaoMudanca());
					problemaMudanca.setTitulo(requisicaoMudancaDto.getTitulo());
					problemaMudanca.setDescrStatus(UtilI18N.internacionaliza(request, requisicaoMudancaDto.getDescrStatus()));
				}
			}
			problemaDto.setRequisicaoMudancaSerializado(WebUtil.serializeObjects(listaRequisicoesMudancasRelacionadas, document.getLanguage()));
		}

	}

	/**
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author breno.guimaraes
	 */
	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		document.getJanelaPopupById("JANELA_AGUARDE_MENU").show();
		this.setProblemaDto((ProblemaDTO) document.getBean());

		if (this.getProblemaDto() != null) {

			UsuarioDTO usuarioDto = br.com.centralit.citcorpore.util.WebUtil.getUsuario(request);

			ArrayList<ProblemaItemConfiguracaoDTO> ics = (ArrayList<ProblemaItemConfiguracaoDTO>) WebUtil.deserializeCollectionFromRequest(ProblemaItemConfiguracaoDTO.class,"itensConfiguracaoRelacionadosSerializado", request);

			this.getProblemaDto().setListProblemaItemConfiguracaoDTO(ics);

			ArrayList<SolicitacaoServicoDTO> listIdSolicitacaoServico = (ArrayList<SolicitacaoServicoDTO>) WebUtil.deserializeCollectionFromRequest(SolicitacaoServicoDTO.class, "solicitacaoServicoSerializado", request);

			this.getProblemaDto().setListIdSolicitacaoServico(listIdSolicitacaoServico);

			ArrayList<ProblemaMudancaDTO> rdm = (ArrayList<ProblemaMudancaDTO>) WebUtil.deserializeCollectionFromRequest(ProblemaMudancaDTO.class, "RequisicaoMudancaSerializado", request);

			ArrayList<ProblemaDTO> problemaRelacionados = (ArrayList<ProblemaDTO>) WebUtil.deserializeCollectionFromRequest(ProblemaDTO.class, "colItensProblema_Serialize", request);
			ArrayList<BaseConhecimentoDTO> baseConhecimentoRelacionados = (ArrayList<BaseConhecimentoDTO>) WebUtil.deserializeCollectionFromRequest(BaseConhecimentoDTO.class, "colItensBaseConhecimento_Serialize", request);

			if (problemaRelacionados != null) {
				this.getProblemaDto().setListProblemaRelacionadoDTO(problemaRelacionados);
			}

			if (baseConhecimentoRelacionados != null) {
				this.getProblemaDto().setListProblemaBaseConhecimentoRelacionadoDTO(baseConhecimentoRelacionados);
			}

			this.getProblemaDto().setListProblemaMudancaDTO(rdm);

			this.getProblemaDto().setUsuarioDto(usuarioDto);

			this.getProblemaDto().setEnviaEmailCriacao("S");

			this.getProblemaDto().setEnviaEmailFinalizacao("S");

			this.getProblemaDto().setEnviaEmailPrazoSolucionarExpirou("S");

			ProblemaDTO problemaAuxDto = new ProblemaDTO();

			if (this.getProblemaDto().getIdProblema() != null) {

				problemaAuxDto.setIdProblema(this.getProblemaDto().getIdProblema());
				problemaAuxDto = (ProblemaDTO) this.getProblemaService(request).restore(problemaAuxDto);

				if (problemaAuxDto.getIdContrato() != null) {
					this.getProblemaDto().setIdContrato(problemaAuxDto.getIdContrato());
				}

				if (problemaAuxDto.getIdCategoriaProblema() != null) {
					this.getProblemaDto().setIdCategoriaProblema(problemaAuxDto.getIdCategoriaProblema());
				}

			}

			this.getProblemaService(request).deserializaInformacoesComplementares(this.getProblemaDto());

			/**
			 * Adicionado para salvar anexos
			 *
			 * @author mario.junior
			 * @since 31/10/2013 08:21
			 */
			Collection<UploadDTO> arquivosUpados = (Collection<UploadDTO>) request.getSession(true).getAttribute("colUploadRequisicaoProblemaGED");
			this.getProblemaDto().setColArquivosUpload(arquivosUpados);

			if (this.getProblemaDto().getIdProblema() == null) {

				this.setProblemaDto(getProblemaService(request).create(this.getProblemaDto()));

				this.gravaProblemaServicoNegocio();

				// Registra o email se tiver sido utilizado
				EmailSolicitacaoServicoService emailSolicitacaoServicoService = (EmailSolicitacaoServicoService) ServiceLocator.getInstance().getService(EmailSolicitacaoServicoService.class, null);

				if (this.getProblemaDto() != null && problemaDto.getMessageId() != null && problemaDto.getMessageId().trim().length() > 0) {

					EmailSolicitacaoServicoDTO emailDto = new EmailSolicitacaoServicoDTO();
					emailDto.setIdSolicitacao(this.getProblemaDto().getIdProblema());
					emailDto.setIdMessage(this.getProblemaDto().getMessageId());
					emailDto.setOrigem(TipoOrigemLeituraEmail.PROBLEMA.toString());
					emailSolicitacaoServicoService.create(emailDto);

				}

	            String comando = "mostraMensagemInsercao('" + UtilI18N.internacionaliza(request, "MSG05") + ".<br>" + UtilI18N.internacionaliza(request, "problema.numero") + " <b><u>" +
	            this.getProblemaDto().getIdProblema() + "</u></b> " + UtilI18N.internacionaliza(request, "citcorpore.comum.criado") + ".<br><br>" + UtilI18N.internacionaliza(request,"prioridade.prioridade") +
	            ": " + this.getProblemaDto().getPrioridade() + "' ";

				comando = comando + ", " + this.getProblemaDto().getIdProblema() + " )";

				document.executeScript("verificaRelacionado(" + this.getProblemaDto().getIdProblema() + ")");

				document.executeScript(comando);
				document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();

				if (this.getProblemaDto() != null && this.getProblemaDto().getIframeSolicitacao().equalsIgnoreCase("true")) {
					document.executeScript("parent.inserirProblemaNalista('" + this.getProblemaDto().getIdProblema() + "')");
				}

				return;

			} else {

				/**
				 * @author geber.costa se o problema for criado a aba de reviso no aparecer, porm a partir do problema criado pode ser usada a aba de reviso
				 */

				if (this.getProblemaDto().getAcompanhamento() == null || this.getProblemaDto().getAcompanhamento().equals("N")) {

					this.getProblemaDto().setAcompanhamento("N");

				} else {

					this.getProblemaDto().setAcompanhamento("S");

				}

				// getProblemaService(request).updateNotNull(this.getProblemaDto());
				getProblemaService(request).update(this.getProblemaDto());

				this.gravaProblemaServicoNegocio();

				try {

					// Registra o email se tiver sido utilizado
	                EmailSolicitacaoServicoService emailSolicitacaoServicoService = (EmailSolicitacaoServicoService) ServiceLocator.getInstance().getService(EmailSolicitacaoServicoService.class, null);

					if (this.getProblemaDto() != null && this.getProblemaDto().getMessageId() != null && this.getProblemaDto().getMessageId().trim().length() > 0) {

						EmailSolicitacaoServicoDTO emailDto = emailSolicitacaoServicoService.getEmailByIdSolicitacaoAndOrigem(this.getProblemaDto().getIdSolicitacaoServico(), TipoOrigemLeituraEmail.PROBLEMA.toString());

						if (emailDto != null && emailDto.getIdEmail() != null) {

							emailDto.setIdMessage(this.getProblemaDto().getMessageId());
							emailDto.setOrigem(TipoOrigemLeituraEmail.PROBLEMA.toString());
							emailSolicitacaoServicoService.update(emailDto);

						} else {

							emailDto = new EmailSolicitacaoServicoDTO();
							emailDto.setIdSolicitacao(this.getProblemaDto().getIdProblema());
							emailDto.setIdMessage(this.getProblemaDto().getMessageId());
							emailDto.setOrigem(TipoOrigemLeituraEmail.PROBLEMA.toString());
							emailSolicitacaoServicoService.create(emailDto);

						}
					}

				} catch (Exception e) {
					e.printStackTrace();
				}

				document.alert(UtilI18N.internacionaliza(request, "MSG06"));
			}

			limparFormularioConsiderandoFCKEditores(document, "form");
			document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
			document.executeScript("fechar('" + this.getProblemaDto().getIdProblema() + "');");

		} else {
			document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
		}

		document.executeScript("$(\"[class*='Valid']\" ).off('focus', collapseWidgetOnFocus);");
	}

	/**
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author breno.guimaraes
	 */
	public void delete(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		problemaDto = (ProblemaDTO) document.getBean();

		getProblemaService(request).deleteAll(problemaDto);

		if (problemaDto.getIdProblema() != null) {
			limparFormularioConsiderandoFCKEditores(document, "form");
			document.alert(UtilI18N.internacionaliza(request, "MSG07"));
		}
	}

	/**
	 * Atualiza as informaes de nome de proprietario e nome de solicitante em uma requisicaoMudancaDto, caso haja.
	 *
	 * @param requisicaoMudancaDto
	 * @throws ServiceException
	 * @throws Exception
	 */
	private void atribuirNomeProprietarioECriadorParaRequisicaoDto(ProblemaDTO problemaDto) throws ServiceException, Exception {
		if (problemaDto == null) {
			return;
		}

		Integer idProprietario = problemaDto.getIdProprietario();
		Integer idSolicitante = problemaDto.getIdSolicitante();

		if (idProprietario != null && idSolicitante != null) {

			// problemaDto.setNomeProprietario(usuarioDto.getNomeUsuario());
			problemaDto.setSolicitante(getEmpregadoService().restoreByIdEmpregado(idSolicitante).getNome());
		}
	}

	public void carregaServicosMulti(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		ProblemaDTO problemaDto = (ProblemaDTO) document.getBean();
		if (problemaDto.getIdContrato() != null && problemaDto.getIdContrato().intValue() == 0) {
			HTMLSelect idServico = document.getSelectById("idServico");
			idServico.removeAllOptions();

			String controleAccUnidade = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.CONTROLE_ACC_UNIDADE_INC_SOLIC, "N");

			if (!UtilStrings.isNotVazio(controleAccUnidade)) {
				controleAccUnidade = "N";
			}

			EmpregadoService empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, null);
			int idUnidade = -999;
			if (controleAccUnidade.trim().equalsIgnoreCase("S")) {
				EmpregadoDTO empregadoDto = new EmpregadoDTO();
				empregadoDto.setIdEmpregado(problemaDto.getIdProprietario());
				if (problemaDto.getIdProprietario() != null) {
					empregadoDto = (EmpregadoDTO) empregadoService.restore(empregadoDto);
					if (empregadoDto != null && empregadoDto.getIdUnidade() != null) {
						idUnidade = empregadoDto.getIdUnidade().intValue();
					}
				}
			}

			ServicoService servicoService = (ServicoService) ServiceLocator.getInstance().getService(ServicoService.class, null);
			UnidadesAccServicosService unidadeAccService = (UnidadesAccServicosService) ServiceLocator.getInstance().getService(UnidadesAccServicosService.class, null);
			idServico.removeAllOptions();
			Collection col = servicoService.findByIdTipoDemandaAndIdContrato(3, problemaDto.getIdContrato(), null);

			int cont = 0;
			Integer idServicoCasoApenas1 = null;
			if (col != null) {
				// this.verificaImpactoUrgencia(document, request, response);
				/* if (col.size() > 1) */

				idServico.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

				for (Iterator it = col.iterator(); it.hasNext();) {
					ServicoDTO servicoDTO = (ServicoDTO) it.next();
					if (servicoDTO.getDeleted() == null || servicoDTO.getDeleted().equalsIgnoreCase("N")) {
						if (servicoDTO.getIdSituacaoServico().intValue() == 1) { // ATIVO
							if (controleAccUnidade.trim().equalsIgnoreCase("S")) {
								UnidadesAccServicosDTO unidadesAccServicosDTO = new UnidadesAccServicosDTO();
								unidadesAccServicosDTO.setIdServico(servicoDTO.getIdServico());
								unidadesAccServicosDTO.setIdUnidade(idUnidade);
								unidadesAccServicosDTO = (UnidadesAccServicosDTO) unidadeAccService.restore(unidadesAccServicosDTO);
								if (unidadesAccServicosDTO != null) {// Se existe acesso
									idServico.addOptionIfNotExists("" + servicoDTO.getIdServico(), servicoDTO.getNomeServico());
									idServicoCasoApenas1 = servicoDTO.getIdServico();
									cont++;
								}
							} else {
								idServico.addOptionIfNotExists("" + servicoDTO.getIdServico(), servicoDTO.getNomeServico());
								idServicoCasoApenas1 = servicoDTO.getIdServico();
								cont++;
							}
						}
					}
				}
				// --- RETITRADO POR EMAURI EM 16/07 - TRATAMENTO DE DELETED --> idServico.addOptions(col, "idServico", "nomeServico", null);
			}
			if (cont == 1) { // Se for apenas um servico encontrado, ja executa o carrega contratos.
				problemaDto.setIdServico(idServicoCasoApenas1);
			}
		}
	}

	/**
	 * form.clear no funciona para os FCKEditores. Esta funo garante que todo o formulrio ser limpado.
	 *
	 * @param document
	 * @param nomeFormulario
	 * @author breno.guimaraes
	 */
	private void limparFormularioConsiderandoFCKEditores(DocumentHTML document, String nomeFormulario) {
		document.executeScript("limpar(document." + nomeFormulario + ")");
	}

	/**
	 * @throws ServiceException
	 * @throws Exception
	 * @author breno.guimaraes
	 */
	private ProblemaService getProblemaService(HttpServletRequest request) throws ServiceException, Exception {

		if (problemaService == null) {
			problemaService = (ProblemaService) ServiceLocator.getInstance().getService(ProblemaService.class, br.com.centralit.citcorpore.util.WebUtil.getUsuarioSistema(request));
		}
		return problemaService;
	}

	/**
	 * @throws ServiceException
	 * @throws Exception
	 * @author thays.araujo
	 */
	private SolicitacaoServicoProblemaService getSolicitacaoServicoProblemaService() throws ServiceException, Exception {
		if (solicitacaoServicoProblemaService == null) {
			solicitacaoServicoProblemaService = (SolicitacaoServicoProblemaService) ServiceLocator.getInstance().getService(SolicitacaoServicoProblemaService.class, null);
		}
		return solicitacaoServicoProblemaService;
	}

	private EmpregadoService getEmpregadoService() throws ServiceException, Exception {
		if (usuarioService == null) {
			usuarioService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, null);
		}
		return usuarioService;
	}

	private CategoriaProblemaService getCategoriaProblemaService() throws ServiceException, Exception {
		if (categoriaProblemaService == null) {
			categoriaProblemaService = (CategoriaProblemaService) ServiceLocator.getInstance().getService(CategoriaProblemaService.class, null);
		}
		return categoriaProblemaService;
	}

	private ProblemaItemConfiguracaoService getProblemaItemConfiguracaoService() throws ServiceException, Exception {
		if (problemaItemConfiguracaoService == null) {
			problemaItemConfiguracaoService = (ProblemaItemConfiguracaoService) ServiceLocator.getInstance().getService(ProblemaItemConfiguracaoService.class, null);
		}
		return problemaItemConfiguracaoService;
	}

	private ProblemaMudancaService getProblemaMudancaService() throws ServiceException, Exception {
		if (problemaMudancaService == null) {
			problemaMudancaService = (ProblemaMudancaService) ServiceLocator.getInstance().getService(ProblemaMudancaService.class, null);
		}
		return problemaMudancaService;
	}

	private ItemConfiguracaoService getItemConfiguracaoService() throws ServiceException, Exception {
		if (itemConfiguracaoService == null) {
			itemConfiguracaoService = (ItemConfiguracaoService) ServiceLocator.getInstance().getService(ItemConfiguracaoService.class, null);
		}
		return itemConfiguracaoService;
	}

	private RequisicaoMudancaService getRequisicaoMudancaService() throws ServiceException, Exception {
		if (requisicaoMudancaService == null) {
			requisicaoMudancaService = (RequisicaoMudancaService) ServiceLocator.getInstance().getService(RequisicaoMudancaService.class, null);
		}
		return requisicaoMudancaService;
	}

	private PastaService getPastaService() throws ServiceException, Exception {
		if (pastaService == null) {
			pastaService = (PastaService) ServiceLocator.getInstance().getService(PastaService.class, null);
		}
		return pastaService;
	}

	public void preencherComboCausa(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		CausaIncidenteService causaIncidenteService = (CausaIncidenteService) ServiceLocator.getInstance().getService(CausaIncidenteService.class, null);
		Collection colCausas = causaIncidenteService.listHierarquia();
		HTMLSelect comboCausa = document.getSelectById("idCausa");

		comboCausa.removeAllOptions();
		comboCausa.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
		if (colCausas != null) {
			comboCausa.addOptions(colCausas, "idCausaIncidente", "descricaoCausaNivel", null);
		}
	}

	public void preencherComboCategoriaSolucao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		CategoriaSolucaoService categoriaSolucaoService = (CategoriaSolucaoService) ServiceLocator.getInstance().getService(CategoriaSolucaoService.class, null);

		Collection colCategSolucao = categoriaSolucaoService.listHierarquia();
		HTMLSelect idCategoriaSolucao = document.getSelectById("idCategoriaSolucao");
		idCategoriaSolucao.removeAllOptions();
		idCategoriaSolucao.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
		if (colCategSolucao != null) {
			idCategoriaSolucao.addOptions(colCategSolucao, "idCategoriaSolucao", "descricaoCategoriaNivel", null);
		}
	}

        /**
	 * Quando um "Problema" foi cadastrado, sendo associado a uma "Categoria Soluo" que foi posteriormente excluda lgicamente, surgia o problema de que no era mais trazido a "Categoria Soluo" associada ao "Problema". Assim, como soluo tem-se
	 * este outro mtodo de preenchimento do combo de Categoria soluo, que traz todas as "Categorias Soluo" cadastradas e vlidas, seguindo as mesma regras do mtodo "problema.preencherComboCategoriaSolucao()", alm de trazer tambm apenas uma
	 * "Categoria Soluo" excluda, se houver associao.
	 *
	 * @author rcs - Analista Desenvolvedor <a href="rafael.soyer@centralit.com.br">rafael.soyer@centralit. com.br</a>
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @since 08/05/2015
	 */
        public void preencherComboCategoriaSolucaoMesmoQuandoDeleted(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

            CategoriaSolucaoService categoriaSolucaoService = (CategoriaSolucaoService) ServiceLocator.getInstance().getService(CategoriaSolucaoService.class, null);
            Collection colCategSolucao = categoriaSolucaoService.buscaCategoriasSolucoesMesmoQuandoDeleted(this.problemaDto.getIdCategoriaSolucao());
            HTMLSelect idCategoriaSolucao = document.getSelectById("idCategoriaSolucao");
            idCategoriaSolucao.removeAllOptions();
            idCategoriaSolucao.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
            if (colCategSolucao != null) {
                idCategoriaSolucao.addOptions(colCategSolucao, "idCategoriaSolucao", "descricaoCategoriaNivel", null);
            }
        }

	public void restoreColaboradorSolicitante(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		ProblemaDTO problemaDto = (ProblemaDTO) document.getBean();
		EmpregadoService empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, null);

		EmpregadoDTO empregadoDto = new EmpregadoDTO();
		if (problemaDto.getIdSolicitante() != null) {
			empregadoDto.setIdEmpregado(problemaDto.getIdSolicitante());
			empregadoDto = (EmpregadoDTO) empregadoService.restore(empregadoDto);

			problemaDto.setSolicitante(empregadoDto.getNome());
			problemaDto.setNomeContato(empregadoDto.getNome());
			problemaDto.setTelefoneContato(empregadoDto.getTelefone());
			problemaDto.setRamal(empregadoDto.getRamal());
			problemaDto.setEmailContato(empregadoDto.getEmail().trim());
			problemaDto.setObservacao(empregadoDto.getObservacoes());
			problemaDto.setIdUnidade(empregadoDto.getIdUnidade());
			this.preencherComboLocalidade(document, request, response);
		}

		document.executeScript("Modal.close('modal-problema-add-solicitante');");

		HTMLForm form = document.getForm("form");
		form.setValues(problemaDto);
		form.setValueText("ramal", null, problemaDto.getRamal());
		form.setValueText("telefoneContato", null, problemaDto.getTelefoneContato());
		if(problemaDto.getIdUnidade()!= null){
			UnidadeService unidadeService = (UnidadeService) ServiceLocator.getInstance().getService(UnidadeService.class, null);
			UnidadeDTO unidadeDto = new UnidadeDTO();
			unidadeDto.setIdUnidade(problemaDto.getIdUnidade());
			unidadeDto = unidadeService.restore(unidadeDto);
			form.setValueText("unidadeDes", null, unidadeDto.getNome());
		}else{
			form.setValueText("unidadeDes", null, "");
		}

		problemaDto = null;
	}

	public void preencherComboLocalidade(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		ProblemaDTO problemaDto = (ProblemaDTO) document.getBean();

		LocalidadeUnidadeService localidadeUnidadeService = (LocalidadeUnidadeService) ServiceLocator.getInstance().getService(LocalidadeUnidadeService.class, null);

		LocalidadeService localidadeService = (LocalidadeService) ServiceLocator.getInstance().getService(LocalidadeService.class, null);

		LocalidadeDTO localidadeDto = new LocalidadeDTO();

		Collection<LocalidadeUnidadeDTO> listaIdlocalidadePorUnidade = null;

		Collection<LocalidadeDTO> listaIdlocalidade = null;

		String TIRAR_VINCULO_LOCALIDADE_UNIDADE = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.TIRAR_VINCULO_LOCALIDADE_UNIDADE, "N");

		HTMLSelect comboLocalidade = document.getSelectById("idLocalidade");
		comboLocalidade.removeAllOptions();
		if (TIRAR_VINCULO_LOCALIDADE_UNIDADE.trim().equalsIgnoreCase("N") || TIRAR_VINCULO_LOCALIDADE_UNIDADE.trim().equalsIgnoreCase("")) {
			if (problemaDto.getIdUnidade() != null) {
				listaIdlocalidadePorUnidade = localidadeUnidadeService.listaIdLocalidades(problemaDto.getIdUnidade());
			}
			if (listaIdlocalidadePorUnidade != null) {
				inicializarComboLocalidade(comboLocalidade, request);
				for (LocalidadeUnidadeDTO localidadeUnidadeDto : listaIdlocalidadePorUnidade) {
					localidadeDto.setIdLocalidade(localidadeUnidadeDto.getIdLocalidade());
					localidadeDto = (LocalidadeDTO) localidadeService.restore(localidadeDto);
					comboLocalidade.addOption(localidadeDto.getIdLocalidade().toString(), localidadeDto.getNomeLocalidade());
				}

			}
		} else {
			listaIdlocalidade = localidadeService.listLocalidade();
			if (listaIdlocalidade != null) {
				inicializarComboLocalidade(comboLocalidade, request);
				for (LocalidadeDTO localidadeDTO : listaIdlocalidade) {
					localidadeDto.setIdLocalidade(localidadeDTO.getIdLocalidade());
					localidadeDto = (LocalidadeDTO) localidadeService.restore(localidadeDto);
					comboLocalidade.addOption(localidadeDto.getIdLocalidade().toString(), localidadeDto.getNomeLocalidade());
				}
			}

		}

	}

	private void inicializarComboLocalidade(HTMLSelect componenteCombo, HttpServletRequest request) {
		componenteCombo.removeAllOptions();
		componenteCombo.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
	}

	public void carregaUnidade(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		ProblemaDTO problemaDto = (ProblemaDTO) document.getBean();
		carregaUnidade(document, request, problemaDto.getIdContrato());
	}

	private void carregaUnidade(DocumentHTML document, HttpServletRequest request, Integer idContrato) throws Exception {
		String validarComboUnidade = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.UNIDADE_VINC_CONTRATOS, "N");

		if (idContrato != null){
			UnidadeService unidadeService = (UnidadeService) ServiceLocator.getInstance().getService(UnidadeService.class, null);
			HTMLSelect comboUnidade = document.getSelectById("idUnidade");
			inicializarCombo(comboUnidade, request);
			if (validarComboUnidade.trim().equalsIgnoreCase("S")) {
				ArrayList<UnidadeDTO> unidades = (ArrayList) unidadeService.listHierarquiaMultiContratos(idContrato);
				if (unidades != null) {
					for (UnidadeDTO unidade : unidades) {
						if (unidade.getDataFim() == null) {
							comboUnidade.addOption(unidade.getIdUnidade().toString(), StringEscapeUtils.escapeJavaScript(unidade.getNomeNivel()));
						}

					}
				}
			} else {
				ArrayList<UnidadeDTO> unidades = (ArrayList) unidadeService.listHierarquia();
				if (unidades != null) {
					for (UnidadeDTO unidade : unidades) {
						if (unidade.getDataFim() == null) {
							comboUnidade.addOption(unidade.getIdUnidade().toString(), StringEscapeUtils.escapeJavaScript(unidade.getNomeNivel()));
						}
					}
				}
			}
		}

	}

	private void inicializarCombo(HTMLSelect componenteCombo, HttpServletRequest request) {
		componenteCombo.removeAllOptions();
		componenteCombo.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
	}

	public void preencherComboGrupoExecutor(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		document.getSelectById("idGrupo").removeAllOptions();

		GrupoService grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);

		Collection<GrupoDTO> listGrupo = grupoService.listaGruposAtivos();

		document.getSelectById("idGrupo").addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

		document.getSelectById("idGrupo").addOptions(listGrupo, "idGrupo", "nome", null);

	}

	public void preencherComboOrigem(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		OrigemAtendimentoService origemService = (OrigemAtendimentoService) ServiceLocator.getInstance().getService(OrigemAtendimentoService.class, null);
		HTMLSelect idOrigem = document.getSelectById("idOrigemAtendimento");
		idOrigem.removeAllOptions();
		document.getSelectById("idOrigemAtendimento").addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

		Collection col = origemService.recuperaAtivos();
		String origemPadrao = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.ORIGEM_PADRAO_SOLICITACAO, "").trim();
		if (col != null) {
			if (origemPadrao != null && !origemPadrao.equals("")) {
				idOrigem.addOptions(col, "idOrigem", "descricao", origemPadrao);
			} else {
				idOrigem.addOptions(col, "idOrigem", "descricao", null);
			}
		}
	}

	/**
	 *
	 * @param problemaDto
	 * @param request
	 * @return
	 * @throws ServiceException
	 * @throws Exception
	 * @author geber.costa retorna uma lista com os registros de execuo de um problema
	 */

	public String listInfoRegExecucaoProblema(ProblemaDTO problemaDto, HttpServletRequest request) throws ServiceException, Exception {

		JustificativaProblemaService justificativaProblemaService = (JustificativaProblemaService) ServiceLocator.getInstance().getService(JustificativaProblemaService.class, null);

		OcorrenciaProblemaService ocorrenciaProblemaService = (OcorrenciaProblemaService) ServiceLocator.getInstance().getService(OcorrenciaProblemaService.class, null);

		Collection<OcorrenciaProblemaDTO> col = ocorrenciaProblemaService.findByIdProblema(problemaDto.getIdProblema());

		CategoriaOcorrenciaDTO categoriaOcorrenciaDTO = new CategoriaOcorrenciaDTO();

		String strBuffer = "<table class='dynamicTable table table-striped table-bordered table-condensed dataTable' style='table-layout: fixed;'>";
		strBuffer += "<tr>";
		strBuffer += "<th style='width:20%'>";
		strBuffer += UtilI18N.internacionaliza(request, "citcorpore.comum.datahora");
		strBuffer += "</th>";
		strBuffer += "<th>";
		strBuffer += UtilI18N.internacionaliza(request, "solicitacaoServico.informacaoexecucao");
		strBuffer += "</th>";
		strBuffer += "</tr>";

		if (col != null) {

			for (OcorrenciaProblemaDTO ocorrenciaProblemaDto : col) {

				if (ocorrenciaProblemaDto.getOcorrencia() != null) {
					Source source = new Source(ocorrenciaProblemaDto.getOcorrencia());
					ocorrenciaProblemaDto.setOcorrencia(source.getTextExtractor().toString());
				}

				String ocorrencia = UtilStrings.nullToVazio(ocorrenciaProblemaDto.getOcorrencia());
				String informacoesContato = UtilStrings.nullToVazio(ocorrenciaProblemaDto.getInformacoesContato());
				ocorrencia = ocorrencia.replaceAll("\"", "");
				informacoesContato = informacoesContato.replaceAll("\"", "");
				ocorrencia = ocorrencia.replaceAll("\n", "<br>");
				informacoesContato = informacoesContato.replaceAll("\n", "<br>");
				ocorrencia = UtilHTML.encodeHTML(ocorrencia.replaceAll("\'", ""));
				informacoesContato = UtilHTML.encodeHTML(informacoesContato.replaceAll("\'", ""));
				strBuffer += "<tr>";
				strBuffer += "<td >";
				strBuffer += "<b>" + UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, ocorrenciaProblemaDto.getDataregistro(), WebUtil.getLanguage(request)) + " - "
						+ ocorrenciaProblemaDto.getHoraregistro();
				strBuffer += " - </b>" + UtilI18N.internacionaliza(request, "ocorrenciaSolicitacao.registradopor") + ": <b>" + ocorrenciaProblemaDto.getRegistradopor() + "</b>";
				strBuffer += "</td>";
				strBuffer += "<td style='word-wrap: break-word;overflow:hidden;'>";

				if (!UtilNumbersAndDecimals.isNullOrZeroOrEmpty(ocorrenciaProblemaDto.getIdCategoriaOcorrencia())) {
					categoriaOcorrenciaDTO.setIdCategoriaOcorrencia(ocorrenciaProblemaDto.getIdCategoriaOcorrencia());
					categoriaOcorrenciaDTO = getCategoriaOcorrenciaService().restore(categoriaOcorrenciaDTO);
					strBuffer += "<b>" + categoriaOcorrenciaDTO.getNome() + "<br><br></b>";
				} else {
					strBuffer += "<b>" + UtilI18N.internacionaliza(request, OccurrenceCategory.chaveFromId(ocorrenciaProblemaDto.getIdOccurrenceCategory())) + "<br><br></b>";
				}

				strBuffer += "<b>";

				String execucaoDaTarefa = "Execu&ccedil;&atilde;o&nbsp;da&nbsp;tarefa&nbsp;";
				if (ocorrencia.indexOf(execucaoDaTarefa) > -1) {
					ocorrencia = ocorrencia.substring(execucaoDaTarefa.length());
					strBuffer += UtilI18N.internacionaliza(request, "citcorpore.comum.execucaoTarefa") + " ";
				}

				strBuffer += ocorrencia + "<br><br></b>";

				if (!UtilNumbersAndDecimals.isNullOrZeroOrEmpty(ocorrenciaProblemaDto.getIdOccurrenceCategory())
						&& (OccurrenceCategory.REQUEST_SUSPENSION.getId().equals(ocorrenciaProblemaDto.getIdOccurrenceCategory()) || OccurrenceCategory.SLA_CHANGE.getId().equals(ocorrenciaProblemaDto.getIdOccurrenceCategory()))) {
						JustificativaProblemaDTO justificativaSolicitacaoDTO = new JustificativaProblemaDTO();
						if (ocorrenciaProblemaDto.getIdJustificativa() != null) {
							justificativaSolicitacaoDTO.setIdJustificativaProblema(ocorrenciaProblemaDto.getIdJustificativa());
							justificativaSolicitacaoDTO = (JustificativaProblemaDTO) justificativaProblemaService.restore(justificativaSolicitacaoDTO);
							if (justificativaSolicitacaoDTO != null) {

								strBuffer += UtilI18N.internacionaliza(request, "citcorpore.comum.justificativa") + ": <b>" + justificativaSolicitacaoDTO.getDescricaoProblema() + "<br><br></b>";
							}
						}
						if (!UtilStrings.nullToVazio(ocorrenciaProblemaDto.getComplementoJustificativa()).trim().equalsIgnoreCase("")) {
							strBuffer += "<b>" + UtilStrings.nullToVazio(ocorrenciaProblemaDto.getComplementoJustificativa()) + "<br><br></b>";
						}
					}

				if (ocorrenciaProblemaDto.getOcorrencia() != null) {
					if (categoriaOcorrenciaDTO.getNome() != null && !categoriaOcorrenciaDTO.getNome().equals("")) {
						if (categoriaOcorrenciaDTO.getNome().equalsIgnoreCase(Enumerados.OccurrenceCategory.REQUEST_SUSPENSION.toString())
								|| categoriaOcorrenciaDTO.getNome().equalsIgnoreCase(Enumerados.OccurrenceCategory.SLA_CHANGE.toString())) {
							JustificativaProblemaDTO justificativaSolicitacaoDTO = new JustificativaProblemaDTO();
							if (ocorrenciaProblemaDto.getIdJustificativa() != null) {

								justificativaSolicitacaoDTO.setIdJustificativaProblema(ocorrenciaProblemaDto.getIdJustificativa());
								justificativaSolicitacaoDTO = (JustificativaProblemaDTO) justificativaProblemaService.restore(justificativaSolicitacaoDTO);
								if (justificativaSolicitacaoDTO != null) {
									strBuffer += UtilI18N.internacionaliza(request, "citcorpore.comum.justificativa") + ": <b>" + justificativaSolicitacaoDTO.getDescricaoProblema() + "<br><br></b>";
								}
							}
							if (!UtilStrings.nullToVazio(ocorrenciaProblemaDto.getComplementoJustificativa()).trim().equalsIgnoreCase("")) {
								strBuffer += "<b>" + UtilStrings.nullToVazio(ocorrenciaProblemaDto.getComplementoJustificativa()) + "<br><br></b>";
							}
						}
					}
				}

				strBuffer += "</td>";
				strBuffer += "</tr>";
			}
		}
		strBuffer += "</table>";

		return strBuffer;
	}

	public void restoreComboUnidade(String editar, ProblemaDTO problemaDto, DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		String UNIDADE_AUTOCOMPLETE = ParametroUtil.getValorParametroCitSmartHashMap(br.com.centralit.citcorpore.util.Enumerados.ParametroSistema.UNIDADE_AUTOCOMPLETE, "N");
		if (UNIDADE_AUTOCOMPLETE != null && !UNIDADE_AUTOCOMPLETE.equalsIgnoreCase("S")) {
		UnidadeService unidadeService = (UnidadeService) ServiceLocator.getInstance().getService(UnidadeService.class, null);
			HTMLSelect comboUnidade = document.getSelectById("idUnidade");
			if (editar == null || editar.equalsIgnoreCase("") || editar.equalsIgnoreCase("S")) {
			String validarComboUnidade = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.UNIDADE_VINC_CONTRATOS, "N");
				if (problemaDto.getIdUnidade() != null) {
					inicializarCombo(comboUnidade, request);
					if (validarComboUnidade.trim().equalsIgnoreCase("S")) {
						if (problemaDto.getIdContrato() != null && problemaDto.getIdContrato().intValue() > 0) {
							ArrayList<UnidadeDTO> unidades = (ArrayList) unidadeService.listHierarquiaMultiContratos(problemaDto.getIdContrato());
						if (unidades != null) {
							for (UnidadeDTO unidade : unidades) {
								if (unidade.getDataFim() == null) {
									comboUnidade.addOption(unidade.getIdUnidade().toString(), StringEscapeUtils.escapeJavaScript(unidade.getNomeNivel()));
								}
							}
						}
						}
					} else {
						ArrayList<UnidadeDTO> unidades = (ArrayList) unidadeService.listHierarquia();
						if (unidades != null) {
							for (UnidadeDTO unidade : unidades) {
								if (unidade.getDataFim() == null) {
									comboUnidade.addOption(unidade.getIdUnidade().toString(), StringEscapeUtils.escapeJavaScript(unidade.getNomeNivel()));
								}
							}
						}
					}
				}
			} else {
				if (problemaDto.getIdUnidade() != null) {
					comboUnidade.removeAllOptions();
					UnidadeDTO unidadeDTO = new UnidadeDTO();
					unidadeDTO.setIdUnidade(problemaDto.getIdUnidade());
					unidadeDTO = (UnidadeDTO) unidadeService.restore(unidadeDTO);
					if (unidadeDTO!=null&&unidadeDTO.getIdUnidade()!=null){
						comboUnidade.addOption(unidadeDTO.getIdUnidade().toString(), StringEscapeUtils.escapeJavaScript(unidadeDTO.getNome()));
			}
		}
	}
		}
	}

	public void restoreComboLocalidade(ProblemaDTO ProblemaDto, DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		if (ProblemaDto.getIdProblema() != null && ProblemaDto.getIdProblema().intValue() > 0) {

			String TIRAR_VINCULO_LOCALIDADE_UNIDADE = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.TIRAR_VINCULO_LOCALIDADE_UNIDADE, "N");

			if (ProblemaDto.getIdLocalidade() != null) {

				LocalidadeUnidadeService localidadeUnidadeService = (LocalidadeUnidadeService) ServiceLocator.getInstance().getService(LocalidadeUnidadeService.class, null);
				LocalidadeService localidadeService = (LocalidadeService) ServiceLocator.getInstance().getService(LocalidadeService.class, null);
				LocalidadeDTO localidadeDto = new LocalidadeDTO();
				Collection<LocalidadeUnidadeDTO> listaIdlocalidadePorUnidade = null;
				Collection<LocalidadeDTO> listaIdlocalidade = null;

				HTMLSelect comboLocalidade = document.getSelectById("idLocalidade");
				comboLocalidade.removeAllOptions();
				if (TIRAR_VINCULO_LOCALIDADE_UNIDADE.trim().equalsIgnoreCase("N") || TIRAR_VINCULO_LOCALIDADE_UNIDADE.trim().equalsIgnoreCase("")) {
					if (ProblemaDto.getIdUnidade() != null) {
						listaIdlocalidadePorUnidade = localidadeUnidadeService.listaIdLocalidades(ProblemaDto.getIdUnidade());
					}
					if (listaIdlocalidadePorUnidade != null) {
						inicializarComboLocalidade(comboLocalidade, request);
						for (LocalidadeUnidadeDTO localidadeUnidadeDto : listaIdlocalidadePorUnidade) {
							localidadeDto.setIdLocalidade(localidadeUnidadeDto.getIdLocalidade());
							localidadeDto = (LocalidadeDTO) localidadeService.restore(localidadeDto);
							comboLocalidade.addOption(localidadeDto.getIdLocalidade().toString(), localidadeDto.getNomeLocalidade());
						}

					}
				} else {
					listaIdlocalidade = localidadeService.listLocalidade();
					if (listaIdlocalidade != null) {
						inicializarComboLocalidade(comboLocalidade, request);
						for (LocalidadeDTO localidadeDTO : listaIdlocalidade) {
							localidadeDto.setIdLocalidade(localidadeDTO.getIdLocalidade());
							localidadeDto = (LocalidadeDTO) localidadeService.restore(localidadeDto);
							comboLocalidade.addOption(localidadeDto.getIdLocalidade().toString(), localidadeDto.getNomeLocalidade());
						}
					}
				}
			}
		}
	}

	public void preencherComboOrigemAtendimento(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		HTMLSelect comboOrigem = document.getSelectById("idOrigemAtendimento");

		OrigemAtendimentoService origemAtendimentoService = (OrigemAtendimentoService) ServiceLocator.getInstance().getService(OrigemAtendimentoService.class, null);
		Collection<OrigemAtendimentoDTO> listOrigem = origemAtendimentoService.list();

		comboOrigem.removeAllOptions();
		comboOrigem.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
		if (listOrigem != null) {
			for (OrigemAtendimentoDTO origemDTO : listOrigem) {
				if (origemDTO.getIdOrigem() != null || origemDTO.getIdOrigem() > 0) {
					comboOrigem.addOption(origemDTO.getIdOrigem().toString(), StringEscapeUtils.escapeJavaScript(origemDTO.getDescricao()));
				}
			}
		}

	}

	public void restoreComboOrigemAtendimento(ProblemaDTO problemaDto, DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (problemaDto.getIdProblema() != null && problemaDto.getIdProblema().intValue() > 0) {
			if (problemaDto.getIdOrigemAtendimento() != null && problemaDto.getIdOrigemAtendimento().intValue() > 0) {
				this.preencherComboOrigem(document, request, response);
			}
		}
	}

	/**
	 * Restaura Problemas na Grid.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author thays.araujo
	 */
	public void atualizaGridProblema(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		ProblemaDTO problemaDTO = (ProblemaDTO) document.getBean();
		ProblemaBaseConhecimentoService ProblemaBaseConhecimentoService = (ProblemaBaseConhecimentoService) ServiceLocator.getInstance().getService(ProblemaBaseConhecimentoService.class, null);

		List<ProblemaBaseConhecimentoRelacionadoDTO> errosConhecido = null;

		if (problemaDTO.getIdProblema() != null) {
			errosConhecido = ProblemaBaseConhecimentoService.findErroConhecidoByProblema(problemaDTO.getIdProblema());
		}

		HTMLTable tblErrosConhecidos = document.getTableById("tblErrosConhecidos");
		tblErrosConhecidos.deleteAllRows();

		if (errosConhecido != null) {
			String idErrosConhecidosStr = "";
			for(ProblemaBaseConhecimentoRelacionadoDTO erroConhecido : errosConhecido) {
				erroConhecido.setStatus(UtilI18N.internacionaliza(request, erroConhecido.getStatus()));
				idErrosConhecidosStr += "|" + erroConhecido.getIdBaseConhecimento() + "|";
			}

			tblErrosConhecidos.addRowsByCollection(errosConhecido, new String[] { "titulo", "status", "" }, null, null, new String[] { "exibeIconesEditarBaseConhecimento" }, null, null);
			if(this.getProblemaDto() == null) {
				this.setProblemaDto(problemaDTO);
			}

			this.getProblemaDto().setIdErrosConhecidosStr(idErrosConhecidosStr);
		}
	}

	public void deleteErroConhecido(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		ProblemaDTO problemaDTO = (ProblemaDTO) document.getBean();
		ProblemaBaseConhecimentoService ProblemaBaseConhecimentoService = (ProblemaBaseConhecimentoService) ServiceLocator.getInstance().getService(ProblemaBaseConhecimentoService.class, null);

		if (problemaDTO.getIdProblemaBaseConhecimentoRelacionado() != null) {
			ProblemaBaseConhecimentoRelacionadoDTO erroConhecido = new ProblemaBaseConhecimentoRelacionadoDTO();
			erroConhecido.setIdProblemaBaseConhecimentoRelacionado(problemaDTO.getIdProblemaBaseConhecimentoRelacionado());
			erroConhecido = ProblemaBaseConhecimentoService.restore(erroConhecido);
			ProblemaBaseConhecimentoService.delete(erroConhecido);
			this.atualizaGridProblema(document, request, response);
		}
	}

	public void atualizaGridProblemaRelacionados(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		ProblemaDTO bean = (ProblemaDTO) document.getBean();
		ProblemaService problemaService = (ProblemaService) ServiceLocator.getInstance().getService(ProblemaService.class, null);
		ProblemaDTO problemaDTO = new ProblemaDTO();

		problemaDTO.setIdProblema(bean.getIdProblemaRelacionado());

		problemaDTO = (ProblemaDTO) problemaService.restore(problemaDTO);
		if (problemaDTO == null) {
			return;
		}
		HTMLTable tblProblema = document.getTableById("tblProblema");
		problemaDTO.setDescrStatus(UtilI18N.internacionaliza(request, problemaDTO.getDescrStatus()));

		if (problemaDTO.getSequenciaProblema() == null) {
			tblProblema.addRow(problemaDTO, new String[] { "idProblema", "titulo", "descrStatus", " " },
					new String[] { "idProblema" }, UtilI18N.internacionaliza(request, "baseConhecimento.problemaExiste"),
					new String[] { "exibeIconesProblema" },
					null, null);
		} else {
			tblProblema.updateRow(problemaDTO, new String[] { "idProblema", "titulo", "descrStatus", " " },
					new String[] { "idProblema" }, UtilI18N.internacionaliza(request, "baseConhecimento.problemaExiste"),
					new String[] { "exibeIconesProblema" },
					"", null, problemaDTO.getSequenciaProblema());
		}
		document.executeScript("HTMLUtils.applyStyleClassInAllCells('tblProblema', 'tblProblema');");
		document.executeScript("fecharModalProblema();");
		bean = null;
	}

	public void atualizaGridConhecimentoRelacionado(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		ProblemaDTO bean = (ProblemaDTO) document.getBean();
		BaseConhecimentoService baseConhecimentoService = (BaseConhecimentoService) ServiceLocator.getInstance().getService(BaseConhecimentoService.class, null);
		BaseConhecimentoDTO baseConhecimentoDTO = new BaseConhecimentoDTO();
		baseConhecimentoDTO.setIdBaseConhecimento(bean.getIdConhecimento());

		baseConhecimentoDTO = (BaseConhecimentoDTO) baseConhecimentoService.restore(baseConhecimentoDTO);
		if (baseConhecimentoDTO == null) {
			return;
		}
		HTMLTable tblConhecimento = document.getTableById("tblConhecimento");


		if (baseConhecimentoDTO.getSequenciaBaseConhecimento() == null) {
			tblConhecimento.addRow(baseConhecimentoDTO, new String[] { "idBaseConhecimento", "titulo", "status", " " },
					new String[] { "idBaseConhecimento" }, UtilI18N.internacionaliza(request, "baseConhecimento.conhecimentoJaCadastrado"),
					new String[] { "exibeIconesConhecimento" },
					null, null);
		} else {
			tblConhecimento.updateRow(baseConhecimentoDTO,
					new String[] { "idBaseConhecimento", "titulo", "status", " " },
					new String[] { "idBaseConhecimento" }, UtilI18N.internacionaliza(request, "baseConhecimento.conhecimentoJaCadastrado"),
					new String[] { "exibeIconesConhecimento" },
					"", null, baseConhecimentoDTO.getSequenciaBaseConhecimento());
		}

		document.executeScript("HTMLUtils.applyStyleClassInAllCells('tblConhecimento', 'tblConhecimento');");
		document.executeScript("Modal.close('modal-problema-add-conhecimento');");
		bean = null;
	}


	public void limparTabelas(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLTable tblICs = document.getTableById("tblICs");
		tblICs.deleteAllRows();
		HTMLTable tblRDM = document.getTableById("tblRDM");
		tblRDM.deleteAllRows();
		HTMLTable tblSolicitacaoServico = document.getTableById("tblSolicitacaoServico");
		tblSolicitacaoServico.deleteAllRows();
	}

	/**
	 * preencher comobo de calendario
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author geber.costa
	 */
	public void preencherComboCalendario(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		CalendarioService calendarioService = (CalendarioService) ServiceLocator.getInstance().getService(CalendarioService.class, null);
		HTMLSelect comboCalendario = document.getSelectById("idCalendario");
		Collection<CalendarioDTO> calendarioDTO = calendarioService.list();

		comboCalendario.removeAllOptions();

		if (calendarioDTO != null) {
			for (CalendarioDTO calendario : calendarioDTO) {

				comboCalendario.addOption(calendario.getIdCalendario().toString(), StringEscapeUtils.escapeJavaScript(calendario.getDescricao()));
			}
		}

	}

	/**
	 * Mtodo responsvel pela validao do avano do fluxo. O fluxo s ser vlido e portanto s poder avanar caso o problema em questo esteja associado a uma base de conhecimento.
	 *
	 * @autor thiago.monterio
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	public void validacaoAvancaFluxo(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		ProblemaDTO problemaDTO = (ProblemaDTO) document.getBean();

		ProblemaService problemaService = (ProblemaService) ServiceLocator.getInstance().getService(ProblemaService.class, null);

		if (problemaDTO != null && problemaService != null) {
			if (ProblemRequestStatus.KNOWN_ERROR_RECORD.getId().equals(problemaDTO.getIdStatus())) {
				boolean avancarFluxo = problemaService.validacaoAvancaFluxo(problemaDTO, null);

				if (!avancarFluxo) {
					document.alert(UtilI18N.internacionaliza(request, "problema.mensagem.necessarioExistirErroConhecido"));
				} else {
					document.executeScript("gravar('form')");
				}
			} else {
				document.executeScript("gravar('form')");
			}

		}
	}

	/**
	 * Mtodo responsvel por enviar mensagens de notificao no e-mail do responsvel (proprietrio) e de cada um dos usurios que fazem parte do grupo executor na resoluo de um problema.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @autor thiago.monteiro / thays.araujo
	 */
	public void notificarPrazoSolucionarProblemaExpirou(DocumentHTML document, HttpServletRequest request, HttpServletResponse response, UsuarioDTO usuario) throws Exception {

		EmpregadoDTO empregadoDto = new EmpregadoDTO();

		ProblemaService problemaService = (ProblemaService) ServiceLocator.getInstance().getService(ProblemaService.class, null);

		UsuarioService usuarioService = (UsuarioService) ServiceLocator.getInstance().getService(UsuarioService.class, null);

		EmpregadoService empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, null);

		GrupoService grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);

		String enviarNotificacao = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.NOTIFICAR_RESPONSAVEL_GRUPO_PRAZO_SOLUCAO_CONTORNO_PROBLEMA_EXPIRADO, "S");

		if (enviarNotificacao.equalsIgnoreCase("S")) {

			Collection<ProblemaDTO> listaProblemasComPrazoLimiteContornoExpirado = problemaService.listaProblemasComPrazoLimiteContornoExpirado(usuario);

			if (usuario != null) {
				if (usuario.getIdEmpregado() != null) {
					empregadoDto.setIdEmpregado(usuario.getIdEmpregado());
					empregadoDto = (EmpregadoDTO) empregadoService.restore(empregadoDto);
				}
			}

			if (problemaService != null && usuarioService != null) {

				if (listaProblemasComPrazoLimiteContornoExpirado != null) {

					String ID_MODELO_EMAIL_PRAZO_SOLUCAO_CONTORNO_PROBLEMA_EXPIRADO = ParametroUtil.getValorParametroCitSmartHashMap(
							ParametroSistema.ID_MODELO_EMAIL_PRAZO_SOLUCAO_CONTORNO_PROBLEMA_EXPIRADO, "38");

					Set emailsIntegrantesGrupoExecutor = new HashSet();

					Collection<String> emailsPorGrupo = null;

					MensagemEmail mensagemEmail;
					for (ProblemaDTO problemaDto : listaProblemasComPrazoLimiteContornoExpirado) {

						if (problemaDto.getIdGrupo() != null) {

							emailsPorGrupo = grupoService.listarEmailsPorGrupo(problemaDto.getIdGrupo());

							if (emailsPorGrupo != null && !emailsPorGrupo.isEmpty()) {

								for (String email : emailsPorGrupo) {
									emailsIntegrantesGrupoExecutor.add(email);
								}

							}

						}
						mensagemEmail = new MensagemEmail(Integer.parseInt(ID_MODELO_EMAIL_PRAZO_SOLUCAO_CONTORNO_PROBLEMA_EXPIRADO.trim()), new IDto[] { problemaDto });
					mensagemEmail.envia(empregadoDto.getEmail(), StringUtils.remove(StringUtils.remove(emailsIntegrantesGrupoExecutor.toString(), "["), "]"),
							ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.SMTP_ENVIO_RemetenteNotificacoesSolicitacao, "10"));
				}
			}
		}
	}
	}

	public void gravarSolContorno(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		ProblemaDTO problemaDto = (ProblemaDTO) document.getBean();
		SolucaoContornoDTO solucaoContornoDto = new SolucaoContornoDTO();
		SolucaoContornoService solucaoContornoService = (SolucaoContornoService) ServiceLocator.getInstance().getService(SolucaoContornoService.class, null);
		ProblemaService problemaService = (ProblemaService) ServiceLocator.getInstance().getService(ProblemaService.class, null);

		if (problemaDto.getIdProblema() != null) {
			solucaoContornoDto.setIdProblema(problemaDto.getIdProblema());

			if (problemaDto.getIdSolucaoContorno() != null && problemaDto.getIdSolucaoContorno().intValue() > 0) {

				solucaoContornoDto.setIdSolucaoContorno(problemaDto.getIdSolucaoContorno());
				solucaoContornoDto = (SolucaoContornoDTO) solucaoContornoService.restore(solucaoContornoDto);

				if (problemaDto.getSolucaoContorno() != null && !problemaDto.getSolucaoContorno().equals("")) {
					solucaoContornoDto.setDescricao(problemaDto.getSolucaoContorno());
				} else {
					document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.descricaoObrigatorio"));
					return;
				}

				if (problemaDto.getTituloSolucaoContorno() != null && !problemaDto.getTituloSolucaoContorno().equals("")) {
					solucaoContornoDto.setTitulo(problemaDto.getTituloSolucaoContorno());
				} else {
					document.alert(UtilI18N.internacionaliza(request, "baseConhecimento.tituloObrigatorio"));
					return;
				}

				solucaoContornoService.update(solucaoContornoDto);
				document.alert(UtilI18N.internacionaliza(request, "MSG06"));

			} else {

				if (problemaDto.getSolucaoContorno() != null && !problemaDto.getSolucaoContorno().equals("")) {
					solucaoContornoDto.setDescricao(problemaDto.getSolucaoContorno());
				} else {
					document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.descricaoObrigatorio"));
					return;
				}

				if (problemaDto.getTituloSolucaoContorno() != null && !problemaDto.getTituloSolucaoContorno().equals("")) {
					solucaoContornoDto.setTitulo(problemaDto.getTituloSolucaoContorno());
				} else {
					document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.tituloObrigatorio"));
					return;
				}
				solucaoContornoDto.setDataHoraCriacao(UtilDatas.getDataHoraAtual());
				solucaoContornoDto = solucaoContornoService.create(solucaoContornoDto);
				document.alert(UtilI18N.internacionaliza(request, "MSG05"));

			}
			problemaService.updateNotNull(problemaDto);
		} else {
			return;
		}
		this.montarTabela(solucaoContornoDto, request, response, document);
		document.executeScript("fecharSolContorno()");

	}

	public SolucaoContornoDTO verificaSolucaoContorno(HttpServletRequest request, HttpServletResponse response, DocumentHTML document, ProblemaDTO problema) throws ServiceException, Exception {
		SolucaoContornoDTO solucaoContorno = new SolucaoContornoDTO();
		SolucaoContornoService solucaoContornoService = (SolucaoContornoService) ServiceLocator.getInstance().getService(SolucaoContornoService.class, null);

		solucaoContorno.setIdProblema(problema.getIdProblema());
		solucaoContorno = solucaoContornoService.findByIdProblema(solucaoContorno);

		if (solucaoContorno != null) {
			this.montarTabela(solucaoContorno, request, response, document);
		}

		return solucaoContorno;
	}

	public void montarTabela(SolucaoContornoDTO solucaoContornoDto, HttpServletRequest request, HttpServletResponse response, DocumentHTML document) throws Exception {
		HTMLTable tblSolContorno = document.getTableById("tblSolContorno");
		tblSolContorno.deleteAllRows();
		if (solucaoContornoDto.getIdSolucaoContorno() != null) {
			solucaoContornoDto.setDataHoraCriacaoStr(UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, solucaoContornoDto.getDataHoraCriacao(), WebUtil.getLanguage(request)));
			tblSolContorno.addRow(solucaoContornoDto, new String[] { "titulo", "dataHoraCriacaoStr", "descricao" }, null, null, null, null, null);
			// document.executeScript("$('#divTblSolContorno').show();");
		}
	}

	public void gravarSolDefinitiva(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		ProblemaDTO problemaDto = (ProblemaDTO) document.getBean();
		SolucaoDefinitivaDTO solucaoDefinitivaDto = new SolucaoDefinitivaDTO();
		SolucaoDefinitivaService solucaoDefinitivaService = (SolucaoDefinitivaService) ServiceLocator.getInstance().getService(SolucaoDefinitivaService.class, null);

		if (problemaDto.getIdProblema() != null) {
			solucaoDefinitivaDto.setIdProblema(problemaDto.getIdProblema());

			if (problemaDto.getIdSolucaoDefinitiva() != null && problemaDto.getIdSolucaoDefinitiva().intValue() > 0) {

				solucaoDefinitivaDto.setIdSolucaoDefinitiva(problemaDto.getIdSolucaoDefinitiva());
				solucaoDefinitivaDto = (SolucaoDefinitivaDTO) solucaoDefinitivaService.restore(solucaoDefinitivaDto);

				if (problemaDto.getSolucaoDefinitiva() != null && !problemaDto.getSolucaoDefinitiva().equals("")) {
					solucaoDefinitivaDto.setDescricao(problemaDto.getSolucaoDefinitiva());
				} else {
					document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.descricaoObrigatorio"));
					return;
				}

				if (problemaDto.getTituloSolucaoDefinitiva() != null && !problemaDto.getTituloSolucaoDefinitiva().equals("")) {
					solucaoDefinitivaDto.setTitulo(problemaDto.getTituloSolucaoDefinitiva());
				} else {
					document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.tituloObrigatorio"));
					return;
				}

				solucaoDefinitivaService.update(solucaoDefinitivaDto);
				document.alert(UtilI18N.internacionaliza(request, "MSG06"));

			} else {

				if (problemaDto.getSolucaoDefinitiva() != null && !problemaDto.getSolucaoDefinitiva().equals("")) {
					solucaoDefinitivaDto.setDescricao(problemaDto.getSolucaoDefinitiva());
				} else {
					document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.descricaoObrigatorio"));
					return;
				}

				if (problemaDto.getTituloSolucaoDefinitiva() != null && !problemaDto.getTituloSolucaoDefinitiva().equals("")) {
					solucaoDefinitivaDto.setTitulo(problemaDto.getTituloSolucaoDefinitiva());
				} else {
					document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.tituloObrigatorio"));
					return;
				}
				solucaoDefinitivaDto.setDataHoraCriacao(UtilDatas.getDataHoraAtual());
				solucaoDefinitivaDto = solucaoDefinitivaService.create(solucaoDefinitivaDto);
				document.alert(UtilI18N.internacionaliza(request, "MSG05"));

			}
		} else {
			return;
		}

		this.montarTabela(solucaoDefinitivaDto, request, response, document);
		document.executeScript("fecharSolDefinitiva()");

	}

	public SolucaoDefinitivaDTO verificaSolucaoDefinitiva(HttpServletRequest request, HttpServletResponse response, DocumentHTML document, ProblemaDTO problema) throws ServiceException, Exception {
		SolucaoDefinitivaDTO solucaoDefinitiva = new SolucaoDefinitivaDTO();
		SolucaoDefinitivaService solucaoDefinitivaService = (SolucaoDefinitivaService) ServiceLocator.getInstance().getService(SolucaoDefinitivaService.class, null);

		solucaoDefinitiva.setIdProblema(problema.getIdProblema());
		solucaoDefinitiva = solucaoDefinitivaService.findByIdProblema(solucaoDefinitiva);

		if (solucaoDefinitiva != null) {
			this.montarTabela(solucaoDefinitiva, request, response, document);
		}

		return solucaoDefinitiva;
	}

	public void montarTabela(SolucaoDefinitivaDTO solucaoDefinitivaDto, HttpServletRequest request, HttpServletResponse response, DocumentHTML document) throws Exception {
		HTMLTable tblSolDefinitiva = document.getTableById("tblSolDefinitiva");
		tblSolDefinitiva.deleteAllRows();
		if (solucaoDefinitivaDto.getIdSolucaoDefinitiva() != null) {
			solucaoDefinitivaDto.setDataHoraCriacaoStr(UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, solucaoDefinitivaDto.getDataHoraCriacao(), WebUtil.getLanguage(request)));
			tblSolDefinitiva.addRow(solucaoDefinitivaDto, new String[] { "titulo", "dataHoraCriacaoStr", "descricao" }, null, null, null, null, null);
		}
	}

	/**
	 * @author geber.costa
	 * @param document
	 * @param idProblema
	 * @throws Exception
	 *             Traz uma lista para verificao de ultima data e hora da ocorrncia, esses dados sero retornados na pgina do cliente.
	 */
	public void verificaUltimaAtualizacao(DocumentHTML document, HttpServletRequest request, int idProblema) throws Exception {

		OcorrenciaProblemaDAO ocorrenciaDao = new OcorrenciaProblemaDAO();
		List<OcorrenciaProblemaDTO> lista = (List<OcorrenciaProblemaDTO>) ocorrenciaDao.listByUltimaDataEHora(idProblema);

		Date data = null;
		String hora = "";
		String registradoPor = "";

		if (lista != null) {

			for (OcorrenciaProblemaDTO l : lista) {

				/**
				 *
				 * valida para pegar a ultima data de registro e a ultima hora, porm ele ir pegar a partiro do momento que a ocorrencia no for nula e vazia ou se ela tiver alguma das descries setadas
				 */

				if (!UtilNumbersAndDecimals.isNullOrZeroOrEmpty(l.getIdOccurrenceCategory()) || OccurrenceCategory.REQUEST_CLOSING.getId().equals(l.getIdOccurrenceCategory())
						|| OccurrenceCategory.REQUEST_SUSPENSION.getId().equals(l.getIdOccurrenceCategory()) || OccurrenceCategory.REQUEST_REACTIVATION.getId().equals(l.getIdOccurrenceCategory())
						|| OccurrenceCategory.ACTIVITY_SCHEDULE.getId().equals(l.getIdOccurrenceCategory()) || OccurrenceCategory.REGISTRATION_EXECUTION.getId().equals(l.getIdOccurrenceCategory())) {

					if (l.getDataregistro() != null) {
						data = l.getDataregistro();
					}

					if (!l.getHoraregistro().equalsIgnoreCase("")) {
						hora = l.getHoraregistro();
					}
					registradoPor = l.getRegistradopor();

				}

			}

			//
			SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
			String date = sdf.format(data);

			// String registradoPor = lista.get(lista.size()-1).getRegistradopor();

			document.getElementById("dataHoraUltimaAtualizacao").setInnerHTML(
					UtilI18N.internacionaliza(request, "carteiraTrabalho.data") + ":<b>&nbsp;" + date + "&nbsp;&nbsp;&nbsp;</b> </br>"
					+ UtilI18N.internacionaliza(request, "carteiraTrabalho.hora") + ":<b>&nbsp;" + hora + "&nbsp;&nbsp;&nbsp;</b> </br>"
							+ UtilI18N.internacionaliza(request, "ocorrenciaProblema.registradopor") + ":<b>&nbsp;" + registradoPor + "&nbsp;&nbsp;</b>");
		}
	}

	public Integer obterIdTarefa(ProblemaDTO problema, HttpServletRequest request) throws ServiceException, Exception {
		int res = 0;
		ExecucaoProblemaService execucaoProblemaService = (ExecucaoProblemaService) ServiceLocator.getInstance().getService(ExecucaoProblemaService.class, null);
		usuario = br.com.centralit.citcorpore.util.WebUtil.getUsuario(request);
		TarefaFluxoDTO tarefaFluxo = execucaoProblemaService.recuperaTarefa(usuario.getLogin(), problema);
		if (tarefaFluxo != null) {
			res = tarefaFluxo.getIdItemTrabalho();
		}
		return res;
	}

	public void carregaInformacoesComplementares(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		carregaInformacoesComplementares(document, request, (ProblemaDTO) document.getBean());
	}

	private void carregaInformacoesComplementares(DocumentHTML document, HttpServletRequest request, ProblemaDTO problemaDto) throws Exception {

		TemplateSolicitacaoServicoService templateService = (TemplateSolicitacaoServicoService) ServiceLocator.getInstance().getService(TemplateSolicitacaoServicoService.class,
				br.com.centralit.citcorpore.util.WebUtil.getUsuarioSistema(request));

		document.executeScript("exibirInformacoesComplementares('" + getProblemaService(request).getUrlInformacoesComplementares(problemaDto) + "');");
		TemplateSolicitacaoServicoDTO templateDto = templateService.recuperaTemplateProblema(problemaDto);

		if (templateDto != null) {
			if (templateDto.getAlturaDiv() != null) {
				document.executeScript("document.getElementById('divInformacoesComplementares').style.height = '" + templateDto.getAlturaDiv().intValue() + "px';");
				document.executeScript("document.getElementById('fraInformacoesComplementares').style.height = '" + templateDto.getAlturaDiv().intValue() + "px';");

			}

		}
		document.executeScript("escondeJanelaAguarde()");
	}

	public void restoreImpactoUrgenciaPorCategoriaProblema(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		ProblemaDTO problemaDto = (ProblemaDTO) document.getBean();

		CategoriaProblemaDTO categoriaProblemaDto = new CategoriaProblemaDTO();

		CategoriaProblemaService categoriaProblemaService = (CategoriaProblemaService) ServiceLocator.getInstance().getService(CategoriaProblemaService.class, null);

		if (problemaDto.getIdCategoriaProblema() != null) {
			categoriaProblemaDto.setIdCategoriaProblema(problemaDto.getIdCategoriaProblema());
			categoriaProblemaDto = (CategoriaProblemaDTO) categoriaProblemaService.restore(categoriaProblemaDto);
		}

		if (categoriaProblemaDto != null) {
			problemaDto.setImpacto(categoriaProblemaDto.getImpacto());
			problemaDto.setUrgencia(categoriaProblemaDto.getUrgencia());

		}

		HTMLForm form = document.getForm("form");
		form.setValues(problemaDto);
		document.executeScript("atualizaPrioridade()");
	}

	public void verificarItensRelacionados(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws ServiceException, Exception {
		ProblemaDTO RequisicaoMudancaDTO = (ProblemaDTO) document.getBean();

		ArrayList<SolicitacaoServicoDTO> listIdSolicitacaoServico = (ArrayList<SolicitacaoServicoDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(SolicitacaoServicoDTO.class,
				"solicitacaoServicoSerializado", request);
		ArrayList<RequisicaoMudancaItemConfiguracaoDTO> listRequisicaoMudancaItemConfiguracaoDTO = (ArrayList<RequisicaoMudancaItemConfiguracaoDTO>) br.com.citframework.util.WebUtil
				.deserializeCollectionFromRequest(RequisicaoMudancaItemConfiguracaoDTO.class, "itensConfiguracaoRelacionadosSerializado", request);

		boolean existeItensRelaiconados = false;

		if (listIdSolicitacaoServico != null && listIdSolicitacaoServico.size() > 0) {
			existeItensRelaiconados = true;
		} else if (listRequisicaoMudancaItemConfiguracaoDTO != null && listRequisicaoMudancaItemConfiguracaoDTO.size() > 0) {
			existeItensRelaiconados = true;
		}

		if (existeItensRelaiconados) {
			document.executeScript("verificarItensRelacionados(false)");
		} else {
			this.validacaoAvancaFluxo(document, request, response);
		}
	}

	public void verificarParametroAnexos(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String DISKFILEUPLOAD_REPOSITORYPATH = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.DISKFILEUPLOAD_REPOSITORYPATH, "");
		if (DISKFILEUPLOAD_REPOSITORYPATH == null) {
			DISKFILEUPLOAD_REPOSITORYPATH = "";
		}
		if (DISKFILEUPLOAD_REPOSITORYPATH.equals("")) {
			throw new LogicException(UtilI18N.internacionaliza(request, "citcorpore.comum.anexosUploadSemParametro"));
		}
		File pasta = new File(DISKFILEUPLOAD_REPOSITORYPATH);
		if (!pasta.exists()) {
			throw new LogicException(UtilI18N.internacionaliza(request, "citcorpore.comum.pastaIndicadaNaoExiste"));
		}
	}

	public void restaurarItemConfiguracao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) {
		problemaDto = (ProblemaDTO) document.getBean();
		ItemConfiguracaoDTO itemConfiguracaoDTO = new ItemConfiguracaoDTO();
		try {

			ItemConfiguracaoService itemConfiguracaoService = (ItemConfiguracaoService) ServiceLocator.getInstance().getService(ItemConfiguracaoService.class, null);
			problemaDto.getHiddenIdItemConfiguracao();
			if (problemaDto != null && problemaDto.getHiddenIdItemConfiguracao() != null && Integer.SIZE > 0) {
				itemConfiguracaoDTO.setIdItemConfiguracao(problemaDto.getHiddenIdItemConfiguracao());
				itemConfiguracaoDTO = (ItemConfiguracaoDTO) itemConfiguracaoService.restore(itemConfiguracaoDTO);
				document.getElementById("hiddenIdItemConfiguracao").setValue(itemConfiguracaoDTO.getIdItemConfiguracao().toString());

				document.executeScript("addLinhaTabelaItemConfiguracao('" + itemConfiguracaoDTO.getIdItemConfiguracao() + "','" + itemConfiguracaoDTO.getIdentificacao() + "')");
			}

		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	/**
	 * Mtodo necessrio para os casos de PoppupManager, pois h uma funo que quando a popup  fechada,  chamado um fireevent para carregar a combo, porm no tinha como acessar o metodo alimentaComboCategoriaProblema por ser private e era
	 * necessario ter um metodo que recebia os parametro (DocumentHTML, HttpServletRequest, HttpServletResponse)
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	public void alimentaComboCatProblemaAposCadastro(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		this.alimentaComboCategoriaProblema(request, document);
	}

    /**
	 * @author euler.ramos Gera a impresso do cadastro de problema juntamente com suas informaes complementares.
	 *
	 * @param document
	 * @param request
	 * @param response
	 */
	public void imprimirCadastroPdf(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) {
		ImpressaoCadProblema impressaoCadProblema;
		try {
			impressaoCadProblema = new ImpressaoCadProblema(document, request);
			impressaoCadProblema.gerarRelatorio();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			impressaoCadProblema = null;
			try {
				document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
			} catch (Exception e) {
				e.printStackTrace();
}
		}
	}

    /**
     * @author rcs - Analista Desenvolvedor <a href="rafael.soyer@centralit.com.br">rafael.soyer@centralit.com.br</a>
     * @param document
     * @param request
     * @param response
     * @since 08/05/2015
     */
    public void atualizaValuesFormProblema(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) {
        this.setFormProblema(document.getForm(this.getStr_nomeFormProblema()));
        this.formProblema.setValues(this.getProblemaDto());
    }

	private String carregarComboTipoCatalogoServico(final DocumentHTML document, final HttpServletRequest request, Integer idContratoSelecionado) throws ServiceException, Exception {
		final HTMLSelect catalogoServico = document.getSelectById("catalogoServico");
		catalogoServico.setDisabled(false);
		catalogoServico.removeAllOptions();
		catalogoServico.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

		for(TipoCatalogoServico tipoCatalogoServico : TipoCatalogoServico.values()) {
			catalogoServico.addOption(tipoCatalogoServico.getIdentificador(), UtilI18N.internacionaliza(request, tipoCatalogoServico.getChave()));
		}

		return verificaTipoDeAcordoDoContrato(document, request, null, idContratoSelecionado);
	}

	public String verificaTipoDeAcordoDoContrato(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response, Integer idContratoSelecionado) throws Exception {
		ProblemaDTO problemaDTO = (ProblemaDTO) document.getBean();
		Integer idContrato = idContratoSelecionado != null ? idContratoSelecionado : problemaDTO.getIdContrato();
		String tipoCategoria = null;
		if (idContrato != null) {
			ContratoDTO contrato = new ContratoDTO();
			contrato.setIdContrato(idContrato);

			contrato = getContratoService().restore(contrato);

			if (contrato != null) {
				final HTMLSelect catalogoServico = document.getSelectById("catalogoServico");

				if (TipoAcordoContrato.CONTRATO.getIdentificador().equalsIgnoreCase(contrato.getTipo())) {
					tipoCategoria = TipoCatalogoServico.SERVICO_NEGOCIO.getIdentificador();
				} else {
					tipoCategoria = TipoCatalogoServico.SERVICO_TECNICO.getIdentificador();
				}
				catalogoServico.setValue(tipoCategoria);
				catalogoServico.setDisabled(true);
			}
		}
		return tipoCategoria;
	}

	private void carregarComboCategoriaServico(final DocumentHTML document, final HttpServletRequest request, String tipoCategoria) throws ServiceException, Exception {
		final HTMLSelect categoriaServico = document.getSelectById("categoriaServico");
		categoriaServico.setDisabled(false);
		categoriaServico.removeAllOptions();
		categoriaServico.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
		if(tipoCategoria != null && !tipoCategoria.isEmpty()){
			Collection<CategoriaServicoDTO> listCategoriaServico = getCatalogoServicoService().listByTipoCategoria(tipoCategoria);
			if(listCategoriaServico != null){
				for(CategoriaServicoDTO categoriaServicoDTO : listCategoriaServico) {
					categoriaServico.addOption(categoriaServicoDTO.getIdCategoriaServico().toString(), categoriaServicoDTO.getNomeCategoriaServico());
				}
			}
		}
	}

	private void gravaProblemaServicoNegocio() throws ServiceException, Exception{
		if(this.getProblemaDto() != null && this.getProblemaDto().getIdProblema() != null){
			ProblemaServicoNegocioDTO problemaServicoNegocioDTO = new ProblemaServicoNegocioDTO();
			problemaServicoNegocioDTO.setIdProblema(getProblemaDto().getIdProblema());
			problemaServicoNegocioDTO.setIdServico(getProblemaDto().getIdServicoNegocio());
			this.getProblemaServicoNegocioService().deleteAllByIdProblema(problemaServicoNegocioDTO);
			if(this.getProblemaDto().getIdServicoNegocio() != null){
				this.getProblemaServicoNegocioService().create(problemaServicoNegocioDTO);
			}
		}
	}

	private void restoreServicoNegocio(final DocumentHTML document, final HttpServletRequest request, Integer idProblema) throws Exception {
		ProblemaServicoNegocioDTO problemaServicoNegocioDTO = new ProblemaServicoNegocioDTO();
		problemaServicoNegocioDTO.setIdProblema(idProblema);
		problemaServicoNegocioDTO =  this.getProblemaServicoNegocioService().findByIdProblema(problemaServicoNegocioDTO);

		if(problemaServicoNegocioDTO != null && problemaServicoNegocioDTO.getIdServico() != null){
			restoreServicoNegocio(document, request,null, problemaServicoNegocioDTO.getIdServico());
		}
	}

	public void listarServicosNegocioTecnico(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final ProblemaDTO problema = (ProblemaDTO) document.getBean();

		final HTMLTable tblListaServicosNegocioTecnico = document.getTableById("tblListaServicosNegocioTecnico");
		tblListaServicosNegocioTecnico.deleteAllRows();

		final Collection<ServicoDTO> colServicos = this.getServicoService().findAutocompleteServicoNegocioTecnico(problema.getIdContrato(), problema.getTipoCatalogo(), "", problema.getCategoriaServico());
		if (colServicos != null && !colServicos.isEmpty()) {
			document.executeScript("Modal.open('modal-problema-info-servico-negocio-tecnico', removeModalOverflowClass);");
			String json = new Gson().toJson(colServicos);
			document.executeScript("adicionaItensTabelaServicoNegocio('" + json +"')");
		} else {
			document.alert(UtilI18N.internacionaliza(request, "MSG04"));
		}

		document.executeScript("JANELA_AGUARDE_MENU.hide();");
	}

	public void restoreServicoNegocio(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final ProblemaDTO problema = (ProblemaDTO) document.getBean();
		restoreServicoNegocio(document, request, response, problema.getIdServicoNegocio());
	}

	private void restoreServicoNegocio(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response, Integer idServico) throws Exception {
		ServicoDTO servicoDTO = new ServicoDTO();
		servicoDTO.setIdServico(idServico);
		servicoDTO = (ServicoDTO) getServicoService().restore(servicoDTO);
		if(servicoDTO != null && servicoDTO.getIdServico() != null && servicoDTO.getNomeServico() != null){
			HTMLElement servicoNegocioInput = document.getElementById("servicoNegocio");
			servicoNegocioInput.setValue(servicoDTO.getNomeServico());
			document.executeScript("$('#idServicoNegocio').val(".concat(servicoDTO.getIdServico().toString()).concat(");"));
			document.executeScript("Modal.close('modal-problema-info-servico-negocio-tecnico');");
		}

	}

	private ContratoService getContratoService() throws ServiceException {
		if (contratoService == null) {
			contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
		}
		return contratoService;
	}

	private CategoriaServicoService getCatalogoServicoService() throws ServiceException {
		if(categoriaServicoService == null) {
			categoriaServicoService = (CategoriaServicoService) ServiceLocator.getInstance().getService(CategoriaServicoService.class, null);
		}
		return categoriaServicoService;
	}

	private ProblemaServicoNegocioService getProblemaServicoNegocioService() throws ServiceException {
		if(problemaServicoNegocioService == null) {
			problemaServicoNegocioService = (ProblemaServicoNegocioService) ServiceLocator.getInstance().getService(ProblemaServicoNegocioService.class, null);
		}
		return problemaServicoNegocioService;
	}

	private ServicoService getServicoService() throws ServiceException {
		if(servicoService == null) {
			servicoService = (ServicoService) ServiceLocator.getInstance().getService(ServicoService.class, null);
		}
		return servicoService;
	}

	private CategoriaOcorrenciaService getCategoriaOcorrenciaService() throws ServiceException {
		if (categoriaOcorrenciaService == null) {
			categoriaOcorrenciaService = (CategoriaOcorrenciaService) ServiceLocator.getInstance().getService(CategoriaOcorrenciaService.class, null);
		}
		return categoriaOcorrenciaService;
	}
}