package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.bpm.dto.FluxoDTO;
import br.com.centralit.bpm.dto.TipoFluxoDTO;
import br.com.centralit.bpm.servico.FluxoService;
import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLCheckbox;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.ClienteDTO;
import br.com.centralit.citcorpore.bean.ProcessoNegocioDTO;
import br.com.centralit.citcorpore.bean.ProcessoNegocioTiposFluxoDTO;
import br.com.centralit.citcorpore.bean.ProcessoNegocioUnidadesDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.bean.UnidadeDTO;
import br.com.centralit.citcorpore.negocio.ClienteService;
import br.com.centralit.citcorpore.negocio.GrupoService;
import br.com.centralit.citcorpore.negocio.ProcessoNegocioService;
import br.com.centralit.citcorpore.negocio.ProcessoNegocioTiposFluxoService;
import br.com.centralit.citcorpore.negocio.ProcessoNegocioUnidadesService;
import br.com.centralit.citcorpore.negocio.ServicoProcessoNegocioService;
import br.com.centralit.citcorpore.negocio.UnidadeService;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;

@SuppressWarnings({ "rawtypes", "unchecked" })
public class ProcessoNegocio extends AjaxFormAction {

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
        loadGrupos(document, request, response);
        loadTiposFluxo(document, request, response);
        
		HTMLElement tabelaUnidade = document.getElementById("divTabelaProcessoNegocioUnidade");
		tabelaUnidade.setInnerHTML("<h4>" + UtilI18N.internacionaliza(request, "processoNegocio.nenhumaUnidadeVinculada") + "</h4>");
		
      //TODO[deborah.ferreira][13/01/2016] Verificar Necessidade
		/*document.executeScript("GRID_AUTORIDADES.deleteAllRows();");
		NivelAutoridadeService nivelAutoridadeService = (NivelAutoridadeService) ServiceLocator.getInstance().getService(NivelAutoridadeService.class, WebUtil.getUsuarioSistema(request));
		request.setAttribute("colAutoridades", nivelAutoridadeService.list());
		*/
	}

	public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		ProcessoNegocioDTO processoNegocioDto = (ProcessoNegocioDTO) document.getBean();
		
		if (processoNegocioDto != null) {
			ProcessoNegocioService processoNegocioService = (ProcessoNegocioService) ServiceLocator.getInstance().getService(ProcessoNegocioService.class, null);
			processoNegocioDto = (ProcessoNegocioDTO) processoNegocioService.restore(processoNegocioDto);
			
			ClienteService clienteService = (ClienteService) ServiceLocator.getInstance().getService(ClienteService.class, null);
			ClienteDTO clienteDTO = new ClienteDTO();
			clienteDTO.setIdCliente(processoNegocioDto.getIdCliente());
			clienteDTO = (ClienteDTO) clienteService.restore(clienteDTO);
			processoNegocioDto.setProcessoNegocioCliente(clienteDTO.getNomeRazaoSocial());

			HTMLForm form = document.getForm("formProcessoNegocio");
			form.clear();
			form.setValues(processoNegocioDto);

			//TODO[deborah.ferreira][13/01/2016] Verificar Necessidade
			/*ProcessoNivelAutoridadeService processoNivelAutoridadeService = (ProcessoNivelAutoridadeService) ServiceLocator.getInstance().getService(ProcessoNivelAutoridadeService.class, null);
			Collection<ProcessoNivelAutoridadeDTO> colAutoridades = processoNivelAutoridadeService.findByIdProcessoNegocio(processoNegocioDto.getIdProcessoNegocio());
			document.executeScript("GRID_AUTORIDADES.deleteAllRows();");
			if (colAutoridades != null) {
				int i = 0;
				for (ProcessoNivelAutoridadeDTO processoNivelAutoridadeDto : colAutoridades) {
					i++;
					document.executeScript("GRID_AUTORIDADES.addRow()");
					processoNivelAutoridadeDto.setSequencia(i);
					document.executeScript("seqAutoridade = NumberUtil.zerosAEsquerda(" + i + ",5)");
					document.executeScript("exibeAutoridade('" + br.com.citframework.util.WebUtil.serializeObject(processoNivelAutoridadeDto, WebUtil.getLanguage(request)) + "')");
				}
			}*/
			
			ProcessoNegocioUnidadesService processoNegocioUnidadesService = (ProcessoNegocioUnidadesService) ServiceLocator.getInstance().getService(ProcessoNegocioUnidadesService.class, WebUtil.getUsuarioSistema(request));
			List<UnidadeDTO> listaUnidades = (List<UnidadeDTO>) processoNegocioUnidadesService.findUnidadesByIdProcessoNegocio(processoNegocioDto.getIdProcessoNegocio());
			String listaUnidadesLookup = "";
			geraHtmlTabelaUnidade(listaUnidades, document, request);
			for (UnidadeDTO unidadeDTO : listaUnidades) {
				listaUnidadesLookup += unidadeDTO.getIdUnidade()+";";
			}
			form.setValue("listaIdsUnidadesVinculadas", listaUnidadesLookup);
			document.executeScript("Unidade.serializarListaIdsUnidadesVinculadas();");
			
			ProcessoNegocioTiposFluxoService processoNegocioTiposFluxoService = (ProcessoNegocioTiposFluxoService) ServiceLocator.getInstance().getService(ProcessoNegocioTiposFluxoService.class, WebUtil.getUsuarioSistema(request));
			Collection<TipoFluxoDTO> tiposFluxo = processoNegocioTiposFluxoService.findTiposFluxoByIdProcessoNegocio(processoNegocioDto.getIdProcessoNegocio());

			document.executeScript("TipoFluxo.limparCheckbox();");
			for (TipoFluxoDTO tipoFluxoDto : tiposFluxo) {
				HTMLCheckbox checkboxTipoFluxo = document.getCheckboxById(tipoFluxoDto.getIdTipoFluxo().toString());
				if(checkboxTipoFluxo != null) {
					checkboxTipoFluxo.setChecked(true);
				}
			}
		}
	}

	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		ProcessoNegocioDTO processoNegocioDto = (ProcessoNegocioDTO) document.getBean();
		ProcessoNegocioService processoNegocioService = (ProcessoNegocioService) ServiceLocator.getInstance().getService(ProcessoNegocioService.class, null);
		//TODO[deborah.ferreira][13/01/2016] Verificar Necessidade
		//processoNegocioDto.setColAutoridades(br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(ProcessoNivelAutoridadeDTO.class, "colAutoridades_Serialize", request));
		processoNegocioDto.setListaProcessoNegocioUnidades(br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(ProcessoNegocioUnidadesDTO.class, "listaProcessoNegocioUnidades_Serialize", request));
		processoNegocioDto.setListaProcessoNegocioTiposFluxo(br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(ProcessoNegocioTiposFluxoDTO.class, "listaProcessoNegocioTiposFluxo_Serialize", request));
		
		//TODO[deborah.ferreira][13/01/2016] Verificar Necessidade
		/*if (processoNegocioDto.getPermissaoSolicitacao() == null)
			processoNegocioDto.setPermissaoSolicitacao("T");*/

		if (processoNegocioDto.getIdProcessoNegocio() == null) {
			processoNegocioDto = processoNegocioService.create(processoNegocioDto);
			document.getForm("formProcessoNegocio").setValue("idProcessoNegocio", processoNegocioDto.getIdProcessoNegocio());
			document.executeScript("notificacaoI18N('MSG05','')");
		} else { 
			processoNegocioService.update(processoNegocioDto);
			document.executeScript("notificacaoI18N('MSG06','')");
		}
	}
	
	public void excluir(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		ProcessoNegocioDTO processoNegocioDto = (ProcessoNegocioDTO) document.getBean();
		
		if(processoNegocioDto != null && processoNegocioDto.getIdProcessoNegocio() != null) {
			ProcessoNegocioService processoNegocioService = (ProcessoNegocioService) ServiceLocator.getInstance().getService(ProcessoNegocioService.class, null);
			ServicoProcessoNegocioService servicoProcessoNegocioService = (ServicoProcessoNegocioService) ServiceLocator.getInstance().getService(ServicoProcessoNegocioService.class, null);
			List<ServicoDTO> listaServicos = (List<ServicoDTO>) servicoProcessoNegocioService.findServicosByIdProcessosNegocio(processoNegocioDto.getIdProcessoNegocio());
			
			if(listaServicos != null && !listaServicos.isEmpty()) {
				document.executeScript("notificacaoErro('processoNegocio.impossivelExcluirProcessoNegocioVinculadoAosServicos','')");
			} else {
				processoNegocioService.delete(processoNegocioDto);
				document.executeScript("notificacaoI18N('MSG07','')");
				document.executeScript("ProcessoNegocio.limpar();");
			}
		} else {
			document.executeScript("notificacaoErro('citcorpore.comum.naoFoiPossivelExcluir','')");
		}
	}
	
	@Override
	public Class getBeanClass() {
		return ProcessoNegocioDTO.class;
	}
	
	/**
	 * Mtodo para carregar os grupos e montar as selects de Grupo Executor e Grupo Administrador
	 * 
	 * @author deborah.ferreira
	 * @since 07.01.2016
	 */
	private void loadGrupos(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GrupoService grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, WebUtil.getUsuarioSistema(request));
        
		HTMLSelect idGrupoExecutor = (HTMLSelect) document.getSelectById("idGrupoExecutor");
        idGrupoExecutor.removeAllOptions();        
        idGrupoExecutor.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
        
        HTMLSelect idGrupoAdministrador = (HTMLSelect) document.getSelectById("idGrupoAdministrador");        
        idGrupoAdministrador.removeAllOptions();
        idGrupoAdministrador.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
        
        Collection colGrupos = grupoService.list();
        if(colGrupos != null && !colGrupos.isEmpty()) {
        	idGrupoExecutor.addOptions(colGrupos, "idGrupo", "nome", null);
        	idGrupoAdministrador.addOptions(colGrupos, "idGrupo", "nome", null);
        }
	}
	
	/**
	 * Mtodo para carregar os tipos de fluxos e montar os checkboxs
	 * 
	 * @author deborah.ferreira
	 * @since 07.01.2016
	 */
	private void loadTiposFluxo(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect idDivTiposDeFluxo = (HTMLSelect) document.getSelectById("divTiposDeFluxo");
		idDivTiposDeFluxo.setInnerHTML("");
		
		FluxoService fluxoService = (FluxoService) ServiceLocator.getInstance().getService(FluxoService.class, null);
		Collection<FluxoDTO> fluxos = fluxoService.list();
		StringBuilder sb;
		
		if(fluxos != null && fluxos.size() > 0) {
			for(FluxoDTO fluxo: fluxos) {
				sb = new StringBuilder();
				sb.append("<label class=\"checkbox\">");
				sb.append("		<input type=\"checkbox\" name=\"idTipoFluxo\" id=\""+fluxo.getIdTipoFluxo()+"\" value=\""+fluxo.getIdTipoFluxo()+"\">");
				sb.append(		fluxo.getDescricao());
				sb.append("</label>");
				idDivTiposDeFluxo.appendHTML(sb.toString());
			}
		} else {
			idDivTiposDeFluxo.setInnerHTML("<h4>" + UtilI18N.internacionaliza(request, "processoNegocio.nenhumTipoFluxoVinculado") + "</h4>");
		}
	}
	
	/**
	 * Mtodo para tratar a vinculao de Unidades a partir
	 * da lookup com checkbox
	 * 
	 * @author deborah.ferreira
	 * @since 07.01.2016
	 */
	public void adicionaTabelaLOOKUP_PROCESSO_NEGOCIO_VINCULAR_UNIDADE(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		if(!WebUtil.validarSeUsuarioEstaNaSessao(request, document)){return;}
		
		ProcessoNegocioDTO processoNegocioDto = (ProcessoNegocioDTO) document.getBean();

		if (processoNegocioDto != null) {
			//Executa a funo no js para atualizar a lista de unidades vinculadas
			document.executeScript("Unidade.montarTabelaUnidades();");
			document.executeScript("Unidade.fecharModal();");
		}
	}
	
	/**
	 * Monta a tabela de unidades vinculadas
	 *
	 * @author deborah.ferreira
	 * @since 12.01.2016
	 */
	public void montarTabelaUnidades(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) {
		try {
			List<ProcessoNegocioUnidadesDTO> listaProcessoNegocioUnidades = new ArrayList<ProcessoNegocioUnidadesDTO>();
			listaProcessoNegocioUnidades = (ArrayList) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(ProcessoNegocioUnidadesDTO.class, "listaProcessoNegocioUnidades_Serialize", request);
			List<UnidadeDTO> listaUnidades = new ArrayList<UnidadeDTO>();

			if (listaProcessoNegocioUnidades != null && listaProcessoNegocioUnidades.size() > 0) {
				for (ProcessoNegocioUnidadesDTO processoNegocioUnidades : listaProcessoNegocioUnidades) {
					UnidadeService unidadeService = (UnidadeService) ServiceLocator.getInstance().getService(UnidadeService.class, null);
					listaUnidades.addAll(unidadeService.findById(processoNegocioUnidades.getIdUnidade()));
				}
				document.executeScript("notificacaoI18N('processoNegocio.unidadeVinculadaSucesso');");
			}
			
			Collections.sort(listaUnidades);
			geraHtmlTabelaUnidade(listaUnidades, document, request);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * Gera o html da tabela vincular unidade
	 *
	 * @author deborah.ferreira
	 * @since 12.01.2016
	 */
	private void geraHtmlTabelaUnidade(List<UnidadeDTO> listaUnidades, DocumentHTML document, HttpServletRequest request) throws Exception {
		StringBuilder sb = new StringBuilder();

		if (listaUnidades != null && listaUnidades.size() > 0) {
			sb.append(geraHtmlCabecalhoTabela(request));

			sb.append(geraHtmlDadosTabela(listaUnidades, document, request));

			sb.append(geraHTMLFinalTabela());
		} else {
			sb.append("<h4>" + UtilI18N.internacionaliza(request, "processoNegocio.nenhumaUnidadeVinculada") + "</h4>");
		}
		HTMLElement tabelaUnidade = document.getElementById("divTabelaProcessoNegocioUnidade");
		tabelaUnidade.setInnerHTML(sb.toString());
	}
	
	/**
	 * Gera o html do cabealho da tabela vincular unidade
	 *
	 * @author deborah.ferreira
	 * @since 12.01.2016
	 */
	private String geraHtmlCabecalhoTabela(HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		sb.append("	<div class=\"table-responsive tabela\">");
		sb.append("		<table class=\"table table-bordered table-striped table-condensed\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "ID") + "</th> ");
		sb.append("				<th>" + UtilI18N.internacionaliza(request, "processoNegocio.descricaoUnidade") + "</th> ");
		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.acoes") + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody id=\"bodyTabelaProcessoNegocioUnidade\"> ");

		return sb.toString();
	}

	/**
	 * Gera o html dos dados da tabela vincular unidade
	 *
	 * @author deborah.ferreira
	 * @since 12.01.2016
	 */
	private String geraHtmlDadosTabela(List<UnidadeDTO> listaUnidades, DocumentHTML document, HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();
		for (int i = 0; i < listaUnidades.size(); i++) {
			sb.append(geraHtmlLinhaTabela(request, listaUnidades.get(i).getIdUnidade(), listaUnidades.get(i).getNome()));
		}
		return sb.toString();
	}

	/**
	 * Gera o html da linha da tabela vincular unidade
	 *
	 * @author deborah.ferreira
	 * @since 12.01.2016
	 */
	private String geraHtmlLinhaTabela(HttpServletRequest request, Integer id, String descricao) {
		StringBuilder sb = new StringBuilder();		
		String onMouseOver = "onmouseover=\"abreTooltip(this, '"+UtilI18N.internacionaliza(request, "processoNegocio.desvincularUnidade")+"')\" onmouseout=\"fechaTooltip();\"";

		sb.append("		<tr id=\""+id+"\">");
		sb.append("			<td class=\"center\">" + id + "</td> ");
		sb.append("			<td>" + descricao + "</td> ");
		sb.append("			<td class=\"center\" style=\"width: 50px;\">");
		sb.append("				<a onclick=\"Unidade.removerUnidadeFromTable(this);\" "+onMouseOver+" class=\"btn-action glyphicons remove_2 btn-default\"><i></i></a>");
		sb.append("			</td> ");
		sb.append("		</tr> ");

		return sb.toString();
	}

	/**
	 * Gera o html do final da tabela vincular unidade
	 *
	 * @author deborah.ferreira
	 * @since 12.01.2016
	 */
	private String geraHTMLFinalTabela() {
		StringBuilder sb = new StringBuilder();
		sb.append("			</tbody> ");
		sb.append("		</table>");
		sb.append("	</div>");

		return sb.toString();
	}

}