package br.com.centralit.citcorpore.ajaxForms;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLTable;
import br.com.centralit.citcorpore.bean.AtividadesOSDTO;
import br.com.centralit.citcorpore.bean.ProgramacaoAtividadeDTO;
import br.com.centralit.citcorpore.negocio.AtividadesOSService;
import br.com.centralit.citcorpore.negocio.ProgramacaoAtividadeService;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;

public class ProgramacaoAtividade extends AjaxFormAction {

	@Override
	public Class getBeanClass() {
		return ProgramacaoAtividadeDTO.class;
	}

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
	}

    public void atualizaGrid(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception{
        ProgramacaoAtividadeDTO programacaoAtividadeDto = (ProgramacaoAtividadeDTO) document.getBean();

		ProgramacaoAtividadeService programacaoAtividadeService = (ProgramacaoAtividadeService) ServiceLocator.getInstance().getService(ProgramacaoAtividadeService.class, null);
        programacaoAtividadeService.validaProgramacao(programacaoAtividadeDto);

		programacaoAtividadeDto.setDetalhamento(this.internacionalizaMensagens(request, programacaoAtividadeDto.getDetalhamento()));
		programacaoAtividadeDto.setDuracaoEstimadaDescr(this.internacionalizaMensagens(request, programacaoAtividadeDto.getDuracaoEstimadaDescr()));
		programacaoAtividadeDto.setRepeticaoDescr(this.internacionalizaMensagens(request, programacaoAtividadeDto.getRepeticaoDescr()));

        HTMLTable tblAgendamentos = document.getTableById("tblAgendamentos");

        if(programacaoAtividadeDto.getIdAtividadesOs() != null){
			AtividadesOSService atividadesOSService = (AtividadesOSService) ServiceLocator.getInstance().getService(AtividadesOSService.class, null);
        	AtividadesOSDTO atividadesOSDTO = new AtividadesOSDTO();
        	atividadesOSDTO.setIdAtividadesOS(programacaoAtividadeDto.getIdAtividadesOs());
        	atividadesOSDTO = (AtividadesOSDTO) atividadesOSService.restore(atividadesOSDTO);

        	programacaoAtividadeDto.setNomeAtividadeOs(atividadesOSDTO.getDescricaoAtividade());
        }

		programacaoAtividadeDto.setTipoAgendamentoDescr(UtilI18N.internacionaliza(request, programacaoAtividadeDto.getTipoAgendamentoDescr()));

        if (programacaoAtividadeDto.getSequencia() == null){
            tblAgendamentos.addRow(programacaoAtividadeDto,
                                    new String[] {"", "", "tipoAgendamentoDescr","nomeAtividadeOs" ,"dataInicio","detalhamento","duracaoEstimadaDescr","repeticaoDescr"},
                                    null,
                                    "",
                                    new String[] {"exibeIconesAgendamento"},
                                    null,
                                    null);
        }else{
            tblAgendamentos.updateRow(programacaoAtividadeDto,
                                    new String[] {"", "", "tipoAgendamentoDescr","nomeAtividadeOs" ,"dataInicio","detalhamento","duracaoEstimadaDescr","repeticaoDescr"},
                                    null,
                                    "",
                                    new String[] {"exibeIconesAgendamento"},
                                    null,
                                    null,
                                    programacaoAtividadeDto.getSequencia());
        }
        document.executeScript("HTMLUtils.applyStyleClassInAllCells('tblAgendamentos', 'tdPontilhada');");
        document.alert(UtilI18N.internacionaliza(request, "periodica.gravado_sucesso"));
        document.executeScript("fecharAgendamento();");
    }

	/**
	 * Internacionaliza o contedo apresentado na Grid
	 * 
	 * @author gilmar.junior
	 * @since 2016-04-12
	 */

	public String internacionalizaMensagens(HttpServletRequest request, String mensagem) {
		String[] internacionalizarMsg = mensagem.split("#");
		StringBuilder sb = new StringBuilder();
		
		for (int i = 0; i < internacionalizarMsg.length; i++) {
			if (i == internacionalizarMsg.length - 1) {
				if (internacionalizarMsg[i].trim() != null && !internacionalizarMsg[i].trim().isEmpty())
					sb.append(UtilI18N.internacionaliza(request, internacionalizarMsg[i].trim()));
			} else {
				if (internacionalizarMsg[i].trim() != null && !internacionalizarMsg[i].trim().isEmpty())
					sb.append(UtilI18N.internacionaliza(request, internacionalizarMsg[i].trim())).append(" ");
			}
		}
		String retorno = sb.toString();
		
		retorno = retorno.replaceAll(" , ", ", ");
		
		return retorno;
	}
}
