package br.com.centralit.citcorpore.ajaxForms;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.mysql.jdbc.StringUtils;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLCheckbox;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.AssinaturaAprovacaoProjetoDTO;
import br.com.centralit.citcorpore.bean.ClienteDTO;
import br.com.centralit.citcorpore.bean.ContratoDTO;
import br.com.centralit.citcorpore.bean.ContratosGruposDTO;
import br.com.centralit.citcorpore.bean.FornecedorDTO;
import br.com.centralit.citcorpore.bean.LinhaBaseProjetoDTO;
import br.com.centralit.citcorpore.bean.OSDTO;
import br.com.centralit.citcorpore.bean.ProjetoDTO;
import br.com.centralit.citcorpore.bean.RecursoProjetoDTO;
import br.com.centralit.citcorpore.bean.RequisicaoLiberacaoDTO;
import br.com.centralit.citcorpore.bean.RequisicaoMudancaDTO;
import br.com.centralit.citcorpore.bean.ServicoContratoDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.negocio.AssinaturaAprovacaoProjetoService;
import br.com.centralit.citcorpore.negocio.ClienteService;
import br.com.centralit.citcorpore.negocio.ContratoService;
import br.com.centralit.citcorpore.negocio.ContratosGruposService;
import br.com.centralit.citcorpore.negocio.EmpregadoService;
import br.com.centralit.citcorpore.negocio.FornecedorService;
import br.com.centralit.citcorpore.negocio.LinhaBaseProjetoService;
import br.com.centralit.citcorpore.negocio.OSService;
import br.com.centralit.citcorpore.negocio.ProjetoService;
import br.com.centralit.citcorpore.negocio.RecursoProjetoService;
import br.com.centralit.citcorpore.negocio.RequisicaoLiberacaoService;
import br.com.centralit.citcorpore.negocio.RequisicaoMudancaService;
import br.com.centralit.citcorpore.negocio.ServicoContratoService;
import br.com.centralit.citcorpore.negocio.ServicoService;
import br.com.centralit.citcorpore.util.ComparatorUtil;
import br.com.centralit.citcorpore.util.Enumerados.SituacaoLinhaBaseProjeto;
import br.com.centralit.citcorpore.util.Enumerados.TipoDate;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilFormatacao;
import br.com.citframework.util.UtilI18N;

@SuppressWarnings({ "unchecked", "rawtypes", "unused" })
public class Projeto extends AjaxFormAction {
	private EmpregadoService empregadoService;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.executeScript("notificacaoErro('citcorpore.comum.sessaoExpirada');");
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}
		ContratoService contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);

		carregaComboSituacaoFuncional(document, request);

		ClienteService clienteService = (ClienteService) ServiceLocator.getInstance().getService(ClienteService.class, null);
		FornecedorService fornecedorService = (FornecedorService) ServiceLocator.getInstance().getService(FornecedorService.class, null);
		ContratosGruposService contratosGruposService = (ContratosGruposService) ServiceLocator.getInstance().getService(ContratosGruposService.class, null);
		ProjetoService projetoService = (ProjetoService) ServiceLocator.getInstance().getService(ProjetoService.class,null);

		Collection colContratos = contratoService.list();
		String COLABORADORES_VINC_CONTRATOS = ParametroUtil.getValorParametroCitSmartHashMap(br.com.centralit.citcorpore.util.Enumerados.ParametroSistema.COLABORADORES_VINC_CONTRATOS, "N");
		if (COLABORADORES_VINC_CONTRATOS == null) {
			COLABORADORES_VINC_CONTRATOS = "N";
		}
		Collection colContratosColab = null;
		if (COLABORADORES_VINC_CONTRATOS.equalsIgnoreCase("S")) {
			colContratosColab = contratosGruposService.findByIdEmpregado(usuario.getIdEmpregado());
		}

		ProjetoDTO projetoDTO = (ProjetoDTO) document.getBean();
		if (projetoDTO != null && projetoDTO.getIdProjeto() != null) {
			projetoDTO = projetoService.restore(projetoDTO);
			HTMLSelect comboIdSituacaoFuncional = document.getSelectById("situacao");
			comboIdSituacaoFuncional.setValue(projetoDTO.getSituacao());
		} else {
			geraHtmlRecursoProjeto(null, document, request);
			geraHtmlAssinaturaAprovacao(null, document, request);
			document.getElementById("divLinhasBase").setInnerHTML("<h5>" + UtilI18N.internacionaliza(request, "projeto.nenhumaLinhaBase") + "</h5>");
		}

		Collection<ContratoDTO> listaContratos = new ArrayList<ContratoDTO>();
		if (colContratos != null) {
			HTMLSelect comboContrato = document.getSelectById("idContrato");
			comboContrato.removeAllOptions();
			if (colContratos.size() > 0) {
				comboContrato.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
			}
			for (Iterator it = colContratos.iterator(); it.hasNext();) {
				ContratoDTO contratoDto = (ContratoDTO) it.next();
				if (contratoDto.getDeleted() == null || !contratoDto.getDeleted().equalsIgnoreCase("y")) {
					if (COLABORADORES_VINC_CONTRATOS.equalsIgnoreCase("S")) { // Se parametro de colaboradores por contrato ativo, entao filtra.
						if (colContratosColab == null) {
							continue;
						}
						if (!isContratoInList(contratoDto.getIdContrato(), colContratosColab)) {
							continue;
						}
					}

					// Filtra os contratos pelo idCliente
					if (projetoDTO != null && projetoDTO.getIdClienteParaFiltrarComboContrato() != null) {
						if (!contratoDto.getIdCliente().equals(projetoDTO.getIdClienteParaFiltrarComboContrato())) {
							continue;
						}
					}

					String nomeCliente = "";
					String nomeForn = "";
					ClienteDTO clienteDto = new ClienteDTO();
					clienteDto.setIdCliente(contratoDto.getIdCliente());
					clienteDto = (ClienteDTO) clienteService.restore(clienteDto);
					if (clienteDto != null) {
						nomeCliente = clienteDto.getNomeRazaoSocial();
					}
					FornecedorDTO fornecedorDto = new FornecedorDTO();
					fornecedorDto.setIdFornecedor(contratoDto.getIdFornecedor());
					fornecedorDto = (FornecedorDTO) fornecedorService.restore(fornecedorDto);
					if (fornecedorDto != null) {
						nomeForn = fornecedorDto.getRazaoSocial();
					}
					if (contratoDto.getSituacao().equalsIgnoreCase("A")) {
						String nomeContrato = "" + contratoDto.getNumero() + " de " + UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, contratoDto.getDataContrato(), WebUtil.getLanguage(request)) + " (" + nomeCliente + " - " + nomeForn + ")";
						comboContrato.addOption("" + contratoDto.getIdContrato(), nomeContrato);
						contratoDto.setNome(nomeContrato);
						listaContratos.add(contratoDto);
					}
				}
			}

		}

		if(projetoDTO!=null && projetoDTO.getIdContrato()!=null){
			document.getSelectById("idContrato").setValue(""+projetoDTO.getIdContrato());
		}

		document.focusInFirstActivateField(null);
	}

	private void carregaComboSituacaoFuncional(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect comboIdSituacaoFuncional = document.getSelectById("situacao");
		inicializarCombo(request, comboIdSituacaoFuncional);
		comboIdSituacaoFuncional.addOption("A", UtilI18N.internacionaliza(request, "citcorpore.comum.ativo"));
		comboIdSituacaoFuncional.addOption("I", UtilI18N.internacionaliza(request, "citcorpore.comum.inativo"));
	}

	protected void inicializarCombo(HttpServletRequest request, HTMLSelect combo) {
		combo.removeAllOptions();
		combo.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
	}

	private boolean isContratoInList(Integer idContrato, Collection colContratosColab) {
		if (colContratosColab != null) {
			for (Iterator it = colContratosColab.iterator(); it.hasNext();) {
				ContratosGruposDTO contratosGruposDTO = (ContratosGruposDTO) it.next();
				if (contratosGruposDTO.getIdContrato().intValue() == idContrato.intValue()) {
					return true;
				}
			}
		}
		return false;
	}

	public void Projeto_onsave(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		Collection<RecursoProjetoDTO> colRecursos = br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(RecursoProjetoDTO.class, "colRecursosSerialize", request);
		Collection<AssinaturaAprovacaoProjetoDTO> colAssinaturas = br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(AssinaturaAprovacaoProjetoDTO.class, "colAssinaturasSerialize", request);
		// System.out.println("---> " + colFaixasValores);
		ProjetoDTO projeto = (ProjetoDTO) document.getBean();

		ProjetoService projetoService = (ProjetoService) ServiceLocator.getInstance().getService(ProjetoService.class, WebUtil.getUsuarioSistema(request));
		ContratoService contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, WebUtil.getUsuarioSistema(request));
		if (projeto.getIdContrato() == null) {
			document.executeScript("notificacaoErro('projeto.contratoNaoEncontrado');");
			return;
		}

        if (projeto.getVinculoOS() != null && projeto.getVinculoOS().equalsIgnoreCase("S")) {
        	String validacao = this.validaObrigatoriedade(projeto);
        	if(!StringUtils.isNullOrEmpty(validacao)){
        		document.alert(UtilI18N.internacionaliza(request, validacao));
        		return;
            }
        }

		ContratoDTO contratoDTO = new ContratoDTO();
		contratoDTO.setIdContrato(projeto.getIdContrato());
		contratoDTO = (ContratoDTO) contratoService.restore(contratoDTO);
		if (contratoDTO == null) {
			document.executeScript("notificacaoErro('projeto.contratoNaoEncontrado');");
			return;
		}
		projeto.setIdCliente(contratoDTO.getIdCliente());
		projeto.setColRecursos(colRecursos);
		projeto.setColAssinaturasAprovacoes(colAssinaturas);

		if (projeto.getIdProjeto() == null || projeto.getIdProjeto().intValue() == 0) {
			projeto = projetoService.create(projeto);
			document.getForm("formProjeto").setValue("idProjeto", projeto.getIdProjeto());
			document.executeScript("notificacaoI18N('MSG05');");

		} else {
			projetoService.update(projeto);
			document.executeScript("notificacaoI18N('MSG06');");

		}
		document.executeScript("Projeto.limpar();");
	}

	public void Projeto_onrestore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		ProjetoDTO projeto = (ProjetoDTO) document.getBean();
		ProjetoService projetoService = (ProjetoService) ServiceLocator.getInstance().getService(ProjetoService.class, null);
		RecursoProjetoService recursoProjetoService = (RecursoProjetoService) ServiceLocator.getInstance().getService(RecursoProjetoService.class, null);
		AssinaturaAprovacaoProjetoService assinaturaAprovacaoService = (AssinaturaAprovacaoProjetoService) ServiceLocator.getInstance().getService(AssinaturaAprovacaoProjetoService.class, null);
		OSService osService = (OSService) ServiceLocator.getInstance().getService(OSService.class, null);
		RequisicaoMudancaService requisicaoMudancaService = (RequisicaoMudancaService) ServiceLocator.getInstance().getService(RequisicaoMudancaService.class, null);
		RequisicaoLiberacaoService requisicaoLiberacaoService = (RequisicaoLiberacaoService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoService.class, null);

		projeto = (ProjetoDTO) projetoService.restore(projeto);

		HTMLForm form = document.getForm("formProjeto");
		form.clear();
		document.executeScript("limpar_LOOKUP_PROJETO_MUDANCA();");
		document.executeScript("limpar_LOOKUP_PROJETO_LIBERACAO();");
		if (projeto.getIdOs() != null) {
			OSDTO osDto = new OSDTO();
			osDto.setIdOS(projeto.getIdOs());
			osDto = (OSDTO) osService.restore(osDto);
			if (osDto != null) {
				projeto.setAno(osDto.getAno());
				projeto.setNumero(osDto.getNumero());
				projeto.setNomeAreaRequisitante(osDto.getNomeAreaRequisitante());
				projeto.setDemanda(osDto.getDemanda());
				projeto.setObjetivo(osDto.getObjetivo());
				projeto.setIdServicoContrato(osDto.getIdServicoContrato());
				projeto.setDataEmissao(osDto.getDataEmissao());
				document.setBean(projeto);
				carregaInfoOS(document, request, response);
			}
			projeto.setVinculoOS("S");
			document.getElementById("divProjetoOS").setVisible(true);
		}
		/*
		 * Desenvolvedor: Pedro Lino - Data: 28/10/2013 - Horrio: 13:58 - ID Citsmart: 120948 - Motivo/Comentrio: Erro de javascript ao usar setvalue e settext/ novo padro de lookup nao h
		 * necessidade
		 */
		form.setValues(projeto);
		if (projeto.getIdRequisicaoMudanca() != null) {
			RequisicaoMudancaDTO requisicaoMudancaDTO = new RequisicaoMudancaDTO();
			requisicaoMudancaDTO.setIdRequisicaoMudanca(projeto.getIdRequisicaoMudanca());
			requisicaoMudancaDTO = (RequisicaoMudancaDTO) requisicaoMudancaService.restore(requisicaoMudancaDTO);
			if (requisicaoMudancaDTO != null) {
				String aux = requisicaoMudancaDTO.getNumberAndTitulo();
				aux = aux.replaceAll("\'", "");
				aux = aux.replaceAll("\"", "");
				document.executeScript("LOOKUP_PROJETO_MUDANCA_select('" + projeto.getIdRequisicaoMudanca() + "','" + aux + "')");
			}
		}
		/*
		 * Desenvolvedor: Pedro Lino - Data: 28/10/2013 - Horrio: 13:58 - ID Citsmart: 120948 - Motivo/Comentrio: Erro de javascript ao usar setvalue e settext/ novo padro de lookup nao h
		 * necessidade
		 */
		if (projeto.getIdLiberacao() != null) {
			RequisicaoLiberacaoDTO requisicaoLiberacaoDTO = new RequisicaoLiberacaoDTO();
			requisicaoLiberacaoDTO.setIdRequisicaoLiberacao(projeto.getIdLiberacao());
			requisicaoLiberacaoDTO = (RequisicaoLiberacaoDTO) requisicaoLiberacaoService.restore(requisicaoLiberacaoDTO);
			if (requisicaoLiberacaoDTO != null) {
				String aux = requisicaoLiberacaoDTO.getTitulo();
				aux = aux.replaceAll("\'", "");
				aux = aux.replaceAll("\"", "");
				document.executeScript("LOOKUP_PROJETO_LIBERACAO_select('" + projeto.getIdLiberacao() + "','" + aux + "')");
			}
		}

		Collection<RecursoProjetoDTO> colRecursosProjeto = recursoProjetoService.findRecursoProjetoComEmpregadoByIdProjeto(projeto.getIdProjeto());
		geraHtmlRecursoProjeto(colRecursosProjeto, document, request);

		Collection<AssinaturaAprovacaoProjetoDTO> colAssinaturaAprovacaoProjeto = assinaturaAprovacaoService.findAssinaturaAprovacaoComEmpregadoByIdProjeto(projeto.getIdProjeto());
		geraHtmlAssinaturaAprovacao(colAssinaturaAprovacaoProjeto, document, request);

		carregaInfoLinhaBase(document, request, projeto.getIdProjeto());
	}

	/*
	 * Desenvolvedor: Bruno Rodrigues Data: 28/10/2013 - Horrio: 10h27min ID Citsmart: 120948 Motivo/Comentrio: Problema na internacionalizao dos labels dessa tabela e do boto de autorizar
	 * mudana.
	 */

	/*
	 * Desenvolvedor: Pedro Lino - Data: 28/10/2013 - Horrio: 13:58 - ID Citsmart: 120948 - Motivo/Comentrio: Tabela com dificil visualizao/ alterado layout: retirado algumas bordas
	 */
	public void carregaInfoLinhaBase(DocumentHTML document, HttpServletRequest request, Integer idProjeto) throws ServiceException, Exception {
		LinhaBaseProjetoService linhaBaseProjetoService = (LinhaBaseProjetoService) ServiceLocator.getInstance().getService(LinhaBaseProjetoService.class, null);
		Collection<LinhaBaseProjetoDTO> colLinhasBaseProjeto = linhaBaseProjetoService.findByIdProjeto(idProjeto);

		StringBuilder sb = new StringBuilder();
		if (colLinhasBaseProjeto != null && !colLinhasBaseProjeto.isEmpty()) {
			String onMouseOver = "onmouseover=\"abreTooltip(this, '" + UtilI18N.internacionaliza(request, "projeto.autorizarMudanca") + "')\" onmouseout=\"fechaTooltip();\"";

			sb.append("	<div class=\"table-responsive tabela\" >");
			sb.append("		<table class=\"table table-bordered table-striped table-condensed\"> ");
			sb.append("			<thead> ");
			sb.append("				<tr> ");
			sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "ID") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.data") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "eventoItemConfiguracao.hora") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "projeto.usuarioUltAlteracao") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.situacao") + "</th> ");
			sb.append("					<th class='visualizacaoHide'>" + UtilI18N.internacionaliza(request, "citcorpore.comum.acoes") + "</th> ");
			sb.append("				</tr> ");
			sb.append("			</thead> ");
			sb.append("			<tbody> ");

			for (LinhaBaseProjetoDTO linhaBaseProjetoDTO : colLinhasBaseProjeto) {
				String situacao = linhaBaseProjetoDTO.getSituacao();
				String acaoSituacao = "";
				if (SituacaoLinhaBaseProjeto.EM_EXECUCAO.getIdentificador().equals(situacao)) {
					acaoSituacao = "<a onclick='Projeto.registrarAutorizacao(\"" + linhaBaseProjetoDTO.getIdLinhaBaseProjeto() + "\")' " + onMouseOver
							+ " class=\"btn-action glyphicons ok_2 btn-default\"><i></i></a>";
				}
				situacao = UtilI18N.internacionaliza(request, SituacaoLinhaBaseProjeto.fromIdentificador(situacao).getChave());

				sb.append("		<tr id='" + linhaBaseProjetoDTO.getIdLinhaBaseProjeto() + "'>");
				sb.append("			<td class=\"center\">" + linhaBaseProjetoDTO.getIdLinhaBaseProjeto() + "</td> ");
				sb.append("			<td>" + UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, linhaBaseProjetoDTO.getDataLinhaBase(), WebUtil.getLanguage(request)) + "</td> ");
				sb.append("			<td>" + UtilFormatacao.formataHoraHHMM(linhaBaseProjetoDTO.getHoraLinhaBase()) + "</td> ");
				sb.append("			<td>" + linhaBaseProjetoDTO.getUsuarioUltAlteracao() + "</td> ");
				sb.append("			<td>" + situacao + "</td> ");
				sb.append("			<td class=\"center visualizacaoHide\" style=\"width: 30px;\">");
				sb.append(acaoSituacao);
				sb.append("			</td> ");
				sb.append("		</tr> ");

				if (linhaBaseProjetoDTO.getJustificativaMudanca() != null && !linhaBaseProjetoDTO.getJustificativaMudanca().trim().equalsIgnoreCase("")) {
					sb.append("	<tr>");
					sb.append("		<td colspan=\"6\" style='padding: 15px 30px;'>");
					sb.append("			<div class=\"row-fluid\" >");
					sb.append("				<div class=\"span12\">");
					sb.append("					<h5>" + UtilI18N.internacionaliza(request, "projeto.solicitacaoMudancaLinhaBase") + "</h5>");
					sb.append("					<hr style=\"margin: 0px;\">");
					sb.append("				</div>");
					sb.append("			</div>");
					sb.append("			<div class=\"row-fluid\" style='padding-top: 15px;'>");
					sb.append("				<div class=\"span4\">");
					sb.append("					<label class=\"strong\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.data") + " - " + UtilI18N.internacionaliza(request, "eventoItemConfiguracao.hora") + "</label>");
					sb.append("					<span type=\"text\" class=\"span12\" >" + UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, linhaBaseProjetoDTO.getDataSolMudanca(), WebUtil.getLanguage(request)) + " - " + UtilFormatacao.formataHoraHHMM(linhaBaseProjetoDTO.getHoraSolMudanca())
							+ "</span>");
					sb.append("				</div>");
					sb.append("				<div class=\"span6\">");
					sb.append("					<label class=\"strong\">" + UtilI18N.internacionaliza(request, "projeto.usuarioSolicitacaoMudanca") + "</label>");
					sb.append("					<span type=\"text\" class=\"span12\" >" + linhaBaseProjetoDTO.getUsuarioSolMudanca() + "</span>");
					sb.append("				</div>");
					sb.append("			</div>");
					sb.append("			<div class=\"row-fluid\" >");
					sb.append("				<div class=\"span12\">");
					sb.append("					<label class=\"strong\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.justificativa") + "</label>");
					sb.append("					<span type=\"text\" class=\"span12\" >" + linhaBaseProjetoDTO.getJustificativaMudanca() + "</span>");
					sb.append("				</div>");
					sb.append("			</div>");
					sb.append("		</td> ");
					sb.append("	</tr> ");
				}
			}

			sb.append(geraFinalTabela());

		} else {
			sb.append("<h5>" + UtilI18N.internacionaliza(request, "projeto.nenhumaLinhaBase") + "</h5>");
		}

		document.getElementById("divLinhasBase").setInnerHTML(sb.toString());
	}

	public void carregaInfoOS(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		ProjetoDTO projeto = (ProjetoDTO) document.getBean();
		if (projeto.getIdContrato() == null) {
			document.executeScript("notificacaoErro('projeto.informeContrato');");
			HTMLCheckbox checkBox = document.getCheckboxById("vinculoOS");
			checkBox.setChecked(false);
			document.executeScript("$('#divProjetoOS').hide()");
			document.executeScript("Projeto.limparVinculacoesOS()");
			return;
		}
		HTMLSelect idContrato = document.getSelectById("idServicoContrato");
		ServicoContratoService servicoContratoService = (ServicoContratoService) ServiceLocator.getInstance().getService(ServicoContratoService.class, null);
		ServicoService servicoService = (ServicoService) ServiceLocator.getInstance().getService(ServicoService.class, null);
		Collection colServicosDoContrato = servicoContratoService.findByIdContrato(projeto.getIdContrato());
		idContrato.removeAllOptions();
		idContrato.addOption("", UtilI18N.internacionaliza(request, "projeto.selecioneServico"));
		List colFinal = new ArrayList();
		if (colServicosDoContrato != null) {
			for (Iterator it = colServicosDoContrato.iterator(); it.hasNext();) {
				ServicoContratoDTO servicoContratoDTO = (ServicoContratoDTO) it.next();
				if (servicoContratoDTO.getDeleted() == null || servicoContratoDTO.getDeleted().equalsIgnoreCase("n")) {
					if (servicoContratoDTO.getDataFim() == null || servicoContratoDTO.getDataFim().after(UtilDatas.getDataAtual())) {
						ServicoDTO servicoDto = new ServicoDTO();
						servicoDto.setIdServico(servicoContratoDTO.getIdServico());
						servicoDto = (ServicoDTO) servicoService.restore(servicoDto);
						if (servicoDto != null) {
							String sigla = servicoDto.getSiglaAbrev();
							String nomeServico = servicoDto.getNomeServico();
							if (sigla != null && nomeServico != null) {
								sigla = sigla.trim();
								nomeServico = nomeServico.trim();
								if (!sigla.equals("")) {
									servicoContratoDTO.setNomeServico(sigla + " - " + nomeServico);
								} else {
									servicoContratoDTO.setNomeServico(nomeServico);
								}
							} else {
								servicoContratoDTO.setNomeServico(nomeServico);
							}

							if (servicoDto.getIdTipoDemandaServico() != null && servicoDto.getIdTipoDemandaServico().intValue() == 2) {
								colFinal.add(servicoContratoDTO);
							}
						}
					}
				}
			}
		}
		if (colFinal != null) {
			Collections.sort(colFinal, ComparatorUtil.getComparatorPorNomeServico());
			for (Iterator it = colFinal.iterator(); it.hasNext();) {
				ServicoContratoDTO servicoContratoDTO = (ServicoContratoDTO) it.next();
				idContrato.addOption("" + servicoContratoDTO.getIdServicoContrato(), servicoContratoDTO.getNomeServico());
			}
		}
	}

	public void gravarAutorizMudanca(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.executeScript("notificacaoErro('citcorpore.comum.sessaoExpirada');");
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}
		ProjetoDTO projeto = (ProjetoDTO) document.getBean();
		if (projeto.getIdProjetoAutorizacao() == null) {
			document.executeScript("notificacaoErro('pagamentoProjeto.informeProjeto');");
			return;
		}
		if (projeto.getIdLinhaBaseProjeto() == null) {
			document.executeScript("notificacaoErro('projeto.informeLinhaBase');");
			return;
		}
		if (projeto.getJustificativaMudanca() == null || projeto.getJustificativaMudanca().trim().equalsIgnoreCase("")) {
			document.executeScript("notificacaoErro('projeto.justificativaLinhaBase');");
			return;
		}
		LinhaBaseProjetoService linhaBaseProjetoService = (LinhaBaseProjetoService) ServiceLocator.getInstance().getService(LinhaBaseProjetoService.class, WebUtil.getUsuarioSistema(request));
		String hora = UtilDatas.getHoraHHMM(UtilDatas.getDataHoraAtual()).replaceAll(":", "");
		LinhaBaseProjetoDTO linhaBaseProjetoDTO = new LinhaBaseProjetoDTO();
		linhaBaseProjetoDTO.setIdLinhaBaseProjeto(projeto.getIdLinhaBaseProjeto());
		linhaBaseProjetoDTO.setDataSolMudanca(UtilDatas.getDataAtual());
		linhaBaseProjetoDTO.setHoraSolMudanca(hora);
		linhaBaseProjetoDTO.setJustificativaMudanca(projeto.getJustificativaMudanca());
		linhaBaseProjetoDTO.setUsuarioSolMudanca(usuario.getNomeUsuario());
		linhaBaseProjetoService.updateAutorizacaoMudanca(linhaBaseProjetoDTO);
		document.executeScript("notificacaoI18N('projeto.gravaAutorizacao');");
		carregaInfoLinhaBase(document, request, projeto.getIdProjetoAutorizacao());
		document.executeScript("$(\"#POPUP_PROJETO_REG_AUT_MUDANCA\").dialog(\"close\");");
	}

	public void delete(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		ProjetoDTO projetoDto = (ProjetoDTO) document.getBean();
		ProjetoService projetoService = (ProjetoService) ServiceLocator.getInstance().getService(ProjetoService.class, null);
		LinhaBaseProjetoService linhaBaseProjetoService = (LinhaBaseProjetoService) ServiceLocator.getInstance().getService(LinhaBaseProjetoService.class, null);
		RecursoProjetoService recursoProjetoService = (RecursoProjetoService) ServiceLocator.getInstance().getService(RecursoProjetoService.class, null);
		AssinaturaAprovacaoProjetoService assinaturaAprovacaoService = (AssinaturaAprovacaoProjetoService) ServiceLocator.getInstance().getService(AssinaturaAprovacaoProjetoService.class, null);

		if (projetoDto.getIdProjeto().intValue() > 0) {
			// tratar excluso
			// Se existe vinculo com linha de base
			if (linhaBaseProjetoService.findByIdProjeto(projetoDto.getIdProjeto()) != null) {
				document.executeScript("notificacaoErro('citcorpore.comum.registroNaoPodeSerExcluidoLinhaBase');");
				document.executeScript("Projeto.limpar()");
				return;
			}
			// Se existe algum recurso, excluir se estiver vinculado
			if (recursoProjetoService.findByIdProjeto(projetoDto.getIdProjeto()) != null) {
				recursoProjetoService.deleteByIdProjeto(projetoDto.getIdProjeto());
			}
			// Se existe alguma assinatura, excluir se estiver vinculado
			if (assinaturaAprovacaoService.findByIdProjeto(projetoDto.getIdProjeto()) != null) {
				assinaturaAprovacaoService.deleteByIdProjeto(projetoDto.getIdProjeto());
			}

			projetoDto = (ProjetoDTO) projetoService.restore(projetoDto);
			projetoDto.setDeleted("y");
			projetoService.update(projetoDto);
			document.executeScript("notificacaoI18N('MSG07');");
		}

		document.executeScript("Projeto.limpar()");
		document.executeScript("limpar_LOOKUP_PROJETO()");

	}

	/**
	 * @author deborah.ferreira
	 * @since 27.02.2016
	 */
	public void geraHtmlRecursoProjeto(Collection<RecursoProjetoDTO> colRecursoProjeto, DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLElement divRecursoProjetoConteudo = document.getElementById("divRecursoProjetoConteudo");
		StringBuilder sb = new StringBuilder();
		if (colRecursoProjeto != null && !colRecursoProjeto.isEmpty()) {

			sb.append(geraCabecalhoTabelaRecursoProjeto(request));
			for (RecursoProjetoDTO recursoProjetoDTO : colRecursoProjeto) {
				sb.append(geraDadosTabelaRecursoProjeto(recursoProjetoDTO.getIdEmpregado(), recursoProjetoDTO.getNomeEmpregado(), recursoProjetoDTO.getCustoHora(), document, request));
			}
			sb.append(geraFinalTabela());

		} else {
			sb.append("<h5>" + UtilI18N.internacionaliza(request, "projeto.nenhumRecursoAdicionado") + "</h5>");
		}
		divRecursoProjetoConteudo.setInnerHTML(sb.toString());
	}

	/**
	 * @author deborah.ferreira
	 * @since 28.02.2016
	 */
	public void addLinhaTabelaRecursoProjeto(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		ProjetoDTO projetoDTO = (ProjetoDTO) document.getBean();
		String contentHtml = geraDadosTabelaRecursoProjeto(projetoDTO.getIdEmpregadoRecursoProjeto(), projetoDTO.getNomeEmpregadoRecursoProjeto(), projetoDTO.getCustoHoraRecursoProjeto(), document,
				request);
		document.executeScript("Projeto.appendTbody('tbodyTabelaRecursoProjeto', '" + contentHtml + "')");
	}

	/**
	 * @author deborah.ferreira
	 * @since 28.02.2016
	 */
	public void addTabelaRecursoProjeto(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLElement divRecursoProjetoConteudo = document.getElementById("divRecursoProjetoConteudo");
		ProjetoDTO projetoDTO = (ProjetoDTO) document.getBean();
		StringBuilder sb = new StringBuilder();

		sb.append(geraCabecalhoTabelaRecursoProjeto(request));
		sb.append(geraDadosTabelaRecursoProjeto(projetoDTO.getIdEmpregadoRecursoProjeto(), projetoDTO.getNomeEmpregadoRecursoProjeto(), projetoDTO.getCustoHoraRecursoProjeto(), document, request));
		sb.append(geraFinalTabela());

		divRecursoProjetoConteudo.setInnerHTML(sb.toString());
	}

	/**
	 * @author deborah.ferreira
	 * @since 28.02.2016
	 */
	private String geraCabecalhoTabelaRecursoProjeto(HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		sb.append("	<div class=\"table-responsive tabela\" >");
		sb.append("		<table class=\"table table-bordered table-striped table-condensed\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.nome") + "</th> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "projeto.custo") + "</th> ");
		sb.append("					<th class='visualizacaoHide'>" + UtilI18N.internacionaliza(request, "citcorpore.comum.acoes") + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody id='tbodyTabelaRecursoProjeto'> ");

		return sb.toString();
	}

	/**
	 * @author deborah.ferreira
	 * @since 28.02.2016
	 */
	private String geraDadosTabelaRecursoProjeto(final Integer idEmpregado, final String nomeEmpregado, final Double custoHora, final DocumentHTML document, final HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();
		DecimalFormat decimal = new DecimalFormat("0.00");
		String onEventsRemover = " onclick=\"Projeto.recursoProjeto.removerRecursoProjetoFromTable(this);\"";
		onEventsRemover = onEventsRemover
				.concat(" onmouseover=\"abreTooltip(this, \"" + UtilI18N.internacionaliza(request, "projeto.desvincularRecursoProjeto") + "\")\" onmouseout=\"fechaTooltip();\"");
		String custoHoraFormatado = "";
		if (custoHora != null) {
			custoHoraFormatado = decimal.format(custoHora);
		}

		sb.append("		<tr id=\"" + idEmpregado + "\">");
		sb.append("			<td>" + nomeEmpregado + "</td> ");
		sb.append("			<td> <input maxlength=\"18\" class=\"mask-moeda visualizacaoDisabled\" type=\"text\" name=\"custoHora\" value=\"" + custoHoraFormatado + "\" /></td> ");
		sb.append("			<td class=\"center visualizacaoHide\" style=\"width: 30px;\">");
		sb.append("				<a " + onEventsRemover + " class=\"btn-action glyphicons remove_2 btn-default\"><i></i></a>");
		sb.append("			</td> ");
		sb.append("		</tr> ");

		return sb.toString();
	}

	/**
	 * @author deborah.ferreira
	 * @since 27.02.2016
	 */
	public void geraHtmlAssinaturaAprovacao(Collection<AssinaturaAprovacaoProjetoDTO> colAssinaturaAprovacaoProjeto, DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLElement divAssinaturaAprovacaoConteudo = document.getElementById("divAssinaturaAprovacaoConteudo");
		StringBuilder sb = new StringBuilder();
		if (colAssinaturaAprovacaoProjeto != null && !colAssinaturaAprovacaoProjeto.isEmpty()) {

			sb.append(geraCabecalhoTabelaAssinaturaAprovacao(request));
			for (AssinaturaAprovacaoProjetoDTO assinaturaAprovacaoProjetoDTO : colAssinaturaAprovacaoProjeto) {
				sb.append(geraDadosTabelaAssinaturaAprovacao(assinaturaAprovacaoProjetoDTO.getIdEmpregadoAssinatura(), assinaturaAprovacaoProjetoDTO.getNomeEmpregado(), assinaturaAprovacaoProjetoDTO.getPapel(), assinaturaAprovacaoProjetoDTO.getOrdem(), request));
			}
			sb.append(geraFinalTabela());

		} else {
			sb.append("<h5>" + UtilI18N.internacionaliza(request, "projeto.nenhumaAssinaturaAprovacaoAdicionada") + "</h5>");
		}
		divAssinaturaAprovacaoConteudo.setInnerHTML(sb.toString());
	}

	/**
	 * @author deborah.ferreira
	 * @since 28.02.2016
	 */
	public void addLinhaTabelaAssinaturaAprovacao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		ProjetoDTO projetoDTO = (ProjetoDTO) document.getBean();
		String contentHtml = geraDadosTabelaAssinaturaAprovacao(projetoDTO.getIdEmpregadoAssinaturaAprovacao(), projetoDTO.getNomeEmpregadoAssinaturaAprovacao(),
				projetoDTO.getPapelAssinaturaAprovacao(), projetoDTO.getOrdemAssinaturaAprovacao(), request);
		document.executeScript("Projeto.appendTbody('tbodyTabelaAssinaturaAprovacao', '" + contentHtml + "')");
	}

	/**
	 * @author deborah.ferreira
	 * @since 28.02.2016
	 */
	public void addTabelaAssinaturaAprovacao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLElement divAssinaturaAprovacaoConteudo = document.getElementById("divAssinaturaAprovacaoConteudo");
		ProjetoDTO projetoDTO = (ProjetoDTO) document.getBean();
		StringBuilder sb = new StringBuilder();

		sb.append(geraCabecalhoTabelaAssinaturaAprovacao(request));
		sb.append(geraDadosTabelaAssinaturaAprovacao(projetoDTO.getIdEmpregadoAssinaturaAprovacao(), projetoDTO.getNomeEmpregadoAssinaturaAprovacao(), projetoDTO.getPapelAssinaturaAprovacao(), projetoDTO.getOrdemAssinaturaAprovacao(), request));
		sb.append(geraFinalTabela());

		divAssinaturaAprovacaoConteudo.setInnerHTML(sb.toString());
	}

	/**
	 * @author deborah.ferreira
	 * @since 28.02.2016
	 */
	private String geraCabecalhoTabelaAssinaturaAprovacao(HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		sb.append("	<div class=\"table-responsive tabela\" >");
		sb.append("		<table class=\"table table-bordered table-striped table-condensed\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.nome") + "</th> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.papel") + "</th> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "projeto.ordem") + "</th> ");
		sb.append("					<th class=\"visualizacaoHide\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.acoes") + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody id=\"tbodyTabelaAssinaturaAprovacao\"> ");

		return sb.toString();
	}

	/**
	 * @author deborah.ferreira
	 * @since 28.02.2016
	 */
	private String geraDadosTabelaAssinaturaAprovacao(final Integer idEmpregado, final String nomeEmpregado, final String papelEmpregado, final String ordemEmpregado, final HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();
		String onEventsRemover = " onclick=\"Projeto.assinaturaAprovacao.removerAssinaturaAprovacaoFromTable(this);\"";
		onEventsRemover = onEventsRemover.concat(" onmouseover=\"abreTooltip(this, \"" + UtilI18N.internacionaliza(request, "projeto.desvincularAssinaturaAprovacao") + "\")\"");
		onEventsRemover = onEventsRemover.concat(" onmouseout=\"fechaTooltip();\"");

		sb.append("		<tr id=\"" + idEmpregado + "\">");
		sb.append("			<td>" + nomeEmpregado + "</td> ");
		sb.append("			<td> <input maxlength=\"100\" class=\"visualizacaoDisabled\" type=\"text\" name=\"papel\" value=\"" + papelEmpregado + "\" /></td> ");
		sb.append("			<td> <input maxlength=\"100\" class=\"mask-numero Valid[Required] visualizacaoDisabled\" type=\"text\" name=\"ordem\" value=\"" + ordemEmpregado + "\" /></td> ");
		sb.append("			<td class=\"center visualizacaoHide\" style=\"width: 30px;\">");
		sb.append("				<a" + onEventsRemover + " class=\"btn-action glyphicons remove_2 btn-default\"><i></i></a>");
		sb.append("			</td> ");
		sb.append("		</tr> ");

		return sb.toString();
	}

	/**
	 * @author deborah.ferreira
	 * @since 28.02.2016
	 */
	private String geraFinalTabela() {
		StringBuilder sb = new StringBuilder();

		sb.append("			</tbody> ");
		sb.append("		</table>");
		sb.append("	</div>");

		return sb.toString();
	}

	@Override
	public Class getBeanClass() {
		return ProjetoDTO.class;
	}

    private String validaObrigatoriedade(final ProjetoDTO projetoDTO) throws LogicException {
        if (projetoDTO.getIdServicoContrato() == null) {
            return "projeto.obrigatorioServico";
        }
        if (projetoDTO.getNumero() == null || projetoDTO.getNumero().equals("")) {
        	return "projeto.obrigatorioNumero";
        }
        if (projetoDTO.getNomeAreaRequisitante() == null || projetoDTO.getNomeAreaRequisitante().equals("")) {
        	return "projeto.obrigatorioRequisitante";
        }
        return "";
    }

	private EmpregadoService getEmpregadoService() throws ServiceException {
		if (empregadoService == null) {
			empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, null);
		}
		return empregadoService;
	}
}