package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citajax.html.HTMLTable;
import br.com.centralit.citcorpore.bean.ClienteDTO;
import br.com.centralit.citcorpore.bean.ContratoDTO;
import br.com.centralit.citcorpore.bean.ContratosGruposDTO;
import br.com.centralit.citcorpore.bean.EmpregadoDTO;
import br.com.centralit.citcorpore.bean.EscalonamentoDTO;
import br.com.centralit.citcorpore.bean.FornecedorDTO;
import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.PrioridadeDTO;
import br.com.centralit.citcorpore.bean.RegraEscalonamentoDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.integracao.PrioridadeDao;
import br.com.centralit.citcorpore.negocio.ClienteService;
import br.com.centralit.citcorpore.negocio.ContratoService;
import br.com.centralit.citcorpore.negocio.ContratosGruposService;
import br.com.centralit.citcorpore.negocio.EmpregadoService;
import br.com.centralit.citcorpore.negocio.EscalonamentoService;
import br.com.centralit.citcorpore.negocio.FornecedorService;
import br.com.centralit.citcorpore.negocio.GrupoService;
import br.com.centralit.citcorpore.negocio.RegraEscalonamentoService;
import br.com.centralit.citcorpore.negocio.ServicoService;
import br.com.centralit.citcorpore.util.Enumerados.ServiceDemandType;
import br.com.centralit.citcorpore.util.Enumerados.SimNao;
import br.com.centralit.citcorpore.util.Enumerados.TipoCatalogoServico;
import br.com.centralit.citcorpore.util.Enumerados.TipoDataEscalonamento;
import br.com.centralit.citcorpore.util.Enumerados.TipoDate;
import br.com.centralit.citcorpore.util.Enumerados.TipoGerenciamentoEscalonamento;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.Util;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;
import br.com.citframework.util.UtilStrings;

public class RegraEscalonamento extends AjaxFormAction {

	private ServicoService servicoService;
	private RegraEscalonamentoService regraEscalonamentoService;
	private EscalonamentoService escalonamentoService;
	private ContratosGruposService contratosGruposService;
	private ContratoService contratoService;
	private ClienteService clienteService;
	private FornecedorService fornecedorService;
	private GrupoService grupoService;
	private EmpregadoService empregadoService;

	@Override
	public Class<RegraEscalonamentoDTO> getBeanClass() {
		return RegraEscalonamentoDTO.class;
	}

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);

		carregarComboTipoGerenciamento(document, request);
		carregarComboTipoDataNotificacaoEmail(document, request);
		carregarComboTipoDataProblema(document, request);
		carregarComboTipoDataEscalonamento(document, request);
		carregarComboGrupoExecutor(document, request);
		carregarComboTipoDemandaServico(document, request);
		carregarComboPrioridade(document, request);
		carregarComboUrgencia(document, request);
		carregarComboImpacto(document, request);
		carregarComboTipoCatalogoServico(document, request);
		carregarComboContrato(document, request, response);
		carregarComboEnviarEmail(document, request);
		carregarComboCriaProblema(document, request);
	}

	private void carregarComboTipoGerenciamento(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect combo = document.getSelectById("idTipoGerenciamento");
		combo.removeAllOptions();

		for (TipoGerenciamentoEscalonamento tipoGerenciamentoEscalonamento : TipoGerenciamentoEscalonamento.values()) {
			combo.addOption(tipoGerenciamentoEscalonamento.getIdentificador().toString(), UtilI18N.internacionaliza(request, tipoGerenciamentoEscalonamento.getChave()));
		}
		
		document.executeScript("$('#idTipoGerenciamento').trigger('change')");
	}

	private void carregarComboTipoDataNotificacaoEmail(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect combo = document.getSelectById("tipoDataNotificacaoEmail");
		carregaOpcoesTipoData(combo, request);
	}

	private void carregarComboTipoDataProblema(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect combo = document.getSelectById("tipoDataProblema");
		carregaOpcoesTipoData(combo, request);
	}

	private void carregarComboTipoDataEscalonamento(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect combo = document.getSelectById("tipoDataEscalonamento");
		carregaOpcoesTipoData(combo, request);
	}

	private void carregaOpcoesTipoData(HTMLSelect combo, HttpServletRequest request) throws Exception {
		inicializarCombo(combo, request);

		for (TipoDataEscalonamento tipoDataEscalonamento : TipoDataEscalonamento.values()) {
			combo.addOption(tipoDataEscalonamento.getIdentificador().toString(), UtilI18N.internacionaliza(request, tipoDataEscalonamento.getChave()));
		}
	}

	private void carregarComboGrupoExecutor(DocumentHTML document, HttpServletRequest request) throws ServiceException, Exception{
		HTMLSelect idGrupoAtual = document.getSelectById("idGrupoAtual");
		inicializarCombo(idGrupoAtual, request);

		Collection<GrupoDTO> colGrupos = getGrupoService().listGruposServiceDesk();
		if (colGrupos != null) {
			idGrupoAtual.addOptions(colGrupos, "idGrupo", "nome", null);
		}
	}

	private void carregarComboTipoDemandaServico(DocumentHTML document, HttpServletRequest request) throws Exception, PersistenceException {
		HTMLSelect idTipoDemandaServico = document.getSelectById("idTipoDemandaServico");
		inicializarCombo(idTipoDemandaServico, request);

		for (ServiceDemandType serviceDemandType : ServiceDemandType.valuesWithoutOS()) {
			idTipoDemandaServico.addOption(String.valueOf(serviceDemandType.getId()), UtilI18N.internacionaliza(request, serviceDemandType.getI18NKey()));
		}
	}

	private void carregarComboPrioridade(DocumentHTML document, HttpServletRequest request) throws Exception, PersistenceException {
		HTMLSelect idPrioridade = document.getSelectById("idPrioridade");
		inicializarCombo(idPrioridade, request);

		ArrayList<PrioridadeDTO> listaPrioridades;
		PrioridadeDao prioridadeDao = new PrioridadeDao();
		listaPrioridades = (ArrayList<PrioridadeDTO>) prioridadeDao.list();

		if (listaPrioridades != null && !listaPrioridades.isEmpty()) {
			for (PrioridadeDTO prioridadeDTO : listaPrioridades) {
				idPrioridade.addOption(String.valueOf(prioridadeDTO.getIdPrioridade()), Util.tratarAspasSimples(Util.retiraBarraInvertida(prioridadeDTO.getNomePrioridade())));
			}
		}
	}

	private void carregarComboUrgencia(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect urgencia = document.getSelectById("urgencia");
		inicializarCombo(urgencia, request);
		urgencia.addOption("B", UtilI18N.internacionaliza(request, "citcorpore.comum.baixa"));
		urgencia.addOption("M", UtilI18N.internacionaliza(request, "citcorpore.comum.media"));
		urgencia.addOption("A", UtilI18N.internacionaliza(request, "citcorpore.comum.alta"));
	}

	private void carregarComboImpacto(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect impacto = document.getSelectById("impacto");
		inicializarCombo(impacto, request);
		impacto.addOption("B", UtilI18N.internacionaliza(request, "citcorpore.comum.baixa"));
		impacto.addOption("M", UtilI18N.internacionaliza(request, "citcorpore.comum.media"));
		impacto.addOption("A", UtilI18N.internacionaliza(request, "citcorpore.comum.alta"));
	}

	private void carregarComboTipoCatalogoServico(final DocumentHTML document, final HttpServletRequest request) throws ServiceException, Exception {
		final HTMLSelect idTipoCatalogoServico = document.getSelectById("idTipoCatalogoServico");
		inicializarCombo(idTipoCatalogoServico, request);

		for(TipoCatalogoServico tipoCatalogoServico : TipoCatalogoServico.values()) {
			idTipoCatalogoServico.addOption(tipoCatalogoServico.getIdentificador(), UtilI18N.internacionaliza(request, tipoCatalogoServico.getChave()));
		}
	}

	private void inicializarCombo(final HTMLSelect componenteCombo, final HttpServletRequest request) {
		componenteCombo.removeAllOptions();
		componenteCombo.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
	}

	private void carregarComboEnviarEmail(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect combo = document.getSelectById("enviarEmail");
		carregaOpcoesSimNao(combo, request);
		document.executeScript("$('#enviarEmail').trigger('change')");
	}

	private void carregarComboCriaProblema(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect combo = document.getSelectById("criaProblema");
		carregaOpcoesSimNao(combo, request);
		document.executeScript("$('#criaProblema').trigger('change')");
	}

	private void carregaOpcoesSimNao(HTMLSelect combo, HttpServletRequest request) {
		combo.removeAllOptions();

		combo.addOption(SimNao.NAO.getValorStr(), UtilI18N.internacionaliza(request, SimNao.NAO.getChave()));
		combo.addOption(SimNao.SIM.getValorStr(), UtilI18N.internacionaliza(request, SimNao.SIM.getChave()));
	}

	public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		RegraEscalonamentoDTO regraEscalonamentoDTO = (RegraEscalonamentoDTO) document.getBean();
		regraEscalonamentoDTO = (RegraEscalonamentoDTO) getRegraEscalonamentoService().restore(regraEscalonamentoDTO);

		if (regraEscalonamentoDTO!=null&&regraEscalonamentoDTO.getIdRegraEscalonamento()!=null){

			if(regraEscalonamentoDTO.getIdSolicitante() != null){
				EmpregadoDTO empregadoDTO = getEmpregadoService().restoreByIdEmpregado(regraEscalonamentoDTO.getIdSolicitante());
				regraEscalonamentoDTO.setNomeSolicitante(empregadoDTO==null||empregadoDTO.getNome()==null?"":empregadoDTO.getNome());
			}

			if(regraEscalonamentoDTO.getIdServico() != null){
				ServicoDTO servicoDTO = getServicoService().findById(regraEscalonamentoDTO.getIdServico());
				regraEscalonamentoDTO.setServicoBusca(servicoDTO == null || servicoDTO.getNomeServico() == null ? "" : servicoDTO.getNomeServico());
			}

			if (regraEscalonamentoDTO.getIdGrupo() != null) {
				GrupoDTO grupoDTO = getGrupoService().listGrupoById(regraEscalonamentoDTO.getIdGrupo());
				if (grupoDTO != null) {
					regraEscalonamentoDTO.setGrupo(UtilStrings.nullToVazio(grupoDTO.getDescricao()));
				} else {
					regraEscalonamentoDTO.setGrupo("");
				}
			}

		}

		HTMLForm form = document.getForm("form");
		form.clear();
		if(regraEscalonamentoDTO != null){
			atualizaTblGrupoExecutor(document, request, response, regraEscalonamentoDTO);
			definirFiltrosServico(document, regraEscalonamentoDTO);
			form.setValues(regraEscalonamentoDTO);
		}
	}

	public void definirFiltrosServico(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws PersistenceException, ServiceException, Exception {
		RegraEscalonamentoDTO regraEscalonamentoDTO = (RegraEscalonamentoDTO) document.getBean();
		definirFiltrosServico(document, regraEscalonamentoDTO);
	}

	private void definirFiltrosServico(final DocumentHTML document, RegraEscalonamentoDTO regraEscalonamentoDTO) throws PersistenceException, ServiceException, Exception {
		if (regraEscalonamentoDTO.getIdContrato() != null && regraEscalonamentoDTO.getIdServico() != null) {
			ServicoDTO servicoRelacionado = this.getServicoService().recuperaServicoRelacionado(regraEscalonamentoDTO.getIdContrato(), regraEscalonamentoDTO.getIdServico());

			HTMLElement servicoNegocioTecnicoBusca =  document.getElementById("servicoNegocioTecnicoBusca");
			servicoNegocioTecnicoBusca.setValue(UtilStrings.nullToVazio(servicoRelacionado.getNomeServico()));

			HTMLElement idServicoNegocioTecnicoBusca =  document.getElementById("idServicoNegocioTecnicoBusca");
			idServicoNegocioTecnicoBusca.setValue(UtilNumbersAndDecimals.nullToVazio(servicoRelacionado.getIdServico()));

			HTMLSelect idTipoCatalogoServicoSolicitacao = document.getSelectById("idTipoCatalogoServico");
			idTipoCatalogoServicoSolicitacao.setValue(UtilStrings.nullToVazio(servicoRelacionado.getTipoServico()));
		}
	}

	@SuppressWarnings("unchecked")
	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		RegraEscalonamentoDTO regraEscalonamentoDTO = (RegraEscalonamentoDTO) document.getBean();
		Collection<EscalonamentoDTO> grupos_serialize = br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(EscalonamentoDTO.class, "grupos_serialize", request);
		if (grupos_serialize != null) {
			regraEscalonamentoDTO.setColEscalonamentoDTOs(grupos_serialize);
		}
		if (regraEscalonamentoDTO != null) {
			if (regraEscalonamentoDTO.getIdRegraEscalonamento() == null) {
				getRegraEscalonamentoService().create(regraEscalonamentoDTO);
				document.executeScript("mensagemCreate()");
			} else {
				getRegraEscalonamentoService().update(regraEscalonamentoDTO);
				document.executeScript("mensagemUpdate()");
			}
			HTMLForm form = document.getForm("form");
			form.clear();
			document.setBean(new RegraEscalonamentoDTO());
			HTMLTable tblGrupoExecutor = document.getTableById("tblGrupoExecutor");
			tblGrupoExecutor.deleteAllRows();
			load(document, request, response);
		}
	}

	public void excluir(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		RegraEscalonamentoDTO regraEscalonamentoDTO = (RegraEscalonamentoDTO) document.getBean();

		if (regraEscalonamentoDTO.getIdRegraEscalonamento() != null) {
			getRegraEscalonamentoService().delete(regraEscalonamentoDTO);
			document.alert(UtilI18N.internacionaliza(request, "regraEscalonamento.excluida"));
		}

		HTMLForm form = document.getForm("form");
		form.clear();
		document.setBean(new RegraEscalonamentoDTO());
		HTMLTable tblGrupoExecutor = document.getTableById("tblGrupoExecutor");
		tblGrupoExecutor.deleteAllRows();
	}

	private boolean isContratoInList(Integer idContrato, Collection<ContratosGruposDTO> colContratosColab) {
		if (colContratosColab != null) {
			for (Iterator<ContratosGruposDTO> it = colContratosColab.iterator(); it.hasNext();) {
				ContratosGruposDTO contratosGruposDTO = it.next();
				if (contratosGruposDTO.getIdContrato().intValue() == idContrato.intValue()) {
					return true;
				}
			}
		}
		return false;
	}

	private void carregarComboContrato(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws ServiceException, Exception{
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		RegraEscalonamentoDTO regraEscalonamentoDTO = (RegraEscalonamentoDTO) document.getBean();

		Collection<ContratoDTO> colContratos = getContratoService().list();
		ContratoDTO contratoDtoAux = new ContratoDTO();

		UsuarioDTO usuario = WebUtil.getUsuario(request);

		String COLABORADORES_VINC_CONTRATOS = ParametroUtil.getValorParametroCitSmartHashMap(br.com.centralit.citcorpore.util.Enumerados.ParametroSistema.COLABORADORES_VINC_CONTRATOS, "N");
		if (COLABORADORES_VINC_CONTRATOS == null) {
			COLABORADORES_VINC_CONTRATOS = "N";
		}

		Collection<ContratosGruposDTO> colContratosColab = null;
		if (COLABORADORES_VINC_CONTRATOS.equalsIgnoreCase("S")) {
			colContratosColab = getContratosGruposService().findByIdEmpregado(usuario.getIdEmpregado());
		}

		Collection<ContratoDTO> listaContratos = new ArrayList<ContratoDTO>();
		document.getSelectById("idContrato").removeAllOptions();
		if (colContratos != null) {
			if (colContratos.size() > 1) {
				document.getSelectById("idContrato").addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
			}

			for (Iterator<ContratoDTO> it = colContratos.iterator(); it.hasNext();) {
				ContratoDTO contratoDto = it.next();
				if (contratoDto.getDeleted() == null || !contratoDto.getDeleted().equalsIgnoreCase("y")) {
					if (COLABORADORES_VINC_CONTRATOS.equalsIgnoreCase("S")) { // Se parametro de colaboradores por contrato ativo, entao filtra.
						if (colContratosColab == null) {
							continue;
						}
						if (!isContratoInList(contratoDto.getIdContrato(), colContratosColab)) {
							continue;
						}
					}

					if (regraEscalonamentoDTO != null && regraEscalonamentoDTO.getIdRegraEscalonamento() != null) {
						this.restore(document, request, response);
					}

					String nomeCliente = "";
					String nomeForn = "";

					ClienteDTO clienteDto = new ClienteDTO();
					clienteDto.setIdCliente(contratoDto.getIdCliente());
					clienteDto = (ClienteDTO) getClienteService().restore(clienteDto);
					if (clienteDto != null) {
						nomeCliente = clienteDto.getNomeRazaoSocial();
					}

					FornecedorDTO fornecedorDto = new FornecedorDTO();
					fornecedorDto.setIdFornecedor(contratoDto.getIdFornecedor());
					fornecedorDto = (FornecedorDTO) getFornecedorService().restore(fornecedorDto);
					if (fornecedorDto != null) {
						nomeForn = fornecedorDto.getRazaoSocial();
					}

					contratoDtoAux.setIdContrato(contratoDto.getIdContrato());
					if (contratoDto.getSituacao().equalsIgnoreCase("A")) {
						String nomeContrato = "" + contratoDto.getNumero() + " de " + UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, contratoDto.getDataContrato(), WebUtil.getLanguage(request)) + " (" + nomeCliente + " - " + nomeForn + ")";
						document.getSelectById("idContrato").addOption("" + contratoDto.getIdContrato(), nomeContrato);
						contratoDto.setNome(nomeContrato);
						listaContratos.add(contratoDto);
					}
				}
			}
		}
	}

	public void atualizaTblGrupoExecutor(DocumentHTML document, HttpServletRequest request, HttpServletResponse response,RegraEscalonamentoDTO regraEscalonamentoDTO) throws Exception{
		HTMLTable tblGrupoExecutor = document.getTableById("tblGrupoExecutor");
		tblGrupoExecutor.deleteAllRows();

		Collection<EscalonamentoDTO> colEscalonamentoDTOs = getEscalonamentoService().findByRegraEscalonamento(regraEscalonamentoDTO);
		regraEscalonamentoDTO.setColEscalonamentoDTOs(colEscalonamentoDTOs);

		if (tblGrupoExecutor != null&&colEscalonamentoDTOs != null) {
			tblGrupoExecutor.addRowsByCollection(colEscalonamentoDTOs, new String[] { "", "descricao", "prazoExecucao", "escalonarPor", "descrPrioridade" }, null, "",
					new String[] { "gerarImgDelGrupoExecutor", "internacionalizaEscalonarPor" }, null, null);
		}

		document.executeScript("HTMLUtils.applyStyleClassInAllCells('tblGrupoExecutor', 'tblGrupoExecutor');");
	}

	public void listarServicosNegocioTecnico(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final RegraEscalonamentoDTO regra = (RegraEscalonamentoDTO) document.getBean();

		final HTMLTable tblListaServicos = document.getTableById("tblListaServicosNegocioTecnico");
		tblListaServicos.deleteAllRows();

		final Collection<ServicoDTO> colServicos = this.getServicoService().findAutocompleteServicoNegocioTecnico(regra.getIdContrato(), regra.getTipoServico(), "");
		if (colServicos != null && !colServicos.isEmpty()) {
			tblListaServicos.addRowsByCollection(colServicos, new String[] { "idServico", "nomeServico" }, null, null, null, "selecionarServicoNegocioTecnico", null);
			document.executeScript("$('#modal_listarServicosNegocioTecnico').modal('show')");
		} else {
			document.executeScript("notificacaoI18N('MSG04')");
		}

		document.executeScript("depoisListarServicos();");
	}

	public void listarServicos(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final RegraEscalonamentoDTO regra = (RegraEscalonamentoDTO) document.getBean();

		final HTMLTable tblListaServicos = document.getTableById("tblListaServicos");
		tblListaServicos.deleteAllRows();

		final Collection<ServicoDTO> colServicos = this.getServicoService().findAutocompleteServico(
				null, regra.getIdContrato(),
				null, "", regra.getIdServicoNegocioTecnico());
		if (colServicos != null && !colServicos.isEmpty()) {
			tblListaServicos.addRowsByCollection(colServicos, new String[] { "idServico", "nomeServico" }, null, null, null, "selecionarServico", null);
			document.executeScript("$('#modal_listarServicos').modal('show')");
		} else {
			document.executeScript("notificacaoI18N('MSG04')");
		}

		document.executeScript("depoisListarServicos();");
	}

	private RegraEscalonamentoService getRegraEscalonamentoService() throws ServiceException {
		if (regraEscalonamentoService == null) {
			regraEscalonamentoService = (RegraEscalonamentoService) ServiceLocator.getInstance().getService(RegraEscalonamentoService.class, null);
		}

		return regraEscalonamentoService;
	}

	private EscalonamentoService getEscalonamentoService() throws ServiceException {
		if (escalonamentoService == null) {
			escalonamentoService = (EscalonamentoService) ServiceLocator.getInstance().getService(EscalonamentoService.class, null);
		}

		return escalonamentoService;
	}

	private ContratosGruposService getContratosGruposService() throws ServiceException {
		if (contratosGruposService == null) {
			contratosGruposService = (ContratosGruposService) ServiceLocator.getInstance().getService(ContratosGruposService.class, null);
		}

		return contratosGruposService;
	}

	private ContratoService getContratoService() throws ServiceException {
		if (contratoService == null) {
			contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
		}

		return contratoService;
	}

	private ClienteService getClienteService() throws ServiceException {
		if (clienteService == null) {
			clienteService = (ClienteService) ServiceLocator.getInstance().getService(ClienteService.class, null);
		}

		return clienteService;
	}

	private FornecedorService getFornecedorService() throws ServiceException {
		if (fornecedorService == null) {
			fornecedorService = (FornecedorService) ServiceLocator.getInstance().getService(FornecedorService.class, null);
		}

		return fornecedorService;
	}

	private GrupoService getGrupoService() throws ServiceException {
		if (grupoService == null) {
			grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
		}

		return grupoService;
	}

	private EmpregadoService getEmpregadoService() throws ServiceException {
		if (empregadoService == null) {
			empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, null);
		}

		return empregadoService;
	}

	private ServicoService getServicoService() throws ServiceException {
		if (servicoService == null) {
			servicoService = (ServicoService) ServiceLocator.getInstance().getService(ServicoService.class, null);
		}

		return servicoService;
	}
 }